# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRepositoryLinkResult',
    'AwaitableGetRepositoryLinkResult',
    'get_repository_link',
    'get_repository_link_output',
]

@pulumi.output_type
class GetRepositoryLinkResult:
    def __init__(__self__, connection_arn=None, encryption_key_arn=None, provider_type=None, repository_link_arn=None, repository_link_id=None, tags=None):
        if connection_arn and not isinstance(connection_arn, str):
            raise TypeError("Expected argument 'connection_arn' to be a str")
        pulumi.set(__self__, "connection_arn", connection_arn)
        if encryption_key_arn and not isinstance(encryption_key_arn, str):
            raise TypeError("Expected argument 'encryption_key_arn' to be a str")
        pulumi.set(__self__, "encryption_key_arn", encryption_key_arn)
        if provider_type and not isinstance(provider_type, str):
            raise TypeError("Expected argument 'provider_type' to be a str")
        pulumi.set(__self__, "provider_type", provider_type)
        if repository_link_arn and not isinstance(repository_link_arn, str):
            raise TypeError("Expected argument 'repository_link_arn' to be a str")
        pulumi.set(__self__, "repository_link_arn", repository_link_arn)
        if repository_link_id and not isinstance(repository_link_id, str):
            raise TypeError("Expected argument 'repository_link_id' to be a str")
        pulumi.set(__self__, "repository_link_id", repository_link_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectionArn")
    def connection_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the CodeStarConnection. The ARN is used as the connection reference when the connection is shared between AWS services.
        """
        return pulumi.get(self, "connection_arn")

    @property
    @pulumi.getter(name="encryptionKeyArn")
    def encryption_key_arn(self) -> Optional[str]:
        """
        The ARN of the KMS key that the customer can optionally specify to use to encrypt RepositoryLink properties. If not specified, a default key will be used.
        """
        return pulumi.get(self, "encryption_key_arn")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional['RepositoryLinkProviderType']:
        """
        The name of the external provider where your third-party code repository is configured.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="repositoryLinkArn")
    def repository_link_arn(self) -> Optional[str]:
        """
        A unique Amazon Resource Name (ARN) to designate the repository link.
        """
        return pulumi.get(self, "repository_link_arn")

    @property
    @pulumi.getter(name="repositoryLinkId")
    def repository_link_id(self) -> Optional[str]:
        """
        A UUID that uniquely identifies the RepositoryLink.
        """
        return pulumi.get(self, "repository_link_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Specifies the tags applied to a RepositoryLink.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRepositoryLinkResult(GetRepositoryLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryLinkResult(
            connection_arn=self.connection_arn,
            encryption_key_arn=self.encryption_key_arn,
            provider_type=self.provider_type,
            repository_link_arn=self.repository_link_arn,
            repository_link_id=self.repository_link_id,
            tags=self.tags)


def get_repository_link(repository_link_arn: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryLinkResult:
    """
    Schema for AWS::CodeStarConnections::RepositoryLink resource which is used to aggregate repository metadata relevant to synchronizing source provider content to AWS Resources.


    :param str repository_link_arn: A unique Amazon Resource Name (ARN) to designate the repository link.
    """
    __args__ = dict()
    __args__['repositoryLinkArn'] = repository_link_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codestarconnections:getRepositoryLink', __args__, opts=opts, typ=GetRepositoryLinkResult).value

    return AwaitableGetRepositoryLinkResult(
        connection_arn=pulumi.get(__ret__, 'connection_arn'),
        encryption_key_arn=pulumi.get(__ret__, 'encryption_key_arn'),
        provider_type=pulumi.get(__ret__, 'provider_type'),
        repository_link_arn=pulumi.get(__ret__, 'repository_link_arn'),
        repository_link_id=pulumi.get(__ret__, 'repository_link_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_repository_link_output(repository_link_arn: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryLinkResult]:
    """
    Schema for AWS::CodeStarConnections::RepositoryLink resource which is used to aggregate repository metadata relevant to synchronizing source provider content to AWS Resources.


    :param str repository_link_arn: A unique Amazon Resource Name (ARN) to designate the repository link.
    """
    __args__ = dict()
    __args__['repositoryLinkArn'] = repository_link_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:codestarconnections:getRepositoryLink', __args__, opts=opts, typ=GetRepositoryLinkResult)
    return __ret__.apply(lambda __response__: GetRepositoryLinkResult(
        connection_arn=pulumi.get(__response__, 'connection_arn'),
        encryption_key_arn=pulumi.get(__response__, 'encryption_key_arn'),
        provider_type=pulumi.get(__response__, 'provider_type'),
        repository_link_arn=pulumi.get(__response__, 'repository_link_arn'),
        repository_link_id=pulumi.get(__response__, 'repository_link_id'),
        tags=pulumi.get(__response__, 'tags')))
