# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 stages: pulumi.Input[Sequence[pulumi.Input['PipelineStageDeclarationArgs']]],
                 artifact_store: Optional[pulumi.Input['PipelineArtifactStoreArgs']] = None,
                 artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreMapArgs']]]] = None,
                 disable_inbound_stage_transitions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStageTransitionArgs']]]] = None,
                 execution_mode: Optional[pulumi.Input['PipelineExecutionMode']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_type: Optional[pulumi.Input['PipelineType']] = None,
                 restart_execution_on_update: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerDeclarationArgs']]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableDeclarationArgs']]]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no actionRoleArn, or to use to assume roles for actions with an actionRoleArn
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStageDeclarationArgs']]] stages: Represents information about a stage and its definition.
        :param pulumi.Input['PipelineArtifactStoreArgs'] artifact_store: The S3 bucket where artifacts for the pipeline are stored.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreMapArgs']]] artifact_stores: A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStageTransitionArgs']]] disable_inbound_stage_transitions: Represents the input of a DisableStageTransition action.
        :param pulumi.Input['PipelineExecutionMode'] execution_mode: The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
        :param pulumi.Input[str] name: The name of the pipeline.
        :param pulumi.Input['PipelineType'] pipeline_type: CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
        :param pulumi.Input[bool] restart_execution_on_update: Indicates whether to rerun the CodePipeline pipeline after you update it.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Specifies the tags applied to the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTriggerDeclarationArgs']]] triggers: The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineVariableDeclarationArgs']]] variables: A list that defines the pipeline variables for a pipeline resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9@\\-_]+.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stages", stages)
        if artifact_store is not None:
            pulumi.set(__self__, "artifact_store", artifact_store)
        if artifact_stores is not None:
            pulumi.set(__self__, "artifact_stores", artifact_stores)
        if disable_inbound_stage_transitions is not None:
            pulumi.set(__self__, "disable_inbound_stage_transitions", disable_inbound_stage_transitions)
        if execution_mode is not None:
            pulumi.set(__self__, "execution_mode", execution_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_type is not None:
            pulumi.set(__self__, "pipeline_type", pipeline_type)
        if restart_execution_on_update is not None:
            pulumi.set(__self__, "restart_execution_on_update", restart_execution_on_update)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no actionRoleArn, or to use to assume roles for actions with an actionRoleArn
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineStageDeclarationArgs']]]:
        """
        Represents information about a stage and its definition.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineStageDeclarationArgs']]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter(name="artifactStore")
    def artifact_store(self) -> Optional[pulumi.Input['PipelineArtifactStoreArgs']]:
        """
        The S3 bucket where artifacts for the pipeline are stored.
        """
        return pulumi.get(self, "artifact_store")

    @artifact_store.setter
    def artifact_store(self, value: Optional[pulumi.Input['PipelineArtifactStoreArgs']]):
        pulumi.set(self, "artifact_store", value)

    @property
    @pulumi.getter(name="artifactStores")
    def artifact_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreMapArgs']]]]:
        """
        A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        """
        return pulumi.get(self, "artifact_stores")

    @artifact_stores.setter
    def artifact_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreMapArgs']]]]):
        pulumi.set(self, "artifact_stores", value)

    @property
    @pulumi.getter(name="disableInboundStageTransitions")
    def disable_inbound_stage_transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStageTransitionArgs']]]]:
        """
        Represents the input of a DisableStageTransition action.
        """
        return pulumi.get(self, "disable_inbound_stage_transitions")

    @disable_inbound_stage_transitions.setter
    def disable_inbound_stage_transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStageTransitionArgs']]]]):
        pulumi.set(self, "disable_inbound_stage_transitions", value)

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> Optional[pulumi.Input['PipelineExecutionMode']]:
        """
        The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
        """
        return pulumi.get(self, "execution_mode")

    @execution_mode.setter
    def execution_mode(self, value: Optional[pulumi.Input['PipelineExecutionMode']]):
        pulumi.set(self, "execution_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineType")
    def pipeline_type(self) -> Optional[pulumi.Input['PipelineType']]:
        """
        CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
        """
        return pulumi.get(self, "pipeline_type")

    @pipeline_type.setter
    def pipeline_type(self, value: Optional[pulumi.Input['PipelineType']]):
        pulumi.set(self, "pipeline_type", value)

    @property
    @pulumi.getter(name="restartExecutionOnUpdate")
    def restart_execution_on_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to rerun the CodePipeline pipeline after you update it.
        """
        return pulumi.get(self, "restart_execution_on_update")

    @restart_execution_on_update.setter
    def restart_execution_on_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_execution_on_update", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Specifies the tags applied to the pipeline.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerDeclarationArgs']]]]:
        """
        The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerDeclarationArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableDeclarationArgs']]]]:
        """
        A list that defines the pipeline variables for a pipeline resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9@\\-_]+.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableDeclarationArgs']]]]):
        pulumi.set(self, "variables", value)


class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_store: Optional[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]] = None,
                 artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreMapArgs', 'PipelineArtifactStoreMapArgsDict']]]]] = None,
                 disable_inbound_stage_transitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageTransitionArgs', 'PipelineStageTransitionArgsDict']]]]] = None,
                 execution_mode: Optional[pulumi.Input['PipelineExecutionMode']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_type: Optional[pulumi.Input['PipelineType']] = None,
                 restart_execution_on_update: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageDeclarationArgs', 'PipelineStageDeclarationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerDeclarationArgs', 'PipelineTriggerDeclarationArgsDict']]]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableDeclarationArgs', 'PipelineVariableDeclarationArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::CodePipeline::Pipeline resource creates a CodePipeline pipeline that describes how software changes go through a release process.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']] artifact_store: The S3 bucket where artifacts for the pipeline are stored.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreMapArgs', 'PipelineArtifactStoreMapArgsDict']]]] artifact_stores: A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageTransitionArgs', 'PipelineStageTransitionArgsDict']]]] disable_inbound_stage_transitions: Represents the input of a DisableStageTransition action.
        :param pulumi.Input['PipelineExecutionMode'] execution_mode: The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
        :param pulumi.Input[str] name: The name of the pipeline.
        :param pulumi.Input['PipelineType'] pipeline_type: CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
        :param pulumi.Input[bool] restart_execution_on_update: Indicates whether to rerun the CodePipeline pipeline after you update it.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no actionRoleArn, or to use to assume roles for actions with an actionRoleArn
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageDeclarationArgs', 'PipelineStageDeclarationArgsDict']]]] stages: Represents information about a stage and its definition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Specifies the tags applied to the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerDeclarationArgs', 'PipelineTriggerDeclarationArgsDict']]]] triggers: The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableDeclarationArgs', 'PipelineVariableDeclarationArgsDict']]]] variables: A list that defines the pipeline variables for a pipeline resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9@\\-_]+.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::CodePipeline::Pipeline resource creates a CodePipeline pipeline that describes how software changes go through a release process.

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_store: Optional[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]] = None,
                 artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreMapArgs', 'PipelineArtifactStoreMapArgsDict']]]]] = None,
                 disable_inbound_stage_transitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageTransitionArgs', 'PipelineStageTransitionArgsDict']]]]] = None,
                 execution_mode: Optional[pulumi.Input['PipelineExecutionMode']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_type: Optional[pulumi.Input['PipelineType']] = None,
                 restart_execution_on_update: Optional[pulumi.Input[bool]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageDeclarationArgs', 'PipelineStageDeclarationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerDeclarationArgs', 'PipelineTriggerDeclarationArgsDict']]]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableDeclarationArgs', 'PipelineVariableDeclarationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["artifact_store"] = artifact_store
            __props__.__dict__["artifact_stores"] = artifact_stores
            __props__.__dict__["disable_inbound_stage_transitions"] = disable_inbound_stage_transitions
            __props__.__dict__["execution_mode"] = execution_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["pipeline_type"] = pipeline_type
            __props__.__dict__["restart_execution_on_update"] = restart_execution_on_update
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if stages is None and not opts.urn:
                raise TypeError("Missing required property 'stages'")
            __props__.__dict__["stages"] = stages
            __props__.__dict__["tags"] = tags
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["variables"] = variables
            __props__.__dict__["version"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Pipeline, __self__).__init__(
            'aws-native:codepipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PipelineArgs.__new__(PipelineArgs)

        __props__.__dict__["artifact_store"] = None
        __props__.__dict__["artifact_stores"] = None
        __props__.__dict__["disable_inbound_stage_transitions"] = None
        __props__.__dict__["execution_mode"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["pipeline_type"] = None
        __props__.__dict__["restart_execution_on_update"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["stages"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["triggers"] = None
        __props__.__dict__["variables"] = None
        __props__.__dict__["version"] = None
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactStore")
    def artifact_store(self) -> pulumi.Output[Optional['outputs.PipelineArtifactStore']]:
        """
        The S3 bucket where artifacts for the pipeline are stored.
        """
        return pulumi.get(self, "artifact_store")

    @property
    @pulumi.getter(name="artifactStores")
    def artifact_stores(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineArtifactStoreMap']]]:
        """
        A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        """
        return pulumi.get(self, "artifact_stores")

    @property
    @pulumi.getter(name="disableInboundStageTransitions")
    def disable_inbound_stage_transitions(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineStageTransition']]]:
        """
        Represents the input of a DisableStageTransition action.
        """
        return pulumi.get(self, "disable_inbound_stage_transitions")

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> pulumi.Output[Optional['PipelineExecutionMode']]:
        """
        The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
        """
        return pulumi.get(self, "execution_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelineType")
    def pipeline_type(self) -> pulumi.Output[Optional['PipelineType']]:
        """
        CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
        """
        return pulumi.get(self, "pipeline_type")

    @property
    @pulumi.getter(name="restartExecutionOnUpdate")
    def restart_execution_on_update(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to rerun the CodePipeline pipeline after you update it.
        """
        return pulumi.get(self, "restart_execution_on_update")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no actionRoleArn, or to use to assume roles for actions with an actionRoleArn
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Sequence['outputs.PipelineStageDeclaration']]:
        """
        Represents information about a stage and its definition.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Specifies the tags applied to the pipeline.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineTriggerDeclaration']]]:
        """
        The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineVariableDeclaration']]]:
        """
        A list that defines the pipeline variables for a pipeline resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9@\\-_]+.
        """
        return pulumi.get(self, "variables")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the pipeline.
        """
        return pulumi.get(self, "version")

