# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CustomActionTypeArtifactDetails',
    'CustomActionTypeConfigurationProperties',
    'CustomActionTypeSettings',
    'PipelineActionDeclaration',
    'PipelineActionTypeId',
    'PipelineArtifactStore',
    'PipelineArtifactStoreMap',
    'PipelineBeforeEntryConditions',
    'PipelineBlockerDeclaration',
    'PipelineCondition',
    'PipelineEncryptionKey',
    'PipelineFailureConditions',
    'PipelineGitBranchFilterCriteria',
    'PipelineGitConfiguration',
    'PipelineGitFilePathFilterCriteria',
    'PipelineGitPullRequestFilter',
    'PipelineGitPushFilter',
    'PipelineGitTagFilterCriteria',
    'PipelineInputArtifact',
    'PipelineOutputArtifact',
    'PipelineRuleDeclaration',
    'PipelineRuleTypeId',
    'PipelineStageDeclaration',
    'PipelineStageTransition',
    'PipelineSuccessConditions',
    'PipelineTriggerDeclaration',
    'PipelineVariableDeclaration',
]

@pulumi.output_type
class CustomActionTypeArtifactDetails(dict):
    """
    Returns information about the details of an artifact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCount":
            suggest = "maximum_count"
        elif key == "minimumCount":
            suggest = "minimum_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeArtifactDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeArtifactDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeArtifactDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_count: int,
                 minimum_count: int):
        """
        Returns information about the details of an artifact.
        :param int maximum_count: The maximum number of artifacts allowed for the action type.
        :param int minimum_count: The minimum number of artifacts allowed for the action type.
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> int:
        """
        The maximum number of artifacts allowed for the action type.
        """
        return pulumi.get(self, "maximum_count")

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> int:
        """
        The minimum number of artifacts allowed for the action type.
        """
        return pulumi.get(self, "minimum_count")


@pulumi.output_type
class CustomActionTypeConfigurationProperties(dict):
    """
    The configuration properties for the custom action.
    """
    def __init__(__self__, *,
                 key: bool,
                 name: str,
                 required: bool,
                 secret: bool,
                 description: Optional[str] = None,
                 queryable: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        The configuration properties for the custom action.
        :param bool key: Whether the configuration property is a key.
        :param str name: The name of the action configuration property.
        :param bool required: Whether the configuration property is a required value.
        :param bool secret: Whether the configuration property is secret. Secrets are hidden from all calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and PollForThirdPartyJobs.
        :param str description: The description of the action configuration property that is displayed to users. 
        :param bool queryable: Indicates that the property is used with PollForJobs. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens. 
        :param str type: The type of the configuration property.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "secret", secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if queryable is not None:
            pulumi.set(__self__, "queryable", queryable)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> bool:
        """
        Whether the configuration property is a key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action configuration property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Whether the configuration property is a required value.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def secret(self) -> bool:
        """
        Whether the configuration property is secret. Secrets are hidden from all calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and PollForThirdPartyJobs.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the action configuration property that is displayed to users. 
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def queryable(self) -> Optional[bool]:
        """
        Indicates that the property is used with PollForJobs. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens. 
        """
        return pulumi.get(self, "queryable")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the configuration property.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomActionTypeSettings(dict):
    """
    Settings is a property of the AWS::CodePipeline::CustomActionType resource that provides URLs that users can access to view information about the CodePipeline custom action. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityUrlTemplate":
            suggest = "entity_url_template"
        elif key == "executionUrlTemplate":
            suggest = "execution_url_template"
        elif key == "revisionUrlTemplate":
            suggest = "revision_url_template"
        elif key == "thirdPartyConfigurationUrl":
            suggest = "third_party_configuration_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_url_template: Optional[str] = None,
                 execution_url_template: Optional[str] = None,
                 revision_url_template: Optional[str] = None,
                 third_party_configuration_url: Optional[str] = None):
        """
        Settings is a property of the AWS::CodePipeline::CustomActionType resource that provides URLs that users can access to view information about the CodePipeline custom action. 
        :param str entity_url_template: The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline. 
        :param str execution_url_template: The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action. 
        :param str revision_url_template: The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action. 
        :param str third_party_configuration_url: The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        if entity_url_template is not None:
            pulumi.set(__self__, "entity_url_template", entity_url_template)
        if execution_url_template is not None:
            pulumi.set(__self__, "execution_url_template", execution_url_template)
        if revision_url_template is not None:
            pulumi.set(__self__, "revision_url_template", revision_url_template)
        if third_party_configuration_url is not None:
            pulumi.set(__self__, "third_party_configuration_url", third_party_configuration_url)

    @property
    @pulumi.getter(name="entityUrlTemplate")
    def entity_url_template(self) -> Optional[str]:
        """
        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline. 
        """
        return pulumi.get(self, "entity_url_template")

    @property
    @pulumi.getter(name="executionUrlTemplate")
    def execution_url_template(self) -> Optional[str]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action. 
        """
        return pulumi.get(self, "execution_url_template")

    @property
    @pulumi.getter(name="revisionUrlTemplate")
    def revision_url_template(self) -> Optional[str]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action. 
        """
        return pulumi.get(self, "revision_url_template")

    @property
    @pulumi.getter(name="thirdPartyConfigurationUrl")
    def third_party_configuration_url(self) -> Optional[str]:
        """
        The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        return pulumi.get(self, "third_party_configuration_url")


@pulumi.output_type
class PipelineActionDeclaration(dict):
    """
    Represents information about an action declaration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionTypeId":
            suggest = "action_type_id"
        elif key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "outputArtifacts":
            suggest = "output_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "runOrder":
            suggest = "run_order"
        elif key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineActionDeclaration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineActionDeclaration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineActionDeclaration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type_id: 'outputs.PipelineActionTypeId',
                 name: str,
                 configuration: Optional[Any] = None,
                 input_artifacts: Optional[Sequence['outputs.PipelineInputArtifact']] = None,
                 namespace: Optional[str] = None,
                 output_artifacts: Optional[Sequence['outputs.PipelineOutputArtifact']] = None,
                 region: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 run_order: Optional[int] = None,
                 timeout_in_minutes: Optional[int] = None):
        """
        Represents information about an action declaration.
        :param 'PipelineActionTypeId' action_type_id: Specifies the action type and the provider of the action.
        :param str name: The action declaration's name.
        :param Any configuration: The action's configuration. These are key-value pairs that specify input values for an action.
        :param Sequence['PipelineInputArtifact'] input_artifacts: The name or ID of the artifact consumed by the action, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
               
               > For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the [CodeBuild action reference page](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html) in the *AWS CodePipeline User Guide* .
        :param str namespace: The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
        :param Sequence['PipelineOutputArtifact'] output_artifacts: The name or ID of the result of the action declaration, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
        :param str region: The action declaration's AWS Region, such as us-east-1.
        :param str role_arn: The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
        :param int run_order: The order in which actions are run.
        :param int timeout_in_minutes: A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline. This attribute is available only to the manual approval ActionType.
        """
        pulumi.set(__self__, "action_type_id", action_type_id)
        pulumi.set(__self__, "name", name)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if output_artifacts is not None:
            pulumi.set(__self__, "output_artifacts", output_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_order is not None:
            pulumi.set(__self__, "run_order", run_order)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter(name="actionTypeId")
    def action_type_id(self) -> 'outputs.PipelineActionTypeId':
        """
        Specifies the action type and the provider of the action.
        """
        return pulumi.get(self, "action_type_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The action declaration's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        The action's configuration. These are key-value pairs that specify input values for an action.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence['outputs.PipelineInputArtifact']]:
        """
        The name or ID of the artifact consumed by the action, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .

        > For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the [CodeBuild action reference page](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html) in the *AWS CodePipeline User Guide* .
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputArtifacts")
    def output_artifacts(self) -> Optional[Sequence['outputs.PipelineOutputArtifact']]:
        """
        The name or ID of the result of the action declaration, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
        """
        return pulumi.get(self, "output_artifacts")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The action declaration's AWS Region, such as us-east-1.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="runOrder")
    def run_order(self) -> Optional[int]:
        """
        The order in which actions are run.
        """
        return pulumi.get(self, "run_order")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[int]:
        """
        A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline. This attribute is available only to the manual approval ActionType.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class PipelineActionTypeId(dict):
    """
    Represents information about an action type.
    """
    def __init__(__self__, *,
                 category: 'PipelineActionTypeIdCategory',
                 owner: str,
                 provider: str,
                 version: str):
        """
        Represents information about an action type.
        :param 'PipelineActionTypeIdCategory' category: A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the values below.
        :param str owner: The creator of the action being called. There are three valid values for the Owner field in the action category section within your pipeline structure: AWS, ThirdParty, and Custom.
        :param str provider: The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as CodeDeploy.
        :param str version: A string that describes the action version.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> 'PipelineActionTypeIdCategory':
        """
        A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the values below.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The creator of the action being called. There are three valid values for the Owner field in the action category section within your pipeline structure: AWS, ThirdParty, and Custom.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as CodeDeploy.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        A string that describes the action version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PipelineArtifactStore(dict):
    """
    The S3 bucket where artifacts for the pipeline are stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineArtifactStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineArtifactStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineArtifactStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 type: 'PipelineArtifactStoreType',
                 encryption_key: Optional['outputs.PipelineEncryptionKey'] = None):
        """
        The S3 bucket where artifacts for the pipeline are stored.
        :param str location: The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
        :param 'PipelineArtifactStoreType' type: The type of the artifact store, such as S3.
        :param 'PipelineEncryptionKey' encryption_key: The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key. If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: [AWS::CodePipeline::Pipeline](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html) .
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def type(self) -> 'PipelineArtifactStoreType':
        """
        The type of the artifact store, such as S3.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional['outputs.PipelineEncryptionKey']:
        """
        The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key. If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: [AWS::CodePipeline::Pipeline](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html) .
        """
        return pulumi.get(self, "encryption_key")


@pulumi.output_type
class PipelineArtifactStoreMap(dict):
    """
    A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactStore":
            suggest = "artifact_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineArtifactStoreMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineArtifactStoreMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineArtifactStoreMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_store: 'outputs.PipelineArtifactStore',
                 region: str):
        """
        A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        :param 'PipelineArtifactStore' artifact_store: Represents information about the S3 bucket where artifacts are stored for the pipeline.
               
               > You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores` .
        :param str region: The action declaration's AWS Region, such as us-east-1.
        """
        pulumi.set(__self__, "artifact_store", artifact_store)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="artifactStore")
    def artifact_store(self) -> 'outputs.PipelineArtifactStore':
        """
        Represents information about the S3 bucket where artifacts are stored for the pipeline.

        > You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores` .
        """
        return pulumi.get(self, "artifact_store")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The action declaration's AWS Region, such as us-east-1.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class PipelineBeforeEntryConditions(dict):
    """
    The configuration that specifies the rules to run before stage starts.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.PipelineCondition']] = None):
        """
        The configuration that specifies the rules to run before stage starts.
        :param Sequence['PipelineCondition'] conditions: The conditions that are configured as entry conditions.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PipelineCondition']]:
        """
        The conditions that are configured as entry conditions.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class PipelineBlockerDeclaration(dict):
    """
    Reserved for future use.
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'PipelineBlockerDeclarationType'):
        """
        Reserved for future use.
        :param str name: Reserved for future use.
        :param 'PipelineBlockerDeclarationType' type: Reserved for future use.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'PipelineBlockerDeclarationType':
        """
        Reserved for future use.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipelineCondition(dict):
    """
    Represents information about condition.
    """
    def __init__(__self__, *,
                 result: Optional[str] = None,
                 rules: Optional[Sequence['outputs.PipelineRuleDeclaration']] = None):
        """
        Represents information about condition.
        :param str result: The specified result for when the failure conditions are met, such as rolling back the stage
        :param Sequence['PipelineRuleDeclaration'] rules: The rules that make up the condition.
        """
        if result is not None:
            pulumi.set(__self__, "result", result)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def result(self) -> Optional[str]:
        """
        The specified result for when the failure conditions are met, such as rolling back the stage
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.PipelineRuleDeclaration']]:
        """
        The rules that make up the condition.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class PipelineEncryptionKey(dict):
    """
    Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key
    """
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key
        :param str id: The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
        :param str type: The type of encryption key, such as an AWS KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of encryption key, such as an AWS KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipelineFailureConditions(dict):
    """
    The configuration that specifies the result, such as rollback, to occur upon stage failure
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.PipelineCondition']] = None,
                 result: Optional['PipelineFailureConditionsResult'] = None):
        """
        The configuration that specifies the result, such as rollback, to occur upon stage failure
        :param Sequence['PipelineCondition'] conditions: The conditions that are configured as failure conditions.
        :param 'PipelineFailureConditionsResult' result: The specified result for when the failure conditions are met, such as rolling back the stage
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if result is not None:
            pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PipelineCondition']]:
        """
        The conditions that are configured as failure conditions.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def result(self) -> Optional['PipelineFailureConditionsResult']:
        """
        The specified result for when the failure conditions are met, such as rolling back the stage
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class PipelineGitBranchFilterCriteria(dict):
    """
    The Git repository branches specified as filter criteria to start the pipeline.
    """
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        The Git repository branches specified as filter criteria to start the pipeline.
        :param Sequence[str] excludes: The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineGitConfiguration(dict):
    """
    A type of trigger configuration for Git-based source actions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceActionName":
            suggest = "source_action_name"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineGitConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineGitConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineGitConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_action_name: str,
                 pull_request: Optional[Sequence['outputs.PipelineGitPullRequestFilter']] = None,
                 push: Optional[Sequence['outputs.PipelineGitPushFilter']] = None):
        """
        A type of trigger configuration for Git-based source actions.
        :param str source_action_name: The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        :param Sequence['PipelineGitPullRequestFilter'] pull_request: The field where the repository event that will start the pipeline is specified as pull requests.
        :param Sequence['PipelineGitPushFilter'] push: The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
        """
        pulumi.set(__self__, "source_action_name", source_action_name)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="sourceActionName")
    def source_action_name(self) -> str:
        """
        The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        return pulumi.get(self, "source_action_name")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[Sequence['outputs.PipelineGitPullRequestFilter']]:
        """
        The field where the repository event that will start the pipeline is specified as pull requests.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> Optional[Sequence['outputs.PipelineGitPushFilter']]:
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class PipelineGitFilePathFilterCriteria(dict):
    """
    The Git repository file paths specified as filter criteria to start the pipeline.
    """
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        The Git repository file paths specified as filter criteria to start the pipeline.
        :param Sequence[str] excludes: The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineGitPullRequestFilter(dict):
    """
    The event criteria for the pull request trigger configuration, such as the lists of branches or file paths to include and exclude.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineGitPullRequestFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineGitPullRequestFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineGitPullRequestFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional['outputs.PipelineGitBranchFilterCriteria'] = None,
                 events: Optional[Sequence[str]] = None,
                 file_paths: Optional['outputs.PipelineGitFilePathFilterCriteria'] = None):
        """
        The event criteria for the pull request trigger configuration, such as the lists of branches or file paths to include and exclude.
        :param 'PipelineGitBranchFilterCriteria' branches: The field that specifies to filter on branches for the pull request trigger configuration.
        :param Sequence[str] events: The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
        :param 'PipelineGitFilePathFilterCriteria' file_paths: The field that specifies to filter on file paths for the pull request trigger configuration.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)

    @property
    @pulumi.getter
    def branches(self) -> Optional['outputs.PipelineGitBranchFilterCriteria']:
        """
        The field that specifies to filter on branches for the pull request trigger configuration.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[str]]:
        """
        The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional['outputs.PipelineGitFilePathFilterCriteria']:
        """
        The field that specifies to filter on file paths for the pull request trigger configuration.
        """
        return pulumi.get(self, "file_paths")


@pulumi.output_type
class PipelineGitPushFilter(dict):
    """
    The event criteria that specify when a specified repository event will start the pipeline for the specified trigger configuration, such as the lists of Git tags to include and exclude.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineGitPushFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineGitPushFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineGitPushFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional['outputs.PipelineGitBranchFilterCriteria'] = None,
                 file_paths: Optional['outputs.PipelineGitFilePathFilterCriteria'] = None,
                 tags: Optional['outputs.PipelineGitTagFilterCriteria'] = None):
        """
        The event criteria that specify when a specified repository event will start the pipeline for the specified trigger configuration, such as the lists of Git tags to include and exclude.
        :param 'PipelineGitBranchFilterCriteria' branches: The field that specifies to filter on branches for the push trigger configuration.
        :param 'PipelineGitFilePathFilterCriteria' file_paths: The field that specifies to filter on file paths for the push trigger configuration.
        :param 'PipelineGitTagFilterCriteria' tags: The field that contains the details for the Git tags trigger configuration.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def branches(self) -> Optional['outputs.PipelineGitBranchFilterCriteria']:
        """
        The field that specifies to filter on branches for the push trigger configuration.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional['outputs.PipelineGitFilePathFilterCriteria']:
        """
        The field that specifies to filter on file paths for the push trigger configuration.
        """
        return pulumi.get(self, "file_paths")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.PipelineGitTagFilterCriteria']:
        """
        The field that contains the details for the Git tags trigger configuration.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PipelineGitTagFilterCriteria(dict):
    """
    The Git tags specified as filter criteria for whether a Git tag repository event will start the pipeline.
    """
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        The Git tags specified as filter criteria for whether a Git tag repository event will start the pipeline.
        :param Sequence[str] excludes: The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        :param Sequence[str] includes: The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineInputArtifact(dict):
    """
    Represents information about an artifact to be worked on, such as a test or build artifact.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Represents information about an artifact to be worked on, such as a test or build artifact.
        :param str name: The name of the artifact to be worked on (for example, "My App").
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the artifact to be worked on (for example, "My App").
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PipelineOutputArtifact(dict):
    """
    Represents information about the output of an action.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Represents information about the output of an action.
        :param str name: The name of the output of an artifact, such as "My App".
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the output of an artifact, such as "My App".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PipelineRuleDeclaration(dict):
    """
    Represents information about condition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "ruleTypeId":
            suggest = "rule_type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineRuleDeclaration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineRuleDeclaration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineRuleDeclaration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration: Optional[Any] = None,
                 input_artifacts: Optional[Sequence['outputs.PipelineInputArtifact']] = None,
                 name: Optional[str] = None,
                 region: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 rule_type_id: Optional['outputs.PipelineRuleTypeId'] = None):
        """
        Represents information about condition.
        :param Any configuration: The rule's configuration. These are key-value pairs that specify input values for a rule.
        :param Sequence['PipelineInputArtifact'] input_artifacts: The input artifacts fields for the rule, such as specifying an input file for the rule.
        :param str name: The rule declaration's name.
        :param str region: The rule declaration's AWS Region, such as us-east-1.
        :param str role_arn: The ARN of the IAM service role that performs the declared rule. This is assumed through the roleArn for the pipeline.
        :param 'PipelineRuleTypeId' rule_type_id: The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if rule_type_id is not None:
            pulumi.set(__self__, "rule_type_id", rule_type_id)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        The rule's configuration. These are key-value pairs that specify input values for a rule.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence['outputs.PipelineInputArtifact']]:
        """
        The input artifacts fields for the rule, such as specifying an input file for the rule.
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The rule declaration's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The rule declaration's AWS Region, such as us-east-1.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM service role that performs the declared rule. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="ruleTypeId")
    def rule_type_id(self) -> Optional['outputs.PipelineRuleTypeId']:
        """
        The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
        """
        return pulumi.get(self, "rule_type_id")


@pulumi.output_type
class PipelineRuleTypeId(dict):
    """
    Represents information about a rule type.
    """
    def __init__(__self__, *,
                 category: Optional[str] = None,
                 owner: Optional[str] = None,
                 provider: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Represents information about a rule type.
        :param str category: A category for the provider type for the rule.
        :param str owner: The creator of the rule being called. Only AWS is supported.
        :param str provider: The provider of the service being called by the rule.
        :param str version: A string that describes the rule version.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        A category for the provider type for the rule.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        The creator of the rule being called. Only AWS is supported.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        The provider of the service being called by the rule.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        A string that describes the rule version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PipelineStageDeclaration(dict):
    """
    Represents information about a stage and its definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beforeEntry":
            suggest = "before_entry"
        elif key == "onFailure":
            suggest = "on_failure"
        elif key == "onSuccess":
            suggest = "on_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageDeclaration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageDeclaration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageDeclaration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence['outputs.PipelineActionDeclaration'],
                 name: str,
                 before_entry: Optional['outputs.PipelineBeforeEntryConditions'] = None,
                 blockers: Optional[Sequence['outputs.PipelineBlockerDeclaration']] = None,
                 on_failure: Optional['outputs.PipelineFailureConditions'] = None,
                 on_success: Optional['outputs.PipelineSuccessConditions'] = None):
        """
        Represents information about a stage and its definition.
        :param Sequence['PipelineActionDeclaration'] actions: The actions included in a stage.
        :param str name: The name of the stage.
        :param 'PipelineBeforeEntryConditions' before_entry: The method to use before stage runs.
        :param Sequence['PipelineBlockerDeclaration'] blockers: Reserved for future use.
        :param 'PipelineFailureConditions' on_failure: The method to use when a stage has not completed successfully
        :param 'PipelineSuccessConditions' on_success: The method to use when a stage has completed successfully
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "name", name)
        if before_entry is not None:
            pulumi.set(__self__, "before_entry", before_entry)
        if blockers is not None:
            pulumi.set(__self__, "blockers", blockers)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.PipelineActionDeclaration']:
        """
        The actions included in a stage.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the stage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="beforeEntry")
    def before_entry(self) -> Optional['outputs.PipelineBeforeEntryConditions']:
        """
        The method to use before stage runs.
        """
        return pulumi.get(self, "before_entry")

    @property
    @pulumi.getter
    def blockers(self) -> Optional[Sequence['outputs.PipelineBlockerDeclaration']]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "blockers")

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.PipelineFailureConditions']:
        """
        The method to use when a stage has not completed successfully
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional['outputs.PipelineSuccessConditions']:
        """
        The method to use when a stage has completed successfully
        """
        return pulumi.get(self, "on_success")


@pulumi.output_type
class PipelineStageTransition(dict):
    """
    The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stageName":
            suggest = "stage_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reason: str,
                 stage_name: str):
        """
        The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
        :param str reason: The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
        :param str stage_name: The name of the stage where you want to disable the inbound or outbound transition of artifacts.
        """
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> str:
        """
        The name of the stage where you want to disable the inbound or outbound transition of artifacts.
        """
        return pulumi.get(self, "stage_name")


@pulumi.output_type
class PipelineSuccessConditions(dict):
    """
    The configuration that specifies the result, such as rollback, to occur upon stage failure
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.PipelineCondition']] = None):
        """
        The configuration that specifies the result, such as rollback, to occur upon stage failure
        :param Sequence['PipelineCondition'] conditions: The conditions that are success conditions.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PipelineCondition']]:
        """
        The conditions that are success conditions.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class PipelineTriggerDeclaration(dict):
    """
    Represents information about the specified trigger configuration, such as the filter criteria and the source stage for the action that contains the trigger.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "gitConfiguration":
            suggest = "git_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerDeclaration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerDeclaration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerDeclaration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: 'PipelineTriggerDeclarationProviderType',
                 git_configuration: Optional['outputs.PipelineGitConfiguration'] = None):
        """
        Represents information about the specified trigger configuration, such as the filter criteria and the source stage for the action that contains the trigger.
        :param 'PipelineTriggerDeclarationProviderType' provider_type: The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
        :param 'PipelineGitConfiguration' git_configuration: Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
        """
        pulumi.set(__self__, "provider_type", provider_type)
        if git_configuration is not None:
            pulumi.set(__self__, "git_configuration", git_configuration)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> 'PipelineTriggerDeclarationProviderType':
        """
        The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="gitConfiguration")
    def git_configuration(self) -> Optional['outputs.PipelineGitConfiguration']:
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
        """
        return pulumi.get(self, "git_configuration")


@pulumi.output_type
class PipelineVariableDeclaration(dict):
    """
    A variable declared at the pipeline level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineVariableDeclaration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineVariableDeclaration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineVariableDeclaration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None):
        """
        A variable declared at the pipeline level.
        :param str name: The name of a pipeline-level variable.
        :param str default_value: The value of a pipeline-level variable.
        :param str description: The description of a pipeline-level variable. It's used to add additional context about the variable, and not being used at time when pipeline executes.
        """
        pulumi.set(__self__, "name", name)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a pipeline-level variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        The value of a pipeline-level variable.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of a pipeline-level variable. It's used to add additional context about the variable, and not being used at time when pipeline executes.
        """
        return pulumi.get(self, "description")


