# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetPipelineResult',
    'AwaitableGetPipelineResult',
    'get_pipeline',
    'get_pipeline_output',
]

@pulumi.output_type
class GetPipelineResult:
    def __init__(__self__, artifact_store=None, artifact_stores=None, disable_inbound_stage_transitions=None, execution_mode=None, pipeline_type=None, role_arn=None, stages=None, tags=None, triggers=None, variables=None, version=None):
        if artifact_store and not isinstance(artifact_store, dict):
            raise TypeError("Expected argument 'artifact_store' to be a dict")
        pulumi.set(__self__, "artifact_store", artifact_store)
        if artifact_stores and not isinstance(artifact_stores, list):
            raise TypeError("Expected argument 'artifact_stores' to be a list")
        pulumi.set(__self__, "artifact_stores", artifact_stores)
        if disable_inbound_stage_transitions and not isinstance(disable_inbound_stage_transitions, list):
            raise TypeError("Expected argument 'disable_inbound_stage_transitions' to be a list")
        pulumi.set(__self__, "disable_inbound_stage_transitions", disable_inbound_stage_transitions)
        if execution_mode and not isinstance(execution_mode, str):
            raise TypeError("Expected argument 'execution_mode' to be a str")
        pulumi.set(__self__, "execution_mode", execution_mode)
        if pipeline_type and not isinstance(pipeline_type, str):
            raise TypeError("Expected argument 'pipeline_type' to be a str")
        pulumi.set(__self__, "pipeline_type", pipeline_type)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if stages and not isinstance(stages, list):
            raise TypeError("Expected argument 'stages' to be a list")
        pulumi.set(__self__, "stages", stages)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)
        if variables and not isinstance(variables, list):
            raise TypeError("Expected argument 'variables' to be a list")
        pulumi.set(__self__, "variables", variables)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactStore")
    def artifact_store(self) -> Optional['outputs.PipelineArtifactStore']:
        """
        The S3 bucket where artifacts for the pipeline are stored.
        """
        return pulumi.get(self, "artifact_store")

    @property
    @pulumi.getter(name="artifactStores")
    def artifact_stores(self) -> Optional[Sequence['outputs.PipelineArtifactStoreMap']]:
        """
        A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        """
        return pulumi.get(self, "artifact_stores")

    @property
    @pulumi.getter(name="disableInboundStageTransitions")
    def disable_inbound_stage_transitions(self) -> Optional[Sequence['outputs.PipelineStageTransition']]:
        """
        Represents the input of a DisableStageTransition action.
        """
        return pulumi.get(self, "disable_inbound_stage_transitions")

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> Optional['PipelineExecutionMode']:
        """
        The method that the pipeline will use to handle multiple executions. The default mode is SUPERSEDED.
        """
        return pulumi.get(self, "execution_mode")

    @property
    @pulumi.getter(name="pipelineType")
    def pipeline_type(self) -> Optional['PipelineType']:
        """
        CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
        """
        return pulumi.get(self, "pipeline_type")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no actionRoleArn, or to use to assume roles for actions with an actionRoleArn
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def stages(self) -> Optional[Sequence['outputs.PipelineStageDeclaration']]:
        """
        Represents information about a stage and its definition.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Specifies the tags applied to the pipeline.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def triggers(self) -> Optional[Sequence['outputs.PipelineTriggerDeclaration']]:
        """
        The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.PipelineVariableDeclaration']]:
        """
        A list that defines the pipeline variables for a pipeline resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9@\\-_]+.
        """
        return pulumi.get(self, "variables")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the pipeline.
        """
        return pulumi.get(self, "version")


class AwaitableGetPipelineResult(GetPipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineResult(
            artifact_store=self.artifact_store,
            artifact_stores=self.artifact_stores,
            disable_inbound_stage_transitions=self.disable_inbound_stage_transitions,
            execution_mode=self.execution_mode,
            pipeline_type=self.pipeline_type,
            role_arn=self.role_arn,
            stages=self.stages,
            tags=self.tags,
            triggers=self.triggers,
            variables=self.variables,
            version=self.version)


def get_pipeline(name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineResult:
    """
    The AWS::CodePipeline::Pipeline resource creates a CodePipeline pipeline that describes how software changes go through a release process.


    :param str name: The name of the pipeline.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codepipeline:getPipeline', __args__, opts=opts, typ=GetPipelineResult).value

    return AwaitableGetPipelineResult(
        artifact_store=pulumi.get(__ret__, 'artifact_store'),
        artifact_stores=pulumi.get(__ret__, 'artifact_stores'),
        disable_inbound_stage_transitions=pulumi.get(__ret__, 'disable_inbound_stage_transitions'),
        execution_mode=pulumi.get(__ret__, 'execution_mode'),
        pipeline_type=pulumi.get(__ret__, 'pipeline_type'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        stages=pulumi.get(__ret__, 'stages'),
        tags=pulumi.get(__ret__, 'tags'),
        triggers=pulumi.get(__ret__, 'triggers'),
        variables=pulumi.get(__ret__, 'variables'),
        version=pulumi.get(__ret__, 'version'))
def get_pipeline_output(name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPipelineResult]:
    """
    The AWS::CodePipeline::Pipeline resource creates a CodePipeline pipeline that describes how software changes go through a release process.


    :param str name: The name of the pipeline.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:codepipeline:getPipeline', __args__, opts=opts, typ=GetPipelineResult)
    return __ret__.apply(lambda __response__: GetPipelineResult(
        artifact_store=pulumi.get(__response__, 'artifact_store'),
        artifact_stores=pulumi.get(__response__, 'artifact_stores'),
        disable_inbound_stage_transitions=pulumi.get(__response__, 'disable_inbound_stage_transitions'),
        execution_mode=pulumi.get(__response__, 'execution_mode'),
        pipeline_type=pulumi.get(__response__, 'pipeline_type'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        stages=pulumi.get(__response__, 'stages'),
        tags=pulumi.get(__response__, 'tags'),
        triggers=pulumi.get(__response__, 'triggers'),
        variables=pulumi.get(__response__, 'variables'),
        version=pulumi.get(__response__, 'version')))
