# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CustomActionTypeArtifactDetailsArgs',
    'CustomActionTypeArtifactDetailsArgsDict',
    'CustomActionTypeConfigurationPropertiesArgs',
    'CustomActionTypeConfigurationPropertiesArgsDict',
    'CustomActionTypeSettingsArgs',
    'CustomActionTypeSettingsArgsDict',
    'PipelineActionDeclarationArgs',
    'PipelineActionDeclarationArgsDict',
    'PipelineActionTypeIdArgs',
    'PipelineActionTypeIdArgsDict',
    'PipelineArtifactStoreMapArgs',
    'PipelineArtifactStoreMapArgsDict',
    'PipelineArtifactStoreArgs',
    'PipelineArtifactStoreArgsDict',
    'PipelineBeforeEntryConditionsArgs',
    'PipelineBeforeEntryConditionsArgsDict',
    'PipelineBlockerDeclarationArgs',
    'PipelineBlockerDeclarationArgsDict',
    'PipelineConditionArgs',
    'PipelineConditionArgsDict',
    'PipelineEncryptionKeyArgs',
    'PipelineEncryptionKeyArgsDict',
    'PipelineFailureConditionsArgs',
    'PipelineFailureConditionsArgsDict',
    'PipelineGitBranchFilterCriteriaArgs',
    'PipelineGitBranchFilterCriteriaArgsDict',
    'PipelineGitConfigurationArgs',
    'PipelineGitConfigurationArgsDict',
    'PipelineGitFilePathFilterCriteriaArgs',
    'PipelineGitFilePathFilterCriteriaArgsDict',
    'PipelineGitPullRequestFilterArgs',
    'PipelineGitPullRequestFilterArgsDict',
    'PipelineGitPushFilterArgs',
    'PipelineGitPushFilterArgsDict',
    'PipelineGitTagFilterCriteriaArgs',
    'PipelineGitTagFilterCriteriaArgsDict',
    'PipelineInputArtifactArgs',
    'PipelineInputArtifactArgsDict',
    'PipelineOutputArtifactArgs',
    'PipelineOutputArtifactArgsDict',
    'PipelineRuleDeclarationArgs',
    'PipelineRuleDeclarationArgsDict',
    'PipelineRuleTypeIdArgs',
    'PipelineRuleTypeIdArgsDict',
    'PipelineStageDeclarationArgs',
    'PipelineStageDeclarationArgsDict',
    'PipelineStageTransitionArgs',
    'PipelineStageTransitionArgsDict',
    'PipelineSuccessConditionsArgs',
    'PipelineSuccessConditionsArgsDict',
    'PipelineTriggerDeclarationArgs',
    'PipelineTriggerDeclarationArgsDict',
    'PipelineVariableDeclarationArgs',
    'PipelineVariableDeclarationArgsDict',
]

MYPY = False

if not MYPY:
    class CustomActionTypeArtifactDetailsArgsDict(TypedDict):
        """
        Returns information about the details of an artifact.
        """
        maximum_count: pulumi.Input[int]
        """
        The maximum number of artifacts allowed for the action type.
        """
        minimum_count: pulumi.Input[int]
        """
        The minimum number of artifacts allowed for the action type.
        """
elif False:
    CustomActionTypeArtifactDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomActionTypeArtifactDetailsArgs:
    def __init__(__self__, *,
                 maximum_count: pulumi.Input[int],
                 minimum_count: pulumi.Input[int]):
        """
        Returns information about the details of an artifact.
        :param pulumi.Input[int] maximum_count: The maximum number of artifacts allowed for the action type.
        :param pulumi.Input[int] minimum_count: The minimum number of artifacts allowed for the action type.
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> pulumi.Input[int]:
        """
        The maximum number of artifacts allowed for the action type.
        """
        return pulumi.get(self, "maximum_count")

    @maximum_count.setter
    def maximum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "maximum_count", value)

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> pulumi.Input[int]:
        """
        The minimum number of artifacts allowed for the action type.
        """
        return pulumi.get(self, "minimum_count")

    @minimum_count.setter
    def minimum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_count", value)


if not MYPY:
    class CustomActionTypeConfigurationPropertiesArgsDict(TypedDict):
        """
        The configuration properties for the custom action.
        """
        key: pulumi.Input[bool]
        """
        Whether the configuration property is a key.
        """
        name: pulumi.Input[str]
        """
        The name of the action configuration property.
        """
        required: pulumi.Input[bool]
        """
        Whether the configuration property is a required value.
        """
        secret: pulumi.Input[bool]
        """
        Whether the configuration property is secret. Secrets are hidden from all calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and PollForThirdPartyJobs.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description of the action configuration property that is displayed to users. 
        """
        queryable: NotRequired[pulumi.Input[bool]]
        """
        Indicates that the property is used with PollForJobs. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens. 
        """
        type: NotRequired[pulumi.Input[str]]
        """
        The type of the configuration property.
        """
elif False:
    CustomActionTypeConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomActionTypeConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 required: pulumi.Input[bool],
                 secret: pulumi.Input[bool],
                 description: Optional[pulumi.Input[str]] = None,
                 queryable: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The configuration properties for the custom action.
        :param pulumi.Input[bool] key: Whether the configuration property is a key.
        :param pulumi.Input[str] name: The name of the action configuration property.
        :param pulumi.Input[bool] required: Whether the configuration property is a required value.
        :param pulumi.Input[bool] secret: Whether the configuration property is secret. Secrets are hidden from all calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and PollForThirdPartyJobs.
        :param pulumi.Input[str] description: The description of the action configuration property that is displayed to users. 
        :param pulumi.Input[bool] queryable: Indicates that the property is used with PollForJobs. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens. 
        :param pulumi.Input[str] type: The type of the configuration property.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "secret", secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if queryable is not None:
            pulumi.set(__self__, "queryable", queryable)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[bool]:
        """
        Whether the configuration property is a key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[bool]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action configuration property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[bool]:
        """
        Whether the configuration property is a required value.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[bool]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[bool]:
        """
        Whether the configuration property is secret. Secrets are hidden from all calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and PollForThirdPartyJobs.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[bool]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the action configuration property that is displayed to users. 
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def queryable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the property is used with PollForJobs. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens. 
        """
        return pulumi.get(self, "queryable")

    @queryable.setter
    def queryable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queryable", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the configuration property.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class CustomActionTypeSettingsArgsDict(TypedDict):
        """
        Settings is a property of the AWS::CodePipeline::CustomActionType resource that provides URLs that users can access to view information about the CodePipeline custom action. 
        """
        entity_url_template: NotRequired[pulumi.Input[str]]
        """
        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline. 
        """
        execution_url_template: NotRequired[pulumi.Input[str]]
        """
        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action. 
        """
        revision_url_template: NotRequired[pulumi.Input[str]]
        """
        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action. 
        """
        third_party_configuration_url: NotRequired[pulumi.Input[str]]
        """
        The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
elif False:
    CustomActionTypeSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomActionTypeSettingsArgs:
    def __init__(__self__, *,
                 entity_url_template: Optional[pulumi.Input[str]] = None,
                 execution_url_template: Optional[pulumi.Input[str]] = None,
                 revision_url_template: Optional[pulumi.Input[str]] = None,
                 third_party_configuration_url: Optional[pulumi.Input[str]] = None):
        """
        Settings is a property of the AWS::CodePipeline::CustomActionType resource that provides URLs that users can access to view information about the CodePipeline custom action. 
        :param pulumi.Input[str] entity_url_template: The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline. 
        :param pulumi.Input[str] execution_url_template: The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action. 
        :param pulumi.Input[str] revision_url_template: The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action. 
        :param pulumi.Input[str] third_party_configuration_url: The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        if entity_url_template is not None:
            pulumi.set(__self__, "entity_url_template", entity_url_template)
        if execution_url_template is not None:
            pulumi.set(__self__, "execution_url_template", execution_url_template)
        if revision_url_template is not None:
            pulumi.set(__self__, "revision_url_template", revision_url_template)
        if third_party_configuration_url is not None:
            pulumi.set(__self__, "third_party_configuration_url", third_party_configuration_url)

    @property
    @pulumi.getter(name="entityUrlTemplate")
    def entity_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline. 
        """
        return pulumi.get(self, "entity_url_template")

    @entity_url_template.setter
    def entity_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_url_template", value)

    @property
    @pulumi.getter(name="executionUrlTemplate")
    def execution_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action. 
        """
        return pulumi.get(self, "execution_url_template")

    @execution_url_template.setter
    def execution_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_url_template", value)

    @property
    @pulumi.getter(name="revisionUrlTemplate")
    def revision_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action. 
        """
        return pulumi.get(self, "revision_url_template")

    @revision_url_template.setter
    def revision_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_url_template", value)

    @property
    @pulumi.getter(name="thirdPartyConfigurationUrl")
    def third_party_configuration_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        return pulumi.get(self, "third_party_configuration_url")

    @third_party_configuration_url.setter
    def third_party_configuration_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "third_party_configuration_url", value)


if not MYPY:
    class PipelineActionDeclarationArgsDict(TypedDict):
        """
        Represents information about an action declaration.
        """
        action_type_id: pulumi.Input['PipelineActionTypeIdArgsDict']
        """
        Specifies the action type and the provider of the action.
        """
        name: pulumi.Input[str]
        """
        The action declaration's name.
        """
        configuration: NotRequired[Any]
        """
        The action's configuration. These are key-value pairs that specify input values for an action.
        """
        input_artifacts: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgsDict']]]]
        """
        The name or ID of the artifact consumed by the action, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .

        > For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the [CodeBuild action reference page](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html) in the *AWS CodePipeline User Guide* .
        """
        namespace: NotRequired[pulumi.Input[str]]
        """
        The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
        """
        output_artifacts: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineOutputArtifactArgsDict']]]]
        """
        The name or ID of the result of the action declaration, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
        """
        region: NotRequired[pulumi.Input[str]]
        """
        The action declaration's AWS Region, such as us-east-1.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
        """
        run_order: NotRequired[pulumi.Input[int]]
        """
        The order in which actions are run.
        """
        timeout_in_minutes: NotRequired[pulumi.Input[int]]
        """
        A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline. This attribute is available only to the manual approval ActionType.
        """
elif False:
    PipelineActionDeclarationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineActionDeclarationArgs:
    def __init__(__self__, *,
                 action_type_id: pulumi.Input['PipelineActionTypeIdArgs'],
                 name: pulumi.Input[str],
                 configuration: Optional[Any] = None,
                 input_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 output_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineOutputArtifactArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 run_order: Optional[pulumi.Input[int]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        Represents information about an action declaration.
        :param pulumi.Input['PipelineActionTypeIdArgs'] action_type_id: Specifies the action type and the provider of the action.
        :param pulumi.Input[str] name: The action declaration's name.
        :param Any configuration: The action's configuration. These are key-value pairs that specify input values for an action.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]] input_artifacts: The name or ID of the artifact consumed by the action, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
               
               > For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the [CodeBuild action reference page](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html) in the *AWS CodePipeline User Guide* .
        :param pulumi.Input[str] namespace: The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineOutputArtifactArgs']]] output_artifacts: The name or ID of the result of the action declaration, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
        :param pulumi.Input[str] region: The action declaration's AWS Region, such as us-east-1.
        :param pulumi.Input[str] role_arn: The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
        :param pulumi.Input[int] run_order: The order in which actions are run.
        :param pulumi.Input[int] timeout_in_minutes: A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline. This attribute is available only to the manual approval ActionType.
        """
        pulumi.set(__self__, "action_type_id", action_type_id)
        pulumi.set(__self__, "name", name)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if output_artifacts is not None:
            pulumi.set(__self__, "output_artifacts", output_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_order is not None:
            pulumi.set(__self__, "run_order", run_order)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter(name="actionTypeId")
    def action_type_id(self) -> pulumi.Input['PipelineActionTypeIdArgs']:
        """
        Specifies the action type and the provider of the action.
        """
        return pulumi.get(self, "action_type_id")

    @action_type_id.setter
    def action_type_id(self, value: pulumi.Input['PipelineActionTypeIdArgs']):
        pulumi.set(self, "action_type_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The action declaration's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        The action's configuration. These are key-value pairs that specify input values for an action.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[Any]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]]]:
        """
        The name or ID of the artifact consumed by the action, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .

        > For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the [CodeBuild action reference page](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html) in the *AWS CodePipeline User Guide* .
        """
        return pulumi.get(self, "input_artifacts")

    @input_artifacts.setter
    def input_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]]]):
        pulumi.set(self, "input_artifacts", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="outputArtifacts")
    def output_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineOutputArtifactArgs']]]]:
        """
        The name or ID of the result of the action declaration, such as a test or build artifact. While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the [Action structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) in the *AWS CodePipeline User Guide* .
        """
        return pulumi.get(self, "output_artifacts")

    @output_artifacts.setter
    def output_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineOutputArtifactArgs']]]]):
        pulumi.set(self, "output_artifacts", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The action declaration's AWS Region, such as us-east-1.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="runOrder")
    def run_order(self) -> Optional[pulumi.Input[int]]:
        """
        The order in which actions are run.
        """
        return pulumi.get(self, "run_order")

    @run_order.setter
    def run_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_order", value)

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline. This attribute is available only to the manual approval ActionType.
        """
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_minutes", value)


if not MYPY:
    class PipelineActionTypeIdArgsDict(TypedDict):
        """
        Represents information about an action type.
        """
        category: pulumi.Input['PipelineActionTypeIdCategory']
        """
        A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the values below.
        """
        owner: pulumi.Input[str]
        """
        The creator of the action being called. There are three valid values for the Owner field in the action category section within your pipeline structure: AWS, ThirdParty, and Custom.
        """
        provider: pulumi.Input[str]
        """
        The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as CodeDeploy.
        """
        version: pulumi.Input[str]
        """
        A string that describes the action version.
        """
elif False:
    PipelineActionTypeIdArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineActionTypeIdArgs:
    def __init__(__self__, *,
                 category: pulumi.Input['PipelineActionTypeIdCategory'],
                 owner: pulumi.Input[str],
                 provider: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        Represents information about an action type.
        :param pulumi.Input['PipelineActionTypeIdCategory'] category: A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the values below.
        :param pulumi.Input[str] owner: The creator of the action being called. There are three valid values for the Owner field in the action category section within your pipeline structure: AWS, ThirdParty, and Custom.
        :param pulumi.Input[str] provider: The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as CodeDeploy.
        :param pulumi.Input[str] version: A string that describes the action version.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input['PipelineActionTypeIdCategory']:
        """
        A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the values below.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input['PipelineActionTypeIdCategory']):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input[str]:
        """
        The creator of the action being called. There are three valid values for the Owner field in the action category section within your pipeline structure: AWS, ThirdParty, and Custom.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Input[str]:
        """
        The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as CodeDeploy.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        A string that describes the action version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


if not MYPY:
    class PipelineArtifactStoreMapArgsDict(TypedDict):
        """
        A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        """
        artifact_store: pulumi.Input['PipelineArtifactStoreArgsDict']
        """
        Represents information about the S3 bucket where artifacts are stored for the pipeline.

        > You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores` .
        """
        region: pulumi.Input[str]
        """
        The action declaration's AWS Region, such as us-east-1.
        """
elif False:
    PipelineArtifactStoreMapArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineArtifactStoreMapArgs:
    def __init__(__self__, *,
                 artifact_store: pulumi.Input['PipelineArtifactStoreArgs'],
                 region: pulumi.Input[str]):
        """
        A mapping of artifactStore objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
        :param pulumi.Input['PipelineArtifactStoreArgs'] artifact_store: Represents information about the S3 bucket where artifacts are stored for the pipeline.
               
               > You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores` .
        :param pulumi.Input[str] region: The action declaration's AWS Region, such as us-east-1.
        """
        pulumi.set(__self__, "artifact_store", artifact_store)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="artifactStore")
    def artifact_store(self) -> pulumi.Input['PipelineArtifactStoreArgs']:
        """
        Represents information about the S3 bucket where artifacts are stored for the pipeline.

        > You must include either `artifactStore` or `artifactStores` in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use `artifactStores` .
        """
        return pulumi.get(self, "artifact_store")

    @artifact_store.setter
    def artifact_store(self, value: pulumi.Input['PipelineArtifactStoreArgs']):
        pulumi.set(self, "artifact_store", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The action declaration's AWS Region, such as us-east-1.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)


if not MYPY:
    class PipelineArtifactStoreArgsDict(TypedDict):
        """
        The S3 bucket where artifacts for the pipeline are stored.
        """
        location: pulumi.Input[str]
        """
        The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
        """
        type: pulumi.Input['PipelineArtifactStoreType']
        """
        The type of the artifact store, such as S3.
        """
        encryption_key: NotRequired[pulumi.Input['PipelineEncryptionKeyArgsDict']]
        """
        The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key. If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: [AWS::CodePipeline::Pipeline](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html) .
        """
elif False:
    PipelineArtifactStoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineArtifactStoreArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 type: pulumi.Input['PipelineArtifactStoreType'],
                 encryption_key: Optional[pulumi.Input['PipelineEncryptionKeyArgs']] = None):
        """
        The S3 bucket where artifacts for the pipeline are stored.
        :param pulumi.Input[str] location: The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
        :param pulumi.Input['PipelineArtifactStoreType'] type: The type of the artifact store, such as S3.
        :param pulumi.Input['PipelineEncryptionKeyArgs'] encryption_key: The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key. If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: [AWS::CodePipeline::Pipeline](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html) .
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['PipelineArtifactStoreType']:
        """
        The type of the artifact store, such as S3.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['PipelineArtifactStoreType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['PipelineEncryptionKeyArgs']]:
        """
        The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key. If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: [AWS::CodePipeline::Pipeline](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html) .
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['PipelineEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)


if not MYPY:
    class PipelineBeforeEntryConditionsArgsDict(TypedDict):
        """
        The configuration that specifies the rules to run before stage starts.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgsDict']]]]
        """
        The conditions that are configured as entry conditions.
        """
elif False:
    PipelineBeforeEntryConditionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineBeforeEntryConditionsArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]] = None):
        """
        The configuration that specifies the rules to run before stage starts.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]] conditions: The conditions that are configured as entry conditions.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]]:
        """
        The conditions that are configured as entry conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]]):
        pulumi.set(self, "conditions", value)


if not MYPY:
    class PipelineBlockerDeclarationArgsDict(TypedDict):
        """
        Reserved for future use.
        """
        name: pulumi.Input[str]
        """
        Reserved for future use.
        """
        type: pulumi.Input['PipelineBlockerDeclarationType']
        """
        Reserved for future use.
        """
elif False:
    PipelineBlockerDeclarationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineBlockerDeclarationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input['PipelineBlockerDeclarationType']):
        """
        Reserved for future use.
        :param pulumi.Input[str] name: Reserved for future use.
        :param pulumi.Input['PipelineBlockerDeclarationType'] type: Reserved for future use.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['PipelineBlockerDeclarationType']:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['PipelineBlockerDeclarationType']):
        pulumi.set(self, "type", value)


if not MYPY:
    class PipelineConditionArgsDict(TypedDict):
        """
        Represents information about condition.
        """
        result: NotRequired[pulumi.Input[str]]
        """
        The specified result for when the failure conditions are met, such as rolling back the stage
        """
        rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineRuleDeclarationArgsDict']]]]
        """
        The rules that make up the condition.
        """
elif False:
    PipelineConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineConditionArgs:
    def __init__(__self__, *,
                 result: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRuleDeclarationArgs']]]] = None):
        """
        Represents information about condition.
        :param pulumi.Input[str] result: The specified result for when the failure conditions are met, such as rolling back the stage
        :param pulumi.Input[Sequence[pulumi.Input['PipelineRuleDeclarationArgs']]] rules: The rules that make up the condition.
        """
        if result is not None:
            pulumi.set(__self__, "result", result)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input[str]]:
        """
        The specified result for when the failure conditions are met, such as rolling back the stage
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "result", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRuleDeclarationArgs']]]]:
        """
        The rules that make up the condition.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRuleDeclarationArgs']]]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class PipelineEncryptionKeyArgsDict(TypedDict):
        """
        Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key
        """
        id: pulumi.Input[str]
        """
        The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
        """
        type: pulumi.Input[str]
        """
        The type of encryption key, such as an AWS KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
        """
elif False:
    PipelineEncryptionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineEncryptionKeyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key
        :param pulumi.Input[str] id: The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
        :param pulumi.Input[str] type: The type of encryption key, such as an AWS KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of encryption key, such as an AWS KMS key. When creating or updating a pipeline, the value must be set to 'KMS'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class PipelineFailureConditionsArgsDict(TypedDict):
        """
        The configuration that specifies the result, such as rollback, to occur upon stage failure
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgsDict']]]]
        """
        The conditions that are configured as failure conditions.
        """
        result: NotRequired[pulumi.Input['PipelineFailureConditionsResult']]
        """
        The specified result for when the failure conditions are met, such as rolling back the stage
        """
elif False:
    PipelineFailureConditionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineFailureConditionsArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]] = None,
                 result: Optional[pulumi.Input['PipelineFailureConditionsResult']] = None):
        """
        The configuration that specifies the result, such as rollback, to occur upon stage failure
        :param pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]] conditions: The conditions that are configured as failure conditions.
        :param pulumi.Input['PipelineFailureConditionsResult'] result: The specified result for when the failure conditions are met, such as rolling back the stage
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if result is not None:
            pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]]:
        """
        The conditions that are configured as failure conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input['PipelineFailureConditionsResult']]:
        """
        The specified result for when the failure conditions are met, such as rolling back the stage
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input['PipelineFailureConditionsResult']]):
        pulumi.set(self, "result", value)


if not MYPY:
    class PipelineGitBranchFilterCriteriaArgsDict(TypedDict):
        """
        The Git repository branches specified as filter criteria to start the pipeline.
        """
        excludes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        includes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
elif False:
    PipelineGitBranchFilterCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineGitBranchFilterCriteriaArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Git repository branches specified as filter criteria to start the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


if not MYPY:
    class PipelineGitConfigurationArgsDict(TypedDict):
        """
        A type of trigger configuration for Git-based source actions.
        """
        source_action_name: pulumi.Input[str]
        """
        The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        pull_request: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineGitPullRequestFilterArgsDict']]]]
        """
        The field where the repository event that will start the pipeline is specified as pull requests.
        """
        push: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineGitPushFilterArgsDict']]]]
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
        """
elif False:
    PipelineGitConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineGitConfigurationArgs:
    def __init__(__self__, *,
                 source_action_name: pulumi.Input[str],
                 pull_request: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineGitPullRequestFilterArgs']]]] = None,
                 push: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineGitPushFilterArgs']]]] = None):
        """
        A type of trigger configuration for Git-based source actions.
        :param pulumi.Input[str] source_action_name: The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineGitPullRequestFilterArgs']]] pull_request: The field where the repository event that will start the pipeline is specified as pull requests.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineGitPushFilterArgs']]] push: The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
        """
        pulumi.set(__self__, "source_action_name", source_action_name)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="sourceActionName")
    def source_action_name(self) -> pulumi.Input[str]:
        """
        The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        return pulumi.get(self, "source_action_name")

    @source_action_name.setter
    def source_action_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_action_name", value)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineGitPullRequestFilterArgs']]]]:
        """
        The field where the repository event that will start the pipeline is specified as pull requests.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineGitPullRequestFilterArgs']]]]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineGitPushFilterArgs']]]]:
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineGitPushFilterArgs']]]]):
        pulumi.set(self, "push", value)


if not MYPY:
    class PipelineGitFilePathFilterCriteriaArgsDict(TypedDict):
        """
        The Git repository file paths specified as filter criteria to start the pipeline.
        """
        excludes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        includes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
elif False:
    PipelineGitFilePathFilterCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineGitFilePathFilterCriteriaArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Git repository file paths specified as filter criteria to start the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


if not MYPY:
    class PipelineGitPullRequestFilterArgsDict(TypedDict):
        """
        The event criteria for the pull request trigger configuration, such as the lists of branches or file paths to include and exclude.
        """
        branches: NotRequired[pulumi.Input['PipelineGitBranchFilterCriteriaArgsDict']]
        """
        The field that specifies to filter on branches for the pull request trigger configuration.
        """
        events: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
        """
        file_paths: NotRequired[pulumi.Input['PipelineGitFilePathFilterCriteriaArgsDict']]
        """
        The field that specifies to filter on file paths for the pull request trigger configuration.
        """
elif False:
    PipelineGitPullRequestFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineGitPullRequestFilterArgs:
    def __init__(__self__, *,
                 branches: Optional[pulumi.Input['PipelineGitBranchFilterCriteriaArgs']] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_paths: Optional[pulumi.Input['PipelineGitFilePathFilterCriteriaArgs']] = None):
        """
        The event criteria for the pull request trigger configuration, such as the lists of branches or file paths to include and exclude.
        :param pulumi.Input['PipelineGitBranchFilterCriteriaArgs'] branches: The field that specifies to filter on branches for the pull request trigger configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
        :param pulumi.Input['PipelineGitFilePathFilterCriteriaArgs'] file_paths: The field that specifies to filter on file paths for the pull request trigger configuration.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)

    @property
    @pulumi.getter
    def branches(self) -> Optional[pulumi.Input['PipelineGitBranchFilterCriteriaArgs']]:
        """
        The field that specifies to filter on branches for the pull request trigger configuration.
        """
        return pulumi.get(self, "branches")

    @branches.setter
    def branches(self, value: Optional[pulumi.Input['PipelineGitBranchFilterCriteriaArgs']]):
        pulumi.set(self, "branches", value)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[pulumi.Input['PipelineGitFilePathFilterCriteriaArgs']]:
        """
        The field that specifies to filter on file paths for the pull request trigger configuration.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: Optional[pulumi.Input['PipelineGitFilePathFilterCriteriaArgs']]):
        pulumi.set(self, "file_paths", value)


if not MYPY:
    class PipelineGitPushFilterArgsDict(TypedDict):
        """
        The event criteria that specify when a specified repository event will start the pipeline for the specified trigger configuration, such as the lists of Git tags to include and exclude.
        """
        branches: NotRequired[pulumi.Input['PipelineGitBranchFilterCriteriaArgsDict']]
        """
        The field that specifies to filter on branches for the push trigger configuration.
        """
        file_paths: NotRequired[pulumi.Input['PipelineGitFilePathFilterCriteriaArgsDict']]
        """
        The field that specifies to filter on file paths for the push trigger configuration.
        """
        tags: NotRequired[pulumi.Input['PipelineGitTagFilterCriteriaArgsDict']]
        """
        The field that contains the details for the Git tags trigger configuration.
        """
elif False:
    PipelineGitPushFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineGitPushFilterArgs:
    def __init__(__self__, *,
                 branches: Optional[pulumi.Input['PipelineGitBranchFilterCriteriaArgs']] = None,
                 file_paths: Optional[pulumi.Input['PipelineGitFilePathFilterCriteriaArgs']] = None,
                 tags: Optional[pulumi.Input['PipelineGitTagFilterCriteriaArgs']] = None):
        """
        The event criteria that specify when a specified repository event will start the pipeline for the specified trigger configuration, such as the lists of Git tags to include and exclude.
        :param pulumi.Input['PipelineGitBranchFilterCriteriaArgs'] branches: The field that specifies to filter on branches for the push trigger configuration.
        :param pulumi.Input['PipelineGitFilePathFilterCriteriaArgs'] file_paths: The field that specifies to filter on file paths for the push trigger configuration.
        :param pulumi.Input['PipelineGitTagFilterCriteriaArgs'] tags: The field that contains the details for the Git tags trigger configuration.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def branches(self) -> Optional[pulumi.Input['PipelineGitBranchFilterCriteriaArgs']]:
        """
        The field that specifies to filter on branches for the push trigger configuration.
        """
        return pulumi.get(self, "branches")

    @branches.setter
    def branches(self, value: Optional[pulumi.Input['PipelineGitBranchFilterCriteriaArgs']]):
        pulumi.set(self, "branches", value)

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[pulumi.Input['PipelineGitFilePathFilterCriteriaArgs']]:
        """
        The field that specifies to filter on file paths for the push trigger configuration.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: Optional[pulumi.Input['PipelineGitFilePathFilterCriteriaArgs']]):
        pulumi.set(self, "file_paths", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['PipelineGitTagFilterCriteriaArgs']]:
        """
        The field that contains the details for the Git tags trigger configuration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['PipelineGitTagFilterCriteriaArgs']]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class PipelineGitTagFilterCriteriaArgsDict(TypedDict):
        """
        The Git tags specified as filter criteria for whether a Git tag repository event will start the pipeline.
        """
        excludes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        includes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
elif False:
    PipelineGitTagFilterCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineGitTagFilterCriteriaArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Git tags specified as filter criteria for whether a Git tag repository event will start the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


if not MYPY:
    class PipelineInputArtifactArgsDict(TypedDict):
        """
        Represents information about an artifact to be worked on, such as a test or build artifact.
        """
        name: pulumi.Input[str]
        """
        The name of the artifact to be worked on (for example, "My App").
        """
elif False:
    PipelineInputArtifactArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineInputArtifactArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        Represents information about an artifact to be worked on, such as a test or build artifact.
        :param pulumi.Input[str] name: The name of the artifact to be worked on (for example, "My App").
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the artifact to be worked on (for example, "My App").
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class PipelineOutputArtifactArgsDict(TypedDict):
        """
        Represents information about the output of an action.
        """
        name: pulumi.Input[str]
        """
        The name of the output of an artifact, such as "My App".
        """
elif False:
    PipelineOutputArtifactArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineOutputArtifactArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        Represents information about the output of an action.
        :param pulumi.Input[str] name: The name of the output of an artifact, such as "My App".
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the output of an artifact, such as "My App".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class PipelineRuleDeclarationArgsDict(TypedDict):
        """
        Represents information about condition.
        """
        configuration: NotRequired[Any]
        """
        The rule's configuration. These are key-value pairs that specify input values for a rule.
        """
        input_artifacts: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgsDict']]]]
        """
        The input artifacts fields for the rule, such as specifying an input file for the rule.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The rule declaration's name.
        """
        region: NotRequired[pulumi.Input[str]]
        """
        The rule declaration's AWS Region, such as us-east-1.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the IAM service role that performs the declared rule. This is assumed through the roleArn for the pipeline.
        """
        rule_type_id: NotRequired[pulumi.Input['PipelineRuleTypeIdArgsDict']]
        """
        The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
        """
elif False:
    PipelineRuleDeclarationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineRuleDeclarationArgs:
    def __init__(__self__, *,
                 configuration: Optional[Any] = None,
                 input_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule_type_id: Optional[pulumi.Input['PipelineRuleTypeIdArgs']] = None):
        """
        Represents information about condition.
        :param Any configuration: The rule's configuration. These are key-value pairs that specify input values for a rule.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]] input_artifacts: The input artifacts fields for the rule, such as specifying an input file for the rule.
        :param pulumi.Input[str] name: The rule declaration's name.
        :param pulumi.Input[str] region: The rule declaration's AWS Region, such as us-east-1.
        :param pulumi.Input[str] role_arn: The ARN of the IAM service role that performs the declared rule. This is assumed through the roleArn for the pipeline.
        :param pulumi.Input['PipelineRuleTypeIdArgs'] rule_type_id: The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if rule_type_id is not None:
            pulumi.set(__self__, "rule_type_id", rule_type_id)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        The rule's configuration. These are key-value pairs that specify input values for a rule.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[Any]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]]]:
        """
        The input artifacts fields for the rule, such as specifying an input file for the rule.
        """
        return pulumi.get(self, "input_artifacts")

    @input_artifacts.setter
    def input_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineInputArtifactArgs']]]]):
        pulumi.set(self, "input_artifacts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The rule declaration's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The rule declaration's AWS Region, such as us-east-1.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM service role that performs the declared rule. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="ruleTypeId")
    def rule_type_id(self) -> Optional[pulumi.Input['PipelineRuleTypeIdArgs']]:
        """
        The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
        """
        return pulumi.get(self, "rule_type_id")

    @rule_type_id.setter
    def rule_type_id(self, value: Optional[pulumi.Input['PipelineRuleTypeIdArgs']]):
        pulumi.set(self, "rule_type_id", value)


if not MYPY:
    class PipelineRuleTypeIdArgsDict(TypedDict):
        """
        Represents information about a rule type.
        """
        category: NotRequired[pulumi.Input[str]]
        """
        A category for the provider type for the rule.
        """
        owner: NotRequired[pulumi.Input[str]]
        """
        The creator of the rule being called. Only AWS is supported.
        """
        provider: NotRequired[pulumi.Input[str]]
        """
        The provider of the service being called by the rule.
        """
        version: NotRequired[pulumi.Input[str]]
        """
        A string that describes the rule version.
        """
elif False:
    PipelineRuleTypeIdArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineRuleTypeIdArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Represents information about a rule type.
        :param pulumi.Input[str] category: A category for the provider type for the rule.
        :param pulumi.Input[str] owner: The creator of the rule being called. Only AWS is supported.
        :param pulumi.Input[str] provider: The provider of the service being called by the rule.
        :param pulumi.Input[str] version: A string that describes the rule version.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        A category for the provider type for the rule.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        The creator of the rule being called. Only AWS is supported.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input[str]]:
        """
        The provider of the service being called by the rule.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        A string that describes the rule version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class PipelineStageDeclarationArgsDict(TypedDict):
        """
        Represents information about a stage and its definition.
        """
        actions: pulumi.Input[Sequence[pulumi.Input['PipelineActionDeclarationArgsDict']]]
        """
        The actions included in a stage.
        """
        name: pulumi.Input[str]
        """
        The name of the stage.
        """
        before_entry: NotRequired[pulumi.Input['PipelineBeforeEntryConditionsArgsDict']]
        """
        The method to use before stage runs.
        """
        blockers: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineBlockerDeclarationArgsDict']]]]
        """
        Reserved for future use.
        """
        on_failure: NotRequired[pulumi.Input['PipelineFailureConditionsArgsDict']]
        """
        The method to use when a stage has not completed successfully
        """
        on_success: NotRequired[pulumi.Input['PipelineSuccessConditionsArgsDict']]
        """
        The method to use when a stage has completed successfully
        """
elif False:
    PipelineStageDeclarationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineStageDeclarationArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['PipelineActionDeclarationArgs']]],
                 name: pulumi.Input[str],
                 before_entry: Optional[pulumi.Input['PipelineBeforeEntryConditionsArgs']] = None,
                 blockers: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineBlockerDeclarationArgs']]]] = None,
                 on_failure: Optional[pulumi.Input['PipelineFailureConditionsArgs']] = None,
                 on_success: Optional[pulumi.Input['PipelineSuccessConditionsArgs']] = None):
        """
        Represents information about a stage and its definition.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineActionDeclarationArgs']]] actions: The actions included in a stage.
        :param pulumi.Input[str] name: The name of the stage.
        :param pulumi.Input['PipelineBeforeEntryConditionsArgs'] before_entry: The method to use before stage runs.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineBlockerDeclarationArgs']]] blockers: Reserved for future use.
        :param pulumi.Input['PipelineFailureConditionsArgs'] on_failure: The method to use when a stage has not completed successfully
        :param pulumi.Input['PipelineSuccessConditionsArgs'] on_success: The method to use when a stage has completed successfully
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "name", name)
        if before_entry is not None:
            pulumi.set(__self__, "before_entry", before_entry)
        if blockers is not None:
            pulumi.set(__self__, "blockers", blockers)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineActionDeclarationArgs']]]:
        """
        The actions included in a stage.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineActionDeclarationArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the stage.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="beforeEntry")
    def before_entry(self) -> Optional[pulumi.Input['PipelineBeforeEntryConditionsArgs']]:
        """
        The method to use before stage runs.
        """
        return pulumi.get(self, "before_entry")

    @before_entry.setter
    def before_entry(self, value: Optional[pulumi.Input['PipelineBeforeEntryConditionsArgs']]):
        pulumi.set(self, "before_entry", value)

    @property
    @pulumi.getter
    def blockers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineBlockerDeclarationArgs']]]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "blockers")

    @blockers.setter
    def blockers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineBlockerDeclarationArgs']]]]):
        pulumi.set(self, "blockers", value)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input['PipelineFailureConditionsArgs']]:
        """
        The method to use when a stage has not completed successfully
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input['PipelineFailureConditionsArgs']]):
        pulumi.set(self, "on_failure", value)

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional[pulumi.Input['PipelineSuccessConditionsArgs']]:
        """
        The method to use when a stage has completed successfully
        """
        return pulumi.get(self, "on_success")

    @on_success.setter
    def on_success(self, value: Optional[pulumi.Input['PipelineSuccessConditionsArgs']]):
        pulumi.set(self, "on_success", value)


if not MYPY:
    class PipelineStageTransitionArgsDict(TypedDict):
        """
        The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
        """
        reason: pulumi.Input[str]
        """
        The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
        """
        stage_name: pulumi.Input[str]
        """
        The name of the stage where you want to disable the inbound or outbound transition of artifacts.
        """
elif False:
    PipelineStageTransitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineStageTransitionArgs:
    def __init__(__self__, *,
                 reason: pulumi.Input[str],
                 stage_name: pulumi.Input[str]):
        """
        The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
        :param pulumi.Input[str] reason: The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
        :param pulumi.Input[str] stage_name: The name of the stage where you want to disable the inbound or outbound transition of artifacts.
        """
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[str]:
        """
        The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> pulumi.Input[str]:
        """
        The name of the stage where you want to disable the inbound or outbound transition of artifacts.
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stage_name", value)


if not MYPY:
    class PipelineSuccessConditionsArgsDict(TypedDict):
        """
        The configuration that specifies the result, such as rollback, to occur upon stage failure
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgsDict']]]]
        """
        The conditions that are success conditions.
        """
elif False:
    PipelineSuccessConditionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineSuccessConditionsArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]] = None):
        """
        The configuration that specifies the result, such as rollback, to occur upon stage failure
        :param pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]] conditions: The conditions that are success conditions.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]]:
        """
        The conditions that are success conditions.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineConditionArgs']]]]):
        pulumi.set(self, "conditions", value)


if not MYPY:
    class PipelineTriggerDeclarationArgsDict(TypedDict):
        """
        Represents information about the specified trigger configuration, such as the filter criteria and the source stage for the action that contains the trigger.
        """
        provider_type: pulumi.Input['PipelineTriggerDeclarationProviderType']
        """
        The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
        """
        git_configuration: NotRequired[pulumi.Input['PipelineGitConfigurationArgsDict']]
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
        """
elif False:
    PipelineTriggerDeclarationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineTriggerDeclarationArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input['PipelineTriggerDeclarationProviderType'],
                 git_configuration: Optional[pulumi.Input['PipelineGitConfigurationArgs']] = None):
        """
        Represents information about the specified trigger configuration, such as the filter criteria and the source stage for the action that contains the trigger.
        :param pulumi.Input['PipelineTriggerDeclarationProviderType'] provider_type: The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
        :param pulumi.Input['PipelineGitConfigurationArgs'] git_configuration: Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
        """
        pulumi.set(__self__, "provider_type", provider_type)
        if git_configuration is not None:
            pulumi.set(__self__, "git_configuration", git_configuration)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input['PipelineTriggerDeclarationProviderType']:
        """
        The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input['PipelineTriggerDeclarationProviderType']):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="gitConfiguration")
    def git_configuration(self) -> Optional[pulumi.Input['PipelineGitConfigurationArgs']]:
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
        """
        return pulumi.get(self, "git_configuration")

    @git_configuration.setter
    def git_configuration(self, value: Optional[pulumi.Input['PipelineGitConfigurationArgs']]):
        pulumi.set(self, "git_configuration", value)


if not MYPY:
    class PipelineVariableDeclarationArgsDict(TypedDict):
        """
        A variable declared at the pipeline level.
        """
        name: pulumi.Input[str]
        """
        The name of a pipeline-level variable.
        """
        default_value: NotRequired[pulumi.Input[str]]
        """
        The value of a pipeline-level variable.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description of a pipeline-level variable. It's used to add additional context about the variable, and not being used at time when pipeline executes.
        """
elif False:
    PipelineVariableDeclarationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineVariableDeclarationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        A variable declared at the pipeline level.
        :param pulumi.Input[str] name: The name of a pipeline-level variable.
        :param pulumi.Input[str] default_value: The value of a pipeline-level variable.
        :param pulumi.Input[str] description: The description of a pipeline-level variable. It's used to add additional context about the variable, and not being used at time when pipeline executes.
        """
        pulumi.set(__self__, "name", name)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of a pipeline-level variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of a pipeline-level variable.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of a pipeline-level variable. It's used to add additional context about the variable, and not being used at time when pipeline executes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


