# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlarmDimension',
    'AlarmMetric',
    'AlarmMetricDataQuery',
    'AlarmMetricStat',
    'MetricStreamFilter',
    'MetricStreamStatisticsConfiguration',
    'MetricStreamStatisticsMetric',
]

@pulumi.output_type
class AlarmDimension(dict):
    """
    Dimension is an embedded property of the ``AWS::CloudWatch::Alarm`` type. Dimensions are name/value pairs that can be associated with a CW metric. You can specify a maximum of 10 dimensions for a given metric.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Dimension is an embedded property of the ``AWS::CloudWatch::Alarm`` type. Dimensions are name/value pairs that can be associated with a CW metric. You can specify a maximum of 10 dimensions for a given metric.
        :param str name: The name of the dimension, from 1–255 characters in length. This dimension name must have been included when the metric was published.
        :param str value: The value for the dimension, from 1–255 characters in length.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the dimension, from 1–255 characters in length. This dimension name must have been included when the metric was published.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the dimension, from 1–255 characters in length.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlarmMetric(dict):
    """
    The ``Metric`` property type represents a specific metric. ``Metric`` is a property of the [MetricStat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html) property type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.AlarmDimension']] = None,
                 metric_name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        The ``Metric`` property type represents a specific metric. ``Metric`` is a property of the [MetricStat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html) property type.
        :param Sequence['AlarmDimension'] dimensions: The metric dimensions that you want to be used for the metric that the alarm will watch.
        :param str metric_name: The name of the metric that you want the alarm to watch. This is a required field.
        :param str namespace: The namespace of the metric that the alarm will watch.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.AlarmDimension']]:
        """
        The metric dimensions that you want to be used for the metric that the alarm will watch.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric that you want the alarm to watch. This is a required field.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace of the metric that the alarm will watch.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class AlarmMetricDataQuery(dict):
    """
    The ``MetricDataQuery`` property type specifies the metric data to return, and whether this call is just retrieving a batch set of data for one metric, or is performing a math expression on metric data. 
     Any expression used must return a single time series. For more information, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "metricStat":
            suggest = "metric_stat"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmMetricDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmMetricDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmMetricDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 account_id: Optional[str] = None,
                 expression: Optional[str] = None,
                 label: Optional[str] = None,
                 metric_stat: Optional['outputs.AlarmMetricStat'] = None,
                 period: Optional[int] = None,
                 return_data: Optional[bool] = None):
        """
        The ``MetricDataQuery`` property type specifies the metric data to return, and whether this call is just retrieving a batch set of data for one metric, or is performing a math expression on metric data. 
         Any expression used must return a single time series. For more information, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
        :param str id: A short name used to tie this object to the results in the response. This name must be unique within a single call to ``GetMetricData``. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        :param str account_id: The ID of the account where the metrics are located, if this is a cross-account alarm.
        :param str expression: The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the ``Id`` of the other metrics to refer to those metrics, and can also use the ``Id`` of other expressions to use the result of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
                Within each MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        :param str label: A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CW dashboard widget, the label is shown. If ``Label`` is omitted, CW generates a default.
        :param 'AlarmMetricStat' metric_stat: The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
                Within one MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        :param int period: The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` operation that includes a ``StorageResolution of 1 second``.
        :param bool return_data: This option indicates whether to return the timestamps and raw data values of this metric.
                When you create an alarm based on a metric math expression, specify ``True`` for this value for only the one math expression that the alarm is based on. You must specify ``False`` for ``ReturnData`` for all the other metrics and expressions used in the alarm.
                This field is required.
        """
        pulumi.set(__self__, "id", id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A short name used to tie this object to the results in the response. This name must be unique within a single call to ``GetMetricData``. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the ``Id`` of the other metrics to refer to those metrics, and can also use the ``Id`` of other expressions to use the result of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
         Within each MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CW dashboard widget, the label is shown. If ``Label`` is omitted, CW generates a default.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional['outputs.AlarmMetricStat']:
        """
        The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
         Within one MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        """
        return pulumi.get(self, "metric_stat")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` operation that includes a ``StorageResolution of 1 second``.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[bool]:
        """
        This option indicates whether to return the timestamps and raw data values of this metric.
         When you create an alarm based on a metric math expression, specify ``True`` for this value for only the one math expression that the alarm is based on. You must specify ``False`` for ``ReturnData`` for all the other metrics and expressions used in the alarm.
         This field is required.
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class AlarmMetricStat(dict):
    """
    This structure defines the metric to be returned, along with the statistics, period, and units.
      ``MetricStat`` is a property of the [MetricDataQuery](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html) property type.
    """
    def __init__(__self__, *,
                 metric: 'outputs.AlarmMetric',
                 period: int,
                 stat: str,
                 unit: Optional[str] = None):
        """
        This structure defines the metric to be returned, along with the statistics, period, and units.
          ``MetricStat`` is a property of the [MetricDataQuery](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html) property type.
        :param 'AlarmMetric' metric: The metric to return, including the metric name, namespace, and dimensions.
        :param int period: The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` call that includes a ``StorageResolution`` of 1 second.
                If the ``StartTime`` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
                 +  Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
                 +  Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
                 +  Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
        :param str stat: The statistic to return. It can include any CW statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *User Guide*.
        :param str unit: The unit to use for the returned data points. 
                Valid values are: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.AlarmMetric':
        """
        The metric to return, including the metric name, namespace, and dimensions.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` call that includes a ``StorageResolution`` of 1 second.
         If the ``StartTime`` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
          +  Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
          +  Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
          +  Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def stat(self) -> str:
        """
        The statistic to return. It can include any CW statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *User Guide*.
        """
        return pulumi.get(self, "stat")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit to use for the returned data points. 
         Valid values are: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class MetricStreamFilter(dict):
    """
    This structure defines the metrics that will be streamed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricNames":
            suggest = "metric_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: str,
                 metric_names: Optional[Sequence[str]] = None):
        """
        This structure defines the metrics that will be streamed.
        :param str namespace: Only metrics with Namespace matching this value will be streamed.
        :param Sequence[str] metric_names: Only metrics with MetricNames matching these values will be streamed. Must be set together with Namespace.
        """
        pulumi.set(__self__, "namespace", namespace)
        if metric_names is not None:
            pulumi.set(__self__, "metric_names", metric_names)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Only metrics with Namespace matching this value will be streamed.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[Sequence[str]]:
        """
        Only metrics with MetricNames matching these values will be streamed. Must be set together with Namespace.
        """
        return pulumi.get(self, "metric_names")


@pulumi.output_type
class MetricStreamStatisticsConfiguration(dict):
    """
    This structure specifies a list of additional statistics to stream, and the metrics to stream those additional statistics for. All metrics that match the combination of metric name and namespace will be streamed with the extended statistics, no matter their dimensions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalStatistics":
            suggest = "additional_statistics"
        elif key == "includeMetrics":
            suggest = "include_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamStatisticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamStatisticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamStatisticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_statistics: Sequence[str],
                 include_metrics: Sequence['outputs.MetricStreamStatisticsMetric']):
        """
        This structure specifies a list of additional statistics to stream, and the metrics to stream those additional statistics for. All metrics that match the combination of metric name and namespace will be streamed with the extended statistics, no matter their dimensions.
        :param Sequence[str] additional_statistics: The additional statistics to stream for the metrics listed in IncludeMetrics.
        :param Sequence['MetricStreamStatisticsMetric'] include_metrics: An array that defines the metrics that are to have additional statistics streamed.
        """
        pulumi.set(__self__, "additional_statistics", additional_statistics)
        pulumi.set(__self__, "include_metrics", include_metrics)

    @property
    @pulumi.getter(name="additionalStatistics")
    def additional_statistics(self) -> Sequence[str]:
        """
        The additional statistics to stream for the metrics listed in IncludeMetrics.
        """
        return pulumi.get(self, "additional_statistics")

    @property
    @pulumi.getter(name="includeMetrics")
    def include_metrics(self) -> Sequence['outputs.MetricStreamStatisticsMetric']:
        """
        An array that defines the metrics that are to have additional statistics streamed.
        """
        return pulumi.get(self, "include_metrics")


@pulumi.output_type
class MetricStreamStatisticsMetric(dict):
    """
    A structure that specifies the metric name and namespace for one metric that is going to have additional statistics included in the stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamStatisticsMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamStatisticsMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamStatisticsMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str):
        """
        A structure that specifies the metric name and namespace for one metric that is going to have additional statistics included in the stream.
        :param str metric_name: The name of the metric.
        :param str namespace: The namespace of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")


