# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AlarmDimensionArgs',
    'AlarmDimensionArgsDict',
    'AlarmMetricDataQueryArgs',
    'AlarmMetricDataQueryArgsDict',
    'AlarmMetricStatArgs',
    'AlarmMetricStatArgsDict',
    'AlarmMetricArgs',
    'AlarmMetricArgsDict',
    'MetricStreamFilterArgs',
    'MetricStreamFilterArgsDict',
    'MetricStreamStatisticsConfigurationArgs',
    'MetricStreamStatisticsConfigurationArgsDict',
    'MetricStreamStatisticsMetricArgs',
    'MetricStreamStatisticsMetricArgsDict',
]

MYPY = False

if not MYPY:
    class AlarmDimensionArgsDict(TypedDict):
        """
        Dimension is an embedded property of the ``AWS::CloudWatch::Alarm`` type. Dimensions are name/value pairs that can be associated with a CW metric. You can specify a maximum of 10 dimensions for a given metric.
        """
        name: pulumi.Input[str]
        """
        The name of the dimension, from 1–255 characters in length. This dimension name must have been included when the metric was published.
        """
        value: pulumi.Input[str]
        """
        The value for the dimension, from 1–255 characters in length.
        """
elif False:
    AlarmDimensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Dimension is an embedded property of the ``AWS::CloudWatch::Alarm`` type. Dimensions are name/value pairs that can be associated with a CW metric. You can specify a maximum of 10 dimensions for a given metric.
        :param pulumi.Input[str] name: The name of the dimension, from 1–255 characters in length. This dimension name must have been included when the metric was published.
        :param pulumi.Input[str] value: The value for the dimension, from 1–255 characters in length.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the dimension, from 1–255 characters in length. This dimension name must have been included when the metric was published.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the dimension, from 1–255 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AlarmMetricDataQueryArgsDict(TypedDict):
        """
        The ``MetricDataQuery`` property type specifies the metric data to return, and whether this call is just retrieving a batch set of data for one metric, or is performing a math expression on metric data. 
         Any expression used must return a single time series. For more information, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
        """
        id: pulumi.Input[str]
        """
        A short name used to tie this object to the results in the response. This name must be unique within a single call to ``GetMetricData``. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        """
        account_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        expression: NotRequired[pulumi.Input[str]]
        """
        The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the ``Id`` of the other metrics to refer to those metrics, and can also use the ``Id`` of other expressions to use the result of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
         Within each MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        """
        label: NotRequired[pulumi.Input[str]]
        """
        A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CW dashboard widget, the label is shown. If ``Label`` is omitted, CW generates a default.
        """
        metric_stat: NotRequired[pulumi.Input['AlarmMetricStatArgsDict']]
        """
        The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
         Within one MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        """
        period: NotRequired[pulumi.Input[int]]
        """
        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` operation that includes a ``StorageResolution of 1 second``.
        """
        return_data: NotRequired[pulumi.Input[bool]]
        """
        This option indicates whether to return the timestamps and raw data values of this metric.
         When you create an alarm based on a metric math expression, specify ``True`` for this value for only the one math expression that the alarm is based on. You must specify ``False`` for ``ReturnData`` for all the other metrics and expressions used in the alarm.
         This field is required.
        """
elif False:
    AlarmMetricDataQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmMetricDataQueryArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 metric_stat: Optional[pulumi.Input['AlarmMetricStatArgs']] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 return_data: Optional[pulumi.Input[bool]] = None):
        """
        The ``MetricDataQuery`` property type specifies the metric data to return, and whether this call is just retrieving a batch set of data for one metric, or is performing a math expression on metric data. 
         Any expression used must return a single time series. For more information, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
        :param pulumi.Input[str] id: A short name used to tie this object to the results in the response. This name must be unique within a single call to ``GetMetricData``. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        :param pulumi.Input[str] account_id: The ID of the account where the metrics are located, if this is a cross-account alarm.
        :param pulumi.Input[str] expression: The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the ``Id`` of the other metrics to refer to those metrics, and can also use the ``Id`` of other expressions to use the result of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
                Within each MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        :param pulumi.Input[str] label: A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CW dashboard widget, the label is shown. If ``Label`` is omitted, CW generates a default.
        :param pulumi.Input['AlarmMetricStatArgs'] metric_stat: The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
                Within one MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        :param pulumi.Input[int] period: The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` operation that includes a ``StorageResolution of 1 second``.
        :param pulumi.Input[bool] return_data: This option indicates whether to return the timestamps and raw data values of this metric.
                When you create an alarm based on a metric math expression, specify ``True`` for this value for only the one math expression that the alarm is based on. You must specify ``False`` for ``ReturnData`` for all the other metrics and expressions used in the alarm.
                This field is required.
        """
        pulumi.set(__self__, "id", id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A short name used to tie this object to the results in the response. This name must be unique within a single call to ``GetMetricData``. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the ``Id`` of the other metrics to refer to those metrics, and can also use the ``Id`` of other expressions to use the result of those expressions. For more information about metric math expressions, see [Metric Math Syntax and Functions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax) in the *User Guide*.
         Within each MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CW dashboard widget, the label is shown. If ``Label`` is omitted, CW generates a default.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional[pulumi.Input['AlarmMetricStatArgs']]:
        """
        The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
         Within one MetricDataQuery object, you must specify either ``Expression`` or ``MetricStat`` but not both.
        """
        return pulumi.get(self, "metric_stat")

    @metric_stat.setter
    def metric_stat(self, value: Optional[pulumi.Input['AlarmMetricStatArgs']]):
        pulumi.set(self, "metric_stat", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` operation that includes a ``StorageResolution of 1 second``.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[pulumi.Input[bool]]:
        """
        This option indicates whether to return the timestamps and raw data values of this metric.
         When you create an alarm based on a metric math expression, specify ``True`` for this value for only the one math expression that the alarm is based on. You must specify ``False`` for ``ReturnData`` for all the other metrics and expressions used in the alarm.
         This field is required.
        """
        return pulumi.get(self, "return_data")

    @return_data.setter
    def return_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_data", value)


if not MYPY:
    class AlarmMetricStatArgsDict(TypedDict):
        """
        This structure defines the metric to be returned, along with the statistics, period, and units.
          ``MetricStat`` is a property of the [MetricDataQuery](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html) property type.
        """
        metric: pulumi.Input['AlarmMetricArgsDict']
        """
        The metric to return, including the metric name, namespace, and dimensions.
        """
        period: pulumi.Input[int]
        """
        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` call that includes a ``StorageResolution`` of 1 second.
         If the ``StartTime`` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
          +  Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
          +  Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
          +  Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
        """
        stat: pulumi.Input[str]
        """
        The statistic to return. It can include any CW statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *User Guide*.
        """
        unit: NotRequired[pulumi.Input[str]]
        """
        The unit to use for the returned data points. 
         Valid values are: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
        """
elif False:
    AlarmMetricStatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmMetricStatArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input['AlarmMetricArgs'],
                 period: pulumi.Input[int],
                 stat: pulumi.Input[str],
                 unit: Optional[pulumi.Input[str]] = None):
        """
        This structure defines the metric to be returned, along with the statistics, period, and units.
          ``MetricStat`` is a property of the [MetricDataQuery](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html) property type.
        :param pulumi.Input['AlarmMetricArgs'] metric: The metric to return, including the metric name, namespace, and dimensions.
        :param pulumi.Input[int] period: The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` call that includes a ``StorageResolution`` of 1 second.
                If the ``StartTime`` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
                 +  Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
                 +  Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
                 +  Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
        :param pulumi.Input[str] stat: The statistic to return. It can include any CW statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *User Guide*.
        :param pulumi.Input[str] unit: The unit to use for the returned data points. 
                Valid values are: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['AlarmMetricArgs']:
        """
        The metric to return, including the metric name, namespace, and dimensions.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['AlarmMetricArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a ``PutMetricData`` call that includes a ``StorageResolution`` of 1 second.
         If the ``StartTime`` parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:
          +  Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).
          +  Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).
          +  Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def stat(self) -> pulumi.Input[str]:
        """
        The statistic to return. It can include any CW statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *User Guide*.
        """
        return pulumi.get(self, "stat")

    @stat.setter
    def stat(self, value: pulumi.Input[str]):
        pulumi.set(self, "stat", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit to use for the returned data points. 
         Valid values are: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


if not MYPY:
    class AlarmMetricArgsDict(TypedDict):
        """
        The ``Metric`` property type represents a specific metric. ``Metric`` is a property of the [MetricStat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html) property type.
        """
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['AlarmDimensionArgsDict']]]]
        """
        The metric dimensions that you want to be used for the metric that the alarm will watch.
        """
        metric_name: NotRequired[pulumi.Input[str]]
        """
        The name of the metric that you want the alarm to watch. This is a required field.
        """
        namespace: NotRequired[pulumi.Input[str]]
        """
        The namespace of the metric that the alarm will watch.
        """
elif False:
    AlarmMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmMetricArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmDimensionArgs']]]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        The ``Metric`` property type represents a specific metric. ``Metric`` is a property of the [MetricStat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html) property type.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmDimensionArgs']]] dimensions: The metric dimensions that you want to be used for the metric that the alarm will watch.
        :param pulumi.Input[str] metric_name: The name of the metric that you want the alarm to watch. This is a required field.
        :param pulumi.Input[str] namespace: The namespace of the metric that the alarm will watch.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmDimensionArgs']]]]:
        """
        The metric dimensions that you want to be used for the metric that the alarm will watch.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the metric that you want the alarm to watch. This is a required field.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the metric that the alarm will watch.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class MetricStreamFilterArgsDict(TypedDict):
        """
        This structure defines the metrics that will be streamed.
        """
        namespace: pulumi.Input[str]
        """
        Only metrics with Namespace matching this value will be streamed.
        """
        metric_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Only metrics with MetricNames matching these values will be streamed. Must be set together with Namespace.
        """
elif False:
    MetricStreamFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricStreamFilterArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 metric_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        This structure defines the metrics that will be streamed.
        :param pulumi.Input[str] namespace: Only metrics with Namespace matching this value will be streamed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metric_names: Only metrics with MetricNames matching these values will be streamed. Must be set together with Namespace.
        """
        pulumi.set(__self__, "namespace", namespace)
        if metric_names is not None:
            pulumi.set(__self__, "metric_names", metric_names)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Only metrics with Namespace matching this value will be streamed.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only metrics with MetricNames matching these values will be streamed. Must be set together with Namespace.
        """
        return pulumi.get(self, "metric_names")

    @metric_names.setter
    def metric_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metric_names", value)


if not MYPY:
    class MetricStreamStatisticsConfigurationArgsDict(TypedDict):
        """
        This structure specifies a list of additional statistics to stream, and the metrics to stream those additional statistics for. All metrics that match the combination of metric name and namespace will be streamed with the extended statistics, no matter their dimensions.
        """
        additional_statistics: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        The additional statistics to stream for the metrics listed in IncludeMetrics.
        """
        include_metrics: pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsMetricArgsDict']]]
        """
        An array that defines the metrics that are to have additional statistics streamed.
        """
elif False:
    MetricStreamStatisticsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricStreamStatisticsConfigurationArgs:
    def __init__(__self__, *,
                 additional_statistics: pulumi.Input[Sequence[pulumi.Input[str]]],
                 include_metrics: pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsMetricArgs']]]):
        """
        This structure specifies a list of additional statistics to stream, and the metrics to stream those additional statistics for. All metrics that match the combination of metric name and namespace will be streamed with the extended statistics, no matter their dimensions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_statistics: The additional statistics to stream for the metrics listed in IncludeMetrics.
        :param pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsMetricArgs']]] include_metrics: An array that defines the metrics that are to have additional statistics streamed.
        """
        pulumi.set(__self__, "additional_statistics", additional_statistics)
        pulumi.set(__self__, "include_metrics", include_metrics)

    @property
    @pulumi.getter(name="additionalStatistics")
    def additional_statistics(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The additional statistics to stream for the metrics listed in IncludeMetrics.
        """
        return pulumi.get(self, "additional_statistics")

    @additional_statistics.setter
    def additional_statistics(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "additional_statistics", value)

    @property
    @pulumi.getter(name="includeMetrics")
    def include_metrics(self) -> pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsMetricArgs']]]:
        """
        An array that defines the metrics that are to have additional statistics streamed.
        """
        return pulumi.get(self, "include_metrics")

    @include_metrics.setter
    def include_metrics(self, value: pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsMetricArgs']]]):
        pulumi.set(self, "include_metrics", value)


if not MYPY:
    class MetricStreamStatisticsMetricArgsDict(TypedDict):
        """
        A structure that specifies the metric name and namespace for one metric that is going to have additional statistics included in the stream.
        """
        metric_name: pulumi.Input[str]
        """
        The name of the metric.
        """
        namespace: pulumi.Input[str]
        """
        The namespace of the metric.
        """
elif False:
    MetricStreamStatisticsMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricStreamStatisticsMetricArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        A structure that specifies the metric name and namespace for one metric that is going to have additional statistics included in the stream.
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


