# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetEventDataStoreResult',
    'AwaitableGetEventDataStoreResult',
    'get_event_data_store',
    'get_event_data_store_output',
]

@pulumi.output_type
class GetEventDataStoreResult:
    def __init__(__self__, advanced_event_selectors=None, billing_mode=None, created_timestamp=None, event_data_store_arn=None, federation_enabled=None, federation_role_arn=None, ingestion_enabled=None, insight_selectors=None, insights_destination=None, kms_key_id=None, multi_region_enabled=None, name=None, organization_enabled=None, retention_period=None, status=None, tags=None, termination_protection_enabled=None, updated_timestamp=None):
        if advanced_event_selectors and not isinstance(advanced_event_selectors, list):
            raise TypeError("Expected argument 'advanced_event_selectors' to be a list")
        pulumi.set(__self__, "advanced_event_selectors", advanced_event_selectors)
        if billing_mode and not isinstance(billing_mode, str):
            raise TypeError("Expected argument 'billing_mode' to be a str")
        pulumi.set(__self__, "billing_mode", billing_mode)
        if created_timestamp and not isinstance(created_timestamp, str):
            raise TypeError("Expected argument 'created_timestamp' to be a str")
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        if event_data_store_arn and not isinstance(event_data_store_arn, str):
            raise TypeError("Expected argument 'event_data_store_arn' to be a str")
        pulumi.set(__self__, "event_data_store_arn", event_data_store_arn)
        if federation_enabled and not isinstance(federation_enabled, bool):
            raise TypeError("Expected argument 'federation_enabled' to be a bool")
        pulumi.set(__self__, "federation_enabled", federation_enabled)
        if federation_role_arn and not isinstance(federation_role_arn, str):
            raise TypeError("Expected argument 'federation_role_arn' to be a str")
        pulumi.set(__self__, "federation_role_arn", federation_role_arn)
        if ingestion_enabled and not isinstance(ingestion_enabled, bool):
            raise TypeError("Expected argument 'ingestion_enabled' to be a bool")
        pulumi.set(__self__, "ingestion_enabled", ingestion_enabled)
        if insight_selectors and not isinstance(insight_selectors, list):
            raise TypeError("Expected argument 'insight_selectors' to be a list")
        pulumi.set(__self__, "insight_selectors", insight_selectors)
        if insights_destination and not isinstance(insights_destination, str):
            raise TypeError("Expected argument 'insights_destination' to be a str")
        pulumi.set(__self__, "insights_destination", insights_destination)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if multi_region_enabled and not isinstance(multi_region_enabled, bool):
            raise TypeError("Expected argument 'multi_region_enabled' to be a bool")
        pulumi.set(__self__, "multi_region_enabled", multi_region_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_enabled and not isinstance(organization_enabled, bool):
            raise TypeError("Expected argument 'organization_enabled' to be a bool")
        pulumi.set(__self__, "organization_enabled", organization_enabled)
        if retention_period and not isinstance(retention_period, int):
            raise TypeError("Expected argument 'retention_period' to be a int")
        pulumi.set(__self__, "retention_period", retention_period)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if termination_protection_enabled and not isinstance(termination_protection_enabled, bool):
            raise TypeError("Expected argument 'termination_protection_enabled' to be a bool")
        pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if updated_timestamp and not isinstance(updated_timestamp, str):
            raise TypeError("Expected argument 'updated_timestamp' to be a str")
        pulumi.set(__self__, "updated_timestamp", updated_timestamp)

    @property
    @pulumi.getter(name="advancedEventSelectors")
    def advanced_event_selectors(self) -> Optional[Sequence['outputs.EventDataStoreAdvancedEventSelector']]:
        """
        The advanced event selectors that were used to select events for the data store.
        """
        return pulumi.get(self, "advanced_event_selectors")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[str]:
        """
        The mode that the event data store will use to charge for event storage.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> Optional[str]:
        """
        The timestamp of the event data store's creation.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="eventDataStoreArn")
    def event_data_store_arn(self) -> Optional[str]:
        """
        The ARN of the event data store.
        """
        return pulumi.get(self, "event_data_store_arn")

    @property
    @pulumi.getter(name="federationEnabled")
    def federation_enabled(self) -> Optional[bool]:
        """
        Indicates whether federation is enabled on an event data store.
        """
        return pulumi.get(self, "federation_enabled")

    @property
    @pulumi.getter(name="federationRoleArn")
    def federation_role_arn(self) -> Optional[str]:
        """
        The ARN of the role used for event data store federation.
        """
        return pulumi.get(self, "federation_role_arn")

    @property
    @pulumi.getter(name="ingestionEnabled")
    def ingestion_enabled(self) -> Optional[bool]:
        """
        Indicates whether the event data store is ingesting events.
        """
        return pulumi.get(self, "ingestion_enabled")

    @property
    @pulumi.getter(name="insightSelectors")
    def insight_selectors(self) -> Optional[Sequence['outputs.EventDataStoreInsightSelector']]:
        """
        Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing event data store. Both InsightSelectors and InsightsDestination need to have a value in order to enable Insights events on an event data store.
        """
        return pulumi.get(self, "insight_selectors")

    @property
    @pulumi.getter(name="insightsDestination")
    def insights_destination(self) -> Optional[str]:
        """
        Specifies the ARN of the event data store that will collect Insights events. Both InsightSelectors and InsightsDestination need to have a value in order to enable Insights events on an event data store
        """
        return pulumi.get(self, "insights_destination")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by 'alias/', a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="multiRegionEnabled")
    def multi_region_enabled(self) -> Optional[bool]:
        """
        Indicates whether the event data store includes events from all regions, or only from the region in which it was created.
        """
        return pulumi.get(self, "multi_region_enabled")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the event data store.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationEnabled")
    def organization_enabled(self) -> Optional[bool]:
        """
        Indicates that an event data store is collecting logged events for an organization.
        """
        return pulumi.get(self, "organization_enabled")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[int]:
        """
        The retention period, in days.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of an event data store. Values are STARTING_INGESTION, ENABLED, STOPPING_INGESTION, STOPPED_INGESTION and PENDING_DELETION.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[bool]:
        """
        Indicates whether the event data store is protected from termination.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @property
    @pulumi.getter(name="updatedTimestamp")
    def updated_timestamp(self) -> Optional[str]:
        """
        The timestamp showing when an event data store was updated, if applicable. UpdatedTimestamp is always either the same or newer than the time shown in CreatedTimestamp.
        """
        return pulumi.get(self, "updated_timestamp")


class AwaitableGetEventDataStoreResult(GetEventDataStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventDataStoreResult(
            advanced_event_selectors=self.advanced_event_selectors,
            billing_mode=self.billing_mode,
            created_timestamp=self.created_timestamp,
            event_data_store_arn=self.event_data_store_arn,
            federation_enabled=self.federation_enabled,
            federation_role_arn=self.federation_role_arn,
            ingestion_enabled=self.ingestion_enabled,
            insight_selectors=self.insight_selectors,
            insights_destination=self.insights_destination,
            kms_key_id=self.kms_key_id,
            multi_region_enabled=self.multi_region_enabled,
            name=self.name,
            organization_enabled=self.organization_enabled,
            retention_period=self.retention_period,
            status=self.status,
            tags=self.tags,
            termination_protection_enabled=self.termination_protection_enabled,
            updated_timestamp=self.updated_timestamp)


def get_event_data_store(event_data_store_arn: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventDataStoreResult:
    """
    A storage lake of event data against which you can run complex SQL-based queries. An event data store can include events that you have logged on your account from the last 7 to 2557 or 3653 days (about seven or ten years) depending on the selected BillingMode.


    :param str event_data_store_arn: The ARN of the event data store.
    """
    __args__ = dict()
    __args__['eventDataStoreArn'] = event_data_store_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudtrail:getEventDataStore', __args__, opts=opts, typ=GetEventDataStoreResult).value

    return AwaitableGetEventDataStoreResult(
        advanced_event_selectors=pulumi.get(__ret__, 'advanced_event_selectors'),
        billing_mode=pulumi.get(__ret__, 'billing_mode'),
        created_timestamp=pulumi.get(__ret__, 'created_timestamp'),
        event_data_store_arn=pulumi.get(__ret__, 'event_data_store_arn'),
        federation_enabled=pulumi.get(__ret__, 'federation_enabled'),
        federation_role_arn=pulumi.get(__ret__, 'federation_role_arn'),
        ingestion_enabled=pulumi.get(__ret__, 'ingestion_enabled'),
        insight_selectors=pulumi.get(__ret__, 'insight_selectors'),
        insights_destination=pulumi.get(__ret__, 'insights_destination'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        multi_region_enabled=pulumi.get(__ret__, 'multi_region_enabled'),
        name=pulumi.get(__ret__, 'name'),
        organization_enabled=pulumi.get(__ret__, 'organization_enabled'),
        retention_period=pulumi.get(__ret__, 'retention_period'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        termination_protection_enabled=pulumi.get(__ret__, 'termination_protection_enabled'),
        updated_timestamp=pulumi.get(__ret__, 'updated_timestamp'))
def get_event_data_store_output(event_data_store_arn: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventDataStoreResult]:
    """
    A storage lake of event data against which you can run complex SQL-based queries. An event data store can include events that you have logged on your account from the last 7 to 2557 or 3653 days (about seven or ten years) depending on the selected BillingMode.


    :param str event_data_store_arn: The ARN of the event data store.
    """
    __args__ = dict()
    __args__['eventDataStoreArn'] = event_data_store_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudtrail:getEventDataStore', __args__, opts=opts, typ=GetEventDataStoreResult)
    return __ret__.apply(lambda __response__: GetEventDataStoreResult(
        advanced_event_selectors=pulumi.get(__response__, 'advanced_event_selectors'),
        billing_mode=pulumi.get(__response__, 'billing_mode'),
        created_timestamp=pulumi.get(__response__, 'created_timestamp'),
        event_data_store_arn=pulumi.get(__response__, 'event_data_store_arn'),
        federation_enabled=pulumi.get(__response__, 'federation_enabled'),
        federation_role_arn=pulumi.get(__response__, 'federation_role_arn'),
        ingestion_enabled=pulumi.get(__response__, 'ingestion_enabled'),
        insight_selectors=pulumi.get(__response__, 'insight_selectors'),
        insights_destination=pulumi.get(__response__, 'insights_destination'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        multi_region_enabled=pulumi.get(__response__, 'multi_region_enabled'),
        name=pulumi.get(__response__, 'name'),
        organization_enabled=pulumi.get(__response__, 'organization_enabled'),
        retention_period=pulumi.get(__response__, 'retention_period'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        termination_protection_enabled=pulumi.get(__response__, 'termination_protection_enabled'),
        updated_timestamp=pulumi.get(__response__, 'updated_timestamp')))
