# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCachePolicyResult',
    'AwaitableGetCachePolicyResult',
    'get_cache_policy',
    'get_cache_policy_output',
]

@pulumi.output_type
class GetCachePolicyResult:
    def __init__(__self__, cache_policy_config=None, id=None, last_modified_time=None):
        if cache_policy_config and not isinstance(cache_policy_config, dict):
            raise TypeError("Expected argument 'cache_policy_config' to be a dict")
        pulumi.set(__self__, "cache_policy_config", cache_policy_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)

    @property
    @pulumi.getter(name="cachePolicyConfig")
    def cache_policy_config(self) -> Optional['outputs.CachePolicyConfig']:
        """
        The cache policy configuration.
        """
        return pulumi.get(self, "cache_policy_config")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique identifier for the cache policy. For example: `2766f7b2-75c5-41c6-8f06-bf4303a2f2f5` .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[str]:
        """
        The date and time when the cache policy was last modified.
        """
        return pulumi.get(self, "last_modified_time")


class AwaitableGetCachePolicyResult(GetCachePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCachePolicyResult(
            cache_policy_config=self.cache_policy_config,
            id=self.id,
            last_modified_time=self.last_modified_time)


def get_cache_policy(id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCachePolicyResult:
    """
    Resource Type definition for AWS::CloudFront::CachePolicy


    :param str id: The unique identifier for the cache policy. For example: `2766f7b2-75c5-41c6-8f06-bf4303a2f2f5` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudfront:getCachePolicy', __args__, opts=opts, typ=GetCachePolicyResult).value

    return AwaitableGetCachePolicyResult(
        cache_policy_config=pulumi.get(__ret__, 'cache_policy_config'),
        id=pulumi.get(__ret__, 'id'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'))
def get_cache_policy_output(id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCachePolicyResult]:
    """
    Resource Type definition for AWS::CloudFront::CachePolicy


    :param str id: The unique identifier for the cache policy. For example: `2766f7b2-75c5-41c6-8f06-bf4303a2f2f5` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudfront:getCachePolicy', __args__, opts=opts, typ=GetCachePolicyResult)
    return __ret__.apply(lambda __response__: GetCachePolicyResult(
        cache_policy_config=pulumi.get(__response__, 'cache_policy_config'),
        id=pulumi.get(__response__, 'id'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time')))
