# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HookDefaultVersionArgs', 'HookDefaultVersion']

@pulumi.input_type
class HookDefaultVersionArgs:
    def __init__(__self__, *,
                 type_name: Optional[pulumi.Input[str]] = None,
                 type_version_arn: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HookDefaultVersion resource.
        :param pulumi.Input[str] type_name: The name of the type being registered.
               
               We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        :param pulumi.Input[str] type_version_arn: The Amazon Resource Name (ARN) of the type version.
        :param pulumi.Input[str] version_id: The ID of an existing version of the hook to set as the default.
        """
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)
        if type_version_arn is not None:
            pulumi.set(__self__, "type_version_arn", type_version_arn)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the type being registered.

        We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_name", value)

    @property
    @pulumi.getter(name="typeVersionArn")
    def type_version_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the type version.
        """
        return pulumi.get(self, "type_version_arn")

    @type_version_arn.setter
    def type_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_version_arn", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an existing version of the hook to set as the default.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class HookDefaultVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 type_name: Optional[pulumi.Input[str]] = None,
                 type_version_arn: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Set a version as default version for a hook in CloudFormation Registry.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion", type_version_arn="arn:aws:cloudformation:us-west-2:123456789012:type/hook/My-Sample-Hook/00000001")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion", type_version_arn="arn:aws:cloudformation:us-west-2:123456789012:type/hook/My-Sample-Hook/00000001")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion",
            type_name="My::Sample::Hook",
            version_id="1")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion",
            type_name="My::Sample::Hook",
            version_id="1")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] type_name: The name of the type being registered.
               
               We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        :param pulumi.Input[str] type_version_arn: The Amazon Resource Name (ARN) of the type version.
        :param pulumi.Input[str] version_id: The ID of an existing version of the hook to set as the default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[HookDefaultVersionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Set a version as default version for a hook in CloudFormation Registry.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion", type_version_arn="arn:aws:cloudformation:us-west-2:123456789012:type/hook/My-Sample-Hook/00000001")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion", type_version_arn="arn:aws:cloudformation:us-west-2:123456789012:type/hook/My-Sample-Hook/00000001")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion",
            type_name="My::Sample::Hook",
            version_id="1")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        hook_default_version = aws_native.cloudformation.HookDefaultVersion("hookDefaultVersion",
            type_name="My::Sample::Hook",
            version_id="1")

        ```

        :param str resource_name: The name of the resource.
        :param HookDefaultVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HookDefaultVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 type_name: Optional[pulumi.Input[str]] = None,
                 type_version_arn: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HookDefaultVersionArgs.__new__(HookDefaultVersionArgs)

            __props__.__dict__["type_name"] = type_name
            __props__.__dict__["type_version_arn"] = type_version_arn
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["arn"] = None
        super(HookDefaultVersion, __self__).__init__(
            'aws-native:cloudformation:HookDefaultVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HookDefaultVersion':
        """
        Get an existing HookDefaultVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HookDefaultVersionArgs.__new__(HookDefaultVersionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["type_name"] = None
        __props__.__dict__["type_version_arn"] = None
        __props__.__dict__["version_id"] = None
        return HookDefaultVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the type. This is used to uniquely identify a HookDefaultVersion
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the type being registered.

        We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter(name="typeVersionArn")
    def type_version_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the type version.
        """
        return pulumi.get(self, "type_version_arn")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of an existing version of the hook to set as the default.
        """
        return pulumi.get(self, "version_id")

