# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'HookVersionLoggingConfigArgs',
    'HookVersionLoggingConfigArgsDict',
    'ManagedExecutionPropertiesArgs',
    'ManagedExecutionPropertiesArgsDict',
    'ResourceVersionLoggingConfigArgs',
    'ResourceVersionLoggingConfigArgsDict',
    'StackSetAutoDeploymentArgs',
    'StackSetAutoDeploymentArgsDict',
    'StackSetDeploymentTargetsArgs',
    'StackSetDeploymentTargetsArgsDict',
    'StackSetOperationPreferencesArgs',
    'StackSetOperationPreferencesArgsDict',
    'StackSetParameterArgs',
    'StackSetParameterArgsDict',
    'StackSetStackInstancesArgs',
    'StackSetStackInstancesArgsDict',
    'TypeActivationLoggingConfigArgs',
    'TypeActivationLoggingConfigArgsDict',
]

MYPY = False

if not MYPY:
    class HookVersionLoggingConfigArgsDict(TypedDict):
        log_group_name: NotRequired[pulumi.Input[str]]
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        log_role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
elif False:
    HookVersionLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HookVersionLoggingConfigArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[str]] = None,
                 log_role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param pulumi.Input[str] log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")

    @log_role_arn.setter
    def log_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_role_arn", value)


if not MYPY:
    class ManagedExecutionPropertiesArgsDict(TypedDict):
        """
        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
        """
        active: NotRequired[pulumi.Input[bool]]
        """
        When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.

        > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
        > 
        > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 

        When `false` (default), StackSets performs one operation at a time in request order.
        """
elif False:
    ManagedExecutionPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedExecutionPropertiesArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None):
        """
        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
        :param pulumi.Input[bool] active: When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.
               
               > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
               > 
               > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 
               
               When `false` (default), StackSets performs one operation at a time in request order.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        When `true` , StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.

        > If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.
        > 
        > You can't modify your stack set's execution configuration while there are running or queued operations for that stack set. 

        When `false` (default), StackSets performs one operation at a time in request order.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)


if not MYPY:
    class ResourceVersionLoggingConfigArgsDict(TypedDict):
        log_group_name: NotRequired[pulumi.Input[str]]
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        log_role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
elif False:
    ResourceVersionLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceVersionLoggingConfigArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[str]] = None,
                 log_role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param pulumi.Input[str] log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")

    @log_role_arn.setter
    def log_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_role_arn", value)


if not MYPY:
    class StackSetAutoDeploymentArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        """
        retain_stacks_on_account_removal: NotRequired[pulumi.Input[bool]]
        """
        If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
elif False:
    StackSetAutoDeploymentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetAutoDeploymentArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 retain_stacks_on_account_removal: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        :param pulumi.Input[bool] retain_stacks_on_account_removal: If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retain_stacks_on_account_removal is not None:
            pulumi.set(__self__, "retain_stacks_on_account_removal", retain_stacks_on_account_removal)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="retainStacksOnAccountRemoval")
    def retain_stacks_on_account_removal(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, stack resources are retained when an account is removed from a target organization or OU. If set to false, stack resources are deleted. Specify only if Enabled is set to True.
        """
        return pulumi.get(self, "retain_stacks_on_account_removal")

    @retain_stacks_on_account_removal.setter
    def retain_stacks_on_account_removal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "retain_stacks_on_account_removal", value)


if not MYPY:
    class StackSetDeploymentTargetsArgsDict(TypedDict):
        """
         The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
        """
        account_filter_type: NotRequired[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']]
        """
        The filter type you want to apply on organizational units and accounts.
        """
        accounts: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        AWS accounts that you want to create stack instances in the specified Region(s) for.
        """
        accounts_url: NotRequired[pulumi.Input[str]]
        """
        Returns the value of the AccountsUrl property.
        """
        organizational_unit_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
elif False:
    StackSetDeploymentTargetsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetDeploymentTargetsArgs:
    def __init__(__self__, *,
                 account_filter_type: Optional[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 accounts_url: Optional[pulumi.Input[str]] = None,
                 organizational_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
         The AWS OrganizationalUnitIds or Accounts for which to create stack instances in the specified Regions.
        :param pulumi.Input['StackSetDeploymentTargetsAccountFilterType'] account_filter_type: The filter type you want to apply on organizational units and accounts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] accounts: AWS accounts that you want to create stack instances in the specified Region(s) for.
        :param pulumi.Input[str] accounts_url: Returns the value of the AccountsUrl property.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] organizational_unit_ids: The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        if account_filter_type is not None:
            pulumi.set(__self__, "account_filter_type", account_filter_type)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if accounts_url is not None:
            pulumi.set(__self__, "accounts_url", accounts_url)
        if organizational_unit_ids is not None:
            pulumi.set(__self__, "organizational_unit_ids", organizational_unit_ids)

    @property
    @pulumi.getter(name="accountFilterType")
    def account_filter_type(self) -> Optional[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']]:
        """
        The filter type you want to apply on organizational units and accounts.
        """
        return pulumi.get(self, "account_filter_type")

    @account_filter_type.setter
    def account_filter_type(self, value: Optional[pulumi.Input['StackSetDeploymentTargetsAccountFilterType']]):
        pulumi.set(self, "account_filter_type", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AWS accounts that you want to create stack instances in the specified Region(s) for.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="accountsUrl")
    def accounts_url(self) -> Optional[pulumi.Input[str]]:
        """
        Returns the value of the AccountsUrl property.
        """
        return pulumi.get(self, "accounts_url")

    @accounts_url.setter
    def accounts_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accounts_url", value)

    @property
    @pulumi.getter(name="organizationalUnitIds")
    def organizational_unit_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        return pulumi.get(self, "organizational_unit_ids")

    @organizational_unit_ids.setter
    def organizational_unit_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "organizational_unit_ids", value)


if not MYPY:
    class StackSetOperationPreferencesArgsDict(TypedDict):
        """
        The user-specified preferences for how AWS CloudFormation performs a stack set operation.
        """
        concurrency_mode: NotRequired[pulumi.Input['StackSetConcurrencyMode']]
        """
        Specifies how the concurrency level behaves during the operation execution.

        - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.

        If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
        - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        """
        failure_tolerance_count: NotRequired[pulumi.Input[int]]
        """
        The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        """
        failure_tolerance_percentage: NotRequired[pulumi.Input[int]]
        """
        The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.

        When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds *down* to the next whole number.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        """
        max_concurrent_count: NotRequired[pulumi.Input[int]]
        """
        The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        max_concurrent_percentage: NotRequired[pulumi.Input[int]]
        """
        The maximum percentage of accounts in which to perform this operation at one time.

        When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        region_concurrency_type: NotRequired[pulumi.Input['StackSetRegionConcurrencyType']]
        """
        The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        """
        region_order: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The order of the Regions where you want to perform the stack operation.

        > `RegionOrder` isn't followed if `AutoDeployment` is enabled.
        """
elif False:
    StackSetOperationPreferencesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetOperationPreferencesArgs:
    def __init__(__self__, *,
                 concurrency_mode: Optional[pulumi.Input['StackSetConcurrencyMode']] = None,
                 failure_tolerance_count: Optional[pulumi.Input[int]] = None,
                 failure_tolerance_percentage: Optional[pulumi.Input[int]] = None,
                 max_concurrent_count: Optional[pulumi.Input[int]] = None,
                 max_concurrent_percentage: Optional[pulumi.Input[int]] = None,
                 region_concurrency_type: Optional[pulumi.Input['StackSetRegionConcurrencyType']] = None,
                 region_order: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The user-specified preferences for how AWS CloudFormation performs a stack set operation.
        :param pulumi.Input['StackSetConcurrencyMode'] concurrency_mode: Specifies how the concurrency level behaves during the operation execution.
               
               - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.
               
               If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
               - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        :param pulumi.Input[int] failure_tolerance_count: The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.
               
               Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        :param pulumi.Input[int] failure_tolerance_percentage: The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.
               
               When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds *down* to the next whole number.
               
               Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        :param pulumi.Input[int] max_concurrent_count: The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .
               
               Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        :param pulumi.Input[int] max_concurrent_percentage: The maximum percentage of accounts in which to perform this operation at one time.
               
               When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.
               
               Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        :param pulumi.Input['StackSetRegionConcurrencyType'] region_concurrency_type: The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] region_order: The order of the Regions where you want to perform the stack operation.
               
               > `RegionOrder` isn't followed if `AutoDeployment` is enabled.
        """
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrent_count is not None:
            pulumi.set(__self__, "max_concurrent_count", max_concurrent_count)
        if max_concurrent_percentage is not None:
            pulumi.set(__self__, "max_concurrent_percentage", max_concurrent_percentage)
        if region_concurrency_type is not None:
            pulumi.set(__self__, "region_concurrency_type", region_concurrency_type)
        if region_order is not None:
            pulumi.set(__self__, "region_order", region_order)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input['StackSetConcurrencyMode']]:
        """
        Specifies how the concurrency level behaves during the operation execution.

        - `STRICT_FAILURE_TOLERANCE` : This option dynamically lowers the concurrency level to ensure the number of failed accounts never exceeds the value of `FailureToleranceCount` +1. The initial actual concurrency is set to the lower of either the value of the `MaxConcurrentCount` , or the value of `FailureToleranceCount` +1. The actual concurrency is then reduced proportionally by the number of failures. This is the default behavior.

        If failure tolerance or Maximum concurrent accounts are set to percentages, the behavior is similar.
        - `SOFT_FAILURE_TOLERANCE` : This option decouples `FailureToleranceCount` from the actual concurrency. This allows stack set operations to run at the concurrency level set by the `MaxConcurrentCount` value, or `MaxConcurrentPercentage` , regardless of the number of failures.
        """
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input['StackSetConcurrencyMode']]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` (but not both).
        """
        return pulumi.get(self, "failure_tolerance_count")

    @failure_tolerance_count.setter
    def failure_tolerance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_tolerance_count", value)

    @property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in any subsequent Regions.

        When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds *down* to the next whole number.

        Conditional: You must specify either `FailureToleranceCount` or `FailureTolerancePercentage` , but not both.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @failure_tolerance_percentage.setter
    def failure_tolerance_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_tolerance_percentage", value)

    @property
    @pulumi.getter(name="maxConcurrentCount")
    def max_concurrent_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `FailureToleranceCount` . `MaxConcurrentCount` is at most one more than the `FailureToleranceCount` .

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "max_concurrent_count")

    @max_concurrent_count.setter
    def max_concurrent_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_count", value)

    @property
    @pulumi.getter(name="maxConcurrentPercentage")
    def max_concurrent_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum percentage of accounts in which to perform this operation at one time.

        When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.

        Note that this setting lets you specify the *maximum* for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Conditional: You must specify either `MaxConcurrentCount` or `MaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "max_concurrent_percentage")

    @max_concurrent_percentage.setter
    def max_concurrent_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_percentage", value)

    @property
    @pulumi.getter(name="regionConcurrencyType")
    def region_concurrency_type(self) -> Optional[pulumi.Input['StackSetRegionConcurrencyType']]:
        """
        The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        """
        return pulumi.get(self, "region_concurrency_type")

    @region_concurrency_type.setter
    def region_concurrency_type(self, value: Optional[pulumi.Input['StackSetRegionConcurrencyType']]):
        pulumi.set(self, "region_concurrency_type", value)

    @property
    @pulumi.getter(name="regionOrder")
    def region_order(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The order of the Regions where you want to perform the stack operation.

        > `RegionOrder` isn't followed if `AutoDeployment` is enabled.
        """
        return pulumi.get(self, "region_order")

    @region_order.setter
    def region_order(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "region_order", value)


if not MYPY:
    class StackSetParameterArgsDict(TypedDict):
        parameter_key: pulumi.Input[str]
        """
        The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        """
        parameter_value: pulumi.Input[str]
        """
        The input value associated with the parameter.
        """
elif False:
    StackSetParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetParameterArgs:
    def __init__(__self__, *,
                 parameter_key: pulumi.Input[str],
                 parameter_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] parameter_key: The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        :param pulumi.Input[str] parameter_value: The input value associated with the parameter.
        """
        pulumi.set(__self__, "parameter_key", parameter_key)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> pulumi.Input[str]:
        """
        The key associated with the parameter. If you don't specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.
        """
        return pulumi.get(self, "parameter_key")

    @parameter_key.setter
    def parameter_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_key", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[str]:
        """
        The input value associated with the parameter.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class StackSetStackInstancesArgsDict(TypedDict):
        """
        Stack instances in some specific accounts and Regions.
        """
        deployment_targets: pulumi.Input['StackSetDeploymentTargetsArgsDict']
        """
        The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        """
        regions: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        """
        parameter_overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgsDict']]]]
        """
        A list of stack set parameters whose values you want to override in the selected stack instances.
        """
elif False:
    StackSetStackInstancesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackSetStackInstancesArgs:
    def __init__(__self__, *,
                 deployment_targets: pulumi.Input['StackSetDeploymentTargetsArgs'],
                 regions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]]] = None):
        """
        Stack instances in some specific accounts and Regions.
        :param pulumi.Input['StackSetDeploymentTargetsArgs'] deployment_targets: The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        :param pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]] parameter_overrides: A list of stack set parameters whose values you want to override in the selected stack instances.
        """
        pulumi.set(__self__, "deployment_targets", deployment_targets)
        pulumi.set(__self__, "regions", regions)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> pulumi.Input['StackSetDeploymentTargetsArgs']:
        """
        The AWS `OrganizationalUnitIds` or `Accounts` for which to create stack instances in the specified Regions.
        """
        return pulumi.get(self, "deployment_targets")

    @deployment_targets.setter
    def deployment_targets(self, value: pulumi.Input['StackSetDeploymentTargetsArgs']):
        pulumi.set(self, "deployment_targets", value)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The names of one or more Regions where you want to create stack instances using the specified AWS account(s).
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]]]:
        """
        A list of stack set parameters whose values you want to override in the selected stack instances.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackSetParameterArgs']]]]):
        pulumi.set(self, "parameter_overrides", value)


if not MYPY:
    class TypeActivationLoggingConfigArgsDict(TypedDict):
        log_group_name: NotRequired[pulumi.Input[str]]
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        log_role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
elif False:
    TypeActivationLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TypeActivationLoggingConfigArgs:
    def __init__(__self__, *,
                 log_group_name: Optional[pulumi.Input[str]] = None,
                 log_role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] log_group_name: The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        :param pulumi.Input[str] log_role_arn: The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_role_arn is not None:
            pulumi.set(__self__, "log_role_arn", log_role_arn)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_name", value)

    @property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
        """
        return pulumi.get(self, "log_role_arn")

    @log_role_arn.setter
    def log_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_role_arn", value)


