# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TrainingDatasetArgs', 'TrainingDataset']

@pulumi.input_type
class TrainingDatasetArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 training_data: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetDatasetArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a TrainingDataset resource.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the `dataSource` field of each dataset.
               
               Passing a role across accounts is not allowed. If you pass a role that isn't in your account, you get an `AccessDeniedException` error.
        :param pulumi.Input[Sequence[pulumi.Input['TrainingDatasetDatasetArgs']]] training_data: An array of information that lists the Dataset objects, which specifies the dataset type and details on its location and schema. You must provide a role that has read access to these tables.
        :param pulumi.Input[str] description: The description of the training dataset.
        :param pulumi.Input[str] name: The name of the training dataset.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms-ml training dataset.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "training_data", training_data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the `dataSource` field of each dataset.

        Passing a role across accounts is not allowed. If you pass a role that isn't in your account, you get an `AccessDeniedException` error.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input[Sequence[pulumi.Input['TrainingDatasetDatasetArgs']]]:
        """
        An array of information that lists the Dataset objects, which specifies the dataset type and details on its location and schema. You must provide a role that has read access to these tables.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input[Sequence[pulumi.Input['TrainingDatasetDatasetArgs']]]):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the training dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the training dataset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms-ml training dataset.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class TrainingDataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 training_data: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrainingDatasetDatasetArgs', 'TrainingDatasetDatasetArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::CleanRoomsML::TrainingDataset Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the training dataset.
        :param pulumi.Input[str] name: The name of the training dataset.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the `dataSource` field of each dataset.
               
               Passing a role across accounts is not allowed. If you pass a role that isn't in your account, you get an `AccessDeniedException` error.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms-ml training dataset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrainingDatasetDatasetArgs', 'TrainingDatasetDatasetArgsDict']]]] training_data: An array of information that lists the Dataset objects, which specifies the dataset type and details on its location and schema. You must provide a role that has read access to these tables.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrainingDatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::CleanRoomsML::TrainingDataset Resource Type

        :param str resource_name: The name of the resource.
        :param TrainingDatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrainingDatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 training_data: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrainingDatasetDatasetArgs', 'TrainingDatasetDatasetArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrainingDatasetArgs.__new__(TrainingDatasetArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            if training_data is None and not opts.urn:
                raise TypeError("Missing required property 'training_data'")
            __props__.__dict__["training_data"] = training_data
            __props__.__dict__["status"] = None
            __props__.__dict__["training_dataset_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["description", "name", "roleArn", "trainingData[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TrainingDataset, __self__).__init__(
            'aws-native:cleanroomsml:TrainingDataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TrainingDataset':
        """
        Get an existing TrainingDataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TrainingDatasetArgs.__new__(TrainingDatasetArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["training_data"] = None
        __props__.__dict__["training_dataset_arn"] = None
        return TrainingDataset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the training dataset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the training dataset.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the `dataSource` field of each dataset.

        Passing a role across accounts is not allowed. If you pass a role that isn't in your account, you get an `AccessDeniedException` error.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['TrainingDatasetStatus']:
        """
        The status of the training dataset.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms-ml training dataset.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Output[Sequence['outputs.TrainingDatasetDataset']]:
        """
        An array of information that lists the Dataset objects, which specifies the dataset type and details on its location and schema. You must provide a role that has read access to these tables.
        """
        return pulumi.get(self, "training_data")

    @property
    @pulumi.getter(name="trainingDatasetArn")
    def training_dataset_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the training dataset.
        """
        return pulumi.get(self, "training_dataset_arn")

