# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AnalysisTemplateAnalysisParameter',
    'AnalysisTemplateAnalysisSchema',
    'AnalysisTemplateAnalysisSource',
    'CollaborationDataEncryptionMetadata',
    'CollaborationMemberSpecification',
    'CollaborationPaymentConfiguration',
    'CollaborationQueryComputePaymentConfig',
    'ConfiguredTableAggregateColumn',
    'ConfiguredTableAggregationConstraint',
    'ConfiguredTableAnalysisRule',
    'ConfiguredTableAnalysisRuleAggregation',
    'ConfiguredTableAnalysisRuleCustom',
    'ConfiguredTableAnalysisRuleList',
    'ConfiguredTableAnalysisRulePolicy',
    'ConfiguredTableAnalysisRulePolicyV10Properties',
    'ConfiguredTableAnalysisRulePolicyV11Properties',
    'ConfiguredTableAnalysisRulePolicyV12Properties',
    'ConfiguredTableAssociationAnalysisRule',
    'ConfiguredTableAssociationAnalysisRuleAggregation',
    'ConfiguredTableAssociationAnalysisRuleCustom',
    'ConfiguredTableAssociationAnalysisRuleList',
    'ConfiguredTableAssociationAnalysisRulePolicy',
    'ConfiguredTableAssociationAnalysisRulePolicyV10Properties',
    'ConfiguredTableAssociationAnalysisRulePolicyV11Properties',
    'ConfiguredTableAssociationAnalysisRulePolicyV12Properties',
    'ConfiguredTableDifferentialPrivacy',
    'ConfiguredTableDifferentialPrivacyColumn',
    'ConfiguredTableGlueTableReference',
    'ConfiguredTableTableReference',
    'IdMappingTableInputReferenceConfig',
    'IdMappingTableInputReferenceProperties',
    'IdMappingTableInputSource',
    'IdNamespaceAssociationDocument',
    'IdNamespaceAssociationIdMappingConfig',
    'IdNamespaceAssociationInputReferenceConfig',
    'IdNamespaceAssociationInputReferenceProperties',
    'MembershipPaymentConfiguration',
    'MembershipProtectedQueryOutputConfiguration',
    'MembershipProtectedQueryResultConfiguration',
    'MembershipProtectedQueryS3OutputConfiguration',
    'MembershipQueryComputePaymentConfig',
    'ParametersProperties',
]

@pulumi.output_type
class AnalysisTemplateAnalysisParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisTemplateAnalysisParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisTemplateAnalysisParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisTemplateAnalysisParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: 'AnalysisTemplateAnalysisParameterType',
                 default_value: Optional[str] = None):
        """
        :param str name: The name of the parameter. The name must use only alphanumeric, underscore (_), or hyphen (-) characters but cannot start or end with a hyphen.
        :param 'AnalysisTemplateAnalysisParameterType' type: The type of parameter.
        :param str default_value: Optional. The default value that is applied in the analysis template. The member who can query can override this value in the query editor.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter. The name must use only alphanumeric, underscore (_), or hyphen (-) characters but cannot start or end with a hyphen.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'AnalysisTemplateAnalysisParameterType':
        """
        The type of parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        Optional. The default value that is applied in the analysis template. The member who can query can override this value in the query editor.
        """
        return pulumi.get(self, "default_value")


@pulumi.output_type
class AnalysisTemplateAnalysisSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referencedTables":
            suggest = "referenced_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisTemplateAnalysisSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisTemplateAnalysisSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisTemplateAnalysisSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 referenced_tables: Sequence[str]):
        """
        :param Sequence[str] referenced_tables: The tables referenced in the analysis schema.
        """
        pulumi.set(__self__, "referenced_tables", referenced_tables)

    @property
    @pulumi.getter(name="referencedTables")
    def referenced_tables(self) -> Sequence[str]:
        """
        The tables referenced in the analysis schema.
        """
        return pulumi.get(self, "referenced_tables")


@pulumi.output_type
class AnalysisTemplateAnalysisSource(dict):
    def __init__(__self__, *,
                 text: str):
        """
        :param str text: The query text.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The query text.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class CollaborationDataEncryptionMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCleartext":
            suggest = "allow_cleartext"
        elif key == "allowDuplicates":
            suggest = "allow_duplicates"
        elif key == "allowJoinsOnColumnsWithDifferentNames":
            suggest = "allow_joins_on_columns_with_different_names"
        elif key == "preserveNulls":
            suggest = "preserve_nulls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollaborationDataEncryptionMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollaborationDataEncryptionMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollaborationDataEncryptionMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_cleartext: bool,
                 allow_duplicates: bool,
                 allow_joins_on_columns_with_different_names: bool,
                 preserve_nulls: bool):
        """
        :param bool allow_cleartext: Indicates whether encrypted tables can contain cleartext data ( `TRUE` ) or are to cryptographically process every column ( `FALSE` ).
        :param bool allow_duplicates: Indicates whether Fingerprint columns can contain duplicate entries ( `TRUE` ) or are to contain only non-repeated values ( `FALSE` ).
        :param bool allow_joins_on_columns_with_different_names: Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name ( `TRUE` ) or can only be joined on Fingerprint columns of the same name ( `FALSE` ).
        :param bool preserve_nulls: Indicates whether NULL values are to be copied as NULL to encrypted tables ( `TRUE` ) or cryptographically processed ( `FALSE` ).
        """
        pulumi.set(__self__, "allow_cleartext", allow_cleartext)
        pulumi.set(__self__, "allow_duplicates", allow_duplicates)
        pulumi.set(__self__, "allow_joins_on_columns_with_different_names", allow_joins_on_columns_with_different_names)
        pulumi.set(__self__, "preserve_nulls", preserve_nulls)

    @property
    @pulumi.getter(name="allowCleartext")
    def allow_cleartext(self) -> bool:
        """
        Indicates whether encrypted tables can contain cleartext data ( `TRUE` ) or are to cryptographically process every column ( `FALSE` ).
        """
        return pulumi.get(self, "allow_cleartext")

    @property
    @pulumi.getter(name="allowDuplicates")
    def allow_duplicates(self) -> bool:
        """
        Indicates whether Fingerprint columns can contain duplicate entries ( `TRUE` ) or are to contain only non-repeated values ( `FALSE` ).
        """
        return pulumi.get(self, "allow_duplicates")

    @property
    @pulumi.getter(name="allowJoinsOnColumnsWithDifferentNames")
    def allow_joins_on_columns_with_different_names(self) -> bool:
        """
        Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name ( `TRUE` ) or can only be joined on Fingerprint columns of the same name ( `FALSE` ).
        """
        return pulumi.get(self, "allow_joins_on_columns_with_different_names")

    @property
    @pulumi.getter(name="preserveNulls")
    def preserve_nulls(self) -> bool:
        """
        Indicates whether NULL values are to be copied as NULL to encrypted tables ( `TRUE` ) or cryptographically processed ( `FALSE` ).
        """
        return pulumi.get(self, "preserve_nulls")


@pulumi.output_type
class CollaborationMemberSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "memberAbilities":
            suggest = "member_abilities"
        elif key == "paymentConfiguration":
            suggest = "payment_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollaborationMemberSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollaborationMemberSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollaborationMemberSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 display_name: str,
                 member_abilities: Sequence['CollaborationMemberAbility'],
                 payment_configuration: Optional['outputs.CollaborationPaymentConfiguration'] = None):
        """
        :param str account_id: The identifier used to reference members of the collaboration. Currently only supports AWS account ID.
        :param str display_name: The member's display name.
        :param Sequence['CollaborationMemberAbility'] member_abilities: The abilities granted to the collaboration member.
               
               *Allowed Values* : `CAN_QUERY` | `CAN_RECEIVE_RESULTS`
        :param 'CollaborationPaymentConfiguration' payment_configuration: The collaboration member's payment responsibilities set by the collaboration creator.
               
               If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the member who can query is the default payer.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "member_abilities", member_abilities)
        if payment_configuration is not None:
            pulumi.set(__self__, "payment_configuration", payment_configuration)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The identifier used to reference members of the collaboration. Currently only supports AWS account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The member's display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="memberAbilities")
    def member_abilities(self) -> Sequence['CollaborationMemberAbility']:
        """
        The abilities granted to the collaboration member.

        *Allowed Values* : `CAN_QUERY` | `CAN_RECEIVE_RESULTS`
        """
        return pulumi.get(self, "member_abilities")

    @property
    @pulumi.getter(name="paymentConfiguration")
    def payment_configuration(self) -> Optional['outputs.CollaborationPaymentConfiguration']:
        """
        The collaboration member's payment responsibilities set by the collaboration creator.

        If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the member who can query is the default payer.
        """
        return pulumi.get(self, "payment_configuration")


@pulumi.output_type
class CollaborationPaymentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryCompute":
            suggest = "query_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollaborationPaymentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollaborationPaymentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollaborationPaymentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_compute: 'outputs.CollaborationQueryComputePaymentConfig'):
        """
        :param 'CollaborationQueryComputePaymentConfig' query_compute: The collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
        """
        pulumi.set(__self__, "query_compute", query_compute)

    @property
    @pulumi.getter(name="queryCompute")
    def query_compute(self) -> 'outputs.CollaborationQueryComputePaymentConfig':
        """
        The collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
        """
        return pulumi.get(self, "query_compute")


@pulumi.output_type
class CollaborationQueryComputePaymentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isResponsible":
            suggest = "is_responsible"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CollaborationQueryComputePaymentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CollaborationQueryComputePaymentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CollaborationQueryComputePaymentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_responsible: bool):
        """
        :param bool is_responsible: Indicates whether the collaboration creator has configured the collaboration member to pay for query compute costs ( `TRUE` ) or has not configured the collaboration member to pay for query compute costs ( `FALSE` ).
               
               Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration creator sets a `TRUE` value for more than one member in the collaboration.
               
               If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a `FALSE` value for the member who can query.
        """
        pulumi.set(__self__, "is_responsible", is_responsible)

    @property
    @pulumi.getter(name="isResponsible")
    def is_responsible(self) -> bool:
        """
        Indicates whether the collaboration creator has configured the collaboration member to pay for query compute costs ( `TRUE` ) or has not configured the collaboration member to pay for query compute costs ( `FALSE` ).

        Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration creator sets a `TRUE` value for more than one member in the collaboration.

        If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a `FALSE` value for the member who can query.
        """
        return pulumi.get(self, "is_responsible")


@pulumi.output_type
class ConfiguredTableAggregateColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnNames":
            suggest = "column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAggregateColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAggregateColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAggregateColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_names: Sequence[str],
                 function: 'ConfiguredTableAggregateFunctionName'):
        pulumi.set(__self__, "column_names", column_names)
        pulumi.set(__self__, "function", function)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Sequence[str]:
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter
    def function(self) -> 'ConfiguredTableAggregateFunctionName':
        return pulumi.get(self, "function")


@pulumi.output_type
class ConfiguredTableAggregationConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAggregationConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAggregationConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAggregationConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: str,
                 minimum: float,
                 type: 'ConfiguredTableAggregationType'):
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> str:
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter
    def minimum(self) -> float:
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def type(self) -> 'ConfiguredTableAggregationType':
        return pulumi.get(self, "type")


@pulumi.output_type
class ConfiguredTableAnalysisRule(dict):
    def __init__(__self__, *,
                 policy: 'outputs.ConfiguredTableAnalysisRulePolicy',
                 type: 'ConfiguredTableAnalysisRuleType'):
        """
        :param 'ConfiguredTableAnalysisRulePolicy' policy: A policy that describes the associated data usage limitations.
        :param 'ConfiguredTableAnalysisRuleType' type: The type of analysis rule.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def policy(self) -> 'outputs.ConfiguredTableAnalysisRulePolicy':
        """
        A policy that describes the associated data usage limitations.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def type(self) -> 'ConfiguredTableAnalysisRuleType':
        """
        The type of analysis rule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConfiguredTableAnalysisRuleAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregateColumns":
            suggest = "aggregate_columns"
        elif key == "dimensionColumns":
            suggest = "dimension_columns"
        elif key == "joinColumns":
            suggest = "join_columns"
        elif key == "outputConstraints":
            suggest = "output_constraints"
        elif key == "scalarFunctions":
            suggest = "scalar_functions"
        elif key == "additionalAnalyses":
            suggest = "additional_analyses"
        elif key == "allowedJoinOperators":
            suggest = "allowed_join_operators"
        elif key == "joinRequired":
            suggest = "join_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAnalysisRuleAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAnalysisRuleAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAnalysisRuleAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregate_columns: Sequence['outputs.ConfiguredTableAggregateColumn'],
                 dimension_columns: Sequence[str],
                 join_columns: Sequence[str],
                 output_constraints: Sequence['outputs.ConfiguredTableAggregationConstraint'],
                 scalar_functions: Sequence['ConfiguredTableScalarFunctions'],
                 additional_analyses: Optional['ConfiguredTableAdditionalAnalyses'] = None,
                 allowed_join_operators: Optional[Sequence['ConfiguredTableJoinOperator']] = None,
                 join_required: Optional['ConfiguredTableJoinRequiredOption'] = None):
        pulumi.set(__self__, "aggregate_columns", aggregate_columns)
        pulumi.set(__self__, "dimension_columns", dimension_columns)
        pulumi.set(__self__, "join_columns", join_columns)
        pulumi.set(__self__, "output_constraints", output_constraints)
        pulumi.set(__self__, "scalar_functions", scalar_functions)
        if additional_analyses is not None:
            pulumi.set(__self__, "additional_analyses", additional_analyses)
        if allowed_join_operators is not None:
            pulumi.set(__self__, "allowed_join_operators", allowed_join_operators)
        if join_required is not None:
            pulumi.set(__self__, "join_required", join_required)

    @property
    @pulumi.getter(name="aggregateColumns")
    def aggregate_columns(self) -> Sequence['outputs.ConfiguredTableAggregateColumn']:
        return pulumi.get(self, "aggregate_columns")

    @property
    @pulumi.getter(name="dimensionColumns")
    def dimension_columns(self) -> Sequence[str]:
        return pulumi.get(self, "dimension_columns")

    @property
    @pulumi.getter(name="joinColumns")
    def join_columns(self) -> Sequence[str]:
        return pulumi.get(self, "join_columns")

    @property
    @pulumi.getter(name="outputConstraints")
    def output_constraints(self) -> Sequence['outputs.ConfiguredTableAggregationConstraint']:
        return pulumi.get(self, "output_constraints")

    @property
    @pulumi.getter(name="scalarFunctions")
    def scalar_functions(self) -> Sequence['ConfiguredTableScalarFunctions']:
        return pulumi.get(self, "scalar_functions")

    @property
    @pulumi.getter(name="additionalAnalyses")
    def additional_analyses(self) -> Optional['ConfiguredTableAdditionalAnalyses']:
        return pulumi.get(self, "additional_analyses")

    @property
    @pulumi.getter(name="allowedJoinOperators")
    def allowed_join_operators(self) -> Optional[Sequence['ConfiguredTableJoinOperator']]:
        return pulumi.get(self, "allowed_join_operators")

    @property
    @pulumi.getter(name="joinRequired")
    def join_required(self) -> Optional['ConfiguredTableJoinRequiredOption']:
        return pulumi.get(self, "join_required")


@pulumi.output_type
class ConfiguredTableAnalysisRuleCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAnalyses":
            suggest = "allowed_analyses"
        elif key == "additionalAnalyses":
            suggest = "additional_analyses"
        elif key == "allowedAnalysisProviders":
            suggest = "allowed_analysis_providers"
        elif key == "differentialPrivacy":
            suggest = "differential_privacy"
        elif key == "disallowedOutputColumns":
            suggest = "disallowed_output_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAnalysisRuleCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAnalysisRuleCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAnalysisRuleCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_analyses: Sequence[str],
                 additional_analyses: Optional['ConfiguredTableAdditionalAnalyses'] = None,
                 allowed_analysis_providers: Optional[Sequence[str]] = None,
                 differential_privacy: Optional['outputs.ConfiguredTableDifferentialPrivacy'] = None,
                 disallowed_output_columns: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "allowed_analyses", allowed_analyses)
        if additional_analyses is not None:
            pulumi.set(__self__, "additional_analyses", additional_analyses)
        if allowed_analysis_providers is not None:
            pulumi.set(__self__, "allowed_analysis_providers", allowed_analysis_providers)
        if differential_privacy is not None:
            pulumi.set(__self__, "differential_privacy", differential_privacy)
        if disallowed_output_columns is not None:
            pulumi.set(__self__, "disallowed_output_columns", disallowed_output_columns)

    @property
    @pulumi.getter(name="allowedAnalyses")
    def allowed_analyses(self) -> Sequence[str]:
        return pulumi.get(self, "allowed_analyses")

    @property
    @pulumi.getter(name="additionalAnalyses")
    def additional_analyses(self) -> Optional['ConfiguredTableAdditionalAnalyses']:
        return pulumi.get(self, "additional_analyses")

    @property
    @pulumi.getter(name="allowedAnalysisProviders")
    def allowed_analysis_providers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_analysis_providers")

    @property
    @pulumi.getter(name="differentialPrivacy")
    def differential_privacy(self) -> Optional['outputs.ConfiguredTableDifferentialPrivacy']:
        return pulumi.get(self, "differential_privacy")

    @property
    @pulumi.getter(name="disallowedOutputColumns")
    def disallowed_output_columns(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "disallowed_output_columns")


@pulumi.output_type
class ConfiguredTableAnalysisRuleList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "joinColumns":
            suggest = "join_columns"
        elif key == "listColumns":
            suggest = "list_columns"
        elif key == "additionalAnalyses":
            suggest = "additional_analyses"
        elif key == "allowedJoinOperators":
            suggest = "allowed_join_operators"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAnalysisRuleList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAnalysisRuleList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAnalysisRuleList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 join_columns: Sequence[str],
                 list_columns: Sequence[str],
                 additional_analyses: Optional['ConfiguredTableAdditionalAnalyses'] = None,
                 allowed_join_operators: Optional[Sequence['ConfiguredTableJoinOperator']] = None):
        pulumi.set(__self__, "join_columns", join_columns)
        pulumi.set(__self__, "list_columns", list_columns)
        if additional_analyses is not None:
            pulumi.set(__self__, "additional_analyses", additional_analyses)
        if allowed_join_operators is not None:
            pulumi.set(__self__, "allowed_join_operators", allowed_join_operators)

    @property
    @pulumi.getter(name="joinColumns")
    def join_columns(self) -> Sequence[str]:
        return pulumi.get(self, "join_columns")

    @property
    @pulumi.getter(name="listColumns")
    def list_columns(self) -> Sequence[str]:
        return pulumi.get(self, "list_columns")

    @property
    @pulumi.getter(name="additionalAnalyses")
    def additional_analyses(self) -> Optional['ConfiguredTableAdditionalAnalyses']:
        return pulumi.get(self, "additional_analyses")

    @property
    @pulumi.getter(name="allowedJoinOperators")
    def allowed_join_operators(self) -> Optional[Sequence['ConfiguredTableJoinOperator']]:
        return pulumi.get(self, "allowed_join_operators")


@pulumi.output_type
class ConfiguredTableAnalysisRulePolicy(dict):
    def __init__(__self__, *,
                 v1: Any):
        """
        :param Union['ConfiguredTableAnalysisRulePolicyV10Properties', 'ConfiguredTableAnalysisRulePolicyV11Properties', 'ConfiguredTableAnalysisRulePolicyV12Properties'] v1: Controls on the query specifications that can be run on a configured table.
        """
        pulumi.set(__self__, "v1", v1)

    @property
    @pulumi.getter
    def v1(self) -> Any:
        """
        Controls on the query specifications that can be run on a configured table.
        """
        return pulumi.get(self, "v1")


@pulumi.output_type
class ConfiguredTableAnalysisRulePolicyV10Properties(dict):
    def __init__(__self__, *,
                 list: 'outputs.ConfiguredTableAnalysisRuleList'):
        pulumi.set(__self__, "list", list)

    @property
    @pulumi.getter
    def list(self) -> 'outputs.ConfiguredTableAnalysisRuleList':
        return pulumi.get(self, "list")


@pulumi.output_type
class ConfiguredTableAnalysisRulePolicyV11Properties(dict):
    def __init__(__self__, *,
                 aggregation: 'outputs.ConfiguredTableAnalysisRuleAggregation'):
        pulumi.set(__self__, "aggregation", aggregation)

    @property
    @pulumi.getter
    def aggregation(self) -> 'outputs.ConfiguredTableAnalysisRuleAggregation':
        return pulumi.get(self, "aggregation")


@pulumi.output_type
class ConfiguredTableAnalysisRulePolicyV12Properties(dict):
    def __init__(__self__, *,
                 custom: 'outputs.ConfiguredTableAnalysisRuleCustom'):
        pulumi.set(__self__, "custom", custom)

    @property
    @pulumi.getter
    def custom(self) -> 'outputs.ConfiguredTableAnalysisRuleCustom':
        return pulumi.get(self, "custom")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRule(dict):
    def __init__(__self__, *,
                 policy: 'outputs.ConfiguredTableAssociationAnalysisRulePolicy',
                 type: 'ConfiguredTableAssociationAnalysisRuleType'):
        """
        :param 'ConfiguredTableAssociationAnalysisRulePolicy' policy: The policy of the configured table association analysis rule.
        :param 'ConfiguredTableAssociationAnalysisRuleType' type: The type of the configured table association analysis rule.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def policy(self) -> 'outputs.ConfiguredTableAssociationAnalysisRulePolicy':
        """
        The policy of the configured table association analysis rule.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def type(self) -> 'ConfiguredTableAssociationAnalysisRuleType':
        """
        The type of the configured table association analysis rule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRuleAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAdditionalAnalyses":
            suggest = "allowed_additional_analyses"
        elif key == "allowedResultReceivers":
            suggest = "allowed_result_receivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAssociationAnalysisRuleAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAssociationAnalysisRuleAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAssociationAnalysisRuleAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_additional_analyses: Optional[Sequence[str]] = None,
                 allowed_result_receivers: Optional[Sequence[str]] = None):
        if allowed_additional_analyses is not None:
            pulumi.set(__self__, "allowed_additional_analyses", allowed_additional_analyses)
        if allowed_result_receivers is not None:
            pulumi.set(__self__, "allowed_result_receivers", allowed_result_receivers)

    @property
    @pulumi.getter(name="allowedAdditionalAnalyses")
    def allowed_additional_analyses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_additional_analyses")

    @property
    @pulumi.getter(name="allowedResultReceivers")
    def allowed_result_receivers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_result_receivers")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRuleCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAdditionalAnalyses":
            suggest = "allowed_additional_analyses"
        elif key == "allowedResultReceivers":
            suggest = "allowed_result_receivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAssociationAnalysisRuleCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAssociationAnalysisRuleCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAssociationAnalysisRuleCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_additional_analyses: Optional[Sequence[str]] = None,
                 allowed_result_receivers: Optional[Sequence[str]] = None):
        if allowed_additional_analyses is not None:
            pulumi.set(__self__, "allowed_additional_analyses", allowed_additional_analyses)
        if allowed_result_receivers is not None:
            pulumi.set(__self__, "allowed_result_receivers", allowed_result_receivers)

    @property
    @pulumi.getter(name="allowedAdditionalAnalyses")
    def allowed_additional_analyses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_additional_analyses")

    @property
    @pulumi.getter(name="allowedResultReceivers")
    def allowed_result_receivers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_result_receivers")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRuleList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAdditionalAnalyses":
            suggest = "allowed_additional_analyses"
        elif key == "allowedResultReceivers":
            suggest = "allowed_result_receivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableAssociationAnalysisRuleList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableAssociationAnalysisRuleList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableAssociationAnalysisRuleList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_additional_analyses: Optional[Sequence[str]] = None,
                 allowed_result_receivers: Optional[Sequence[str]] = None):
        if allowed_additional_analyses is not None:
            pulumi.set(__self__, "allowed_additional_analyses", allowed_additional_analyses)
        if allowed_result_receivers is not None:
            pulumi.set(__self__, "allowed_result_receivers", allowed_result_receivers)

    @property
    @pulumi.getter(name="allowedAdditionalAnalyses")
    def allowed_additional_analyses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_additional_analyses")

    @property
    @pulumi.getter(name="allowedResultReceivers")
    def allowed_result_receivers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_result_receivers")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRulePolicy(dict):
    def __init__(__self__, *,
                 v1: Any):
        """
        :param Union['ConfiguredTableAssociationAnalysisRulePolicyV10Properties', 'ConfiguredTableAssociationAnalysisRulePolicyV11Properties', 'ConfiguredTableAssociationAnalysisRulePolicyV12Properties'] v1: The policy for the configured table association analysis rule.
        """
        pulumi.set(__self__, "v1", v1)

    @property
    @pulumi.getter
    def v1(self) -> Any:
        """
        The policy for the configured table association analysis rule.
        """
        return pulumi.get(self, "v1")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRulePolicyV10Properties(dict):
    def __init__(__self__, *,
                 list: 'outputs.ConfiguredTableAssociationAnalysisRuleList'):
        pulumi.set(__self__, "list", list)

    @property
    @pulumi.getter
    def list(self) -> 'outputs.ConfiguredTableAssociationAnalysisRuleList':
        return pulumi.get(self, "list")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRulePolicyV11Properties(dict):
    def __init__(__self__, *,
                 aggregation: 'outputs.ConfiguredTableAssociationAnalysisRuleAggregation'):
        pulumi.set(__self__, "aggregation", aggregation)

    @property
    @pulumi.getter
    def aggregation(self) -> 'outputs.ConfiguredTableAssociationAnalysisRuleAggregation':
        return pulumi.get(self, "aggregation")


@pulumi.output_type
class ConfiguredTableAssociationAnalysisRulePolicyV12Properties(dict):
    def __init__(__self__, *,
                 custom: 'outputs.ConfiguredTableAssociationAnalysisRuleCustom'):
        pulumi.set(__self__, "custom", custom)

    @property
    @pulumi.getter
    def custom(self) -> 'outputs.ConfiguredTableAssociationAnalysisRuleCustom':
        return pulumi.get(self, "custom")


@pulumi.output_type
class ConfiguredTableDifferentialPrivacy(dict):
    def __init__(__self__, *,
                 columns: Sequence['outputs.ConfiguredTableDifferentialPrivacyColumn']):
        pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.ConfiguredTableDifferentialPrivacyColumn']:
        return pulumi.get(self, "columns")


@pulumi.output_type
class ConfiguredTableDifferentialPrivacyColumn(dict):
    def __init__(__self__, *,
                 name: str):
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class ConfiguredTableGlueTableReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfiguredTableGlueTableReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfiguredTableGlueTableReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfiguredTableGlueTableReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 table_name: str):
        """
        :param str database_name: The name of the database the AWS Glue table belongs to.
        :param str table_name: The name of the AWS Glue table.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the database the AWS Glue table belongs to.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the AWS Glue table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class ConfiguredTableTableReference(dict):
    def __init__(__self__, *,
                 glue: 'outputs.ConfiguredTableGlueTableReference'):
        """
        :param 'ConfiguredTableGlueTableReference' glue: If present, a reference to the AWS Glue table referred to by this table reference.
        """
        pulumi.set(__self__, "glue", glue)

    @property
    @pulumi.getter
    def glue(self) -> 'outputs.ConfiguredTableGlueTableReference':
        """
        If present, a reference to the AWS Glue table referred to by this table reference.
        """
        return pulumi.get(self, "glue")


@pulumi.output_type
class IdMappingTableInputReferenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputReferenceArn":
            suggest = "input_reference_arn"
        elif key == "manageResourcePolicies":
            suggest = "manage_resource_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingTableInputReferenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingTableInputReferenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingTableInputReferenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_reference_arn: str,
                 manage_resource_policies: bool):
        """
        :param str input_reference_arn: The Amazon Resource Name (ARN) of the referenced resource in AWS Entity Resolution . Valid values are ID mapping workflow ARNs.
        :param bool manage_resource_policies: When `TRUE` , AWS Clean Rooms manages permissions for the ID mapping table resource.
               
               When `FALSE` , the resource owner manages permissions for the ID mapping table resource.
        """
        pulumi.set(__self__, "input_reference_arn", input_reference_arn)
        pulumi.set(__self__, "manage_resource_policies", manage_resource_policies)

    @property
    @pulumi.getter(name="inputReferenceArn")
    def input_reference_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the referenced resource in AWS Entity Resolution . Valid values are ID mapping workflow ARNs.
        """
        return pulumi.get(self, "input_reference_arn")

    @property
    @pulumi.getter(name="manageResourcePolicies")
    def manage_resource_policies(self) -> bool:
        """
        When `TRUE` , AWS Clean Rooms manages permissions for the ID mapping table resource.

        When `FALSE` , the resource owner manages permissions for the ID mapping table resource.
        """
        return pulumi.get(self, "manage_resource_policies")


@pulumi.output_type
class IdMappingTableInputReferenceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idMappingTableInputSource":
            suggest = "id_mapping_table_input_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingTableInputReferenceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingTableInputReferenceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingTableInputReferenceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id_mapping_table_input_source: Sequence['outputs.IdMappingTableInputSource']):
        """
        :param Sequence['IdMappingTableInputSource'] id_mapping_table_input_source: The input source of the ID mapping table.
        """
        pulumi.set(__self__, "id_mapping_table_input_source", id_mapping_table_input_source)

    @property
    @pulumi.getter(name="idMappingTableInputSource")
    def id_mapping_table_input_source(self) -> Sequence['outputs.IdMappingTableInputSource']:
        """
        The input source of the ID mapping table.
        """
        return pulumi.get(self, "id_mapping_table_input_source")


@pulumi.output_type
class IdMappingTableInputSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idNamespaceAssociationId":
            suggest = "id_namespace_association_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingTableInputSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingTableInputSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingTableInputSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id_namespace_association_id: str,
                 type: 'IdMappingTableInputSourceType'):
        """
        :param str id_namespace_association_id: The unique identifier of the ID namespace association.
        :param 'IdMappingTableInputSourceType' type: The type of the input source of the ID mapping table.
        """
        pulumi.set(__self__, "id_namespace_association_id", id_namespace_association_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="idNamespaceAssociationId")
    def id_namespace_association_id(self) -> str:
        """
        The unique identifier of the ID namespace association.
        """
        return pulumi.get(self, "id_namespace_association_id")

    @property
    @pulumi.getter
    def type(self) -> 'IdMappingTableInputSourceType':
        """
        The type of the input source of the ID mapping table.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IdNamespaceAssociationDocument(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class IdNamespaceAssociationIdMappingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowUseAsDimensionColumn":
            suggest = "allow_use_as_dimension_column"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceAssociationIdMappingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceAssociationIdMappingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceAssociationIdMappingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_use_as_dimension_column: bool):
        """
        :param bool allow_use_as_dimension_column: An indicator as to whether you can use your column as a dimension column in the ID mapping table ( `TRUE` ) or not ( `FALSE` ).
               
               Default is `FALSE` .
        """
        pulumi.set(__self__, "allow_use_as_dimension_column", allow_use_as_dimension_column)

    @property
    @pulumi.getter(name="allowUseAsDimensionColumn")
    def allow_use_as_dimension_column(self) -> bool:
        """
        An indicator as to whether you can use your column as a dimension column in the ID mapping table ( `TRUE` ) or not ( `FALSE` ).

        Default is `FALSE` .
        """
        return pulumi.get(self, "allow_use_as_dimension_column")


@pulumi.output_type
class IdNamespaceAssociationInputReferenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputReferenceArn":
            suggest = "input_reference_arn"
        elif key == "manageResourcePolicies":
            suggest = "manage_resource_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceAssociationInputReferenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceAssociationInputReferenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceAssociationInputReferenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_reference_arn: str,
                 manage_resource_policies: bool):
        """
        :param str input_reference_arn: The Amazon Resource Name (ARN) of the AWS Entity Resolution resource that is being associated to the collaboration. Valid resource ARNs are from the ID namespaces that you own.
        :param bool manage_resource_policies: When `TRUE` , AWS Clean Rooms manages permissions for the ID namespace association resource.
               
               When `FALSE` , the resource owner manages permissions for the ID namespace association resource.
        """
        pulumi.set(__self__, "input_reference_arn", input_reference_arn)
        pulumi.set(__self__, "manage_resource_policies", manage_resource_policies)

    @property
    @pulumi.getter(name="inputReferenceArn")
    def input_reference_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the AWS Entity Resolution resource that is being associated to the collaboration. Valid resource ARNs are from the ID namespaces that you own.
        """
        return pulumi.get(self, "input_reference_arn")

    @property
    @pulumi.getter(name="manageResourcePolicies")
    def manage_resource_policies(self) -> bool:
        """
        When `TRUE` , AWS Clean Rooms manages permissions for the ID namespace association resource.

        When `FALSE` , the resource owner manages permissions for the ID namespace association resource.
        """
        return pulumi.get(self, "manage_resource_policies")


@pulumi.output_type
class IdNamespaceAssociationInputReferenceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idMappingWorkflowsSupported":
            suggest = "id_mapping_workflows_supported"
        elif key == "idNamespaceType":
            suggest = "id_namespace_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceAssociationInputReferenceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceAssociationInputReferenceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceAssociationInputReferenceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id_mapping_workflows_supported: Optional[Sequence['outputs.IdNamespaceAssociationDocument']] = None,
                 id_namespace_type: Optional['IdNamespaceAssociationInputReferencePropertiesIdNamespaceType'] = None):
        """
        :param Sequence['IdNamespaceAssociationDocument'] id_mapping_workflows_supported: Defines how ID mapping workflows are supported for this ID namespace association.
        :param 'IdNamespaceAssociationInputReferencePropertiesIdNamespaceType' id_namespace_type: The ID namespace type for this ID namespace association.
        """
        if id_mapping_workflows_supported is not None:
            pulumi.set(__self__, "id_mapping_workflows_supported", id_mapping_workflows_supported)
        if id_namespace_type is not None:
            pulumi.set(__self__, "id_namespace_type", id_namespace_type)

    @property
    @pulumi.getter(name="idMappingWorkflowsSupported")
    def id_mapping_workflows_supported(self) -> Optional[Sequence['outputs.IdNamespaceAssociationDocument']]:
        """
        Defines how ID mapping workflows are supported for this ID namespace association.
        """
        return pulumi.get(self, "id_mapping_workflows_supported")

    @property
    @pulumi.getter(name="idNamespaceType")
    def id_namespace_type(self) -> Optional['IdNamespaceAssociationInputReferencePropertiesIdNamespaceType']:
        """
        The ID namespace type for this ID namespace association.
        """
        return pulumi.get(self, "id_namespace_type")


@pulumi.output_type
class MembershipPaymentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryCompute":
            suggest = "query_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipPaymentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipPaymentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipPaymentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_compute: 'outputs.MembershipQueryComputePaymentConfig'):
        """
        :param 'MembershipQueryComputePaymentConfig' query_compute: The payment responsibilities accepted by the collaboration member for query compute costs.
        """
        pulumi.set(__self__, "query_compute", query_compute)

    @property
    @pulumi.getter(name="queryCompute")
    def query_compute(self) -> 'outputs.MembershipQueryComputePaymentConfig':
        """
        The payment responsibilities accepted by the collaboration member for query compute costs.
        """
        return pulumi.get(self, "query_compute")


@pulumi.output_type
class MembershipProtectedQueryOutputConfiguration(dict):
    def __init__(__self__, *,
                 s3: 'outputs.MembershipProtectedQueryS3OutputConfiguration'):
        """
        :param 'MembershipProtectedQueryS3OutputConfiguration' s3: Required configuration for a protected query with an `s3` output type.
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.MembershipProtectedQueryS3OutputConfiguration':
        """
        Required configuration for a protected query with an `s3` output type.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class MembershipProtectedQueryResultConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputConfiguration":
            suggest = "output_configuration"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipProtectedQueryResultConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipProtectedQueryResultConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipProtectedQueryResultConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_configuration: 'outputs.MembershipProtectedQueryOutputConfiguration',
                 role_arn: Optional[str] = None):
        """
        :param 'MembershipProtectedQueryOutputConfiguration' output_configuration: Configuration for protected query results.
        :param str role_arn: The unique ARN for an IAM role that is used by AWS Clean Rooms to write protected query results to the result location, given by the member who can receive results.
        """
        pulumi.set(__self__, "output_configuration", output_configuration)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="outputConfiguration")
    def output_configuration(self) -> 'outputs.MembershipProtectedQueryOutputConfiguration':
        """
        Configuration for protected query results.
        """
        return pulumi.get(self, "output_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The unique ARN for an IAM role that is used by AWS Clean Rooms to write protected query results to the result location, given by the member who can receive results.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class MembershipProtectedQueryS3OutputConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultFormat":
            suggest = "result_format"
        elif key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipProtectedQueryS3OutputConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipProtectedQueryS3OutputConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipProtectedQueryS3OutputConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 result_format: 'MembershipResultFormat',
                 key_prefix: Optional[str] = None):
        """
        :param str bucket: The S3 bucket to unload the protected query results.
        :param 'MembershipResultFormat' result_format: Intended file format of the result.
        :param str key_prefix: The S3 prefix to unload the protected query results.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "result_format", result_format)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The S3 bucket to unload the protected query results.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="resultFormat")
    def result_format(self) -> 'MembershipResultFormat':
        """
        Intended file format of the result.
        """
        return pulumi.get(self, "result_format")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[str]:
        """
        The S3 prefix to unload the protected query results.
        """
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class MembershipQueryComputePaymentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isResponsible":
            suggest = "is_responsible"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipQueryComputePaymentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipQueryComputePaymentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipQueryComputePaymentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_responsible: bool):
        """
        :param bool is_responsible: Indicates whether the collaboration member has accepted to pay for query compute costs ( `TRUE` ) or has not accepted to pay for query compute costs ( `FALSE` ).
               
               If the collaboration creator has not specified anyone to pay for query compute costs, then the member who can query is the default payer.
               
               An error message is returned for the following reasons:
               
               - If you set the value to `FALSE` but you are responsible to pay for query compute costs.
               - If you set the value to `TRUE` but you are not responsible to pay for query compute costs.
        """
        pulumi.set(__self__, "is_responsible", is_responsible)

    @property
    @pulumi.getter(name="isResponsible")
    def is_responsible(self) -> bool:
        """
        Indicates whether the collaboration member has accepted to pay for query compute costs ( `TRUE` ) or has not accepted to pay for query compute costs ( `FALSE` ).

        If the collaboration creator has not specified anyone to pay for query compute costs, then the member who can query is the default payer.

        An error message is returned for the following reasons:

        - If you set the value to `FALSE` but you are responsible to pay for query compute costs.
        - If you set the value to `TRUE` but you are not responsible to pay for query compute costs.
        """
        return pulumi.get(self, "is_responsible")


@pulumi.output_type
class ParametersProperties(dict):
    """
    Specifies the epsilon and noise parameters for the privacy budget template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usersNoisePerQuery":
            suggest = "users_noise_per_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParametersProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParametersProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParametersProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 epsilon: int,
                 users_noise_per_query: int):
        """
        Specifies the epsilon and noise parameters for the privacy budget template.
        :param int epsilon: The epsilon value that you want to use.
        :param int users_noise_per_query: Noise added per query is measured in terms of the number of users whose contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.
        """
        pulumi.set(__self__, "epsilon", epsilon)
        pulumi.set(__self__, "users_noise_per_query", users_noise_per_query)

    @property
    @pulumi.getter
    def epsilon(self) -> int:
        """
        The epsilon value that you want to use.
        """
        return pulumi.get(self, "epsilon")

    @property
    @pulumi.getter(name="usersNoisePerQuery")
    def users_noise_per_query(self) -> int:
        """
        Noise added per query is measured in terms of the number of users whose contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.
        """
        return pulumi.get(self, "users_noise_per_query")


