# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['IdNamespaceAssociationArgs', 'IdNamespaceAssociation']

@pulumi.input_type
class IdNamespaceAssociationArgs:
    def __init__(__self__, *,
                 input_reference_config: pulumi.Input['IdNamespaceAssociationInputReferenceConfigArgs'],
                 membership_identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 id_mapping_config: Optional[pulumi.Input['IdNamespaceAssociationIdMappingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a IdNamespaceAssociation resource.
        :param pulumi.Input['IdNamespaceAssociationInputReferenceConfigArgs'] input_reference_config: The input reference configuration for the ID namespace association.
        :param pulumi.Input[str] membership_identifier: The unique identifier of the membership that contains the ID namespace association.
        :param pulumi.Input[str] description: The description of the ID namespace association.
        :param pulumi.Input['IdNamespaceAssociationIdMappingConfigArgs'] id_mapping_config: The configuration settings for the ID mapping table.
        :param pulumi.Input[str] name: The name of this ID namespace association.
        """
        pulumi.set(__self__, "input_reference_config", input_reference_config)
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id_mapping_config is not None:
            pulumi.set(__self__, "id_mapping_config", id_mapping_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="inputReferenceConfig")
    def input_reference_config(self) -> pulumi.Input['IdNamespaceAssociationInputReferenceConfigArgs']:
        """
        The input reference configuration for the ID namespace association.
        """
        return pulumi.get(self, "input_reference_config")

    @input_reference_config.setter
    def input_reference_config(self, value: pulumi.Input['IdNamespaceAssociationInputReferenceConfigArgs']):
        pulumi.set(self, "input_reference_config", value)

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Input[str]:
        """
        The unique identifier of the membership that contains the ID namespace association.
        """
        return pulumi.get(self, "membership_identifier")

    @membership_identifier.setter
    def membership_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "membership_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ID namespace association.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="idMappingConfig")
    def id_mapping_config(self) -> Optional[pulumi.Input['IdNamespaceAssociationIdMappingConfigArgs']]:
        """
        The configuration settings for the ID mapping table.
        """
        return pulumi.get(self, "id_mapping_config")

    @id_mapping_config.setter
    def id_mapping_config(self, value: Optional[pulumi.Input['IdNamespaceAssociationIdMappingConfigArgs']]):
        pulumi.set(self, "id_mapping_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this ID namespace association.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class IdNamespaceAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id_mapping_config: Optional[pulumi.Input[Union['IdNamespaceAssociationIdMappingConfigArgs', 'IdNamespaceAssociationIdMappingConfigArgsDict']]] = None,
                 input_reference_config: Optional[pulumi.Input[Union['IdNamespaceAssociationInputReferenceConfigArgs', 'IdNamespaceAssociationInputReferenceConfigArgsDict']]] = None,
                 membership_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents an association between an ID namespace and a collaboration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ID namespace association.
        :param pulumi.Input[Union['IdNamespaceAssociationIdMappingConfigArgs', 'IdNamespaceAssociationIdMappingConfigArgsDict']] id_mapping_config: The configuration settings for the ID mapping table.
        :param pulumi.Input[Union['IdNamespaceAssociationInputReferenceConfigArgs', 'IdNamespaceAssociationInputReferenceConfigArgsDict']] input_reference_config: The input reference configuration for the ID namespace association.
        :param pulumi.Input[str] membership_identifier: The unique identifier of the membership that contains the ID namespace association.
        :param pulumi.Input[str] name: The name of this ID namespace association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdNamespaceAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an association between an ID namespace and a collaboration

        :param str resource_name: The name of the resource.
        :param IdNamespaceAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdNamespaceAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id_mapping_config: Optional[pulumi.Input[Union['IdNamespaceAssociationIdMappingConfigArgs', 'IdNamespaceAssociationIdMappingConfigArgsDict']]] = None,
                 input_reference_config: Optional[pulumi.Input[Union['IdNamespaceAssociationInputReferenceConfigArgs', 'IdNamespaceAssociationInputReferenceConfigArgsDict']]] = None,
                 membership_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdNamespaceAssociationArgs.__new__(IdNamespaceAssociationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["id_mapping_config"] = id_mapping_config
            if input_reference_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_reference_config'")
            __props__.__dict__["input_reference_config"] = input_reference_config
            if membership_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'membership_identifier'")
            __props__.__dict__["membership_identifier"] = membership_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["collaboration_arn"] = None
            __props__.__dict__["collaboration_identifier"] = None
            __props__.__dict__["id_namespace_association_identifier"] = None
            __props__.__dict__["input_reference_properties"] = None
            __props__.__dict__["membership_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["inputReferenceConfig", "membershipIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IdNamespaceAssociation, __self__).__init__(
            'aws-native:cleanrooms:IdNamespaceAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IdNamespaceAssociation':
        """
        Get an existing IdNamespaceAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IdNamespaceAssociationArgs.__new__(IdNamespaceAssociationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["collaboration_arn"] = None
        __props__.__dict__["collaboration_identifier"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["id_mapping_config"] = None
        __props__.__dict__["id_namespace_association_identifier"] = None
        __props__.__dict__["input_reference_config"] = None
        __props__.__dict__["input_reference_properties"] = None
        __props__.__dict__["membership_arn"] = None
        __props__.__dict__["membership_identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return IdNamespaceAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the ID namespace association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
        """
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationIdentifier")
    def collaboration_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "collaboration_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the ID namespace association.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="idMappingConfig")
    def id_mapping_config(self) -> pulumi.Output[Optional['outputs.IdNamespaceAssociationIdMappingConfig']]:
        """
        The configuration settings for the ID mapping table.
        """
        return pulumi.get(self, "id_mapping_config")

    @property
    @pulumi.getter(name="idNamespaceAssociationIdentifier")
    def id_namespace_association_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "id_namespace_association_identifier")

    @property
    @pulumi.getter(name="inputReferenceConfig")
    def input_reference_config(self) -> pulumi.Output['outputs.IdNamespaceAssociationInputReferenceConfig']:
        """
        The input reference configuration for the ID namespace association.
        """
        return pulumi.get(self, "input_reference_config")

    @property
    @pulumi.getter(name="inputReferenceProperties")
    def input_reference_properties(self) -> pulumi.Output['outputs.IdNamespaceAssociationInputReferenceProperties']:
        return pulumi.get(self, "input_reference_properties")

    @property
    @pulumi.getter(name="membershipArn")
    def membership_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
        """
        return pulumi.get(self, "membership_arn")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Output[str]:
        """
        The unique identifier of the membership that contains the ID namespace association.
        """
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this ID namespace association.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

