# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['IdMappingTableArgs', 'IdMappingTable']

@pulumi.input_type
class IdMappingTableArgs:
    def __init__(__self__, *,
                 input_reference_config: pulumi.Input['IdMappingTableInputReferenceConfigArgs'],
                 membership_identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a IdMappingTable resource.
        :param pulumi.Input['IdMappingTableInputReferenceConfigArgs'] input_reference_config: The input reference configuration for the ID mapping table.
        :param pulumi.Input[str] membership_identifier: The unique identifier of the membership resource for the ID mapping table.
        :param pulumi.Input[str] description: The description of the ID mapping table.
        :param pulumi.Input[str] kms_key_arn: The Amazon Resource Name (ARN) of the AWS KMS key.
        :param pulumi.Input[str] name: The name of the ID mapping table.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
        """
        pulumi.set(__self__, "input_reference_config", input_reference_config)
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="inputReferenceConfig")
    def input_reference_config(self) -> pulumi.Input['IdMappingTableInputReferenceConfigArgs']:
        """
        The input reference configuration for the ID mapping table.
        """
        return pulumi.get(self, "input_reference_config")

    @input_reference_config.setter
    def input_reference_config(self, value: pulumi.Input['IdMappingTableInputReferenceConfigArgs']):
        pulumi.set(self, "input_reference_config", value)

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Input[str]:
        """
        The unique identifier of the membership resource for the ID mapping table.
        """
        return pulumi.get(self, "membership_identifier")

    @membership_identifier.setter
    def membership_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "membership_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ID mapping table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ID mapping table.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class IdMappingTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_reference_config: Optional[pulumi.Input[Union['IdMappingTableInputReferenceConfigArgs', 'IdMappingTableInputReferenceConfigArgsDict']]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 membership_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents an association between an ID mapping workflow and a collaboration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ID mapping table.
        :param pulumi.Input[Union['IdMappingTableInputReferenceConfigArgs', 'IdMappingTableInputReferenceConfigArgsDict']] input_reference_config: The input reference configuration for the ID mapping table.
        :param pulumi.Input[str] kms_key_arn: The Amazon Resource Name (ARN) of the AWS KMS key.
        :param pulumi.Input[str] membership_identifier: The unique identifier of the membership resource for the ID mapping table.
        :param pulumi.Input[str] name: The name of the ID mapping table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdMappingTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an association between an ID mapping workflow and a collaboration

        :param str resource_name: The name of the resource.
        :param IdMappingTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdMappingTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_reference_config: Optional[pulumi.Input[Union['IdMappingTableInputReferenceConfigArgs', 'IdMappingTableInputReferenceConfigArgsDict']]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 membership_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdMappingTableArgs.__new__(IdMappingTableArgs)

            __props__.__dict__["description"] = description
            if input_reference_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_reference_config'")
            __props__.__dict__["input_reference_config"] = input_reference_config
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            if membership_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'membership_identifier'")
            __props__.__dict__["membership_identifier"] = membership_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["collaboration_arn"] = None
            __props__.__dict__["collaboration_identifier"] = None
            __props__.__dict__["id_mapping_table_identifier"] = None
            __props__.__dict__["input_reference_properties"] = None
            __props__.__dict__["membership_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["inputReferenceConfig", "membershipIdentifier", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IdMappingTable, __self__).__init__(
            'aws-native:cleanrooms:IdMappingTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IdMappingTable':
        """
        Get an existing IdMappingTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IdMappingTableArgs.__new__(IdMappingTableArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["collaboration_arn"] = None
        __props__.__dict__["collaboration_identifier"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["id_mapping_table_identifier"] = None
        __props__.__dict__["input_reference_config"] = None
        __props__.__dict__["input_reference_properties"] = None
        __props__.__dict__["kms_key_arn"] = None
        __props__.__dict__["membership_arn"] = None
        __props__.__dict__["membership_identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return IdMappingTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the ID mapping table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
        """
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationIdentifier")
    def collaboration_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "collaboration_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the ID mapping table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="idMappingTableIdentifier")
    def id_mapping_table_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "id_mapping_table_identifier")

    @property
    @pulumi.getter(name="inputReferenceConfig")
    def input_reference_config(self) -> pulumi.Output['outputs.IdMappingTableInputReferenceConfig']:
        """
        The input reference configuration for the ID mapping table.
        """
        return pulumi.get(self, "input_reference_config")

    @property
    @pulumi.getter(name="inputReferenceProperties")
    def input_reference_properties(self) -> pulumi.Output['outputs.IdMappingTableInputReferenceProperties']:
        return pulumi.get(self, "input_reference_properties")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="membershipArn")
    def membership_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the membership resource for the ID mapping table.
        """
        return pulumi.get(self, "membership_arn")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Output[str]:
        """
        The unique identifier of the membership resource for the ID mapping table.
        """
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ID mapping table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
        """
        return pulumi.get(self, "tags")

