# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetIdNamespaceAssociationResult',
    'AwaitableGetIdNamespaceAssociationResult',
    'get_id_namespace_association',
    'get_id_namespace_association_output',
]

@pulumi.output_type
class GetIdNamespaceAssociationResult:
    def __init__(__self__, arn=None, collaboration_arn=None, collaboration_identifier=None, description=None, id_mapping_config=None, id_namespace_association_identifier=None, input_reference_properties=None, membership_arn=None, name=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if collaboration_arn and not isinstance(collaboration_arn, str):
            raise TypeError("Expected argument 'collaboration_arn' to be a str")
        pulumi.set(__self__, "collaboration_arn", collaboration_arn)
        if collaboration_identifier and not isinstance(collaboration_identifier, str):
            raise TypeError("Expected argument 'collaboration_identifier' to be a str")
        pulumi.set(__self__, "collaboration_identifier", collaboration_identifier)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id_mapping_config and not isinstance(id_mapping_config, dict):
            raise TypeError("Expected argument 'id_mapping_config' to be a dict")
        pulumi.set(__self__, "id_mapping_config", id_mapping_config)
        if id_namespace_association_identifier and not isinstance(id_namespace_association_identifier, str):
            raise TypeError("Expected argument 'id_namespace_association_identifier' to be a str")
        pulumi.set(__self__, "id_namespace_association_identifier", id_namespace_association_identifier)
        if input_reference_properties and not isinstance(input_reference_properties, dict):
            raise TypeError("Expected argument 'input_reference_properties' to be a dict")
        pulumi.set(__self__, "input_reference_properties", input_reference_properties)
        if membership_arn and not isinstance(membership_arn, str):
            raise TypeError("Expected argument 'membership_arn' to be a str")
        pulumi.set(__self__, "membership_arn", membership_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the ID namespace association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
        """
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationIdentifier")
    def collaboration_identifier(self) -> Optional[str]:
        return pulumi.get(self, "collaboration_identifier")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the ID namespace association.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="idMappingConfig")
    def id_mapping_config(self) -> Optional['outputs.IdNamespaceAssociationIdMappingConfig']:
        """
        The configuration settings for the ID mapping table.
        """
        return pulumi.get(self, "id_mapping_config")

    @property
    @pulumi.getter(name="idNamespaceAssociationIdentifier")
    def id_namespace_association_identifier(self) -> Optional[str]:
        return pulumi.get(self, "id_namespace_association_identifier")

    @property
    @pulumi.getter(name="inputReferenceProperties")
    def input_reference_properties(self) -> Optional['outputs.IdNamespaceAssociationInputReferenceProperties']:
        return pulumi.get(self, "input_reference_properties")

    @property
    @pulumi.getter(name="membershipArn")
    def membership_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
        """
        return pulumi.get(self, "membership_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of this ID namespace association.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        return pulumi.get(self, "tags")


class AwaitableGetIdNamespaceAssociationResult(GetIdNamespaceAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdNamespaceAssociationResult(
            arn=self.arn,
            collaboration_arn=self.collaboration_arn,
            collaboration_identifier=self.collaboration_identifier,
            description=self.description,
            id_mapping_config=self.id_mapping_config,
            id_namespace_association_identifier=self.id_namespace_association_identifier,
            input_reference_properties=self.input_reference_properties,
            membership_arn=self.membership_arn,
            name=self.name,
            tags=self.tags)


def get_id_namespace_association(id_namespace_association_identifier: Optional[str] = None,
                                 membership_identifier: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdNamespaceAssociationResult:
    """
    Represents an association between an ID namespace and a collaboration


    :param str membership_identifier: The unique identifier of the membership that contains the ID namespace association.
    """
    __args__ = dict()
    __args__['idNamespaceAssociationIdentifier'] = id_namespace_association_identifier
    __args__['membershipIdentifier'] = membership_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cleanrooms:getIdNamespaceAssociation', __args__, opts=opts, typ=GetIdNamespaceAssociationResult).value

    return AwaitableGetIdNamespaceAssociationResult(
        arn=pulumi.get(__ret__, 'arn'),
        collaboration_arn=pulumi.get(__ret__, 'collaboration_arn'),
        collaboration_identifier=pulumi.get(__ret__, 'collaboration_identifier'),
        description=pulumi.get(__ret__, 'description'),
        id_mapping_config=pulumi.get(__ret__, 'id_mapping_config'),
        id_namespace_association_identifier=pulumi.get(__ret__, 'id_namespace_association_identifier'),
        input_reference_properties=pulumi.get(__ret__, 'input_reference_properties'),
        membership_arn=pulumi.get(__ret__, 'membership_arn'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_id_namespace_association_output(id_namespace_association_identifier: Optional[pulumi.Input[str]] = None,
                                        membership_identifier: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIdNamespaceAssociationResult]:
    """
    Represents an association between an ID namespace and a collaboration


    :param str membership_identifier: The unique identifier of the membership that contains the ID namespace association.
    """
    __args__ = dict()
    __args__['idNamespaceAssociationIdentifier'] = id_namespace_association_identifier
    __args__['membershipIdentifier'] = membership_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cleanrooms:getIdNamespaceAssociation', __args__, opts=opts, typ=GetIdNamespaceAssociationResult)
    return __ret__.apply(lambda __response__: GetIdNamespaceAssociationResult(
        arn=pulumi.get(__response__, 'arn'),
        collaboration_arn=pulumi.get(__response__, 'collaboration_arn'),
        collaboration_identifier=pulumi.get(__response__, 'collaboration_identifier'),
        description=pulumi.get(__response__, 'description'),
        id_mapping_config=pulumi.get(__response__, 'id_mapping_config'),
        id_namespace_association_identifier=pulumi.get(__response__, 'id_namespace_association_identifier'),
        input_reference_properties=pulumi.get(__response__, 'input_reference_properties'),
        membership_arn=pulumi.get(__response__, 'membership_arn'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
