# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['CollaborationArgs', 'Collaboration']

@pulumi.input_type
class CollaborationArgs:
    def __init__(__self__, *,
                 creator_display_name: pulumi.Input[str],
                 creator_member_abilities: pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]],
                 description: pulumi.Input[str],
                 members: pulumi.Input[Sequence[pulumi.Input['CollaborationMemberSpecificationArgs']]],
                 query_log_status: pulumi.Input['CollaborationQueryLogStatus'],
                 creator_payment_configuration: Optional[pulumi.Input['CollaborationPaymentConfigurationArgs']] = None,
                 data_encryption_metadata: Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Collaboration resource.
        :param pulumi.Input[str] creator_display_name: A display name of the collaboration creator.
        :param pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]] creator_member_abilities: The abilities granted to the collaboration creator.
               
               *Allowed values* `CAN_QUERY` | `CAN_RECEIVE_RESULTS`
        :param pulumi.Input[str] description: A description of the collaboration provided by the collaboration owner.
        :param pulumi.Input[Sequence[pulumi.Input['CollaborationMemberSpecificationArgs']]] members: A list of initial members, not including the creator. This list is immutable.
        :param pulumi.Input['CollaborationQueryLogStatus'] query_log_status: An indicator as to whether query logging has been enabled or disabled for the collaboration.
        :param pulumi.Input['CollaborationPaymentConfigurationArgs'] creator_payment_configuration: An object representing the collaboration member's payment responsibilities set by the collaboration creator.
        :param pulumi.Input['CollaborationDataEncryptionMetadataArgs'] data_encryption_metadata: The settings for client-side encryption for cryptographic computing.
        :param pulumi.Input[str] name: A human-readable identifier provided by the collaboration owner. Display names are not unique.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        pulumi.set(__self__, "creator_display_name", creator_display_name)
        pulumi.set(__self__, "creator_member_abilities", creator_member_abilities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "query_log_status", query_log_status)
        if creator_payment_configuration is not None:
            pulumi.set(__self__, "creator_payment_configuration", creator_payment_configuration)
        if data_encryption_metadata is not None:
            pulumi.set(__self__, "data_encryption_metadata", data_encryption_metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creatorDisplayName")
    def creator_display_name(self) -> pulumi.Input[str]:
        """
        A display name of the collaboration creator.
        """
        return pulumi.get(self, "creator_display_name")

    @creator_display_name.setter
    def creator_display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "creator_display_name", value)

    @property
    @pulumi.getter(name="creatorMemberAbilities")
    def creator_member_abilities(self) -> pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]]:
        """
        The abilities granted to the collaboration creator.

        *Allowed values* `CAN_QUERY` | `CAN_RECEIVE_RESULTS`
        """
        return pulumi.get(self, "creator_member_abilities")

    @creator_member_abilities.setter
    def creator_member_abilities(self, value: pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]]):
        pulumi.set(self, "creator_member_abilities", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A description of the collaboration provided by the collaboration owner.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['CollaborationMemberSpecificationArgs']]]:
        """
        A list of initial members, not including the creator. This list is immutable.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['CollaborationMemberSpecificationArgs']]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> pulumi.Input['CollaborationQueryLogStatus']:
        """
        An indicator as to whether query logging has been enabled or disabled for the collaboration.
        """
        return pulumi.get(self, "query_log_status")

    @query_log_status.setter
    def query_log_status(self, value: pulumi.Input['CollaborationQueryLogStatus']):
        pulumi.set(self, "query_log_status", value)

    @property
    @pulumi.getter(name="creatorPaymentConfiguration")
    def creator_payment_configuration(self) -> Optional[pulumi.Input['CollaborationPaymentConfigurationArgs']]:
        """
        An object representing the collaboration member's payment responsibilities set by the collaboration creator.
        """
        return pulumi.get(self, "creator_payment_configuration")

    @creator_payment_configuration.setter
    def creator_payment_configuration(self, value: Optional[pulumi.Input['CollaborationPaymentConfigurationArgs']]):
        pulumi.set(self, "creator_payment_configuration", value)

    @property
    @pulumi.getter(name="dataEncryptionMetadata")
    def data_encryption_metadata(self) -> Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']]:
        """
        The settings for client-side encryption for cryptographic computing.
        """
        return pulumi.get(self, "data_encryption_metadata")

    @data_encryption_metadata.setter
    def data_encryption_metadata(self, value: Optional[pulumi.Input['CollaborationDataEncryptionMetadataArgs']]):
        pulumi.set(self, "data_encryption_metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable identifier provided by the collaboration owner. Display names are not unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Collaboration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creator_display_name: Optional[pulumi.Input[str]] = None,
                 creator_member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]]] = None,
                 creator_payment_configuration: Optional[pulumi.Input[Union['CollaborationPaymentConfigurationArgs', 'CollaborationPaymentConfigurationArgsDict']]] = None,
                 data_encryption_metadata: Optional[pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberSpecificationArgs', 'CollaborationMemberSpecificationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_log_status: Optional[pulumi.Input['CollaborationQueryLogStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents a collaboration between AWS accounts that allows for secure data collaboration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creator_display_name: A display name of the collaboration creator.
        :param pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]] creator_member_abilities: The abilities granted to the collaboration creator.
               
               *Allowed values* `CAN_QUERY` | `CAN_RECEIVE_RESULTS`
        :param pulumi.Input[Union['CollaborationPaymentConfigurationArgs', 'CollaborationPaymentConfigurationArgsDict']] creator_payment_configuration: An object representing the collaboration member's payment responsibilities set by the collaboration creator.
        :param pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']] data_encryption_metadata: The settings for client-side encryption for cryptographic computing.
        :param pulumi.Input[str] description: A description of the collaboration provided by the collaboration owner.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberSpecificationArgs', 'CollaborationMemberSpecificationArgsDict']]]] members: A list of initial members, not including the creator. This list is immutable.
        :param pulumi.Input[str] name: A human-readable identifier provided by the collaboration owner. Display names are not unique.
        :param pulumi.Input['CollaborationQueryLogStatus'] query_log_status: An indicator as to whether query logging has been enabled or disabled for the collaboration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CollaborationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a collaboration between AWS accounts that allows for secure data collaboration

        :param str resource_name: The name of the resource.
        :param CollaborationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CollaborationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creator_display_name: Optional[pulumi.Input[str]] = None,
                 creator_member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input['CollaborationMemberAbility']]]] = None,
                 creator_payment_configuration: Optional[pulumi.Input[Union['CollaborationPaymentConfigurationArgs', 'CollaborationPaymentConfigurationArgsDict']]] = None,
                 data_encryption_metadata: Optional[pulumi.Input[Union['CollaborationDataEncryptionMetadataArgs', 'CollaborationDataEncryptionMetadataArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CollaborationMemberSpecificationArgs', 'CollaborationMemberSpecificationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_log_status: Optional[pulumi.Input['CollaborationQueryLogStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CollaborationArgs.__new__(CollaborationArgs)

            if creator_display_name is None and not opts.urn:
                raise TypeError("Missing required property 'creator_display_name'")
            __props__.__dict__["creator_display_name"] = creator_display_name
            if creator_member_abilities is None and not opts.urn:
                raise TypeError("Missing required property 'creator_member_abilities'")
            __props__.__dict__["creator_member_abilities"] = creator_member_abilities
            __props__.__dict__["creator_payment_configuration"] = creator_payment_configuration
            __props__.__dict__["data_encryption_metadata"] = data_encryption_metadata
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            if query_log_status is None and not opts.urn:
                raise TypeError("Missing required property 'query_log_status'")
            __props__.__dict__["query_log_status"] = query_log_status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["collaboration_identifier"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["creatorDisplayName", "creatorMemberAbilities[*]", "creatorPaymentConfiguration", "dataEncryptionMetadata", "members[*]", "queryLogStatus"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Collaboration, __self__).__init__(
            'aws-native:cleanrooms:Collaboration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Collaboration':
        """
        Get an existing Collaboration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CollaborationArgs.__new__(CollaborationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["collaboration_identifier"] = None
        __props__.__dict__["creator_display_name"] = None
        __props__.__dict__["creator_member_abilities"] = None
        __props__.__dict__["creator_payment_configuration"] = None
        __props__.__dict__["data_encryption_metadata"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["members"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["query_log_status"] = None
        __props__.__dict__["tags"] = None
        return Collaboration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified collaboration.

        Example: `arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationIdentifier")
    def collaboration_identifier(self) -> pulumi.Output[str]:
        """
        Returns the unique identifier of the specified collaboration.

        Example: `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`
        """
        return pulumi.get(self, "collaboration_identifier")

    @property
    @pulumi.getter(name="creatorDisplayName")
    def creator_display_name(self) -> pulumi.Output[str]:
        """
        A display name of the collaboration creator.
        """
        return pulumi.get(self, "creator_display_name")

    @property
    @pulumi.getter(name="creatorMemberAbilities")
    def creator_member_abilities(self) -> pulumi.Output[Sequence['CollaborationMemberAbility']]:
        """
        The abilities granted to the collaboration creator.

        *Allowed values* `CAN_QUERY` | `CAN_RECEIVE_RESULTS`
        """
        return pulumi.get(self, "creator_member_abilities")

    @property
    @pulumi.getter(name="creatorPaymentConfiguration")
    def creator_payment_configuration(self) -> pulumi.Output[Optional['outputs.CollaborationPaymentConfiguration']]:
        """
        An object representing the collaboration member's payment responsibilities set by the collaboration creator.
        """
        return pulumi.get(self, "creator_payment_configuration")

    @property
    @pulumi.getter(name="dataEncryptionMetadata")
    def data_encryption_metadata(self) -> pulumi.Output[Optional['outputs.CollaborationDataEncryptionMetadata']]:
        """
        The settings for client-side encryption for cryptographic computing.
        """
        return pulumi.get(self, "data_encryption_metadata")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of the collaboration provided by the collaboration owner.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.CollaborationMemberSpecification']]:
        """
        A list of initial members, not including the creator. This list is immutable.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A human-readable identifier provided by the collaboration owner. Display names are not unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> pulumi.Output['CollaborationQueryLogStatus']:
        """
        An indicator as to whether query logging has been enabled or disabled for the collaboration.
        """
        return pulumi.get(self, "query_log_status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms collaboration.
        """
        return pulumi.get(self, "tags")

