# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 expiry_events_configuration: pulumi.Input['AccountExpiryEventsConfigurationArgs']):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input['AccountExpiryEventsConfigurationArgs'] expiry_events_configuration: Object containing expiration events options associated with an AWS account . For more information, see [ExpiryEventsConfiguration](https://docs.aws.amazon.com/acm/latest/APIReference/API_ExpiryEventsConfiguration.html) in the API reference.
        """
        pulumi.set(__self__, "expiry_events_configuration", expiry_events_configuration)

    @property
    @pulumi.getter(name="expiryEventsConfiguration")
    def expiry_events_configuration(self) -> pulumi.Input['AccountExpiryEventsConfigurationArgs']:
        """
        Object containing expiration events options associated with an AWS account . For more information, see [ExpiryEventsConfiguration](https://docs.aws.amazon.com/acm/latest/APIReference/API_ExpiryEventsConfiguration.html) in the API reference.
        """
        return pulumi.get(self, "expiry_events_configuration")

    @expiry_events_configuration.setter
    def expiry_events_configuration(self, value: pulumi.Input['AccountExpiryEventsConfigurationArgs']):
        pulumi.set(self, "expiry_events_configuration", value)


class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiry_events_configuration: Optional[pulumi.Input[Union['AccountExpiryEventsConfigurationArgs', 'AccountExpiryEventsConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Resource schema for AWS::CertificateManager::Account.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccountExpiryEventsConfigurationArgs', 'AccountExpiryEventsConfigurationArgsDict']] expiry_events_configuration: Object containing expiration events options associated with an AWS account . For more information, see [ExpiryEventsConfiguration](https://docs.aws.amazon.com/acm/latest/APIReference/API_ExpiryEventsConfiguration.html) in the API reference.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::CertificateManager::Account.

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiry_events_configuration: Optional[pulumi.Input[Union['AccountExpiryEventsConfigurationArgs', 'AccountExpiryEventsConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            if expiry_events_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'expiry_events_configuration'")
            __props__.__dict__["expiry_events_configuration"] = expiry_events_configuration
            __props__.__dict__["account_id"] = None
        super(Account, __self__).__init__(
            'aws-native:certificatemanager:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccountArgs.__new__(AccountArgs)

        __props__.__dict__["account_id"] = None
        __props__.__dict__["expiry_events_configuration"] = None
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        ID of the AWS account that owns the certificate.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="expiryEventsConfiguration")
    def expiry_events_configuration(self) -> pulumi.Output['outputs.AccountExpiryEventsConfiguration']:
        """
        Object containing expiration events options associated with an AWS account . For more information, see [ExpiryEventsConfiguration](https://docs.aws.amazon.com/acm/latest/APIReference/API_ExpiryEventsConfiguration.html) in the API reference.
        """
        return pulumi.get(self, "expiry_events_configuration")

