# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 keyspace_name: pulumi.Input[str],
                 partition_key_columns: pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]],
                 auto_scaling_specifications: Optional[pulumi.Input['TableAutoScalingSpecificationArgs']] = None,
                 billing_mode: Optional[pulumi.Input['TableBillingModeArgs']] = None,
                 client_side_timestamps_enabled: Optional[pulumi.Input[bool]] = None,
                 clustering_key_columns: Optional[pulumi.Input[Sequence[pulumi.Input['TableClusteringKeyColumnArgs']]]] = None,
                 default_time_to_live: Optional[pulumi.Input[int]] = None,
                 encryption_specification: Optional[pulumi.Input['TableEncryptionSpecificationArgs']] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 regular_columns: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]] = None,
                 replica_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaSpecificationArgs']]]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[str] keyspace_name: Name for Cassandra keyspace
        :param pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]] partition_key_columns: Partition key columns of the table
        :param pulumi.Input['TableAutoScalingSpecificationArgs'] auto_scaling_specifications: The optional auto scaling capacity settings for a table in provisioned capacity mode.
        :param pulumi.Input['TableBillingModeArgs'] billing_mode: The billing mode for the table, which determines how you'll be charged for reads and writes:
               
               - *On-demand mode* (default) - You pay based on the actual reads and writes your application performs.
               - *Provisioned mode* - Lets you specify the number of reads and writes per second that you need for your application.
               
               If you don't specify a value for this property, then the table will use on-demand mode.
        :param pulumi.Input[bool] client_side_timestamps_enabled: Indicates whether client side timestamps are enabled (true) or disabled (false) on the table. False by default, once it is enabled it cannot be disabled again.
        :param pulumi.Input[Sequence[pulumi.Input['TableClusteringKeyColumnArgs']]] clustering_key_columns: Clustering key columns of the table
        :param pulumi.Input[int] default_time_to_live: Default TTL (Time To Live) in seconds, where zero is disabled. If the value is greater than zero, TTL is enabled for the entire table and an expiration timestamp is added to each column.
        :param pulumi.Input['TableEncryptionSpecificationArgs'] encryption_specification: The encryption at rest options for the table.
               
               - *AWS owned key* (default) - The key is owned by Amazon Keyspaces .
               - *Customer managed key* - The key is stored in your account and is created, owned, and managed by you.
               
               > If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
               
               For more information, see [Encryption at rest in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide* .
        :param pulumi.Input[bool] point_in_time_recovery_enabled: Indicates whether point in time recovery is enabled (true) or disabled (false) on the table
        :param pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]] regular_columns: Non-key columns of the table
        :param pulumi.Input[Sequence[pulumi.Input['TableReplicaSpecificationArgs']]] replica_specifications: The AWS Region specific settings of a multi-Region table.
               
               For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.
               
               - `region` : The Region where these settings are applied. (Required)
               - `readCapacityUnits` : The provisioned read capacity units. (Optional)
               - `readCapacityAutoScaling` : The read capacity auto scaling settings for the table. (Optional)
        :param pulumi.Input[str] table_name: Name for Cassandra table
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource
        """
        pulumi.set(__self__, "keyspace_name", keyspace_name)
        pulumi.set(__self__, "partition_key_columns", partition_key_columns)
        if auto_scaling_specifications is not None:
            pulumi.set(__self__, "auto_scaling_specifications", auto_scaling_specifications)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if client_side_timestamps_enabled is not None:
            pulumi.set(__self__, "client_side_timestamps_enabled", client_side_timestamps_enabled)
        if clustering_key_columns is not None:
            pulumi.set(__self__, "clustering_key_columns", clustering_key_columns)
        if default_time_to_live is not None:
            pulumi.set(__self__, "default_time_to_live", default_time_to_live)
        if encryption_specification is not None:
            pulumi.set(__self__, "encryption_specification", encryption_specification)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if regular_columns is not None:
            pulumi.set(__self__, "regular_columns", regular_columns)
        if replica_specifications is not None:
            pulumi.set(__self__, "replica_specifications", replica_specifications)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="keyspaceName")
    def keyspace_name(self) -> pulumi.Input[str]:
        """
        Name for Cassandra keyspace
        """
        return pulumi.get(self, "keyspace_name")

    @keyspace_name.setter
    def keyspace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "keyspace_name", value)

    @property
    @pulumi.getter(name="partitionKeyColumns")
    def partition_key_columns(self) -> pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]:
        """
        Partition key columns of the table
        """
        return pulumi.get(self, "partition_key_columns")

    @partition_key_columns.setter
    def partition_key_columns(self, value: pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]):
        pulumi.set(self, "partition_key_columns", value)

    @property
    @pulumi.getter(name="autoScalingSpecifications")
    def auto_scaling_specifications(self) -> Optional[pulumi.Input['TableAutoScalingSpecificationArgs']]:
        """
        The optional auto scaling capacity settings for a table in provisioned capacity mode.
        """
        return pulumi.get(self, "auto_scaling_specifications")

    @auto_scaling_specifications.setter
    def auto_scaling_specifications(self, value: Optional[pulumi.Input['TableAutoScalingSpecificationArgs']]):
        pulumi.set(self, "auto_scaling_specifications", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input['TableBillingModeArgs']]:
        """
        The billing mode for the table, which determines how you'll be charged for reads and writes:

        - *On-demand mode* (default) - You pay based on the actual reads and writes your application performs.
        - *Provisioned mode* - Lets you specify the number of reads and writes per second that you need for your application.

        If you don't specify a value for this property, then the table will use on-demand mode.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input['TableBillingModeArgs']]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="clientSideTimestampsEnabled")
    def client_side_timestamps_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether client side timestamps are enabled (true) or disabled (false) on the table. False by default, once it is enabled it cannot be disabled again.
        """
        return pulumi.get(self, "client_side_timestamps_enabled")

    @client_side_timestamps_enabled.setter
    def client_side_timestamps_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_side_timestamps_enabled", value)

    @property
    @pulumi.getter(name="clusteringKeyColumns")
    def clustering_key_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableClusteringKeyColumnArgs']]]]:
        """
        Clustering key columns of the table
        """
        return pulumi.get(self, "clustering_key_columns")

    @clustering_key_columns.setter
    def clustering_key_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableClusteringKeyColumnArgs']]]]):
        pulumi.set(self, "clustering_key_columns", value)

    @property
    @pulumi.getter(name="defaultTimeToLive")
    def default_time_to_live(self) -> Optional[pulumi.Input[int]]:
        """
        Default TTL (Time To Live) in seconds, where zero is disabled. If the value is greater than zero, TTL is enabled for the entire table and an expiration timestamp is added to each column.
        """
        return pulumi.get(self, "default_time_to_live")

    @default_time_to_live.setter
    def default_time_to_live(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_time_to_live", value)

    @property
    @pulumi.getter(name="encryptionSpecification")
    def encryption_specification(self) -> Optional[pulumi.Input['TableEncryptionSpecificationArgs']]:
        """
        The encryption at rest options for the table.

        - *AWS owned key* (default) - The key is owned by Amazon Keyspaces .
        - *Customer managed key* - The key is stored in your account and is created, owned, and managed by you.

        > If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.

        For more information, see [Encryption at rest in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide* .
        """
        return pulumi.get(self, "encryption_specification")

    @encryption_specification.setter
    def encryption_specification(self, value: Optional[pulumi.Input['TableEncryptionSpecificationArgs']]):
        pulumi.set(self, "encryption_specification", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @point_in_time_recovery_enabled.setter
    def point_in_time_recovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "point_in_time_recovery_enabled", value)

    @property
    @pulumi.getter(name="regularColumns")
    def regular_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]]:
        """
        Non-key columns of the table
        """
        return pulumi.get(self, "regular_columns")

    @regular_columns.setter
    def regular_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]]):
        pulumi.set(self, "regular_columns", value)

    @property
    @pulumi.getter(name="replicaSpecifications")
    def replica_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaSpecificationArgs']]]]:
        """
        The AWS Region specific settings of a multi-Region table.

        For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.

        - `region` : The Region where these settings are applied. (Required)
        - `readCapacityUnits` : The provisioned read capacity units. (Optional)
        - `readCapacityAutoScaling` : The read capacity auto scaling settings for the table. (Optional)
        """
        return pulumi.get(self, "replica_specifications")

    @replica_specifications.setter
    def replica_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableReplicaSpecificationArgs']]]]):
        pulumi.set(self, "replica_specifications", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for Cassandra table
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_specifications: Optional[pulumi.Input[Union['TableAutoScalingSpecificationArgs', 'TableAutoScalingSpecificationArgsDict']]] = None,
                 billing_mode: Optional[pulumi.Input[Union['TableBillingModeArgs', 'TableBillingModeArgsDict']]] = None,
                 client_side_timestamps_enabled: Optional[pulumi.Input[bool]] = None,
                 clustering_key_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableClusteringKeyColumnArgs', 'TableClusteringKeyColumnArgsDict']]]]] = None,
                 default_time_to_live: Optional[pulumi.Input[int]] = None,
                 encryption_specification: Optional[pulumi.Input[Union['TableEncryptionSpecificationArgs', 'TableEncryptionSpecificationArgsDict']]] = None,
                 keyspace_name: Optional[pulumi.Input[str]] = None,
                 partition_key_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnArgs', 'TableColumnArgsDict']]]]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 regular_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnArgs', 'TableColumnArgsDict']]]]] = None,
                 replica_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaSpecificationArgs', 'TableReplicaSpecificationArgsDict']]]]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::Cassandra::Table

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            client_side_timestamps_enabled=True,
            default_time_to_live=63072000,
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            client_side_timestamps_enabled=True,
            default_time_to_live=63072000,
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            default_time_to_live=63072000,
            encryption_specification={
                "encryption_type": aws_native.cassandra.TableEncryptionType.CUSTOMER_MANAGED_KMS_KEY,
                "kms_key_identifier": "arn:aws:kms:eu-west-1:5555555555555:key/11111111-1111-111-1111-111111111111",
            },
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            default_time_to_live=63072000,
            encryption_specification={
                "encryption_type": aws_native.cassandra.TableEncryptionType.CUSTOMER_MANAGED_KMS_KEY,
                "kms_key_identifier": "arn:aws:kms:eu-west-1:5555555555555:key/11111111-1111-111-1111-111111111111",
            },
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableAutoScalingSpecificationArgs', 'TableAutoScalingSpecificationArgsDict']] auto_scaling_specifications: The optional auto scaling capacity settings for a table in provisioned capacity mode.
        :param pulumi.Input[Union['TableBillingModeArgs', 'TableBillingModeArgsDict']] billing_mode: The billing mode for the table, which determines how you'll be charged for reads and writes:
               
               - *On-demand mode* (default) - You pay based on the actual reads and writes your application performs.
               - *Provisioned mode* - Lets you specify the number of reads and writes per second that you need for your application.
               
               If you don't specify a value for this property, then the table will use on-demand mode.
        :param pulumi.Input[bool] client_side_timestamps_enabled: Indicates whether client side timestamps are enabled (true) or disabled (false) on the table. False by default, once it is enabled it cannot be disabled again.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableClusteringKeyColumnArgs', 'TableClusteringKeyColumnArgsDict']]]] clustering_key_columns: Clustering key columns of the table
        :param pulumi.Input[int] default_time_to_live: Default TTL (Time To Live) in seconds, where zero is disabled. If the value is greater than zero, TTL is enabled for the entire table and an expiration timestamp is added to each column.
        :param pulumi.Input[Union['TableEncryptionSpecificationArgs', 'TableEncryptionSpecificationArgsDict']] encryption_specification: The encryption at rest options for the table.
               
               - *AWS owned key* (default) - The key is owned by Amazon Keyspaces .
               - *Customer managed key* - The key is stored in your account and is created, owned, and managed by you.
               
               > If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
               
               For more information, see [Encryption at rest in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide* .
        :param pulumi.Input[str] keyspace_name: Name for Cassandra keyspace
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableColumnArgs', 'TableColumnArgsDict']]]] partition_key_columns: Partition key columns of the table
        :param pulumi.Input[bool] point_in_time_recovery_enabled: Indicates whether point in time recovery is enabled (true) or disabled (false) on the table
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableColumnArgs', 'TableColumnArgsDict']]]] regular_columns: Non-key columns of the table
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaSpecificationArgs', 'TableReplicaSpecificationArgsDict']]]] replica_specifications: The AWS Region specific settings of a multi-Region table.
               
               For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.
               
               - `region` : The Region where these settings are applied. (Required)
               - `readCapacityUnits` : The provisioned read capacity units. (Optional)
               - `readCapacityAutoScaling` : The read capacity auto scaling settings for the table. (Optional)
        :param pulumi.Input[str] table_name: Name for Cassandra table
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::Cassandra::Table

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            client_side_timestamps_enabled=True,
            default_time_to_live=63072000,
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            client_side_timestamps_enabled=True,
            default_time_to_live=63072000,
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            default_time_to_live=63072000,
            encryption_specification={
                "encryption_type": aws_native.cassandra.TableEncryptionType.CUSTOMER_MANAGED_KMS_KEY,
                "kms_key_identifier": "arn:aws:kms:eu-west-1:5555555555555:key/11111111-1111-111-1111-111111111111",
            },
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_new_table = aws_native.cassandra.Table("myNewTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "id",
                "column_type": "ASCII",
            }],
            clustering_key_columns=[{
                "column": {
                    "column_name": "division",
                    "column_type": "ASCII",
                },
                "order_by": aws_native.cassandra.TableClusteringKeyColumnOrderBy.ASC,
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ],
            billing_mode={
                "mode": aws_native.cassandra.TableMode.PROVISIONED,
                "provisioned_throughput": {
                    "read_capacity_units": 5,
                    "write_capacity_units": 5,
                },
            },
            default_time_to_live=63072000,
            encryption_specification={
                "encryption_type": aws_native.cassandra.TableEncryptionType.CUSTOMER_MANAGED_KMS_KEY,
                "kms_key_identifier": "arn:aws:kms:eu-west-1:5555555555555:key/11111111-1111-111-1111-111111111111",
            },
            point_in_time_recovery_enabled=True,
            tags=[
                {
                    "key": "tag1",
                    "value": "val1",
                },
                {
                    "key": "tag2",
                    "value": "val2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_table = aws_native.cassandra.Table("myTable",
            keyspace_name="my_keyspace",
            table_name="my_table",
            partition_key_columns=[{
                "column_name": "Message",
                "column_type": "ASCII",
            }],
            regular_columns=[
                {
                    "column_name": "name",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "region",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "project",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "role",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "pay_scale",
                    "column_type": "TEXT",
                },
                {
                    "column_name": "vacation_hrs",
                    "column_type": "FLOAT",
                },
                {
                    "column_name": "manager_id",
                    "column_type": "TEXT",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_specifications: Optional[pulumi.Input[Union['TableAutoScalingSpecificationArgs', 'TableAutoScalingSpecificationArgsDict']]] = None,
                 billing_mode: Optional[pulumi.Input[Union['TableBillingModeArgs', 'TableBillingModeArgsDict']]] = None,
                 client_side_timestamps_enabled: Optional[pulumi.Input[bool]] = None,
                 clustering_key_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableClusteringKeyColumnArgs', 'TableClusteringKeyColumnArgsDict']]]]] = None,
                 default_time_to_live: Optional[pulumi.Input[int]] = None,
                 encryption_specification: Optional[pulumi.Input[Union['TableEncryptionSpecificationArgs', 'TableEncryptionSpecificationArgsDict']]] = None,
                 keyspace_name: Optional[pulumi.Input[str]] = None,
                 partition_key_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnArgs', 'TableColumnArgsDict']]]]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 regular_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnArgs', 'TableColumnArgsDict']]]]] = None,
                 replica_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableReplicaSpecificationArgs', 'TableReplicaSpecificationArgsDict']]]]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["auto_scaling_specifications"] = auto_scaling_specifications
            __props__.__dict__["billing_mode"] = billing_mode
            __props__.__dict__["client_side_timestamps_enabled"] = client_side_timestamps_enabled
            __props__.__dict__["clustering_key_columns"] = clustering_key_columns
            __props__.__dict__["default_time_to_live"] = default_time_to_live
            __props__.__dict__["encryption_specification"] = encryption_specification
            if keyspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'keyspace_name'")
            __props__.__dict__["keyspace_name"] = keyspace_name
            if partition_key_columns is None and not opts.urn:
                raise TypeError("Missing required property 'partition_key_columns'")
            __props__.__dict__["partition_key_columns"] = partition_key_columns
            __props__.__dict__["point_in_time_recovery_enabled"] = point_in_time_recovery_enabled
            __props__.__dict__["regular_columns"] = regular_columns
            __props__.__dict__["replica_specifications"] = replica_specifications
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["tags"] = tags
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clientSideTimestampsEnabled", "clusteringKeyColumns[*]", "keyspaceName", "partitionKeyColumns[*]", "tableName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Table, __self__).__init__(
            'aws-native:cassandra:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TableArgs.__new__(TableArgs)

        __props__.__dict__["auto_scaling_specifications"] = None
        __props__.__dict__["billing_mode"] = None
        __props__.__dict__["client_side_timestamps_enabled"] = None
        __props__.__dict__["clustering_key_columns"] = None
        __props__.__dict__["default_time_to_live"] = None
        __props__.__dict__["encryption_specification"] = None
        __props__.__dict__["keyspace_name"] = None
        __props__.__dict__["partition_key_columns"] = None
        __props__.__dict__["point_in_time_recovery_enabled"] = None
        __props__.__dict__["regular_columns"] = None
        __props__.__dict__["replica_specifications"] = None
        __props__.__dict__["table_name"] = None
        __props__.__dict__["tags"] = None
        return Table(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoScalingSpecifications")
    def auto_scaling_specifications(self) -> pulumi.Output[Optional['outputs.TableAutoScalingSpecification']]:
        """
        The optional auto scaling capacity settings for a table in provisioned capacity mode.
        """
        return pulumi.get(self, "auto_scaling_specifications")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[Optional['outputs.TableBillingMode']]:
        """
        The billing mode for the table, which determines how you'll be charged for reads and writes:

        - *On-demand mode* (default) - You pay based on the actual reads and writes your application performs.
        - *Provisioned mode* - Lets you specify the number of reads and writes per second that you need for your application.

        If you don't specify a value for this property, then the table will use on-demand mode.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="clientSideTimestampsEnabled")
    def client_side_timestamps_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether client side timestamps are enabled (true) or disabled (false) on the table. False by default, once it is enabled it cannot be disabled again.
        """
        return pulumi.get(self, "client_side_timestamps_enabled")

    @property
    @pulumi.getter(name="clusteringKeyColumns")
    def clustering_key_columns(self) -> pulumi.Output[Optional[Sequence['outputs.TableClusteringKeyColumn']]]:
        """
        Clustering key columns of the table
        """
        return pulumi.get(self, "clustering_key_columns")

    @property
    @pulumi.getter(name="defaultTimeToLive")
    def default_time_to_live(self) -> pulumi.Output[Optional[int]]:
        """
        Default TTL (Time To Live) in seconds, where zero is disabled. If the value is greater than zero, TTL is enabled for the entire table and an expiration timestamp is added to each column.
        """
        return pulumi.get(self, "default_time_to_live")

    @property
    @pulumi.getter(name="encryptionSpecification")
    def encryption_specification(self) -> pulumi.Output[Optional['outputs.TableEncryptionSpecification']]:
        """
        The encryption at rest options for the table.

        - *AWS owned key* (default) - The key is owned by Amazon Keyspaces .
        - *Customer managed key* - The key is stored in your account and is created, owned, and managed by you.

        > If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.

        For more information, see [Encryption at rest in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide* .
        """
        return pulumi.get(self, "encryption_specification")

    @property
    @pulumi.getter(name="keyspaceName")
    def keyspace_name(self) -> pulumi.Output[str]:
        """
        Name for Cassandra keyspace
        """
        return pulumi.get(self, "keyspace_name")

    @property
    @pulumi.getter(name="partitionKeyColumns")
    def partition_key_columns(self) -> pulumi.Output[Sequence['outputs.TableColumn']]:
        """
        Partition key columns of the table
        """
        return pulumi.get(self, "partition_key_columns")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="regularColumns")
    def regular_columns(self) -> pulumi.Output[Optional[Sequence['outputs.TableColumn']]]:
        """
        Non-key columns of the table
        """
        return pulumi.get(self, "regular_columns")

    @property
    @pulumi.getter(name="replicaSpecifications")
    def replica_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.TableReplicaSpecification']]]:
        """
        The AWS Region specific settings of a multi-Region table.

        For a multi-Region table, you can configure the table's read capacity differently per AWS Region. You can do this by configuring the following parameters.

        - `region` : The Region where these settings are applied. (Required)
        - `readCapacityUnits` : The provisioned read capacity units. (Optional)
        - `readCapacityAutoScaling` : The read capacity auto scaling settings for the table. (Optional)
        """
        return pulumi.get(self, "replica_specifications")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name for Cassandra table
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource
        """
        return pulumi.get(self, "tags")

