# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BudgetsActionActionThreshold',
    'BudgetsActionDefinition',
    'BudgetsActionIamActionDefinition',
    'BudgetsActionScpActionDefinition',
    'BudgetsActionSsmActionDefinition',
    'BudgetsActionSubscriber',
]

@pulumi.output_type
class BudgetsActionActionThreshold(dict):
    def __init__(__self__, *,
                 type: 'BudgetsActionActionThresholdType',
                 value: float):
        """
        :param 'BudgetsActionActionThresholdType' type: The type of threshold for a notification.
        :param float value: The threshold of a notification.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'BudgetsActionActionThresholdType':
        """
        The type of threshold for a notification.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold of a notification.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BudgetsActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamActionDefinition":
            suggest = "iam_action_definition"
        elif key == "scpActionDefinition":
            suggest = "scp_action_definition"
        elif key == "ssmActionDefinition":
            suggest = "ssm_action_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetsActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetsActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetsActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_action_definition: Optional['outputs.BudgetsActionIamActionDefinition'] = None,
                 scp_action_definition: Optional['outputs.BudgetsActionScpActionDefinition'] = None,
                 ssm_action_definition: Optional['outputs.BudgetsActionSsmActionDefinition'] = None):
        """
        :param 'BudgetsActionIamActionDefinition' iam_action_definition: The AWS Identity and Access Management ( IAM ) action definition details.
        :param 'BudgetsActionScpActionDefinition' scp_action_definition: The service control policies (SCP) action definition details.
        :param 'BudgetsActionSsmActionDefinition' ssm_action_definition: The Amazon EC2 Systems Manager ( SSM ) action definition details.
        """
        if iam_action_definition is not None:
            pulumi.set(__self__, "iam_action_definition", iam_action_definition)
        if scp_action_definition is not None:
            pulumi.set(__self__, "scp_action_definition", scp_action_definition)
        if ssm_action_definition is not None:
            pulumi.set(__self__, "ssm_action_definition", ssm_action_definition)

    @property
    @pulumi.getter(name="iamActionDefinition")
    def iam_action_definition(self) -> Optional['outputs.BudgetsActionIamActionDefinition']:
        """
        The AWS Identity and Access Management ( IAM ) action definition details.
        """
        return pulumi.get(self, "iam_action_definition")

    @property
    @pulumi.getter(name="scpActionDefinition")
    def scp_action_definition(self) -> Optional['outputs.BudgetsActionScpActionDefinition']:
        """
        The service control policies (SCP) action definition details.
        """
        return pulumi.get(self, "scp_action_definition")

    @property
    @pulumi.getter(name="ssmActionDefinition")
    def ssm_action_definition(self) -> Optional['outputs.BudgetsActionSsmActionDefinition']:
        """
        The Amazon EC2 Systems Manager ( SSM ) action definition details.
        """
        return pulumi.get(self, "ssm_action_definition")


@pulumi.output_type
class BudgetsActionIamActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyArn":
            suggest = "policy_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetsActionIamActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetsActionIamActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetsActionIamActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_arn: str,
                 groups: Optional[Sequence[str]] = None,
                 roles: Optional[Sequence[str]] = None,
                 users: Optional[Sequence[str]] = None):
        """
        :param str policy_arn: The Amazon Resource Name (ARN) of the policy to be attached.
        :param Sequence[str] groups: A list of groups to be attached. There must be at least one group.
        :param Sequence[str] roles: A list of roles to be attached. There must be at least one role.
        :param Sequence[str] users: A list of users to be attached. There must be at least one user.
        """
        pulumi.set(__self__, "policy_arn", policy_arn)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the policy to be attached.
        """
        return pulumi.get(self, "policy_arn")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[str]]:
        """
        A list of groups to be attached. There must be at least one group.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[str]]:
        """
        A list of roles to be attached. There must be at least one role.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def users(self) -> Optional[Sequence[str]]:
        """
        A list of users to be attached. There must be at least one user.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class BudgetsActionScpActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyId":
            suggest = "policy_id"
        elif key == "targetIds":
            suggest = "target_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetsActionScpActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetsActionScpActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetsActionScpActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_id: str,
                 target_ids: Sequence[str]):
        """
        :param str policy_id: The policy ID attached.
        :param Sequence[str] target_ids: A list of target IDs.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "target_ids", target_ids)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        """
        The policy ID attached.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Sequence[str]:
        """
        A list of target IDs.
        """
        return pulumi.get(self, "target_ids")


@pulumi.output_type
class BudgetsActionSsmActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceIds":
            suggest = "instance_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetsActionSsmActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetsActionSsmActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetsActionSsmActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_ids: Sequence[str],
                 region: str,
                 subtype: 'BudgetsActionSsmActionDefinitionSubtype'):
        """
        :param Sequence[str] instance_ids: The EC2 and RDS instance IDs.
        :param str region: The Region to run the ( SSM ) document.
        :param 'BudgetsActionSsmActionDefinitionSubtype' subtype: The action subType.
        """
        pulumi.set(__self__, "instance_ids", instance_ids)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subtype", subtype)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Sequence[str]:
        """
        The EC2 and RDS instance IDs.
        """
        return pulumi.get(self, "instance_ids")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The Region to run the ( SSM ) document.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def subtype(self) -> 'BudgetsActionSsmActionDefinitionSubtype':
        """
        The action subType.
        """
        return pulumi.get(self, "subtype")


@pulumi.output_type
class BudgetsActionSubscriber(dict):
    def __init__(__self__, *,
                 address: str,
                 type: 'BudgetsActionSubscriberType'):
        """
        :param str address: The address that AWS sends budget notifications to, either an SNS topic or an email.
               
               When you create a subscriber, the value of `Address` can't contain line breaks.
        :param 'BudgetsActionSubscriberType' type: The type of notification that AWS sends to a subscriber.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address that AWS sends budget notifications to, either an SNS topic or an email.

        When you create a subscriber, the value of `Address` can't contain line breaks.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def type(self) -> 'BudgetsActionSubscriberType':
        """
        The type of notification that AWS sends to a subscriber.
        """
        return pulumi.get(self, "type")


