# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AgentActionGroup',
    'AgentActionGroupExecutor0Properties',
    'AgentActionGroupExecutor1Properties',
    'AgentAliasHistoryEvent',
    'AgentAliasRoutingConfigurationListItem',
    'AgentApiSchema0Properties',
    'AgentApiSchema1Properties',
    'AgentFunction',
    'AgentFunctionSchema',
    'AgentGuardrailConfiguration',
    'AgentInferenceConfiguration',
    'AgentKnowledgeBase',
    'AgentParameterDetail',
    'AgentPromptConfiguration',
    'AgentPromptOverrideConfiguration',
    'AgentS3Identifier',
    'DataSourceBedrockFoundationModelConfiguration',
    'DataSourceChunkingConfiguration',
    'DataSourceConfiguration',
    'DataSourceConfluenceCrawlerConfiguration',
    'DataSourceConfluenceDataSourceConfiguration',
    'DataSourceConfluenceSourceConfiguration',
    'DataSourceCrawlFilterConfiguration',
    'DataSourceCustomTransformationConfiguration',
    'DataSourceFixedSizeChunkingConfiguration',
    'DataSourceHierarchicalChunkingConfiguration',
    'DataSourceHierarchicalChunkingLevelConfiguration',
    'DataSourceIntermediateStorage',
    'DataSourceParsingConfiguration',
    'DataSourceParsingPrompt',
    'DataSourcePatternObjectFilter',
    'DataSourcePatternObjectFilterConfiguration',
    'DataSourceS3DataSourceConfiguration',
    'DataSourceS3Location',
    'DataSourceSalesforceCrawlerConfiguration',
    'DataSourceSalesforceDataSourceConfiguration',
    'DataSourceSalesforceSourceConfiguration',
    'DataSourceSeedUrl',
    'DataSourceSemanticChunkingConfiguration',
    'DataSourceServerSideEncryptionConfiguration',
    'DataSourceSharePointCrawlerConfiguration',
    'DataSourceSharePointDataSourceConfiguration',
    'DataSourceSharePointSourceConfiguration',
    'DataSourceTransformation',
    'DataSourceTransformationFunction',
    'DataSourceTransformationLambdaConfiguration',
    'DataSourceUrlConfiguration',
    'DataSourceVectorIngestionConfiguration',
    'DataSourceWebCrawlerConfiguration',
    'DataSourceWebCrawlerLimits',
    'DataSourceWebDataSourceConfiguration',
    'DataSourceWebSourceConfiguration',
    'FlowAgentFlowNodeConfiguration',
    'FlowAliasRoutingConfigurationListItem',
    'FlowCollectorFlowNodeConfiguration',
    'FlowCondition',
    'FlowConditionFlowNodeConfiguration',
    'FlowConditionalConnectionConfiguration',
    'FlowConnection',
    'FlowConnectionConfiguration0Properties',
    'FlowConnectionConfiguration1Properties',
    'FlowDataConnectionConfiguration',
    'FlowDefinition',
    'FlowInputFlowNodeConfiguration',
    'FlowIteratorFlowNodeConfiguration',
    'FlowKnowledgeBaseFlowNodeConfiguration',
    'FlowLambdaFunctionFlowNodeConfiguration',
    'FlowLexFlowNodeConfiguration',
    'FlowNode',
    'FlowNodeConfiguration0Properties',
    'FlowNodeConfiguration10Properties',
    'FlowNodeConfiguration11Properties',
    'FlowNodeConfiguration1Properties',
    'FlowNodeConfiguration2Properties',
    'FlowNodeConfiguration3Properties',
    'FlowNodeConfiguration4Properties',
    'FlowNodeConfiguration5Properties',
    'FlowNodeConfiguration6Properties',
    'FlowNodeConfiguration7Properties',
    'FlowNodeConfiguration8Properties',
    'FlowNodeConfiguration9Properties',
    'FlowNodeInput',
    'FlowNodeOutput',
    'FlowOutputFlowNodeConfiguration',
    'FlowPromptFlowNodeConfiguration',
    'FlowPromptFlowNodeInlineConfiguration',
    'FlowPromptFlowNodeResourceConfiguration',
    'FlowPromptFlowNodeSourceConfiguration0Properties',
    'FlowPromptFlowNodeSourceConfiguration1Properties',
    'FlowPromptInferenceConfigurationProperties',
    'FlowPromptInputVariable',
    'FlowPromptModelInferenceConfiguration',
    'FlowPromptTemplateConfigurationProperties',
    'FlowRetrievalFlowNodeConfiguration',
    'FlowRetrievalFlowNodeS3Configuration',
    'FlowRetrievalFlowNodeServiceConfigurationProperties',
    'FlowS3Location',
    'FlowStorageFlowNodeConfiguration',
    'FlowStorageFlowNodeS3Configuration',
    'FlowStorageFlowNodeServiceConfigurationProperties',
    'FlowTextPromptTemplateConfiguration',
    'FlowValidation',
    'FlowVersionAgentFlowNodeConfiguration',
    'FlowVersionCollectorFlowNodeConfiguration',
    'FlowVersionConditionFlowNodeConfiguration',
    'FlowVersionFlowCondition',
    'FlowVersionFlowConditionalConnectionConfiguration',
    'FlowVersionFlowConnection',
    'FlowVersionFlowConnectionConfiguration0Properties',
    'FlowVersionFlowConnectionConfiguration1Properties',
    'FlowVersionFlowDataConnectionConfiguration',
    'FlowVersionFlowDefinition',
    'FlowVersionFlowNode',
    'FlowVersionFlowNodeConfiguration0Properties',
    'FlowVersionFlowNodeConfiguration10Properties',
    'FlowVersionFlowNodeConfiguration11Properties',
    'FlowVersionFlowNodeConfiguration1Properties',
    'FlowVersionFlowNodeConfiguration2Properties',
    'FlowVersionFlowNodeConfiguration3Properties',
    'FlowVersionFlowNodeConfiguration4Properties',
    'FlowVersionFlowNodeConfiguration5Properties',
    'FlowVersionFlowNodeConfiguration6Properties',
    'FlowVersionFlowNodeConfiguration7Properties',
    'FlowVersionFlowNodeConfiguration8Properties',
    'FlowVersionFlowNodeConfiguration9Properties',
    'FlowVersionFlowNodeInput',
    'FlowVersionFlowNodeOutput',
    'FlowVersionInputFlowNodeConfiguration',
    'FlowVersionIteratorFlowNodeConfiguration',
    'FlowVersionKnowledgeBaseFlowNodeConfiguration',
    'FlowVersionLambdaFunctionFlowNodeConfiguration',
    'FlowVersionLexFlowNodeConfiguration',
    'FlowVersionOutputFlowNodeConfiguration',
    'FlowVersionPromptFlowNodeConfiguration',
    'FlowVersionPromptFlowNodeInlineConfiguration',
    'FlowVersionPromptFlowNodeResourceConfiguration',
    'FlowVersionPromptFlowNodeSourceConfiguration0Properties',
    'FlowVersionPromptFlowNodeSourceConfiguration1Properties',
    'FlowVersionPromptInferenceConfigurationProperties',
    'FlowVersionPromptInputVariable',
    'FlowVersionPromptModelInferenceConfiguration',
    'FlowVersionPromptTemplateConfigurationProperties',
    'FlowVersionRetrievalFlowNodeConfiguration',
    'FlowVersionRetrievalFlowNodeS3Configuration',
    'FlowVersionRetrievalFlowNodeServiceConfigurationProperties',
    'FlowVersionStorageFlowNodeConfiguration',
    'FlowVersionStorageFlowNodeS3Configuration',
    'FlowVersionStorageFlowNodeServiceConfigurationProperties',
    'FlowVersionTextPromptTemplateConfiguration',
    'GuardrailContentFilterConfig',
    'GuardrailContentPolicyConfig',
    'GuardrailContextualGroundingFilterConfig',
    'GuardrailContextualGroundingPolicyConfig',
    'GuardrailManagedWordsConfig',
    'GuardrailPiiEntityConfig',
    'GuardrailRegexConfig',
    'GuardrailSensitiveInformationPolicyConfig',
    'GuardrailTopicConfig',
    'GuardrailTopicPolicyConfig',
    'GuardrailWordConfig',
    'GuardrailWordPolicyConfig',
    'KnowledgeBaseBedrockEmbeddingModelConfiguration',
    'KnowledgeBaseConfiguration',
    'KnowledgeBaseEmbeddingModelConfiguration',
    'KnowledgeBaseMongoDbAtlasConfiguration',
    'KnowledgeBaseMongoDbAtlasFieldMapping',
    'KnowledgeBaseOpenSearchServerlessConfiguration',
    'KnowledgeBaseOpenSearchServerlessFieldMapping',
    'KnowledgeBasePineconeConfiguration',
    'KnowledgeBasePineconeFieldMapping',
    'KnowledgeBaseRdsConfiguration',
    'KnowledgeBaseRdsFieldMapping',
    'KnowledgeBaseStorageConfiguration',
    'KnowledgeBaseVectorKnowledgeBaseConfiguration',
    'PromptInferenceConfigurationProperties',
    'PromptInputVariable',
    'PromptModelInferenceConfiguration',
    'PromptTemplateConfigurationProperties',
    'PromptTextPromptTemplateConfiguration',
    'PromptTextS3Location',
    'PromptVariant',
    'PromptVersionPromptInferenceConfigurationProperties',
    'PromptVersionPromptInputVariable',
    'PromptVersionPromptModelInferenceConfiguration',
    'PromptVersionPromptTemplateConfigurationProperties',
    'PromptVersionPromptVariant',
    'PromptVersionTextPromptTemplateConfiguration',
]

@pulumi.output_type
class AgentActionGroup(dict):
    """
    Contains the information of an Agent Action Group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroupName":
            suggest = "action_group_name"
        elif key == "actionGroupExecutor":
            suggest = "action_group_executor"
        elif key == "actionGroupState":
            suggest = "action_group_state"
        elif key == "apiSchema":
            suggest = "api_schema"
        elif key == "functionSchema":
            suggest = "function_schema"
        elif key == "parentActionGroupSignature":
            suggest = "parent_action_group_signature"
        elif key == "skipResourceInUseCheckOnDelete":
            suggest = "skip_resource_in_use_check_on_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentActionGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentActionGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentActionGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_group_name: str,
                 action_group_executor: Optional[Any] = None,
                 action_group_state: Optional['AgentActionGroupState'] = None,
                 api_schema: Optional[Any] = None,
                 description: Optional[str] = None,
                 function_schema: Optional['outputs.AgentFunctionSchema'] = None,
                 parent_action_group_signature: Optional['AgentActionGroupSignature'] = None,
                 skip_resource_in_use_check_on_delete: Optional[bool] = None):
        """
        Contains the information of an Agent Action Group
        :param str action_group_name: Name of the action group
        :param Union['AgentActionGroupExecutor0Properties', 'AgentActionGroupExecutor1Properties'] action_group_executor: The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.
        :param 'AgentActionGroupState' action_group_state: Specifies whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request.
        :param Union['AgentApiSchema0Properties', 'AgentApiSchema1Properties'] api_schema: Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html) .
        :param str description: Description of action group
        :param 'AgentFunctionSchema' function_schema: Defines functions that each define parameters that the agent needs to invoke from the user. Each function represents an action in an action group.
        :param 'AgentActionGroupSignature' parent_action_group_signature: If this field is set as `AMAZON.UserInput` , the agent can request the user for additional information when trying to complete a task. The `description` , `apiSchema` , and `actionGroupExecutor` fields must be blank for this action group.
               
               During orchestration, if the agent determines that it needs to invoke an API in an action group, but doesn't have enough information to complete the API request, it will invoke this action group instead and return an [Observation](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html) reprompting the user for more information.
        :param bool skip_resource_in_use_check_on_delete: Specifies whether to allow deleting action group while it is in use.
        """
        pulumi.set(__self__, "action_group_name", action_group_name)
        if action_group_executor is not None:
            pulumi.set(__self__, "action_group_executor", action_group_executor)
        if action_group_state is not None:
            pulumi.set(__self__, "action_group_state", action_group_state)
        if api_schema is not None:
            pulumi.set(__self__, "api_schema", api_schema)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if function_schema is not None:
            pulumi.set(__self__, "function_schema", function_schema)
        if parent_action_group_signature is not None:
            pulumi.set(__self__, "parent_action_group_signature", parent_action_group_signature)
        if skip_resource_in_use_check_on_delete is not None:
            pulumi.set(__self__, "skip_resource_in_use_check_on_delete", skip_resource_in_use_check_on_delete)

    @property
    @pulumi.getter(name="actionGroupName")
    def action_group_name(self) -> str:
        """
        Name of the action group
        """
        return pulumi.get(self, "action_group_name")

    @property
    @pulumi.getter(name="actionGroupExecutor")
    def action_group_executor(self) -> Optional[Any]:
        """
        The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.
        """
        return pulumi.get(self, "action_group_executor")

    @property
    @pulumi.getter(name="actionGroupState")
    def action_group_state(self) -> Optional['AgentActionGroupState']:
        """
        Specifies whether the action group is available for the agent to invoke or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request.
        """
        return pulumi.get(self, "action_group_state")

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> Optional[Any]:
        """
        Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html) .
        """
        return pulumi.get(self, "api_schema")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of action group
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionSchema")
    def function_schema(self) -> Optional['outputs.AgentFunctionSchema']:
        """
        Defines functions that each define parameters that the agent needs to invoke from the user. Each function represents an action in an action group.
        """
        return pulumi.get(self, "function_schema")

    @property
    @pulumi.getter(name="parentActionGroupSignature")
    def parent_action_group_signature(self) -> Optional['AgentActionGroupSignature']:
        """
        If this field is set as `AMAZON.UserInput` , the agent can request the user for additional information when trying to complete a task. The `description` , `apiSchema` , and `actionGroupExecutor` fields must be blank for this action group.

        During orchestration, if the agent determines that it needs to invoke an API in an action group, but doesn't have enough information to complete the API request, it will invoke this action group instead and return an [Observation](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html) reprompting the user for more information.
        """
        return pulumi.get(self, "parent_action_group_signature")

    @property
    @pulumi.getter(name="skipResourceInUseCheckOnDelete")
    def skip_resource_in_use_check_on_delete(self) -> Optional[bool]:
        """
        Specifies whether to allow deleting action group while it is in use.
        """
        return pulumi.get(self, "skip_resource_in_use_check_on_delete")


@pulumi.output_type
class AgentActionGroupExecutor0Properties(dict):
    """
    Type of Executors for an Action Group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambda":
            suggest = "lambda_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentActionGroupExecutor0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentActionGroupExecutor0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentActionGroupExecutor0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_: str):
        """
        Type of Executors for an Action Group
        :param str lambda_: ARN of a Lambda.
        """
        pulumi.set(__self__, "lambda_", lambda_)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> str:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "lambda_")


@pulumi.output_type
class AgentActionGroupExecutor1Properties(dict):
    """
    Type of Executors for an Action Group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customControl":
            suggest = "custom_control"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentActionGroupExecutor1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentActionGroupExecutor1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentActionGroupExecutor1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_control: 'AgentCustomControlMethod'):
        """
        Type of Executors for an Action Group
        """
        pulumi.set(__self__, "custom_control", custom_control)

    @property
    @pulumi.getter(name="customControl")
    def custom_control(self) -> 'AgentCustomControlMethod':
        return pulumi.get(self, "custom_control")


@pulumi.output_type
class AgentAliasHistoryEvent(dict):
    """
    History event for an alias for an Agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "routingConfiguration":
            suggest = "routing_configuration"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentAliasHistoryEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentAliasHistoryEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentAliasHistoryEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: Optional[str] = None,
                 routing_configuration: Optional[Sequence['outputs.AgentAliasRoutingConfigurationListItem']] = None,
                 start_date: Optional[str] = None):
        """
        History event for an alias for an Agent.
        :param str end_date: Time Stamp.
        :param Sequence['AgentAliasRoutingConfigurationListItem'] routing_configuration: Routing configuration for an Agent alias.
        :param str start_date: Time Stamp.
        """
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[Sequence['outputs.AgentAliasRoutingConfigurationListItem']]:
        """
        Routing configuration for an Agent alias.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class AgentAliasRoutingConfigurationListItem(dict):
    """
    Details about the routing configuration for an Agent alias.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersion":
            suggest = "agent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentAliasRoutingConfigurationListItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentAliasRoutingConfigurationListItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentAliasRoutingConfigurationListItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version: str):
        """
        Details about the routing configuration for an Agent alias.
        :param str agent_version: Agent Version.
        """
        pulumi.set(__self__, "agent_version", agent_version)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        Agent Version.
        """
        return pulumi.get(self, "agent_version")


@pulumi.output_type
class AgentApiSchema0Properties(dict):
    """
    Contains information about the API Schema for the Action Group
    """
    def __init__(__self__, *,
                 s3: 'outputs.AgentS3Identifier'):
        """
        Contains information about the API Schema for the Action Group
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.AgentS3Identifier':
        return pulumi.get(self, "s3")


@pulumi.output_type
class AgentApiSchema1Properties(dict):
    """
    Contains information about the API Schema for the Action Group
    """
    def __init__(__self__, *,
                 payload: str):
        """
        Contains information about the API Schema for the Action Group
        :param str payload: String OpenAPI Payload
        """
        pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter
    def payload(self) -> str:
        """
        String OpenAPI Payload
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AgentFunction(dict):
    """
    Function definition
    """
    def __init__(__self__, *,
                 name: str,
                 description: Optional[str] = None,
                 parameters: Optional[Mapping[str, 'outputs.AgentParameterDetail']] = None):
        """
        Function definition
        :param str name: Name for a resource.
        :param str description: Description of function
        :param Mapping[str, 'AgentParameterDetail'] parameters: The parameters that the agent elicits from the user to fulfill the function.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of function
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.AgentParameterDetail']]:
        """
        The parameters that the agent elicits from the user to fulfill the function.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AgentFunctionSchema(dict):
    """
    Schema of Functions
    """
    def __init__(__self__, *,
                 functions: Sequence['outputs.AgentFunction']):
        """
        Schema of Functions
        :param Sequence['AgentFunction'] functions: List of Function definitions
        """
        pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Sequence['outputs.AgentFunction']:
        """
        List of Function definitions
        """
        return pulumi.get(self, "functions")


@pulumi.output_type
class AgentGuardrailConfiguration(dict):
    """
    Configuration for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "guardrailIdentifier":
            suggest = "guardrail_identifier"
        elif key == "guardrailVersion":
            suggest = "guardrail_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentGuardrailConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentGuardrailConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentGuardrailConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 guardrail_identifier: Optional[str] = None,
                 guardrail_version: Optional[str] = None):
        """
        Configuration for a guardrail.
        :param str guardrail_identifier: Identifier for the guardrail, could be the id or the arn
        :param str guardrail_version: Version of the guardrail
        """
        if guardrail_identifier is not None:
            pulumi.set(__self__, "guardrail_identifier", guardrail_identifier)
        if guardrail_version is not None:
            pulumi.set(__self__, "guardrail_version", guardrail_version)

    @property
    @pulumi.getter(name="guardrailIdentifier")
    def guardrail_identifier(self) -> Optional[str]:
        """
        Identifier for the guardrail, could be the id or the arn
        """
        return pulumi.get(self, "guardrail_identifier")

    @property
    @pulumi.getter(name="guardrailVersion")
    def guardrail_version(self) -> Optional[str]:
        """
        Version of the guardrail
        """
        return pulumi.get(self, "guardrail_version")


@pulumi.output_type
class AgentInferenceConfiguration(dict):
    """
    Configuration for inference in prompt configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumLength":
            suggest = "maximum_length"
        elif key == "stopSequences":
            suggest = "stop_sequences"
        elif key == "topK":
            suggest = "top_k"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentInferenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentInferenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentInferenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_length: Optional[float] = None,
                 stop_sequences: Optional[Sequence[str]] = None,
                 temperature: Optional[float] = None,
                 top_k: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        Configuration for inference in prompt configuration
        :param float maximum_length: Maximum length of output
        :param Sequence[str] stop_sequences: List of stop sequences
        :param float temperature: Controls randomness, higher values increase diversity
        :param float top_k: Sample from the k most likely next tokens
        :param float top_p: Cumulative probability cutoff for token selection
        """
        if maximum_length is not None:
            pulumi.set(__self__, "maximum_length", maximum_length)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maximumLength")
    def maximum_length(self) -> Optional[float]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "maximum_length")

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[Sequence[str]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[float]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class AgentKnowledgeBase(dict):
    """
    Agent Knowledge Base
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBaseId":
            suggest = "knowledge_base_id"
        elif key == "knowledgeBaseState":
            suggest = "knowledge_base_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentKnowledgeBase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentKnowledgeBase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentKnowledgeBase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 knowledge_base_id: str,
                 knowledge_base_state: Optional['AgentKnowledgeBaseState'] = None):
        """
        Agent Knowledge Base
        :param str description: Description of the Resource.
        :param str knowledge_base_id: Identifier for a resource.
        :param 'AgentKnowledgeBaseState' knowledge_base_state: Specifies whether to use the knowledge base or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if knowledge_base_state is not None:
            pulumi.set(__self__, "knowledge_base_state", knowledge_base_state)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> str:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="knowledgeBaseState")
    def knowledge_base_state(self) -> Optional['AgentKnowledgeBaseState']:
        """
        Specifies whether to use the knowledge base or not when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request.
        """
        return pulumi.get(self, "knowledge_base_state")


@pulumi.output_type
class AgentParameterDetail(dict):
    """
    Parameter detail
    """
    def __init__(__self__, *,
                 type: 'AgentType',
                 description: Optional[str] = None,
                 required: Optional[bool] = None):
        """
        Parameter detail
        :param 'AgentType' type: The data type of the parameter.
        :param str description: Description of function parameter.
        :param bool required: Information about if a parameter is required for function call. Default to false.
        """
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def type(self) -> 'AgentType':
        """
        The data type of the parameter.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of function parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Information about if a parameter is required for function call. Default to false.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class AgentPromptConfiguration(dict):
    """
    BasePromptConfiguration per Prompt Type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basePromptTemplate":
            suggest = "base_prompt_template"
        elif key == "inferenceConfiguration":
            suggest = "inference_configuration"
        elif key == "parserMode":
            suggest = "parser_mode"
        elif key == "promptCreationMode":
            suggest = "prompt_creation_mode"
        elif key == "promptState":
            suggest = "prompt_state"
        elif key == "promptType":
            suggest = "prompt_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentPromptConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentPromptConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentPromptConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_prompt_template: Optional[str] = None,
                 inference_configuration: Optional['outputs.AgentInferenceConfiguration'] = None,
                 parser_mode: Optional['AgentCreationMode'] = None,
                 prompt_creation_mode: Optional['AgentCreationMode'] = None,
                 prompt_state: Optional['AgentPromptState'] = None,
                 prompt_type: Optional['AgentPromptType'] = None):
        """
        BasePromptConfiguration per Prompt Type.
        :param str base_prompt_template: Base Prompt Template.
        :param 'AgentInferenceConfiguration' inference_configuration: Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `promptType` . For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html) .
        :param 'AgentCreationMode' parser_mode: Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the `promptType` . If you set the field as `OVERRIDEN` , the `overrideLambda` field in the [PromptOverrideConfiguration](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html) must be specified with the ARN of a Lambda function.
        :param 'AgentCreationMode' prompt_creation_mode: Specifies whether to override the default prompt template for this `promptType` . Set this value to `OVERRIDDEN` to use the prompt that you provide in the `basePromptTemplate` . If you leave it as `DEFAULT` , the agent uses a default prompt template.
        :param 'AgentPromptState' prompt_state: Specifies whether to allow the agent to carry out the step specified in the `promptType` . If you set this value to `DISABLED` , the agent skips that step. The default state for each `promptType` is as follows.
               
               - `PRE_PROCESSING` – `ENABLED`
               - `ORCHESTRATION` – `ENABLED`
               - `KNOWLEDGE_BASE_RESPONSE_GENERATION` – `ENABLED`
               - `POST_PROCESSING` – `DISABLED`
        :param 'AgentPromptType' prompt_type: The step in the agent sequence that this prompt configuration applies to.
        """
        if base_prompt_template is not None:
            pulumi.set(__self__, "base_prompt_template", base_prompt_template)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)
        if parser_mode is not None:
            pulumi.set(__self__, "parser_mode", parser_mode)
        if prompt_creation_mode is not None:
            pulumi.set(__self__, "prompt_creation_mode", prompt_creation_mode)
        if prompt_state is not None:
            pulumi.set(__self__, "prompt_state", prompt_state)
        if prompt_type is not None:
            pulumi.set(__self__, "prompt_type", prompt_type)

    @property
    @pulumi.getter(name="basePromptTemplate")
    def base_prompt_template(self) -> Optional[str]:
        """
        Base Prompt Template.
        """
        return pulumi.get(self, "base_prompt_template")

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional['outputs.AgentInferenceConfiguration']:
        """
        Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `promptType` . For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html) .
        """
        return pulumi.get(self, "inference_configuration")

    @property
    @pulumi.getter(name="parserMode")
    def parser_mode(self) -> Optional['AgentCreationMode']:
        """
        Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the `promptType` . If you set the field as `OVERRIDEN` , the `overrideLambda` field in the [PromptOverrideConfiguration](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html) must be specified with the ARN of a Lambda function.
        """
        return pulumi.get(self, "parser_mode")

    @property
    @pulumi.getter(name="promptCreationMode")
    def prompt_creation_mode(self) -> Optional['AgentCreationMode']:
        """
        Specifies whether to override the default prompt template for this `promptType` . Set this value to `OVERRIDDEN` to use the prompt that you provide in the `basePromptTemplate` . If you leave it as `DEFAULT` , the agent uses a default prompt template.
        """
        return pulumi.get(self, "prompt_creation_mode")

    @property
    @pulumi.getter(name="promptState")
    def prompt_state(self) -> Optional['AgentPromptState']:
        """
        Specifies whether to allow the agent to carry out the step specified in the `promptType` . If you set this value to `DISABLED` , the agent skips that step. The default state for each `promptType` is as follows.

        - `PRE_PROCESSING` – `ENABLED`
        - `ORCHESTRATION` – `ENABLED`
        - `KNOWLEDGE_BASE_RESPONSE_GENERATION` – `ENABLED`
        - `POST_PROCESSING` – `DISABLED`
        """
        return pulumi.get(self, "prompt_state")

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> Optional['AgentPromptType']:
        """
        The step in the agent sequence that this prompt configuration applies to.
        """
        return pulumi.get(self, "prompt_type")


@pulumi.output_type
class AgentPromptOverrideConfiguration(dict):
    """
    Configuration for prompt override.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promptConfigurations":
            suggest = "prompt_configurations"
        elif key == "overrideLambda":
            suggest = "override_lambda"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentPromptOverrideConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentPromptOverrideConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentPromptOverrideConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prompt_configurations: Sequence['outputs.AgentPromptConfiguration'],
                 override_lambda: Optional[str] = None):
        """
        Configuration for prompt override.
        :param Sequence['AgentPromptConfiguration'] prompt_configurations: List of BasePromptConfiguration
        :param str override_lambda: ARN of a Lambda.
        """
        pulumi.set(__self__, "prompt_configurations", prompt_configurations)
        if override_lambda is not None:
            pulumi.set(__self__, "override_lambda", override_lambda)

    @property
    @pulumi.getter(name="promptConfigurations")
    def prompt_configurations(self) -> Sequence['outputs.AgentPromptConfiguration']:
        """
        List of BasePromptConfiguration
        """
        return pulumi.get(self, "prompt_configurations")

    @property
    @pulumi.getter(name="overrideLambda")
    def override_lambda(self) -> Optional[str]:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "override_lambda")


@pulumi.output_type
class AgentS3Identifier(dict):
    """
    The identifier for the S3 resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3ObjectKey":
            suggest = "s3_object_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentS3Identifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentS3Identifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentS3Identifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: Optional[str] = None,
                 s3_object_key: Optional[str] = None):
        """
        The identifier for the S3 resource.
        :param str s3_bucket_name: A bucket in S3.
        :param str s3_object_key: A object key in S3.
        """
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_key is not None:
            pulumi.set(__self__, "s3_object_key", s3_object_key)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        """
        A bucket in S3.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> Optional[str]:
        """
        A object key in S3.
        """
        return pulumi.get(self, "s3_object_key")


@pulumi.output_type
class DataSourceBedrockFoundationModelConfiguration(dict):
    """
    Settings for a foundation model used to parse documents for a data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelArn":
            suggest = "model_arn"
        elif key == "parsingPrompt":
            suggest = "parsing_prompt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceBedrockFoundationModelConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceBedrockFoundationModelConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceBedrockFoundationModelConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_arn: str,
                 parsing_prompt: Optional['outputs.DataSourceParsingPrompt'] = None):
        """
        Settings for a foundation model used to parse documents for a data source.
        :param str model_arn: The model's ARN.
        :param 'DataSourceParsingPrompt' parsing_prompt: Instructions for interpreting the contents of a document.
        """
        pulumi.set(__self__, "model_arn", model_arn)
        if parsing_prompt is not None:
            pulumi.set(__self__, "parsing_prompt", parsing_prompt)

    @property
    @pulumi.getter(name="modelArn")
    def model_arn(self) -> str:
        """
        The model's ARN.
        """
        return pulumi.get(self, "model_arn")

    @property
    @pulumi.getter(name="parsingPrompt")
    def parsing_prompt(self) -> Optional['outputs.DataSourceParsingPrompt']:
        """
        Instructions for interpreting the contents of a document.
        """
        return pulumi.get(self, "parsing_prompt")


@pulumi.output_type
class DataSourceChunkingConfiguration(dict):
    """
    Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkingStrategy":
            suggest = "chunking_strategy"
        elif key == "fixedSizeChunkingConfiguration":
            suggest = "fixed_size_chunking_configuration"
        elif key == "hierarchicalChunkingConfiguration":
            suggest = "hierarchical_chunking_configuration"
        elif key == "semanticChunkingConfiguration":
            suggest = "semantic_chunking_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceChunkingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceChunkingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceChunkingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunking_strategy: 'DataSourceChunkingStrategy',
                 fixed_size_chunking_configuration: Optional['outputs.DataSourceFixedSizeChunkingConfiguration'] = None,
                 hierarchical_chunking_configuration: Optional['outputs.DataSourceHierarchicalChunkingConfiguration'] = None,
                 semantic_chunking_configuration: Optional['outputs.DataSourceSemanticChunkingConfiguration'] = None):
        """
        Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        :param 'DataSourceChunkingStrategy' chunking_strategy: Knowledge base can split your source data into chunks. A *chunk* refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for `NONE` , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
               
               - `FIXED_SIZE` – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the `fixedSizeChunkingConfiguration` .
               - `HIERARCHICAL` – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
               - `SEMANTIC` – Split documents into chunks based on groups of similar content derived with natural language processing.
               - `NONE` – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.
        :param 'DataSourceFixedSizeChunkingConfiguration' fixed_size_chunking_configuration: Configurations for when you choose fixed-size chunking. If you set the `chunkingStrategy` as `NONE` , exclude this field.
        :param 'DataSourceHierarchicalChunkingConfiguration' hierarchical_chunking_configuration: Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
        :param 'DataSourceSemanticChunkingConfiguration' semantic_chunking_configuration: Settings for semantic document chunking for a data source. Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.
        """
        pulumi.set(__self__, "chunking_strategy", chunking_strategy)
        if fixed_size_chunking_configuration is not None:
            pulumi.set(__self__, "fixed_size_chunking_configuration", fixed_size_chunking_configuration)
        if hierarchical_chunking_configuration is not None:
            pulumi.set(__self__, "hierarchical_chunking_configuration", hierarchical_chunking_configuration)
        if semantic_chunking_configuration is not None:
            pulumi.set(__self__, "semantic_chunking_configuration", semantic_chunking_configuration)

    @property
    @pulumi.getter(name="chunkingStrategy")
    def chunking_strategy(self) -> 'DataSourceChunkingStrategy':
        """
        Knowledge base can split your source data into chunks. A *chunk* refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for `NONE` , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.

        - `FIXED_SIZE` – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the `fixedSizeChunkingConfiguration` .
        - `HIERARCHICAL` – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
        - `SEMANTIC` – Split documents into chunks based on groups of similar content derived with natural language processing.
        - `NONE` – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.
        """
        return pulumi.get(self, "chunking_strategy")

    @property
    @pulumi.getter(name="fixedSizeChunkingConfiguration")
    def fixed_size_chunking_configuration(self) -> Optional['outputs.DataSourceFixedSizeChunkingConfiguration']:
        """
        Configurations for when you choose fixed-size chunking. If you set the `chunkingStrategy` as `NONE` , exclude this field.
        """
        return pulumi.get(self, "fixed_size_chunking_configuration")

    @property
    @pulumi.getter(name="hierarchicalChunkingConfiguration")
    def hierarchical_chunking_configuration(self) -> Optional['outputs.DataSourceHierarchicalChunkingConfiguration']:
        """
        Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
        """
        return pulumi.get(self, "hierarchical_chunking_configuration")

    @property
    @pulumi.getter(name="semanticChunkingConfiguration")
    def semantic_chunking_configuration(self) -> Optional['outputs.DataSourceSemanticChunkingConfiguration']:
        """
        Settings for semantic document chunking for a data source. Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.
        """
        return pulumi.get(self, "semantic_chunking_configuration")


@pulumi.output_type
class DataSourceConfiguration(dict):
    """
    Specifies a raw data source location to ingest.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confluenceConfiguration":
            suggest = "confluence_configuration"
        elif key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "salesforceConfiguration":
            suggest = "salesforce_configuration"
        elif key == "sharePointConfiguration":
            suggest = "share_point_configuration"
        elif key == "webConfiguration":
            suggest = "web_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'DataSourceType',
                 confluence_configuration: Optional['outputs.DataSourceConfluenceDataSourceConfiguration'] = None,
                 s3_configuration: Optional['outputs.DataSourceS3DataSourceConfiguration'] = None,
                 salesforce_configuration: Optional['outputs.DataSourceSalesforceDataSourceConfiguration'] = None,
                 share_point_configuration: Optional['outputs.DataSourceSharePointDataSourceConfiguration'] = None,
                 web_configuration: Optional['outputs.DataSourceWebDataSourceConfiguration'] = None):
        """
        Specifies a raw data source location to ingest.
        :param 'DataSourceType' type: The type of data source.
        :param 'DataSourceConfluenceDataSourceConfiguration' confluence_configuration: The configuration information to connect to Confluence as your data source.
               
               > Confluence data source connector is in preview release and is subject to change.
        :param 'DataSourceS3DataSourceConfiguration' s3_configuration: The configuration information to connect to Amazon S3 as your data source.
        :param 'DataSourceSalesforceDataSourceConfiguration' salesforce_configuration: The configuration information to connect to Salesforce as your data source.
               
               > Salesforce data source connector is in preview release and is subject to change.
        :param 'DataSourceSharePointDataSourceConfiguration' share_point_configuration: The configuration information to connect to SharePoint as your data source.
               
               > SharePoint data source connector is in preview release and is subject to change.
        :param 'DataSourceWebDataSourceConfiguration' web_configuration: The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
               
               > Crawling web URLs as your data source is in preview release and is subject to change.
        """
        pulumi.set(__self__, "type", type)
        if confluence_configuration is not None:
            pulumi.set(__self__, "confluence_configuration", confluence_configuration)
        if s3_configuration is not None:
            pulumi.set(__self__, "s3_configuration", s3_configuration)
        if salesforce_configuration is not None:
            pulumi.set(__self__, "salesforce_configuration", salesforce_configuration)
        if share_point_configuration is not None:
            pulumi.set(__self__, "share_point_configuration", share_point_configuration)
        if web_configuration is not None:
            pulumi.set(__self__, "web_configuration", web_configuration)

    @property
    @pulumi.getter
    def type(self) -> 'DataSourceType':
        """
        The type of data source.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="confluenceConfiguration")
    def confluence_configuration(self) -> Optional['outputs.DataSourceConfluenceDataSourceConfiguration']:
        """
        The configuration information to connect to Confluence as your data source.

        > Confluence data source connector is in preview release and is subject to change.
        """
        return pulumi.get(self, "confluence_configuration")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> Optional['outputs.DataSourceS3DataSourceConfiguration']:
        """
        The configuration information to connect to Amazon S3 as your data source.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="salesforceConfiguration")
    def salesforce_configuration(self) -> Optional['outputs.DataSourceSalesforceDataSourceConfiguration']:
        """
        The configuration information to connect to Salesforce as your data source.

        > Salesforce data source connector is in preview release and is subject to change.
        """
        return pulumi.get(self, "salesforce_configuration")

    @property
    @pulumi.getter(name="sharePointConfiguration")
    def share_point_configuration(self) -> Optional['outputs.DataSourceSharePointDataSourceConfiguration']:
        """
        The configuration information to connect to SharePoint as your data source.

        > SharePoint data source connector is in preview release and is subject to change.
        """
        return pulumi.get(self, "share_point_configuration")

    @property
    @pulumi.getter(name="webConfiguration")
    def web_configuration(self) -> Optional['outputs.DataSourceWebDataSourceConfiguration']:
        """
        The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.

        > Crawling web URLs as your data source is in preview release and is subject to change.
        """
        return pulumi.get(self, "web_configuration")


@pulumi.output_type
class DataSourceConfluenceCrawlerConfiguration(dict):
    """
    The configuration of the Confluence content. For example, configuring specific types of Confluence content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterConfiguration":
            suggest = "filter_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfluenceCrawlerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfluenceCrawlerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfluenceCrawlerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_configuration: Optional['outputs.DataSourceCrawlFilterConfiguration'] = None):
        """
        The configuration of the Confluence content. For example, configuring specific types of Confluence content.
        :param 'DataSourceCrawlFilterConfiguration' filter_configuration: The configuration of filtering the Confluence content. For example, configuring regular expression patterns to include or exclude certain content.
        """
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.DataSourceCrawlFilterConfiguration']:
        """
        The configuration of filtering the Confluence content. For example, configuring regular expression patterns to include or exclude certain content.
        """
        return pulumi.get(self, "filter_configuration")


@pulumi.output_type
class DataSourceConfluenceDataSourceConfiguration(dict):
    """
    The configuration information to connect to Confluence as your data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConfiguration":
            suggest = "source_configuration"
        elif key == "crawlerConfiguration":
            suggest = "crawler_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfluenceDataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfluenceDataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfluenceDataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_configuration: 'outputs.DataSourceConfluenceSourceConfiguration',
                 crawler_configuration: Optional['outputs.DataSourceConfluenceCrawlerConfiguration'] = None):
        """
        The configuration information to connect to Confluence as your data source.
        :param 'DataSourceConfluenceSourceConfiguration' source_configuration: The endpoint information to connect to your Confluence data source.
        :param 'DataSourceConfluenceCrawlerConfiguration' crawler_configuration: The configuration of the Confluence content. For example, configuring specific types of Confluence content.
        """
        pulumi.set(__self__, "source_configuration", source_configuration)
        if crawler_configuration is not None:
            pulumi.set(__self__, "crawler_configuration", crawler_configuration)

    @property
    @pulumi.getter(name="sourceConfiguration")
    def source_configuration(self) -> 'outputs.DataSourceConfluenceSourceConfiguration':
        """
        The endpoint information to connect to your Confluence data source.
        """
        return pulumi.get(self, "source_configuration")

    @property
    @pulumi.getter(name="crawlerConfiguration")
    def crawler_configuration(self) -> Optional['outputs.DataSourceConfluenceCrawlerConfiguration']:
        """
        The configuration of the Confluence content. For example, configuring specific types of Confluence content.
        """
        return pulumi.get(self, "crawler_configuration")


@pulumi.output_type
class DataSourceConfluenceSourceConfiguration(dict):
    """
    The endpoint information to connect to your Confluence data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "hostType":
            suggest = "host_type"
        elif key == "hostUrl":
            suggest = "host_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfluenceSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfluenceSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfluenceSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: 'DataSourceConfluenceSourceConfigurationAuthType',
                 credentials_secret_arn: str,
                 host_type: 'DataSourceConfluenceSourceConfigurationHostType',
                 host_url: str):
        """
        The endpoint information to connect to your Confluence data source.
        :param 'DataSourceConfluenceSourceConfigurationAuthType' auth_type: The supported authentication type to authenticate and connect to your Confluence instance.
        :param str credentials_secret_arn: The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Confluence instance URL. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see Confluence connection configuration.
        :param 'DataSourceConfluenceSourceConfigurationHostType' host_type: The supported host type, whether online/cloud or server/on-premises.
        :param str host_url: The Confluence host URL or instance URL.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "host_type", host_type)
        pulumi.set(__self__, "host_url", host_url)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> 'DataSourceConfluenceSourceConfigurationAuthType':
        """
        The supported authentication type to authenticate and connect to your Confluence instance.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Confluence instance URL. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see Confluence connection configuration.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> 'DataSourceConfluenceSourceConfigurationHostType':
        """
        The supported host type, whether online/cloud or server/on-premises.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> str:
        """
        The Confluence host URL or instance URL.
        """
        return pulumi.get(self, "host_url")


@pulumi.output_type
class DataSourceCrawlFilterConfiguration(dict):
    """
    The type of filtering that you want to apply to certain objects or content of the data source. For example, the PATTERN type is regular expression patterns you can apply to filter your content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patternObjectFilter":
            suggest = "pattern_object_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCrawlFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCrawlFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCrawlFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'DataSourceCrawlFilterConfigurationType',
                 pattern_object_filter: Optional['outputs.DataSourcePatternObjectFilterConfiguration'] = None):
        """
        The type of filtering that you want to apply to certain objects or content of the data source. For example, the PATTERN type is regular expression patterns you can apply to filter your content.
        :param 'DataSourceCrawlFilterConfigurationType' type: The crawl filter type.
        :param 'DataSourcePatternObjectFilterConfiguration' pattern_object_filter: The configuration of filtering certain objects or content types of the data source.
        """
        pulumi.set(__self__, "type", type)
        if pattern_object_filter is not None:
            pulumi.set(__self__, "pattern_object_filter", pattern_object_filter)

    @property
    @pulumi.getter
    def type(self) -> 'DataSourceCrawlFilterConfigurationType':
        """
        The crawl filter type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="patternObjectFilter")
    def pattern_object_filter(self) -> Optional['outputs.DataSourcePatternObjectFilterConfiguration']:
        """
        The configuration of filtering certain objects or content types of the data source.
        """
        return pulumi.get(self, "pattern_object_filter")


@pulumi.output_type
class DataSourceCustomTransformationConfiguration(dict):
    """
    Settings for customizing steps in the data source content ingestion pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intermediateStorage":
            suggest = "intermediate_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomTransformationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomTransformationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomTransformationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intermediate_storage: 'outputs.DataSourceIntermediateStorage',
                 transformations: Sequence['outputs.DataSourceTransformation']):
        """
        Settings for customizing steps in the data source content ingestion pipeline.
        :param 'DataSourceIntermediateStorage' intermediate_storage: An S3 bucket path for input and output objects.
        :param Sequence['DataSourceTransformation'] transformations: A list of Lambda functions that process documents.
        """
        pulumi.set(__self__, "intermediate_storage", intermediate_storage)
        pulumi.set(__self__, "transformations", transformations)

    @property
    @pulumi.getter(name="intermediateStorage")
    def intermediate_storage(self) -> 'outputs.DataSourceIntermediateStorage':
        """
        An S3 bucket path for input and output objects.
        """
        return pulumi.get(self, "intermediate_storage")

    @property
    @pulumi.getter
    def transformations(self) -> Sequence['outputs.DataSourceTransformation']:
        """
        A list of Lambda functions that process documents.
        """
        return pulumi.get(self, "transformations")


@pulumi.output_type
class DataSourceFixedSizeChunkingConfiguration(dict):
    """
    Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy as NONE, exclude this field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"
        elif key == "overlapPercentage":
            suggest = "overlap_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceFixedSizeChunkingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceFixedSizeChunkingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceFixedSizeChunkingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: int,
                 overlap_percentage: int):
        """
        Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy as NONE, exclude this field.
        :param int max_tokens: The maximum number of tokens to include in a chunk.
        :param int overlap_percentage: The percentage of overlap between adjacent chunks of a data source.
        """
        pulumi.set(__self__, "max_tokens", max_tokens)
        pulumi.set(__self__, "overlap_percentage", overlap_percentage)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> int:
        """
        The maximum number of tokens to include in a chunk.
        """
        return pulumi.get(self, "max_tokens")

    @property
    @pulumi.getter(name="overlapPercentage")
    def overlap_percentage(self) -> int:
        """
        The percentage of overlap between adjacent chunks of a data source.
        """
        return pulumi.get(self, "overlap_percentage")


@pulumi.output_type
class DataSourceHierarchicalChunkingConfiguration(dict):
    """
    Configurations for when you choose hierarchical chunking. If you set the chunkingStrategy as NONE, exclude this field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "levelConfigurations":
            suggest = "level_configurations"
        elif key == "overlapTokens":
            suggest = "overlap_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHierarchicalChunkingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHierarchicalChunkingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHierarchicalChunkingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level_configurations: Sequence['outputs.DataSourceHierarchicalChunkingLevelConfiguration'],
                 overlap_tokens: int):
        """
        Configurations for when you choose hierarchical chunking. If you set the chunkingStrategy as NONE, exclude this field.
        :param Sequence['DataSourceHierarchicalChunkingLevelConfiguration'] level_configurations: Token settings for each layer.
        :param int overlap_tokens: The number of tokens to repeat across chunks in the same layer.
        """
        pulumi.set(__self__, "level_configurations", level_configurations)
        pulumi.set(__self__, "overlap_tokens", overlap_tokens)

    @property
    @pulumi.getter(name="levelConfigurations")
    def level_configurations(self) -> Sequence['outputs.DataSourceHierarchicalChunkingLevelConfiguration']:
        """
        Token settings for each layer.
        """
        return pulumi.get(self, "level_configurations")

    @property
    @pulumi.getter(name="overlapTokens")
    def overlap_tokens(self) -> int:
        """
        The number of tokens to repeat across chunks in the same layer.
        """
        return pulumi.get(self, "overlap_tokens")


@pulumi.output_type
class DataSourceHierarchicalChunkingLevelConfiguration(dict):
    """
    Token settings for a layer in a hierarchical chunking configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHierarchicalChunkingLevelConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHierarchicalChunkingLevelConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHierarchicalChunkingLevelConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: int):
        """
        Token settings for a layer in a hierarchical chunking configuration.
        :param int max_tokens: The maximum number of tokens that a chunk can contain in this layer.
        """
        pulumi.set(__self__, "max_tokens", max_tokens)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> int:
        """
        The maximum number of tokens that a chunk can contain in this layer.
        """
        return pulumi.get(self, "max_tokens")


@pulumi.output_type
class DataSourceIntermediateStorage(dict):
    """
    A location for storing content from data sources temporarily as it is processed by custom components in the ingestion pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Location":
            suggest = "s3_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceIntermediateStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceIntermediateStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceIntermediateStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_location: 'outputs.DataSourceS3Location'):
        """
        A location for storing content from data sources temporarily as it is processed by custom components in the ingestion pipeline.
        :param 'DataSourceS3Location' s3_location: An S3 bucket path.
        """
        pulumi.set(__self__, "s3_location", s3_location)

    @property
    @pulumi.getter(name="s3Location")
    def s3_location(self) -> 'outputs.DataSourceS3Location':
        """
        An S3 bucket path.
        """
        return pulumi.get(self, "s3_location")


@pulumi.output_type
class DataSourceParsingConfiguration(dict):
    """
    Settings for parsing document contents
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parsingStrategy":
            suggest = "parsing_strategy"
        elif key == "bedrockFoundationModelConfiguration":
            suggest = "bedrock_foundation_model_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceParsingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceParsingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceParsingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parsing_strategy: 'DataSourceParsingStrategy',
                 bedrock_foundation_model_configuration: Optional['outputs.DataSourceBedrockFoundationModelConfiguration'] = None):
        """
        Settings for parsing document contents
        :param 'DataSourceParsingStrategy' parsing_strategy: The parsing strategy for the data source.
        :param 'DataSourceBedrockFoundationModelConfiguration' bedrock_foundation_model_configuration: Settings for a foundation model used to parse documents for a data source.
        """
        pulumi.set(__self__, "parsing_strategy", parsing_strategy)
        if bedrock_foundation_model_configuration is not None:
            pulumi.set(__self__, "bedrock_foundation_model_configuration", bedrock_foundation_model_configuration)

    @property
    @pulumi.getter(name="parsingStrategy")
    def parsing_strategy(self) -> 'DataSourceParsingStrategy':
        """
        The parsing strategy for the data source.
        """
        return pulumi.get(self, "parsing_strategy")

    @property
    @pulumi.getter(name="bedrockFoundationModelConfiguration")
    def bedrock_foundation_model_configuration(self) -> Optional['outputs.DataSourceBedrockFoundationModelConfiguration']:
        """
        Settings for a foundation model used to parse documents for a data source.
        """
        return pulumi.get(self, "bedrock_foundation_model_configuration")


@pulumi.output_type
class DataSourceParsingPrompt(dict):
    """
    Instructions for interpreting the contents of a document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parsingPromptText":
            suggest = "parsing_prompt_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceParsingPrompt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceParsingPrompt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceParsingPrompt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parsing_prompt_text: str):
        """
        Instructions for interpreting the contents of a document.
        :param str parsing_prompt_text: Instructions for interpreting the contents of a document.
        """
        pulumi.set(__self__, "parsing_prompt_text", parsing_prompt_text)

    @property
    @pulumi.getter(name="parsingPromptText")
    def parsing_prompt_text(self) -> str:
        """
        Instructions for interpreting the contents of a document.
        """
        return pulumi.get(self, "parsing_prompt_text")


@pulumi.output_type
class DataSourcePatternObjectFilter(dict):
    """
    The specific filters applied to your data source content. You can filter out or include certain content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"
        elif key == "exclusionFilters":
            suggest = "exclusion_filters"
        elif key == "inclusionFilters":
            suggest = "inclusion_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourcePatternObjectFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourcePatternObjectFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourcePatternObjectFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str,
                 exclusion_filters: Optional[Sequence[str]] = None,
                 inclusion_filters: Optional[Sequence[str]] = None):
        """
        The specific filters applied to your data source content. You can filter out or include certain content.
        :param str object_type: The supported object type or content type of the data source.
        """
        pulumi.set(__self__, "object_type", object_type)
        if exclusion_filters is not None:
            pulumi.set(__self__, "exclusion_filters", exclusion_filters)
        if inclusion_filters is not None:
            pulumi.set(__self__, "inclusion_filters", inclusion_filters)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        The supported object type or content type of the data source.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "exclusion_filters")

    @property
    @pulumi.getter(name="inclusionFilters")
    def inclusion_filters(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "inclusion_filters")


@pulumi.output_type
class DataSourcePatternObjectFilterConfiguration(dict):
    """
    The configuration of specific filters applied to your data source content. You can filter out or include certain content.
    """
    def __init__(__self__, *,
                 filters: Sequence['outputs.DataSourcePatternObjectFilter']):
        """
        The configuration of specific filters applied to your data source content. You can filter out or include certain content.
        :param Sequence['DataSourcePatternObjectFilter'] filters: The configuration of specific filters applied to your data source content. You can filter out or include certain content.
        """
        pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.DataSourcePatternObjectFilter']:
        """
        The configuration of specific filters applied to your data source content. You can filter out or include certain content.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class DataSourceS3DataSourceConfiguration(dict):
    """
    The configuration information to connect to Amazon S3 as your data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "bucketOwnerAccountId":
            suggest = "bucket_owner_account_id"
        elif key == "inclusionPrefixes":
            suggest = "inclusion_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceS3DataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceS3DataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceS3DataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 bucket_owner_account_id: Optional[str] = None,
                 inclusion_prefixes: Optional[Sequence[str]] = None):
        """
        The configuration information to connect to Amazon S3 as your data source.
        :param str bucket_arn: The ARN of the bucket that contains the data source.
        :param str bucket_owner_account_id: The account ID for the owner of the S3 bucket.
        :param Sequence[str] inclusion_prefixes: A list of S3 prefixes that define the object containing the data sources.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if bucket_owner_account_id is not None:
            pulumi.set(__self__, "bucket_owner_account_id", bucket_owner_account_id)
        if inclusion_prefixes is not None:
            pulumi.set(__self__, "inclusion_prefixes", inclusion_prefixes)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        The ARN of the bucket that contains the data source.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="bucketOwnerAccountId")
    def bucket_owner_account_id(self) -> Optional[str]:
        """
        The account ID for the owner of the S3 bucket.
        """
        return pulumi.get(self, "bucket_owner_account_id")

    @property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Optional[Sequence[str]]:
        """
        A list of S3 prefixes that define the object containing the data sources.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class DataSourceS3Location(dict):
    """
    An Amazon S3 location.
    """
    def __init__(__self__, *,
                 uri: str):
        """
        An Amazon S3 location.
        :param str uri: The location's URI
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The location's URI
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class DataSourceSalesforceCrawlerConfiguration(dict):
    """
    The configuration of filtering the Salesforce content. For example, configuring regular expression patterns to include or exclude certain content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterConfiguration":
            suggest = "filter_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSalesforceCrawlerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSalesforceCrawlerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSalesforceCrawlerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_configuration: Optional['outputs.DataSourceCrawlFilterConfiguration'] = None):
        """
        The configuration of filtering the Salesforce content. For example, configuring regular expression patterns to include or exclude certain content.
        :param 'DataSourceCrawlFilterConfiguration' filter_configuration: The configuration of filtering the Salesforce content. For example, configuring regular expression patterns to include or exclude certain content.
        """
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.DataSourceCrawlFilterConfiguration']:
        """
        The configuration of filtering the Salesforce content. For example, configuring regular expression patterns to include or exclude certain content.
        """
        return pulumi.get(self, "filter_configuration")


@pulumi.output_type
class DataSourceSalesforceDataSourceConfiguration(dict):
    """
    The configuration information to connect to Salesforce as your data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConfiguration":
            suggest = "source_configuration"
        elif key == "crawlerConfiguration":
            suggest = "crawler_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSalesforceDataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSalesforceDataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSalesforceDataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_configuration: 'outputs.DataSourceSalesforceSourceConfiguration',
                 crawler_configuration: Optional['outputs.DataSourceSalesforceCrawlerConfiguration'] = None):
        """
        The configuration information to connect to Salesforce as your data source.
        :param 'DataSourceSalesforceSourceConfiguration' source_configuration: The endpoint information to connect to your Salesforce data source.
        :param 'DataSourceSalesforceCrawlerConfiguration' crawler_configuration: The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.
        """
        pulumi.set(__self__, "source_configuration", source_configuration)
        if crawler_configuration is not None:
            pulumi.set(__self__, "crawler_configuration", crawler_configuration)

    @property
    @pulumi.getter(name="sourceConfiguration")
    def source_configuration(self) -> 'outputs.DataSourceSalesforceSourceConfiguration':
        """
        The endpoint information to connect to your Salesforce data source.
        """
        return pulumi.get(self, "source_configuration")

    @property
    @pulumi.getter(name="crawlerConfiguration")
    def crawler_configuration(self) -> Optional['outputs.DataSourceSalesforceCrawlerConfiguration']:
        """
        The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.
        """
        return pulumi.get(self, "crawler_configuration")


@pulumi.output_type
class DataSourceSalesforceSourceConfiguration(dict):
    """
    The endpoint information to connect to your Salesforce data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "hostUrl":
            suggest = "host_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSalesforceSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSalesforceSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSalesforceSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: 'DataSourceSalesforceSourceConfigurationAuthType',
                 credentials_secret_arn: str,
                 host_url: str):
        """
        The endpoint information to connect to your Salesforce data source.
        :param 'DataSourceSalesforceSourceConfigurationAuthType' auth_type: The supported authentication type to authenticate and connect to your Salesforce instance.
        :param str credentials_secret_arn: The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Salesforce instance URL. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see Salesforce connection configuration.
        :param str host_url: The Salesforce host URL or instance URL.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "host_url", host_url)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> 'DataSourceSalesforceSourceConfigurationAuthType':
        """
        The supported authentication type to authenticate and connect to your Salesforce instance.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your Salesforce instance URL. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see Salesforce connection configuration.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> str:
        """
        The Salesforce host URL or instance URL.
        """
        return pulumi.get(self, "host_url")


@pulumi.output_type
class DataSourceSeedUrl(dict):
    """
    A seed url object.
    """
    def __init__(__self__, *,
                 url: str):
        """
        A seed url object.
        :param str url: A web url.
        """
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        A web url.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DataSourceSemanticChunkingConfiguration(dict):
    """
    Configurations for when you choose semantic chunking. If you set the chunkingStrategy as NONE, exclude this field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakpointPercentileThreshold":
            suggest = "breakpoint_percentile_threshold"
        elif key == "bufferSize":
            suggest = "buffer_size"
        elif key == "maxTokens":
            suggest = "max_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSemanticChunkingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSemanticChunkingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSemanticChunkingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakpoint_percentile_threshold: int,
                 buffer_size: int,
                 max_tokens: int):
        """
        Configurations for when you choose semantic chunking. If you set the chunkingStrategy as NONE, exclude this field.
        :param int breakpoint_percentile_threshold: The dissimilarity threshold for splitting chunks.
        :param int buffer_size: The buffer size.
        :param int max_tokens: The maximum number of tokens that a chunk can contain.
        """
        pulumi.set(__self__, "breakpoint_percentile_threshold", breakpoint_percentile_threshold)
        pulumi.set(__self__, "buffer_size", buffer_size)
        pulumi.set(__self__, "max_tokens", max_tokens)

    @property
    @pulumi.getter(name="breakpointPercentileThreshold")
    def breakpoint_percentile_threshold(self) -> int:
        """
        The dissimilarity threshold for splitting chunks.
        """
        return pulumi.get(self, "breakpoint_percentile_threshold")

    @property
    @pulumi.getter(name="bufferSize")
    def buffer_size(self) -> int:
        """
        The buffer size.
        """
        return pulumi.get(self, "buffer_size")

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> int:
        """
        The maximum number of tokens that a chunk can contain.
        """
        return pulumi.get(self, "max_tokens")


@pulumi.output_type
class DataSourceServerSideEncryptionConfiguration(dict):
    """
    Contains details about the server-side encryption for the data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceServerSideEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceServerSideEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceServerSideEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: Optional[str] = None):
        """
        Contains details about the server-side encryption for the data source.
        :param str kms_key_arn: The ARN of the AWS KMS key used to encrypt the resource.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        The ARN of the AWS KMS key used to encrypt the resource.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class DataSourceSharePointCrawlerConfiguration(dict):
    """
    The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterConfiguration":
            suggest = "filter_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSharePointCrawlerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSharePointCrawlerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSharePointCrawlerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_configuration: Optional['outputs.DataSourceCrawlFilterConfiguration'] = None):
        """
        The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
        :param 'DataSourceCrawlFilterConfiguration' filter_configuration: The configuration of filtering the SharePoint content. For example, configuring regular expression patterns to include or exclude certain content.
        """
        if filter_configuration is not None:
            pulumi.set(__self__, "filter_configuration", filter_configuration)

    @property
    @pulumi.getter(name="filterConfiguration")
    def filter_configuration(self) -> Optional['outputs.DataSourceCrawlFilterConfiguration']:
        """
        The configuration of filtering the SharePoint content. For example, configuring regular expression patterns to include or exclude certain content.
        """
        return pulumi.get(self, "filter_configuration")


@pulumi.output_type
class DataSourceSharePointDataSourceConfiguration(dict):
    """
    The configuration information to connect to SharePoint as your data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConfiguration":
            suggest = "source_configuration"
        elif key == "crawlerConfiguration":
            suggest = "crawler_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSharePointDataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSharePointDataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSharePointDataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_configuration: 'outputs.DataSourceSharePointSourceConfiguration',
                 crawler_configuration: Optional['outputs.DataSourceSharePointCrawlerConfiguration'] = None):
        """
        The configuration information to connect to SharePoint as your data source.
        :param 'DataSourceSharePointSourceConfiguration' source_configuration: The endpoint information to connect to your SharePoint data source.
        :param 'DataSourceSharePointCrawlerConfiguration' crawler_configuration: The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
        """
        pulumi.set(__self__, "source_configuration", source_configuration)
        if crawler_configuration is not None:
            pulumi.set(__self__, "crawler_configuration", crawler_configuration)

    @property
    @pulumi.getter(name="sourceConfiguration")
    def source_configuration(self) -> 'outputs.DataSourceSharePointSourceConfiguration':
        """
        The endpoint information to connect to your SharePoint data source.
        """
        return pulumi.get(self, "source_configuration")

    @property
    @pulumi.getter(name="crawlerConfiguration")
    def crawler_configuration(self) -> Optional['outputs.DataSourceSharePointCrawlerConfiguration']:
        """
        The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
        """
        return pulumi.get(self, "crawler_configuration")


@pulumi.output_type
class DataSourceSharePointSourceConfiguration(dict):
    """
    The endpoint information to connect to your SharePoint data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "hostType":
            suggest = "host_type"
        elif key == "siteUrls":
            suggest = "site_urls"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceSharePointSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceSharePointSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceSharePointSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: 'DataSourceSharePointSourceConfigurationAuthType',
                 credentials_secret_arn: str,
                 domain: str,
                 host_type: 'DataSourceSharePointSourceConfigurationHostType',
                 site_urls: Sequence[str],
                 tenant_id: Optional[str] = None):
        """
        The endpoint information to connect to your SharePoint data source.
        :param 'DataSourceSharePointSourceConfigurationAuthType' auth_type: The supported authentication type to authenticate and connect to your SharePoint site/sites.
        :param str credentials_secret_arn: The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see SharePoint connection configuration.
        :param str domain: The domain of your SharePoint instance or site URL/URLs.
        :param 'DataSourceSharePointSourceConfigurationHostType' host_type: The supported host type, whether online/cloud or server/on-premises.
        :param Sequence[str] site_urls: A list of one or more SharePoint site URLs.
        :param str tenant_id: The identifier of your Microsoft 365 tenant.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "host_type", host_type)
        pulumi.set(__self__, "site_urls", site_urls)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> 'DataSourceSharePointSourceConfigurationAuthType':
        """
        The supported authentication type to authenticate and connect to your SharePoint site/sites.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The Amazon Resource Name of an AWS Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see SharePoint connection configuration.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain of your SharePoint instance or site URL/URLs.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> 'DataSourceSharePointSourceConfigurationHostType':
        """
        The supported host type, whether online/cloud or server/on-premises.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter(name="siteUrls")
    def site_urls(self) -> Sequence[str]:
        """
        A list of one or more SharePoint site URLs.
        """
        return pulumi.get(self, "site_urls")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The identifier of your Microsoft 365 tenant.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DataSourceTransformation(dict):
    """
    A Lambda function that processes documents.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepToApply":
            suggest = "step_to_apply"
        elif key == "transformationFunction":
            suggest = "transformation_function"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceTransformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceTransformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceTransformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 step_to_apply: 'DataSourceTransformationStepToApply',
                 transformation_function: 'outputs.DataSourceTransformationFunction'):
        """
        A Lambda function that processes documents.
        :param 'DataSourceTransformationStepToApply' step_to_apply: When the service applies the transformation.
        :param 'DataSourceTransformationFunction' transformation_function: A Lambda function that processes documents.
        """
        pulumi.set(__self__, "step_to_apply", step_to_apply)
        pulumi.set(__self__, "transformation_function", transformation_function)

    @property
    @pulumi.getter(name="stepToApply")
    def step_to_apply(self) -> 'DataSourceTransformationStepToApply':
        """
        When the service applies the transformation.
        """
        return pulumi.get(self, "step_to_apply")

    @property
    @pulumi.getter(name="transformationFunction")
    def transformation_function(self) -> 'outputs.DataSourceTransformationFunction':
        """
        A Lambda function that processes documents.
        """
        return pulumi.get(self, "transformation_function")


@pulumi.output_type
class DataSourceTransformationFunction(dict):
    """
    A Lambda function that processes documents.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transformationLambdaConfiguration":
            suggest = "transformation_lambda_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceTransformationFunction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceTransformationFunction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceTransformationFunction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transformation_lambda_configuration: 'outputs.DataSourceTransformationLambdaConfiguration'):
        """
        A Lambda function that processes documents.
        :param 'DataSourceTransformationLambdaConfiguration' transformation_lambda_configuration: The Lambda function.
        """
        pulumi.set(__self__, "transformation_lambda_configuration", transformation_lambda_configuration)

    @property
    @pulumi.getter(name="transformationLambdaConfiguration")
    def transformation_lambda_configuration(self) -> 'outputs.DataSourceTransformationLambdaConfiguration':
        """
        The Lambda function.
        """
        return pulumi.get(self, "transformation_lambda_configuration")


@pulumi.output_type
class DataSourceTransformationLambdaConfiguration(dict):
    """
    A Lambda function that processes documents.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceTransformationLambdaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceTransformationLambdaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceTransformationLambdaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str):
        """
        A Lambda function that processes documents.
        :param str lambda_arn: The function's ARN identifier.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        The function's ARN identifier.
        """
        return pulumi.get(self, "lambda_arn")


@pulumi.output_type
class DataSourceUrlConfiguration(dict):
    """
    A url configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "seedUrls":
            suggest = "seed_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceUrlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceUrlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceUrlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 seed_urls: Sequence['outputs.DataSourceSeedUrl']):
        """
        A url configuration.
        :param Sequence['DataSourceSeedUrl'] seed_urls: One or more seed or starting point URLs.
        """
        pulumi.set(__self__, "seed_urls", seed_urls)

    @property
    @pulumi.getter(name="seedUrls")
    def seed_urls(self) -> Sequence['outputs.DataSourceSeedUrl']:
        """
        One or more seed or starting point URLs.
        """
        return pulumi.get(self, "seed_urls")


@pulumi.output_type
class DataSourceVectorIngestionConfiguration(dict):
    """
    Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkingConfiguration":
            suggest = "chunking_configuration"
        elif key == "customTransformationConfiguration":
            suggest = "custom_transformation_configuration"
        elif key == "parsingConfiguration":
            suggest = "parsing_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceVectorIngestionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceVectorIngestionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceVectorIngestionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunking_configuration: Optional['outputs.DataSourceChunkingConfiguration'] = None,
                 custom_transformation_configuration: Optional['outputs.DataSourceCustomTransformationConfiguration'] = None,
                 parsing_configuration: Optional['outputs.DataSourceParsingConfiguration'] = None):
        """
        Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        :param 'DataSourceChunkingConfiguration' chunking_configuration: Details about how to chunk the documents in the data source. A *chunk* refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        :param 'DataSourceCustomTransformationConfiguration' custom_transformation_configuration: A custom document transformer for parsed data source documents.
        :param 'DataSourceParsingConfiguration' parsing_configuration: A custom parser for data source documents.
        """
        if chunking_configuration is not None:
            pulumi.set(__self__, "chunking_configuration", chunking_configuration)
        if custom_transformation_configuration is not None:
            pulumi.set(__self__, "custom_transformation_configuration", custom_transformation_configuration)
        if parsing_configuration is not None:
            pulumi.set(__self__, "parsing_configuration", parsing_configuration)

    @property
    @pulumi.getter(name="chunkingConfiguration")
    def chunking_configuration(self) -> Optional['outputs.DataSourceChunkingConfiguration']:
        """
        Details about how to chunk the documents in the data source. A *chunk* refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        """
        return pulumi.get(self, "chunking_configuration")

    @property
    @pulumi.getter(name="customTransformationConfiguration")
    def custom_transformation_configuration(self) -> Optional['outputs.DataSourceCustomTransformationConfiguration']:
        """
        A custom document transformer for parsed data source documents.
        """
        return pulumi.get(self, "custom_transformation_configuration")

    @property
    @pulumi.getter(name="parsingConfiguration")
    def parsing_configuration(self) -> Optional['outputs.DataSourceParsingConfiguration']:
        """
        A custom parser for data source documents.
        """
        return pulumi.get(self, "parsing_configuration")


@pulumi.output_type
class DataSourceWebCrawlerConfiguration(dict):
    """
    Configuration for the web crawler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crawlerLimits":
            suggest = "crawler_limits"
        elif key == "exclusionFilters":
            suggest = "exclusion_filters"
        elif key == "inclusionFilters":
            suggest = "inclusion_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceWebCrawlerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceWebCrawlerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceWebCrawlerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crawler_limits: Optional['outputs.DataSourceWebCrawlerLimits'] = None,
                 exclusion_filters: Optional[Sequence[str]] = None,
                 inclusion_filters: Optional[Sequence[str]] = None,
                 scope: Optional['DataSourceWebScopeType'] = None):
        """
        Configuration for the web crawler.
        :param 'DataSourceWebCrawlerLimits' crawler_limits: The configuration of crawl limits for the web URLs.
        :param Sequence[str] exclusion_filters: A list of one or more exclusion regular expression patterns to exclude certain URLs. If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
        :param Sequence[str] inclusion_filters: A list of one or more inclusion regular expression patterns to include certain URLs. If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
        :param 'DataSourceWebScopeType' scope: The scope of what is crawled for your URLs.
               
               You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL "https://docs.aws.amazon.com/bedrock/latest/userguide/" and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain "aws.amazon.com" can also include sub domain "docs.aws.amazon.com".
        """
        if crawler_limits is not None:
            pulumi.set(__self__, "crawler_limits", crawler_limits)
        if exclusion_filters is not None:
            pulumi.set(__self__, "exclusion_filters", exclusion_filters)
        if inclusion_filters is not None:
            pulumi.set(__self__, "inclusion_filters", inclusion_filters)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="crawlerLimits")
    def crawler_limits(self) -> Optional['outputs.DataSourceWebCrawlerLimits']:
        """
        The configuration of crawl limits for the web URLs.
        """
        return pulumi.get(self, "crawler_limits")

    @property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> Optional[Sequence[str]]:
        """
        A list of one or more exclusion regular expression patterns to exclude certain URLs. If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
        """
        return pulumi.get(self, "exclusion_filters")

    @property
    @pulumi.getter(name="inclusionFilters")
    def inclusion_filters(self) -> Optional[Sequence[str]]:
        """
        A list of one or more inclusion regular expression patterns to include certain URLs. If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
        """
        return pulumi.get(self, "inclusion_filters")

    @property
    @pulumi.getter
    def scope(self) -> Optional['DataSourceWebScopeType']:
        """
        The scope of what is crawled for your URLs.

        You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL "https://docs.aws.amazon.com/bedrock/latest/userguide/" and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain "aws.amazon.com" can also include sub domain "docs.aws.amazon.com".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class DataSourceWebCrawlerLimits(dict):
    """
    Limit settings for the web crawler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rateLimit":
            suggest = "rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceWebCrawlerLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceWebCrawlerLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceWebCrawlerLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rate_limit: Optional[int] = None):
        """
        Limit settings for the web crawler.
        :param int rate_limit: Rate of web URLs retrieved per minute.
        """
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[int]:
        """
        Rate of web URLs retrieved per minute.
        """
        return pulumi.get(self, "rate_limit")


@pulumi.output_type
class DataSourceWebDataSourceConfiguration(dict):
    """
    Configures a web data source location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConfiguration":
            suggest = "source_configuration"
        elif key == "crawlerConfiguration":
            suggest = "crawler_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceWebDataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceWebDataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceWebDataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_configuration: 'outputs.DataSourceWebSourceConfiguration',
                 crawler_configuration: Optional['outputs.DataSourceWebCrawlerConfiguration'] = None):
        """
        Configures a web data source location.
        :param 'DataSourceWebSourceConfiguration' source_configuration: The source configuration details for the web data source.
        :param 'DataSourceWebCrawlerConfiguration' crawler_configuration: The Web Crawler configuration details for the web data source.
        """
        pulumi.set(__self__, "source_configuration", source_configuration)
        if crawler_configuration is not None:
            pulumi.set(__self__, "crawler_configuration", crawler_configuration)

    @property
    @pulumi.getter(name="sourceConfiguration")
    def source_configuration(self) -> 'outputs.DataSourceWebSourceConfiguration':
        """
        The source configuration details for the web data source.
        """
        return pulumi.get(self, "source_configuration")

    @property
    @pulumi.getter(name="crawlerConfiguration")
    def crawler_configuration(self) -> Optional['outputs.DataSourceWebCrawlerConfiguration']:
        """
        The Web Crawler configuration details for the web data source.
        """
        return pulumi.get(self, "crawler_configuration")


@pulumi.output_type
class DataSourceWebSourceConfiguration(dict):
    """
    A web source configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlConfiguration":
            suggest = "url_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceWebSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceWebSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceWebSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url_configuration: 'outputs.DataSourceUrlConfiguration'):
        """
        A web source configuration.
        :param 'DataSourceUrlConfiguration' url_configuration: The configuration of the URL/URLs.
        """
        pulumi.set(__self__, "url_configuration", url_configuration)

    @property
    @pulumi.getter(name="urlConfiguration")
    def url_configuration(self) -> 'outputs.DataSourceUrlConfiguration':
        """
        The configuration of the URL/URLs.
        """
        return pulumi.get(self, "url_configuration")


@pulumi.output_type
class FlowAgentFlowNodeConfiguration(dict):
    """
    Agent flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentAliasArn":
            suggest = "agent_alias_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowAgentFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowAgentFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowAgentFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_alias_arn: str):
        """
        Agent flow node configuration
        :param str agent_alias_arn: Arn representation of the Agent Alias.
        """
        pulumi.set(__self__, "agent_alias_arn", agent_alias_arn)

    @property
    @pulumi.getter(name="agentAliasArn")
    def agent_alias_arn(self) -> str:
        """
        Arn representation of the Agent Alias.
        """
        return pulumi.get(self, "agent_alias_arn")


@pulumi.output_type
class FlowAliasRoutingConfigurationListItem(dict):
    """
    Details about the routing configuration for a Flow alias.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowVersion":
            suggest = "flow_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowAliasRoutingConfigurationListItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowAliasRoutingConfigurationListItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowAliasRoutingConfigurationListItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_version: Optional[str] = None):
        """
        Details about the routing configuration for a Flow alias.
        :param str flow_version: Version.
        """
        if flow_version is not None:
            pulumi.set(__self__, "flow_version", flow_version)

    @property
    @pulumi.getter(name="flowVersion")
    def flow_version(self) -> Optional[str]:
        """
        Version.
        """
        return pulumi.get(self, "flow_version")


@pulumi.output_type
class FlowCollectorFlowNodeConfiguration(dict):
    """
    Collector flow node configuration
    """
    def __init__(__self__):
        """
        Collector flow node configuration
        """
        pass


@pulumi.output_type
class FlowCondition(dict):
    """
    Condition branch for a condition node
    """
    def __init__(__self__, *,
                 name: str,
                 expression: Optional[str] = None):
        """
        Condition branch for a condition node
        :param str name: Name of a condition in a flow
        :param str expression: Expression for a condition in a flow
        """
        pulumi.set(__self__, "name", name)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a condition in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Expression for a condition in a flow
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class FlowConditionFlowNodeConfiguration(dict):
    """
    Condition flow node configuration
    """
    def __init__(__self__, *,
                 conditions: Sequence['outputs.FlowCondition']):
        """
        Condition flow node configuration
        :param Sequence['FlowCondition'] conditions: List of conditions in a condition node
        """
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.FlowCondition']:
        """
        List of conditions in a condition node
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class FlowConditionalConnectionConfiguration(dict):
    """
    Conditional connection configuration
    """
    def __init__(__self__, *,
                 condition: str):
        """
        Conditional connection configuration
        :param str condition: Name of a condition in a flow
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Name of a condition in a flow
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class FlowConnection(dict):
    """
    Flow connection
    """
    def __init__(__self__, *,
                 name: str,
                 source: str,
                 target: str,
                 type: 'FlowConnectionType',
                 configuration: Optional[Any] = None):
        """
        Flow connection
        :param str name: Name of a connection in a flow
        :param str source: Name of a node in a flow
        :param str target: Name of a node in a flow
        :param 'FlowConnectionType' type: Whether the source node that the connection begins from is a condition node ( `Conditional` ) or not ( `Data` ).
        :param Union['FlowConnectionConfiguration0Properties', 'FlowConnectionConfiguration1Properties'] configuration: The configuration of the connection.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a connection in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Name of a node in a flow
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Name of a node in a flow
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> 'FlowConnectionType':
        """
        Whether the source node that the connection begins from is a condition node ( `Conditional` ) or not ( `Data` ).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        The configuration of the connection.
        """
        return pulumi.get(self, "configuration")


@pulumi.output_type
class FlowConnectionConfiguration0Properties(dict):
    """
    Connection configuration
    """
    def __init__(__self__, *,
                 data: 'outputs.FlowDataConnectionConfiguration'):
        """
        Connection configuration
        """
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> 'outputs.FlowDataConnectionConfiguration':
        return pulumi.get(self, "data")


@pulumi.output_type
class FlowConnectionConfiguration1Properties(dict):
    """
    Connection configuration
    """
    def __init__(__self__, *,
                 conditional: 'outputs.FlowConditionalConnectionConfiguration'):
        """
        Connection configuration
        """
        pulumi.set(__self__, "conditional", conditional)

    @property
    @pulumi.getter
    def conditional(self) -> 'outputs.FlowConditionalConnectionConfiguration':
        return pulumi.get(self, "conditional")


@pulumi.output_type
class FlowDataConnectionConfiguration(dict):
    """
    Data connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceOutput":
            suggest = "source_output"
        elif key == "targetInput":
            suggest = "target_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowDataConnectionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowDataConnectionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowDataConnectionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_output: str,
                 target_input: str):
        """
        Data connection configuration
        :param str source_output: Name of a node output in a flow
        :param str target_input: Name of a node input in a flow
        """
        pulumi.set(__self__, "source_output", source_output)
        pulumi.set(__self__, "target_input", target_input)

    @property
    @pulumi.getter(name="sourceOutput")
    def source_output(self) -> str:
        """
        Name of a node output in a flow
        """
        return pulumi.get(self, "source_output")

    @property
    @pulumi.getter(name="targetInput")
    def target_input(self) -> str:
        """
        Name of a node input in a flow
        """
        return pulumi.get(self, "target_input")


@pulumi.output_type
class FlowDefinition(dict):
    """
    Flow definition
    """
    def __init__(__self__, *,
                 connections: Optional[Sequence['outputs.FlowConnection']] = None,
                 nodes: Optional[Sequence['outputs.FlowNode']] = None):
        """
        Flow definition
        :param Sequence['FlowConnection'] connections: List of connections
        :param Sequence['FlowNode'] nodes: List of nodes in a flow
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)

    @property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.FlowConnection']]:
        """
        List of connections
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.FlowNode']]:
        """
        List of nodes in a flow
        """
        return pulumi.get(self, "nodes")


@pulumi.output_type
class FlowInputFlowNodeConfiguration(dict):
    """
    Input flow node configuration
    """
    def __init__(__self__):
        """
        Input flow node configuration
        """
        pass


@pulumi.output_type
class FlowIteratorFlowNodeConfiguration(dict):
    """
    Iterator flow node configuration
    """
    def __init__(__self__):
        """
        Iterator flow node configuration
        """
        pass


@pulumi.output_type
class FlowKnowledgeBaseFlowNodeConfiguration(dict):
    """
    Knowledge base flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBaseId":
            suggest = "knowledge_base_id"
        elif key == "modelId":
            suggest = "model_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowKnowledgeBaseFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowKnowledgeBaseFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowKnowledgeBaseFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knowledge_base_id: str,
                 model_id: Optional[str] = None):
        """
        Knowledge base flow node configuration
        :param str knowledge_base_id: Identifier of the KnowledgeBase
        :param str model_id: ARN or name of a Bedrock model.
        """
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> str:
        """
        Identifier of the KnowledgeBase
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class FlowLambdaFunctionFlowNodeConfiguration(dict):
    """
    Lambda function flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowLambdaFunctionFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowLambdaFunctionFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowLambdaFunctionFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str):
        """
        Lambda function flow node configuration
        :param str lambda_arn: ARN of a Lambda.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "lambda_arn")


@pulumi.output_type
class FlowLexFlowNodeConfiguration(dict):
    """
    Lex flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botAliasArn":
            suggest = "bot_alias_arn"
        elif key == "localeId":
            suggest = "locale_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowLexFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowLexFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowLexFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_alias_arn: str,
                 locale_id: str):
        """
        Lex flow node configuration
        :param str bot_alias_arn: ARN of a Lex bot alias
        :param str locale_id: Lex bot locale id
        """
        pulumi.set(__self__, "bot_alias_arn", bot_alias_arn)
        pulumi.set(__self__, "locale_id", locale_id)

    @property
    @pulumi.getter(name="botAliasArn")
    def bot_alias_arn(self) -> str:
        """
        ARN of a Lex bot alias
        """
        return pulumi.get(self, "bot_alias_arn")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> str:
        """
        Lex bot locale id
        """
        return pulumi.get(self, "locale_id")


@pulumi.output_type
class FlowNode(dict):
    """
    Internal mixin for flow node
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'FlowNodeType',
                 configuration: Optional[Any] = None,
                 inputs: Optional[Sequence['outputs.FlowNodeInput']] = None,
                 outputs: Optional[Sequence['outputs.FlowNodeOutput']] = None):
        """
        Internal mixin for flow node
        :param str name: Name of a node in a flow
        :param 'FlowNodeType' type: The type of node. This value must match the name of the key that you provide in the configuration you provide in the `FlowNodeConfiguration` field.
        :param Union['FlowNodeConfiguration0Properties', 'FlowNodeConfiguration1Properties', 'FlowNodeConfiguration2Properties', 'FlowNodeConfiguration3Properties', 'FlowNodeConfiguration4Properties', 'FlowNodeConfiguration5Properties', 'FlowNodeConfiguration6Properties', 'FlowNodeConfiguration7Properties', 'FlowNodeConfiguration8Properties', 'FlowNodeConfiguration9Properties', 'FlowNodeConfiguration10Properties', 'FlowNodeConfiguration11Properties'] configuration: Contains configurations for the node.
        :param Sequence['FlowNodeInput'] inputs: List of node inputs in a flow
        :param Sequence['FlowNodeOutput'] outputs: List of node outputs in a flow
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a node in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowNodeType':
        """
        The type of node. This value must match the name of the key that you provide in the configuration you provide in the `FlowNodeConfiguration` field.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        Contains configurations for the node.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.FlowNodeInput']]:
        """
        List of node inputs in a flow
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Sequence['outputs.FlowNodeOutput']]:
        """
        List of node outputs in a flow
        """
        return pulumi.get(self, "outputs")


@pulumi.output_type
class FlowNodeConfiguration0Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 input: 'outputs.FlowInputFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def input(self) -> 'outputs.FlowInputFlowNodeConfiguration':
        return pulumi.get(self, "input")


@pulumi.output_type
class FlowNodeConfiguration10Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 collector: 'outputs.FlowCollectorFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "collector", collector)

    @property
    @pulumi.getter
    def collector(self) -> 'outputs.FlowCollectorFlowNodeConfiguration':
        return pulumi.get(self, "collector")


@pulumi.output_type
class FlowNodeConfiguration11Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 retrieval: 'outputs.FlowRetrievalFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "retrieval", retrieval)

    @property
    @pulumi.getter
    def retrieval(self) -> 'outputs.FlowRetrievalFlowNodeConfiguration':
        return pulumi.get(self, "retrieval")


@pulumi.output_type
class FlowNodeConfiguration1Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 output: 'outputs.FlowOutputFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def output(self) -> 'outputs.FlowOutputFlowNodeConfiguration':
        return pulumi.get(self, "output")


@pulumi.output_type
class FlowNodeConfiguration2Properties(dict):
    """
    Node configuration in a flow
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBase":
            suggest = "knowledge_base"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowNodeConfiguration2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowNodeConfiguration2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowNodeConfiguration2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knowledge_base: 'outputs.FlowKnowledgeBaseFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "knowledge_base", knowledge_base)

    @property
    @pulumi.getter(name="knowledgeBase")
    def knowledge_base(self) -> 'outputs.FlowKnowledgeBaseFlowNodeConfiguration':
        return pulumi.get(self, "knowledge_base")


@pulumi.output_type
class FlowNodeConfiguration3Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 condition: 'outputs.FlowConditionFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.FlowConditionFlowNodeConfiguration':
        return pulumi.get(self, "condition")


@pulumi.output_type
class FlowNodeConfiguration4Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 lex: 'outputs.FlowLexFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "lex", lex)

    @property
    @pulumi.getter
    def lex(self) -> 'outputs.FlowLexFlowNodeConfiguration':
        return pulumi.get(self, "lex")


@pulumi.output_type
class FlowNodeConfiguration5Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 prompt: 'outputs.FlowPromptFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "prompt", prompt)

    @property
    @pulumi.getter
    def prompt(self) -> 'outputs.FlowPromptFlowNodeConfiguration':
        return pulumi.get(self, "prompt")


@pulumi.output_type
class FlowNodeConfiguration6Properties(dict):
    """
    Node configuration in a flow
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaFunction":
            suggest = "lambda_function"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowNodeConfiguration6Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowNodeConfiguration6Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowNodeConfiguration6Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_function: 'outputs.FlowLambdaFunctionFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "lambda_function", lambda_function)

    @property
    @pulumi.getter(name="lambdaFunction")
    def lambda_function(self) -> 'outputs.FlowLambdaFunctionFlowNodeConfiguration':
        return pulumi.get(self, "lambda_function")


@pulumi.output_type
class FlowNodeConfiguration7Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 agent: 'outputs.FlowAgentFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> 'outputs.FlowAgentFlowNodeConfiguration':
        return pulumi.get(self, "agent")


@pulumi.output_type
class FlowNodeConfiguration8Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 storage: 'outputs.FlowStorageFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def storage(self) -> 'outputs.FlowStorageFlowNodeConfiguration':
        return pulumi.get(self, "storage")


@pulumi.output_type
class FlowNodeConfiguration9Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 iterator: 'outputs.FlowIteratorFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "iterator", iterator)

    @property
    @pulumi.getter
    def iterator(self) -> 'outputs.FlowIteratorFlowNodeConfiguration':
        return pulumi.get(self, "iterator")


@pulumi.output_type
class FlowNodeInput(dict):
    """
    Input to a node in a flow
    """
    def __init__(__self__, *,
                 expression: str,
                 name: str,
                 type: 'FlowNodeIoDataType'):
        """
        Input to a node in a flow
        :param str expression: Expression for a node input in a flow
        :param str name: Name of a node input in a flow
        :param 'FlowNodeIoDataType' type: The data type of the input. If the input doesn't match this type at runtime, a validation error will be thrown.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression for a node input in a flow
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a node input in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowNodeIoDataType':
        """
        The data type of the input. If the input doesn't match this type at runtime, a validation error will be thrown.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowNodeOutput(dict):
    """
    Output of a node in a flow
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'FlowNodeIoDataType'):
        """
        Output of a node in a flow
        :param str name: Name of a node output in a flow
        :param 'FlowNodeIoDataType' type: The data type of the output. If the output doesn't match this type at runtime, a validation error will be thrown.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a node output in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowNodeIoDataType':
        """
        The data type of the output. If the output doesn't match this type at runtime, a validation error will be thrown.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowOutputFlowNodeConfiguration(dict):
    """
    Output flow node configuration
    """
    def __init__(__self__):
        """
        Output flow node configuration
        """
        pass


@pulumi.output_type
class FlowPromptFlowNodeConfiguration(dict):
    """
    Prompt flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConfiguration":
            suggest = "source_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowPromptFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowPromptFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowPromptFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_configuration: Any):
        """
        Prompt flow node configuration
        """
        pulumi.set(__self__, "source_configuration", source_configuration)

    @property
    @pulumi.getter(name="sourceConfiguration")
    def source_configuration(self) -> Any:
        return pulumi.get(self, "source_configuration")


@pulumi.output_type
class FlowPromptFlowNodeInlineConfiguration(dict):
    """
    Inline prompt configuration for prompt node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelId":
            suggest = "model_id"
        elif key == "templateConfiguration":
            suggest = "template_configuration"
        elif key == "templateType":
            suggest = "template_type"
        elif key == "inferenceConfiguration":
            suggest = "inference_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowPromptFlowNodeInlineConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowPromptFlowNodeInlineConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowPromptFlowNodeInlineConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_id: str,
                 template_configuration: 'outputs.FlowPromptTemplateConfigurationProperties',
                 template_type: 'FlowPromptTemplateType',
                 inference_configuration: Optional['outputs.FlowPromptInferenceConfigurationProperties'] = None):
        """
        Inline prompt configuration for prompt node
        :param str model_id: ARN or name of a Bedrock model.
        """
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "template_configuration", template_configuration)
        pulumi.set(__self__, "template_type", template_type)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> 'outputs.FlowPromptTemplateConfigurationProperties':
        return pulumi.get(self, "template_configuration")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> 'FlowPromptTemplateType':
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional['outputs.FlowPromptInferenceConfigurationProperties']:
        return pulumi.get(self, "inference_configuration")


@pulumi.output_type
class FlowPromptFlowNodeResourceConfiguration(dict):
    """
    Resource prompt configuration for prompt node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promptArn":
            suggest = "prompt_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowPromptFlowNodeResourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowPromptFlowNodeResourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowPromptFlowNodeResourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prompt_arn: str):
        """
        Resource prompt configuration for prompt node
        :param str prompt_arn: ARN of a prompt resource possibly with a version
        """
        pulumi.set(__self__, "prompt_arn", prompt_arn)

    @property
    @pulumi.getter(name="promptArn")
    def prompt_arn(self) -> str:
        """
        ARN of a prompt resource possibly with a version
        """
        return pulumi.get(self, "prompt_arn")


@pulumi.output_type
class FlowPromptFlowNodeSourceConfiguration0Properties(dict):
    """
    Prompt source configuration for prompt node
    """
    def __init__(__self__, *,
                 resource: 'outputs.FlowPromptFlowNodeResourceConfiguration'):
        """
        Prompt source configuration for prompt node
        """
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def resource(self) -> 'outputs.FlowPromptFlowNodeResourceConfiguration':
        return pulumi.get(self, "resource")


@pulumi.output_type
class FlowPromptFlowNodeSourceConfiguration1Properties(dict):
    """
    Prompt source configuration for prompt node
    """
    def __init__(__self__, *,
                 inline: 'outputs.FlowPromptFlowNodeInlineConfiguration'):
        """
        Prompt source configuration for prompt node
        """
        pulumi.set(__self__, "inline", inline)

    @property
    @pulumi.getter
    def inline(self) -> 'outputs.FlowPromptFlowNodeInlineConfiguration':
        return pulumi.get(self, "inline")


@pulumi.output_type
class FlowPromptInferenceConfigurationProperties(dict):
    """
    Model inference configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.FlowPromptModelInferenceConfiguration'):
        """
        Model inference configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.FlowPromptModelInferenceConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class FlowPromptInputVariable(dict):
    """
    Input variable
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Input variable
        :param str name: Name for an input variable
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name for an input variable
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FlowPromptModelInferenceConfiguration(dict):
    """
    Prompt model inference configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"
        elif key == "stopSequences":
            suggest = "stop_sequences"
        elif key == "topK":
            suggest = "top_k"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowPromptModelInferenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowPromptModelInferenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowPromptModelInferenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: Optional[float] = None,
                 stop_sequences: Optional[Sequence[str]] = None,
                 temperature: Optional[float] = None,
                 top_k: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        Prompt model inference configuration
        :param float max_tokens: Maximum length of output
        :param Sequence[str] stop_sequences: List of stop sequences
        :param float temperature: Controls randomness, higher values increase diversity
        :param float top_k: Sample from the k most likely next tokens
        :param float top_p: Cumulative probability cutoff for token selection
        """
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[float]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "max_tokens")

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[Sequence[str]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[float]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class FlowPromptTemplateConfigurationProperties(dict):
    """
    Prompt template configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.FlowTextPromptTemplateConfiguration'):
        """
        Prompt template configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.FlowTextPromptTemplateConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class FlowRetrievalFlowNodeConfiguration(dict):
    """
    Retrieval flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceConfiguration":
            suggest = "service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowRetrievalFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowRetrievalFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowRetrievalFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_configuration: 'outputs.FlowRetrievalFlowNodeServiceConfigurationProperties'):
        """
        Retrieval flow node configuration
        """
        pulumi.set(__self__, "service_configuration", service_configuration)

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> 'outputs.FlowRetrievalFlowNodeServiceConfigurationProperties':
        return pulumi.get(self, "service_configuration")


@pulumi.output_type
class FlowRetrievalFlowNodeS3Configuration(dict):
    """
    s3 Retrieval configuration for Retrieval node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowRetrievalFlowNodeS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowRetrievalFlowNodeS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowRetrievalFlowNodeS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str):
        """
        s3 Retrieval configuration for Retrieval node
        :param str bucket_name: bucket name of an s3 that will be used for Retrieval flow node configuration
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        bucket name of an s3 that will be used for Retrieval flow node configuration
        """
        return pulumi.get(self, "bucket_name")


@pulumi.output_type
class FlowRetrievalFlowNodeServiceConfigurationProperties(dict):
    """
    Retrieval service configuration for Retrieval node
    """
    def __init__(__self__, *,
                 s3: Optional['outputs.FlowRetrievalFlowNodeS3Configuration'] = None):
        """
        Retrieval service configuration for Retrieval node
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.FlowRetrievalFlowNodeS3Configuration']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class FlowS3Location(dict):
    """
    A bucket, key and optional version pointing to an S3 object containing a UTF-8 encoded JSON string Definition with the same schema as the Definition property of this resource
    """
    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 version: Optional[str] = None):
        """
        A bucket, key and optional version pointing to an S3 object containing a UTF-8 encoded JSON string Definition with the same schema as the Definition property of this resource
        :param str bucket: A bucket in S3
        :param str key: A object key in S3
        :param str version: The version of the the S3 object to use
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        A bucket in S3
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A object key in S3
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the the S3 object to use
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FlowStorageFlowNodeConfiguration(dict):
    """
    Storage flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceConfiguration":
            suggest = "service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowStorageFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowStorageFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowStorageFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_configuration: 'outputs.FlowStorageFlowNodeServiceConfigurationProperties'):
        """
        Storage flow node configuration
        """
        pulumi.set(__self__, "service_configuration", service_configuration)

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> 'outputs.FlowStorageFlowNodeServiceConfigurationProperties':
        return pulumi.get(self, "service_configuration")


@pulumi.output_type
class FlowStorageFlowNodeS3Configuration(dict):
    """
    s3 storage configuration for storage node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowStorageFlowNodeS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowStorageFlowNodeS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowStorageFlowNodeS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str):
        """
        s3 storage configuration for storage node
        :param str bucket_name: bucket name of an s3 that will be used for storage flow node configuration
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        bucket name of an s3 that will be used for storage flow node configuration
        """
        return pulumi.get(self, "bucket_name")


@pulumi.output_type
class FlowStorageFlowNodeServiceConfigurationProperties(dict):
    """
    storage service configuration for storage node
    """
    def __init__(__self__, *,
                 s3: Optional['outputs.FlowStorageFlowNodeS3Configuration'] = None):
        """
        storage service configuration for storage node
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.FlowStorageFlowNodeS3Configuration']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class FlowTextPromptTemplateConfiguration(dict):
    """
    Configuration for text prompt template
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputVariables":
            suggest = "input_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowTextPromptTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowTextPromptTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowTextPromptTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text: str,
                 input_variables: Optional[Sequence['outputs.FlowPromptInputVariable']] = None):
        """
        Configuration for text prompt template
        :param str text: Prompt content for String prompt template
        :param Sequence['FlowPromptInputVariable'] input_variables: List of input variables
        """
        pulumi.set(__self__, "text", text)
        if input_variables is not None:
            pulumi.set(__self__, "input_variables", input_variables)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Prompt content for String prompt template
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Optional[Sequence['outputs.FlowPromptInputVariable']]:
        """
        List of input variables
        """
        return pulumi.get(self, "input_variables")


@pulumi.output_type
class FlowValidation(dict):
    """
    Validation for Flow
    """
    def __init__(__self__, *,
                 message: str):
        """
        Validation for Flow
        :param str message: validation message
        """
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        validation message
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class FlowVersionAgentFlowNodeConfiguration(dict):
    """
    Agent flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentAliasArn":
            suggest = "agent_alias_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionAgentFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionAgentFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionAgentFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_alias_arn: str):
        """
        Agent flow node configuration
        :param str agent_alias_arn: Arn representation of the Agent Alias.
        """
        pulumi.set(__self__, "agent_alias_arn", agent_alias_arn)

    @property
    @pulumi.getter(name="agentAliasArn")
    def agent_alias_arn(self) -> str:
        """
        Arn representation of the Agent Alias.
        """
        return pulumi.get(self, "agent_alias_arn")


@pulumi.output_type
class FlowVersionCollectorFlowNodeConfiguration(dict):
    """
    Collector flow node configuration
    """
    def __init__(__self__):
        """
        Collector flow node configuration
        """
        pass


@pulumi.output_type
class FlowVersionConditionFlowNodeConfiguration(dict):
    """
    Condition flow node configuration
    """
    def __init__(__self__, *,
                 conditions: Sequence['outputs.FlowVersionFlowCondition']):
        """
        Condition flow node configuration
        :param Sequence['FlowVersionFlowCondition'] conditions: List of conditions in a condition node
        """
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.FlowVersionFlowCondition']:
        """
        List of conditions in a condition node
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class FlowVersionFlowCondition(dict):
    """
    Condition branch for a condition node
    """
    def __init__(__self__, *,
                 name: str,
                 expression: Optional[str] = None):
        """
        Condition branch for a condition node
        :param str name: Name of a condition in a flow
        :param str expression: Expression for a condition in a flow
        """
        pulumi.set(__self__, "name", name)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a condition in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Expression for a condition in a flow
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class FlowVersionFlowConditionalConnectionConfiguration(dict):
    """
    Conditional connection configuration
    """
    def __init__(__self__, *,
                 condition: str):
        """
        Conditional connection configuration
        :param str condition: Name of a condition in a flow
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Name of a condition in a flow
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class FlowVersionFlowConnection(dict):
    """
    Flow connection
    """
    def __init__(__self__, *,
                 name: str,
                 source: str,
                 target: str,
                 type: 'FlowVersionFlowConnectionType',
                 configuration: Optional[Any] = None):
        """
        Flow connection
        :param str name: Name of a connection in a flow
        :param str source: Name of a node in a flow
        :param str target: Name of a node in a flow
        :param 'FlowVersionFlowConnectionType' type: Whether the source node that the connection begins from is a condition node ( `Conditional` ) or not ( `Data` ).
        :param Union['FlowVersionFlowConnectionConfiguration0Properties', 'FlowVersionFlowConnectionConfiguration1Properties'] configuration: The configuration of the connection.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a connection in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Name of a node in a flow
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Name of a node in a flow
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> 'FlowVersionFlowConnectionType':
        """
        Whether the source node that the connection begins from is a condition node ( `Conditional` ) or not ( `Data` ).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        The configuration of the connection.
        """
        return pulumi.get(self, "configuration")


@pulumi.output_type
class FlowVersionFlowConnectionConfiguration0Properties(dict):
    """
    Connection configuration
    """
    def __init__(__self__, *,
                 data: 'outputs.FlowVersionFlowDataConnectionConfiguration'):
        """
        Connection configuration
        """
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> 'outputs.FlowVersionFlowDataConnectionConfiguration':
        return pulumi.get(self, "data")


@pulumi.output_type
class FlowVersionFlowConnectionConfiguration1Properties(dict):
    """
    Connection configuration
    """
    def __init__(__self__, *,
                 conditional: 'outputs.FlowVersionFlowConditionalConnectionConfiguration'):
        """
        Connection configuration
        """
        pulumi.set(__self__, "conditional", conditional)

    @property
    @pulumi.getter
    def conditional(self) -> 'outputs.FlowVersionFlowConditionalConnectionConfiguration':
        return pulumi.get(self, "conditional")


@pulumi.output_type
class FlowVersionFlowDataConnectionConfiguration(dict):
    """
    Data connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceOutput":
            suggest = "source_output"
        elif key == "targetInput":
            suggest = "target_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionFlowDataConnectionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionFlowDataConnectionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionFlowDataConnectionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_output: str,
                 target_input: str):
        """
        Data connection configuration
        :param str source_output: Name of a node output in a flow
        :param str target_input: Name of a node input in a flow
        """
        pulumi.set(__self__, "source_output", source_output)
        pulumi.set(__self__, "target_input", target_input)

    @property
    @pulumi.getter(name="sourceOutput")
    def source_output(self) -> str:
        """
        Name of a node output in a flow
        """
        return pulumi.get(self, "source_output")

    @property
    @pulumi.getter(name="targetInput")
    def target_input(self) -> str:
        """
        Name of a node input in a flow
        """
        return pulumi.get(self, "target_input")


@pulumi.output_type
class FlowVersionFlowDefinition(dict):
    """
    Flow definition
    """
    def __init__(__self__, *,
                 connections: Optional[Sequence['outputs.FlowVersionFlowConnection']] = None,
                 nodes: Optional[Sequence['outputs.FlowVersionFlowNode']] = None):
        """
        Flow definition
        :param Sequence['FlowVersionFlowConnection'] connections: List of connections
        :param Sequence['FlowVersionFlowNode'] nodes: List of nodes in a flow
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)

    @property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.FlowVersionFlowConnection']]:
        """
        List of connections
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.FlowVersionFlowNode']]:
        """
        List of nodes in a flow
        """
        return pulumi.get(self, "nodes")


@pulumi.output_type
class FlowVersionFlowNode(dict):
    """
    Internal mixin for flow node
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'FlowVersionFlowNodeType',
                 configuration: Optional[Any] = None,
                 inputs: Optional[Sequence['outputs.FlowVersionFlowNodeInput']] = None,
                 outputs: Optional[Sequence['outputs.FlowVersionFlowNodeOutput']] = None):
        """
        Internal mixin for flow node
        :param str name: Name of a node in a flow
        :param 'FlowVersionFlowNodeType' type: The type of node. This value must match the name of the key that you provide in the configuration you provide in the `FlowNodeConfiguration` field.
        :param Union['FlowVersionFlowNodeConfiguration0Properties', 'FlowVersionFlowNodeConfiguration1Properties', 'FlowVersionFlowNodeConfiguration2Properties', 'FlowVersionFlowNodeConfiguration3Properties', 'FlowVersionFlowNodeConfiguration4Properties', 'FlowVersionFlowNodeConfiguration5Properties', 'FlowVersionFlowNodeConfiguration6Properties', 'FlowVersionFlowNodeConfiguration7Properties', 'FlowVersionFlowNodeConfiguration8Properties', 'FlowVersionFlowNodeConfiguration9Properties', 'FlowVersionFlowNodeConfiguration10Properties', 'FlowVersionFlowNodeConfiguration11Properties'] configuration: Contains configurations for the node.
        :param Sequence['FlowVersionFlowNodeInput'] inputs: List of node inputs in a flow
        :param Sequence['FlowVersionFlowNodeOutput'] outputs: List of node outputs in a flow
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a node in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowVersionFlowNodeType':
        """
        The type of node. This value must match the name of the key that you provide in the configuration you provide in the `FlowNodeConfiguration` field.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        Contains configurations for the node.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.FlowVersionFlowNodeInput']]:
        """
        List of node inputs in a flow
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Sequence['outputs.FlowVersionFlowNodeOutput']]:
        """
        List of node outputs in a flow
        """
        return pulumi.get(self, "outputs")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration0Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 input: 'outputs.FlowVersionInputFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "input", input)

    @property
    @pulumi.getter
    def input(self) -> 'outputs.FlowVersionInputFlowNodeConfiguration':
        return pulumi.get(self, "input")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration10Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 iterator: 'outputs.FlowVersionIteratorFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "iterator", iterator)

    @property
    @pulumi.getter
    def iterator(self) -> 'outputs.FlowVersionIteratorFlowNodeConfiguration':
        return pulumi.get(self, "iterator")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration11Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 collector: 'outputs.FlowVersionCollectorFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "collector", collector)

    @property
    @pulumi.getter
    def collector(self) -> 'outputs.FlowVersionCollectorFlowNodeConfiguration':
        return pulumi.get(self, "collector")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration1Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 output: 'outputs.FlowVersionOutputFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def output(self) -> 'outputs.FlowVersionOutputFlowNodeConfiguration':
        return pulumi.get(self, "output")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration2Properties(dict):
    """
    Node configuration in a flow
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBase":
            suggest = "knowledge_base"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionFlowNodeConfiguration2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionFlowNodeConfiguration2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionFlowNodeConfiguration2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knowledge_base: 'outputs.FlowVersionKnowledgeBaseFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "knowledge_base", knowledge_base)

    @property
    @pulumi.getter(name="knowledgeBase")
    def knowledge_base(self) -> 'outputs.FlowVersionKnowledgeBaseFlowNodeConfiguration':
        return pulumi.get(self, "knowledge_base")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration3Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 condition: 'outputs.FlowVersionConditionFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.FlowVersionConditionFlowNodeConfiguration':
        return pulumi.get(self, "condition")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration4Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 lex: 'outputs.FlowVersionLexFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "lex", lex)

    @property
    @pulumi.getter
    def lex(self) -> 'outputs.FlowVersionLexFlowNodeConfiguration':
        return pulumi.get(self, "lex")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration5Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 prompt: 'outputs.FlowVersionPromptFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "prompt", prompt)

    @property
    @pulumi.getter
    def prompt(self) -> 'outputs.FlowVersionPromptFlowNodeConfiguration':
        return pulumi.get(self, "prompt")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration6Properties(dict):
    """
    Node configuration in a flow
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaFunction":
            suggest = "lambda_function"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionFlowNodeConfiguration6Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionFlowNodeConfiguration6Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionFlowNodeConfiguration6Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_function: 'outputs.FlowVersionLambdaFunctionFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "lambda_function", lambda_function)

    @property
    @pulumi.getter(name="lambdaFunction")
    def lambda_function(self) -> 'outputs.FlowVersionLambdaFunctionFlowNodeConfiguration':
        return pulumi.get(self, "lambda_function")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration7Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 agent: 'outputs.FlowVersionAgentFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> 'outputs.FlowVersionAgentFlowNodeConfiguration':
        return pulumi.get(self, "agent")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration8Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 storage: 'outputs.FlowVersionStorageFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def storage(self) -> 'outputs.FlowVersionStorageFlowNodeConfiguration':
        return pulumi.get(self, "storage")


@pulumi.output_type
class FlowVersionFlowNodeConfiguration9Properties(dict):
    """
    Node configuration in a flow
    """
    def __init__(__self__, *,
                 retrieval: 'outputs.FlowVersionRetrievalFlowNodeConfiguration'):
        """
        Node configuration in a flow
        """
        pulumi.set(__self__, "retrieval", retrieval)

    @property
    @pulumi.getter
    def retrieval(self) -> 'outputs.FlowVersionRetrievalFlowNodeConfiguration':
        return pulumi.get(self, "retrieval")


@pulumi.output_type
class FlowVersionFlowNodeInput(dict):
    """
    Input to a node in a flow
    """
    def __init__(__self__, *,
                 expression: str,
                 name: str,
                 type: 'FlowVersionFlowNodeIoDataType'):
        """
        Input to a node in a flow
        :param str expression: Expression for a node input in a flow
        :param str name: Name of a node input in a flow
        :param 'FlowVersionFlowNodeIoDataType' type: The data type of the input. If the input doesn't match this type at runtime, a validation error will be thrown.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Expression for a node input in a flow
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a node input in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowVersionFlowNodeIoDataType':
        """
        The data type of the input. If the input doesn't match this type at runtime, a validation error will be thrown.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowVersionFlowNodeOutput(dict):
    """
    Output of a node in a flow
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'FlowVersionFlowNodeIoDataType'):
        """
        Output of a node in a flow
        :param str name: Name of a node output in a flow
        :param 'FlowVersionFlowNodeIoDataType' type: The data type of the output. If the output doesn't match this type at runtime, a validation error will be thrown.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of a node output in a flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowVersionFlowNodeIoDataType':
        """
        The data type of the output. If the output doesn't match this type at runtime, a validation error will be thrown.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowVersionInputFlowNodeConfiguration(dict):
    """
    Input flow node configuration
    """
    def __init__(__self__):
        """
        Input flow node configuration
        """
        pass


@pulumi.output_type
class FlowVersionIteratorFlowNodeConfiguration(dict):
    """
    Iterator flow node configuration
    """
    def __init__(__self__):
        """
        Iterator flow node configuration
        """
        pass


@pulumi.output_type
class FlowVersionKnowledgeBaseFlowNodeConfiguration(dict):
    """
    Knowledge base flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBaseId":
            suggest = "knowledge_base_id"
        elif key == "modelId":
            suggest = "model_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionKnowledgeBaseFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionKnowledgeBaseFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionKnowledgeBaseFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knowledge_base_id: str,
                 model_id: Optional[str] = None):
        """
        Knowledge base flow node configuration
        :param str knowledge_base_id: Identifier of the KnowledgeBase
        :param str model_id: ARN or name of a Bedrock model.
        """
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> str:
        """
        Identifier of the KnowledgeBase
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class FlowVersionLambdaFunctionFlowNodeConfiguration(dict):
    """
    Lambda function flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionLambdaFunctionFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionLambdaFunctionFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionLambdaFunctionFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str):
        """
        Lambda function flow node configuration
        :param str lambda_arn: ARN of a Lambda.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "lambda_arn")


@pulumi.output_type
class FlowVersionLexFlowNodeConfiguration(dict):
    """
    Lex flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botAliasArn":
            suggest = "bot_alias_arn"
        elif key == "localeId":
            suggest = "locale_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionLexFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionLexFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionLexFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_alias_arn: str,
                 locale_id: str):
        """
        Lex flow node configuration
        :param str bot_alias_arn: ARN of a Lex bot alias
        :param str locale_id: Lex bot locale id
        """
        pulumi.set(__self__, "bot_alias_arn", bot_alias_arn)
        pulumi.set(__self__, "locale_id", locale_id)

    @property
    @pulumi.getter(name="botAliasArn")
    def bot_alias_arn(self) -> str:
        """
        ARN of a Lex bot alias
        """
        return pulumi.get(self, "bot_alias_arn")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> str:
        """
        Lex bot locale id
        """
        return pulumi.get(self, "locale_id")


@pulumi.output_type
class FlowVersionOutputFlowNodeConfiguration(dict):
    """
    Output flow node configuration
    """
    def __init__(__self__):
        """
        Output flow node configuration
        """
        pass


@pulumi.output_type
class FlowVersionPromptFlowNodeConfiguration(dict):
    """
    Prompt flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConfiguration":
            suggest = "source_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionPromptFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionPromptFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionPromptFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_configuration: Any):
        """
        Prompt flow node configuration
        """
        pulumi.set(__self__, "source_configuration", source_configuration)

    @property
    @pulumi.getter(name="sourceConfiguration")
    def source_configuration(self) -> Any:
        return pulumi.get(self, "source_configuration")


@pulumi.output_type
class FlowVersionPromptFlowNodeInlineConfiguration(dict):
    """
    Inline prompt configuration for prompt node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelId":
            suggest = "model_id"
        elif key == "templateConfiguration":
            suggest = "template_configuration"
        elif key == "templateType":
            suggest = "template_type"
        elif key == "inferenceConfiguration":
            suggest = "inference_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionPromptFlowNodeInlineConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionPromptFlowNodeInlineConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionPromptFlowNodeInlineConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_id: str,
                 template_configuration: 'outputs.FlowVersionPromptTemplateConfigurationProperties',
                 template_type: 'FlowVersionPromptTemplateType',
                 inference_configuration: Optional['outputs.FlowVersionPromptInferenceConfigurationProperties'] = None):
        """
        Inline prompt configuration for prompt node
        :param str model_id: ARN or name of a Bedrock model.
        """
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "template_configuration", template_configuration)
        pulumi.set(__self__, "template_type", template_type)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> 'outputs.FlowVersionPromptTemplateConfigurationProperties':
        return pulumi.get(self, "template_configuration")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> 'FlowVersionPromptTemplateType':
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional['outputs.FlowVersionPromptInferenceConfigurationProperties']:
        return pulumi.get(self, "inference_configuration")


@pulumi.output_type
class FlowVersionPromptFlowNodeResourceConfiguration(dict):
    """
    Resource prompt configuration for prompt node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promptArn":
            suggest = "prompt_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionPromptFlowNodeResourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionPromptFlowNodeResourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionPromptFlowNodeResourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prompt_arn: str):
        """
        Resource prompt configuration for prompt node
        :param str prompt_arn: ARN of a prompt resource possibly with a version
        """
        pulumi.set(__self__, "prompt_arn", prompt_arn)

    @property
    @pulumi.getter(name="promptArn")
    def prompt_arn(self) -> str:
        """
        ARN of a prompt resource possibly with a version
        """
        return pulumi.get(self, "prompt_arn")


@pulumi.output_type
class FlowVersionPromptFlowNodeSourceConfiguration0Properties(dict):
    """
    Prompt source configuration for prompt node
    """
    def __init__(__self__, *,
                 resource: 'outputs.FlowVersionPromptFlowNodeResourceConfiguration'):
        """
        Prompt source configuration for prompt node
        """
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def resource(self) -> 'outputs.FlowVersionPromptFlowNodeResourceConfiguration':
        return pulumi.get(self, "resource")


@pulumi.output_type
class FlowVersionPromptFlowNodeSourceConfiguration1Properties(dict):
    """
    Prompt source configuration for prompt node
    """
    def __init__(__self__, *,
                 inline: 'outputs.FlowVersionPromptFlowNodeInlineConfiguration'):
        """
        Prompt source configuration for prompt node
        """
        pulumi.set(__self__, "inline", inline)

    @property
    @pulumi.getter
    def inline(self) -> 'outputs.FlowVersionPromptFlowNodeInlineConfiguration':
        return pulumi.get(self, "inline")


@pulumi.output_type
class FlowVersionPromptInferenceConfigurationProperties(dict):
    """
    Model inference configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.FlowVersionPromptModelInferenceConfiguration'):
        """
        Model inference configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.FlowVersionPromptModelInferenceConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class FlowVersionPromptInputVariable(dict):
    """
    Input variable
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Input variable
        :param str name: Name for an input variable
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name for an input variable
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FlowVersionPromptModelInferenceConfiguration(dict):
    """
    Prompt model inference configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"
        elif key == "stopSequences":
            suggest = "stop_sequences"
        elif key == "topK":
            suggest = "top_k"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionPromptModelInferenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionPromptModelInferenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionPromptModelInferenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: Optional[float] = None,
                 stop_sequences: Optional[Sequence[str]] = None,
                 temperature: Optional[float] = None,
                 top_k: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        Prompt model inference configuration
        :param float max_tokens: Maximum length of output
        :param Sequence[str] stop_sequences: List of stop sequences
        :param float temperature: Controls randomness, higher values increase diversity
        :param float top_k: Sample from the k most likely next tokens
        :param float top_p: Cumulative probability cutoff for token selection
        """
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[float]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "max_tokens")

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[Sequence[str]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[float]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class FlowVersionPromptTemplateConfigurationProperties(dict):
    """
    Prompt template configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.FlowVersionTextPromptTemplateConfiguration'):
        """
        Prompt template configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.FlowVersionTextPromptTemplateConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class FlowVersionRetrievalFlowNodeConfiguration(dict):
    """
    Retrieval flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceConfiguration":
            suggest = "service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionRetrievalFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionRetrievalFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionRetrievalFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_configuration: 'outputs.FlowVersionRetrievalFlowNodeServiceConfigurationProperties'):
        """
        Retrieval flow node configuration
        """
        pulumi.set(__self__, "service_configuration", service_configuration)

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> 'outputs.FlowVersionRetrievalFlowNodeServiceConfigurationProperties':
        return pulumi.get(self, "service_configuration")


@pulumi.output_type
class FlowVersionRetrievalFlowNodeS3Configuration(dict):
    """
    s3 Retrieval configuration for Retrieval node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionRetrievalFlowNodeS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionRetrievalFlowNodeS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionRetrievalFlowNodeS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str):
        """
        s3 Retrieval configuration for Retrieval node
        :param str bucket_name: bucket name of an s3 that will be used for Retrieval flow node configuration
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        bucket name of an s3 that will be used for Retrieval flow node configuration
        """
        return pulumi.get(self, "bucket_name")


@pulumi.output_type
class FlowVersionRetrievalFlowNodeServiceConfigurationProperties(dict):
    """
    Retrieval service configuration for Retrieval node
    """
    def __init__(__self__, *,
                 s3: Optional['outputs.FlowVersionRetrievalFlowNodeS3Configuration'] = None):
        """
        Retrieval service configuration for Retrieval node
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.FlowVersionRetrievalFlowNodeS3Configuration']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class FlowVersionStorageFlowNodeConfiguration(dict):
    """
    Storage flow node configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceConfiguration":
            suggest = "service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionStorageFlowNodeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionStorageFlowNodeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionStorageFlowNodeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_configuration: 'outputs.FlowVersionStorageFlowNodeServiceConfigurationProperties'):
        """
        Storage flow node configuration
        """
        pulumi.set(__self__, "service_configuration", service_configuration)

    @property
    @pulumi.getter(name="serviceConfiguration")
    def service_configuration(self) -> 'outputs.FlowVersionStorageFlowNodeServiceConfigurationProperties':
        return pulumi.get(self, "service_configuration")


@pulumi.output_type
class FlowVersionStorageFlowNodeS3Configuration(dict):
    """
    s3 storage configuration for storage node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionStorageFlowNodeS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionStorageFlowNodeS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionStorageFlowNodeS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str):
        """
        s3 storage configuration for storage node
        :param str bucket_name: bucket name of an s3 that will be used for storage flow node configuration
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        bucket name of an s3 that will be used for storage flow node configuration
        """
        return pulumi.get(self, "bucket_name")


@pulumi.output_type
class FlowVersionStorageFlowNodeServiceConfigurationProperties(dict):
    """
    storage service configuration for storage node
    """
    def __init__(__self__, *,
                 s3: Optional['outputs.FlowVersionStorageFlowNodeS3Configuration'] = None):
        """
        storage service configuration for storage node
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.FlowVersionStorageFlowNodeS3Configuration']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class FlowVersionTextPromptTemplateConfiguration(dict):
    """
    Configuration for text prompt template
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputVariables":
            suggest = "input_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVersionTextPromptTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVersionTextPromptTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVersionTextPromptTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text: str,
                 input_variables: Optional[Sequence['outputs.FlowVersionPromptInputVariable']] = None):
        """
        Configuration for text prompt template
        :param str text: Prompt content for String prompt template
        :param Sequence['FlowVersionPromptInputVariable'] input_variables: List of input variables
        """
        pulumi.set(__self__, "text", text)
        if input_variables is not None:
            pulumi.set(__self__, "input_variables", input_variables)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Prompt content for String prompt template
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Optional[Sequence['outputs.FlowVersionPromptInputVariable']]:
        """
        List of input variables
        """
        return pulumi.get(self, "input_variables")


@pulumi.output_type
class GuardrailContentFilterConfig(dict):
    """
    Content filter config in content policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputStrength":
            suggest = "input_strength"
        elif key == "outputStrength":
            suggest = "output_strength"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailContentFilterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailContentFilterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailContentFilterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_strength: 'GuardrailFilterStrength',
                 output_strength: 'GuardrailFilterStrength',
                 type: 'GuardrailContentFilterType'):
        """
        Content filter config in content policy.
        :param 'GuardrailFilterStrength' input_strength: The strength of the content filter to apply to prompts. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
        :param 'GuardrailFilterStrength' output_strength: The strength of the content filter to apply to model responses. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
        :param 'GuardrailContentFilterType' type: The harmful category that the content filter is applied to.
        """
        pulumi.set(__self__, "input_strength", input_strength)
        pulumi.set(__self__, "output_strength", output_strength)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inputStrength")
    def input_strength(self) -> 'GuardrailFilterStrength':
        """
        The strength of the content filter to apply to prompts. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
        """
        return pulumi.get(self, "input_strength")

    @property
    @pulumi.getter(name="outputStrength")
    def output_strength(self) -> 'GuardrailFilterStrength':
        """
        The strength of the content filter to apply to model responses. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
        """
        return pulumi.get(self, "output_strength")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailContentFilterType':
        """
        The harmful category that the content filter is applied to.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailContentPolicyConfig(dict):
    """
    Content policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filtersConfig":
            suggest = "filters_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailContentPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailContentPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailContentPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filters_config: Sequence['outputs.GuardrailContentFilterConfig']):
        """
        Content policy config for a guardrail.
        :param Sequence['GuardrailContentFilterConfig'] filters_config: List of content filter configs in content policy.
        """
        pulumi.set(__self__, "filters_config", filters_config)

    @property
    @pulumi.getter(name="filtersConfig")
    def filters_config(self) -> Sequence['outputs.GuardrailContentFilterConfig']:
        """
        List of content filter configs in content policy.
        """
        return pulumi.get(self, "filters_config")


@pulumi.output_type
class GuardrailContextualGroundingFilterConfig(dict):
    """
    A config for grounding filter.
    """
    def __init__(__self__, *,
                 threshold: float,
                 type: 'GuardrailContextualGroundingFilterType'):
        """
        A config for grounding filter.
        :param float threshold: The threshold for this filter.
        :param 'GuardrailContextualGroundingFilterType' type: The filter details for the guardrails contextual grounding filter.
        """
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The threshold for this filter.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailContextualGroundingFilterType':
        """
        The filter details for the guardrails contextual grounding filter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailContextualGroundingPolicyConfig(dict):
    """
    Contextual grounding policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filtersConfig":
            suggest = "filters_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailContextualGroundingPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailContextualGroundingPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailContextualGroundingPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filters_config: Sequence['outputs.GuardrailContextualGroundingFilterConfig']):
        """
        Contextual grounding policy config for a guardrail.
        :param Sequence['GuardrailContextualGroundingFilterConfig'] filters_config: List of contextual grounding filter configs.
        """
        pulumi.set(__self__, "filters_config", filters_config)

    @property
    @pulumi.getter(name="filtersConfig")
    def filters_config(self) -> Sequence['outputs.GuardrailContextualGroundingFilterConfig']:
        """
        List of contextual grounding filter configs.
        """
        return pulumi.get(self, "filters_config")


@pulumi.output_type
class GuardrailManagedWordsConfig(dict):
    """
    A managed words config.
    """
    def __init__(__self__, *,
                 type: 'GuardrailManagedWordsType'):
        """
        A managed words config.
        :param 'GuardrailManagedWordsType' type: The managed word type to configure for the guardrail.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailManagedWordsType':
        """
        The managed word type to configure for the guardrail.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailPiiEntityConfig(dict):
    """
    Pii entity configuration.
    """
    def __init__(__self__, *,
                 action: 'GuardrailSensitiveInformationAction',
                 type: 'GuardrailPiiEntityType'):
        """
        Pii entity configuration.
        :param 'GuardrailSensitiveInformationAction' action: Configure guardrail action when the PII entity is detected.
        :param 'GuardrailPiiEntityType' type: Configure guardrail type when the PII entity is detected.
               
               The following PIIs are used to block or mask sensitive information:
               
               - *General*
               
               - *ADDRESS*
               
               A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include information such as the street, building, location, city, state, country, county, zip code, precinct, and neighborhood.
               - *AGE*
               
               An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old," Guarrails recognizes "40 years" as an age.
               - *NAME*
               
               An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
               - *EMAIL*
               
               An email address, such as *marymajor@email.com* .
               - *PHONE*
               
               A phone number. This entity type also includes fax and pager numbers.
               - *USERNAME*
               
               A user name that identifies an account, such as a login name, screen name, nick name, or handle.
               - *PASSWORD*
               
               An alphanumeric string that is used as a password, such as "* *very20special#pass** ".
               - *DRIVER_ID*
               
               The number assigned to a driver's license, which is an official document permitting an individual to operate one or more motorized vehicles on a public road. A driver's license number consists of alphanumeric characters.
               - *LICENSE_PLATE*
               
               A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format varies depending on the location of the issuing state or country.
               - *VEHICLE_IDENTIFICATION_NUMBER*
               
               A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the *ISO 3779* specification. Each country has specific codes and formats for VINs.
               - *Finance*
               
               - *REDIT_DEBIT_CARD_CVV*
               
               A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
               - *CREDIT_DEBIT_CARD_EXPIRY*
               
               The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as *month/year* or *MM/YY* . Guardrails recognizes expiration dates such as *01/21* , *01/2021* , and *Jan 2021* .
               - *CREDIT_DEBIT_CARD_NUMBER*
               
               The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
               - *PIN*
               
               A four-digit personal identification number (PIN) with which you can access your bank account.
               - *INTERNATIONAL_BANK_ACCOUNT_NUMBER*
               
               An International Bank Account Number has specific formats in each country. For more information, see [www.iban.com/structure](https://docs.aws.amazon.com/https://www.iban.com/structure) .
               - *SWIFT_CODE*
               
               A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch. Banks use these codes for money transfers such as international wire transfers.
               
               SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
               - *IT*
               
               - *IP_ADDRESS*
               
               An IPv4 address, such as *198.51.100.0* .
               - *MAC_ADDRESS*
               
               A *media access control* (MAC) address is a unique identifier assigned to a network interface controller (NIC).
               - *URL*
               
               A web address, such as *www.example.com* .
               - *AWS_ACCESS_KEY*
               
               A unique identifier that's associated with a secret access key; you use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
               - *AWS_SECRET_KEY*
               
               A unique identifier that's associated with an access key. You use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
               - *USA specific*
               
               - *US_BANK_ACCOUNT_NUMBER*
               
               A US bank account number, which is typically 10 to 12 digits long.
               - *US_BANK_ROUTING_NUMBER*
               
               A US bank account routing number. These are typically nine digits long,
               - *US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER*
               
               A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits.
               - *US_PASSPORT_NUMBER*
               
               A US passport number. Passport numbers range from six to nine alphanumeric characters.
               - *US_SOCIAL_SECURITY_NUMBER*
               
               A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and temporary working residents.
               - *Canada specific*
               
               - *CA_HEALTH_NUMBER*
               
               A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare benefits.
               - *CA_SOCIAL_INSURANCE_NUMBER*
               
               A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access government programs and benefits.
               
               The SIN is formatted as three groups of three digits, such as *123-456-789* . A SIN can be validated through a simple check-digit process called the [Luhn algorithm](https://docs.aws.amazon.com/https://www.wikipedia.org/wiki/Luhn_algorithm) .
               - *UK Specific*
               
               - *UK_NATIONAL_HEALTH_SERVICE_NUMBER*
               
               A UK National Health Service Number is a 10-17 digit number, such as *485 777 3456* . The current system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting checksum.
               - *UK_NATIONAL_INSURANCE_NUMBER*
               
               A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security) benefits. It is also used for some purposes in the UK tax system.
               
               The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
               - *UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER*
               
               A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
               - *Custom*
               
               - *Regex filter* - You can use a regular expressions to define patterns for a guardrail to recognize and act upon such as serial number, booking ID etc..
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> 'GuardrailSensitiveInformationAction':
        """
        Configure guardrail action when the PII entity is detected.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailPiiEntityType':
        """
        Configure guardrail type when the PII entity is detected.

        The following PIIs are used to block or mask sensitive information:

        - *General*

        - *ADDRESS*

        A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include information such as the street, building, location, city, state, country, county, zip code, precinct, and neighborhood.
        - *AGE*

        An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old," Guarrails recognizes "40 years" as an age.
        - *NAME*

        An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
        - *EMAIL*

        An email address, such as *marymajor@email.com* .
        - *PHONE*

        A phone number. This entity type also includes fax and pager numbers.
        - *USERNAME*

        A user name that identifies an account, such as a login name, screen name, nick name, or handle.
        - *PASSWORD*

        An alphanumeric string that is used as a password, such as "* *very20special#pass** ".
        - *DRIVER_ID*

        The number assigned to a driver's license, which is an official document permitting an individual to operate one or more motorized vehicles on a public road. A driver's license number consists of alphanumeric characters.
        - *LICENSE_PLATE*

        A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format varies depending on the location of the issuing state or country.
        - *VEHICLE_IDENTIFICATION_NUMBER*

        A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the *ISO 3779* specification. Each country has specific codes and formats for VINs.
        - *Finance*

        - *REDIT_DEBIT_CARD_CVV*

        A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
        - *CREDIT_DEBIT_CARD_EXPIRY*

        The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as *month/year* or *MM/YY* . Guardrails recognizes expiration dates such as *01/21* , *01/2021* , and *Jan 2021* .
        - *CREDIT_DEBIT_CARD_NUMBER*

        The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
        - *PIN*

        A four-digit personal identification number (PIN) with which you can access your bank account.
        - *INTERNATIONAL_BANK_ACCOUNT_NUMBER*

        An International Bank Account Number has specific formats in each country. For more information, see [www.iban.com/structure](https://docs.aws.amazon.com/https://www.iban.com/structure) .
        - *SWIFT_CODE*

        A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch. Banks use these codes for money transfers such as international wire transfers.

        SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
        - *IT*

        - *IP_ADDRESS*

        An IPv4 address, such as *198.51.100.0* .
        - *MAC_ADDRESS*

        A *media access control* (MAC) address is a unique identifier assigned to a network interface controller (NIC).
        - *URL*

        A web address, such as *www.example.com* .
        - *AWS_ACCESS_KEY*

        A unique identifier that's associated with a secret access key; you use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
        - *AWS_SECRET_KEY*

        A unique identifier that's associated with an access key. You use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
        - *USA specific*

        - *US_BANK_ACCOUNT_NUMBER*

        A US bank account number, which is typically 10 to 12 digits long.
        - *US_BANK_ROUTING_NUMBER*

        A US bank account routing number. These are typically nine digits long,
        - *US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER*

        A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits.
        - *US_PASSPORT_NUMBER*

        A US passport number. Passport numbers range from six to nine alphanumeric characters.
        - *US_SOCIAL_SECURITY_NUMBER*

        A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and temporary working residents.
        - *Canada specific*

        - *CA_HEALTH_NUMBER*

        A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare benefits.
        - *CA_SOCIAL_INSURANCE_NUMBER*

        A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access government programs and benefits.

        The SIN is formatted as three groups of three digits, such as *123-456-789* . A SIN can be validated through a simple check-digit process called the [Luhn algorithm](https://docs.aws.amazon.com/https://www.wikipedia.org/wiki/Luhn_algorithm) .
        - *UK Specific*

        - *UK_NATIONAL_HEALTH_SERVICE_NUMBER*

        A UK National Health Service Number is a 10-17 digit number, such as *485 777 3456* . The current system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting checksum.
        - *UK_NATIONAL_INSURANCE_NUMBER*

        A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security) benefits. It is also used for some purposes in the UK tax system.

        The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
        - *UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER*

        A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
        - *Custom*

        - *Regex filter* - You can use a regular expressions to define patterns for a guardrail to recognize and act upon such as serial number, booking ID etc..
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailRegexConfig(dict):
    """
    A regex configuration.
    """
    def __init__(__self__, *,
                 action: 'GuardrailSensitiveInformationAction',
                 name: str,
                 pattern: str,
                 description: Optional[str] = None):
        """
        A regex configuration.
        :param 'GuardrailSensitiveInformationAction' action: The guardrail action to configure when matching regular expression is detected.
        :param str name: The regex name.
        :param str pattern: The regex pattern.
        :param str description: The regex description.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> 'GuardrailSensitiveInformationAction':
        """
        The guardrail action to configure when matching regular expression is detected.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The regex name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The regex pattern.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The regex description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GuardrailSensitiveInformationPolicyConfig(dict):
    """
    Sensitive information policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "piiEntitiesConfig":
            suggest = "pii_entities_config"
        elif key == "regexesConfig":
            suggest = "regexes_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailSensitiveInformationPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailSensitiveInformationPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailSensitiveInformationPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pii_entities_config: Optional[Sequence['outputs.GuardrailPiiEntityConfig']] = None,
                 regexes_config: Optional[Sequence['outputs.GuardrailRegexConfig']] = None):
        """
        Sensitive information policy config for a guardrail.
        :param Sequence['GuardrailPiiEntityConfig'] pii_entities_config: List of entities.
        :param Sequence['GuardrailRegexConfig'] regexes_config: List of regex.
        """
        if pii_entities_config is not None:
            pulumi.set(__self__, "pii_entities_config", pii_entities_config)
        if regexes_config is not None:
            pulumi.set(__self__, "regexes_config", regexes_config)

    @property
    @pulumi.getter(name="piiEntitiesConfig")
    def pii_entities_config(self) -> Optional[Sequence['outputs.GuardrailPiiEntityConfig']]:
        """
        List of entities.
        """
        return pulumi.get(self, "pii_entities_config")

    @property
    @pulumi.getter(name="regexesConfig")
    def regexes_config(self) -> Optional[Sequence['outputs.GuardrailRegexConfig']]:
        """
        List of regex.
        """
        return pulumi.get(self, "regexes_config")


@pulumi.output_type
class GuardrailTopicConfig(dict):
    """
    Topic config in topic policy.
    """
    def __init__(__self__, *,
                 definition: str,
                 name: str,
                 type: 'GuardrailTopicType',
                 examples: Optional[Sequence[str]] = None):
        """
        Topic config in topic policy.
        :param str definition: Definition of topic in topic policy
        :param str name: Name of topic in topic policy
        :param 'GuardrailTopicType' type: Specifies to deny the topic.
        :param Sequence[str] examples: List of text examples
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)

    @property
    @pulumi.getter
    def definition(self) -> str:
        """
        Definition of topic in topic policy
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of topic in topic policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailTopicType':
        """
        Specifies to deny the topic.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence[str]]:
        """
        List of text examples
        """
        return pulumi.get(self, "examples")


@pulumi.output_type
class GuardrailTopicPolicyConfig(dict):
    """
    Topic policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicsConfig":
            suggest = "topics_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailTopicPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailTopicPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailTopicPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topics_config: Sequence['outputs.GuardrailTopicConfig']):
        """
        Topic policy config for a guardrail.
        :param Sequence['GuardrailTopicConfig'] topics_config: List of topic configs in topic policy.
        """
        pulumi.set(__self__, "topics_config", topics_config)

    @property
    @pulumi.getter(name="topicsConfig")
    def topics_config(self) -> Sequence['outputs.GuardrailTopicConfig']:
        """
        List of topic configs in topic policy.
        """
        return pulumi.get(self, "topics_config")


@pulumi.output_type
class GuardrailWordConfig(dict):
    """
    A custom word config.
    """
    def __init__(__self__, *,
                 text: str):
        """
        A custom word config.
        :param str text: The custom word text.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The custom word text.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GuardrailWordPolicyConfig(dict):
    """
    Word policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedWordListsConfig":
            suggest = "managed_word_lists_config"
        elif key == "wordsConfig":
            suggest = "words_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailWordPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailWordPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailWordPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_word_lists_config: Optional[Sequence['outputs.GuardrailManagedWordsConfig']] = None,
                 words_config: Optional[Sequence['outputs.GuardrailWordConfig']] = None):
        """
        Word policy config for a guardrail.
        :param Sequence['GuardrailManagedWordsConfig'] managed_word_lists_config: A config for the list of managed words.
        :param Sequence['GuardrailWordConfig'] words_config: List of custom word configs.
        """
        if managed_word_lists_config is not None:
            pulumi.set(__self__, "managed_word_lists_config", managed_word_lists_config)
        if words_config is not None:
            pulumi.set(__self__, "words_config", words_config)

    @property
    @pulumi.getter(name="managedWordListsConfig")
    def managed_word_lists_config(self) -> Optional[Sequence['outputs.GuardrailManagedWordsConfig']]:
        """
        A config for the list of managed words.
        """
        return pulumi.get(self, "managed_word_lists_config")

    @property
    @pulumi.getter(name="wordsConfig")
    def words_config(self) -> Optional[Sequence['outputs.GuardrailWordConfig']]:
        """
        List of custom word configs.
        """
        return pulumi.get(self, "words_config")


@pulumi.output_type
class KnowledgeBaseBedrockEmbeddingModelConfiguration(dict):
    """
    The vector configuration details for the Bedrock embeddings model.
    """
    def __init__(__self__, *,
                 dimensions: Optional[int] = None):
        """
        The vector configuration details for the Bedrock embeddings model.
        :param int dimensions: The dimensions details for the vector configuration used on the Bedrock embeddings model.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[int]:
        """
        The dimensions details for the vector configuration used on the Bedrock embeddings model.
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class KnowledgeBaseConfiguration(dict):
    """
    Contains details about the embeddings model used for the knowledge base.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vectorKnowledgeBaseConfiguration":
            suggest = "vector_knowledge_base_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'KnowledgeBaseType',
                 vector_knowledge_base_configuration: 'outputs.KnowledgeBaseVectorKnowledgeBaseConfiguration'):
        """
        Contains details about the embeddings model used for the knowledge base.
        :param 'KnowledgeBaseType' type: The type of data that the data source is converted into for the knowledge base.
        :param 'KnowledgeBaseVectorKnowledgeBaseConfiguration' vector_knowledge_base_configuration: Contains details about the model that's used to convert the data source into vector embeddings.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vector_knowledge_base_configuration", vector_knowledge_base_configuration)

    @property
    @pulumi.getter
    def type(self) -> 'KnowledgeBaseType':
        """
        The type of data that the data source is converted into for the knowledge base.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vectorKnowledgeBaseConfiguration")
    def vector_knowledge_base_configuration(self) -> 'outputs.KnowledgeBaseVectorKnowledgeBaseConfiguration':
        """
        Contains details about the model that's used to convert the data source into vector embeddings.
        """
        return pulumi.get(self, "vector_knowledge_base_configuration")


@pulumi.output_type
class KnowledgeBaseEmbeddingModelConfiguration(dict):
    """
    The embeddings model configuration details for the vector model used in Knowledge Base.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bedrockEmbeddingModelConfiguration":
            suggest = "bedrock_embedding_model_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseEmbeddingModelConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseEmbeddingModelConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseEmbeddingModelConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bedrock_embedding_model_configuration: Optional['outputs.KnowledgeBaseBedrockEmbeddingModelConfiguration'] = None):
        """
        The embeddings model configuration details for the vector model used in Knowledge Base.
        :param 'KnowledgeBaseBedrockEmbeddingModelConfiguration' bedrock_embedding_model_configuration: The vector configuration details on the Bedrock embeddings model.
        """
        if bedrock_embedding_model_configuration is not None:
            pulumi.set(__self__, "bedrock_embedding_model_configuration", bedrock_embedding_model_configuration)

    @property
    @pulumi.getter(name="bedrockEmbeddingModelConfiguration")
    def bedrock_embedding_model_configuration(self) -> Optional['outputs.KnowledgeBaseBedrockEmbeddingModelConfiguration']:
        """
        The vector configuration details on the Bedrock embeddings model.
        """
        return pulumi.get(self, "bedrock_embedding_model_configuration")


@pulumi.output_type
class KnowledgeBaseMongoDbAtlasConfiguration(dict):
    """
    Contains the storage configuration of the knowledge base in MongoDb Atlas Cloud.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionName":
            suggest = "collection_name"
        elif key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fieldMapping":
            suggest = "field_mapping"
        elif key == "vectorIndexName":
            suggest = "vector_index_name"
        elif key == "endpointServiceName":
            suggest = "endpoint_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseMongoDbAtlasConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseMongoDbAtlasConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseMongoDbAtlasConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_name: str,
                 credentials_secret_arn: str,
                 database_name: str,
                 endpoint: str,
                 field_mapping: 'outputs.KnowledgeBaseMongoDbAtlasFieldMapping',
                 vector_index_name: str,
                 endpoint_service_name: Optional[str] = None):
        """
        Contains the storage configuration of the knowledge base in MongoDb Atlas Cloud.
        :param str collection_name: Name of the collection within MongoDB Atlas.
        :param str credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon Mongo database.
        :param str database_name: Name of the database within MongoDB Atlas.
        :param str endpoint: MongoDB Atlas endpoint.
        :param 'KnowledgeBaseMongoDbAtlasFieldMapping' field_mapping: Contains the names of the fields to which to map information about the vector store.
        :param str vector_index_name: Name of a MongoDB Atlas index.
        :param str endpoint_service_name: MongoDB Atlas endpoint service name.
        """
        pulumi.set(__self__, "collection_name", collection_name)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "vector_index_name", vector_index_name)
        if endpoint_service_name is not None:
            pulumi.set(__self__, "endpoint_service_name", endpoint_service_name)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> str:
        """
        Name of the collection within MongoDB Atlas.
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon Mongo database.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the database within MongoDB Atlas.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        MongoDB Atlas endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBaseMongoDbAtlasFieldMapping':
        """
        Contains the names of the fields to which to map information about the vector store.
        """
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter(name="vectorIndexName")
    def vector_index_name(self) -> str:
        """
        Name of a MongoDB Atlas index.
        """
        return pulumi.get(self, "vector_index_name")

    @property
    @pulumi.getter(name="endpointServiceName")
    def endpoint_service_name(self) -> Optional[str]:
        """
        MongoDB Atlas endpoint service name.
        """
        return pulumi.get(self, "endpoint_service_name")


@pulumi.output_type
class KnowledgeBaseMongoDbAtlasFieldMapping(dict):
    """
    Contains the names of the fields to which to map information about the vector store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "textField":
            suggest = "text_field"
        elif key == "vectorField":
            suggest = "vector_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseMongoDbAtlasFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseMongoDbAtlasFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseMongoDbAtlasFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 text_field: str,
                 vector_field: str):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param str vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")


@pulumi.output_type
class KnowledgeBaseOpenSearchServerlessConfiguration(dict):
    """
    Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionArn":
            suggest = "collection_arn"
        elif key == "fieldMapping":
            suggest = "field_mapping"
        elif key == "vectorIndexName":
            suggest = "vector_index_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseOpenSearchServerlessConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseOpenSearchServerlessConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseOpenSearchServerlessConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_arn: str,
                 field_mapping: 'outputs.KnowledgeBaseOpenSearchServerlessFieldMapping',
                 vector_index_name: str):
        """
        Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
        :param str collection_arn: The ARN of the OpenSearch Service vector store.
        :param 'KnowledgeBaseOpenSearchServerlessFieldMapping' field_mapping: Contains the names of the fields to which to map information about the vector store.
        :param str vector_index_name: The name of the vector store.
        """
        pulumi.set(__self__, "collection_arn", collection_arn)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "vector_index_name", vector_index_name)

    @property
    @pulumi.getter(name="collectionArn")
    def collection_arn(self) -> str:
        """
        The ARN of the OpenSearch Service vector store.
        """
        return pulumi.get(self, "collection_arn")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBaseOpenSearchServerlessFieldMapping':
        """
        Contains the names of the fields to which to map information about the vector store.
        """
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter(name="vectorIndexName")
    def vector_index_name(self) -> str:
        """
        The name of the vector store.
        """
        return pulumi.get(self, "vector_index_name")


@pulumi.output_type
class KnowledgeBaseOpenSearchServerlessFieldMapping(dict):
    """
    A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "textField":
            suggest = "text_field"
        elif key == "vectorField":
            suggest = "vector_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseOpenSearchServerlessFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseOpenSearchServerlessFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseOpenSearchServerlessFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 text_field: str,
                 vector_field: str):
        """
        A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param str vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")


@pulumi.output_type
class KnowledgeBasePineconeConfiguration(dict):
    """
    Contains the storage configuration of the knowledge base in Pinecone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "fieldMapping":
            suggest = "field_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBasePineconeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBasePineconeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBasePineconeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 credentials_secret_arn: str,
                 field_mapping: 'outputs.KnowledgeBasePineconeFieldMapping',
                 namespace: Optional[str] = None):
        """
        Contains the storage configuration of the knowledge base in Pinecone.
        :param str connection_string: The endpoint URL for your index management page.
        :param str credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
        :param 'KnowledgeBasePineconeFieldMapping' field_mapping: Contains the names of the fields to which to map information about the vector store.
        :param str namespace: The namespace to be used to write new data to your database.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "field_mapping", field_mapping)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The endpoint URL for your index management page.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBasePineconeFieldMapping':
        """
        Contains the names of the fields to which to map information about the vector store.
        """
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace to be used to write new data to your database.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class KnowledgeBasePineconeFieldMapping(dict):
    """
    Contains the names of the fields to which to map information about the vector store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "textField":
            suggest = "text_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBasePineconeFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBasePineconeFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBasePineconeFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 text_field: str):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")


@pulumi.output_type
class KnowledgeBaseRdsConfiguration(dict):
    """
    Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see Create a vector index in Amazon RDS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fieldMapping":
            suggest = "field_mapping"
        elif key == "resourceArn":
            suggest = "resource_arn"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseRdsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseRdsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseRdsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_secret_arn: str,
                 database_name: str,
                 field_mapping: 'outputs.KnowledgeBaseRdsFieldMapping',
                 resource_arn: str,
                 table_name: str):
        """
        Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see Create a vector index in Amazon RDS.
        :param str credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
        :param str database_name: The name of your Amazon RDS database.
        :param 'KnowledgeBaseRdsFieldMapping' field_mapping: Contains the names of the fields to which to map information about the vector store.
        :param str resource_arn: The ARN of the vector store.
        :param str table_name: The name of the table in the database.
        """
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of your Amazon RDS database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBaseRdsFieldMapping':
        """
        Contains the names of the fields to which to map information about the vector store.
        """
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> str:
        """
        The ARN of the vector store.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the table in the database.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class KnowledgeBaseRdsFieldMapping(dict):
    """
    Contains the names of the fields to which to map information about the vector store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "primaryKeyField":
            suggest = "primary_key_field"
        elif key == "textField":
            suggest = "text_field"
        elif key == "vectorField":
            suggest = "vector_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseRdsFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseRdsFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseRdsFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 primary_key_field: str,
                 text_field: str,
                 vector_field: str):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str primary_key_field: The name of the field in which Amazon Bedrock stores the ID for each entry.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param str vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "primary_key_field", primary_key_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="primaryKeyField")
    def primary_key_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the ID for each entry.
        """
        return pulumi.get(self, "primary_key_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")


@pulumi.output_type
class KnowledgeBaseStorageConfiguration(dict):
    """
    The vector store service in which the knowledge base is stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mongoDbAtlasConfiguration":
            suggest = "mongo_db_atlas_configuration"
        elif key == "opensearchServerlessConfiguration":
            suggest = "opensearch_serverless_configuration"
        elif key == "pineconeConfiguration":
            suggest = "pinecone_configuration"
        elif key == "rdsConfiguration":
            suggest = "rds_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseStorageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseStorageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseStorageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'KnowledgeBaseStorageType',
                 mongo_db_atlas_configuration: Optional['outputs.KnowledgeBaseMongoDbAtlasConfiguration'] = None,
                 opensearch_serverless_configuration: Optional['outputs.KnowledgeBaseOpenSearchServerlessConfiguration'] = None,
                 pinecone_configuration: Optional['outputs.KnowledgeBasePineconeConfiguration'] = None,
                 rds_configuration: Optional['outputs.KnowledgeBaseRdsConfiguration'] = None):
        """
        The vector store service in which the knowledge base is stored.
        :param 'KnowledgeBaseStorageType' type: The vector store service in which the knowledge base is stored.
        :param 'KnowledgeBaseMongoDbAtlasConfiguration' mongo_db_atlas_configuration: Contains the storage configuration of the knowledge base in MongoDB Atlas.
        :param 'KnowledgeBaseOpenSearchServerlessConfiguration' opensearch_serverless_configuration: Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
        :param 'KnowledgeBasePineconeConfiguration' pinecone_configuration: Contains the storage configuration of the knowledge base in Pinecone.
        :param 'KnowledgeBaseRdsConfiguration' rds_configuration: Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see [Create a vector index in Amazon RDS](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html) .
        """
        pulumi.set(__self__, "type", type)
        if mongo_db_atlas_configuration is not None:
            pulumi.set(__self__, "mongo_db_atlas_configuration", mongo_db_atlas_configuration)
        if opensearch_serverless_configuration is not None:
            pulumi.set(__self__, "opensearch_serverless_configuration", opensearch_serverless_configuration)
        if pinecone_configuration is not None:
            pulumi.set(__self__, "pinecone_configuration", pinecone_configuration)
        if rds_configuration is not None:
            pulumi.set(__self__, "rds_configuration", rds_configuration)

    @property
    @pulumi.getter
    def type(self) -> 'KnowledgeBaseStorageType':
        """
        The vector store service in which the knowledge base is stored.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="mongoDbAtlasConfiguration")
    def mongo_db_atlas_configuration(self) -> Optional['outputs.KnowledgeBaseMongoDbAtlasConfiguration']:
        """
        Contains the storage configuration of the knowledge base in MongoDB Atlas.
        """
        return pulumi.get(self, "mongo_db_atlas_configuration")

    @property
    @pulumi.getter(name="opensearchServerlessConfiguration")
    def opensearch_serverless_configuration(self) -> Optional['outputs.KnowledgeBaseOpenSearchServerlessConfiguration']:
        """
        Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
        """
        return pulumi.get(self, "opensearch_serverless_configuration")

    @property
    @pulumi.getter(name="pineconeConfiguration")
    def pinecone_configuration(self) -> Optional['outputs.KnowledgeBasePineconeConfiguration']:
        """
        Contains the storage configuration of the knowledge base in Pinecone.
        """
        return pulumi.get(self, "pinecone_configuration")

    @property
    @pulumi.getter(name="rdsConfiguration")
    def rds_configuration(self) -> Optional['outputs.KnowledgeBaseRdsConfiguration']:
        """
        Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see [Create a vector index in Amazon RDS](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html) .
        """
        return pulumi.get(self, "rds_configuration")


@pulumi.output_type
class KnowledgeBaseVectorKnowledgeBaseConfiguration(dict):
    """
    Contains details about the model used to create vector embeddings for the knowledge base.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "embeddingModelArn":
            suggest = "embedding_model_arn"
        elif key == "embeddingModelConfiguration":
            suggest = "embedding_model_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseVectorKnowledgeBaseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseVectorKnowledgeBaseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseVectorKnowledgeBaseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 embedding_model_arn: str,
                 embedding_model_configuration: Optional['outputs.KnowledgeBaseEmbeddingModelConfiguration'] = None):
        """
        Contains details about the model used to create vector embeddings for the knowledge base.
        :param str embedding_model_arn: The ARN of the model used to create vector embeddings for the knowledge base.
        :param 'KnowledgeBaseEmbeddingModelConfiguration' embedding_model_configuration: The embeddings model configuration details for the vector model used in Knowledge Base.
        """
        pulumi.set(__self__, "embedding_model_arn", embedding_model_arn)
        if embedding_model_configuration is not None:
            pulumi.set(__self__, "embedding_model_configuration", embedding_model_configuration)

    @property
    @pulumi.getter(name="embeddingModelArn")
    def embedding_model_arn(self) -> str:
        """
        The ARN of the model used to create vector embeddings for the knowledge base.
        """
        return pulumi.get(self, "embedding_model_arn")

    @property
    @pulumi.getter(name="embeddingModelConfiguration")
    def embedding_model_configuration(self) -> Optional['outputs.KnowledgeBaseEmbeddingModelConfiguration']:
        """
        The embeddings model configuration details for the vector model used in Knowledge Base.
        """
        return pulumi.get(self, "embedding_model_configuration")


@pulumi.output_type
class PromptInferenceConfigurationProperties(dict):
    """
    Model inference configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.PromptModelInferenceConfiguration'):
        """
        Model inference configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.PromptModelInferenceConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class PromptInputVariable(dict):
    """
    Input variable
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Input variable
        :param str name: Name for an input variable
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name for an input variable
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PromptModelInferenceConfiguration(dict):
    """
    Prompt model inference configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"
        elif key == "stopSequences":
            suggest = "stop_sequences"
        elif key == "topK":
            suggest = "top_k"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PromptModelInferenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PromptModelInferenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PromptModelInferenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: Optional[float] = None,
                 stop_sequences: Optional[Sequence[str]] = None,
                 temperature: Optional[float] = None,
                 top_k: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        Prompt model inference configuration
        :param float max_tokens: Maximum length of output
        :param Sequence[str] stop_sequences: List of stop sequences
        :param float temperature: Controls randomness, higher values increase diversity
        :param float top_k: Sample from the k most likely next tokens
        :param float top_p: Cumulative probability cutoff for token selection
        """
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[float]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "max_tokens")

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[Sequence[str]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[float]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class PromptTemplateConfigurationProperties(dict):
    """
    Prompt template configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.PromptTextPromptTemplateConfiguration'):
        """
        Prompt template configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.PromptTextPromptTemplateConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class PromptTextPromptTemplateConfiguration(dict):
    """
    Configuration for text prompt template
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputVariables":
            suggest = "input_variables"
        elif key == "textS3Location":
            suggest = "text_s3_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PromptTextPromptTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PromptTextPromptTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PromptTextPromptTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_variables: Optional[Sequence['outputs.PromptInputVariable']] = None,
                 text: Optional[str] = None,
                 text_s3_location: Optional['outputs.PromptTextS3Location'] = None):
        """
        Configuration for text prompt template
        :param Sequence['PromptInputVariable'] input_variables: List of input variables
        :param str text: Prompt content for String prompt template
        """
        if input_variables is not None:
            pulumi.set(__self__, "input_variables", input_variables)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if text_s3_location is not None:
            pulumi.set(__self__, "text_s3_location", text_s3_location)

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Optional[Sequence['outputs.PromptInputVariable']]:
        """
        List of input variables
        """
        return pulumi.get(self, "input_variables")

    @property
    @pulumi.getter
    def text(self) -> Optional[str]:
        """
        Prompt content for String prompt template
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="textS3Location")
    def text_s3_location(self) -> Optional['outputs.PromptTextS3Location']:
        return pulumi.get(self, "text_s3_location")


@pulumi.output_type
class PromptTextS3Location(dict):
    """
    The identifier for the S3 resource.
    """
    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 version: Optional[str] = None):
        """
        The identifier for the S3 resource.
        :param str bucket: A bucket in S3
        :param str key: A object key in S3
        :param str version: The version of the the S3 object to use
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        A bucket in S3
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A object key in S3
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the the S3 object to use
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PromptVariant(dict):
    """
    Prompt variant
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateType":
            suggest = "template_type"
        elif key == "inferenceConfiguration":
            suggest = "inference_configuration"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "templateConfiguration":
            suggest = "template_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PromptVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PromptVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PromptVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 template_type: 'PromptTemplateType',
                 inference_configuration: Optional['outputs.PromptInferenceConfigurationProperties'] = None,
                 model_id: Optional[str] = None,
                 template_configuration: Optional['outputs.PromptTemplateConfigurationProperties'] = None):
        """
        Prompt variant
        :param str name: Name for a variant.
        :param 'PromptTemplateType' template_type: The type of prompt template to use.
        :param 'PromptInferenceConfigurationProperties' inference_configuration: Contains inference configurations for the prompt variant.
        :param str model_id: ARN or name of a Bedrock model.
        :param 'PromptTemplateConfigurationProperties' template_configuration: Contains configurations for the prompt template.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "template_type", template_type)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for a variant.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> 'PromptTemplateType':
        """
        The type of prompt template to use.
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional['outputs.PromptInferenceConfigurationProperties']:
        """
        Contains inference configurations for the prompt variant.
        """
        return pulumi.get(self, "inference_configuration")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional['outputs.PromptTemplateConfigurationProperties']:
        """
        Contains configurations for the prompt template.
        """
        return pulumi.get(self, "template_configuration")


@pulumi.output_type
class PromptVersionPromptInferenceConfigurationProperties(dict):
    """
    Model inference configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.PromptVersionPromptModelInferenceConfiguration'):
        """
        Model inference configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.PromptVersionPromptModelInferenceConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class PromptVersionPromptInputVariable(dict):
    """
    Input variable
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Input variable
        :param str name: Name for an input variable
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name for an input variable
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PromptVersionPromptModelInferenceConfiguration(dict):
    """
    Prompt model inference configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"
        elif key == "stopSequences":
            suggest = "stop_sequences"
        elif key == "topK":
            suggest = "top_k"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PromptVersionPromptModelInferenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PromptVersionPromptModelInferenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PromptVersionPromptModelInferenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: Optional[float] = None,
                 stop_sequences: Optional[Sequence[str]] = None,
                 temperature: Optional[float] = None,
                 top_k: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        Prompt model inference configuration
        :param float max_tokens: Maximum length of output
        :param Sequence[str] stop_sequences: List of stop sequences
        :param float temperature: Controls randomness, higher values increase diversity
        :param float top_k: Sample from the k most likely next tokens
        :param float top_p: Cumulative probability cutoff for token selection
        """
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[float]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "max_tokens")

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[Sequence[str]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[float]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class PromptVersionPromptTemplateConfigurationProperties(dict):
    """
    Prompt template configuration
    """
    def __init__(__self__, *,
                 text: 'outputs.PromptVersionTextPromptTemplateConfiguration'):
        """
        Prompt template configuration
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> 'outputs.PromptVersionTextPromptTemplateConfiguration':
        return pulumi.get(self, "text")


@pulumi.output_type
class PromptVersionPromptVariant(dict):
    """
    Prompt variant
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateType":
            suggest = "template_type"
        elif key == "inferenceConfiguration":
            suggest = "inference_configuration"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "templateConfiguration":
            suggest = "template_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PromptVersionPromptVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PromptVersionPromptVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PromptVersionPromptVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 template_type: 'PromptVersionPromptTemplateType',
                 inference_configuration: Optional['outputs.PromptVersionPromptInferenceConfigurationProperties'] = None,
                 model_id: Optional[str] = None,
                 template_configuration: Optional['outputs.PromptVersionPromptTemplateConfigurationProperties'] = None):
        """
        Prompt variant
        :param str name: Name for a variant.
        :param 'PromptVersionPromptTemplateType' template_type: The type of prompt template to use.
        :param 'PromptVersionPromptInferenceConfigurationProperties' inference_configuration: Contains inference configurations for the prompt variant.
        :param str model_id: ARN or name of a Bedrock model.
        :param 'PromptVersionPromptTemplateConfigurationProperties' template_configuration: Contains configurations for the prompt template.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "template_type", template_type)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if template_configuration is not None:
            pulumi.set(__self__, "template_configuration", template_configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for a variant.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> 'PromptVersionPromptTemplateType':
        """
        The type of prompt template to use.
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional['outputs.PromptVersionPromptInferenceConfigurationProperties']:
        """
        Contains inference configurations for the prompt variant.
        """
        return pulumi.get(self, "inference_configuration")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional['outputs.PromptVersionPromptTemplateConfigurationProperties']:
        """
        Contains configurations for the prompt template.
        """
        return pulumi.get(self, "template_configuration")


@pulumi.output_type
class PromptVersionTextPromptTemplateConfiguration(dict):
    """
    Configuration for text prompt template
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputVariables":
            suggest = "input_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PromptVersionTextPromptTemplateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PromptVersionTextPromptTemplateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PromptVersionTextPromptTemplateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text: str,
                 input_variables: Optional[Sequence['outputs.PromptVersionPromptInputVariable']] = None):
        """
        Configuration for text prompt template
        :param str text: Prompt content for String prompt template
        :param Sequence['PromptVersionPromptInputVariable'] input_variables: List of input variables
        """
        pulumi.set(__self__, "text", text)
        if input_variables is not None:
            pulumi.set(__self__, "input_variables", input_variables)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Prompt content for String prompt template
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="inputVariables")
    def input_variables(self) -> Optional[Sequence['outputs.PromptVersionPromptInputVariable']]:
        """
        List of input variables
        """
        return pulumi.get(self, "input_variables")


