# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetPromptResult',
    'AwaitableGetPromptResult',
    'get_prompt',
    'get_prompt_output',
]

@pulumi.output_type
class GetPromptResult:
    def __init__(__self__, arn=None, created_at=None, customer_encryption_key_arn=None, default_variant=None, description=None, id=None, name=None, tags=None, updated_at=None, variants=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if customer_encryption_key_arn and not isinstance(customer_encryption_key_arn, str):
            raise TypeError("Expected argument 'customer_encryption_key_arn' to be a str")
        pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if default_variant and not isinstance(default_variant, str):
            raise TypeError("Expected argument 'default_variant' to be a str")
        pulumi.set(__self__, "default_variant", default_variant)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if variants and not isinstance(variants, list):
            raise TypeError("Expected argument 'variants' to be a list")
        pulumi.set(__self__, "variants", variants)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        ARN of a prompt resource possibly with a version
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[str]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> Optional[str]:
        """
        Name for a variant.
        """
        return pulumi.get(self, "default_variant")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Identifier for a Prompt
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name for a prompt resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def variants(self) -> Optional[Sequence['outputs.PromptVariant']]:
        """
        List of prompt variants
        """
        return pulumi.get(self, "variants")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Draft Version.
        """
        return pulumi.get(self, "version")


class AwaitableGetPromptResult(GetPromptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPromptResult(
            arn=self.arn,
            created_at=self.created_at,
            customer_encryption_key_arn=self.customer_encryption_key_arn,
            default_variant=self.default_variant,
            description=self.description,
            id=self.id,
            name=self.name,
            tags=self.tags,
            updated_at=self.updated_at,
            variants=self.variants,
            version=self.version)


def get_prompt(arn: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPromptResult:
    """
    Definition of AWS::Bedrock::Prompt Resource Type


    :param str arn: ARN of a prompt resource possibly with a version
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:bedrock:getPrompt', __args__, opts=opts, typ=GetPromptResult).value

    return AwaitableGetPromptResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__ret__, 'customer_encryption_key_arn'),
        default_variant=pulumi.get(__ret__, 'default_variant'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        variants=pulumi.get(__ret__, 'variants'),
        version=pulumi.get(__ret__, 'version'))
def get_prompt_output(arn: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPromptResult]:
    """
    Definition of AWS::Bedrock::Prompt Resource Type


    :param str arn: ARN of a prompt resource possibly with a version
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:bedrock:getPrompt', __args__, opts=opts, typ=GetPromptResult)
    return __ret__.apply(lambda __response__: GetPromptResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        customer_encryption_key_arn=pulumi.get(__response__, 'customer_encryption_key_arn'),
        default_variant=pulumi.get(__response__, 'default_variant'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        variants=pulumi.get(__response__, 'variants'),
        version=pulumi.get(__response__, 'version')))
