# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['FlowVersionArgs', 'FlowVersion']

@pulumi.input_type
class FlowVersionArgs:
    def __init__(__self__, *,
                 flow_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FlowVersion resource.
        :param pulumi.Input[str] flow_arn: Arn representation of the Flow
        :param pulumi.Input[str] description: Description of the flow version
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Input[str]:
        """
        Arn representation of the Flow
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the flow version
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


class FlowVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::FlowVersion Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the flow version
        :param pulumi.Input[str] flow_arn: Arn representation of the Flow
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::FlowVersion Resource Type

        :param str resource_name: The name of the resource.
        :param FlowVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowVersionArgs.__new__(FlowVersionArgs)

            __props__.__dict__["description"] = description
            if flow_arn is None and not opts.urn:
                raise TypeError("Missing required property 'flow_arn'")
            __props__.__dict__["flow_arn"] = flow_arn
            __props__.__dict__["created_at"] = None
            __props__.__dict__["customer_encryption_key_arn"] = None
            __props__.__dict__["definition"] = None
            __props__.__dict__["execution_role_arn"] = None
            __props__.__dict__["flow_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["description", "flowArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FlowVersion, __self__).__init__(
            'aws-native:bedrock:FlowVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FlowVersion':
        """
        Get an existing FlowVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FlowVersionArgs.__new__(FlowVersionArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["customer_encryption_key_arn"] = None
        __props__.__dict__["definition"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["flow_arn"] = None
        __props__.__dict__["flow_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["version"] = None
        return FlowVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[str]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output['outputs.FlowVersionFlowDefinition']:
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the flow version
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of a IAM role
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Output[str]:
        """
        Arn representation of the Flow
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="flowId")
    def flow_id(self) -> pulumi.Output[str]:
        """
        Identifier for a Flow
        """
        return pulumi.get(self, "flow_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['FlowVersionFlowStatus']:
        """
        The status of the flow.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Numerical Version.
        """
        return pulumi.get(self, "version")

