# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FlowArgs', 'Flow']

@pulumi.input_type
class FlowArgs:
    def __init__(__self__, *,
                 execution_role_arn: pulumi.Input[str],
                 customer_encryption_key_arn: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input['FlowDefinitionArgs']] = None,
                 definition_s3_location: Optional[pulumi.Input['FlowS3LocationArgs']] = None,
                 definition_string: Optional[pulumi.Input[str]] = None,
                 definition_substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 test_alias_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Flow resource.
        :param pulumi.Input[str] execution_role_arn: ARN of a IAM role
        :param pulumi.Input[str] customer_encryption_key_arn: A KMS key ARN
        :param pulumi.Input['FlowDefinitionArgs'] definition: The definition of the nodes and connections between the nodes in the flow.
        :param pulumi.Input['FlowS3LocationArgs'] definition_s3_location: The Amazon S3 location of the flow definition.
        :param pulumi.Input[str] definition_string: A JSON string containing a Definition with the same schema as the Definition property of this resource
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]] definition_substitutions: A map that specifies the mappings for placeholder variables in the prompt flow definition. This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the `DefinitionString` and `DefinitionS3Location` fields.
               
               Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        :param pulumi.Input[str] description: Description of the flow
        :param pulumi.Input[str] name: Name for the flow
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if definition_s3_location is not None:
            pulumi.set(__self__, "definition_s3_location", definition_s3_location)
        if definition_string is not None:
            pulumi.set(__self__, "definition_string", definition_string)
        if definition_substitutions is not None:
            pulumi.set(__self__, "definition_substitutions", definition_substitutions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if test_alias_tags is not None:
            pulumi.set(__self__, "test_alias_tags", test_alias_tags)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[str]:
        """
        ARN of a IAM role
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input['FlowDefinitionArgs']]:
        """
        The definition of the nodes and connections between the nodes in the flow.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input['FlowDefinitionArgs']]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter(name="definitionS3Location")
    def definition_s3_location(self) -> Optional[pulumi.Input['FlowS3LocationArgs']]:
        """
        The Amazon S3 location of the flow definition.
        """
        return pulumi.get(self, "definition_s3_location")

    @definition_s3_location.setter
    def definition_s3_location(self, value: Optional[pulumi.Input['FlowS3LocationArgs']]):
        pulumi.set(self, "definition_s3_location", value)

    @property
    @pulumi.getter(name="definitionString")
    def definition_string(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string containing a Definition with the same schema as the Definition property of this resource
        """
        return pulumi.get(self, "definition_string")

    @definition_string.setter
    def definition_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "definition_string", value)

    @property
    @pulumi.getter(name="definitionSubstitutions")
    def definition_substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]]:
        """
        A map that specifies the mappings for placeholder variables in the prompt flow definition. This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the `DefinitionString` and `DefinitionS3Location` fields.

        Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        """
        return pulumi.get(self, "definition_substitutions")

    @definition_substitutions.setter
    def definition_substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]]):
        pulumi.set(self, "definition_substitutions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the flow
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the flow
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="testAliasTags")
    def test_alias_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "test_alias_tags")

    @test_alias_tags.setter
    def test_alias_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "test_alias_tags", value)


class Flow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[Union['FlowDefinitionArgs', 'FlowDefinitionArgsDict']]] = None,
                 definition_s3_location: Optional[pulumi.Input[Union['FlowS3LocationArgs', 'FlowS3LocationArgsDict']]] = None,
                 definition_string: Optional[pulumi.Input[str]] = None,
                 definition_substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 test_alias_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::Flow Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer_encryption_key_arn: A KMS key ARN
        :param pulumi.Input[Union['FlowDefinitionArgs', 'FlowDefinitionArgsDict']] definition: The definition of the nodes and connections between the nodes in the flow.
        :param pulumi.Input[Union['FlowS3LocationArgs', 'FlowS3LocationArgsDict']] definition_s3_location: The Amazon S3 location of the flow definition.
        :param pulumi.Input[str] definition_string: A JSON string containing a Definition with the same schema as the Definition property of this resource
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]] definition_substitutions: A map that specifies the mappings for placeholder variables in the prompt flow definition. This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the `DefinitionString` and `DefinitionS3Location` fields.
               
               Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        :param pulumi.Input[str] description: Description of the flow
        :param pulumi.Input[str] execution_role_arn: ARN of a IAM role
        :param pulumi.Input[str] name: Name for the flow
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::Flow Resource Type

        :param str resource_name: The name of the resource.
        :param FlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[Union['FlowDefinitionArgs', 'FlowDefinitionArgsDict']]] = None,
                 definition_s3_location: Optional[pulumi.Input[Union['FlowS3LocationArgs', 'FlowS3LocationArgsDict']]] = None,
                 definition_string: Optional[pulumi.Input[str]] = None,
                 definition_substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[str, int, bool]]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 test_alias_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowArgs.__new__(FlowArgs)

            __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
            __props__.__dict__["definition"] = definition
            __props__.__dict__["definition_s3_location"] = definition_s3_location
            __props__.__dict__["definition_string"] = definition_string
            __props__.__dict__["definition_substitutions"] = definition_substitutions
            __props__.__dict__["description"] = description
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["test_alias_tags"] = test_alias_tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["validations"] = None
            __props__.__dict__["version"] = None
        super(Flow, __self__).__init__(
            'aws-native:bedrock:Flow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Flow':
        """
        Get an existing Flow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FlowArgs.__new__(FlowArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["customer_encryption_key_arn"] = None
        __props__.__dict__["definition"] = None
        __props__.__dict__["definition_s3_location"] = None
        __props__.__dict__["definition_string"] = None
        __props__.__dict__["definition_substitutions"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["test_alias_tags"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["validations"] = None
        __props__.__dict__["version"] = None
        return Flow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Arn representation of the Flow
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        Identifier for a Flow
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output[Optional['outputs.FlowDefinition']]:
        """
        The definition of the nodes and connections between the nodes in the flow.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="definitionS3Location")
    def definition_s3_location(self) -> pulumi.Output[Optional['outputs.FlowS3Location']]:
        """
        The Amazon S3 location of the flow definition.
        """
        return pulumi.get(self, "definition_s3_location")

    @property
    @pulumi.getter(name="definitionString")
    def definition_string(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string containing a Definition with the same schema as the Definition property of this resource
        """
        return pulumi.get(self, "definition_string")

    @property
    @pulumi.getter(name="definitionSubstitutions")
    def definition_substitutions(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map that specifies the mappings for placeholder variables in the prompt flow definition. This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the `DefinitionString` and `DefinitionS3Location` fields.

        Substitutions must follow the syntax: `${key_name}` or `${variable_1,variable_2,...}` .
        """
        return pulumi.get(self, "definition_substitutions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the flow
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of a IAM role
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the flow
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['FlowStatus']:
        """
        The status of the flow. The following statuses are possible:

        - NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you can't test it. If you updated the flow, the `DRAFT` version won't contain the latest changes for testing. Send a [PrepareFlow](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html) request to package the latest changes into the `DRAFT` version.
        - Preparing – The flow is being prepared so that the `DRAFT` version contains the latest changes for testing.
        - Prepared – The flow is prepared and the `DRAFT` version contains the latest changes for testing.
        - Failed – The last API operation that you invoked on the flow failed. Send a [GetFlow](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html) request and check the error message in the `validations` field.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="testAliasTags")
    def test_alias_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "test_alias_tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def validations(self) -> pulumi.Output[Sequence['outputs.FlowValidation']]:
        return pulumi.get(self, "validations")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Draft Version.
        """
        return pulumi.get(self, "version")

