# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AgentArgs', 'Agent']

@pulumi.input_type
class AgentArgs:
    def __init__(__self__, *,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AgentActionGroupArgs']]]] = None,
                 agent_name: Optional[pulumi.Input[str]] = None,
                 agent_resource_role_arn: Optional[pulumi.Input[str]] = None,
                 auto_prepare: Optional[pulumi.Input[bool]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 foundation_model: Optional[pulumi.Input[str]] = None,
                 guardrail_configuration: Optional[pulumi.Input['AgentGuardrailConfigurationArgs']] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[float]] = None,
                 instruction: Optional[pulumi.Input[str]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input['AgentKnowledgeBaseArgs']]]] = None,
                 prompt_override_configuration: Optional[pulumi.Input['AgentPromptOverrideConfigurationArgs']] = None,
                 skip_resource_in_use_check_on_delete: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 test_alias_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Agent resource.
        :param pulumi.Input[Sequence[pulumi.Input['AgentActionGroupArgs']]] action_groups: List of ActionGroups
        :param pulumi.Input[str] agent_name: Name for a resource.
        :param pulumi.Input[str] agent_resource_role_arn: ARN of a IAM role.
        :param pulumi.Input[bool] auto_prepare: Specifies whether to automatically prepare after creating or updating the agent.
        :param pulumi.Input[str] customer_encryption_key_arn: A KMS key ARN
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[str] foundation_model: ARN or name of a Bedrock model.
        :param pulumi.Input['AgentGuardrailConfigurationArgs'] guardrail_configuration: Details about the guardrail associated with the agent.
        :param pulumi.Input[float] idle_session_ttl_in_seconds: Max Session Time.
        :param pulumi.Input[str] instruction: Instruction for the agent.
        :param pulumi.Input[Sequence[pulumi.Input['AgentKnowledgeBaseArgs']]] knowledge_bases: List of Agent Knowledge Bases
        :param pulumi.Input['AgentPromptOverrideConfigurationArgs'] prompt_override_configuration: Contains configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html) .
        :param pulumi.Input[bool] skip_resource_in_use_check_on_delete: Specifies whether to allow deleting agent while it is in use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] test_alias_tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        if action_groups is not None:
            pulumi.set(__self__, "action_groups", action_groups)
        if agent_name is not None:
            pulumi.set(__self__, "agent_name", agent_name)
        if agent_resource_role_arn is not None:
            pulumi.set(__self__, "agent_resource_role_arn", agent_resource_role_arn)
        if auto_prepare is not None:
            pulumi.set(__self__, "auto_prepare", auto_prepare)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if foundation_model is not None:
            pulumi.set(__self__, "foundation_model", foundation_model)
        if guardrail_configuration is not None:
            pulumi.set(__self__, "guardrail_configuration", guardrail_configuration)
        if idle_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "idle_session_ttl_in_seconds", idle_session_ttl_in_seconds)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if knowledge_bases is not None:
            pulumi.set(__self__, "knowledge_bases", knowledge_bases)
        if prompt_override_configuration is not None:
            pulumi.set(__self__, "prompt_override_configuration", prompt_override_configuration)
        if skip_resource_in_use_check_on_delete is not None:
            pulumi.set(__self__, "skip_resource_in_use_check_on_delete", skip_resource_in_use_check_on_delete)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if test_alias_tags is not None:
            pulumi.set(__self__, "test_alias_tags", test_alias_tags)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentActionGroupArgs']]]]:
        """
        List of ActionGroups
        """
        return pulumi.get(self, "action_groups")

    @action_groups.setter
    def action_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentActionGroupArgs']]]]):
        pulumi.set(self, "action_groups", value)

    @property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "agent_name")

    @agent_name.setter
    def agent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_name", value)

    @property
    @pulumi.getter(name="agentResourceRoleArn")
    def agent_resource_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of a IAM role.
        """
        return pulumi.get(self, "agent_resource_role_arn")

    @agent_resource_role_arn.setter
    def agent_resource_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_resource_role_arn", value)

    @property
    @pulumi.getter(name="autoPrepare")
    def auto_prepare(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically prepare after creating or updating the agent.
        """
        return pulumi.get(self, "auto_prepare")

    @auto_prepare.setter
    def auto_prepare(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_prepare", value)

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="foundationModel")
    def foundation_model(self) -> Optional[pulumi.Input[str]]:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "foundation_model")

    @foundation_model.setter
    def foundation_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "foundation_model", value)

    @property
    @pulumi.getter(name="guardrailConfiguration")
    def guardrail_configuration(self) -> Optional[pulumi.Input['AgentGuardrailConfigurationArgs']]:
        """
        Details about the guardrail associated with the agent.
        """
        return pulumi.get(self, "guardrail_configuration")

    @guardrail_configuration.setter
    def guardrail_configuration(self, value: Optional[pulumi.Input['AgentGuardrailConfigurationArgs']]):
        pulumi.set(self, "guardrail_configuration", value)

    @property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        Max Session Time.
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @idle_session_ttl_in_seconds.setter
    def idle_session_ttl_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "idle_session_ttl_in_seconds", value)

    @property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input[str]]:
        """
        Instruction for the agent.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instruction", value)

    @property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentKnowledgeBaseArgs']]]]:
        """
        List of Agent Knowledge Bases
        """
        return pulumi.get(self, "knowledge_bases")

    @knowledge_bases.setter
    def knowledge_bases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentKnowledgeBaseArgs']]]]):
        pulumi.set(self, "knowledge_bases", value)

    @property
    @pulumi.getter(name="promptOverrideConfiguration")
    def prompt_override_configuration(self) -> Optional[pulumi.Input['AgentPromptOverrideConfigurationArgs']]:
        """
        Contains configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html) .
        """
        return pulumi.get(self, "prompt_override_configuration")

    @prompt_override_configuration.setter
    def prompt_override_configuration(self, value: Optional[pulumi.Input['AgentPromptOverrideConfigurationArgs']]):
        pulumi.set(self, "prompt_override_configuration", value)

    @property
    @pulumi.getter(name="skipResourceInUseCheckOnDelete")
    def skip_resource_in_use_check_on_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow deleting agent while it is in use.
        """
        return pulumi.get(self, "skip_resource_in_use_check_on_delete")

    @skip_resource_in_use_check_on_delete.setter
    def skip_resource_in_use_check_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_resource_in_use_check_on_delete", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="testAliasTags")
    def test_alias_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "test_alias_tags")

    @test_alias_tags.setter
    def test_alias_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "test_alias_tags", value)


class Agent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentActionGroupArgs', 'AgentActionGroupArgsDict']]]]] = None,
                 agent_name: Optional[pulumi.Input[str]] = None,
                 agent_resource_role_arn: Optional[pulumi.Input[str]] = None,
                 auto_prepare: Optional[pulumi.Input[bool]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 foundation_model: Optional[pulumi.Input[str]] = None,
                 guardrail_configuration: Optional[pulumi.Input[Union['AgentGuardrailConfigurationArgs', 'AgentGuardrailConfigurationArgsDict']]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[float]] = None,
                 instruction: Optional[pulumi.Input[str]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentKnowledgeBaseArgs', 'AgentKnowledgeBaseArgsDict']]]]] = None,
                 prompt_override_configuration: Optional[pulumi.Input[Union['AgentPromptOverrideConfigurationArgs', 'AgentPromptOverrideConfigurationArgsDict']]] = None,
                 skip_resource_in_use_check_on_delete: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 test_alias_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::Agent Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentActionGroupArgs', 'AgentActionGroupArgsDict']]]] action_groups: List of ActionGroups
        :param pulumi.Input[str] agent_name: Name for a resource.
        :param pulumi.Input[str] agent_resource_role_arn: ARN of a IAM role.
        :param pulumi.Input[bool] auto_prepare: Specifies whether to automatically prepare after creating or updating the agent.
        :param pulumi.Input[str] customer_encryption_key_arn: A KMS key ARN
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[str] foundation_model: ARN or name of a Bedrock model.
        :param pulumi.Input[Union['AgentGuardrailConfigurationArgs', 'AgentGuardrailConfigurationArgsDict']] guardrail_configuration: Details about the guardrail associated with the agent.
        :param pulumi.Input[float] idle_session_ttl_in_seconds: Max Session Time.
        :param pulumi.Input[str] instruction: Instruction for the agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentKnowledgeBaseArgs', 'AgentKnowledgeBaseArgsDict']]]] knowledge_bases: List of Agent Knowledge Bases
        :param pulumi.Input[Union['AgentPromptOverrideConfigurationArgs', 'AgentPromptOverrideConfigurationArgsDict']] prompt_override_configuration: Contains configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html) .
        :param pulumi.Input[bool] skip_resource_in_use_check_on_delete: Specifies whether to allow deleting agent while it is in use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] test_alias_tags: Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:
               
               - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
               - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::Agent Resource Type

        :param str resource_name: The name of the resource.
        :param AgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentActionGroupArgs', 'AgentActionGroupArgsDict']]]]] = None,
                 agent_name: Optional[pulumi.Input[str]] = None,
                 agent_resource_role_arn: Optional[pulumi.Input[str]] = None,
                 auto_prepare: Optional[pulumi.Input[bool]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 foundation_model: Optional[pulumi.Input[str]] = None,
                 guardrail_configuration: Optional[pulumi.Input[Union['AgentGuardrailConfigurationArgs', 'AgentGuardrailConfigurationArgsDict']]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[float]] = None,
                 instruction: Optional[pulumi.Input[str]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentKnowledgeBaseArgs', 'AgentKnowledgeBaseArgsDict']]]]] = None,
                 prompt_override_configuration: Optional[pulumi.Input[Union['AgentPromptOverrideConfigurationArgs', 'AgentPromptOverrideConfigurationArgsDict']]] = None,
                 skip_resource_in_use_check_on_delete: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 test_alias_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentArgs.__new__(AgentArgs)

            __props__.__dict__["action_groups"] = action_groups
            __props__.__dict__["agent_name"] = agent_name
            __props__.__dict__["agent_resource_role_arn"] = agent_resource_role_arn
            __props__.__dict__["auto_prepare"] = auto_prepare
            __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
            __props__.__dict__["description"] = description
            __props__.__dict__["foundation_model"] = foundation_model
            __props__.__dict__["guardrail_configuration"] = guardrail_configuration
            __props__.__dict__["idle_session_ttl_in_seconds"] = idle_session_ttl_in_seconds
            __props__.__dict__["instruction"] = instruction
            __props__.__dict__["knowledge_bases"] = knowledge_bases
            __props__.__dict__["prompt_override_configuration"] = prompt_override_configuration
            __props__.__dict__["skip_resource_in_use_check_on_delete"] = skip_resource_in_use_check_on_delete
            __props__.__dict__["tags"] = tags
            __props__.__dict__["test_alias_tags"] = test_alias_tags
            __props__.__dict__["agent_arn"] = None
            __props__.__dict__["agent_id"] = None
            __props__.__dict__["agent_status"] = None
            __props__.__dict__["agent_version"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["failure_reasons"] = None
            __props__.__dict__["prepared_at"] = None
            __props__.__dict__["recommended_actions"] = None
            __props__.__dict__["updated_at"] = None
        super(Agent, __self__).__init__(
            'aws-native:bedrock:Agent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Agent':
        """
        Get an existing Agent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AgentArgs.__new__(AgentArgs)

        __props__.__dict__["action_groups"] = None
        __props__.__dict__["agent_arn"] = None
        __props__.__dict__["agent_id"] = None
        __props__.__dict__["agent_name"] = None
        __props__.__dict__["agent_resource_role_arn"] = None
        __props__.__dict__["agent_status"] = None
        __props__.__dict__["agent_version"] = None
        __props__.__dict__["auto_prepare"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["customer_encryption_key_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["failure_reasons"] = None
        __props__.__dict__["foundation_model"] = None
        __props__.__dict__["guardrail_configuration"] = None
        __props__.__dict__["idle_session_ttl_in_seconds"] = None
        __props__.__dict__["instruction"] = None
        __props__.__dict__["knowledge_bases"] = None
        __props__.__dict__["prepared_at"] = None
        __props__.__dict__["prompt_override_configuration"] = None
        __props__.__dict__["recommended_actions"] = None
        __props__.__dict__["skip_resource_in_use_check_on_delete"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["test_alias_tags"] = None
        __props__.__dict__["updated_at"] = None
        return Agent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> pulumi.Output[Optional[Sequence['outputs.AgentActionGroup']]]:
        """
        List of ActionGroups
        """
        return pulumi.get(self, "action_groups")

    @property
    @pulumi.getter(name="agentArn")
    def agent_arn(self) -> pulumi.Output[str]:
        """
        Arn representation of the Agent.
        """
        return pulumi.get(self, "agent_arn")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[str]:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> pulumi.Output[str]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "agent_name")

    @property
    @pulumi.getter(name="agentResourceRoleArn")
    def agent_resource_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of a IAM role.
        """
        return pulumi.get(self, "agent_resource_role_arn")

    @property
    @pulumi.getter(name="agentStatus")
    def agent_status(self) -> pulumi.Output['AgentStatus']:
        """
        The status of the agent and whether it is ready for use. The following statuses are possible:

        - CREATING – The agent is being created.
        - PREPARING – The agent is being prepared.
        - PREPARED – The agent is prepared and ready to be invoked.
        - NOT_PREPARED – The agent has been created but not yet prepared.
        - FAILED – The agent API operation failed.
        - UPDATING – The agent is being updated.
        - DELETING – The agent is being deleted.
        """
        return pulumi.get(self, "agent_status")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[str]:
        """
        Draft Agent Version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="autoPrepare")
    def auto_prepare(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically prepare after creating or updating the agent.
        """
        return pulumi.get(self, "auto_prepare")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        A KMS key ARN
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="failureReasons")
    def failure_reasons(self) -> pulumi.Output[Sequence[str]]:
        """
        Failure Reasons for Error.
        """
        return pulumi.get(self, "failure_reasons")

    @property
    @pulumi.getter(name="foundationModel")
    def foundation_model(self) -> pulumi.Output[Optional[str]]:
        """
        ARN or name of a Bedrock model.
        """
        return pulumi.get(self, "foundation_model")

    @property
    @pulumi.getter(name="guardrailConfiguration")
    def guardrail_configuration(self) -> pulumi.Output[Optional['outputs.AgentGuardrailConfiguration']]:
        """
        Details about the guardrail associated with the agent.
        """
        return pulumi.get(self, "guardrail_configuration")

    @property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> pulumi.Output[Optional[float]]:
        """
        Max Session Time.
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @property
    @pulumi.getter
    def instruction(self) -> pulumi.Output[Optional[str]]:
        """
        Instruction for the agent.
        """
        return pulumi.get(self, "instruction")

    @property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> pulumi.Output[Optional[Sequence['outputs.AgentKnowledgeBase']]]:
        """
        List of Agent Knowledge Bases
        """
        return pulumi.get(self, "knowledge_bases")

    @property
    @pulumi.getter(name="preparedAt")
    def prepared_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "prepared_at")

    @property
    @pulumi.getter(name="promptOverrideConfiguration")
    def prompt_override_configuration(self) -> pulumi.Output[Optional['outputs.AgentPromptOverrideConfiguration']]:
        """
        Contains configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html) .
        """
        return pulumi.get(self, "prompt_override_configuration")

    @property
    @pulumi.getter(name="recommendedActions")
    def recommended_actions(self) -> pulumi.Output[Sequence[str]]:
        """
        The recommended actions users can take to resolve an error in failureReasons.
        """
        return pulumi.get(self, "recommended_actions")

    @property
    @pulumi.getter(name="skipResourceInUseCheckOnDelete")
    def skip_resource_in_use_check_on_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to allow deleting agent while it is in use.
        """
        return pulumi.get(self, "skip_resource_in_use_check_on_delete")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="testAliasTags")
    def test_alias_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:

        - [Tag naming limits and requirements](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions)
        - [Tagging best practices](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices)
        """
        return pulumi.get(self, "test_alias_tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

