# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetJobQueueResult',
    'AwaitableGetJobQueueResult',
    'get_job_queue',
    'get_job_queue_output',
]

@pulumi.output_type
class GetJobQueueResult:
    def __init__(__self__, compute_environment_order=None, job_queue_arn=None, job_state_time_limit_actions=None, priority=None, scheduling_policy_arn=None, state=None):
        if compute_environment_order and not isinstance(compute_environment_order, list):
            raise TypeError("Expected argument 'compute_environment_order' to be a list")
        pulumi.set(__self__, "compute_environment_order", compute_environment_order)
        if job_queue_arn and not isinstance(job_queue_arn, str):
            raise TypeError("Expected argument 'job_queue_arn' to be a str")
        pulumi.set(__self__, "job_queue_arn", job_queue_arn)
        if job_state_time_limit_actions and not isinstance(job_state_time_limit_actions, list):
            raise TypeError("Expected argument 'job_state_time_limit_actions' to be a list")
        pulumi.set(__self__, "job_state_time_limit_actions", job_state_time_limit_actions)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if scheduling_policy_arn and not isinstance(scheduling_policy_arn, str):
            raise TypeError("Expected argument 'scheduling_policy_arn' to be a str")
        pulumi.set(__self__, "scheduling_policy_arn", scheduling_policy_arn)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="computeEnvironmentOrder")
    def compute_environment_order(self) -> Optional[Sequence['outputs.JobQueueComputeEnvironmentOrder']]:
        """
        The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the `VALID` state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 ( `EC2` or `SPOT` ) or Fargate ( `FARGATE` or `FARGATE_SPOT` ); EC2 and Fargate compute environments can't be mixed.

        > All compute environments that are associated with a job queue must share the same architecture. AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
        """
        return pulumi.get(self, "compute_environment_order")

    @property
    @pulumi.getter(name="jobQueueArn")
    def job_queue_arn(self) -> Optional[str]:
        """
        Returns the job queue ARN, such as `batch: *us-east-1* : *111122223333* :job-queue/ *JobQueueName*` .
        """
        return pulumi.get(self, "job_queue_arn")

    @property
    @pulumi.getter(name="jobStateTimeLimitActions")
    def job_state_time_limit_actions(self) -> Optional[Sequence['outputs.JobQueueJobStateTimeLimitAction']]:
        """
        The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times. AWS Batch will perform each action after `maxTimeSeconds` has passed.
        """
        return pulumi.get(self, "job_state_time_limit_actions")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the job queue. Job queues with a higher priority (or a higher integer value for the `priority` parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of `10` is given scheduling preference over a job queue with a priority value of `1` . All of the compute environments must be either EC2 ( `EC2` or `SPOT` ) or Fargate ( `FARGATE` or `FARGATE_SPOT` ); EC2 and Fargate compute environments can't be mixed.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the scheduling policy. The format is `aws: *Partition* :batch: *Region* : *Account* :scheduling-policy/ *Name*` . For example, `aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy` .
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @property
    @pulumi.getter
    def state(self) -> Optional['JobQueueState']:
        """
        The state of the job queue. If the job queue state is `ENABLED` , it is able to accept jobs. If the job queue state is `DISABLED` , new jobs can't be added to the queue, but jobs already in the queue can finish.
        """
        return pulumi.get(self, "state")


class AwaitableGetJobQueueResult(GetJobQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobQueueResult(
            compute_environment_order=self.compute_environment_order,
            job_queue_arn=self.job_queue_arn,
            job_state_time_limit_actions=self.job_state_time_limit_actions,
            priority=self.priority,
            scheduling_policy_arn=self.scheduling_policy_arn,
            state=self.state)


def get_job_queue(job_queue_arn: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobQueueResult:
    """
    Resource Type definition for AWS::Batch::JobQueue


    :param str job_queue_arn: Returns the job queue ARN, such as `batch: *us-east-1* : *111122223333* :job-queue/ *JobQueueName*` .
    """
    __args__ = dict()
    __args__['jobQueueArn'] = job_queue_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:batch:getJobQueue', __args__, opts=opts, typ=GetJobQueueResult).value

    return AwaitableGetJobQueueResult(
        compute_environment_order=pulumi.get(__ret__, 'compute_environment_order'),
        job_queue_arn=pulumi.get(__ret__, 'job_queue_arn'),
        job_state_time_limit_actions=pulumi.get(__ret__, 'job_state_time_limit_actions'),
        priority=pulumi.get(__ret__, 'priority'),
        scheduling_policy_arn=pulumi.get(__ret__, 'scheduling_policy_arn'),
        state=pulumi.get(__ret__, 'state'))
def get_job_queue_output(job_queue_arn: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobQueueResult]:
    """
    Resource Type definition for AWS::Batch::JobQueue


    :param str job_queue_arn: Returns the job queue ARN, such as `batch: *us-east-1* : *111122223333* :job-queue/ *JobQueueName*` .
    """
    __args__ = dict()
    __args__['jobQueueArn'] = job_queue_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:batch:getJobQueue', __args__, opts=opts, typ=GetJobQueueResult)
    return __ret__.apply(lambda __response__: GetJobQueueResult(
        compute_environment_order=pulumi.get(__response__, 'compute_environment_order'),
        job_queue_arn=pulumi.get(__response__, 'job_queue_arn'),
        job_state_time_limit_actions=pulumi.get(__response__, 'job_state_time_limit_actions'),
        priority=pulumi.get(__response__, 'priority'),
        scheduling_policy_arn=pulumi.get(__response__, 'scheduling_policy_arn'),
        state=pulumi.get(__response__, 'state')))
