# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetComputeEnvironmentResult',
    'AwaitableGetComputeEnvironmentResult',
    'get_compute_environment',
    'get_compute_environment_output',
]

@pulumi.output_type
class GetComputeEnvironmentResult:
    def __init__(__self__, compute_environment_arn=None, compute_resources=None, context=None, service_role=None, state=None, unmanagedv_cpus=None):
        if compute_environment_arn and not isinstance(compute_environment_arn, str):
            raise TypeError("Expected argument 'compute_environment_arn' to be a str")
        pulumi.set(__self__, "compute_environment_arn", compute_environment_arn)
        if compute_resources and not isinstance(compute_resources, dict):
            raise TypeError("Expected argument 'compute_resources' to be a dict")
        pulumi.set(__self__, "compute_resources", compute_resources)
        if context and not isinstance(context, str):
            raise TypeError("Expected argument 'context' to be a str")
        pulumi.set(__self__, "context", context)
        if service_role and not isinstance(service_role, str):
            raise TypeError("Expected argument 'service_role' to be a str")
        pulumi.set(__self__, "service_role", service_role)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if unmanagedv_cpus and not isinstance(unmanagedv_cpus, int):
            raise TypeError("Expected argument 'unmanagedv_cpus' to be a int")
        pulumi.set(__self__, "unmanagedv_cpus", unmanagedv_cpus)

    @property
    @pulumi.getter(name="computeEnvironmentArn")
    def compute_environment_arn(self) -> Optional[str]:
        """
        Returns the compute environment ARN, such as `batch: *us-east-1* : *111122223333* :compute-environment/ *ComputeEnvironmentName*` .
        """
        return pulumi.get(self, "compute_environment_arn")

    @property
    @pulumi.getter(name="computeResources")
    def compute_resources(self) -> Optional['outputs.ComputeEnvironmentComputeResources']:
        """
        The ComputeResources property type specifies details of the compute resources managed by the compute environment. This parameter is required for managed compute environments. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the ** .
        """
        return pulumi.get(self, "compute_resources")

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[str]:
        """
        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf. For more information, see [AWS Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *AWS Batch User Guide* .

        > If your account already created the AWS Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the AWS Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the AWS Batch service-linked role in your account. 

        If your specified role has a path other than `/` , then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name `bar` has a path of `/foo/` , specify `/foo/bar` as the role name. For more information, see [Friendly names and paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) in the *IAM User Guide* .

        > Depending on how you created your AWS Batch service role, its ARN might contain the `service-role` path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN doesn't use the `service-role` path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the compute environment. If the state is `ENABLED` , then the compute environment accepts jobs from a queue and can scale out automatically based on queues.

        If the state is `ENABLED` , then the AWS Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.

        If the state is `DISABLED` , then the AWS Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out.

        > Compute environments in a `DISABLED` state may continue to incur billing charges. To prevent additional charges, turn off and then delete the compute environment. For more information, see [State](https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state) in the *AWS Batch User Guide* . 

        When an instance is idle, the instance scales down to the `minvCpus` value. However, the instance size doesn't change. For example, consider a `c5.8xlarge` instance with a `minvCpus` value of `4` and a `desiredvCpus` value of `36` . This instance doesn't scale down to a `c5.large` instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="unmanagedvCpus")
    def unmanagedv_cpus(self) -> Optional[int]:
        """
        The maximum number of vCPUs for an unmanaged compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.

        > This parameter is only supported when the `type` parameter is set to `UNMANAGED` .
        """
        return pulumi.get(self, "unmanagedv_cpus")


class AwaitableGetComputeEnvironmentResult(GetComputeEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeEnvironmentResult(
            compute_environment_arn=self.compute_environment_arn,
            compute_resources=self.compute_resources,
            context=self.context,
            service_role=self.service_role,
            state=self.state,
            unmanagedv_cpus=self.unmanagedv_cpus)


def get_compute_environment(compute_environment_arn: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeEnvironmentResult:
    """
    Resource Type definition for AWS::Batch::ComputeEnvironment


    :param str compute_environment_arn: Returns the compute environment ARN, such as `batch: *us-east-1* : *111122223333* :compute-environment/ *ComputeEnvironmentName*` .
    """
    __args__ = dict()
    __args__['computeEnvironmentArn'] = compute_environment_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:batch:getComputeEnvironment', __args__, opts=opts, typ=GetComputeEnvironmentResult).value

    return AwaitableGetComputeEnvironmentResult(
        compute_environment_arn=pulumi.get(__ret__, 'compute_environment_arn'),
        compute_resources=pulumi.get(__ret__, 'compute_resources'),
        context=pulumi.get(__ret__, 'context'),
        service_role=pulumi.get(__ret__, 'service_role'),
        state=pulumi.get(__ret__, 'state'),
        unmanagedv_cpus=pulumi.get(__ret__, 'unmanagedv_cpus'))
def get_compute_environment_output(compute_environment_arn: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetComputeEnvironmentResult]:
    """
    Resource Type definition for AWS::Batch::ComputeEnvironment


    :param str compute_environment_arn: Returns the compute environment ARN, such as `batch: *us-east-1* : *111122223333* :compute-environment/ *ComputeEnvironmentName*` .
    """
    __args__ = dict()
    __args__['computeEnvironmentArn'] = compute_environment_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:batch:getComputeEnvironment', __args__, opts=opts, typ=GetComputeEnvironmentResult)
    return __ret__.apply(lambda __response__: GetComputeEnvironmentResult(
        compute_environment_arn=pulumi.get(__response__, 'compute_environment_arn'),
        compute_resources=pulumi.get(__response__, 'compute_resources'),
        context=pulumi.get(__response__, 'context'),
        service_role=pulumi.get(__response__, 'service_role'),
        state=pulumi.get(__response__, 'state'),
        unmanagedv_cpus=pulumi.get(__response__, 'unmanagedv_cpus')))
