# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RestoreTestingPlanArgs', 'RestoreTestingPlan']

@pulumi.input_type
class RestoreTestingPlanArgs:
    def __init__(__self__, *,
                 recovery_point_selection: pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs'],
                 schedule_expression: pulumi.Input[str],
                 restore_testing_plan_name: Optional[pulumi.Input[str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[str]] = None,
                 schedule_status: Optional[pulumi.Input['RestoreTestingPlanRestoreTestingScheduleStatus']] = None,
                 start_window_hours: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a RestoreTestingPlan resource.
        :param pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs'] recovery_point_selection: The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
        :param pulumi.Input[str] schedule_expression: A CRON expression in specified timezone when a restore testing plan is executed.
        :param pulumi.Input[str] restore_testing_plan_name: The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
        :param pulumi.Input[str] schedule_expression_timezone: Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        :param pulumi.Input[int] start_window_hours: Defaults to 24 hours.
               
               A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: `+ - = . _ : /.`
        """
        pulumi.set(__self__, "recovery_point_selection", recovery_point_selection)
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if restore_testing_plan_name is not None:
            pulumi.set(__self__, "restore_testing_plan_name", restore_testing_plan_name)
        if schedule_expression_timezone is not None:
            pulumi.set(__self__, "schedule_expression_timezone", schedule_expression_timezone)
        if schedule_status is not None:
            pulumi.set(__self__, "schedule_status", schedule_status)
        if start_window_hours is not None:
            pulumi.set(__self__, "start_window_hours", start_window_hours)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="recoveryPointSelection")
    def recovery_point_selection(self) -> pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs']:
        """
        The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
        """
        return pulumi.get(self, "recovery_point_selection")

    @recovery_point_selection.setter
    def recovery_point_selection(self, value: pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs']):
        pulumi.set(self, "recovery_point_selection", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[str]:
        """
        A CRON expression in specified timezone when a restore testing plan is executed.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="restoreTestingPlanName")
    def restore_testing_plan_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
        """
        return pulumi.get(self, "restore_testing_plan_name")

    @restore_testing_plan_name.setter
    def restore_testing_plan_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_testing_plan_name", value)

    @property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @schedule_expression_timezone.setter
    def schedule_expression_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression_timezone", value)

    @property
    @pulumi.getter(name="scheduleStatus")
    def schedule_status(self) -> Optional[pulumi.Input['RestoreTestingPlanRestoreTestingScheduleStatus']]:
        return pulumi.get(self, "schedule_status")

    @schedule_status.setter
    def schedule_status(self, value: Optional[pulumi.Input['RestoreTestingPlanRestoreTestingScheduleStatus']]):
        pulumi.set(self, "schedule_status", value)

    @property
    @pulumi.getter(name="startWindowHours")
    def start_window_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Defaults to 24 hours.

        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
        """
        return pulumi.get(self, "start_window_hours")

    @start_window_hours.setter
    def start_window_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_window_hours", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: `+ - = . _ : /.`
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class RestoreTestingPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recovery_point_selection: Optional[pulumi.Input[Union['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs', 'RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgsDict']]] = None,
                 restore_testing_plan_name: Optional[pulumi.Input[str]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[str]] = None,
                 schedule_status: Optional[pulumi.Input['RestoreTestingPlanRestoreTestingScheduleStatus']] = None,
                 start_window_hours: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Backup::RestoreTestingPlan Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs', 'RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgsDict']] recovery_point_selection: The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
        :param pulumi.Input[str] restore_testing_plan_name: The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
        :param pulumi.Input[str] schedule_expression: A CRON expression in specified timezone when a restore testing plan is executed.
        :param pulumi.Input[str] schedule_expression_timezone: Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        :param pulumi.Input[int] start_window_hours: Defaults to 24 hours.
               
               A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: `+ - = . _ : /.`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestoreTestingPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Backup::RestoreTestingPlan Resource Type

        :param str resource_name: The name of the resource.
        :param RestoreTestingPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestoreTestingPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recovery_point_selection: Optional[pulumi.Input[Union['RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs', 'RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgsDict']]] = None,
                 restore_testing_plan_name: Optional[pulumi.Input[str]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[str]] = None,
                 schedule_status: Optional[pulumi.Input['RestoreTestingPlanRestoreTestingScheduleStatus']] = None,
                 start_window_hours: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestoreTestingPlanArgs.__new__(RestoreTestingPlanArgs)

            if recovery_point_selection is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_point_selection'")
            __props__.__dict__["recovery_point_selection"] = recovery_point_selection
            __props__.__dict__["restore_testing_plan_name"] = restore_testing_plan_name
            if schedule_expression is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_expression'")
            __props__.__dict__["schedule_expression"] = schedule_expression
            __props__.__dict__["schedule_expression_timezone"] = schedule_expression_timezone
            __props__.__dict__["schedule_status"] = schedule_status
            __props__.__dict__["start_window_hours"] = start_window_hours
            __props__.__dict__["tags"] = tags
            __props__.__dict__["restore_testing_plan_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["restoreTestingPlanName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RestoreTestingPlan, __self__).__init__(
            'aws-native:backup:RestoreTestingPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RestoreTestingPlan':
        """
        Get an existing RestoreTestingPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RestoreTestingPlanArgs.__new__(RestoreTestingPlanArgs)

        __props__.__dict__["recovery_point_selection"] = None
        __props__.__dict__["restore_testing_plan_arn"] = None
        __props__.__dict__["restore_testing_plan_name"] = None
        __props__.__dict__["schedule_expression"] = None
        __props__.__dict__["schedule_expression_timezone"] = None
        __props__.__dict__["schedule_status"] = None
        __props__.__dict__["start_window_hours"] = None
        __props__.__dict__["tags"] = None
        return RestoreTestingPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="recoveryPointSelection")
    def recovery_point_selection(self) -> pulumi.Output['outputs.RestoreTestingPlanRestoreTestingRecoveryPointSelection']:
        """
        The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
        """
        return pulumi.get(self, "recovery_point_selection")

    @property
    @pulumi.getter(name="restoreTestingPlanArn")
    def restore_testing_plan_arn(self) -> pulumi.Output[str]:
        """
        An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
        """
        return pulumi.get(self, "restore_testing_plan_arn")

    @property
    @pulumi.getter(name="restoreTestingPlanName")
    def restore_testing_plan_name(self) -> pulumi.Output[str]:
        """
        The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
        """
        return pulumi.get(self, "restore_testing_plan_name")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Output[str]:
        """
        A CRON expression in specified timezone when a restore testing plan is executed.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @property
    @pulumi.getter(name="scheduleStatus")
    def schedule_status(self) -> pulumi.Output[Optional['RestoreTestingPlanRestoreTestingScheduleStatus']]:
        return pulumi.get(self, "schedule_status")

    @property
    @pulumi.getter(name="startWindowHours")
    def start_window_hours(self) -> pulumi.Output[Optional[int]]:
        """
        Defaults to 24 hours.

        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
        """
        return pulumi.get(self, "start_window_hours")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: `+ - = . _ : /.`
        """
        return pulumi.get(self, "tags")

