# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRestoreTestingPlanResult',
    'AwaitableGetRestoreTestingPlanResult',
    'get_restore_testing_plan',
    'get_restore_testing_plan_output',
]

@pulumi.output_type
class GetRestoreTestingPlanResult:
    def __init__(__self__, recovery_point_selection=None, restore_testing_plan_arn=None, schedule_expression=None, schedule_expression_timezone=None, schedule_status=None, start_window_hours=None, tags=None):
        if recovery_point_selection and not isinstance(recovery_point_selection, dict):
            raise TypeError("Expected argument 'recovery_point_selection' to be a dict")
        pulumi.set(__self__, "recovery_point_selection", recovery_point_selection)
        if restore_testing_plan_arn and not isinstance(restore_testing_plan_arn, str):
            raise TypeError("Expected argument 'restore_testing_plan_arn' to be a str")
        pulumi.set(__self__, "restore_testing_plan_arn", restore_testing_plan_arn)
        if schedule_expression and not isinstance(schedule_expression, str):
            raise TypeError("Expected argument 'schedule_expression' to be a str")
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_expression_timezone and not isinstance(schedule_expression_timezone, str):
            raise TypeError("Expected argument 'schedule_expression_timezone' to be a str")
        pulumi.set(__self__, "schedule_expression_timezone", schedule_expression_timezone)
        if schedule_status and not isinstance(schedule_status, str):
            raise TypeError("Expected argument 'schedule_status' to be a str")
        pulumi.set(__self__, "schedule_status", schedule_status)
        if start_window_hours and not isinstance(start_window_hours, int):
            raise TypeError("Expected argument 'start_window_hours' to be a int")
        pulumi.set(__self__, "start_window_hours", start_window_hours)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="recoveryPointSelection")
    def recovery_point_selection(self) -> Optional['outputs.RestoreTestingPlanRestoreTestingRecoveryPointSelection']:
        """
        The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
        """
        return pulumi.get(self, "recovery_point_selection")

    @property
    @pulumi.getter(name="restoreTestingPlanArn")
    def restore_testing_plan_arn(self) -> Optional[str]:
        """
        An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
        """
        return pulumi.get(self, "restore_testing_plan_arn")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[str]:
        """
        A CRON expression in specified timezone when a restore testing plan is executed.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> Optional[str]:
        """
        Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @property
    @pulumi.getter(name="scheduleStatus")
    def schedule_status(self) -> Optional['RestoreTestingPlanRestoreTestingScheduleStatus']:
        return pulumi.get(self, "schedule_status")

    @property
    @pulumi.getter(name="startWindowHours")
    def start_window_hours(self) -> Optional[int]:
        """
        Defaults to 24 hours.

        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
        """
        return pulumi.get(self, "start_window_hours")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: `+ - = . _ : /.`
        """
        return pulumi.get(self, "tags")


class AwaitableGetRestoreTestingPlanResult(GetRestoreTestingPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRestoreTestingPlanResult(
            recovery_point_selection=self.recovery_point_selection,
            restore_testing_plan_arn=self.restore_testing_plan_arn,
            schedule_expression=self.schedule_expression,
            schedule_expression_timezone=self.schedule_expression_timezone,
            schedule_status=self.schedule_status,
            start_window_hours=self.start_window_hours,
            tags=self.tags)


def get_restore_testing_plan(restore_testing_plan_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRestoreTestingPlanResult:
    """
    Definition of AWS::Backup::RestoreTestingPlan Resource Type


    :param str restore_testing_plan_name: The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
    """
    __args__ = dict()
    __args__['restoreTestingPlanName'] = restore_testing_plan_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:backup:getRestoreTestingPlan', __args__, opts=opts, typ=GetRestoreTestingPlanResult).value

    return AwaitableGetRestoreTestingPlanResult(
        recovery_point_selection=pulumi.get(__ret__, 'recovery_point_selection'),
        restore_testing_plan_arn=pulumi.get(__ret__, 'restore_testing_plan_arn'),
        schedule_expression=pulumi.get(__ret__, 'schedule_expression'),
        schedule_expression_timezone=pulumi.get(__ret__, 'schedule_expression_timezone'),
        schedule_status=pulumi.get(__ret__, 'schedule_status'),
        start_window_hours=pulumi.get(__ret__, 'start_window_hours'),
        tags=pulumi.get(__ret__, 'tags'))
def get_restore_testing_plan_output(restore_testing_plan_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRestoreTestingPlanResult]:
    """
    Definition of AWS::Backup::RestoreTestingPlan Resource Type


    :param str restore_testing_plan_name: The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
    """
    __args__ = dict()
    __args__['restoreTestingPlanName'] = restore_testing_plan_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:backup:getRestoreTestingPlan', __args__, opts=opts, typ=GetRestoreTestingPlanResult)
    return __ret__.apply(lambda __response__: GetRestoreTestingPlanResult(
        recovery_point_selection=pulumi.get(__response__, 'recovery_point_selection'),
        restore_testing_plan_arn=pulumi.get(__response__, 'restore_testing_plan_arn'),
        schedule_expression=pulumi.get(__response__, 'schedule_expression'),
        schedule_expression_timezone=pulumi.get(__response__, 'schedule_expression_timezone'),
        schedule_status=pulumi.get(__response__, 'schedule_status'),
        start_window_hours=pulumi.get(__response__, 'start_window_hours'),
        tags=pulumi.get(__response__, 'tags')))
