# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'BackupPlanAdvancedBackupSettingResourceTypeArgs',
    'BackupPlanAdvancedBackupSettingResourceTypeArgsDict',
    'BackupPlanBackupRuleResourceTypeArgs',
    'BackupPlanBackupRuleResourceTypeArgsDict',
    'BackupPlanCopyActionResourceTypeArgs',
    'BackupPlanCopyActionResourceTypeArgsDict',
    'BackupPlanLifecycleResourceTypeArgs',
    'BackupPlanLifecycleResourceTypeArgsDict',
    'BackupPlanResourceTypeArgs',
    'BackupPlanResourceTypeArgsDict',
    'BackupSelectionConditionParameterArgs',
    'BackupSelectionConditionParameterArgsDict',
    'BackupSelectionConditionResourceTypeArgs',
    'BackupSelectionConditionResourceTypeArgsDict',
    'BackupSelectionResourceTypeConditionsPropertiesArgs',
    'BackupSelectionResourceTypeConditionsPropertiesArgsDict',
    'BackupSelectionResourceTypeArgs',
    'BackupSelectionResourceTypeArgsDict',
    'BackupVaultLockConfigurationTypeArgs',
    'BackupVaultLockConfigurationTypeArgsDict',
    'BackupVaultNotificationObjectTypeArgs',
    'BackupVaultNotificationObjectTypeArgsDict',
    'FrameworkControlControlScopePropertiesArgs',
    'FrameworkControlControlScopePropertiesArgsDict',
    'FrameworkControlInputParameterArgs',
    'FrameworkControlInputParameterArgsDict',
    'FrameworkControlArgs',
    'FrameworkControlArgsDict',
    'FrameworkTagArgs',
    'FrameworkTagArgsDict',
    'ReportDeliveryChannelPropertiesArgs',
    'ReportDeliveryChannelPropertiesArgsDict',
    'ReportSettingPropertiesArgs',
    'ReportSettingPropertiesArgsDict',
    'RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs',
    'RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgsDict',
    'RestoreTestingSelectionKeyValueArgs',
    'RestoreTestingSelectionKeyValueArgsDict',
    'RestoreTestingSelectionProtectedResourceConditionsArgs',
    'RestoreTestingSelectionProtectedResourceConditionsArgsDict',
]

MYPY = False

if not MYPY:
    class BackupPlanAdvancedBackupSettingResourceTypeArgsDict(TypedDict):
        backup_options: Any
        """
        The backup option for the resource. Each option is a key-value pair. This option is only available for Windows VSS backup jobs.

        Valid values:

        Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.

        Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.

        If you specify an invalid option, you get an `InvalidParameterValueException` exception.

        For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html) .
        """
        resource_type: pulumi.Input[str]
        """
        The name of a resource type. The only supported resource type is EC2.
        """
elif False:
    BackupPlanAdvancedBackupSettingResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanAdvancedBackupSettingResourceTypeArgs:
    def __init__(__self__, *,
                 backup_options: Any,
                 resource_type: pulumi.Input[str]):
        """
        :param Any backup_options: The backup option for the resource. Each option is a key-value pair. This option is only available for Windows VSS backup jobs.
               
               Valid values:
               
               Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.
               
               Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.
               
               If you specify an invalid option, you get an `InvalidParameterValueException` exception.
               
               For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html) .
        :param pulumi.Input[str] resource_type: The name of a resource type. The only supported resource type is EC2.
        """
        pulumi.set(__self__, "backup_options", backup_options)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="backupOptions")
    def backup_options(self) -> Any:
        """
        The backup option for the resource. Each option is a key-value pair. This option is only available for Windows VSS backup jobs.

        Valid values:

        Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS` backup option and create a Windows VSS backup.

        Set to `"WindowsVSS":"disabled"` to create a regular backup. The `WindowsVSS` option is not enabled by default.

        If you specify an invalid option, you get an `InvalidParameterValueException` exception.

        For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup](https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html) .
        """
        return pulumi.get(self, "backup_options")

    @backup_options.setter
    def backup_options(self, value: Any):
        pulumi.set(self, "backup_options", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The name of a resource type. The only supported resource type is EC2.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)


if not MYPY:
    class BackupPlanBackupRuleResourceTypeArgsDict(TypedDict):
        rule_name: pulumi.Input[str]
        """
        A display name for a backup rule.
        """
        target_backup_vault: pulumi.Input[str]
        """
        The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
        """
        completion_window_minutes: NotRequired[pulumi.Input[float]]
        """
        A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
        """
        copy_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupPlanCopyActionResourceTypeArgsDict']]]]
        """
        An array of CopyAction objects, which contains the details of the copy operation.
        """
        enable_continuous_backup: NotRequired[pulumi.Input[bool]]
        """
        Enables continuous backup and point-in-time restores (PITR).
        """
        lifecycle: NotRequired[pulumi.Input['BackupPlanLifecycleResourceTypeArgsDict']]
        """
        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
        """
        recovery_point_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        The tags to assign to the resources.
        """
        schedule_expression: NotRequired[pulumi.Input[str]]
        """
        A CRON expression specifying when AWS Backup initiates a backup job.
        """
        schedule_expression_timezone: NotRequired[pulumi.Input[str]]
        """
        This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        """
        start_window_minutes: NotRequired[pulumi.Input[float]]
        """
        An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.

        If this value is included, it must be at least 60 minutes to avoid errors.
        """
elif False:
    BackupPlanBackupRuleResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanBackupRuleResourceTypeArgs:
    def __init__(__self__, *,
                 rule_name: pulumi.Input[str],
                 target_backup_vault: pulumi.Input[str],
                 completion_window_minutes: Optional[pulumi.Input[float]] = None,
                 copy_actions: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanCopyActionResourceTypeArgs']]]] = None,
                 enable_continuous_backup: Optional[pulumi.Input[bool]] = None,
                 lifecycle: Optional[pulumi.Input['BackupPlanLifecycleResourceTypeArgs']] = None,
                 recovery_point_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 schedule_expression_timezone: Optional[pulumi.Input[str]] = None,
                 start_window_minutes: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] rule_name: A display name for a backup rule.
        :param pulumi.Input[str] target_backup_vault: The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
        :param pulumi.Input[float] completion_window_minutes: A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanCopyActionResourceTypeArgs']]] copy_actions: An array of CopyAction objects, which contains the details of the copy operation.
        :param pulumi.Input[bool] enable_continuous_backup: Enables continuous backup and point-in-time restores (PITR).
        :param pulumi.Input['BackupPlanLifecycleResourceTypeArgs'] lifecycle: The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] recovery_point_tags: The tags to assign to the resources.
        :param pulumi.Input[str] schedule_expression: A CRON expression specifying when AWS Backup initiates a backup job.
        :param pulumi.Input[str] schedule_expression_timezone: This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        :param pulumi.Input[float] start_window_minutes: An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.
               
               If this value is included, it must be at least 60 minutes to avoid errors.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "target_backup_vault", target_backup_vault)
        if completion_window_minutes is not None:
            pulumi.set(__self__, "completion_window_minutes", completion_window_minutes)
        if copy_actions is not None:
            pulumi.set(__self__, "copy_actions", copy_actions)
        if enable_continuous_backup is not None:
            pulumi.set(__self__, "enable_continuous_backup", enable_continuous_backup)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if recovery_point_tags is not None:
            pulumi.set(__self__, "recovery_point_tags", recovery_point_tags)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_expression_timezone is not None:
            pulumi.set(__self__, "schedule_expression_timezone", schedule_expression_timezone)
        if start_window_minutes is not None:
            pulumi.set(__self__, "start_window_minutes", start_window_minutes)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        A display name for a backup rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="targetBackupVault")
    def target_backup_vault(self) -> pulumi.Input[str]:
        """
        The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created. They consist of letters, numbers, and hyphens.
        """
        return pulumi.get(self, "target_backup_vault")

    @target_backup_vault.setter
    def target_backup_vault(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_backup_vault", value)

    @property
    @pulumi.getter(name="completionWindowMinutes")
    def completion_window_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        A value in minutes after a backup job is successfully started before it must be completed or it is canceled by AWS Backup .
        """
        return pulumi.get(self, "completion_window_minutes")

    @completion_window_minutes.setter
    def completion_window_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "completion_window_minutes", value)

    @property
    @pulumi.getter(name="copyActions")
    def copy_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanCopyActionResourceTypeArgs']]]]:
        """
        An array of CopyAction objects, which contains the details of the copy operation.
        """
        return pulumi.get(self, "copy_actions")

    @copy_actions.setter
    def copy_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanCopyActionResourceTypeArgs']]]]):
        pulumi.set(self, "copy_actions", value)

    @property
    @pulumi.getter(name="enableContinuousBackup")
    def enable_continuous_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables continuous backup and point-in-time restores (PITR).
        """
        return pulumi.get(self, "enable_continuous_backup")

    @enable_continuous_backup.setter
    def enable_continuous_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_continuous_backup", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['BackupPlanLifecycleResourceTypeArgs']]:
        """
        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['BackupPlanLifecycleResourceTypeArgs']]):
        pulumi.set(self, "lifecycle", value)

    @property
    @pulumi.getter(name="recoveryPointTags")
    def recovery_point_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to assign to the resources.
        """
        return pulumi.get(self, "recovery_point_tags")

    @recovery_point_tags.setter
    def recovery_point_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "recovery_point_tags", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        A CRON expression specifying when AWS Backup initiates a backup job.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="scheduleExpressionTimezone")
    def schedule_expression_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
        """
        return pulumi.get(self, "schedule_expression_timezone")

    @schedule_expression_timezone.setter
    def schedule_expression_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression_timezone", value)

    @property
    @pulumi.getter(name="startWindowMinutes")
    def start_window_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        An optional value that specifies a period of time in minutes after a backup is scheduled before a job is canceled if it doesn't start successfully.

        If this value is included, it must be at least 60 minutes to avoid errors.
        """
        return pulumi.get(self, "start_window_minutes")

    @start_window_minutes.setter
    def start_window_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "start_window_minutes", value)


if not MYPY:
    class BackupPlanCopyActionResourceTypeArgsDict(TypedDict):
        destination_backup_vault_arn: pulumi.Input[str]
        """
        An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.`
        """
        lifecycle: NotRequired[pulumi.Input['BackupPlanLifecycleResourceTypeArgsDict']]
        """
        Defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.

        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
        """
elif False:
    BackupPlanCopyActionResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanCopyActionResourceTypeArgs:
    def __init__(__self__, *,
                 destination_backup_vault_arn: pulumi.Input[str],
                 lifecycle: Optional[pulumi.Input['BackupPlanLifecycleResourceTypeArgs']] = None):
        """
        :param pulumi.Input[str] destination_backup_vault_arn: An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.`
        :param pulumi.Input['BackupPlanLifecycleResourceTypeArgs'] lifecycle: Defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.
               
               Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
        """
        pulumi.set(__self__, "destination_backup_vault_arn", destination_backup_vault_arn)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)

    @property
    @pulumi.getter(name="destinationBackupVaultArn")
    def destination_backup_vault_arn(self) -> pulumi.Input[str]:
        """
        An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.`
        """
        return pulumi.get(self, "destination_backup_vault_arn")

    @destination_backup_vault_arn.setter
    def destination_backup_vault_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_backup_vault_arn", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['BackupPlanLifecycleResourceTypeArgs']]:
        """
        Defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, AWS Backup applies the lifecycle policy of the source backup to the destination backup.

        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['BackupPlanLifecycleResourceTypeArgs']]):
        pulumi.set(self, "lifecycle", value)


if not MYPY:
    class BackupPlanLifecycleResourceTypeArgsDict(TypedDict):
        delete_after_days: NotRequired[pulumi.Input[float]]
        """
        Specifies the number of days after creation that a recovery point is deleted. Must be greater than `MoveToColdStorageAfterDays` .
        """
        move_to_cold_storage_after_days: NotRequired[pulumi.Input[float]]
        """
        Specifies the number of days after creation that a recovery point is moved to cold storage.
        """
        opt_in_to_archive_for_supported_resources: NotRequired[pulumi.Input[bool]]
        """
        If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
        """
elif False:
    BackupPlanLifecycleResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanLifecycleResourceTypeArgs:
    def __init__(__self__, *,
                 delete_after_days: Optional[pulumi.Input[float]] = None,
                 move_to_cold_storage_after_days: Optional[pulumi.Input[float]] = None,
                 opt_in_to_archive_for_supported_resources: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[float] delete_after_days: Specifies the number of days after creation that a recovery point is deleted. Must be greater than `MoveToColdStorageAfterDays` .
        :param pulumi.Input[float] move_to_cold_storage_after_days: Specifies the number of days after creation that a recovery point is moved to cold storage.
        :param pulumi.Input[bool] opt_in_to_archive_for_supported_resources: If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
        """
        if delete_after_days is not None:
            pulumi.set(__self__, "delete_after_days", delete_after_days)
        if move_to_cold_storage_after_days is not None:
            pulumi.set(__self__, "move_to_cold_storage_after_days", move_to_cold_storage_after_days)
        if opt_in_to_archive_for_supported_resources is not None:
            pulumi.set(__self__, "opt_in_to_archive_for_supported_resources", opt_in_to_archive_for_supported_resources)

    @property
    @pulumi.getter(name="deleteAfterDays")
    def delete_after_days(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of days after creation that a recovery point is deleted. Must be greater than `MoveToColdStorageAfterDays` .
        """
        return pulumi.get(self, "delete_after_days")

    @delete_after_days.setter
    def delete_after_days(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "delete_after_days", value)

    @property
    @pulumi.getter(name="moveToColdStorageAfterDays")
    def move_to_cold_storage_after_days(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of days after creation that a recovery point is moved to cold storage.
        """
        return pulumi.get(self, "move_to_cold_storage_after_days")

    @move_to_cold_storage_after_days.setter
    def move_to_cold_storage_after_days(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "move_to_cold_storage_after_days", value)

    @property
    @pulumi.getter(name="optInToArchiveForSupportedResources")
    def opt_in_to_archive_for_supported_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        If the value is true, your backup plan transitions supported resources to archive (cold) storage tier in accordance with your lifecycle settings.
        """
        return pulumi.get(self, "opt_in_to_archive_for_supported_resources")

    @opt_in_to_archive_for_supported_resources.setter
    def opt_in_to_archive_for_supported_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "opt_in_to_archive_for_supported_resources", value)


if not MYPY:
    class BackupPlanResourceTypeArgsDict(TypedDict):
        backup_plan_name: pulumi.Input[str]
        """
        The display name of a backup plan.
        """
        backup_plan_rule: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleResourceTypeArgsDict']]]
        """
        An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
        """
        advanced_backup_settings: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupPlanAdvancedBackupSettingResourceTypeArgsDict']]]]
        """
        A list of backup options for each resource type.
        """
elif False:
    BackupPlanResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPlanResourceTypeArgs:
    def __init__(__self__, *,
                 backup_plan_name: pulumi.Input[str],
                 backup_plan_rule: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleResourceTypeArgs']]],
                 advanced_backup_settings: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanAdvancedBackupSettingResourceTypeArgs']]]] = None):
        """
        :param pulumi.Input[str] backup_plan_name: The display name of a backup plan.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleResourceTypeArgs']]] backup_plan_rule: An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanAdvancedBackupSettingResourceTypeArgs']]] advanced_backup_settings: A list of backup options for each resource type.
        """
        pulumi.set(__self__, "backup_plan_name", backup_plan_name)
        pulumi.set(__self__, "backup_plan_rule", backup_plan_rule)
        if advanced_backup_settings is not None:
            pulumi.set(__self__, "advanced_backup_settings", advanced_backup_settings)

    @property
    @pulumi.getter(name="backupPlanName")
    def backup_plan_name(self) -> pulumi.Input[str]:
        """
        The display name of a backup plan.
        """
        return pulumi.get(self, "backup_plan_name")

    @backup_plan_name.setter
    def backup_plan_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_plan_name", value)

    @property
    @pulumi.getter(name="backupPlanRule")
    def backup_plan_rule(self) -> pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleResourceTypeArgs']]]:
        """
        An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
        """
        return pulumi.get(self, "backup_plan_rule")

    @backup_plan_rule.setter
    def backup_plan_rule(self, value: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupRuleResourceTypeArgs']]]):
        pulumi.set(self, "backup_plan_rule", value)

    @property
    @pulumi.getter(name="advancedBackupSettings")
    def advanced_backup_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanAdvancedBackupSettingResourceTypeArgs']]]]:
        """
        A list of backup options for each resource type.
        """
        return pulumi.get(self, "advanced_backup_settings")

    @advanced_backup_settings.setter
    def advanced_backup_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanAdvancedBackupSettingResourceTypeArgs']]]]):
        pulumi.set(self, "advanced_backup_settings", value)


if not MYPY:
    class BackupSelectionConditionParameterArgsDict(TypedDict):
        condition_key: NotRequired[pulumi.Input[str]]
        """
        The key in a key-value pair. For example, in the tag `Department: Accounting` , `Department` is the key.
        """
        condition_value: NotRequired[pulumi.Input[str]]
        """
        The value in a key-value pair. For example, in the tag `Department: Accounting` , `Accounting` is the value.
        """
elif False:
    BackupSelectionConditionParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupSelectionConditionParameterArgs:
    def __init__(__self__, *,
                 condition_key: Optional[pulumi.Input[str]] = None,
                 condition_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] condition_key: The key in a key-value pair. For example, in the tag `Department: Accounting` , `Department` is the key.
        :param pulumi.Input[str] condition_value: The value in a key-value pair. For example, in the tag `Department: Accounting` , `Accounting` is the value.
        """
        if condition_key is not None:
            pulumi.set(__self__, "condition_key", condition_key)
        if condition_value is not None:
            pulumi.set(__self__, "condition_value", condition_value)

    @property
    @pulumi.getter(name="conditionKey")
    def condition_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key in a key-value pair. For example, in the tag `Department: Accounting` , `Department` is the key.
        """
        return pulumi.get(self, "condition_key")

    @condition_key.setter
    def condition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_key", value)

    @property
    @pulumi.getter(name="conditionValue")
    def condition_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value in a key-value pair. For example, in the tag `Department: Accounting` , `Accounting` is the value.
        """
        return pulumi.get(self, "condition_value")

    @condition_value.setter
    def condition_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_value", value)


if not MYPY:
    class BackupSelectionConditionResourceTypeArgsDict(TypedDict):
        condition_key: pulumi.Input[str]
        """
        The key in a key-value pair. For example, in `"Department": "accounting"` , `"Department"` is the key.
        """
        condition_type: pulumi.Input[str]
        """
        An operation, such as `STRINGEQUALS` , that is applied to a key-value pair used to filter resources in a selection.
        """
        condition_value: pulumi.Input[str]
        """
        The value in a key-value pair. For example, in `"Department": "accounting"` , `"accounting"` is the value.
        """
elif False:
    BackupSelectionConditionResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupSelectionConditionResourceTypeArgs:
    def __init__(__self__, *,
                 condition_key: pulumi.Input[str],
                 condition_type: pulumi.Input[str],
                 condition_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] condition_key: The key in a key-value pair. For example, in `"Department": "accounting"` , `"Department"` is the key.
        :param pulumi.Input[str] condition_type: An operation, such as `STRINGEQUALS` , that is applied to a key-value pair used to filter resources in a selection.
        :param pulumi.Input[str] condition_value: The value in a key-value pair. For example, in `"Department": "accounting"` , `"accounting"` is the value.
        """
        pulumi.set(__self__, "condition_key", condition_key)
        pulumi.set(__self__, "condition_type", condition_type)
        pulumi.set(__self__, "condition_value", condition_value)

    @property
    @pulumi.getter(name="conditionKey")
    def condition_key(self) -> pulumi.Input[str]:
        """
        The key in a key-value pair. For example, in `"Department": "accounting"` , `"Department"` is the key.
        """
        return pulumi.get(self, "condition_key")

    @condition_key.setter
    def condition_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_key", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[str]:
        """
        An operation, such as `STRINGEQUALS` , that is applied to a key-value pair used to filter resources in a selection.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter(name="conditionValue")
    def condition_value(self) -> pulumi.Input[str]:
        """
        The value in a key-value pair. For example, in `"Department": "accounting"` , `"accounting"` is the value.
        """
        return pulumi.get(self, "condition_value")

    @condition_value.setter
    def condition_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_value", value)


if not MYPY:
    class BackupSelectionResourceTypeConditionsPropertiesArgsDict(TypedDict):
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `Conditions` differs from `ListOfTags` as follows:

        - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
        - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        """
        string_equals: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgsDict']]]]
        string_like: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgsDict']]]]
        string_not_equals: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgsDict']]]]
        string_not_like: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgsDict']]]]
elif False:
    BackupSelectionResourceTypeConditionsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupSelectionResourceTypeConditionsPropertiesArgs:
    def __init__(__self__, *,
                 string_equals: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]] = None,
                 string_like: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]] = None,
                 string_not_equals: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]] = None,
                 string_not_like: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]] = None):
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `Conditions` differs from `ListOfTags` as follows:

        - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
        - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        """
        if string_equals is not None:
            pulumi.set(__self__, "string_equals", string_equals)
        if string_like is not None:
            pulumi.set(__self__, "string_like", string_like)
        if string_not_equals is not None:
            pulumi.set(__self__, "string_not_equals", string_not_equals)
        if string_not_like is not None:
            pulumi.set(__self__, "string_not_like", string_not_like)

    @property
    @pulumi.getter(name="stringEquals")
    def string_equals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]:
        return pulumi.get(self, "string_equals")

    @string_equals.setter
    def string_equals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]):
        pulumi.set(self, "string_equals", value)

    @property
    @pulumi.getter(name="stringLike")
    def string_like(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]:
        return pulumi.get(self, "string_like")

    @string_like.setter
    def string_like(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]):
        pulumi.set(self, "string_like", value)

    @property
    @pulumi.getter(name="stringNotEquals")
    def string_not_equals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]:
        return pulumi.get(self, "string_not_equals")

    @string_not_equals.setter
    def string_not_equals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]):
        pulumi.set(self, "string_not_equals", value)

    @property
    @pulumi.getter(name="stringNotLike")
    def string_not_like(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]:
        return pulumi.get(self, "string_not_like")

    @string_not_like.setter
    def string_not_like(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionParameterArgs']]]]):
        pulumi.set(self, "string_not_like", value)


if not MYPY:
    class BackupSelectionResourceTypeArgsDict(TypedDict):
        iam_role_arn: pulumi.Input[str]
        """
        The ARN of the IAM role that AWS Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access` .
        """
        selection_name: pulumi.Input[str]
        """
        The display name of a resource selection document.
        """
        conditions: NotRequired[pulumi.Input['BackupSelectionResourceTypeConditionsPropertiesArgsDict']]
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `Conditions` differs from `ListOfTags` as follows:

        - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
        - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        """
        list_of_tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionResourceTypeArgsDict']]]]
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `ListOfTags` differs from `Conditions` as follows:

        - When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
        - `ListOfTags` only supports `StringEquals` . `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` .
        """
        not_resources: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.

        If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
        """
        resources: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        An array of strings that contain Amazon Resource Names (ARNs) of resources to assign to a backup plan.
        """
elif False:
    BackupSelectionResourceTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupSelectionResourceTypeArgs:
    def __init__(__self__, *,
                 iam_role_arn: pulumi.Input[str],
                 selection_name: pulumi.Input[str],
                 conditions: Optional[pulumi.Input['BackupSelectionResourceTypeConditionsPropertiesArgs']] = None,
                 list_of_tags: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionResourceTypeArgs']]]] = None,
                 not_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] iam_role_arn: The ARN of the IAM role that AWS Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access` .
        :param pulumi.Input[str] selection_name: The display name of a resource selection document.
        :param pulumi.Input['BackupSelectionResourceTypeConditionsPropertiesArgs'] conditions: A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.
               
               `Conditions` differs from `ListOfTags` as follows:
               
               - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
               - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        :param pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionResourceTypeArgs']]] list_of_tags: A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.
               
               `ListOfTags` differs from `Conditions` as follows:
               
               - When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
               - `ListOfTags` only supports `StringEquals` . `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_resources: A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
               
               If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: An array of strings that contain Amazon Resource Names (ARNs) of resources to assign to a backup plan.
        """
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        pulumi.set(__self__, "selection_name", selection_name)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if list_of_tags is not None:
            pulumi.set(__self__, "list_of_tags", list_of_tags)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role that AWS Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access` .
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="selectionName")
    def selection_name(self) -> pulumi.Input[str]:
        """
        The display name of a resource selection document.
        """
        return pulumi.get(self, "selection_name")

    @selection_name.setter
    def selection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "selection_name", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input['BackupSelectionResourceTypeConditionsPropertiesArgs']]:
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `Conditions` differs from `ListOfTags` as follows:

        - When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
        - `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` . `ListOfTags` only supports `StringEquals` .
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input['BackupSelectionResourceTypeConditionsPropertiesArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="listOfTags")
    def list_of_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionResourceTypeArgs']]]]:
        """
        A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": { "ConditionKey": "aws:ResourceTag/CreatedByCryo", "ConditionValue": "true" },` . Condition operators are case sensitive.

        `ListOfTags` differs from `Conditions` as follows:

        - When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
        - `ListOfTags` only supports `StringEquals` . `Conditions` supports `StringEquals` , `StringLike` , `StringNotEquals` , and `StringNotLike` .
        """
        return pulumi.get(self, "list_of_tags")

    @list_of_tags.setter
    def list_of_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupSelectionConditionResourceTypeArgs']]]]):
        pulumi.set(self, "list_of_tags", value)

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.

        If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
        """
        return pulumi.get(self, "not_resources")

    @not_resources.setter
    def not_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_resources", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings that contain Amazon Resource Names (ARNs) of resources to assign to a backup plan.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


if not MYPY:
    class BackupVaultLockConfigurationTypeArgsDict(TypedDict):
        min_retention_days: pulumi.Input[int]
        """
        The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).

        If this parameter is not specified, Vault Lock will not enforce a minimum retention period.

        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        changeable_for_days: NotRequired[pulumi.Input[int]]
        """
        The AWS Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.

        AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.

        Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.

        If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
        """
        max_retention_days: NotRequired[pulumi.Input[int]]
        """
        The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).

        If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.

        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
elif False:
    BackupVaultLockConfigurationTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupVaultLockConfigurationTypeArgs:
    def __init__(__self__, *,
                 min_retention_days: pulumi.Input[int],
                 changeable_for_days: Optional[pulumi.Input[int]] = None,
                 max_retention_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] min_retention_days: The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).
               
               If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
               
               If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        :param pulumi.Input[int] changeable_for_days: The AWS Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
               
               AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.
               
               Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.
               
               If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
        :param pulumi.Input[int] max_retention_days: The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).
               
               If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.
               
               If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        pulumi.set(__self__, "min_retention_days", min_retention_days)
        if changeable_for_days is not None:
            pulumi.set(__self__, "changeable_for_days", changeable_for_days)
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)

    @property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> pulumi.Input[int]:
        """
        The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).

        If this parameter is not specified, Vault Lock will not enforce a minimum retention period.

        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        return pulumi.get(self, "min_retention_days")

    @min_retention_days.setter
    def min_retention_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_retention_days", value)

    @property
    @pulumi.getter(name="changeableForDays")
    def changeable_for_days(self) -> Optional[pulumi.Input[int]]:
        """
        The AWS Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting `ChangeableForDays` to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.

        AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set `ChangeableForDays` to 3 or greater.

        Before the lock date, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.

        If this parameter is not specified, you can delete Vault Lock from the vault using `DeleteBackupVaultLockConfiguration` or change the Vault Lock configuration using `PutBackupVaultLockConfiguration` at any time.
        """
        return pulumi.get(self, "changeable_for_days")

    @changeable_for_days.setter
    def changeable_for_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "changeable_for_days", value)

    @property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).

        If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.

        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retention_days", value)


if not MYPY:
    class BackupVaultNotificationObjectTypeArgsDict(TypedDict):
        backup_vault_events: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        An array of events that indicate the status of jobs to back up resources to the backup vault. For valid events, see [BackupVaultEvents](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax) in the *AWS Backup API Guide* .
        """
        sns_topic_arn: pulumi.Input[str]
        """
        An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, `arn:aws:sns:us-west-2:111122223333:MyTopic` .
        """
elif False:
    BackupVaultNotificationObjectTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupVaultNotificationObjectTypeArgs:
    def __init__(__self__, *,
                 backup_vault_events: pulumi.Input[Sequence[pulumi.Input[str]]],
                 sns_topic_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_vault_events: An array of events that indicate the status of jobs to back up resources to the backup vault. For valid events, see [BackupVaultEvents](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax) in the *AWS Backup API Guide* .
        :param pulumi.Input[str] sns_topic_arn: An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, `arn:aws:sns:us-west-2:111122223333:MyTopic` .
        """
        pulumi.set(__self__, "backup_vault_events", backup_vault_events)
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="backupVaultEvents")
    def backup_vault_events(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of events that indicate the status of jobs to back up resources to the backup vault. For valid events, see [BackupVaultEvents](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax) in the *AWS Backup API Guide* .
        """
        return pulumi.get(self, "backup_vault_events")

    @backup_vault_events.setter
    def backup_vault_events(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "backup_vault_events", value)

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> pulumi.Input[str]:
        """
        An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, `arn:aws:sns:us-west-2:111122223333:MyTopic` .
        """
        return pulumi.get(self, "sns_topic_arn")

    @sns_topic_arn.setter
    def sns_topic_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "sns_topic_arn", value)


if not MYPY:
    class FrameworkControlControlScopePropertiesArgsDict(TypedDict):
        """
        The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        """
        compliance_resource_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The ID of the only AWS resource that you want your control scope to contain.
        """
        compliance_resource_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['FrameworkTagArgsDict']]]]
        """
        Describes whether the control scope includes resources with one or more tags. Each tag is a key-value pair.
        """
elif False:
    FrameworkControlControlScopePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrameworkControlControlScopePropertiesArgs:
    def __init__(__self__, *,
                 compliance_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compliance_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['FrameworkTagArgs']]]] = None):
        """
        The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_resource_ids: The ID of the only AWS resource that you want your control scope to contain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_resource_types: Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
        :param pulumi.Input[Sequence[pulumi.Input['FrameworkTagArgs']]] tags: Describes whether the control scope includes resources with one or more tags. Each tag is a key-value pair.
        """
        if compliance_resource_ids is not None:
            pulumi.set(__self__, "compliance_resource_ids", compliance_resource_ids)
        if compliance_resource_types is not None:
            pulumi.set(__self__, "compliance_resource_types", compliance_resource_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="complianceResourceIds")
    def compliance_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of the only AWS resource that you want your control scope to contain.
        """
        return pulumi.get(self, "compliance_resource_ids")

    @compliance_resource_ids.setter
    def compliance_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compliance_resource_ids", value)

    @property
    @pulumi.getter(name="complianceResourceTypes")
    def compliance_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Describes whether the control scope includes one or more types of resources, such as `EFS` or `RDS`.
        """
        return pulumi.get(self, "compliance_resource_types")

    @compliance_resource_types.setter
    def compliance_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compliance_resource_types", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrameworkTagArgs']]]]:
        """
        Describes whether the control scope includes resources with one or more tags. Each tag is a key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrameworkTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class FrameworkControlInputParameterArgsDict(TypedDict):
        parameter_name: pulumi.Input[str]
        """
        The name of a parameter, for example, `BackupPlanFrequency` .
        """
        parameter_value: pulumi.Input[str]
        """
        The value of parameter, for example, `hourly` .
        """
elif False:
    FrameworkControlInputParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrameworkControlInputParameterArgs:
    def __init__(__self__, *,
                 parameter_name: pulumi.Input[str],
                 parameter_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] parameter_name: The name of a parameter, for example, `BackupPlanFrequency` .
        :param pulumi.Input[str] parameter_value: The value of parameter, for example, `hourly` .
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> pulumi.Input[str]:
        """
        The name of a parameter, for example, `BackupPlanFrequency` .
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[str]:
        """
        The value of parameter, for example, `hourly` .
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class FrameworkControlArgsDict(TypedDict):
        control_name: pulumi.Input[str]
        """
        The name of a control. This name is between 1 and 256 characters.
        """
        control_input_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['FrameworkControlInputParameterArgsDict']]]]
        """
        A list of ParameterName and ParameterValue pairs.
        """
        control_scope: NotRequired[pulumi.Input['FrameworkControlControlScopePropertiesArgsDict']]
        """
        The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        """
elif False:
    FrameworkControlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrameworkControlArgs:
    def __init__(__self__, *,
                 control_name: pulumi.Input[str],
                 control_input_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['FrameworkControlInputParameterArgs']]]] = None,
                 control_scope: Optional[pulumi.Input['FrameworkControlControlScopePropertiesArgs']] = None):
        """
        :param pulumi.Input[str] control_name: The name of a control. This name is between 1 and 256 characters.
        :param pulumi.Input[Sequence[pulumi.Input['FrameworkControlInputParameterArgs']]] control_input_parameters: A list of ParameterName and ParameterValue pairs.
        :param pulumi.Input['FrameworkControlControlScopePropertiesArgs'] control_scope: The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        """
        pulumi.set(__self__, "control_name", control_name)
        if control_input_parameters is not None:
            pulumi.set(__self__, "control_input_parameters", control_input_parameters)
        if control_scope is not None:
            pulumi.set(__self__, "control_scope", control_scope)

    @property
    @pulumi.getter(name="controlName")
    def control_name(self) -> pulumi.Input[str]:
        """
        The name of a control. This name is between 1 and 256 characters.
        """
        return pulumi.get(self, "control_name")

    @control_name.setter
    def control_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "control_name", value)

    @property
    @pulumi.getter(name="controlInputParameters")
    def control_input_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrameworkControlInputParameterArgs']]]]:
        """
        A list of ParameterName and ParameterValue pairs.
        """
        return pulumi.get(self, "control_input_parameters")

    @control_input_parameters.setter
    def control_input_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrameworkControlInputParameterArgs']]]]):
        pulumi.set(self, "control_input_parameters", value)

    @property
    @pulumi.getter(name="controlScope")
    def control_scope(self) -> Optional[pulumi.Input['FrameworkControlControlScopePropertiesArgs']]:
        """
        The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.
        """
        return pulumi.get(self, "control_scope")

    @control_scope.setter
    def control_scope(self, value: Optional[pulumi.Input['FrameworkControlControlScopePropertiesArgs']]):
        pulumi.set(self, "control_scope", value)


if not MYPY:
    class FrameworkTagArgsDict(TypedDict):
        """
        A key-value pair to associate with a resource.
        """
        key: NotRequired[pulumi.Input[str]]
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
elif False:
    FrameworkTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrameworkTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ReportDeliveryChannelPropertiesArgsDict(TypedDict):
        """
        A structure that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
        """
        s3_bucket_name: pulumi.Input[str]
        """
        The unique name of the S3 bucket that receives your reports.
        """
        formats: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
        """
        s3_key_prefix: NotRequired[pulumi.Input[str]]
        """
        The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
        """
elif False:
    ReportDeliveryChannelPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReportDeliveryChannelPropertiesArgs:
    def __init__(__self__, *,
                 s3_bucket_name: pulumi.Input[str],
                 formats: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
        :param pulumi.Input[str] s3_bucket_name: The unique name of the S3 bucket that receives your reports.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] formats: A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
        :param pulumi.Input[str] s3_key_prefix: The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[str]:
        """
        The unique name of the S3 bucket that receives your reports.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter
    def formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix for where AWS Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_prefix", value)


if not MYPY:
    class ReportSettingPropertiesArgsDict(TypedDict):
        """
        Identifies the report template for the report. Reports are built using a report template.
        """
        report_template: pulumi.Input[str]
        """
        Identifies the report template for the report. Reports are built using a report template. The report templates are: `BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
        """
        accounts: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of AWS accounts that a report covers.
        """
        framework_arns: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The Amazon Resource Names (ARNs) of the frameworks a report covers.
        """
        organization_units: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of AWS organization units that a report covers.
        """
        regions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of AWS regions that a report covers.
        """
elif False:
    ReportSettingPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReportSettingPropertiesArgs:
    def __init__(__self__, *,
                 report_template: pulumi.Input[str],
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 framework_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_units: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Identifies the report template for the report. Reports are built using a report template.
        :param pulumi.Input[str] report_template: Identifies the report template for the report. Reports are built using a report template. The report templates are: `BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] accounts: The list of AWS accounts that a report covers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] framework_arns: The Amazon Resource Names (ARNs) of the frameworks a report covers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] organization_units: The list of AWS organization units that a report covers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: The list of AWS regions that a report covers.
        """
        pulumi.set(__self__, "report_template", report_template)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if framework_arns is not None:
            pulumi.set(__self__, "framework_arns", framework_arns)
        if organization_units is not None:
            pulumi.set(__self__, "organization_units", organization_units)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter(name="reportTemplate")
    def report_template(self) -> pulumi.Input[str]:
        """
        Identifies the report template for the report. Reports are built using a report template. The report templates are: `BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
        """
        return pulumi.get(self, "report_template")

    @report_template.setter
    def report_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "report_template", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of AWS accounts that a report covers.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="frameworkArns")
    def framework_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Amazon Resource Names (ARNs) of the frameworks a report covers.
        """
        return pulumi.get(self, "framework_arns")

    @framework_arns.setter
    def framework_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "framework_arns", value)

    @property
    @pulumi.getter(name="organizationUnits")
    def organization_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of AWS organization units that a report covers.
        """
        return pulumi.get(self, "organization_units")

    @organization_units.setter
    def organization_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "organization_units", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of AWS regions that a report covers.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)


if not MYPY:
    class RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgsDict(TypedDict):
        algorithm: pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm']
        """
        Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
        """
        include_vaults: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
        """
        recovery_point_types: pulumi.Input[Sequence[pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointType']]]
        """
        These are the types of recovery points.

        Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm` .
        """
        exclude_vaults: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
        """
        selection_window_days: NotRequired[pulumi.Input[int]]
        """
        Accepted values are integers from 1 to 365.
        """
elif False:
    RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestoreTestingPlanRestoreTestingRecoveryPointSelectionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm'],
                 include_vaults: pulumi.Input[Sequence[pulumi.Input[str]]],
                 recovery_point_types: pulumi.Input[Sequence[pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointType']]],
                 exclude_vaults: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 selection_window_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm'] algorithm: Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_vaults: Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
        :param pulumi.Input[Sequence[pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointType']]] recovery_point_types: These are the types of recovery points.
               
               Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_vaults: Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
        :param pulumi.Input[int] selection_window_days: Accepted values are integers from 1 to 365.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "include_vaults", include_vaults)
        pulumi.set(__self__, "recovery_point_types", recovery_point_types)
        if exclude_vaults is not None:
            pulumi.set(__self__, "exclude_vaults", exclude_vaults)
        if selection_window_days is not None:
            pulumi.set(__self__, "selection_window_days", selection_window_days)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm']:
        """
        Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointSelectionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="includeVaults")
    def include_vaults(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
        """
        return pulumi.get(self, "include_vaults")

    @include_vaults.setter
    def include_vaults(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "include_vaults", value)

    @property
    @pulumi.getter(name="recoveryPointTypes")
    def recovery_point_types(self) -> pulumi.Input[Sequence[pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointType']]]:
        """
        These are the types of recovery points.

        Include `SNAPSHOT` to restore only snapshot recovery points; include `CONTINUOUS` to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for `Algorithm` .
        """
        return pulumi.get(self, "recovery_point_types")

    @recovery_point_types.setter
    def recovery_point_types(self, value: pulumi.Input[Sequence[pulumi.Input['RestoreTestingPlanRestoreTestingRecoveryPointType']]]):
        pulumi.set(self, "recovery_point_types", value)

    @property
    @pulumi.getter(name="excludeVaults")
    def exclude_vaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.
        """
        return pulumi.get(self, "exclude_vaults")

    @exclude_vaults.setter
    def exclude_vaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_vaults", value)

    @property
    @pulumi.getter(name="selectionWindowDays")
    def selection_window_days(self) -> Optional[pulumi.Input[int]]:
        """
        Accepted values are integers from 1 to 365.
        """
        return pulumi.get(self, "selection_window_days")

    @selection_window_days.setter
    def selection_window_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "selection_window_days", value)


if not MYPY:
    class RestoreTestingSelectionKeyValueArgsDict(TypedDict):
        key: pulumi.Input[str]
        """
        The tag key.
        """
        value: pulumi.Input[str]
        """
        The tag value.
        """
elif False:
    RestoreTestingSelectionKeyValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestoreTestingSelectionKeyValueArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The tag key.
        :param pulumi.Input[str] value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RestoreTestingSelectionProtectedResourceConditionsArgsDict(TypedDict):
        string_equals: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgsDict']]]]
        """
        Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."
        """
        string_not_equals: NotRequired[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgsDict']]]]
        """
        Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."
        """
elif False:
    RestoreTestingSelectionProtectedResourceConditionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RestoreTestingSelectionProtectedResourceConditionsArgs:
    def __init__(__self__, *,
                 string_equals: Optional[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]]] = None,
                 string_not_equals: Optional[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]] string_equals: Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."
        :param pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]] string_not_equals: Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."
        """
        if string_equals is not None:
            pulumi.set(__self__, "string_equals", string_equals)
        if string_not_equals is not None:
            pulumi.set(__self__, "string_not_equals", string_not_equals)

    @property
    @pulumi.getter(name="stringEquals")
    def string_equals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]]]:
        """
        Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."
        """
        return pulumi.get(self, "string_equals")

    @string_equals.setter
    def string_equals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]]]):
        pulumi.set(self, "string_equals", value)

    @property
    @pulumi.getter(name="stringNotEquals")
    def string_not_equals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]]]:
        """
        Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."
        """
        return pulumi.get(self, "string_not_equals")

    @string_not_equals.setter
    def string_not_equals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestoreTestingSelectionKeyValueArgs']]]]):
        pulumi.set(self, "string_not_equals", value)


