# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AutoScalingGroupAcceleratorCountRequest',
    'AutoScalingGroupAcceleratorTotalMemoryMiBRequest',
    'AutoScalingGroupBaselineEbsBandwidthMbpsRequest',
    'AutoScalingGroupInstanceMaintenancePolicy',
    'AutoScalingGroupInstanceRequirements',
    'AutoScalingGroupInstancesDistribution',
    'AutoScalingGroupLaunchTemplate',
    'AutoScalingGroupLaunchTemplateOverrides',
    'AutoScalingGroupLaunchTemplateSpecification',
    'AutoScalingGroupLifecycleHookSpecification',
    'AutoScalingGroupMemoryGiBPerVCpuRequest',
    'AutoScalingGroupMemoryMiBRequest',
    'AutoScalingGroupMetricsCollection',
    'AutoScalingGroupMixedInstancesPolicy',
    'AutoScalingGroupNetworkBandwidthGbpsRequest',
    'AutoScalingGroupNetworkInterfaceCountRequest',
    'AutoScalingGroupNotificationConfiguration',
    'AutoScalingGroupTagProperty',
    'AutoScalingGroupTotalLocalStorageGbRequest',
    'AutoScalingGroupVCpuCountRequest',
    'LaunchConfigurationBlockDevice',
    'LaunchConfigurationBlockDeviceMapping',
    'LaunchConfigurationMetadataOptions',
    'ScalingPolicyCustomizedMetricSpecification',
    'ScalingPolicyMetric',
    'ScalingPolicyMetricDataQuery',
    'ScalingPolicyMetricDimension',
    'ScalingPolicyMetricStat',
    'ScalingPolicyPredefinedMetricSpecification',
    'ScalingPolicyPredictiveScalingConfiguration',
    'ScalingPolicyPredictiveScalingCustomizedCapacityMetric',
    'ScalingPolicyPredictiveScalingCustomizedLoadMetric',
    'ScalingPolicyPredictiveScalingCustomizedScalingMetric',
    'ScalingPolicyPredictiveScalingMetricSpecification',
    'ScalingPolicyPredictiveScalingPredefinedLoadMetric',
    'ScalingPolicyPredictiveScalingPredefinedMetricPair',
    'ScalingPolicyPredictiveScalingPredefinedScalingMetric',
    'ScalingPolicyStepAdjustment',
    'ScalingPolicyTargetTrackingConfiguration',
    'ScalingPolicyTargetTrackingMetricDataQuery',
    'ScalingPolicyTargetTrackingMetricStat',
    'WarmPoolInstanceReusePolicy',
]

@pulumi.output_type
class AutoScalingGroupAcceleratorCountRequest(dict):
    """
    ``AcceleratorCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of accelerators for an instance type.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        ``AcceleratorCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of accelerators for an instance type.
        :param int max: The maximum value.
        :param int min: The minimum value.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The maximum value.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The minimum value.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupAcceleratorTotalMemoryMiBRequest(dict):
    """
    ``AcceleratorTotalMemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total memory size for the accelerators for an instance type, in MiB.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        ``AcceleratorTotalMemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total memory size for the accelerators for an instance type, in MiB.
        :param int max: The memory maximum in MiB.
        :param int min: The memory minimum in MiB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The memory maximum in MiB.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The memory minimum in MiB.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupBaselineEbsBandwidthMbpsRequest(dict):
    """
    ``BaselineEbsBandwidthMbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        ``BaselineEbsBandwidthMbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
        :param int max: The maximum value in Mbps.
        :param int min: The minimum value in Mbps.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The maximum value in Mbps.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The minimum value in Mbps.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupInstanceMaintenancePolicy(dict):
    """
    ``InstanceMaintenancePolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
     For more information, see [Instance maintenance policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxHealthyPercentage":
            suggest = "max_healthy_percentage"
        elif key == "minHealthyPercentage":
            suggest = "min_healthy_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupInstanceMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupInstanceMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupInstanceMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_healthy_percentage: Optional[int] = None,
                 min_healthy_percentage: Optional[int] = None):
        """
        ``InstanceMaintenancePolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For more information, see [Instance maintenance policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param int max_healthy_percentage: Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. To clear a previously set value, specify a value of ``-1``.
                Both ``MinHealthyPercentage`` and ``MaxHealthyPercentage`` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
        :param int min_healthy_percentage: Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. To clear a previously set value, specify a value of ``-1``.
        """
        if max_healthy_percentage is not None:
            pulumi.set(__self__, "max_healthy_percentage", max_healthy_percentage)
        if min_healthy_percentage is not None:
            pulumi.set(__self__, "min_healthy_percentage", min_healthy_percentage)

    @property
    @pulumi.getter(name="maxHealthyPercentage")
    def max_healthy_percentage(self) -> Optional[int]:
        """
        Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. To clear a previously set value, specify a value of ``-1``.
         Both ``MinHealthyPercentage`` and ``MaxHealthyPercentage`` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
        """
        return pulumi.get(self, "max_healthy_percentage")

    @property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> Optional[int]:
        """
        Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. To clear a previously set value, specify a value of ``-1``.
        """
        return pulumi.get(self, "min_healthy_percentage")


@pulumi.output_type
class AutoScalingGroupInstanceRequirements(dict):
    """
    The attributes for the instance types for a mixed instances policy. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
     When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
     To limit the list of instance types from which Amazon EC2 Auto Scaling can identify matching instance types, you can use one of the following parameters, but not both in the same request:
      +   ``AllowedInstanceTypes`` - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.
      +   ``ExcludedInstanceTypes`` - The instance types to exclude from the list, even if they match your specified attributes.
      
      You must specify ``VCpuCount`` and ``MemoryMiB``. All other attributes are optional. Any unspecified optional attribute is set to its default.
      For an example template, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
     For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*. For help determining which instance types match your attributes before you apply them to your Auto Scaling group, see [Preview instance types with specified attributes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html#ec2fleet-get-instance-types-from-instance-requirements) in the *Amazon EC2 User Guide for Linux Instances*.
      ``InstanceRequirements`` is a property of the ``LaunchTemplateOverrides`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryMiB":
            suggest = "memory_mi_b"
        elif key == "vCpuCount":
            suggest = "v_cpu_count"
        elif key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorManufacturers":
            suggest = "accelerator_manufacturers"
        elif key == "acceleratorNames":
            suggest = "accelerator_names"
        elif key == "acceleratorTotalMemoryMiB":
            suggest = "accelerator_total_memory_mi_b"
        elif key == "acceleratorTypes":
            suggest = "accelerator_types"
        elif key == "allowedInstanceTypes":
            suggest = "allowed_instance_types"
        elif key == "bareMetal":
            suggest = "bare_metal"
        elif key == "baselineEbsBandwidthMbps":
            suggest = "baseline_ebs_bandwidth_mbps"
        elif key == "burstablePerformance":
            suggest = "burstable_performance"
        elif key == "cpuManufacturers":
            suggest = "cpu_manufacturers"
        elif key == "excludedInstanceTypes":
            suggest = "excluded_instance_types"
        elif key == "instanceGenerations":
            suggest = "instance_generations"
        elif key == "localStorage":
            suggest = "local_storage"
        elif key == "localStorageTypes":
            suggest = "local_storage_types"
        elif key == "maxSpotPriceAsPercentageOfOptimalOnDemandPrice":
            suggest = "max_spot_price_as_percentage_of_optimal_on_demand_price"
        elif key == "memoryGiBPerVCpu":
            suggest = "memory_gi_b_per_v_cpu"
        elif key == "networkBandwidthGbps":
            suggest = "network_bandwidth_gbps"
        elif key == "networkInterfaceCount":
            suggest = "network_interface_count"
        elif key == "onDemandMaxPricePercentageOverLowestPrice":
            suggest = "on_demand_max_price_percentage_over_lowest_price"
        elif key == "requireHibernateSupport":
            suggest = "require_hibernate_support"
        elif key == "spotMaxPricePercentageOverLowestPrice":
            suggest = "spot_max_price_percentage_over_lowest_price"
        elif key == "totalLocalStorageGb":
            suggest = "total_local_storage_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupInstanceRequirements. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupInstanceRequirements.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupInstanceRequirements.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_mi_b: 'outputs.AutoScalingGroupMemoryMiBRequest',
                 v_cpu_count: 'outputs.AutoScalingGroupVCpuCountRequest',
                 accelerator_count: Optional['outputs.AutoScalingGroupAcceleratorCountRequest'] = None,
                 accelerator_manufacturers: Optional[Sequence[str]] = None,
                 accelerator_names: Optional[Sequence[str]] = None,
                 accelerator_total_memory_mi_b: Optional['outputs.AutoScalingGroupAcceleratorTotalMemoryMiBRequest'] = None,
                 accelerator_types: Optional[Sequence[str]] = None,
                 allowed_instance_types: Optional[Sequence[str]] = None,
                 bare_metal: Optional[str] = None,
                 baseline_ebs_bandwidth_mbps: Optional['outputs.AutoScalingGroupBaselineEbsBandwidthMbpsRequest'] = None,
                 burstable_performance: Optional[str] = None,
                 cpu_manufacturers: Optional[Sequence[str]] = None,
                 excluded_instance_types: Optional[Sequence[str]] = None,
                 instance_generations: Optional[Sequence[str]] = None,
                 local_storage: Optional[str] = None,
                 local_storage_types: Optional[Sequence[str]] = None,
                 max_spot_price_as_percentage_of_optimal_on_demand_price: Optional[int] = None,
                 memory_gi_b_per_v_cpu: Optional['outputs.AutoScalingGroupMemoryGiBPerVCpuRequest'] = None,
                 network_bandwidth_gbps: Optional['outputs.AutoScalingGroupNetworkBandwidthGbpsRequest'] = None,
                 network_interface_count: Optional['outputs.AutoScalingGroupNetworkInterfaceCountRequest'] = None,
                 on_demand_max_price_percentage_over_lowest_price: Optional[int] = None,
                 require_hibernate_support: Optional[bool] = None,
                 spot_max_price_percentage_over_lowest_price: Optional[int] = None,
                 total_local_storage_gb: Optional['outputs.AutoScalingGroupTotalLocalStorageGbRequest'] = None):
        """
        The attributes for the instance types for a mixed instances policy. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
         To limit the list of instance types from which Amazon EC2 Auto Scaling can identify matching instance types, you can use one of the following parameters, but not both in the same request:
          +   ``AllowedInstanceTypes`` - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.
          +   ``ExcludedInstanceTypes`` - The instance types to exclude from the list, even if they match your specified attributes.
          
          You must specify ``VCpuCount`` and ``MemoryMiB``. All other attributes are optional. Any unspecified optional attribute is set to its default.
          For an example template, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
         For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*. For help determining which instance types match your attributes before you apply them to your Auto Scaling group, see [Preview instance types with specified attributes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html#ec2fleet-get-instance-types-from-instance-requirements) in the *Amazon EC2 User Guide for Linux Instances*.
          ``InstanceRequirements`` is a property of the ``LaunchTemplateOverrides`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
        :param 'AutoScalingGroupMemoryMiBRequest' memory_mi_b: The minimum and maximum instance memory size for an instance type, in MiB.
        :param 'AutoScalingGroupVCpuCountRequest' v_cpu_count: The minimum and maximum number of vCPUs for an instance type.
        :param 'AutoScalingGroupAcceleratorCountRequest' accelerator_count: The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) for an instance type.
                To exclude accelerator-enabled instance types, set ``Max`` to ``0``.
                Default: No minimum or maximum limits
        :param Sequence[str] accelerator_manufacturers: Indicates whether instance types must have accelerators by specific manufacturers.
                 +  For instance types with NVIDIA devices, specify ``nvidia``.
                 +  For instance types with AMD devices, specify ``amd``.
                 +  For instance types with AWS devices, specify ``amazon-web-services``.
                 +  For instance types with Xilinx devices, specify ``xilinx``.
                 
                Default: Any manufacturer
        :param Sequence[str] accelerator_names: Lists the accelerators that must be on an instance type.
                 +  For instance types with NVIDIA A100 GPUs, specify ``a100``.
                 +  For instance types with NVIDIA V100 GPUs, specify ``v100``.
                 +  For instance types with NVIDIA K80 GPUs, specify ``k80``.
                 +  For instance types with NVIDIA T4 GPUs, specify ``t4``.
                 +  For instance types with NVIDIA M60 GPUs, specify ``m60``.
                 +  For instance types with AMD Radeon Pro V520 GPUs, specify ``radeon-pro-v520``.
                 +  For instance types with Xilinx VU9P FPGAs, specify ``vu9p``.
                 
                Default: Any accelerator
        :param 'AutoScalingGroupAcceleratorTotalMemoryMiBRequest' accelerator_total_memory_mi_b: The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
                Default: No minimum or maximum limits
        :param Sequence[str] accelerator_types: Lists the accelerator types that must be on an instance type.
                 +  For instance types with GPU accelerators, specify ``gpu``.
                 +  For instance types with FPGA accelerators, specify ``fpga``.
                 +  For instance types with inference accelerators, specify ``inference``.
                 
                Default: Any accelerator type
        :param Sequence[str] allowed_instance_types: The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
                You can use strings with one or more wild cards, represented by an asterisk (``*``), to allow an instance type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``.
                For example, if you specify ``c5*``, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
                 If you specify ``AllowedInstanceTypes``, you can't specify ``ExcludedInstanceTypes``.
                 Default: All instance types
        :param str bare_metal: Indicates whether bare metal instance types are included, excluded, or required.
                Default: ``excluded``
        :param 'AutoScalingGroupBaselineEbsBandwidthMbpsRequest' baseline_ebs_bandwidth_mbps: The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
                Default: No minimum or maximum limits
        :param str burstable_performance: Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
                Default: ``excluded``
        :param Sequence[str] cpu_manufacturers: Lists which specific CPU manufacturers to include.
                 +  For instance types with Intel CPUs, specify ``intel``.
                 +  For instance types with AMD CPUs, specify ``amd``.
                 +  For instance types with AWS CPUs, specify ``amazon-web-services``.
                 
                 Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template. 
                 Default: Any manufacturer
        :param Sequence[str] excluded_instance_types: The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (``*``), to exclude an instance family, type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``. 
                For example, if you specify ``c5*``, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
                 If you specify ``ExcludedInstanceTypes``, you can't specify ``AllowedInstanceTypes``.
                 Default: No excluded instance types
        :param Sequence[str] instance_generations: Indicates whether current or previous generation instance types are included.
                 +  For current generation instance types, specify ``current``. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
                 +  For previous generation instance types, specify ``previous``.
                 
                Default: Any current or previous generation
        :param str local_storage: Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
                Default: ``included``
        :param Sequence[str] local_storage_types: Indicates the type of local storage that is required.
                 +  For instance types with hard disk drive (HDD) storage, specify ``hdd``.
                 +  For instance types with solid state drive (SSD) storage, specify ``ssd``.
                 
                Default: Any local storage type
        :param int max_spot_price_as_percentage_of_optimal_on_demand_price: [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
                The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
                If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
                 Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        :param 'AutoScalingGroupMemoryGiBPerVCpuRequest' memory_gi_b_per_v_cpu: The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
                Default: No minimum or maximum limits
        :param 'AutoScalingGroupNetworkBandwidthGbpsRequest' network_bandwidth_gbps: The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
                Default: No minimum or maximum limits
        :param 'AutoScalingGroupNetworkInterfaceCountRequest' network_interface_count: The minimum and maximum number of network interfaces for an instance type.
                Default: No minimum or maximum limits
        :param int on_demand_max_price_percentage_over_lowest_price: [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold. 
                The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
                To turn off price protection, specify a high value, such as ``999999``. 
                If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per instance price. 
                Default: ``20``
        :param bool require_hibernate_support: Indicates whether instance types must provide On-Demand Instance hibernation support.
                Default: ``false``
        :param int spot_max_price_percentage_over_lowest_price: [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price. The identified Spot price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
                The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. 
                If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
                 Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        :param 'AutoScalingGroupTotalLocalStorageGbRequest' total_local_storage_gb: The minimum and maximum total local storage size for an instance type, in GB.
                Default: No minimum or maximum limits
        """
        pulumi.set(__self__, "memory_mi_b", memory_mi_b)
        pulumi.set(__self__, "v_cpu_count", v_cpu_count)
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_manufacturers is not None:
            pulumi.set(__self__, "accelerator_manufacturers", accelerator_manufacturers)
        if accelerator_names is not None:
            pulumi.set(__self__, "accelerator_names", accelerator_names)
        if accelerator_total_memory_mi_b is not None:
            pulumi.set(__self__, "accelerator_total_memory_mi_b", accelerator_total_memory_mi_b)
        if accelerator_types is not None:
            pulumi.set(__self__, "accelerator_types", accelerator_types)
        if allowed_instance_types is not None:
            pulumi.set(__self__, "allowed_instance_types", allowed_instance_types)
        if bare_metal is not None:
            pulumi.set(__self__, "bare_metal", bare_metal)
        if baseline_ebs_bandwidth_mbps is not None:
            pulumi.set(__self__, "baseline_ebs_bandwidth_mbps", baseline_ebs_bandwidth_mbps)
        if burstable_performance is not None:
            pulumi.set(__self__, "burstable_performance", burstable_performance)
        if cpu_manufacturers is not None:
            pulumi.set(__self__, "cpu_manufacturers", cpu_manufacturers)
        if excluded_instance_types is not None:
            pulumi.set(__self__, "excluded_instance_types", excluded_instance_types)
        if instance_generations is not None:
            pulumi.set(__self__, "instance_generations", instance_generations)
        if local_storage is not None:
            pulumi.set(__self__, "local_storage", local_storage)
        if local_storage_types is not None:
            pulumi.set(__self__, "local_storage_types", local_storage_types)
        if max_spot_price_as_percentage_of_optimal_on_demand_price is not None:
            pulumi.set(__self__, "max_spot_price_as_percentage_of_optimal_on_demand_price", max_spot_price_as_percentage_of_optimal_on_demand_price)
        if memory_gi_b_per_v_cpu is not None:
            pulumi.set(__self__, "memory_gi_b_per_v_cpu", memory_gi_b_per_v_cpu)
        if network_bandwidth_gbps is not None:
            pulumi.set(__self__, "network_bandwidth_gbps", network_bandwidth_gbps)
        if network_interface_count is not None:
            pulumi.set(__self__, "network_interface_count", network_interface_count)
        if on_demand_max_price_percentage_over_lowest_price is not None:
            pulumi.set(__self__, "on_demand_max_price_percentage_over_lowest_price", on_demand_max_price_percentage_over_lowest_price)
        if require_hibernate_support is not None:
            pulumi.set(__self__, "require_hibernate_support", require_hibernate_support)
        if spot_max_price_percentage_over_lowest_price is not None:
            pulumi.set(__self__, "spot_max_price_percentage_over_lowest_price", spot_max_price_percentage_over_lowest_price)
        if total_local_storage_gb is not None:
            pulumi.set(__self__, "total_local_storage_gb", total_local_storage_gb)

    @property
    @pulumi.getter(name="memoryMiB")
    def memory_mi_b(self) -> 'outputs.AutoScalingGroupMemoryMiBRequest':
        """
        The minimum and maximum instance memory size for an instance type, in MiB.
        """
        return pulumi.get(self, "memory_mi_b")

    @property
    @pulumi.getter(name="vCpuCount")
    def v_cpu_count(self) -> 'outputs.AutoScalingGroupVCpuCountRequest':
        """
        The minimum and maximum number of vCPUs for an instance type.
        """
        return pulumi.get(self, "v_cpu_count")

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional['outputs.AutoScalingGroupAcceleratorCountRequest']:
        """
        The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) for an instance type.
         To exclude accelerator-enabled instance types, set ``Max`` to ``0``.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorManufacturers")
    def accelerator_manufacturers(self) -> Optional[Sequence[str]]:
        """
        Indicates whether instance types must have accelerators by specific manufacturers.
          +  For instance types with NVIDIA devices, specify ``nvidia``.
          +  For instance types with AMD devices, specify ``amd``.
          +  For instance types with AWS devices, specify ``amazon-web-services``.
          +  For instance types with Xilinx devices, specify ``xilinx``.
          
         Default: Any manufacturer
        """
        return pulumi.get(self, "accelerator_manufacturers")

    @property
    @pulumi.getter(name="acceleratorNames")
    def accelerator_names(self) -> Optional[Sequence[str]]:
        """
        Lists the accelerators that must be on an instance type.
          +  For instance types with NVIDIA A100 GPUs, specify ``a100``.
          +  For instance types with NVIDIA V100 GPUs, specify ``v100``.
          +  For instance types with NVIDIA K80 GPUs, specify ``k80``.
          +  For instance types with NVIDIA T4 GPUs, specify ``t4``.
          +  For instance types with NVIDIA M60 GPUs, specify ``m60``.
          +  For instance types with AMD Radeon Pro V520 GPUs, specify ``radeon-pro-v520``.
          +  For instance types with Xilinx VU9P FPGAs, specify ``vu9p``.
          
         Default: Any accelerator
        """
        return pulumi.get(self, "accelerator_names")

    @property
    @pulumi.getter(name="acceleratorTotalMemoryMiB")
    def accelerator_total_memory_mi_b(self) -> Optional['outputs.AutoScalingGroupAcceleratorTotalMemoryMiBRequest']:
        """
        The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "accelerator_total_memory_mi_b")

    @property
    @pulumi.getter(name="acceleratorTypes")
    def accelerator_types(self) -> Optional[Sequence[str]]:
        """
        Lists the accelerator types that must be on an instance type.
          +  For instance types with GPU accelerators, specify ``gpu``.
          +  For instance types with FPGA accelerators, specify ``fpga``.
          +  For instance types with inference accelerators, specify ``inference``.
          
         Default: Any accelerator type
        """
        return pulumi.get(self, "accelerator_types")

    @property
    @pulumi.getter(name="allowedInstanceTypes")
    def allowed_instance_types(self) -> Optional[Sequence[str]]:
        """
        The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
         You can use strings with one or more wild cards, represented by an asterisk (``*``), to allow an instance type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``.
         For example, if you specify ``c5*``, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
          If you specify ``AllowedInstanceTypes``, you can't specify ``ExcludedInstanceTypes``.
          Default: All instance types
        """
        return pulumi.get(self, "allowed_instance_types")

    @property
    @pulumi.getter(name="bareMetal")
    def bare_metal(self) -> Optional[str]:
        """
        Indicates whether bare metal instance types are included, excluded, or required.
         Default: ``excluded``
        """
        return pulumi.get(self, "bare_metal")

    @property
    @pulumi.getter(name="baselineEbsBandwidthMbps")
    def baseline_ebs_bandwidth_mbps(self) -> Optional['outputs.AutoScalingGroupBaselineEbsBandwidthMbpsRequest']:
        """
        The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "baseline_ebs_bandwidth_mbps")

    @property
    @pulumi.getter(name="burstablePerformance")
    def burstable_performance(self) -> Optional[str]:
        """
        Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: ``excluded``
        """
        return pulumi.get(self, "burstable_performance")

    @property
    @pulumi.getter(name="cpuManufacturers")
    def cpu_manufacturers(self) -> Optional[Sequence[str]]:
        """
        Lists which specific CPU manufacturers to include.
          +  For instance types with Intel CPUs, specify ``intel``.
          +  For instance types with AMD CPUs, specify ``amd``.
          +  For instance types with AWS CPUs, specify ``amazon-web-services``.
          
          Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template. 
          Default: Any manufacturer
        """
        return pulumi.get(self, "cpu_manufacturers")

    @property
    @pulumi.getter(name="excludedInstanceTypes")
    def excluded_instance_types(self) -> Optional[Sequence[str]]:
        """
        The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (``*``), to exclude an instance family, type, size, or generation. The following are examples: ``m5.8xlarge``, ``c5*.*``, ``m5a.*``, ``r*``, ``*3*``. 
         For example, if you specify ``c5*``, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify ``m5a.*``, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
          If you specify ``ExcludedInstanceTypes``, you can't specify ``AllowedInstanceTypes``.
          Default: No excluded instance types
        """
        return pulumi.get(self, "excluded_instance_types")

    @property
    @pulumi.getter(name="instanceGenerations")
    def instance_generations(self) -> Optional[Sequence[str]]:
        """
        Indicates whether current or previous generation instance types are included.
          +  For current generation instance types, specify ``current``. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
          +  For previous generation instance types, specify ``previous``.
          
         Default: Any current or previous generation
        """
        return pulumi.get(self, "instance_generations")

    @property
    @pulumi.getter(name="localStorage")
    def local_storage(self) -> Optional[str]:
        """
        Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
         Default: ``included``
        """
        return pulumi.get(self, "local_storage")

    @property
    @pulumi.getter(name="localStorageTypes")
    def local_storage_types(self) -> Optional[Sequence[str]]:
        """
        Indicates the type of local storage that is required.
          +  For instance types with hard disk drive (HDD) storage, specify ``hdd``.
          +  For instance types with solid state drive (SSD) storage, specify ``ssd``.
          
         Default: Any local storage type
        """
        return pulumi.get(self, "local_storage_types")

    @property
    @pulumi.getter(name="maxSpotPriceAsPercentageOfOptimalOnDemandPrice")
    def max_spot_price_as_percentage_of_optimal_on_demand_price(self) -> Optional[int]:
        """
        [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
          Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        """
        return pulumi.get(self, "max_spot_price_as_percentage_of_optimal_on_demand_price")

    @property
    @pulumi.getter(name="memoryGiBPerVCpu")
    def memory_gi_b_per_v_cpu(self) -> Optional['outputs.AutoScalingGroupMemoryGiBPerVCpuRequest']:
        """
        The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "memory_gi_b_per_v_cpu")

    @property
    @pulumi.getter(name="networkBandwidthGbps")
    def network_bandwidth_gbps(self) -> Optional['outputs.AutoScalingGroupNetworkBandwidthGbpsRequest']:
        """
        The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "network_bandwidth_gbps")

    @property
    @pulumi.getter(name="networkInterfaceCount")
    def network_interface_count(self) -> Optional['outputs.AutoScalingGroupNetworkInterfaceCountRequest']:
        """
        The minimum and maximum number of network interfaces for an instance type.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "network_interface_count")

    @property
    @pulumi.getter(name="onDemandMaxPricePercentageOverLowestPrice")
    def on_demand_max_price_percentage_over_lowest_price(self) -> Optional[int]:
        """
        [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price. The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold. 
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
         To turn off price protection, specify a high value, such as ``999999``. 
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per instance price. 
         Default: ``20``
        """
        return pulumi.get(self, "on_demand_max_price_percentage_over_lowest_price")

    @property
    @pulumi.getter(name="requireHibernateSupport")
    def require_hibernate_support(self) -> Optional[bool]:
        """
        Indicates whether instance types must provide On-Demand Instance hibernation support.
         Default: ``false``
        """
        return pulumi.get(self, "require_hibernate_support")

    @property
    @pulumi.getter(name="spotMaxPricePercentageOverLowestPrice")
    def spot_max_price_percentage_over_lowest_price(self) -> Optional[int]:
        """
        [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price. The identified Spot price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. 
         If you set ``DesiredCapacityType`` to ``vcpu`` or ``memory-mib``, the price protection threshold is based on the per-vCPU or per-memory price instead of the per instance price. 
          Only one of ``SpotMaxPricePercentageOverLowestPrice`` or ``MaxSpotPriceAsPercentageOfOptimalOnDemandPrice`` can be specified. If you don't specify either, Amazon EC2 Auto Scaling will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as ``999999``.
        """
        return pulumi.get(self, "spot_max_price_percentage_over_lowest_price")

    @property
    @pulumi.getter(name="totalLocalStorageGb")
    def total_local_storage_gb(self) -> Optional['outputs.AutoScalingGroupTotalLocalStorageGbRequest']:
        """
        The minimum and maximum total local storage size for an instance type, in GB.
         Default: No minimum or maximum limits
        """
        return pulumi.get(self, "total_local_storage_gb")


@pulumi.output_type
class AutoScalingGroupInstancesDistribution(dict):
    """
    Use this structure to specify the distribution of On-Demand Instances and Spot Instances and the allocation strategies used to fulfill On-Demand and Spot capacities for a mixed instances policy.
     For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
      ``InstancesDistribution`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandAllocationStrategy":
            suggest = "on_demand_allocation_strategy"
        elif key == "onDemandBaseCapacity":
            suggest = "on_demand_base_capacity"
        elif key == "onDemandPercentageAboveBaseCapacity":
            suggest = "on_demand_percentage_above_base_capacity"
        elif key == "spotAllocationStrategy":
            suggest = "spot_allocation_strategy"
        elif key == "spotInstancePools":
            suggest = "spot_instance_pools"
        elif key == "spotMaxPrice":
            suggest = "spot_max_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupInstancesDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupInstancesDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupInstancesDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_allocation_strategy: Optional[str] = None,
                 on_demand_base_capacity: Optional[int] = None,
                 on_demand_percentage_above_base_capacity: Optional[int] = None,
                 spot_allocation_strategy: Optional[str] = None,
                 spot_instance_pools: Optional[int] = None,
                 spot_max_price: Optional[str] = None):
        """
        Use this structure to specify the distribution of On-Demand Instances and Spot Instances and the allocation strategies used to fulfill On-Demand and Spot capacities for a mixed instances policy.
         For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
          ``InstancesDistribution`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
        :param str on_demand_allocation_strategy: The allocation strategy to apply to your On-Demand Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
                The following lists the valid values:
                 + lowest-price Uses price to determine which instance types are the highest priority, launching the lowest priced instance types within an Availability Zone first. This is the default value for Auto Scaling groups that specify InstanceRequirements. + prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling launches your highest priority instance types first. If all your On-Demand capacity cannot be fulfilled using your highest priority instance type, then Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so on. This is the default value for Auto Scaling groups that don't specify InstanceRequirements and cannot be used for groups that do.
        :param int on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is launched first as your group scales.
                This number has the same unit of measurement as the group's desired capacity. If you change the default unit of measurement (number of instances) by specifying weighted capacity values in your launch template overrides list, or by changing the default desired capacity type setting of the group, you must specify this number using the same unit of measurement.
                Default: 0
                 An update to this setting means a gradual replacement of instances to adjust the current On-Demand Instance levels. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        :param int on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond ``OnDemandBaseCapacity``. Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand Instances are used.
                Default: 100
                 An update to this setting means a gradual replacement of instances to adjust the current On-Demand and Spot Instance levels for your additional capacity higher than the base capacity. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        :param str spot_allocation_strategy: The allocation strategy to apply to your Spot Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
                The following lists the valid values:
                 + capacity-optimized Requests Spot Instances using pools that are optimally chosen based on the available Spot capacity. This strategy has the lowest risk of interruption. To give certain instance types a higher chance of launching first, use capacity-optimized-prioritized. + capacity-optimized-prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best effort basis but optimizes for capacity first. Note that if the On-Demand allocation strategy is set to prioritized, the same priority is applied when fulfilling On-Demand capacity. This is not a valid value for Auto Scaling groups that specify InstanceRequirements. + lowest-price Requests Spot Instances using the lowest priced pools within an Availability Zone, across the number of Spot pools that you specify for the SpotInstancePools property. To ensure that your desired capacity is met, you might receive Spot Instances from several pools. This is the default value, but it might lead to high interruption rates because this strategy only considers instance price and not available capacity. + price-capacity-optimized (recommended) The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
        :param int spot_instance_pools: The number of Spot Instance pools across which to allocate your Spot Instances. The Spot pools are determined from the different instance types in the overrides. Valid only when the ``SpotAllocationStrategy`` is ``lowest-price``. Value must be in the range of 1–20.
                Default: 2
        :param str spot_max_price: The maximum price per unit hour that you are willing to pay for a Spot Instance. If your maximum price is lower than the Spot price for the instance types that you selected, your Spot Instances are not launched. We do not recommend specifying a maximum price because it can lead to increased interruptions. When Spot Instances launch, you pay the current Spot price. To remove a maximum price that you previously set, include the property but specify an empty string ("") for the value.
                 If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify one.
                 Valid Range: Minimum value of 0.001
        """
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[str]:
        """
        The allocation strategy to apply to your On-Demand Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
         The following lists the valid values:
          + lowest-price Uses price to determine which instance types are the highest priority, launching the lowest priced instance types within an Availability Zone first. This is the default value for Auto Scaling groups that specify InstanceRequirements. + prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling launches your highest priority instance types first. If all your On-Demand capacity cannot be fulfilled using your highest priority instance type, then Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so on. This is the default value for Auto Scaling groups that don't specify InstanceRequirements and cannot be used for groups that do.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[int]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is launched first as your group scales.
         This number has the same unit of measurement as the group's desired capacity. If you change the default unit of measurement (number of instances) by specifying weighted capacity values in your launch template overrides list, or by changing the default desired capacity type setting of the group, you must specify this number using the same unit of measurement.
         Default: 0
          An update to this setting means a gradual replacement of instances to adjust the current On-Demand Instance levels. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[int]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond ``OnDemandBaseCapacity``. Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand Instances are used.
         Default: 100
          An update to this setting means a gradual replacement of instances to adjust the current On-Demand and Spot Instance levels for your additional capacity higher than the base capacity. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the previous ones.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[str]:
        """
        The allocation strategy to apply to your Spot Instances when they are launched. Possible instance types are determined by the launch template overrides that you specify.
         The following lists the valid values:
          + capacity-optimized Requests Spot Instances using pools that are optimally chosen based on the available Spot capacity. This strategy has the lowest risk of interruption. To give certain instance types a higher chance of launching first, use capacity-optimized-prioritized. + capacity-optimized-prioritized You set the order of instance types for the launch template overrides from highest to lowest priority (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best effort basis but optimizes for capacity first. Note that if the On-Demand allocation strategy is set to prioritized, the same priority is applied when fulfilling On-Demand capacity. This is not a valid value for Auto Scaling groups that specify InstanceRequirements. + lowest-price Requests Spot Instances using the lowest priced pools within an Availability Zone, across the number of Spot pools that you specify for the SpotInstancePools property. To ensure that your desired capacity is met, you might receive Spot Instances from several pools. This is the default value, but it might lead to high interruption rates because this strategy only considers instance price and not available capacity. + price-capacity-optimized (recommended) The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[int]:
        """
        The number of Spot Instance pools across which to allocate your Spot Instances. The Spot pools are determined from the different instance types in the overrides. Valid only when the ``SpotAllocationStrategy`` is ``lowest-price``. Value must be in the range of 1–20.
         Default: 2
        """
        return pulumi.get(self, "spot_instance_pools")

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[str]:
        """
        The maximum price per unit hour that you are willing to pay for a Spot Instance. If your maximum price is lower than the Spot price for the instance types that you selected, your Spot Instances are not launched. We do not recommend specifying a maximum price because it can lead to increased interruptions. When Spot Instances launch, you pay the current Spot price. To remove a maximum price that you previously set, include the property but specify an empty string ("") for the value.
          If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify one.
          Valid Range: Minimum value of 0.001
        """
        return pulumi.get(self, "spot_max_price")


@pulumi.output_type
class AutoScalingGroupLaunchTemplate(dict):
    """
    Use this structure to specify the launch templates and instance types (overrides) for a mixed instances policy.
      ``LaunchTemplate`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateSpecification":
            suggest = "launch_template_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_specification: 'outputs.AutoScalingGroupLaunchTemplateSpecification',
                 overrides: Optional[Sequence['outputs.AutoScalingGroupLaunchTemplateOverrides']] = None):
        """
        Use this structure to specify the launch templates and instance types (overrides) for a mixed instances policy.
          ``LaunchTemplate`` is a property of the [AWS::AutoScaling::AutoScalingGroup MixedInstancesPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-mixedinstancespolicy.html) property type.
        :param 'AutoScalingGroupLaunchTemplateSpecification' launch_template_specification: The launch template.
        :param Sequence['AutoScalingGroupLaunchTemplateOverrides'] overrides: Any properties that you specify override the same properties in the launch template.
        """
        pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> 'outputs.AutoScalingGroupLaunchTemplateSpecification':
        """
        The launch template.
        """
        return pulumi.get(self, "launch_template_specification")

    @property
    @pulumi.getter
    def overrides(self) -> Optional[Sequence['outputs.AutoScalingGroupLaunchTemplateOverrides']]:
        """
        Any properties that you specify override the same properties in the launch template.
        """
        return pulumi.get(self, "overrides")


@pulumi.output_type
class AutoScalingGroupLaunchTemplateOverrides(dict):
    """
    Use this structure to let Amazon EC2 Auto Scaling do the following when the Auto Scaling group has a mixed instances policy:
      +  Override the instance type that is specified in the launch template.
      +  Use multiple instance types.
      
     Specify the instance types that you want, or define your instance requirements instead and let Amazon EC2 Auto Scaling provision the available instance types that meet your requirements. This can provide Amazon EC2 Auto Scaling with a larger selection of instance types to choose from when fulfilling Spot and On-Demand capacities. You can view which instance types are matched before you apply the instance requirements to your Auto Scaling group.
     After you define your instance requirements, you don't have to keep updating these settings to get new EC2 instance types automatically. Amazon EC2 Auto Scaling uses the instance requirements of the Auto Scaling group to determine whether a new EC2 instance type can be used.
      ``LaunchTemplateOverrides`` is a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceRequirements":
            suggest = "instance_requirements"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "launchTemplateSpecification":
            suggest = "launch_template_specification"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLaunchTemplateOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLaunchTemplateOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLaunchTemplateOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_requirements: Optional['outputs.AutoScalingGroupInstanceRequirements'] = None,
                 instance_type: Optional[str] = None,
                 launch_template_specification: Optional['outputs.AutoScalingGroupLaunchTemplateSpecification'] = None,
                 weighted_capacity: Optional[str] = None):
        """
        Use this structure to let Amazon EC2 Auto Scaling do the following when the Auto Scaling group has a mixed instances policy:
          +  Override the instance type that is specified in the launch template.
          +  Use multiple instance types.
          
         Specify the instance types that you want, or define your instance requirements instead and let Amazon EC2 Auto Scaling provision the available instance types that meet your requirements. This can provide Amazon EC2 Auto Scaling with a larger selection of instance types to choose from when fulfilling Spot and On-Demand capacities. You can view which instance types are matched before you apply the instance requirements to your Auto Scaling group.
         After you define your instance requirements, you don't have to keep updating these settings to get new EC2 instance types automatically. Amazon EC2 Auto Scaling uses the instance requirements of the Auto Scaling group to determine whether a new EC2 instance type can be used.
          ``LaunchTemplateOverrides`` is a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) property type.
        :param 'AutoScalingGroupInstanceRequirements' instance_requirements: The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
                You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template. 
                 If you specify ``InstanceRequirements``, you can't specify ``InstanceType``.
        :param str instance_type: The instance type, such as ``m3.xlarge``. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
                You can specify up to 40 instance types per Auto Scaling group.
        :param 'AutoScalingGroupLaunchTemplateSpecification' launch_template_specification: Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the ``LaunchTemplate`` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*. 
                You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the ``LaunchTemplate`` definition count towards this limit.
        :param str weighted_capacity: If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a ``WeightedCapacity`` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configure instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1-999. 
                If you specify a value for ``WeightedCapacity`` for one instance type, you must specify a value for ``WeightedCapacity`` for all of them.
                 Every Auto Scaling group has three size parameters (``DesiredCapacity``, ``MaxSize``, and ``MinSize``). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
        """
        if instance_requirements is not None:
            pulumi.set(__self__, "instance_requirements", instance_requirements)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if launch_template_specification is not None:
            pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceRequirements")
    def instance_requirements(self) -> Optional['outputs.AutoScalingGroupInstanceRequirements']:
        """
        The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template. 
          If you specify ``InstanceRequirements``, you can't specify ``InstanceType``.
        """
        return pulumi.get(self, "instance_requirements")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type, such as ``m3.xlarge``. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
         You can specify up to 40 instance types per Auto Scaling group.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> Optional['outputs.AutoScalingGroupLaunchTemplateSpecification']:
        """
        Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the ``LaunchTemplate`` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*. 
         You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the ``LaunchTemplate`` definition count towards this limit.
        """
        return pulumi.get(self, "launch_template_specification")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[str]:
        """
        If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a ``WeightedCapacity`` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configure instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1-999. 
         If you specify a value for ``WeightedCapacity`` for one instance type, you must specify a value for ``WeightedCapacity`` for all of them.
          Every Auto Scaling group has three size parameters (``DesiredCapacity``, ``MaxSize``, and ``MinSize``). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class AutoScalingGroupLaunchTemplateSpecification(dict):
    """
    Specifies a launch template to use when provisioning EC2 instances for an Auto Scaling group.
     You must specify the following:
      +  The ID or the name of the launch template, but not both.
      +  The version of the launch template.
      
      ``LaunchTemplateSpecification`` is property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. It is also a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) and [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property types.
     For information about creating a launch template, see [AWS::EC2::LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
     For examples of launch templates, see [Create launch templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-launch-templates.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLaunchTemplateSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLaunchTemplateSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLaunchTemplateSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: str,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None):
        """
        Specifies a launch template to use when provisioning EC2 instances for an Auto Scaling group.
         You must specify the following:
          +  The ID or the name of the launch template, but not both.
          +  The version of the launch template.
          
          ``LaunchTemplateSpecification`` is property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. It is also a property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplate.html) and [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property types.
         For information about creating a launch template, see [AWS::EC2::LaunchTemplate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         For examples of launch templates, see [Create launch templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-launch-templates.html).
        :param str version: The version number of the launch template.
                Specifying ``$Latest`` or ``$Default`` for the template version number is not supported. However, you can specify ``LatestVersionNumber`` or ``DefaultVersionNumber`` using the ``Fn::GetAtt`` intrinsic function. For more information, see [Fn::GetAtt](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html).
                 For an example of using the ``Fn::GetAtt`` function, see the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        :param str launch_template_id: The ID of the launch template.
                You must specify the ``LaunchTemplateID`` or the ``LaunchTemplateName``, but not both.
        :param str launch_template_name: The name of the launch template.
                You must specify the ``LaunchTemplateName`` or the ``LaunchTemplateID``, but not both.
        """
        pulumi.set(__self__, "version", version)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version number of the launch template.
         Specifying ``$Latest`` or ``$Default`` for the template version number is not supported. However, you can specify ``LatestVersionNumber`` or ``DefaultVersionNumber`` using the ``Fn::GetAtt`` intrinsic function. For more information, see [Fn::GetAtt](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html).
          For an example of using the ``Fn::GetAtt`` function, see the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        """
        The ID of the launch template.
         You must specify the ``LaunchTemplateID`` or the ``LaunchTemplateName``, but not both.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        """
        The name of the launch template.
         You must specify the ``LaunchTemplateName`` or the ``LaunchTemplateID``, but not both.
        """
        return pulumi.get(self, "launch_template_name")


@pulumi.output_type
class AutoScalingGroupLifecycleHookSpecification(dict):
    """
    ``LifecycleHookSpecification`` specifies a lifecycle hook for the ``LifecycleHookSpecificationList`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. A lifecycle hook specifies actions to perform when Amazon EC2 Auto Scaling launches or terminates instances. 
     For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#aws-resource-as-lifecyclehook--examples) section of the ``AWS::AutoScaling::LifecycleHook`` resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifecycleHookName":
            suggest = "lifecycle_hook_name"
        elif key == "lifecycleTransition":
            suggest = "lifecycle_transition"
        elif key == "defaultResult":
            suggest = "default_result"
        elif key == "heartbeatTimeout":
            suggest = "heartbeat_timeout"
        elif key == "notificationMetadata":
            suggest = "notification_metadata"
        elif key == "notificationTargetArn":
            suggest = "notification_target_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLifecycleHookSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLifecycleHookSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLifecycleHookSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifecycle_hook_name: str,
                 lifecycle_transition: str,
                 default_result: Optional[str] = None,
                 heartbeat_timeout: Optional[int] = None,
                 notification_metadata: Optional[str] = None,
                 notification_target_arn: Optional[str] = None,
                 role_arn: Optional[str] = None):
        """
        ``LifecycleHookSpecification`` specifies a lifecycle hook for the ``LifecycleHookSpecificationList`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource. A lifecycle hook specifies actions to perform when Amazon EC2 Auto Scaling launches or terminates instances. 
         For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#aws-resource-as-lifecyclehook--examples) section of the ``AWS::AutoScaling::LifecycleHook`` resource.
        :param str lifecycle_hook_name: The name of the lifecycle hook.
        :param str lifecycle_transition: The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
                 +  To create a lifecycle hook for scale-out events, specify ``autoscaling:EC2_INSTANCE_LAUNCHING``.
                 +  To create a lifecycle hook for scale-in events, specify ``autoscaling:EC2_INSTANCE_TERMINATING``.
        :param str default_result: The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is ``ABANDON``.
                Valid values: ``CONTINUE`` | ``ABANDON``
        :param int heartbeat_timeout: The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from ``30`` to ``7200`` seconds. The default value is ``3600`` seconds (1 hour).
        :param str notification_metadata: Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
        :param str notification_target_arn: The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook. You can specify an Amazon SNS topic or an Amazon SQS queue.
        :param str role_arn: The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target. For information about creating this role, see [Prepare to add a lifecycle hook to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/prepare-for-lifecycle-notifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue.
        """
        pulumi.set(__self__, "lifecycle_hook_name", lifecycle_hook_name)
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)
        if notification_target_arn is not None:
            pulumi.set(__self__, "notification_target_arn", notification_target_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lifecycleHookName")
    def lifecycle_hook_name(self) -> str:
        """
        The name of the lifecycle hook.
        """
        return pulumi.get(self, "lifecycle_hook_name")

    @property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> str:
        """
        The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
          +  To create a lifecycle hook for scale-out events, specify ``autoscaling:EC2_INSTANCE_LAUNCHING``.
          +  To create a lifecycle hook for scale-in events, specify ``autoscaling:EC2_INSTANCE_TERMINATING``.
        """
        return pulumi.get(self, "lifecycle_transition")

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[str]:
        """
        The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is ``ABANDON``.
         Valid values: ``CONTINUE`` | ``ABANDON``
        """
        return pulumi.get(self, "default_result")

    @property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[int]:
        """
        The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from ``30`` to ``7200`` seconds. The default value is ``3600`` seconds (1 hour).
        """
        return pulumi.get(self, "heartbeat_timeout")

    @property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[str]:
        """
        Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @property
    @pulumi.getter(name="notificationTargetArn")
    def notification_target_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook. You can specify an Amazon SNS topic or an Amazon SQS queue.
        """
        return pulumi.get(self, "notification_target_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target. For information about creating this role, see [Prepare to add a lifecycle hook to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/prepare-for-lifecycle-notifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AutoScalingGroupMemoryGiBPerVCpuRequest(dict):
    """
    ``MemoryGiBPerVCpuRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum amount of memory per vCPU for an instance type, in GiB.
    """
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        ``MemoryGiBPerVCpuRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum amount of memory per vCPU for an instance type, in GiB.
        :param float max: The memory maximum in GiB.
        :param float min: The memory minimum in GiB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        The memory maximum in GiB.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        The memory minimum in GiB.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupMemoryMiBRequest(dict):
    """
    ``MemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum instance memory size for an instance type, in MiB.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        ``MemoryMiBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum instance memory size for an instance type, in MiB.
        :param int max: The memory maximum in MiB.
        :param int min: The memory minimum in MiB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The memory maximum in MiB.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The memory minimum in MiB.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupMetricsCollection(dict):
    """
    ``MetricsCollection`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource that describes the group metrics that an Amazon EC2 Auto Scaling group sends to Amazon CloudWatch. These metrics describe the group rather than any of its instances. 
     For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
    """
    def __init__(__self__, *,
                 granularity: str,
                 metrics: Optional[Sequence[str]] = None):
        """
        ``MetricsCollection`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource that describes the group metrics that an Amazon EC2 Auto Scaling group sends to Amazon CloudWatch. These metrics describe the group rather than any of its instances. 
         For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
        :param str granularity: The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is ``1Minute``.
        :param Sequence[str] metrics: Identifies the metrics to enable.
                You can specify one or more of the following metrics:
                 +   ``GroupMinSize`` 
                 +   ``GroupMaxSize`` 
                 +   ``GroupDesiredCapacity`` 
                 +   ``GroupInServiceInstances`` 
                 +   ``GroupPendingInstances`` 
                 +   ``GroupStandbyInstances`` 
                 +   ``GroupTerminatingInstances`` 
                 +   ``GroupTotalInstances`` 
                 +   ``GroupInServiceCapacity`` 
                 +   ``GroupPendingCapacity`` 
                 +   ``GroupStandbyCapacity`` 
                 +   ``GroupTerminatingCapacity`` 
                 +   ``GroupTotalCapacity`` 
                 +   ``WarmPoolDesiredCapacity`` 
                 +   ``WarmPoolWarmedCapacity`` 
                 +   ``WarmPoolPendingCapacity`` 
                 +   ``WarmPoolTerminatingCapacity`` 
                 +   ``WarmPoolTotalCapacity`` 
                 +   ``GroupAndWarmPoolDesiredCapacity`` 
                 +   ``GroupAndWarmPoolTotalCapacity`` 
                 
                If you specify ``Granularity`` and don't specify any metrics, all metrics are enabled.
                For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        pulumi.set(__self__, "granularity", granularity)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def granularity(self) -> str:
        """
        The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is ``1Minute``.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence[str]]:
        """
        Identifies the metrics to enable.
         You can specify one or more of the following metrics:
          +   ``GroupMinSize`` 
          +   ``GroupMaxSize`` 
          +   ``GroupDesiredCapacity`` 
          +   ``GroupInServiceInstances`` 
          +   ``GroupPendingInstances`` 
          +   ``GroupStandbyInstances`` 
          +   ``GroupTerminatingInstances`` 
          +   ``GroupTotalInstances`` 
          +   ``GroupInServiceCapacity`` 
          +   ``GroupPendingCapacity`` 
          +   ``GroupStandbyCapacity`` 
          +   ``GroupTerminatingCapacity`` 
          +   ``GroupTotalCapacity`` 
          +   ``WarmPoolDesiredCapacity`` 
          +   ``WarmPoolWarmedCapacity`` 
          +   ``WarmPoolPendingCapacity`` 
          +   ``WarmPoolTerminatingCapacity`` 
          +   ``WarmPoolTotalCapacity`` 
          +   ``GroupAndWarmPoolDesiredCapacity`` 
          +   ``GroupAndWarmPoolTotalCapacity`` 
          
         If you specify ``Granularity`` and don't specify any metrics, all metrics are enabled.
         For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class AutoScalingGroupMixedInstancesPolicy(dict):
    """
    Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
     A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
     You can create a mixed instances policy for new and existing Auto Scaling groups. You must use a launch template to configure the policy. You cannot use a launch configuration.
     There are key differences between Spot Instances and On-Demand Instances:
      +  The price for Spot Instances varies based on demand
      +  Amazon EC2 can terminate an individual Spot Instance as the availability of, or price for, Spot Instances changes
      
     When a Spot Instance is terminated, Amazon EC2 Auto Scaling group attempts to launch a replacement instance to maintain the desired capacity for the group. 
      ``MixedInstancesPolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplate":
            suggest = "launch_template"
        elif key == "instancesDistribution":
            suggest = "instances_distribution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupMixedInstancesPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupMixedInstancesPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupMixedInstancesPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template: 'outputs.AutoScalingGroupLaunchTemplate',
                 instances_distribution: Optional['outputs.AutoScalingGroupInstancesDistribution'] = None):
        """
        Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
         A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
         You can create a mixed instances policy for new and existing Auto Scaling groups. You must use a launch template to configure the policy. You cannot use a launch configuration.
         There are key differences between Spot Instances and On-Demand Instances:
          +  The price for Spot Instances varies based on demand
          +  Amazon EC2 can terminate an individual Spot Instance as the availability of, or price for, Spot Instances changes
          
         When a Spot Instance is terminated, Amazon EC2 Auto Scaling group attempts to launch a replacement instance to maintain the desired capacity for the group. 
          ``MixedInstancesPolicy`` is a property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
        :param 'AutoScalingGroupLaunchTemplate' launch_template: One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
        :param 'AutoScalingGroupInstancesDistribution' instances_distribution: The instances distribution.
        """
        pulumi.set(__self__, "launch_template", launch_template)
        if instances_distribution is not None:
            pulumi.set(__self__, "instances_distribution", instances_distribution)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> 'outputs.AutoScalingGroupLaunchTemplate':
        """
        One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="instancesDistribution")
    def instances_distribution(self) -> Optional['outputs.AutoScalingGroupInstancesDistribution']:
        """
        The instances distribution.
        """
        return pulumi.get(self, "instances_distribution")


@pulumi.output_type
class AutoScalingGroupNetworkBandwidthGbpsRequest(dict):
    """
    ``NetworkBandwidthGbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum network bandwidth for an instance type, in Gbps.
      Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see [Available instance bandwidth](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth) in the *Amazon EC2 User Guide for Linux Instances*.
    """
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        ``NetworkBandwidthGbpsRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum network bandwidth for an instance type, in Gbps.
          Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see [Available instance bandwidth](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth) in the *Amazon EC2 User Guide for Linux Instances*.
        :param float max: The maximum amount of network bandwidth, in gigabits per second (Gbps).
        :param float min: The minimum amount of network bandwidth, in gigabits per second (Gbps).
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        The maximum amount of network bandwidth, in gigabits per second (Gbps).
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        The minimum amount of network bandwidth, in gigabits per second (Gbps).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupNetworkInterfaceCountRequest(dict):
    """
    ``NetworkInterfaceCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of network interfaces for an instance type.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        ``NetworkInterfaceCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of network interfaces for an instance type.
        :param int max: The maximum number of network interfaces.
        :param int min: The minimum number of network interfaces.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The maximum number of network interfaces.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The minimum number of network interfaces.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupNotificationConfiguration(dict):
    """
    A structure that specifies an Amazon SNS notification configuration for the ``NotificationConfigurations`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
     For an example template snippet, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
     For more information, see [Get Amazon SNS notifications when your Auto Scaling group scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"
        elif key == "notificationTypes":
            suggest = "notification_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_arn: Sequence[str],
                 notification_types: Optional[Sequence[str]] = None):
        """
        A structure that specifies an Amazon SNS notification configuration for the ``NotificationConfigurations`` property of the [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For an example template snippet, see [Configure Amazon EC2 Auto Scaling resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-ec2-auto-scaling.html).
         For more information, see [Get Amazon SNS notifications when your Auto Scaling group scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param Sequence[str] topic_arn: The Amazon Resource Name (ARN) of the Amazon SNS topic.
        :param Sequence[str] notification_types: A list of event types that send a notification. Event types can include any of the following types. 
                 *Allowed values*:
                 +   ``autoscaling:EC2_INSTANCE_LAUNCH`` 
                 +   ``autoscaling:EC2_INSTANCE_LAUNCH_ERROR`` 
                 +   ``autoscaling:EC2_INSTANCE_TERMINATE`` 
                 +   ``autoscaling:EC2_INSTANCE_TERMINATE_ERROR`` 
                 +   ``autoscaling:TEST_NOTIFICATION``
        """
        pulumi.set(__self__, "topic_arn", topic_arn)
        if notification_types is not None:
            pulumi.set(__self__, "notification_types", notification_types)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Sequence[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic.
        """
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="notificationTypes")
    def notification_types(self) -> Optional[Sequence[str]]:
        """
        A list of event types that send a notification. Event types can include any of the following types. 
          *Allowed values*:
          +   ``autoscaling:EC2_INSTANCE_LAUNCH`` 
          +   ``autoscaling:EC2_INSTANCE_LAUNCH_ERROR`` 
          +   ``autoscaling:EC2_INSTANCE_TERMINATE`` 
          +   ``autoscaling:EC2_INSTANCE_TERMINATE_ERROR`` 
          +   ``autoscaling:TEST_NOTIFICATION``
        """
        return pulumi.get(self, "notification_types")


@pulumi.output_type
class AutoScalingGroupTagProperty(dict):
    """
    A structure that specifies a tag for the ``Tags`` property of [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
     For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
     CloudFormation adds the following tags to all Auto Scaling groups and associated instances: 
      +  aws:cloudformation:stack-name
      +  aws:cloudformation:stack-id
      +  aws:cloudformation:logical-id
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propagateAtLaunch":
            suggest = "propagate_at_launch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupTagProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupTagProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupTagProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 propagate_at_launch: bool,
                 value: str):
        """
        A structure that specifies a tag for the ``Tags`` property of [AWS::AutoScaling::AutoScalingGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html) resource.
         For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*. You can find a sample template snippet in the [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-autoscalinggroup.html#aws-resource-autoscaling-autoscalinggroup--examples) section of the ``AWS::AutoScaling::AutoScalingGroup`` resource.
         CloudFormation adds the following tags to all Auto Scaling groups and associated instances: 
          +  aws:cloudformation:stack-name
          +  aws:cloudformation:stack-id
          +  aws:cloudformation:logical-id
        :param str key: The tag key.
        :param bool propagate_at_launch: Set to ``true`` if you want CloudFormation to copy the tag to EC2 instances that are launched as part of the Auto Scaling group. Set to ``false`` if you want the tag attached only to the Auto Scaling group and not copied to any instances launched as part of the Auto Scaling group.
        :param str value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "propagate_at_launch", propagate_at_launch)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="propagateAtLaunch")
    def propagate_at_launch(self) -> bool:
        """
        Set to ``true`` if you want CloudFormation to copy the tag to EC2 instances that are launched as part of the Auto Scaling group. Set to ``false`` if you want the tag attached only to the Auto Scaling group and not copied to any instances launched as part of the Auto Scaling group.
        """
        return pulumi.get(self, "propagate_at_launch")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AutoScalingGroupTotalLocalStorageGbRequest(dict):
    """
    ``TotalLocalStorageGBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total local storage size for an instance type, in GB.
    """
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        ``TotalLocalStorageGBRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum total local storage size for an instance type, in GB.
        :param float max: The storage maximum in GB.
        :param float min: The storage minimum in GB.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        The storage maximum in GB.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        The storage minimum in GB.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingGroupVCpuCountRequest(dict):
    """
    ``VCpuCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of vCPUs for an instance type.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        ``VCpuCountRequest`` is a property of the ``InstanceRequirements`` property of the [AWS::AutoScaling::AutoScalingGroup LaunchTemplateOverrides](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplateoverrides.html) property type that describes the minimum and maximum number of vCPUs for an instance type.
        :param int max: The maximum number of vCPUs.
        :param int min: The minimum number of vCPUs.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The maximum number of vCPUs.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The minimum number of vCPUs.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class LaunchConfigurationBlockDevice(dict):
    """
    BlockDevice is a subproperty of BlockDeviceMapping that describes an Amazon EBS volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchConfigurationBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchConfigurationBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchConfigurationBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 snapshot_id: Optional[str] = None,
                 throughput: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        """
        BlockDevice is a subproperty of BlockDeviceMapping that describes an Amazon EBS volume.
        :param bool delete_on_termination: Indicates whether the volume is deleted on instance termination. 
        :param bool encrypted: Specifies whether the volume should be encrypted. 
        :param int iops: The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        :param str snapshot_id: The snapshot ID of the volume to use.
        :param int throughput: The throughput (MiBps) to provision for a gp3 volume.
        :param int volume_size: The volume size, in GiBs.
        :param str volume_type: The volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Indicates whether the volume is deleted on instance termination. 
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Specifies whether the volume should be encrypted. 
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot ID of the volume to use.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        The throughput (MiBps) to provision for a gp3 volume.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        The volume size, in GiBs.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        The volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class LaunchConfigurationBlockDeviceMapping(dict):
    """
    BlockDeviceMapping is a property of AWS::AutoScaling::LaunchConfiguration that describes a block device mapping for an Auto Scaling group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchConfigurationBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchConfigurationBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchConfigurationBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 ebs: Optional['outputs.LaunchConfigurationBlockDevice'] = None,
                 no_device: Optional[bool] = None,
                 virtual_name: Optional[str] = None):
        """
        BlockDeviceMapping is a property of AWS::AutoScaling::LaunchConfiguration that describes a block device mapping for an Auto Scaling group.
        :param str device_name: The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        :param 'LaunchConfigurationBlockDevice' ebs: Parameters used to automatically set up EBS volumes when an instance is launched.
        :param bool no_device: Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        :param str virtual_name: The name of the virtual device.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.LaunchConfigurationBlockDevice']:
        """
        Parameters used to automatically set up EBS volumes when an instance is launched.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[bool]:
        """
        Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[str]:
        """
        The name of the virtual device.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class LaunchConfigurationMetadataOptions(dict):
    """
    MetadataOptions is a property of AWS::AutoScaling::LaunchConfiguration that describes metadata options for the instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"
        elif key == "httpTokens":
            suggest = "http_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchConfigurationMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchConfigurationMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchConfigurationMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_endpoint: Optional[str] = None,
                 http_put_response_hop_limit: Optional[int] = None,
                 http_tokens: Optional[str] = None):
        """
        MetadataOptions is a property of AWS::AutoScaling::LaunchConfiguration that describes metadata options for the instances.
        :param str http_endpoint: This parameter enables or disables the HTTP metadata endpoint on your instances.
        :param int http_put_response_hop_limit: The desired HTTP PUT response hop limit for instance metadata requests.
        :param str http_tokens: The state of token usage for your instance metadata requests.
        """
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[str]:
        """
        This parameter enables or disables the HTTP metadata endpoint on your instances.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[int]:
        """
        The desired HTTP PUT response hop limit for instance metadata requests.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[str]:
        """
        The state of token usage for your instance metadata requests.
        """
        return pulumi.get(self, "http_tokens")


@pulumi.output_type
class ScalingPolicyCustomizedMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyCustomizedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyCustomizedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyCustomizedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.ScalingPolicyMetricDimension']] = None,
                 metric_name: Optional[str] = None,
                 metrics: Optional[Sequence['outputs.ScalingPolicyTargetTrackingMetricDataQuery']] = None,
                 namespace: Optional[str] = None,
                 statistic: Optional[str] = None,
                 unit: Optional[str] = None):
        """
        :param Sequence['ScalingPolicyMetricDimension'] dimensions: The dimensions of the metric.
               
               Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        :param str metric_name: The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        :param Sequence['ScalingPolicyTargetTrackingMetricDataQuery'] metrics: The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        :param str namespace: The namespace of the metric.
        :param str statistic: The statistic of the metric.
        :param str unit: The unit of the metric. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScalingPolicyMetricDimension']]:
        """
        The dimensions of the metric.

        Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ScalingPolicyTargetTrackingMetricDataQuery']]:
        """
        The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        The statistic of the metric.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit of the metric. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPolicyMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 dimensions: Optional[Sequence['outputs.ScalingPolicyMetricDimension']] = None):
        """
        :param str metric_name: The name of the metric.
        :param str namespace: The namespace of the metric. For more information, see the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
        :param Sequence['ScalingPolicyMetricDimension'] dimensions: The dimensions for the metric. For the list of available dimensions, see the AWS documentation available from the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
               
               Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the metric. For more information, see the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScalingPolicyMetricDimension']]:
        """
        The dimensions for the metric. For the list of available dimensions, see the AWS documentation available from the table in [AWS services that publish CloudWatch metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html) in the *Amazon CloudWatch User Guide* .

        Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class ScalingPolicyMetricDataQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricStat":
            suggest = "metric_stat"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyMetricDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyMetricDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyMetricDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 expression: Optional[str] = None,
                 label: Optional[str] = None,
                 metric_stat: Optional['outputs.ScalingPolicyMetricStat'] = None,
                 return_data: Optional[bool] = None):
        """
        :param str id: A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        :param str expression: The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.
               
               Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param str label: A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        :param 'ScalingPolicyMetricStat' metric_stat: Information about the metric data to return.
               
               Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param bool return_data: Indicates whether to return the timestamps and raw data values of this metric.
               
               If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.
               
               If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        pulumi.set(__self__, "id", id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.

        Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional['outputs.ScalingPolicyMetricStat']:
        """
        Information about the metric data to return.

        Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "metric_stat")

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[bool]:
        """
        Indicates whether to return the timestamps and raw data values of this metric.

        If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.

        If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class ScalingPolicyMetricDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the dimension.
        :param str value: The value of the dimension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScalingPolicyMetricStat(dict):
    def __init__(__self__, *,
                 metric: 'outputs.ScalingPolicyMetric',
                 stat: str,
                 unit: Optional[str] = None):
        """
        :param 'ScalingPolicyMetric' metric: The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        :param str stat: The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .
               
               The most commonly used metrics for predictive scaling are `Average` and `Sum` .
        :param str unit: The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.ScalingPolicyMetric':
        """
        The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric name, namespace, and dimensions, inspect the [Metric](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html) object that is returned by a call to [ListMetrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html) .
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def stat(self) -> str:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .

        The most commonly used metrics for predictive scaling are `Average` and `Sum` .
        """
        return pulumi.get(self, "stat")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPolicyPredefinedMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredefinedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredefinedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredefinedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        """
        :param str predefined_metric_type: The metric type. The following predefined metrics are available:
               
               - `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
               - `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
               - `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
               - `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        The metric type. The following predefined metrics are available:

        - `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
        - `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
        - `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
        - `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyPredictiveScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricSpecifications":
            suggest = "metric_specifications"
        elif key == "maxCapacityBreachBehavior":
            suggest = "max_capacity_breach_behavior"
        elif key == "maxCapacityBuffer":
            suggest = "max_capacity_buffer"
        elif key == "schedulingBufferTime":
            suggest = "scheduling_buffer_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_specifications: Sequence['outputs.ScalingPolicyPredictiveScalingMetricSpecification'],
                 max_capacity_breach_behavior: Optional[str] = None,
                 max_capacity_buffer: Optional[int] = None,
                 mode: Optional[str] = None,
                 scheduling_buffer_time: Optional[int] = None):
        """
        :param Sequence['ScalingPolicyPredictiveScalingMetricSpecification'] metric_specifications: This structure includes the metrics and target utilization to use for predictive scaling.
               
               This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
        :param str max_capacity_breach_behavior: Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.
               
               The following are possible values:
               
               - `HonorMaxCapacity` - Amazon EC2 Auto Scaling can't increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity.
               - `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer` .
               
               > Use caution when allowing the maximum capacity to be automatically increased. This can lead to more instances being launched than intended if the increased maximum capacity is not monitored and managed. The increased maximum capacity then becomes the new normal maximum capacity for the Auto Scaling group until you manually update it. The maximum capacity does not automatically decrease back to the original maximum.
        :param int max_capacity_buffer: The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
               
               If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
               
               Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity` , and cannot be used otherwise.
        :param str mode: The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
        :param int scheduling_buffer_time: The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
               
               The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
        """
        pulumi.set(__self__, "metric_specifications", metric_specifications)
        if max_capacity_breach_behavior is not None:
            pulumi.set(__self__, "max_capacity_breach_behavior", max_capacity_breach_behavior)
        if max_capacity_buffer is not None:
            pulumi.set(__self__, "max_capacity_buffer", max_capacity_buffer)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if scheduling_buffer_time is not None:
            pulumi.set(__self__, "scheduling_buffer_time", scheduling_buffer_time)

    @property
    @pulumi.getter(name="metricSpecifications")
    def metric_specifications(self) -> Sequence['outputs.ScalingPolicyPredictiveScalingMetricSpecification']:
        """
        This structure includes the metrics and target utilization to use for predictive scaling.

        This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
        """
        return pulumi.get(self, "metric_specifications")

    @property
    @pulumi.getter(name="maxCapacityBreachBehavior")
    def max_capacity_breach_behavior(self) -> Optional[str]:
        """
        Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.

        The following are possible values:

        - `HonorMaxCapacity` - Amazon EC2 Auto Scaling can't increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity.
        - `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can increase the maximum capacity of the group when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer` .

        > Use caution when allowing the maximum capacity to be automatically increased. This can lead to more instances being launched than intended if the increased maximum capacity is not monitored and managed. The increased maximum capacity then becomes the new normal maximum capacity for the Auto Scaling group until you manually update it. The maximum capacity does not automatically decrease back to the original maximum.
        """
        return pulumi.get(self, "max_capacity_breach_behavior")

    @property
    @pulumi.getter(name="maxCapacityBuffer")
    def max_capacity_buffer(self) -> Optional[int]:
        """
        The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.

        If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.

        Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity` , and cannot be used otherwise.
        """
        return pulumi.get(self, "max_capacity_buffer")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="schedulingBufferTime")
    def scheduling_buffer_time(self) -> Optional[int]:
        """
        The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.

        The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
        """
        return pulumi.get(self, "scheduling_buffer_time")


@pulumi.output_type
class ScalingPolicyPredictiveScalingCustomizedCapacityMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricDataQueries":
            suggest = "metric_data_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingCustomizedCapacityMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingCustomizedCapacityMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingCustomizedCapacityMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_data_queries: Sequence['outputs.ScalingPolicyMetricDataQuery']):
        """
        :param Sequence['ScalingPolicyMetricDataQuery'] metric_data_queries: One or more metric data queries to provide the data points for a capacity metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> Sequence['outputs.ScalingPolicyMetricDataQuery']:
        """
        One or more metric data queries to provide the data points for a capacity metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        return pulumi.get(self, "metric_data_queries")


@pulumi.output_type
class ScalingPolicyPredictiveScalingCustomizedLoadMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricDataQueries":
            suggest = "metric_data_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingCustomizedLoadMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingCustomizedLoadMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingCustomizedLoadMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_data_queries: Sequence['outputs.ScalingPolicyMetricDataQuery']):
        """
        :param Sequence['ScalingPolicyMetricDataQuery'] metric_data_queries: One or more metric data queries to provide the data points for a load metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> Sequence['outputs.ScalingPolicyMetricDataQuery']:
        """
        One or more metric data queries to provide the data points for a load metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        return pulumi.get(self, "metric_data_queries")


@pulumi.output_type
class ScalingPolicyPredictiveScalingCustomizedScalingMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricDataQueries":
            suggest = "metric_data_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingCustomizedScalingMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingCustomizedScalingMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingCustomizedScalingMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_data_queries: Sequence['outputs.ScalingPolicyMetricDataQuery']):
        """
        :param Sequence['ScalingPolicyMetricDataQuery'] metric_data_queries: One or more metric data queries to provide the data points for a scaling metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        pulumi.set(__self__, "metric_data_queries", metric_data_queries)

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> Sequence['outputs.ScalingPolicyMetricDataQuery']:
        """
        One or more metric data queries to provide the data points for a scaling metric. Use multiple metric data queries only if you are performing a math expression on returned data.
        """
        return pulumi.get(self, "metric_data_queries")


@pulumi.output_type
class ScalingPolicyPredictiveScalingMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "customizedCapacityMetricSpecification":
            suggest = "customized_capacity_metric_specification"
        elif key == "customizedLoadMetricSpecification":
            suggest = "customized_load_metric_specification"
        elif key == "customizedScalingMetricSpecification":
            suggest = "customized_scaling_metric_specification"
        elif key == "predefinedLoadMetricSpecification":
            suggest = "predefined_load_metric_specification"
        elif key == "predefinedMetricPairSpecification":
            suggest = "predefined_metric_pair_specification"
        elif key == "predefinedScalingMetricSpecification":
            suggest = "predefined_scaling_metric_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 customized_capacity_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingCustomizedCapacityMetric'] = None,
                 customized_load_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingCustomizedLoadMetric'] = None,
                 customized_scaling_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingCustomizedScalingMetric'] = None,
                 predefined_load_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingPredefinedLoadMetric'] = None,
                 predefined_metric_pair_specification: Optional['outputs.ScalingPolicyPredictiveScalingPredefinedMetricPair'] = None,
                 predefined_scaling_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingPredefinedScalingMetric'] = None):
        """
        :param float target_value: Specifies the target utilization.
               
               > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        :param 'ScalingPolicyPredictiveScalingCustomizedCapacityMetric' customized_capacity_metric_specification: The customized capacity metric specification.
        :param 'ScalingPolicyPredictiveScalingCustomizedLoadMetric' customized_load_metric_specification: The customized load metric specification.
        :param 'ScalingPolicyPredictiveScalingCustomizedScalingMetric' customized_scaling_metric_specification: The customized scaling metric specification.
        :param 'ScalingPolicyPredictiveScalingPredefinedLoadMetric' predefined_load_metric_specification: The predefined load metric specification.
        :param 'ScalingPolicyPredictiveScalingPredefinedMetricPair' predefined_metric_pair_specification: The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        :param 'ScalingPolicyPredictiveScalingPredefinedScalingMetric' predefined_scaling_metric_specification: The predefined scaling metric specification.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_capacity_metric_specification is not None:
            pulumi.set(__self__, "customized_capacity_metric_specification", customized_capacity_metric_specification)
        if customized_load_metric_specification is not None:
            pulumi.set(__self__, "customized_load_metric_specification", customized_load_metric_specification)
        if customized_scaling_metric_specification is not None:
            pulumi.set(__self__, "customized_scaling_metric_specification", customized_scaling_metric_specification)
        if predefined_load_metric_specification is not None:
            pulumi.set(__self__, "predefined_load_metric_specification", predefined_load_metric_specification)
        if predefined_metric_pair_specification is not None:
            pulumi.set(__self__, "predefined_metric_pair_specification", predefined_metric_pair_specification)
        if predefined_scaling_metric_specification is not None:
            pulumi.set(__self__, "predefined_scaling_metric_specification", predefined_scaling_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        Specifies the target utilization.

        > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="customizedCapacityMetricSpecification")
    def customized_capacity_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingCustomizedCapacityMetric']:
        """
        The customized capacity metric specification.
        """
        return pulumi.get(self, "customized_capacity_metric_specification")

    @property
    @pulumi.getter(name="customizedLoadMetricSpecification")
    def customized_load_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingCustomizedLoadMetric']:
        """
        The customized load metric specification.
        """
        return pulumi.get(self, "customized_load_metric_specification")

    @property
    @pulumi.getter(name="customizedScalingMetricSpecification")
    def customized_scaling_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingCustomizedScalingMetric']:
        """
        The customized scaling metric specification.
        """
        return pulumi.get(self, "customized_scaling_metric_specification")

    @property
    @pulumi.getter(name="predefinedLoadMetricSpecification")
    def predefined_load_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingPredefinedLoadMetric']:
        """
        The predefined load metric specification.
        """
        return pulumi.get(self, "predefined_load_metric_specification")

    @property
    @pulumi.getter(name="predefinedMetricPairSpecification")
    def predefined_metric_pair_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingPredefinedMetricPair']:
        """
        The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        """
        return pulumi.get(self, "predefined_metric_pair_specification")

    @property
    @pulumi.getter(name="predefinedScalingMetricSpecification")
    def predefined_scaling_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingPredefinedScalingMetric']:
        """
        The predefined scaling metric specification.
        """
        return pulumi.get(self, "predefined_scaling_metric_specification")


@pulumi.output_type
class ScalingPolicyPredictiveScalingPredefinedLoadMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingPredefinedLoadMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingPredefinedLoadMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingPredefinedLoadMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        """
        :param str predefined_metric_type: The metric type.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        The metric type.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyPredictiveScalingPredefinedMetricPair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingPredefinedMetricPair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingPredefinedMetricPair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingPredefinedMetricPair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        """
        :param str predefined_metric_type: Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization` , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization` , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyPredictiveScalingPredefinedScalingMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingPredefinedScalingMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingPredefinedScalingMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingPredefinedScalingMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        """
        :param str predefined_metric_type: The metric type.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
               
               You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
               
               `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .
               
               Where:
               
               - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
               - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
               
               To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        The metric type.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.

        You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:

        `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff` .

        Where:

        - app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
        - targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.

        To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyStepAdjustment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "metricIntervalLowerBound":
            suggest = "metric_interval_lower_bound"
        elif key == "metricIntervalUpperBound":
            suggest = "metric_interval_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyStepAdjustment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyStepAdjustment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyStepAdjustment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scaling_adjustment: int,
                 metric_interval_lower_bound: Optional[float] = None,
                 metric_interval_upper_bound: Optional[float] = None):
        """
        :param int scaling_adjustment: The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a non-negative value.
        :param float metric_interval_lower_bound: The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        :param float metric_interval_upper_bound: The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
               
               The upper bound must be greater than the lower bound.
        """
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> int:
        """
        The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a non-negative value.
        """
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[float]:
        """
        The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[float]:
        """
        The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.

        The upper bound must be greater than the lower bound.
        """
        return pulumi.get(self, "metric_interval_upper_bound")


@pulumi.output_type
class ScalingPolicyTargetTrackingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "customizedMetricSpecification":
            suggest = "customized_metric_specification"
        elif key == "disableScaleIn":
            suggest = "disable_scale_in"
        elif key == "predefinedMetricSpecification":
            suggest = "predefined_metric_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 customized_metric_specification: Optional['outputs.ScalingPolicyCustomizedMetricSpecification'] = None,
                 disable_scale_in: Optional[bool] = None,
                 predefined_metric_specification: Optional['outputs.ScalingPolicyPredefinedMetricSpecification'] = None):
        """
        :param float target_value: The target value for the metric.
               
               > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        :param 'ScalingPolicyCustomizedMetricSpecification' customized_metric_specification: A customized metric. You must specify either a predefined metric or a customized metric.
        :param bool disable_scale_in: Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false` .
        :param 'ScalingPolicyPredefinedMetricSpecification' predefined_metric_specification: A predefined metric. You must specify either a predefined metric or a customized metric.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        The target value for the metric.

        > Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional['outputs.ScalingPolicyCustomizedMetricSpecification']:
        """
        A customized metric. You must specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "customized_metric_specification")

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[bool]:
        """
        Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false` .
        """
        return pulumi.get(self, "disable_scale_in")

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional['outputs.ScalingPolicyPredefinedMetricSpecification']:
        """
        A predefined metric. You must specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "predefined_metric_specification")


@pulumi.output_type
class ScalingPolicyTargetTrackingMetricDataQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricStat":
            suggest = "metric_stat"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyTargetTrackingMetricDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyTargetTrackingMetricDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyTargetTrackingMetricDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 expression: Optional[str] = None,
                 label: Optional[str] = None,
                 metric_stat: Optional['outputs.ScalingPolicyTargetTrackingMetricStat'] = None,
                 return_data: Optional[bool] = None):
        """
        :param str id: A short name that identifies the object's results in the response. This name must be unique among all `TargetTrackingMetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        :param str expression: The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.
               
               Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param str label: A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        :param 'ScalingPolicyTargetTrackingMetricStat' metric_stat: Information about the metric data to return.
               
               Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        :param bool return_data: Indicates whether to return the timestamps and raw data values of this metric.
               
               If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.
               
               If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        pulumi.set(__self__, "id", id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A short name that identifies the object's results in the response. This name must be unique among all `TargetTrackingMetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.

        Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional['outputs.ScalingPolicyTargetTrackingMetricStat']:
        """
        Information about the metric data to return.

        Conditional: Within each `TargetTrackingMetricDataQuery` object, you must specify either `Expression` or `MetricStat` , but not both.
        """
        return pulumi.get(self, "metric_stat")

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[bool]:
        """
        Indicates whether to return the timestamps and raw data values of this metric.

        If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.

        If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData` . This sets it to its default ( `true` ).
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class ScalingPolicyTargetTrackingMetricStat(dict):
    def __init__(__self__, *,
                 metric: 'outputs.ScalingPolicyMetric',
                 stat: str,
                 unit: Optional[str] = None):
        """
        :param 'ScalingPolicyMetric' metric: The metric to use.
        :param str stat: The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .
               
               The most commonly used metric for scaling is `Average` .
        :param str unit: The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.ScalingPolicyMetric':
        """
        The metric to use.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def stat(self) -> str:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in [Statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic) in the *Amazon CloudWatch User Guide* .

        The most commonly used metric for scaling is `Average` .
        """
        return pulumi.get(self, "stat")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the [MetricDatum](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html) data type in the *Amazon CloudWatch API Reference* .
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class WarmPoolInstanceReusePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reuseOnScaleIn":
            suggest = "reuse_on_scale_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WarmPoolInstanceReusePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WarmPoolInstanceReusePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WarmPoolInstanceReusePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reuse_on_scale_in: Optional[bool] = None):
        """
        :param bool reuse_on_scale_in: Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
        """
        if reuse_on_scale_in is not None:
            pulumi.set(__self__, "reuse_on_scale_in", reuse_on_scale_in)

    @property
    @pulumi.getter(name="reuseOnScaleIn")
    def reuse_on_scale_in(self) -> Optional[bool]:
        """
        Specifies whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
        """
        return pulumi.get(self, "reuse_on_scale_in")


