# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutoScalingGroupResult',
    'AwaitableGetAutoScalingGroupResult',
    'get_auto_scaling_group',
    'get_auto_scaling_group_output',
]

@pulumi.output_type
class GetAutoScalingGroupResult:
    def __init__(__self__, availability_zones=None, capacity_rebalance=None, context=None, cooldown=None, default_instance_warmup=None, desired_capacity=None, desired_capacity_type=None, health_check_grace_period=None, health_check_type=None, instance_maintenance_policy=None, launch_configuration_name=None, launch_template=None, lifecycle_hook_specification_list=None, load_balancer_names=None, max_instance_lifetime=None, max_size=None, metrics_collection=None, min_size=None, mixed_instances_policy=None, new_instances_protected_from_scale_in=None, notification_configuration=None, notification_configurations=None, placement_group=None, service_linked_role_arn=None, tags=None, target_group_arns=None, termination_policies=None, vpc_zone_identifier=None):
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if capacity_rebalance and not isinstance(capacity_rebalance, bool):
            raise TypeError("Expected argument 'capacity_rebalance' to be a bool")
        pulumi.set(__self__, "capacity_rebalance", capacity_rebalance)
        if context and not isinstance(context, str):
            raise TypeError("Expected argument 'context' to be a str")
        pulumi.set(__self__, "context", context)
        if cooldown and not isinstance(cooldown, str):
            raise TypeError("Expected argument 'cooldown' to be a str")
        pulumi.set(__self__, "cooldown", cooldown)
        if default_instance_warmup and not isinstance(default_instance_warmup, int):
            raise TypeError("Expected argument 'default_instance_warmup' to be a int")
        pulumi.set(__self__, "default_instance_warmup", default_instance_warmup)
        if desired_capacity and not isinstance(desired_capacity, str):
            raise TypeError("Expected argument 'desired_capacity' to be a str")
        pulumi.set(__self__, "desired_capacity", desired_capacity)
        if desired_capacity_type and not isinstance(desired_capacity_type, str):
            raise TypeError("Expected argument 'desired_capacity_type' to be a str")
        pulumi.set(__self__, "desired_capacity_type", desired_capacity_type)
        if health_check_grace_period and not isinstance(health_check_grace_period, int):
            raise TypeError("Expected argument 'health_check_grace_period' to be a int")
        pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type and not isinstance(health_check_type, str):
            raise TypeError("Expected argument 'health_check_type' to be a str")
        pulumi.set(__self__, "health_check_type", health_check_type)
        if instance_maintenance_policy and not isinstance(instance_maintenance_policy, dict):
            raise TypeError("Expected argument 'instance_maintenance_policy' to be a dict")
        pulumi.set(__self__, "instance_maintenance_policy", instance_maintenance_policy)
        if launch_configuration_name and not isinstance(launch_configuration_name, str):
            raise TypeError("Expected argument 'launch_configuration_name' to be a str")
        pulumi.set(__self__, "launch_configuration_name", launch_configuration_name)
        if launch_template and not isinstance(launch_template, dict):
            raise TypeError("Expected argument 'launch_template' to be a dict")
        pulumi.set(__self__, "launch_template", launch_template)
        if lifecycle_hook_specification_list and not isinstance(lifecycle_hook_specification_list, list):
            raise TypeError("Expected argument 'lifecycle_hook_specification_list' to be a list")
        pulumi.set(__self__, "lifecycle_hook_specification_list", lifecycle_hook_specification_list)
        if load_balancer_names and not isinstance(load_balancer_names, list):
            raise TypeError("Expected argument 'load_balancer_names' to be a list")
        pulumi.set(__self__, "load_balancer_names", load_balancer_names)
        if max_instance_lifetime and not isinstance(max_instance_lifetime, int):
            raise TypeError("Expected argument 'max_instance_lifetime' to be a int")
        pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        if max_size and not isinstance(max_size, str):
            raise TypeError("Expected argument 'max_size' to be a str")
        pulumi.set(__self__, "max_size", max_size)
        if metrics_collection and not isinstance(metrics_collection, list):
            raise TypeError("Expected argument 'metrics_collection' to be a list")
        pulumi.set(__self__, "metrics_collection", metrics_collection)
        if min_size and not isinstance(min_size, str):
            raise TypeError("Expected argument 'min_size' to be a str")
        pulumi.set(__self__, "min_size", min_size)
        if mixed_instances_policy and not isinstance(mixed_instances_policy, dict):
            raise TypeError("Expected argument 'mixed_instances_policy' to be a dict")
        pulumi.set(__self__, "mixed_instances_policy", mixed_instances_policy)
        if new_instances_protected_from_scale_in and not isinstance(new_instances_protected_from_scale_in, bool):
            raise TypeError("Expected argument 'new_instances_protected_from_scale_in' to be a bool")
        pulumi.set(__self__, "new_instances_protected_from_scale_in", new_instances_protected_from_scale_in)
        if notification_configuration and not isinstance(notification_configuration, dict):
            raise TypeError("Expected argument 'notification_configuration' to be a dict")
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        if notification_configurations and not isinstance(notification_configurations, list):
            raise TypeError("Expected argument 'notification_configurations' to be a list")
        pulumi.set(__self__, "notification_configurations", notification_configurations)
        if placement_group and not isinstance(placement_group, str):
            raise TypeError("Expected argument 'placement_group' to be a str")
        pulumi.set(__self__, "placement_group", placement_group)
        if service_linked_role_arn and not isinstance(service_linked_role_arn, str):
            raise TypeError("Expected argument 'service_linked_role_arn' to be a str")
        pulumi.set(__self__, "service_linked_role_arn", service_linked_role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_group_arns and not isinstance(target_group_arns, list):
            raise TypeError("Expected argument 'target_group_arns' to be a list")
        pulumi.set(__self__, "target_group_arns", target_group_arns)
        if termination_policies and not isinstance(termination_policies, list):
            raise TypeError("Expected argument 'termination_policies' to be a list")
        pulumi.set(__self__, "termination_policies", termination_policies)
        if vpc_zone_identifier and not isinstance(vpc_zone_identifier, list):
            raise TypeError("Expected argument 'vpc_zone_identifier' to be a list")
        pulumi.set(__self__, "vpc_zone_identifier", vpc_zone_identifier)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[str]]:
        """
        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the ``VPCZoneIdentifier`` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="capacityRebalance")
    def capacity_rebalance(self) -> Optional[bool]:
        """
        Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "capacity_rebalance")

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[str]:
        """
        *Only needed if you use simple scaling policies.* 
         The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Default: ``300`` seconds
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter(name="defaultInstanceWarmup")
    def default_instance_warmup(self) -> Optional[int]:
        """
        The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the ``InService`` state. 
         During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
          To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify ``-1`` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of ``0`` or other nominal value.
          Default: None
        """
        return pulumi.get(self, "default_instance_warmup")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[str]:
        """
        The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure automatic scaling.
         The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
         CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="desiredCapacityType")
    def desired_capacity_type(self) -> Optional[str]:
        """
        The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports ``DesiredCapacityType`` for attribute-based instance type selection only. For more information, see [Create a mixed instances group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html) in the *Amazon EC2 Auto Scaling User Guide*.
         By default, Amazon EC2 Auto Scaling specifies ``units``, which translates into number of instances.
         Valid values: ``units`` | ``vcpu`` | ``memory-mib``
        """
        return pulumi.get(self, "desired_capacity_type")

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[int]:
        """
        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the ``InService`` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Default: ``0`` seconds
        """
        return pulumi.get(self, "health_check_grace_period")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[str]:
        """
        A comma-separated value string of one or more health check types.
         The valid values are ``EC2``, ``ELB``, and ``VPC_LATTICE``. ``EC2`` is the default health check and cannot be disabled. For more information, see [Health checks for instances in an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Only specify ``EC2`` if you must clear a value that was previously set.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="instanceMaintenancePolicy")
    def instance_maintenance_policy(self) -> Optional['outputs.AutoScalingGroupInstanceMaintenancePolicy']:
        """
        An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "instance_maintenance_policy")

    @property
    @pulumi.getter(name="launchConfigurationName")
    def launch_configuration_name(self) -> Optional[str]:
        """
        The name of the launch configuration to use to launch instances.
         Required only if you don't specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``InstanceId``.
        """
        return pulumi.get(self, "launch_configuration_name")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional['outputs.AutoScalingGroupLaunchTemplateSpecification']:
        """
        Information used to specify the launch template and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a ``MixedInstancesPolicy``. For more information about creating launch templates, see [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         If you omit this property, you must specify ``MixedInstancesPolicy``, ``LaunchConfigurationName``, or ``InstanceId``.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="lifecycleHookSpecificationList")
    def lifecycle_hook_specification_list(self) -> Optional[Sequence['outputs.AutoScalingGroupLifecycleHookSpecification']]:
        """
        One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
        """
        return pulumi.get(self, "lifecycle_hook_specification_list")

    @property
    @pulumi.getter(name="loadBalancerNames")
    def load_balancer_names(self) -> Optional[Sequence[str]]:
        """
        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the ``TargetGroupARNs`` property instead.
        """
        return pulumi.get(self, "load_balancer_names")

    @property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> Optional[int]:
        """
        The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replace Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[str]:
        """
        The maximum size of the group.
          With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above ``MaxSize`` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above ``MaxSize`` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="metricsCollection")
    def metrics_collection(self) -> Optional[Sequence['outputs.AutoScalingGroupMetricsCollection']]:
        """
        Enables the monitoring of group metrics of an Auto Scaling group. By default, these metrics are disabled.
        """
        return pulumi.get(self, "metrics_collection")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[str]:
        """
        The minimum size of the group.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="mixedInstancesPolicy")
    def mixed_instances_policy(self) -> Optional['outputs.AutoScalingGroupMixedInstancesPolicy']:
        """
        An embedded object that specifies a mixed instances policy.
         The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
         For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "mixed_instances_policy")

    @property
    @pulumi.getter(name="newInstancesProtectedFromScaleIn")
    def new_instances_protected_from_scale_in(self) -> Optional[bool]:
        """
        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Use instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "new_instances_protected_from_scale_in")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional['outputs.AutoScalingGroupNotificationConfiguration']:
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="notificationConfigurations")
    def notification_configurations(self) -> Optional[Sequence['outputs.AutoScalingGroupNotificationConfiguration']]:
        """
        Configures an Auto Scaling group to send notifications when specified events take place.
        """
        return pulumi.get(self, "notification_configurations")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[str]:
        """
        The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
          A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named ``AWSServiceRoleForAutoScaling``, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "service_linked_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.AutoScalingGroupTagProperty']]:
        """
        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[Sequence[str]]:
        """
        The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="terminationPolicies")
    def termination_policies(self) -> Optional[Sequence[str]]:
        """
        A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Configure termination policies for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Valid values: ``Default`` | ``AllocationStrategy`` | ``ClosestToNextInstanceHour`` | ``NewestInstance`` | ``OldestInstance`` | ``OldestLaunchConfiguration`` | ``OldestLaunchTemplate`` | ``arn:aws:lambda:region:account-id:function:my-function:my-alias``
        """
        return pulumi.get(self, "termination_policies")

    @property
    @pulumi.getter(name="vpcZoneIdentifier")
    def vpc_zone_identifier(self) -> Optional[Sequence[str]]:
        """
        A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
         If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the [DependsOn attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) to declare a dependency on the [VPC-gateway attachment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html).
          When you update ``VPCZoneIdentifier``, this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html).
          Required to launch instances into a nondefault VPC. If you specify ``VPCZoneIdentifier`` with ``AvailabilityZones``, the subnets that you specify for this property must reside in those Availability Zones.
        """
        return pulumi.get(self, "vpc_zone_identifier")


class AwaitableGetAutoScalingGroupResult(GetAutoScalingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutoScalingGroupResult(
            availability_zones=self.availability_zones,
            capacity_rebalance=self.capacity_rebalance,
            context=self.context,
            cooldown=self.cooldown,
            default_instance_warmup=self.default_instance_warmup,
            desired_capacity=self.desired_capacity,
            desired_capacity_type=self.desired_capacity_type,
            health_check_grace_period=self.health_check_grace_period,
            health_check_type=self.health_check_type,
            instance_maintenance_policy=self.instance_maintenance_policy,
            launch_configuration_name=self.launch_configuration_name,
            launch_template=self.launch_template,
            lifecycle_hook_specification_list=self.lifecycle_hook_specification_list,
            load_balancer_names=self.load_balancer_names,
            max_instance_lifetime=self.max_instance_lifetime,
            max_size=self.max_size,
            metrics_collection=self.metrics_collection,
            min_size=self.min_size,
            mixed_instances_policy=self.mixed_instances_policy,
            new_instances_protected_from_scale_in=self.new_instances_protected_from_scale_in,
            notification_configuration=self.notification_configuration,
            notification_configurations=self.notification_configurations,
            placement_group=self.placement_group,
            service_linked_role_arn=self.service_linked_role_arn,
            tags=self.tags,
            target_group_arns=self.target_group_arns,
            termination_policies=self.termination_policies,
            vpc_zone_identifier=self.vpc_zone_identifier)


def get_auto_scaling_group(auto_scaling_group_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutoScalingGroupResult:
    """
    The ``AWS::AutoScaling::AutoScalingGroup`` resource defines an Amazon EC2 Auto Scaling group, which is a collection of Amazon EC2 instances that are treated as a logical grouping for the purposes of automatic scaling and management.
     For more information about Amazon EC2 Auto Scaling, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html).
      Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) or a launch configuration. We strongly recommend that you do not use launch configurations. For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html) in the *Amazon EC2 Auto Scaling User Guide*.
     For help migrating from launch configurations to launch templates, see [Migrate CloudFormation stacks from launch configurations to launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/migrate-launch-configurations-with-cloudformation.html) in the *Amazon EC2 Auto Scaling User Guide*.


    :param str auto_scaling_group_name: The name of the Auto Scaling group. This name must be unique per Region per account.
            The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
             You cannot use a colon (:) in the name.
    """
    __args__ = dict()
    __args__['autoScalingGroupName'] = auto_scaling_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:autoscaling:getAutoScalingGroup', __args__, opts=opts, typ=GetAutoScalingGroupResult).value

    return AwaitableGetAutoScalingGroupResult(
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        capacity_rebalance=pulumi.get(__ret__, 'capacity_rebalance'),
        context=pulumi.get(__ret__, 'context'),
        cooldown=pulumi.get(__ret__, 'cooldown'),
        default_instance_warmup=pulumi.get(__ret__, 'default_instance_warmup'),
        desired_capacity=pulumi.get(__ret__, 'desired_capacity'),
        desired_capacity_type=pulumi.get(__ret__, 'desired_capacity_type'),
        health_check_grace_period=pulumi.get(__ret__, 'health_check_grace_period'),
        health_check_type=pulumi.get(__ret__, 'health_check_type'),
        instance_maintenance_policy=pulumi.get(__ret__, 'instance_maintenance_policy'),
        launch_configuration_name=pulumi.get(__ret__, 'launch_configuration_name'),
        launch_template=pulumi.get(__ret__, 'launch_template'),
        lifecycle_hook_specification_list=pulumi.get(__ret__, 'lifecycle_hook_specification_list'),
        load_balancer_names=pulumi.get(__ret__, 'load_balancer_names'),
        max_instance_lifetime=pulumi.get(__ret__, 'max_instance_lifetime'),
        max_size=pulumi.get(__ret__, 'max_size'),
        metrics_collection=pulumi.get(__ret__, 'metrics_collection'),
        min_size=pulumi.get(__ret__, 'min_size'),
        mixed_instances_policy=pulumi.get(__ret__, 'mixed_instances_policy'),
        new_instances_protected_from_scale_in=pulumi.get(__ret__, 'new_instances_protected_from_scale_in'),
        notification_configuration=pulumi.get(__ret__, 'notification_configuration'),
        notification_configurations=pulumi.get(__ret__, 'notification_configurations'),
        placement_group=pulumi.get(__ret__, 'placement_group'),
        service_linked_role_arn=pulumi.get(__ret__, 'service_linked_role_arn'),
        tags=pulumi.get(__ret__, 'tags'),
        target_group_arns=pulumi.get(__ret__, 'target_group_arns'),
        termination_policies=pulumi.get(__ret__, 'termination_policies'),
        vpc_zone_identifier=pulumi.get(__ret__, 'vpc_zone_identifier'))
def get_auto_scaling_group_output(auto_scaling_group_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutoScalingGroupResult]:
    """
    The ``AWS::AutoScaling::AutoScalingGroup`` resource defines an Amazon EC2 Auto Scaling group, which is a collection of Amazon EC2 instances that are treated as a logical grouping for the purposes of automatic scaling and management.
     For more information about Amazon EC2 Auto Scaling, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html).
      Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) or a launch configuration. We strongly recommend that you do not use launch configurations. For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html) in the *Amazon EC2 Auto Scaling User Guide*.
     For help migrating from launch configurations to launch templates, see [Migrate CloudFormation stacks from launch configurations to launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/migrate-launch-configurations-with-cloudformation.html) in the *Amazon EC2 Auto Scaling User Guide*.


    :param str auto_scaling_group_name: The name of the Auto Scaling group. This name must be unique per Region per account.
            The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
             You cannot use a colon (:) in the name.
    """
    __args__ = dict()
    __args__['autoScalingGroupName'] = auto_scaling_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:autoscaling:getAutoScalingGroup', __args__, opts=opts, typ=GetAutoScalingGroupResult)
    return __ret__.apply(lambda __response__: GetAutoScalingGroupResult(
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        capacity_rebalance=pulumi.get(__response__, 'capacity_rebalance'),
        context=pulumi.get(__response__, 'context'),
        cooldown=pulumi.get(__response__, 'cooldown'),
        default_instance_warmup=pulumi.get(__response__, 'default_instance_warmup'),
        desired_capacity=pulumi.get(__response__, 'desired_capacity'),
        desired_capacity_type=pulumi.get(__response__, 'desired_capacity_type'),
        health_check_grace_period=pulumi.get(__response__, 'health_check_grace_period'),
        health_check_type=pulumi.get(__response__, 'health_check_type'),
        instance_maintenance_policy=pulumi.get(__response__, 'instance_maintenance_policy'),
        launch_configuration_name=pulumi.get(__response__, 'launch_configuration_name'),
        launch_template=pulumi.get(__response__, 'launch_template'),
        lifecycle_hook_specification_list=pulumi.get(__response__, 'lifecycle_hook_specification_list'),
        load_balancer_names=pulumi.get(__response__, 'load_balancer_names'),
        max_instance_lifetime=pulumi.get(__response__, 'max_instance_lifetime'),
        max_size=pulumi.get(__response__, 'max_size'),
        metrics_collection=pulumi.get(__response__, 'metrics_collection'),
        min_size=pulumi.get(__response__, 'min_size'),
        mixed_instances_policy=pulumi.get(__response__, 'mixed_instances_policy'),
        new_instances_protected_from_scale_in=pulumi.get(__response__, 'new_instances_protected_from_scale_in'),
        notification_configuration=pulumi.get(__response__, 'notification_configuration'),
        notification_configurations=pulumi.get(__response__, 'notification_configurations'),
        placement_group=pulumi.get(__response__, 'placement_group'),
        service_linked_role_arn=pulumi.get(__response__, 'service_linked_role_arn'),
        tags=pulumi.get(__response__, 'tags'),
        target_group_arns=pulumi.get(__response__, 'target_group_arns'),
        termination_policies=pulumi.get(__response__, 'termination_policies'),
        vpc_zone_identifier=pulumi.get(__response__, 'vpc_zone_identifier')))
