# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutoScalingGroupArgs', 'AutoScalingGroup']

@pulumi.input_type
class AutoScalingGroupArgs:
    def __init__(__self__, *,
                 max_size: pulumi.Input[str],
                 min_size: pulumi.Input[str],
                 auto_scaling_group_name: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[str]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[str]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input['AutoScalingGroupInstanceMaintenancePolicyArgs']] = None,
                 launch_configuration_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']] = None,
                 lifecycle_hook_specification_list: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLifecycleHookSpecificationArgs']]]] = None,
                 load_balancer_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 metrics_collection: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupMetricsCollectionArgs']]]] = None,
                 mixed_instances_policy: Optional[pulumi.Input['AutoScalingGroupMixedInstancesPolicyArgs']] = None,
                 new_instances_protected_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 notification_configuration: Optional[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']] = None,
                 notification_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']]]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupTagPropertyArgs']]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_zone_identifier: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AutoScalingGroup resource.
        :param pulumi.Input[str] max_size: The maximum size of the group.
                 With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above ``MaxSize`` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above ``MaxSize`` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
        :param pulumi.Input[str] min_size: The minimum size of the group.
        :param pulumi.Input[str] auto_scaling_group_name: The name of the Auto Scaling group. This name must be unique per Region per account.
                The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
                 You cannot use a colon (:) in the name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the ``VPCZoneIdentifier`` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
        :param pulumi.Input[bool] capacity_rebalance: Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[str] context: Reserved.
        :param pulumi.Input[str] cooldown: *Only needed if you use simple scaling policies.* 
                The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Default: ``300`` seconds
        :param pulumi.Input[int] default_instance_warmup: The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the ``InService`` state. 
                During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
                 To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify ``-1`` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of ``0`` or other nominal value.
                 Default: None
        :param pulumi.Input[str] desired_capacity: The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure automatic scaling.
                The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
                CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
        :param pulumi.Input[str] desired_capacity_type: The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports ``DesiredCapacityType`` for attribute-based instance type selection only. For more information, see [Create a mixed instances group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html) in the *Amazon EC2 Auto Scaling User Guide*.
                By default, Amazon EC2 Auto Scaling specifies ``units``, which translates into number of instances.
                Valid values: ``units`` | ``vcpu`` | ``memory-mib``
        :param pulumi.Input[int] health_check_grace_period: The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the ``InService`` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Default: ``0`` seconds
        :param pulumi.Input[str] health_check_type: A comma-separated value string of one or more health check types.
                The valid values are ``EC2``, ``ELB``, and ``VPC_LATTICE``. ``EC2`` is the default health check and cannot be disabled. For more information, see [Health checks for instances in an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Only specify ``EC2`` if you must clear a value that was previously set.
        :param pulumi.Input[str] instance_id: The ID of the instance used to base the launch configuration on. For more information, see [Create an Auto Scaling group using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html) in the *Amazon EC2 Auto Scaling User Guide*.
                If you specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``LaunchConfigurationName``, don't specify ``InstanceId``.
        :param pulumi.Input['AutoScalingGroupInstanceMaintenancePolicyArgs'] instance_maintenance_policy: An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[str] launch_configuration_name: The name of the launch configuration to use to launch instances.
                Required only if you don't specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``InstanceId``.
        :param pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs'] launch_template: Information used to specify the launch template and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a ``MixedInstancesPolicy``. For more information about creating launch templates, see [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
                If you omit this property, you must specify ``MixedInstancesPolicy``, ``LaunchConfigurationName``, or ``InstanceId``.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLifecycleHookSpecificationArgs']]] lifecycle_hook_specification_list: One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancer_names: A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the ``TargetGroupARNs`` property instead.
        :param pulumi.Input[int] max_instance_lifetime: The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replace Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupMetricsCollectionArgs']]] metrics_collection: Enables the monitoring of group metrics of an Auto Scaling group. By default, these metrics are disabled.
        :param pulumi.Input['AutoScalingGroupMixedInstancesPolicyArgs'] mixed_instances_policy: An embedded object that specifies a mixed instances policy.
                The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
                For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[bool] new_instances_protected_from_scale_in: Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Use instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']]] notification_configurations: Configures an Auto Scaling group to send notifications when specified events take place.
        :param pulumi.Input[str] placement_group: The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
                 A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
        :param pulumi.Input[str] service_linked_role_arn: The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named ``AWSServiceRoleForAutoScaling``, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupTagPropertyArgs']]] tags: One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_group_arns: The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] termination_policies: A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Configure termination policies for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Valid values: ``Default`` | ``AllocationStrategy`` | ``ClosestToNextInstanceHour`` | ``NewestInstance`` | ``OldestInstance`` | ``OldestLaunchConfiguration`` | ``OldestLaunchTemplate`` | ``arn:aws:lambda:region:account-id:function:my-function:my-alias``
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_zone_identifier: A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
                If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the [DependsOn attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) to declare a dependency on the [VPC-gateway attachment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html).
                 When you update ``VPCZoneIdentifier``, this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html).
                 Required to launch instances into a nondefault VPC. If you specify ``VPCZoneIdentifier`` with ``AvailabilityZones``, the subnets that you specify for this property must reside in those Availability Zones.
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        if auto_scaling_group_name is not None:
            pulumi.set(__self__, "auto_scaling_group_name", auto_scaling_group_name)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if capacity_rebalance is not None:
            pulumi.set(__self__, "capacity_rebalance", capacity_rebalance)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if default_instance_warmup is not None:
            pulumi.set(__self__, "default_instance_warmup", default_instance_warmup)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if desired_capacity_type is not None:
            pulumi.set(__self__, "desired_capacity_type", desired_capacity_type)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_maintenance_policy is not None:
            pulumi.set(__self__, "instance_maintenance_policy", instance_maintenance_policy)
        if launch_configuration_name is not None:
            pulumi.set(__self__, "launch_configuration_name", launch_configuration_name)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if lifecycle_hook_specification_list is not None:
            pulumi.set(__self__, "lifecycle_hook_specification_list", lifecycle_hook_specification_list)
        if load_balancer_names is not None:
            pulumi.set(__self__, "load_balancer_names", load_balancer_names)
        if max_instance_lifetime is not None:
            pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        if metrics_collection is not None:
            pulumi.set(__self__, "metrics_collection", metrics_collection)
        if mixed_instances_policy is not None:
            pulumi.set(__self__, "mixed_instances_policy", mixed_instances_policy)
        if new_instances_protected_from_scale_in is not None:
            pulumi.set(__self__, "new_instances_protected_from_scale_in", new_instances_protected_from_scale_in)
        if notification_configuration is not None:
            pulumi.set(__self__, "notification_configuration", notification_configuration)
        if notification_configurations is not None:
            pulumi.set(__self__, "notification_configurations", notification_configurations)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if service_linked_role_arn is not None:
            pulumi.set(__self__, "service_linked_role_arn", service_linked_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if termination_policies is not None:
            pulumi.set(__self__, "termination_policies", termination_policies)
        if vpc_zone_identifier is not None:
            pulumi.set(__self__, "vpc_zone_identifier", vpc_zone_identifier)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[str]:
        """
        The maximum size of the group.
          With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above ``MaxSize`` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above ``MaxSize`` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[str]:
        """
        The minimum size of the group.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="autoScalingGroupName")
    def auto_scaling_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Auto Scaling group. This name must be unique per Region per account.
         The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
          You cannot use a colon (:) in the name.
        """
        return pulumi.get(self, "auto_scaling_group_name")

    @auto_scaling_group_name.setter
    def auto_scaling_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_scaling_group_name", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the ``VPCZoneIdentifier`` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="capacityRebalance")
    def capacity_rebalance(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "capacity_rebalance")

    @capacity_rebalance.setter
    def capacity_rebalance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "capacity_rebalance", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[str]]:
        """
        *Only needed if you use simple scaling policies.* 
         The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Default: ``300`` seconds
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cooldown", value)

    @property
    @pulumi.getter(name="defaultInstanceWarmup")
    def default_instance_warmup(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the ``InService`` state. 
         During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
          To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify ``-1`` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of ``0`` or other nominal value.
          Default: None
        """
        return pulumi.get(self, "default_instance_warmup")

    @default_instance_warmup.setter
    def default_instance_warmup(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_instance_warmup", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure automatic scaling.
         The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
         CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="desiredCapacityType")
    def desired_capacity_type(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports ``DesiredCapacityType`` for attribute-based instance type selection only. For more information, see [Create a mixed instances group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html) in the *Amazon EC2 Auto Scaling User Guide*.
         By default, Amazon EC2 Auto Scaling specifies ``units``, which translates into number of instances.
         Valid values: ``units`` | ``vcpu`` | ``memory-mib``
        """
        return pulumi.get(self, "desired_capacity_type")

    @desired_capacity_type.setter
    def desired_capacity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_capacity_type", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the ``InService`` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Default: ``0`` seconds
        """
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        A comma-separated value string of one or more health check types.
         The valid values are ``EC2``, ``ELB``, and ``VPC_LATTICE``. ``EC2`` is the default health check and cannot be disabled. For more information, see [Health checks for instances in an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Only specify ``EC2`` if you must clear a value that was previously set.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance used to base the launch configuration on. For more information, see [Create an Auto Scaling group using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html) in the *Amazon EC2 Auto Scaling User Guide*.
         If you specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``LaunchConfigurationName``, don't specify ``InstanceId``.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceMaintenancePolicy")
    def instance_maintenance_policy(self) -> Optional[pulumi.Input['AutoScalingGroupInstanceMaintenancePolicyArgs']]:
        """
        An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "instance_maintenance_policy")

    @instance_maintenance_policy.setter
    def instance_maintenance_policy(self, value: Optional[pulumi.Input['AutoScalingGroupInstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "instance_maintenance_policy", value)

    @property
    @pulumi.getter(name="launchConfigurationName")
    def launch_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch configuration to use to launch instances.
         Required only if you don't specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``InstanceId``.
        """
        return pulumi.get(self, "launch_configuration_name")

    @launch_configuration_name.setter
    def launch_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_configuration_name", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']]:
        """
        Information used to specify the launch template and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a ``MixedInstancesPolicy``. For more information about creating launch templates, see [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         If you omit this property, you must specify ``MixedInstancesPolicy``, ``LaunchConfigurationName``, or ``InstanceId``.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['AutoScalingGroupLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="lifecycleHookSpecificationList")
    def lifecycle_hook_specification_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLifecycleHookSpecificationArgs']]]]:
        """
        One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
        """
        return pulumi.get(self, "lifecycle_hook_specification_list")

    @lifecycle_hook_specification_list.setter
    def lifecycle_hook_specification_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupLifecycleHookSpecificationArgs']]]]):
        pulumi.set(self, "lifecycle_hook_specification_list", value)

    @property
    @pulumi.getter(name="loadBalancerNames")
    def load_balancer_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the ``TargetGroupARNs`` property instead.
        """
        return pulumi.get(self, "load_balancer_names")

    @load_balancer_names.setter
    def load_balancer_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancer_names", value)

    @property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replace Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @max_instance_lifetime.setter
    def max_instance_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_lifetime", value)

    @property
    @pulumi.getter(name="metricsCollection")
    def metrics_collection(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupMetricsCollectionArgs']]]]:
        """
        Enables the monitoring of group metrics of an Auto Scaling group. By default, these metrics are disabled.
        """
        return pulumi.get(self, "metrics_collection")

    @metrics_collection.setter
    def metrics_collection(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupMetricsCollectionArgs']]]]):
        pulumi.set(self, "metrics_collection", value)

    @property
    @pulumi.getter(name="mixedInstancesPolicy")
    def mixed_instances_policy(self) -> Optional[pulumi.Input['AutoScalingGroupMixedInstancesPolicyArgs']]:
        """
        An embedded object that specifies a mixed instances policy.
         The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
         For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "mixed_instances_policy")

    @mixed_instances_policy.setter
    def mixed_instances_policy(self, value: Optional[pulumi.Input['AutoScalingGroupMixedInstancesPolicyArgs']]):
        pulumi.set(self, "mixed_instances_policy", value)

    @property
    @pulumi.getter(name="newInstancesProtectedFromScaleIn")
    def new_instances_protected_from_scale_in(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Use instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "new_instances_protected_from_scale_in")

    @new_instances_protected_from_scale_in.setter
    def new_instances_protected_from_scale_in(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_instances_protected_from_scale_in", value)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']]:
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: Optional[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']]):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="notificationConfigurations")
    def notification_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']]]]:
        """
        Configures an Auto Scaling group to send notifications when specified events take place.
        """
        return pulumi.get(self, "notification_configurations")

    @notification_configurations.setter
    def notification_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupNotificationConfigurationArgs']]]]):
        pulumi.set(self, "notification_configurations", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
          A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named ``AWSServiceRoleForAutoScaling``, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "service_linked_role_arn")

    @service_linked_role_arn.setter
    def service_linked_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_linked_role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupTagPropertyArgs']]]]:
        """
        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoScalingGroupTagPropertyArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="terminationPolicies")
    def termination_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Configure termination policies for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Valid values: ``Default`` | ``AllocationStrategy`` | ``ClosestToNextInstanceHour`` | ``NewestInstance`` | ``OldestInstance`` | ``OldestLaunchConfiguration`` | ``OldestLaunchTemplate`` | ``arn:aws:lambda:region:account-id:function:my-function:my-alias``
        """
        return pulumi.get(self, "termination_policies")

    @termination_policies.setter
    def termination_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "termination_policies", value)

    @property
    @pulumi.getter(name="vpcZoneIdentifier")
    def vpc_zone_identifier(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
         If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the [DependsOn attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) to declare a dependency on the [VPC-gateway attachment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html).
          When you update ``VPCZoneIdentifier``, this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html).
          Required to launch instances into a nondefault VPC. If you specify ``VPCZoneIdentifier`` with ``AvailabilityZones``, the subnets that you specify for this property must reside in those Availability Zones.
        """
        return pulumi.get(self, "vpc_zone_identifier")

    @vpc_zone_identifier.setter
    def vpc_zone_identifier(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_zone_identifier", value)


class AutoScalingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_group_name: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[str]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[str]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input[Union['AutoScalingGroupInstanceMaintenancePolicyArgs', 'AutoScalingGroupInstanceMaintenancePolicyArgsDict']]] = None,
                 launch_configuration_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[Union['AutoScalingGroupLaunchTemplateSpecificationArgs', 'AutoScalingGroupLaunchTemplateSpecificationArgsDict']]] = None,
                 lifecycle_hook_specification_list: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupLifecycleHookSpecificationArgs', 'AutoScalingGroupLifecycleHookSpecificationArgsDict']]]]] = None,
                 load_balancer_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 max_size: Optional[pulumi.Input[str]] = None,
                 metrics_collection: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupMetricsCollectionArgs', 'AutoScalingGroupMetricsCollectionArgsDict']]]]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 mixed_instances_policy: Optional[pulumi.Input[Union['AutoScalingGroupMixedInstancesPolicyArgs', 'AutoScalingGroupMixedInstancesPolicyArgsDict']]] = None,
                 new_instances_protected_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['AutoScalingGroupNotificationConfigurationArgs', 'AutoScalingGroupNotificationConfigurationArgsDict']]] = None,
                 notification_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupNotificationConfigurationArgs', 'AutoScalingGroupNotificationConfigurationArgsDict']]]]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupTagPropertyArgs', 'AutoScalingGroupTagPropertyArgsDict']]]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_zone_identifier: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The ``AWS::AutoScaling::AutoScalingGroup`` resource defines an Amazon EC2 Auto Scaling group, which is a collection of Amazon EC2 instances that are treated as a logical grouping for the purposes of automatic scaling and management.
         For more information about Amazon EC2 Auto Scaling, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html).
          Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) or a launch configuration. We strongly recommend that you do not use launch configurations. For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html) in the *Amazon EC2 Auto Scaling User Guide*.
         For help migrating from launch configurations to launch templates, see [Migrate CloudFormation stacks from launch configurations to launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/migrate-launch-configurations-with-cloudformation.html) in the *Amazon EC2 Auto Scaling User Guide*.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_scaling_group_name: The name of the Auto Scaling group. This name must be unique per Region per account.
                The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
                 You cannot use a colon (:) in the name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the ``VPCZoneIdentifier`` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
        :param pulumi.Input[bool] capacity_rebalance: Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[str] context: Reserved.
        :param pulumi.Input[str] cooldown: *Only needed if you use simple scaling policies.* 
                The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Default: ``300`` seconds
        :param pulumi.Input[int] default_instance_warmup: The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the ``InService`` state. 
                During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
                 To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify ``-1`` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of ``0`` or other nominal value.
                 Default: None
        :param pulumi.Input[str] desired_capacity: The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure automatic scaling.
                The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
                CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
        :param pulumi.Input[str] desired_capacity_type: The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports ``DesiredCapacityType`` for attribute-based instance type selection only. For more information, see [Create a mixed instances group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html) in the *Amazon EC2 Auto Scaling User Guide*.
                By default, Amazon EC2 Auto Scaling specifies ``units``, which translates into number of instances.
                Valid values: ``units`` | ``vcpu`` | ``memory-mib``
        :param pulumi.Input[int] health_check_grace_period: The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the ``InService`` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Default: ``0`` seconds
        :param pulumi.Input[str] health_check_type: A comma-separated value string of one or more health check types.
                The valid values are ``EC2``, ``ELB``, and ``VPC_LATTICE``. ``EC2`` is the default health check and cannot be disabled. For more information, see [Health checks for instances in an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Only specify ``EC2`` if you must clear a value that was previously set.
        :param pulumi.Input[str] instance_id: The ID of the instance used to base the launch configuration on. For more information, see [Create an Auto Scaling group using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html) in the *Amazon EC2 Auto Scaling User Guide*.
                If you specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``LaunchConfigurationName``, don't specify ``InstanceId``.
        :param pulumi.Input[Union['AutoScalingGroupInstanceMaintenancePolicyArgs', 'AutoScalingGroupInstanceMaintenancePolicyArgsDict']] instance_maintenance_policy: An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[str] launch_configuration_name: The name of the launch configuration to use to launch instances.
                Required only if you don't specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``InstanceId``.
        :param pulumi.Input[Union['AutoScalingGroupLaunchTemplateSpecificationArgs', 'AutoScalingGroupLaunchTemplateSpecificationArgsDict']] launch_template: Information used to specify the launch template and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a ``MixedInstancesPolicy``. For more information about creating launch templates, see [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
                If you omit this property, you must specify ``MixedInstancesPolicy``, ``LaunchConfigurationName``, or ``InstanceId``.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupLifecycleHookSpecificationArgs', 'AutoScalingGroupLifecycleHookSpecificationArgsDict']]]] lifecycle_hook_specification_list: One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancer_names: A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the ``TargetGroupARNs`` property instead.
        :param pulumi.Input[int] max_instance_lifetime: The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replace Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[str] max_size: The maximum size of the group.
                 With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above ``MaxSize`` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above ``MaxSize`` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupMetricsCollectionArgs', 'AutoScalingGroupMetricsCollectionArgsDict']]]] metrics_collection: Enables the monitoring of group metrics of an Auto Scaling group. By default, these metrics are disabled.
        :param pulumi.Input[str] min_size: The minimum size of the group.
        :param pulumi.Input[Union['AutoScalingGroupMixedInstancesPolicyArgs', 'AutoScalingGroupMixedInstancesPolicyArgsDict']] mixed_instances_policy: An embedded object that specifies a mixed instances policy.
                The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
                For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[bool] new_instances_protected_from_scale_in: Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Use instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupNotificationConfigurationArgs', 'AutoScalingGroupNotificationConfigurationArgsDict']]]] notification_configurations: Configures an Auto Scaling group to send notifications when specified events take place.
        :param pulumi.Input[str] placement_group: The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
                 A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
        :param pulumi.Input[str] service_linked_role_arn: The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named ``AWSServiceRoleForAutoScaling``, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupTagPropertyArgs', 'AutoScalingGroupTagPropertyArgsDict']]]] tags: One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_group_arns: The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] termination_policies: A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Configure termination policies for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
                Valid values: ``Default`` | ``AllocationStrategy`` | ``ClosestToNextInstanceHour`` | ``NewestInstance`` | ``OldestInstance`` | ``OldestLaunchConfiguration`` | ``OldestLaunchTemplate`` | ``arn:aws:lambda:region:account-id:function:my-function:my-alias``
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_zone_identifier: A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
                If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the [DependsOn attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) to declare a dependency on the [VPC-gateway attachment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html).
                 When you update ``VPCZoneIdentifier``, this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html).
                 Required to launch instances into a nondefault VPC. If you specify ``VPCZoneIdentifier`` with ``AvailabilityZones``, the subnets that you specify for this property must reside in those Availability Zones.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoScalingGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::AutoScaling::AutoScalingGroup`` resource defines an Amazon EC2 Auto Scaling group, which is a collection of Amazon EC2 instances that are treated as a logical grouping for the purposes of automatic scaling and management.
         For more information about Amazon EC2 Auto Scaling, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html).
          Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) or a launch configuration. We strongly recommend that you do not use launch configurations. For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html) in the *Amazon EC2 Auto Scaling User Guide*.
         For help migrating from launch configurations to launch templates, see [Migrate CloudFormation stacks from launch configurations to launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/migrate-launch-configurations-with-cloudformation.html) in the *Amazon EC2 Auto Scaling User Guide*.

        :param str resource_name: The name of the resource.
        :param AutoScalingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoScalingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_group_name: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[str]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[str]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input[Union['AutoScalingGroupInstanceMaintenancePolicyArgs', 'AutoScalingGroupInstanceMaintenancePolicyArgsDict']]] = None,
                 launch_configuration_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[Union['AutoScalingGroupLaunchTemplateSpecificationArgs', 'AutoScalingGroupLaunchTemplateSpecificationArgsDict']]] = None,
                 lifecycle_hook_specification_list: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupLifecycleHookSpecificationArgs', 'AutoScalingGroupLifecycleHookSpecificationArgsDict']]]]] = None,
                 load_balancer_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 max_size: Optional[pulumi.Input[str]] = None,
                 metrics_collection: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupMetricsCollectionArgs', 'AutoScalingGroupMetricsCollectionArgsDict']]]]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 mixed_instances_policy: Optional[pulumi.Input[Union['AutoScalingGroupMixedInstancesPolicyArgs', 'AutoScalingGroupMixedInstancesPolicyArgsDict']]] = None,
                 new_instances_protected_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['AutoScalingGroupNotificationConfigurationArgs', 'AutoScalingGroupNotificationConfigurationArgsDict']]] = None,
                 notification_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupNotificationConfigurationArgs', 'AutoScalingGroupNotificationConfigurationArgsDict']]]]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoScalingGroupTagPropertyArgs', 'AutoScalingGroupTagPropertyArgsDict']]]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_zone_identifier: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoScalingGroupArgs.__new__(AutoScalingGroupArgs)

            __props__.__dict__["auto_scaling_group_name"] = auto_scaling_group_name
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["capacity_rebalance"] = capacity_rebalance
            __props__.__dict__["context"] = context
            __props__.__dict__["cooldown"] = cooldown
            __props__.__dict__["default_instance_warmup"] = default_instance_warmup
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["desired_capacity_type"] = desired_capacity_type
            __props__.__dict__["health_check_grace_period"] = health_check_grace_period
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_maintenance_policy"] = instance_maintenance_policy
            __props__.__dict__["launch_configuration_name"] = launch_configuration_name
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["lifecycle_hook_specification_list"] = lifecycle_hook_specification_list
            __props__.__dict__["load_balancer_names"] = load_balancer_names
            __props__.__dict__["max_instance_lifetime"] = max_instance_lifetime
            if max_size is None and not opts.urn:
                raise TypeError("Missing required property 'max_size'")
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["metrics_collection"] = metrics_collection
            if min_size is None and not opts.urn:
                raise TypeError("Missing required property 'min_size'")
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["mixed_instances_policy"] = mixed_instances_policy
            __props__.__dict__["new_instances_protected_from_scale_in"] = new_instances_protected_from_scale_in
            __props__.__dict__["notification_configuration"] = notification_configuration
            __props__.__dict__["notification_configurations"] = notification_configurations
            __props__.__dict__["placement_group"] = placement_group
            __props__.__dict__["service_linked_role_arn"] = service_linked_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_group_arns"] = target_group_arns
            __props__.__dict__["termination_policies"] = termination_policies
            __props__.__dict__["vpc_zone_identifier"] = vpc_zone_identifier
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["autoScalingGroupName", "instanceId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AutoScalingGroup, __self__).__init__(
            'aws-native:autoscaling:AutoScalingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AutoScalingGroup':
        """
        Get an existing AutoScalingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AutoScalingGroupArgs.__new__(AutoScalingGroupArgs)

        __props__.__dict__["auto_scaling_group_name"] = None
        __props__.__dict__["availability_zones"] = None
        __props__.__dict__["capacity_rebalance"] = None
        __props__.__dict__["context"] = None
        __props__.__dict__["cooldown"] = None
        __props__.__dict__["default_instance_warmup"] = None
        __props__.__dict__["desired_capacity"] = None
        __props__.__dict__["desired_capacity_type"] = None
        __props__.__dict__["health_check_grace_period"] = None
        __props__.__dict__["health_check_type"] = None
        __props__.__dict__["instance_id"] = None
        __props__.__dict__["instance_maintenance_policy"] = None
        __props__.__dict__["launch_configuration_name"] = None
        __props__.__dict__["launch_template"] = None
        __props__.__dict__["lifecycle_hook_specification_list"] = None
        __props__.__dict__["load_balancer_names"] = None
        __props__.__dict__["max_instance_lifetime"] = None
        __props__.__dict__["max_size"] = None
        __props__.__dict__["metrics_collection"] = None
        __props__.__dict__["min_size"] = None
        __props__.__dict__["mixed_instances_policy"] = None
        __props__.__dict__["new_instances_protected_from_scale_in"] = None
        __props__.__dict__["notification_configuration"] = None
        __props__.__dict__["notification_configurations"] = None
        __props__.__dict__["placement_group"] = None
        __props__.__dict__["service_linked_role_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_group_arns"] = None
        __props__.__dict__["termination_policies"] = None
        __props__.__dict__["vpc_zone_identifier"] = None
        return AutoScalingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoScalingGroupName")
    def auto_scaling_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Auto Scaling group. This name must be unique per Region per account.
         The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
          You cannot use a colon (:) in the name.
        """
        return pulumi.get(self, "auto_scaling_group_name")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the ``VPCZoneIdentifier`` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="capacityRebalance")
    def capacity_rebalance(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "capacity_rebalance")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def cooldown(self) -> pulumi.Output[Optional[str]]:
        """
        *Only needed if you use simple scaling policies.* 
         The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Default: ``300`` seconds
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter(name="defaultInstanceWarmup")
    def default_instance_warmup(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the ``InService`` state. 
         During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
          To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify ``-1`` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of ``0`` or other nominal value.
          Default: None
        """
        return pulumi.get(self, "default_instance_warmup")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[Optional[str]]:
        """
        The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure automatic scaling.
         The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
         CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="desiredCapacityType")
    def desired_capacity_type(self) -> pulumi.Output[Optional[str]]:
        """
        The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports ``DesiredCapacityType`` for attribute-based instance type selection only. For more information, see [Create a mixed instances group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html) in the *Amazon EC2 Auto Scaling User Guide*.
         By default, Amazon EC2 Auto Scaling specifies ``units``, which translates into number of instances.
         Valid values: ``units`` | ``vcpu`` | ``memory-mib``
        """
        return pulumi.get(self, "desired_capacity_type")

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the ``InService`` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Default: ``0`` seconds
        """
        return pulumi.get(self, "health_check_grace_period")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[Optional[str]]:
        """
        A comma-separated value string of one or more health check types.
         The valid values are ``EC2``, ``ELB``, and ``VPC_LATTICE``. ``EC2`` is the default health check and cannot be disabled. For more information, see [Health checks for instances in an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Only specify ``EC2`` if you must clear a value that was previously set.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the instance used to base the launch configuration on. For more information, see [Create an Auto Scaling group using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html) in the *Amazon EC2 Auto Scaling User Guide*.
         If you specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``LaunchConfigurationName``, don't specify ``InstanceId``.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceMaintenancePolicy")
    def instance_maintenance_policy(self) -> pulumi.Output[Optional['outputs.AutoScalingGroupInstanceMaintenancePolicy']]:
        """
        An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "instance_maintenance_policy")

    @property
    @pulumi.getter(name="launchConfigurationName")
    def launch_configuration_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the launch configuration to use to launch instances.
         Required only if you don't specify ``LaunchTemplate``, ``MixedInstancesPolicy``, or ``InstanceId``.
        """
        return pulumi.get(self, "launch_configuration_name")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.AutoScalingGroupLaunchTemplateSpecification']]:
        """
        Information used to specify the launch template and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a ``MixedInstancesPolicy``. For more information about creating launch templates, see [Create a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         If you omit this property, you must specify ``MixedInstancesPolicy``, ``LaunchConfigurationName``, or ``InstanceId``.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="lifecycleHookSpecificationList")
    def lifecycle_hook_specification_list(self) -> pulumi.Output[Optional[Sequence['outputs.AutoScalingGroupLifecycleHookSpecification']]]:
        """
        One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
        """
        return pulumi.get(self, "lifecycle_hook_specification_list")

    @property
    @pulumi.getter(name="loadBalancerNames")
    def load_balancer_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the ``TargetGroupARNs`` property instead.
        """
        return pulumi.get(self, "load_balancer_names")

    @property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replace Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[str]:
        """
        The maximum size of the group.
          With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above ``MaxSize`` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above ``MaxSize`` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="metricsCollection")
    def metrics_collection(self) -> pulumi.Output[Optional[Sequence['outputs.AutoScalingGroupMetricsCollection']]]:
        """
        Enables the monitoring of group metrics of an Auto Scaling group. By default, these metrics are disabled.
        """
        return pulumi.get(self, "metrics_collection")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[str]:
        """
        The minimum size of the group.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="mixedInstancesPolicy")
    def mixed_instances_policy(self) -> pulumi.Output[Optional['outputs.AutoScalingGroupMixedInstancesPolicy']]:
        """
        An embedded object that specifies a mixed instances policy.
         The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
         For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "mixed_instances_policy")

    @property
    @pulumi.getter(name="newInstancesProtectedFromScaleIn")
    def new_instances_protected_from_scale_in(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Use instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "new_instances_protected_from_scale_in")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output[Optional['outputs.AutoScalingGroupNotificationConfiguration']]:
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="notificationConfigurations")
    def notification_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AutoScalingGroupNotificationConfiguration']]]:
        """
        Configures an Auto Scaling group to send notifications when specified events take place.
        """
        return pulumi.get(self, "notification_configurations")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
          A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named ``AWSServiceRoleForAutoScaling``, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "service_linked_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AutoScalingGroupTagProperty']]]:
        """
        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
        """
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="terminationPolicies")
    def termination_policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Configure termination policies for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
         Valid values: ``Default`` | ``AllocationStrategy`` | ``ClosestToNextInstanceHour`` | ``NewestInstance`` | ``OldestInstance`` | ``OldestLaunchConfiguration`` | ``OldestLaunchTemplate`` | ``arn:aws:lambda:region:account-id:function:my-function:my-alias``
        """
        return pulumi.get(self, "termination_policies")

    @property
    @pulumi.getter(name="vpcZoneIdentifier")
    def vpc_zone_identifier(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
         If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the [DependsOn attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) to declare a dependency on the [VPC-gateway attachment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html).
          When you update ``VPCZoneIdentifier``, this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an [UpdatePolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html).
          Required to launch instances into a nondefault VPC. If you specify ``VPCZoneIdentifier`` with ``AvailabilityZones``, the subnets that you specify for this property must reside in those Availability Zones.
        """
        return pulumi.get(self, "vpc_zone_identifier")

