# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AssessmentAwsAccountArgs',
    'AssessmentAwsAccountArgsDict',
    'AssessmentAwsServiceArgs',
    'AssessmentAwsServiceArgsDict',
    'AssessmentDelegationArgs',
    'AssessmentDelegationArgsDict',
    'AssessmentReportsDestinationArgs',
    'AssessmentReportsDestinationArgsDict',
    'AssessmentRoleArgs',
    'AssessmentRoleArgsDict',
    'AssessmentScopeArgs',
    'AssessmentScopeArgsDict',
]

MYPY = False

if not MYPY:
    class AssessmentAwsAccountArgsDict(TypedDict):
        """
        The AWS account associated with the assessment.
        """
        email_address: NotRequired[pulumi.Input[str]]
        """
        The email address that's associated with the AWS account .
        """
        id: NotRequired[pulumi.Input[str]]
        """
        The identifier for the AWS account .
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the AWS account .
        """
elif False:
    AssessmentAwsAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentAwsAccountArgs:
    def __init__(__self__, *,
                 email_address: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The AWS account associated with the assessment.
        :param pulumi.Input[str] email_address: The email address that's associated with the AWS account .
        :param pulumi.Input[str] id: The identifier for the AWS account .
        :param pulumi.Input[str] name: The name of the AWS account .
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        The email address that's associated with the AWS account .
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the AWS account .
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the AWS account .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class AssessmentAwsServiceArgsDict(TypedDict):
        """
        An AWS service such as Amazon S3, AWS CloudTrail, and so on.
        """
        service_name: NotRequired[pulumi.Input[str]]
        """
        The name of the AWS service .
        """
elif False:
    AssessmentAwsServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentAwsServiceArgs:
    def __init__(__self__, *,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        An AWS service such as Amazon S3, AWS CloudTrail, and so on.
        :param pulumi.Input[str] service_name: The name of the AWS service .
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the AWS service .
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


if not MYPY:
    class AssessmentDelegationArgsDict(TypedDict):
        """
        The assignment of a control set to a delegate for review.
        """
        assessment_id: NotRequired[pulumi.Input[str]]
        """
        The identifier for the assessment that's associated with the delegation.
        """
        assessment_name: NotRequired[pulumi.Input[str]]
        """
        The name of the assessment that's associated with the delegation.
        """
        comment: NotRequired[pulumi.Input[str]]
        """
        The comment that's related to the delegation.
        """
        control_set_id: NotRequired[pulumi.Input[str]]
        """
        The identifier for the control set that's associated with the delegation.
        """
        created_by: NotRequired[pulumi.Input[str]]
        """
        The user or role that created the delegation.

        *Minimum* : `1`

        *Maximum* : `100`

        *Pattern* : `^[a-zA-Z0-9-_()\\\\[\\\\]\\\\s]+$`
        """
        creation_time: NotRequired[pulumi.Input[float]]
        """
        Specifies when the delegation was created.
        """
        id: NotRequired[pulumi.Input[str]]
        """
        The unique identifier for the delegation.
        """
        last_updated: NotRequired[pulumi.Input[float]]
        """
        Specifies when the delegation was last updated.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        role_type: NotRequired[pulumi.Input['AssessmentRoleType']]
        """
        The type of customer persona.

        > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        status: NotRequired[pulumi.Input['AssessmentDelegationStatus']]
        """
        The status of the delegation.
        """
elif False:
    AssessmentDelegationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentDelegationArgs:
    def __init__(__self__, *,
                 assessment_id: Optional[pulumi.Input[str]] = None,
                 assessment_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 control_set_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[float]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 last_updated: Optional[pulumi.Input[float]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 role_type: Optional[pulumi.Input['AssessmentRoleType']] = None,
                 status: Optional[pulumi.Input['AssessmentDelegationStatus']] = None):
        """
        The assignment of a control set to a delegate for review.
        :param pulumi.Input[str] assessment_id: The identifier for the assessment that's associated with the delegation.
        :param pulumi.Input[str] assessment_name: The name of the assessment that's associated with the delegation.
        :param pulumi.Input[str] comment: The comment that's related to the delegation.
        :param pulumi.Input[str] control_set_id: The identifier for the control set that's associated with the delegation.
        :param pulumi.Input[str] created_by: The user or role that created the delegation.
               
               *Minimum* : `1`
               
               *Maximum* : `100`
               
               *Pattern* : `^[a-zA-Z0-9-_()\\\\[\\\\]\\\\s]+$`
        :param pulumi.Input[float] creation_time: Specifies when the delegation was created.
        :param pulumi.Input[str] id: The unique identifier for the delegation.
        :param pulumi.Input[float] last_updated: Specifies when the delegation was last updated.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role.
        :param pulumi.Input['AssessmentRoleType'] role_type: The type of customer persona.
               
               > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        :param pulumi.Input['AssessmentDelegationStatus'] status: The status of the delegation.
        """
        if assessment_id is not None:
            pulumi.set(__self__, "assessment_id", assessment_id)
        if assessment_name is not None:
            pulumi.set(__self__, "assessment_name", assessment_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if control_set_id is not None:
            pulumi.set(__self__, "control_set_id", control_set_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the assessment that's associated with the delegation.
        """
        return pulumi.get(self, "assessment_id")

    @assessment_id.setter
    def assessment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assessment_id", value)

    @property
    @pulumi.getter(name="assessmentName")
    def assessment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the assessment that's associated with the delegation.
        """
        return pulumi.get(self, "assessment_name")

    @assessment_name.setter
    def assessment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assessment_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        The comment that's related to the delegation.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="controlSetId")
    def control_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the control set that's associated with the delegation.
        """
        return pulumi.get(self, "control_set_id")

    @control_set_id.setter
    def control_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_set_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The user or role that created the delegation.

        *Minimum* : `1`

        *Maximum* : `100`

        *Pattern* : `^[a-zA-Z0-9-_()\\\\[\\\\]\\\\s]+$`
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies when the delegation was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier for the delegation.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies when the delegation was last updated.
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "last_updated", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input['AssessmentRoleType']]:
        """
        The type of customer persona.

        > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input['AssessmentRoleType']]):
        pulumi.set(self, "role_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['AssessmentDelegationStatus']]:
        """
        The status of the delegation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['AssessmentDelegationStatus']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class AssessmentReportsDestinationArgsDict(TypedDict):
        """
        The destination in which evidence reports are stored for the specified assessment.
        """
        destination: NotRequired[pulumi.Input[str]]
        """
        The destination bucket where Audit Manager stores assessment reports.
        """
        destination_type: NotRequired[pulumi.Input['AssessmentReportDestinationType']]
        """
        The destination type, such as Amazon S3.
        """
elif False:
    AssessmentReportsDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentReportsDestinationArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_type: Optional[pulumi.Input['AssessmentReportDestinationType']] = None):
        """
        The destination in which evidence reports are stored for the specified assessment.
        :param pulumi.Input[str] destination: The destination bucket where Audit Manager stores assessment reports.
        :param pulumi.Input['AssessmentReportDestinationType'] destination_type: The destination type, such as Amazon S3.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        The destination bucket where Audit Manager stores assessment reports.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input['AssessmentReportDestinationType']]:
        """
        The destination type, such as Amazon S3.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input['AssessmentReportDestinationType']]):
        pulumi.set(self, "destination_type", value)


if not MYPY:
    class AssessmentRoleArgsDict(TypedDict):
        """
        The wrapper that contains AWS Audit Manager role information, such as the role type and IAM ARN.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        role_type: NotRequired[pulumi.Input['AssessmentRoleType']]
        """
        The type of customer persona.

        > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
elif False:
    AssessmentRoleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentRoleArgs:
    def __init__(__self__, *,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 role_type: Optional[pulumi.Input['AssessmentRoleType']] = None):
        """
        The wrapper that contains AWS Audit Manager role information, such as the role type and IAM ARN.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role.
        :param pulumi.Input['AssessmentRoleType'] role_type: The type of customer persona.
               
               > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
               > 
               > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input['AssessmentRoleType']]:
        """
        The type of customer persona.

        > In `CreateAssessment` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `UpdateSettings` , `roleType` can only be `PROCESS_OWNER` .
        > 
        > In `BatchCreateDelegationByAssessment` , `roleType` can only be `RESOURCE_OWNER` .
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input['AssessmentRoleType']]):
        pulumi.set(self, "role_type", value)


if not MYPY:
    class AssessmentScopeArgsDict(TypedDict):
        """
        The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
        """
        aws_accounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsAccountArgsDict']]]]
        """
        The AWS accounts included in scope.
        """
        aws_services: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsServiceArgsDict']]]]
        """
        The AWS services included in scope.
        """
elif False:
    AssessmentScopeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentScopeArgs:
    def __init__(__self__, *,
                 aws_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsAccountArgs']]]] = None,
                 aws_services: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsServiceArgs']]]] = None):
        """
        The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
        :param pulumi.Input[Sequence[pulumi.Input['AssessmentAwsAccountArgs']]] aws_accounts: The AWS accounts included in scope.
        :param pulumi.Input[Sequence[pulumi.Input['AssessmentAwsServiceArgs']]] aws_services: The AWS services included in scope.
        """
        if aws_accounts is not None:
            pulumi.set(__self__, "aws_accounts", aws_accounts)
        if aws_services is not None:
            pulumi.set(__self__, "aws_services", aws_services)

    @property
    @pulumi.getter(name="awsAccounts")
    def aws_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsAccountArgs']]]]:
        """
        The AWS accounts included in scope.
        """
        return pulumi.get(self, "aws_accounts")

    @aws_accounts.setter
    def aws_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsAccountArgs']]]]):
        pulumi.set(self, "aws_accounts", value)

    @property
    @pulumi.getter(name="awsServices")
    def aws_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsServiceArgs']]]]:
        """
        The AWS services included in scope.
        """
        return pulumi.get(self, "aws_services")

    @aws_services.setter
    def aws_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentAwsServiceArgs']]]]):
        pulumi.set(self, "aws_services", value)


