# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CapacityReservationCapacityAssignment',
    'CapacityReservationCapacityAssignmentConfiguration',
    'WorkGroupAclConfiguration',
    'WorkGroupConfiguration',
    'WorkGroupConfigurationUpdates',
    'WorkGroupCustomerContentEncryptionConfiguration',
    'WorkGroupEncryptionConfiguration',
    'WorkGroupEngineVersion',
    'WorkGroupResultConfiguration',
    'WorkGroupResultConfigurationUpdates',
]

@pulumi.output_type
class CapacityReservationCapacityAssignment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workgroupNames":
            suggest = "workgroup_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityReservationCapacityAssignment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityReservationCapacityAssignment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityReservationCapacityAssignment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workgroup_names: Sequence[str]):
        pulumi.set(__self__, "workgroup_names", workgroup_names)

    @property
    @pulumi.getter(name="workgroupNames")
    def workgroup_names(self) -> Sequence[str]:
        return pulumi.get(self, "workgroup_names")


@pulumi.output_type
class CapacityReservationCapacityAssignmentConfiguration(dict):
    """
    Assignment configuration to assign workgroups to a reservation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityAssignments":
            suggest = "capacity_assignments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityReservationCapacityAssignmentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityReservationCapacityAssignmentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityReservationCapacityAssignmentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_assignments: Sequence['outputs.CapacityReservationCapacityAssignment']):
        """
        Assignment configuration to assign workgroups to a reservation
        :param Sequence['CapacityReservationCapacityAssignment'] capacity_assignments: The list of assignments that make up the capacity assignment configuration.
        """
        pulumi.set(__self__, "capacity_assignments", capacity_assignments)

    @property
    @pulumi.getter(name="capacityAssignments")
    def capacity_assignments(self) -> Sequence['outputs.CapacityReservationCapacityAssignment']:
        """
        The list of assignments that make up the capacity assignment configuration.
        """
        return pulumi.get(self, "capacity_assignments")


@pulumi.output_type
class WorkGroupAclConfiguration(dict):
    """
    Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3AclOption":
            suggest = "s3_acl_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupAclConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupAclConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupAclConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_acl_option: 'WorkGroupS3AclOption'):
        """
        Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results
        :param 'WorkGroupS3AclOption' s3_acl_option: The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide* .
        """
        pulumi.set(__self__, "s3_acl_option", s3_acl_option)

    @property
    @pulumi.getter(name="s3AclOption")
    def s3_acl_option(self) -> 'WorkGroupS3AclOption':
        """
        The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide* .
        """
        return pulumi.get(self, "s3_acl_option")


@pulumi.output_type
class WorkGroupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalConfiguration":
            suggest = "additional_configuration"
        elif key == "bytesScannedCutoffPerQuery":
            suggest = "bytes_scanned_cutoff_per_query"
        elif key == "customerContentEncryptionConfiguration":
            suggest = "customer_content_encryption_configuration"
        elif key == "enforceWorkGroupConfiguration":
            suggest = "enforce_work_group_configuration"
        elif key == "engineVersion":
            suggest = "engine_version"
        elif key == "executionRole":
            suggest = "execution_role"
        elif key == "publishCloudWatchMetricsEnabled":
            suggest = "publish_cloud_watch_metrics_enabled"
        elif key == "requesterPaysEnabled":
            suggest = "requester_pays_enabled"
        elif key == "resultConfiguration":
            suggest = "result_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_configuration: Optional[str] = None,
                 bytes_scanned_cutoff_per_query: Optional[int] = None,
                 customer_content_encryption_configuration: Optional['outputs.WorkGroupCustomerContentEncryptionConfiguration'] = None,
                 enforce_work_group_configuration: Optional[bool] = None,
                 engine_version: Optional['outputs.WorkGroupEngineVersion'] = None,
                 execution_role: Optional[str] = None,
                 publish_cloud_watch_metrics_enabled: Optional[bool] = None,
                 requester_pays_enabled: Optional[bool] = None,
                 result_configuration: Optional['outputs.WorkGroupResultConfiguration'] = None):
        """
        :param str additional_configuration: Specifies a user defined JSON string that is passed to the session engine.
        :param int bytes_scanned_cutoff_per_query: The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. No default is defined.
               
               > This property currently supports integer types. Support for long values is planned.
        :param 'WorkGroupCustomerContentEncryptionConfiguration' customer_content_encryption_configuration: Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
        :param bool enforce_work_group_configuration: If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param 'WorkGroupEngineVersion' engine_version: The engine version that all queries running on the workgroup use.
        :param str execution_role: Role used to access user resources in an Athena for Apache Spark session. This property applies only to Spark-enabled workgroups in Athena.
        :param bool publish_cloud_watch_metrics_enabled: Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
        :param bool requester_pays_enabled: If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false` , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false` . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide* .
        :param 'WorkGroupResultConfiguration' result_configuration: Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) .
        """
        if additional_configuration is not None:
            pulumi.set(__self__, "additional_configuration", additional_configuration)
        if bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "bytes_scanned_cutoff_per_query", bytes_scanned_cutoff_per_query)
        if customer_content_encryption_configuration is not None:
            pulumi.set(__self__, "customer_content_encryption_configuration", customer_content_encryption_configuration)
        if enforce_work_group_configuration is not None:
            pulumi.set(__self__, "enforce_work_group_configuration", enforce_work_group_configuration)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if publish_cloud_watch_metrics_enabled is not None:
            pulumi.set(__self__, "publish_cloud_watch_metrics_enabled", publish_cloud_watch_metrics_enabled)
        if requester_pays_enabled is not None:
            pulumi.set(__self__, "requester_pays_enabled", requester_pays_enabled)
        if result_configuration is not None:
            pulumi.set(__self__, "result_configuration", result_configuration)

    @property
    @pulumi.getter(name="additionalConfiguration")
    def additional_configuration(self) -> Optional[str]:
        """
        Specifies a user defined JSON string that is passed to the session engine.
        """
        return pulumi.get(self, "additional_configuration")

    @property
    @pulumi.getter(name="bytesScannedCutoffPerQuery")
    def bytes_scanned_cutoff_per_query(self) -> Optional[int]:
        """
        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. No default is defined.

        > This property currently supports integer types. Support for long values is planned.
        """
        return pulumi.get(self, "bytes_scanned_cutoff_per_query")

    @property
    @pulumi.getter(name="customerContentEncryptionConfiguration")
    def customer_content_encryption_configuration(self) -> Optional['outputs.WorkGroupCustomerContentEncryptionConfiguration']:
        """
        Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
        """
        return pulumi.get(self, "customer_content_encryption_configuration")

    @property
    @pulumi.getter(name="enforceWorkGroupConfiguration")
    def enforce_work_group_configuration(self) -> Optional[bool]:
        """
        If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "enforce_work_group_configuration")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional['outputs.WorkGroupEngineVersion']:
        """
        The engine version that all queries running on the workgroup use.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[str]:
        """
        Role used to access user resources in an Athena for Apache Spark session. This property applies only to Spark-enabled workgroups in Athena.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="publishCloudWatchMetricsEnabled")
    def publish_cloud_watch_metrics_enabled(self) -> Optional[bool]:
        """
        Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
        """
        return pulumi.get(self, "publish_cloud_watch_metrics_enabled")

    @property
    @pulumi.getter(name="requesterPaysEnabled")
    def requester_pays_enabled(self) -> Optional[bool]:
        """
        If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false` , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false` . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide* .
        """
        return pulumi.get(self, "requester_pays_enabled")

    @property
    @pulumi.getter(name="resultConfiguration")
    def result_configuration(self) -> Optional['outputs.WorkGroupResultConfiguration']:
        """
        Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) .
        """
        return pulumi.get(self, "result_configuration")


@pulumi.output_type
class WorkGroupConfigurationUpdates(dict):
    """
    The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalConfiguration":
            suggest = "additional_configuration"
        elif key == "bytesScannedCutoffPerQuery":
            suggest = "bytes_scanned_cutoff_per_query"
        elif key == "customerContentEncryptionConfiguration":
            suggest = "customer_content_encryption_configuration"
        elif key == "enforceWorkGroupConfiguration":
            suggest = "enforce_work_group_configuration"
        elif key == "engineVersion":
            suggest = "engine_version"
        elif key == "executionRole":
            suggest = "execution_role"
        elif key == "publishCloudWatchMetricsEnabled":
            suggest = "publish_cloud_watch_metrics_enabled"
        elif key == "removeBytesScannedCutoffPerQuery":
            suggest = "remove_bytes_scanned_cutoff_per_query"
        elif key == "removeCustomerContentEncryptionConfiguration":
            suggest = "remove_customer_content_encryption_configuration"
        elif key == "requesterPaysEnabled":
            suggest = "requester_pays_enabled"
        elif key == "resultConfigurationUpdates":
            suggest = "result_configuration_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupConfigurationUpdates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupConfigurationUpdates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupConfigurationUpdates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_configuration: Optional[str] = None,
                 bytes_scanned_cutoff_per_query: Optional[int] = None,
                 customer_content_encryption_configuration: Optional['outputs.WorkGroupCustomerContentEncryptionConfiguration'] = None,
                 enforce_work_group_configuration: Optional[bool] = None,
                 engine_version: Optional['outputs.WorkGroupEngineVersion'] = None,
                 execution_role: Optional[str] = None,
                 publish_cloud_watch_metrics_enabled: Optional[bool] = None,
                 remove_bytes_scanned_cutoff_per_query: Optional[bool] = None,
                 remove_customer_content_encryption_configuration: Optional[bool] = None,
                 requester_pays_enabled: Optional[bool] = None,
                 result_configuration_updates: Optional['outputs.WorkGroupResultConfigurationUpdates'] = None):
        """
        The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. 
        """
        if additional_configuration is not None:
            pulumi.set(__self__, "additional_configuration", additional_configuration)
        if bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "bytes_scanned_cutoff_per_query", bytes_scanned_cutoff_per_query)
        if customer_content_encryption_configuration is not None:
            pulumi.set(__self__, "customer_content_encryption_configuration", customer_content_encryption_configuration)
        if enforce_work_group_configuration is not None:
            pulumi.set(__self__, "enforce_work_group_configuration", enforce_work_group_configuration)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if publish_cloud_watch_metrics_enabled is not None:
            pulumi.set(__self__, "publish_cloud_watch_metrics_enabled", publish_cloud_watch_metrics_enabled)
        if remove_bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "remove_bytes_scanned_cutoff_per_query", remove_bytes_scanned_cutoff_per_query)
        if remove_customer_content_encryption_configuration is not None:
            pulumi.set(__self__, "remove_customer_content_encryption_configuration", remove_customer_content_encryption_configuration)
        if requester_pays_enabled is not None:
            pulumi.set(__self__, "requester_pays_enabled", requester_pays_enabled)
        if result_configuration_updates is not None:
            pulumi.set(__self__, "result_configuration_updates", result_configuration_updates)

    @property
    @pulumi.getter(name="additionalConfiguration")
    def additional_configuration(self) -> Optional[str]:
        return pulumi.get(self, "additional_configuration")

    @property
    @pulumi.getter(name="bytesScannedCutoffPerQuery")
    def bytes_scanned_cutoff_per_query(self) -> Optional[int]:
        return pulumi.get(self, "bytes_scanned_cutoff_per_query")

    @property
    @pulumi.getter(name="customerContentEncryptionConfiguration")
    def customer_content_encryption_configuration(self) -> Optional['outputs.WorkGroupCustomerContentEncryptionConfiguration']:
        return pulumi.get(self, "customer_content_encryption_configuration")

    @property
    @pulumi.getter(name="enforceWorkGroupConfiguration")
    def enforce_work_group_configuration(self) -> Optional[bool]:
        return pulumi.get(self, "enforce_work_group_configuration")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional['outputs.WorkGroupEngineVersion']:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[str]:
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="publishCloudWatchMetricsEnabled")
    def publish_cloud_watch_metrics_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "publish_cloud_watch_metrics_enabled")

    @property
    @pulumi.getter(name="removeBytesScannedCutoffPerQuery")
    def remove_bytes_scanned_cutoff_per_query(self) -> Optional[bool]:
        return pulumi.get(self, "remove_bytes_scanned_cutoff_per_query")

    @property
    @pulumi.getter(name="removeCustomerContentEncryptionConfiguration")
    def remove_customer_content_encryption_configuration(self) -> Optional[bool]:
        return pulumi.get(self, "remove_customer_content_encryption_configuration")

    @property
    @pulumi.getter(name="requesterPaysEnabled")
    def requester_pays_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "requester_pays_enabled")

    @property
    @pulumi.getter(name="resultConfigurationUpdates")
    def result_configuration_updates(self) -> Optional['outputs.WorkGroupResultConfigurationUpdates']:
        return pulumi.get(self, "result_configuration_updates")


@pulumi.output_type
class WorkGroupCustomerContentEncryptionConfiguration(dict):
    """
    Indicates the KMS key for encrypting notebook content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupCustomerContentEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupCustomerContentEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupCustomerContentEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: str):
        """
        Indicates the KMS key for encrypting notebook content.
        :param str kms_key: The customer managed KMS key that is used to encrypt the user's data stores in Athena.
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        The customer managed KMS key that is used to encrypt the user's data stores in Athena.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class WorkGroupEncryptionConfiguration(dict):
    """
    If query results are encrypted in Amazon S3, indicates the encryption option used (for example, SSE-KMS or CSE-KMS) and key information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_option: 'WorkGroupEncryptionOption',
                 kms_key: Optional[str] = None):
        """
        If query results are encrypted in Amazon S3, indicates the encryption option used (for example, SSE-KMS or CSE-KMS) and key information.
        :param 'WorkGroupEncryptionOption' encryption_option: Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used.
               
               If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        :param str kms_key: For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
        """
        pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> 'WorkGroupEncryptionOption':
        """
        Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used.

        If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        """
        return pulumi.get(self, "encryption_option")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class WorkGroupEngineVersion(dict):
    """
    The Athena engine version for running queries.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveEngineVersion":
            suggest = "effective_engine_version"
        elif key == "selectedEngineVersion":
            suggest = "selected_engine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupEngineVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupEngineVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupEngineVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_engine_version: Optional[str] = None,
                 selected_engine_version: Optional[str] = None):
        """
        The Athena engine version for running queries.
        :param str effective_engine_version: Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a `CreateWorkGroup` or `UpdateWorkGroup` operation, the `EffectiveEngineVersion` field is ignored.
        :param str selected_engine_version: The engine version requested by the user. Possible values are determined by the output of `ListEngineVersions` , including AUTO. The default is AUTO.
        """
        if effective_engine_version is not None:
            pulumi.set(__self__, "effective_engine_version", effective_engine_version)
        if selected_engine_version is not None:
            pulumi.set(__self__, "selected_engine_version", selected_engine_version)

    @property
    @pulumi.getter(name="effectiveEngineVersion")
    def effective_engine_version(self) -> Optional[str]:
        """
        Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a `CreateWorkGroup` or `UpdateWorkGroup` operation, the `EffectiveEngineVersion` field is ignored.
        """
        return pulumi.get(self, "effective_engine_version")

    @property
    @pulumi.getter(name="selectedEngineVersion")
    def selected_engine_version(self) -> Optional[str]:
        """
        The engine version requested by the user. Possible values are determined by the output of `ListEngineVersions` , including AUTO. The default is AUTO.
        """
        return pulumi.get(self, "selected_engine_version")


@pulumi.output_type
class WorkGroupResultConfiguration(dict):
    """
    The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclConfiguration":
            suggest = "acl_configuration"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "expectedBucketOwner":
            suggest = "expected_bucket_owner"
        elif key == "outputLocation":
            suggest = "output_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupResultConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupResultConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupResultConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_configuration: Optional['outputs.WorkGroupAclConfiguration'] = None,
                 encryption_configuration: Optional['outputs.WorkGroupEncryptionConfiguration'] = None,
                 expected_bucket_owner: Optional[str] = None,
                 output_location: Optional[str] = None):
        """
        The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.

        :param 'WorkGroupAclConfiguration' acl_configuration: Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        :param 'WorkGroupEncryptionConfiguration' encryption_configuration: If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` and [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param str expected_bucket_owner: The account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration:OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
               
               This is a client-side setting. If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        :param str output_location: The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) and `EnforceWorkGroupConfiguration` .
        """
        if acl_configuration is not None:
            pulumi.set(__self__, "acl_configuration", acl_configuration)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)

    @property
    @pulumi.getter(name="aclConfiguration")
    def acl_configuration(self) -> Optional['outputs.WorkGroupAclConfiguration']:
        """
        Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "acl_configuration")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.WorkGroupEncryptionConfiguration']:
        """
        If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` and [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[str]:
        """
        The account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration:OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.

        This is a client-side setting. If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "expected_bucket_owner")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[str]:
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) and `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "output_location")


@pulumi.output_type
class WorkGroupResultConfigurationUpdates(dict):
    """
    The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclConfiguration":
            suggest = "acl_configuration"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "expectedBucketOwner":
            suggest = "expected_bucket_owner"
        elif key == "outputLocation":
            suggest = "output_location"
        elif key == "removeAclConfiguration":
            suggest = "remove_acl_configuration"
        elif key == "removeEncryptionConfiguration":
            suggest = "remove_encryption_configuration"
        elif key == "removeExpectedBucketOwner":
            suggest = "remove_expected_bucket_owner"
        elif key == "removeOutputLocation":
            suggest = "remove_output_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkGroupResultConfigurationUpdates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkGroupResultConfigurationUpdates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkGroupResultConfigurationUpdates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_configuration: Optional['outputs.WorkGroupAclConfiguration'] = None,
                 encryption_configuration: Optional['outputs.WorkGroupEncryptionConfiguration'] = None,
                 expected_bucket_owner: Optional[str] = None,
                 output_location: Optional[str] = None,
                 remove_acl_configuration: Optional[bool] = None,
                 remove_encryption_configuration: Optional[bool] = None,
                 remove_expected_bucket_owner: Optional[bool] = None,
                 remove_output_location: Optional[bool] = None):
        """
        The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results. 
        :param 'WorkGroupAclConfiguration' acl_configuration: The ACL configuration for the query results.
        :param 'WorkGroupEncryptionConfiguration' encryption_configuration: The encryption configuration for the query results.
        :param str expected_bucket_owner: The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration$OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
               
               If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `WorkGroupConfiguration$EnforceWorkGroupConfiguration` and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param str output_location: The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See `EnforceWorkGroupConfiguration` .
        :param bool remove_acl_configuration: If set to `true` , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates` , the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param bool remove_encryption_configuration: If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param bool remove_expected_bucket_owner: If set to "true", removes the AWS account ID previously specified for `ResultConfiguration$ExpectedBucketOwner` . If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param bool remove_output_location: If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        if acl_configuration is not None:
            pulumi.set(__self__, "acl_configuration", acl_configuration)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if remove_acl_configuration is not None:
            pulumi.set(__self__, "remove_acl_configuration", remove_acl_configuration)
        if remove_encryption_configuration is not None:
            pulumi.set(__self__, "remove_encryption_configuration", remove_encryption_configuration)
        if remove_expected_bucket_owner is not None:
            pulumi.set(__self__, "remove_expected_bucket_owner", remove_expected_bucket_owner)
        if remove_output_location is not None:
            pulumi.set(__self__, "remove_output_location", remove_output_location)

    @property
    @pulumi.getter(name="aclConfiguration")
    def acl_configuration(self) -> Optional['outputs.WorkGroupAclConfiguration']:
        """
        The ACL configuration for the query results.
        """
        return pulumi.get(self, "acl_configuration")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.WorkGroupEncryptionConfiguration']:
        """
        The encryption configuration for the query results.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[str]:
        """
        The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration$OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.

        If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `WorkGroupConfiguration$EnforceWorkGroupConfiguration` and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "expected_bucket_owner")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[str]:
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "output_location")

    @property
    @pulumi.getter(name="removeAclConfiguration")
    def remove_acl_configuration(self) -> Optional[bool]:
        """
        If set to `true` , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates` , the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_acl_configuration")

    @property
    @pulumi.getter(name="removeEncryptionConfiguration")
    def remove_encryption_configuration(self) -> Optional[bool]:
        """
        If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_encryption_configuration")

    @property
    @pulumi.getter(name="removeExpectedBucketOwner")
    def remove_expected_bucket_owner(self) -> Optional[bool]:
        """
        If set to "true", removes the AWS account ID previously specified for `ResultConfiguration$ExpectedBucketOwner` . If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_expected_bucket_owner")

    @property
    @pulumi.getter(name="removeOutputLocation")
    def remove_output_location(self) -> Optional[bool]:
        """
        If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_output_location")


