# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CapacityReservationCapacityAssignmentConfigurationArgs',
    'CapacityReservationCapacityAssignmentConfigurationArgsDict',
    'CapacityReservationCapacityAssignmentArgs',
    'CapacityReservationCapacityAssignmentArgsDict',
    'WorkGroupAclConfigurationArgs',
    'WorkGroupAclConfigurationArgsDict',
    'WorkGroupConfigurationUpdatesArgs',
    'WorkGroupConfigurationUpdatesArgsDict',
    'WorkGroupConfigurationArgs',
    'WorkGroupConfigurationArgsDict',
    'WorkGroupCustomerContentEncryptionConfigurationArgs',
    'WorkGroupCustomerContentEncryptionConfigurationArgsDict',
    'WorkGroupEncryptionConfigurationArgs',
    'WorkGroupEncryptionConfigurationArgsDict',
    'WorkGroupEngineVersionArgs',
    'WorkGroupEngineVersionArgsDict',
    'WorkGroupResultConfigurationUpdatesArgs',
    'WorkGroupResultConfigurationUpdatesArgsDict',
    'WorkGroupResultConfigurationArgs',
    'WorkGroupResultConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class CapacityReservationCapacityAssignmentConfigurationArgsDict(TypedDict):
        """
        Assignment configuration to assign workgroups to a reservation
        """
        capacity_assignments: pulumi.Input[Sequence[pulumi.Input['CapacityReservationCapacityAssignmentArgsDict']]]
        """
        The list of assignments that make up the capacity assignment configuration.
        """
elif False:
    CapacityReservationCapacityAssignmentConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CapacityReservationCapacityAssignmentConfigurationArgs:
    def __init__(__self__, *,
                 capacity_assignments: pulumi.Input[Sequence[pulumi.Input['CapacityReservationCapacityAssignmentArgs']]]):
        """
        Assignment configuration to assign workgroups to a reservation
        :param pulumi.Input[Sequence[pulumi.Input['CapacityReservationCapacityAssignmentArgs']]] capacity_assignments: The list of assignments that make up the capacity assignment configuration.
        """
        pulumi.set(__self__, "capacity_assignments", capacity_assignments)

    @property
    @pulumi.getter(name="capacityAssignments")
    def capacity_assignments(self) -> pulumi.Input[Sequence[pulumi.Input['CapacityReservationCapacityAssignmentArgs']]]:
        """
        The list of assignments that make up the capacity assignment configuration.
        """
        return pulumi.get(self, "capacity_assignments")

    @capacity_assignments.setter
    def capacity_assignments(self, value: pulumi.Input[Sequence[pulumi.Input['CapacityReservationCapacityAssignmentArgs']]]):
        pulumi.set(self, "capacity_assignments", value)


if not MYPY:
    class CapacityReservationCapacityAssignmentArgsDict(TypedDict):
        workgroup_names: pulumi.Input[Sequence[pulumi.Input[str]]]
elif False:
    CapacityReservationCapacityAssignmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CapacityReservationCapacityAssignmentArgs:
    def __init__(__self__, *,
                 workgroup_names: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(__self__, "workgroup_names", workgroup_names)

    @property
    @pulumi.getter(name="workgroupNames")
    def workgroup_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "workgroup_names")

    @workgroup_names.setter
    def workgroup_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "workgroup_names", value)


if not MYPY:
    class WorkGroupAclConfigurationArgsDict(TypedDict):
        """
        Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results
        """
        s3_acl_option: pulumi.Input['WorkGroupS3AclOption']
        """
        The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide* .
        """
elif False:
    WorkGroupAclConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupAclConfigurationArgs:
    def __init__(__self__, *,
                 s3_acl_option: pulumi.Input['WorkGroupS3AclOption']):
        """
        Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results
        :param pulumi.Input['WorkGroupS3AclOption'] s3_acl_option: The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide* .
        """
        pulumi.set(__self__, "s3_acl_option", s3_acl_option)

    @property
    @pulumi.getter(name="s3AclOption")
    def s3_acl_option(self) -> pulumi.Input['WorkGroupS3AclOption']:
        """
        The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) in the *Amazon S3 User Guide* .
        """
        return pulumi.get(self, "s3_acl_option")

    @s3_acl_option.setter
    def s3_acl_option(self, value: pulumi.Input['WorkGroupS3AclOption']):
        pulumi.set(self, "s3_acl_option", value)


if not MYPY:
    class WorkGroupConfigurationUpdatesArgsDict(TypedDict):
        """
        The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. 
        """
        additional_configuration: NotRequired[pulumi.Input[str]]
        bytes_scanned_cutoff_per_query: NotRequired[pulumi.Input[int]]
        customer_content_encryption_configuration: NotRequired[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgsDict']]
        enforce_work_group_configuration: NotRequired[pulumi.Input[bool]]
        engine_version: NotRequired[pulumi.Input['WorkGroupEngineVersionArgsDict']]
        execution_role: NotRequired[pulumi.Input[str]]
        publish_cloud_watch_metrics_enabled: NotRequired[pulumi.Input[bool]]
        remove_bytes_scanned_cutoff_per_query: NotRequired[pulumi.Input[bool]]
        remove_customer_content_encryption_configuration: NotRequired[pulumi.Input[bool]]
        requester_pays_enabled: NotRequired[pulumi.Input[bool]]
        result_configuration_updates: NotRequired[pulumi.Input['WorkGroupResultConfigurationUpdatesArgsDict']]
elif False:
    WorkGroupConfigurationUpdatesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupConfigurationUpdatesArgs:
    def __init__(__self__, *,
                 additional_configuration: Optional[pulumi.Input[str]] = None,
                 bytes_scanned_cutoff_per_query: Optional[pulumi.Input[int]] = None,
                 customer_content_encryption_configuration: Optional[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs']] = None,
                 enforce_work_group_configuration: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input['WorkGroupEngineVersionArgs']] = None,
                 execution_role: Optional[pulumi.Input[str]] = None,
                 publish_cloud_watch_metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 remove_bytes_scanned_cutoff_per_query: Optional[pulumi.Input[bool]] = None,
                 remove_customer_content_encryption_configuration: Optional[pulumi.Input[bool]] = None,
                 requester_pays_enabled: Optional[pulumi.Input[bool]] = None,
                 result_configuration_updates: Optional[pulumi.Input['WorkGroupResultConfigurationUpdatesArgs']] = None):
        """
        The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. 
        """
        if additional_configuration is not None:
            pulumi.set(__self__, "additional_configuration", additional_configuration)
        if bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "bytes_scanned_cutoff_per_query", bytes_scanned_cutoff_per_query)
        if customer_content_encryption_configuration is not None:
            pulumi.set(__self__, "customer_content_encryption_configuration", customer_content_encryption_configuration)
        if enforce_work_group_configuration is not None:
            pulumi.set(__self__, "enforce_work_group_configuration", enforce_work_group_configuration)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if publish_cloud_watch_metrics_enabled is not None:
            pulumi.set(__self__, "publish_cloud_watch_metrics_enabled", publish_cloud_watch_metrics_enabled)
        if remove_bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "remove_bytes_scanned_cutoff_per_query", remove_bytes_scanned_cutoff_per_query)
        if remove_customer_content_encryption_configuration is not None:
            pulumi.set(__self__, "remove_customer_content_encryption_configuration", remove_customer_content_encryption_configuration)
        if requester_pays_enabled is not None:
            pulumi.set(__self__, "requester_pays_enabled", requester_pays_enabled)
        if result_configuration_updates is not None:
            pulumi.set(__self__, "result_configuration_updates", result_configuration_updates)

    @property
    @pulumi.getter(name="additionalConfiguration")
    def additional_configuration(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "additional_configuration")

    @additional_configuration.setter
    def additional_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_configuration", value)

    @property
    @pulumi.getter(name="bytesScannedCutoffPerQuery")
    def bytes_scanned_cutoff_per_query(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "bytes_scanned_cutoff_per_query")

    @bytes_scanned_cutoff_per_query.setter
    def bytes_scanned_cutoff_per_query(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bytes_scanned_cutoff_per_query", value)

    @property
    @pulumi.getter(name="customerContentEncryptionConfiguration")
    def customer_content_encryption_configuration(self) -> Optional[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs']]:
        return pulumi.get(self, "customer_content_encryption_configuration")

    @customer_content_encryption_configuration.setter
    def customer_content_encryption_configuration(self, value: Optional[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs']]):
        pulumi.set(self, "customer_content_encryption_configuration", value)

    @property
    @pulumi.getter(name="enforceWorkGroupConfiguration")
    def enforce_work_group_configuration(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enforce_work_group_configuration")

    @enforce_work_group_configuration.setter
    def enforce_work_group_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_work_group_configuration", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input['WorkGroupEngineVersionArgs']]:
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input['WorkGroupEngineVersionArgs']]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="publishCloudWatchMetricsEnabled")
    def publish_cloud_watch_metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "publish_cloud_watch_metrics_enabled")

    @publish_cloud_watch_metrics_enabled.setter
    def publish_cloud_watch_metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_cloud_watch_metrics_enabled", value)

    @property
    @pulumi.getter(name="removeBytesScannedCutoffPerQuery")
    def remove_bytes_scanned_cutoff_per_query(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "remove_bytes_scanned_cutoff_per_query")

    @remove_bytes_scanned_cutoff_per_query.setter
    def remove_bytes_scanned_cutoff_per_query(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_bytes_scanned_cutoff_per_query", value)

    @property
    @pulumi.getter(name="removeCustomerContentEncryptionConfiguration")
    def remove_customer_content_encryption_configuration(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "remove_customer_content_encryption_configuration")

    @remove_customer_content_encryption_configuration.setter
    def remove_customer_content_encryption_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_customer_content_encryption_configuration", value)

    @property
    @pulumi.getter(name="requesterPaysEnabled")
    def requester_pays_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "requester_pays_enabled")

    @requester_pays_enabled.setter
    def requester_pays_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays_enabled", value)

    @property
    @pulumi.getter(name="resultConfigurationUpdates")
    def result_configuration_updates(self) -> Optional[pulumi.Input['WorkGroupResultConfigurationUpdatesArgs']]:
        return pulumi.get(self, "result_configuration_updates")

    @result_configuration_updates.setter
    def result_configuration_updates(self, value: Optional[pulumi.Input['WorkGroupResultConfigurationUpdatesArgs']]):
        pulumi.set(self, "result_configuration_updates", value)


if not MYPY:
    class WorkGroupConfigurationArgsDict(TypedDict):
        additional_configuration: NotRequired[pulumi.Input[str]]
        """
        Specifies a user defined JSON string that is passed to the session engine.
        """
        bytes_scanned_cutoff_per_query: NotRequired[pulumi.Input[int]]
        """
        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. No default is defined.

        > This property currently supports integer types. Support for long values is planned.
        """
        customer_content_encryption_configuration: NotRequired[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgsDict']]
        """
        Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
        """
        enforce_work_group_configuration: NotRequired[pulumi.Input[bool]]
        """
        If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        engine_version: NotRequired[pulumi.Input['WorkGroupEngineVersionArgsDict']]
        """
        The engine version that all queries running on the workgroup use.
        """
        execution_role: NotRequired[pulumi.Input[str]]
        """
        Role used to access user resources in an Athena for Apache Spark session. This property applies only to Spark-enabled workgroups in Athena.
        """
        publish_cloud_watch_metrics_enabled: NotRequired[pulumi.Input[bool]]
        """
        Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
        """
        requester_pays_enabled: NotRequired[pulumi.Input[bool]]
        """
        If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false` , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false` . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide* .
        """
        result_configuration: NotRequired[pulumi.Input['WorkGroupResultConfigurationArgsDict']]
        """
        Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) .
        """
elif False:
    WorkGroupConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupConfigurationArgs:
    def __init__(__self__, *,
                 additional_configuration: Optional[pulumi.Input[str]] = None,
                 bytes_scanned_cutoff_per_query: Optional[pulumi.Input[int]] = None,
                 customer_content_encryption_configuration: Optional[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs']] = None,
                 enforce_work_group_configuration: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input['WorkGroupEngineVersionArgs']] = None,
                 execution_role: Optional[pulumi.Input[str]] = None,
                 publish_cloud_watch_metrics_enabled: Optional[pulumi.Input[bool]] = None,
                 requester_pays_enabled: Optional[pulumi.Input[bool]] = None,
                 result_configuration: Optional[pulumi.Input['WorkGroupResultConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] additional_configuration: Specifies a user defined JSON string that is passed to the session engine.
        :param pulumi.Input[int] bytes_scanned_cutoff_per_query: The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. No default is defined.
               
               > This property currently supports integer types. Support for long values is planned.
        :param pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs'] customer_content_encryption_configuration: Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
        :param pulumi.Input[bool] enforce_work_group_configuration: If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param pulumi.Input['WorkGroupEngineVersionArgs'] engine_version: The engine version that all queries running on the workgroup use.
        :param pulumi.Input[str] execution_role: Role used to access user resources in an Athena for Apache Spark session. This property applies only to Spark-enabled workgroups in Athena.
        :param pulumi.Input[bool] publish_cloud_watch_metrics_enabled: Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
        :param pulumi.Input[bool] requester_pays_enabled: If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false` , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false` . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide* .
        :param pulumi.Input['WorkGroupResultConfigurationArgs'] result_configuration: Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) .
        """
        if additional_configuration is not None:
            pulumi.set(__self__, "additional_configuration", additional_configuration)
        if bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "bytes_scanned_cutoff_per_query", bytes_scanned_cutoff_per_query)
        if customer_content_encryption_configuration is not None:
            pulumi.set(__self__, "customer_content_encryption_configuration", customer_content_encryption_configuration)
        if enforce_work_group_configuration is not None:
            pulumi.set(__self__, "enforce_work_group_configuration", enforce_work_group_configuration)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if publish_cloud_watch_metrics_enabled is not None:
            pulumi.set(__self__, "publish_cloud_watch_metrics_enabled", publish_cloud_watch_metrics_enabled)
        if requester_pays_enabled is not None:
            pulumi.set(__self__, "requester_pays_enabled", requester_pays_enabled)
        if result_configuration is not None:
            pulumi.set(__self__, "result_configuration", result_configuration)

    @property
    @pulumi.getter(name="additionalConfiguration")
    def additional_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user defined JSON string that is passed to the session engine.
        """
        return pulumi.get(self, "additional_configuration")

    @additional_configuration.setter
    def additional_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_configuration", value)

    @property
    @pulumi.getter(name="bytesScannedCutoffPerQuery")
    def bytes_scanned_cutoff_per_query(self) -> Optional[pulumi.Input[int]]:
        """
        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. No default is defined.

        > This property currently supports integer types. Support for long values is planned.
        """
        return pulumi.get(self, "bytes_scanned_cutoff_per_query")

    @bytes_scanned_cutoff_per_query.setter
    def bytes_scanned_cutoff_per_query(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bytes_scanned_cutoff_per_query", value)

    @property
    @pulumi.getter(name="customerContentEncryptionConfiguration")
    def customer_content_encryption_configuration(self) -> Optional[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs']]:
        """
        Specifies the KMS key that is used to encrypt the user's data stores in Athena. This setting does not apply to Athena SQL workgroups.
        """
        return pulumi.get(self, "customer_content_encryption_configuration")

    @customer_content_encryption_configuration.setter
    def customer_content_encryption_configuration(self, value: Optional[pulumi.Input['WorkGroupCustomerContentEncryptionConfigurationArgs']]):
        pulumi.set(self, "customer_content_encryption_configuration", value)

    @property
    @pulumi.getter(name="enforceWorkGroupConfiguration")
    def enforce_work_group_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "enforce_work_group_configuration")

    @enforce_work_group_configuration.setter
    def enforce_work_group_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_work_group_configuration", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input['WorkGroupEngineVersionArgs']]:
        """
        The engine version that all queries running on the workgroup use.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input['WorkGroupEngineVersionArgs']]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[pulumi.Input[str]]:
        """
        Role used to access user resources in an Athena for Apache Spark session. This property applies only to Spark-enabled workgroups in Athena.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="publishCloudWatchMetricsEnabled")
    def publish_cloud_watch_metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
        """
        return pulumi.get(self, "publish_cloud_watch_metrics_enabled")

    @publish_cloud_watch_metrics_enabled.setter
    def publish_cloud_watch_metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_cloud_watch_metrics_enabled", value)

    @property
    @pulumi.getter(name="requesterPaysEnabled")
    def requester_pays_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true` , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to `false` , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is `false` . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the *Amazon Simple Storage Service Developer Guide* .
        """
        return pulumi.get(self, "requester_pays_enabled")

    @requester_pays_enabled.setter
    def requester_pays_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays_enabled", value)

    @property
    @pulumi.getter(name="resultConfiguration")
    def result_configuration(self) -> Optional[pulumi.Input['WorkGroupResultConfigurationArgs']]:
        """
        Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) .
        """
        return pulumi.get(self, "result_configuration")

    @result_configuration.setter
    def result_configuration(self, value: Optional[pulumi.Input['WorkGroupResultConfigurationArgs']]):
        pulumi.set(self, "result_configuration", value)


if not MYPY:
    class WorkGroupCustomerContentEncryptionConfigurationArgsDict(TypedDict):
        """
        Indicates the KMS key for encrypting notebook content.
        """
        kms_key: pulumi.Input[str]
        """
        The customer managed KMS key that is used to encrypt the user's data stores in Athena.
        """
elif False:
    WorkGroupCustomerContentEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupCustomerContentEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key: pulumi.Input[str]):
        """
        Indicates the KMS key for encrypting notebook content.
        :param pulumi.Input[str] kms_key: The customer managed KMS key that is used to encrypt the user's data stores in Athena.
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Input[str]:
        """
        The customer managed KMS key that is used to encrypt the user's data stores in Athena.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class WorkGroupEncryptionConfigurationArgsDict(TypedDict):
        """
        If query results are encrypted in Amazon S3, indicates the encryption option used (for example, SSE-KMS or CSE-KMS) and key information.
        """
        encryption_option: pulumi.Input['WorkGroupEncryptionOption']
        """
        Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used.

        If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        """
        kms_key: NotRequired[pulumi.Input[str]]
        """
        For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
        """
elif False:
    WorkGroupEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_option: pulumi.Input['WorkGroupEncryptionOption'],
                 kms_key: Optional[pulumi.Input[str]] = None):
        """
        If query results are encrypted in Amazon S3, indicates the encryption option used (for example, SSE-KMS or CSE-KMS) and key information.
        :param pulumi.Input['WorkGroupEncryptionOption'] encryption_option: Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used.
               
               If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        :param pulumi.Input[str] kms_key: For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
        """
        pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> pulumi.Input['WorkGroupEncryptionOption']:
        """
        Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( `SSE_S3` ), server-side encryption with KMS-managed keys ( `SSE_KMS` ), or client-side encryption with KMS-managed keys ( `CSE_KMS` ) is used.

        If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        """
        return pulumi.get(self, "encryption_option")

    @encryption_option.setter
    def encryption_option(self, value: pulumi.Input['WorkGroupEncryptionOption']):
        pulumi.set(self, "encryption_option", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        For `SSE_KMS` and `CSE_KMS` , this is the KMS key ARN or ID.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class WorkGroupEngineVersionArgsDict(TypedDict):
        """
        The Athena engine version for running queries.
        """
        effective_engine_version: NotRequired[pulumi.Input[str]]
        """
        Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a `CreateWorkGroup` or `UpdateWorkGroup` operation, the `EffectiveEngineVersion` field is ignored.
        """
        selected_engine_version: NotRequired[pulumi.Input[str]]
        """
        The engine version requested by the user. Possible values are determined by the output of `ListEngineVersions` , including AUTO. The default is AUTO.
        """
elif False:
    WorkGroupEngineVersionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupEngineVersionArgs:
    def __init__(__self__, *,
                 effective_engine_version: Optional[pulumi.Input[str]] = None,
                 selected_engine_version: Optional[pulumi.Input[str]] = None):
        """
        The Athena engine version for running queries.
        :param pulumi.Input[str] effective_engine_version: Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a `CreateWorkGroup` or `UpdateWorkGroup` operation, the `EffectiveEngineVersion` field is ignored.
        :param pulumi.Input[str] selected_engine_version: The engine version requested by the user. Possible values are determined by the output of `ListEngineVersions` , including AUTO. The default is AUTO.
        """
        if effective_engine_version is not None:
            pulumi.set(__self__, "effective_engine_version", effective_engine_version)
        if selected_engine_version is not None:
            pulumi.set(__self__, "selected_engine_version", selected_engine_version)

    @property
    @pulumi.getter(name="effectiveEngineVersion")
    def effective_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a `CreateWorkGroup` or `UpdateWorkGroup` operation, the `EffectiveEngineVersion` field is ignored.
        """
        return pulumi.get(self, "effective_engine_version")

    @effective_engine_version.setter
    def effective_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_engine_version", value)

    @property
    @pulumi.getter(name="selectedEngineVersion")
    def selected_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version requested by the user. Possible values are determined by the output of `ListEngineVersions` , including AUTO. The default is AUTO.
        """
        return pulumi.get(self, "selected_engine_version")

    @selected_engine_version.setter
    def selected_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selected_engine_version", value)


if not MYPY:
    class WorkGroupResultConfigurationUpdatesArgsDict(TypedDict):
        """
        The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results. 
        """
        acl_configuration: NotRequired[pulumi.Input['WorkGroupAclConfigurationArgsDict']]
        """
        The ACL configuration for the query results.
        """
        encryption_configuration: NotRequired[pulumi.Input['WorkGroupEncryptionConfigurationArgsDict']]
        """
        The encryption configuration for the query results.
        """
        expected_bucket_owner: NotRequired[pulumi.Input[str]]
        """
        The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration$OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.

        If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `WorkGroupConfiguration$EnforceWorkGroupConfiguration` and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        output_location: NotRequired[pulumi.Input[str]]
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See `EnforceWorkGroupConfiguration` .
        """
        remove_acl_configuration: NotRequired[pulumi.Input[bool]]
        """
        If set to `true` , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates` , the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        remove_encryption_configuration: NotRequired[pulumi.Input[bool]]
        """
        If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        remove_expected_bucket_owner: NotRequired[pulumi.Input[bool]]
        """
        If set to "true", removes the AWS account ID previously specified for `ResultConfiguration$ExpectedBucketOwner` . If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        remove_output_location: NotRequired[pulumi.Input[bool]]
        """
        If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
elif False:
    WorkGroupResultConfigurationUpdatesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupResultConfigurationUpdatesArgs:
    def __init__(__self__, *,
                 acl_configuration: Optional[pulumi.Input['WorkGroupAclConfigurationArgs']] = None,
                 encryption_configuration: Optional[pulumi.Input['WorkGroupEncryptionConfigurationArgs']] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input[str]] = None,
                 remove_acl_configuration: Optional[pulumi.Input[bool]] = None,
                 remove_encryption_configuration: Optional[pulumi.Input[bool]] = None,
                 remove_expected_bucket_owner: Optional[pulumi.Input[bool]] = None,
                 remove_output_location: Optional[pulumi.Input[bool]] = None):
        """
        The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results. 
        :param pulumi.Input['WorkGroupAclConfigurationArgs'] acl_configuration: The ACL configuration for the query results.
        :param pulumi.Input['WorkGroupEncryptionConfigurationArgs'] encryption_configuration: The encryption configuration for the query results.
        :param pulumi.Input[str] expected_bucket_owner: The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration$OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
               
               If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `WorkGroupConfiguration$EnforceWorkGroupConfiguration` and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param pulumi.Input[str] output_location: The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See `EnforceWorkGroupConfiguration` .
        :param pulumi.Input[bool] remove_acl_configuration: If set to `true` , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates` , the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param pulumi.Input[bool] remove_encryption_configuration: If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param pulumi.Input[bool] remove_expected_bucket_owner: If set to "true", removes the AWS account ID previously specified for `ResultConfiguration$ExpectedBucketOwner` . If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param pulumi.Input[bool] remove_output_location: If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        if acl_configuration is not None:
            pulumi.set(__self__, "acl_configuration", acl_configuration)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if remove_acl_configuration is not None:
            pulumi.set(__self__, "remove_acl_configuration", remove_acl_configuration)
        if remove_encryption_configuration is not None:
            pulumi.set(__self__, "remove_encryption_configuration", remove_encryption_configuration)
        if remove_expected_bucket_owner is not None:
            pulumi.set(__self__, "remove_expected_bucket_owner", remove_expected_bucket_owner)
        if remove_output_location is not None:
            pulumi.set(__self__, "remove_output_location", remove_output_location)

    @property
    @pulumi.getter(name="aclConfiguration")
    def acl_configuration(self) -> Optional[pulumi.Input['WorkGroupAclConfigurationArgs']]:
        """
        The ACL configuration for the query results.
        """
        return pulumi.get(self, "acl_configuration")

    @acl_configuration.setter
    def acl_configuration(self, value: Optional[pulumi.Input['WorkGroupAclConfigurationArgs']]):
        pulumi.set(self, "acl_configuration", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['WorkGroupEncryptionConfigurationArgs']]:
        """
        The encryption configuration for the query results.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['WorkGroupEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration$OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.

        If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `WorkGroupConfiguration$EnforceWorkGroupConfiguration` and [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter(name="removeAclConfiguration")
    def remove_acl_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true` , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to `false` or not set, and a value is present in the `AclConfiguration` of `ResultConfigurationUpdates` , the `AclConfiguration` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_acl_configuration")

    @remove_acl_configuration.setter
    def remove_acl_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_acl_configuration", value)

    @property
    @pulumi.getter(name="removeEncryptionConfiguration")
    def remove_encryption_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_encryption_configuration")

    @remove_encryption_configuration.setter
    def remove_encryption_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_encryption_configuration", value)

    @property
    @pulumi.getter(name="removeExpectedBucketOwner")
    def remove_expected_bucket_owner(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to "true", removes the AWS account ID previously specified for `ResultConfiguration$ExpectedBucketOwner` . If set to "false" or not set, and a value is present in the `ExpectedBucketOwner` in `ResultConfigurationUpdates` (the client-side setting), the `ExpectedBucketOwner` in the workgroup's `ResultConfiguration` is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_expected_bucket_owner")

    @remove_expected_bucket_owner.setter
    def remove_expected_bucket_owner(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_expected_bucket_owner", value)

    @property
    @pulumi.getter(name="removeOutputLocation")
    def remove_output_location(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see [Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "remove_output_location")

    @remove_output_location.setter
    def remove_output_location(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_output_location", value)


if not MYPY:
    class WorkGroupResultConfigurationArgsDict(TypedDict):
        """
        The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.
        """
        acl_configuration: NotRequired[pulumi.Input['WorkGroupAclConfigurationArgsDict']]
        """
        Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        """
        encryption_configuration: NotRequired[pulumi.Input['WorkGroupEncryptionConfigurationArgsDict']]
        """
        If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` and [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        expected_bucket_owner: NotRequired[pulumi.Input[str]]
        """
        The account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration:OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.

        This is a client-side setting. If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        """
        output_location: NotRequired[pulumi.Input[str]]
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) and `EnforceWorkGroupConfiguration` .
        """
elif False:
    WorkGroupResultConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkGroupResultConfigurationArgs:
    def __init__(__self__, *,
                 acl_configuration: Optional[pulumi.Input['WorkGroupAclConfigurationArgs']] = None,
                 encryption_configuration: Optional[pulumi.Input['WorkGroupEncryptionConfigurationArgs']] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input[str]] = None):
        """
        The location in Amazon S3 where query results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.

        :param pulumi.Input['WorkGroupAclConfigurationArgs'] acl_configuration: Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        :param pulumi.Input['WorkGroupEncryptionConfigurationArgs'] encryption_configuration: If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` and [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        :param pulumi.Input[str] expected_bucket_owner: The account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration:OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
               
               This is a client-side setting. If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        :param pulumi.Input[str] output_location: The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) and `EnforceWorkGroupConfiguration` .
        """
        if acl_configuration is not None:
            pulumi.set(__self__, "acl_configuration", acl_configuration)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)

    @property
    @pulumi.getter(name="aclConfiguration")
    def acl_configuration(self) -> Optional[pulumi.Input['WorkGroupAclConfigurationArgs']]:
        """
        Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. Currently the only supported canned ACL is `BUCKET_OWNER_FULL_CONTROL` . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "acl_configuration")

    @acl_configuration.setter
    def acl_configuration(self, value: Optional[pulumi.Input['WorkGroupAclConfigurationArgs']]):
        pulumi.set(self, "acl_configuration", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['WorkGroupEncryptionConfigurationArgs']]:
        """
        If query results are encrypted in Amazon S3, indicates the encryption option used (for example, `SSE_KMS` or `CSE_KMS` ) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` and [Override client-side settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html) .
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['WorkGroupEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID that you expect to be the owner of the Amazon S3 bucket specified by `ResultConfiguration:OutputLocation` . If set, Athena uses the value for `ExpectedBucketOwner` when it makes Amazon S3 calls to your specified output location. If the `ExpectedBucketOwner` account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.

        This is a client-side setting. If workgroup settings override client-side settings, then the query uses the `ExpectedBucketOwner` setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/` . To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see [Work with query results and recent queries](https://docs.aws.amazon.com/athena/latest/ug/querying.html) and `EnforceWorkGroupConfiguration` .
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_location", value)


