# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetZonalAutoshiftConfigurationResult',
    'AwaitableGetZonalAutoshiftConfigurationResult',
    'get_zonal_autoshift_configuration',
    'get_zonal_autoshift_configuration_output',
]

@pulumi.output_type
class GetZonalAutoshiftConfigurationResult:
    def __init__(__self__, practice_run_configuration=None, zonal_autoshift_status=None):
        if practice_run_configuration and not isinstance(practice_run_configuration, dict):
            raise TypeError("Expected argument 'practice_run_configuration' to be a dict")
        pulumi.set(__self__, "practice_run_configuration", practice_run_configuration)
        if zonal_autoshift_status and not isinstance(zonal_autoshift_status, str):
            raise TypeError("Expected argument 'zonal_autoshift_status' to be a str")
        pulumi.set(__self__, "zonal_autoshift_status", zonal_autoshift_status)

    @property
    @pulumi.getter(name="practiceRunConfiguration")
    def practice_run_configuration(self) -> Optional['outputs.ZonalAutoshiftConfigurationPracticeRunConfiguration']:
        """
        A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run. When a resource has a practice run configuration, Route 53 ARC shifts traffic for the resource weekly for practice runs.

        Practice runs are required for zonal autoshift. The zonal shifts that Route 53 ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.

        You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
        """
        return pulumi.get(self, "practice_run_configuration")

    @property
    @pulumi.getter(name="zonalAutoshiftStatus")
    def zonal_autoshift_status(self) -> Optional['ZonalAutoshiftConfigurationZonalAutoshiftStatus']:
        """
        When zonal autoshift is `ENABLED` , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away for the required weekly practice runs.
        """
        return pulumi.get(self, "zonal_autoshift_status")


class AwaitableGetZonalAutoshiftConfigurationResult(GetZonalAutoshiftConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZonalAutoshiftConfigurationResult(
            practice_run_configuration=self.practice_run_configuration,
            zonal_autoshift_status=self.zonal_autoshift_status)


def get_zonal_autoshift_configuration(resource_identifier: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZonalAutoshiftConfigurationResult:
    """
    Definition of AWS::ARCZonalShift::ZonalAutoshiftConfiguration Resource Type


    :param str resource_identifier: The identifier for the resource that AWS shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.
           
           At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.
    """
    __args__ = dict()
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:arczonalshift:getZonalAutoshiftConfiguration', __args__, opts=opts, typ=GetZonalAutoshiftConfigurationResult).value

    return AwaitableGetZonalAutoshiftConfigurationResult(
        practice_run_configuration=pulumi.get(__ret__, 'practice_run_configuration'),
        zonal_autoshift_status=pulumi.get(__ret__, 'zonal_autoshift_status'))
def get_zonal_autoshift_configuration_output(resource_identifier: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetZonalAutoshiftConfigurationResult]:
    """
    Definition of AWS::ARCZonalShift::ZonalAutoshiftConfiguration Resource Type


    :param str resource_identifier: The identifier for the resource that AWS shifts traffic for. The identifier is the Amazon Resource Name (ARN) for the resource.
           
           At this time, supported resources are Network Load Balancers and Application Load Balancers with cross-zone load balancing turned off.
    """
    __args__ = dict()
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:arczonalshift:getZonalAutoshiftConfiguration', __args__, opts=opts, typ=GetZonalAutoshiftConfigurationResult)
    return __ret__.apply(lambda __response__: GetZonalAutoshiftConfigurationResult(
        practice_run_configuration=pulumi.get(__response__, 'practice_run_configuration'),
        zonal_autoshift_status=pulumi.get(__response__, 'zonal_autoshift_status')))
