# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ZonalAutoshiftConfigurationControlConditionArgs',
    'ZonalAutoshiftConfigurationControlConditionArgsDict',
    'ZonalAutoshiftConfigurationPracticeRunConfigurationArgs',
    'ZonalAutoshiftConfigurationPracticeRunConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class ZonalAutoshiftConfigurationControlConditionArgsDict(TypedDict):
        alarm_identifier: pulumi.Input[str]
        """
        The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.
        """
        type: pulumi.Input[str]
        """
        The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is `CLOUDWATCH` .
        """
elif False:
    ZonalAutoshiftConfigurationControlConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ZonalAutoshiftConfigurationControlConditionArgs:
    def __init__(__self__, *,
                 alarm_identifier: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] alarm_identifier: The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.
        :param pulumi.Input[str] type: The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is `CLOUDWATCH` .
        """
        pulumi.set(__self__, "alarm_identifier", alarm_identifier)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="alarmIdentifier")
    def alarm_identifier(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.
        """
        return pulumi.get(self, "alarm_identifier")

    @alarm_identifier.setter
    def alarm_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "alarm_identifier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of alarm specified for a practice run. You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is `CLOUDWATCH` .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ZonalAutoshiftConfigurationPracticeRunConfigurationArgsDict(TypedDict):
        outcome_alarms: pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgsDict']]]
        """
        The alarm that you specify to monitor the health of your application during practice runs. When the outcome alarm goes into an `ALARM` state, the practice run is ended and the outcome is set to `FAILED` .
        """
        blocked_dates: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        An array of one or more dates that you can specify when AWS does not start practice runs for a resource. Dates are in UTC.

        Specify blocked dates in the format `YYYY-MM-DD` , separated by spaces.
        """
        blocked_windows: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        An array of one or more days and times that you can specify when Route 53 ARC does not start practice runs for a resource. Days and times are in UTC.

        Specify blocked windows in the format `DAY:HH:MM-DAY:HH:MM` , separated by spaces. For example, `MON:18:30-MON:19:30 TUE:18:30-TUE:19:30` .
        """
        blocking_alarms: NotRequired[pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgsDict']]]]
        """
        An optional alarm that you can specify that blocks practice runs when the alarm is in an `ALARM` state. When a blocking alarm goes into an `ALARM` state, it prevents practice runs from being started, and ends practice runs that are in progress.
        """
elif False:
    ZonalAutoshiftConfigurationPracticeRunConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ZonalAutoshiftConfigurationPracticeRunConfigurationArgs:
    def __init__(__self__, *,
                 outcome_alarms: pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]],
                 blocked_dates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocked_windows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blocking_alarms: Optional[pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]] outcome_alarms: The alarm that you specify to monitor the health of your application during practice runs. When the outcome alarm goes into an `ALARM` state, the practice run is ended and the outcome is set to `FAILED` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_dates: An array of one or more dates that you can specify when AWS does not start practice runs for a resource. Dates are in UTC.
               
               Specify blocked dates in the format `YYYY-MM-DD` , separated by spaces.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blocked_windows: An array of one or more days and times that you can specify when Route 53 ARC does not start practice runs for a resource. Days and times are in UTC.
               
               Specify blocked windows in the format `DAY:HH:MM-DAY:HH:MM` , separated by spaces. For example, `MON:18:30-MON:19:30 TUE:18:30-TUE:19:30` .
        :param pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]] blocking_alarms: An optional alarm that you can specify that blocks practice runs when the alarm is in an `ALARM` state. When a blocking alarm goes into an `ALARM` state, it prevents practice runs from being started, and ends practice runs that are in progress.
        """
        pulumi.set(__self__, "outcome_alarms", outcome_alarms)
        if blocked_dates is not None:
            pulumi.set(__self__, "blocked_dates", blocked_dates)
        if blocked_windows is not None:
            pulumi.set(__self__, "blocked_windows", blocked_windows)
        if blocking_alarms is not None:
            pulumi.set(__self__, "blocking_alarms", blocking_alarms)

    @property
    @pulumi.getter(name="outcomeAlarms")
    def outcome_alarms(self) -> pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]]:
        """
        The alarm that you specify to monitor the health of your application during practice runs. When the outcome alarm goes into an `ALARM` state, the practice run is ended and the outcome is set to `FAILED` .
        """
        return pulumi.get(self, "outcome_alarms")

    @outcome_alarms.setter
    def outcome_alarms(self, value: pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]]):
        pulumi.set(self, "outcome_alarms", value)

    @property
    @pulumi.getter(name="blockedDates")
    def blocked_dates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more dates that you can specify when AWS does not start practice runs for a resource. Dates are in UTC.

        Specify blocked dates in the format `YYYY-MM-DD` , separated by spaces.
        """
        return pulumi.get(self, "blocked_dates")

    @blocked_dates.setter
    def blocked_dates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_dates", value)

    @property
    @pulumi.getter(name="blockedWindows")
    def blocked_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more days and times that you can specify when Route 53 ARC does not start practice runs for a resource. Days and times are in UTC.

        Specify blocked windows in the format `DAY:HH:MM-DAY:HH:MM` , separated by spaces. For example, `MON:18:30-MON:19:30 TUE:18:30-TUE:19:30` .
        """
        return pulumi.get(self, "blocked_windows")

    @blocked_windows.setter
    def blocked_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "blocked_windows", value)

    @property
    @pulumi.getter(name="blockingAlarms")
    def blocking_alarms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]]]:
        """
        An optional alarm that you can specify that blocks practice runs when the alarm is in an `ALARM` state. When a blocking alarm goes into an `ALARM` state, it prevents practice runs from being started, and ends practice runs that are in progress.
        """
        return pulumi.get(self, "blocking_alarms")

    @blocking_alarms.setter
    def blocking_alarms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZonalAutoshiftConfigurationControlConditionArgs']]]]):
        pulumi.set(self, "blocking_alarms", value)


