# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ScraperArgs', 'Scraper']

@pulumi.input_type
class ScraperArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['ScraperDestinationArgs'],
                 scrape_configuration: pulumi.Input['ScraperScrapeConfigurationArgs'],
                 source: pulumi.Input['ScraperSourceArgs'],
                 alias: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Scraper resource.
        :param pulumi.Input['ScraperDestinationArgs'] destination: The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
        :param pulumi.Input['ScraperScrapeConfigurationArgs'] scrape_configuration: The configuration in use by the scraper.
        :param pulumi.Input['ScraperSourceArgs'] source: The Amazon EKS cluster from which the scraper collects metrics.
        :param pulumi.Input[str] alias: Scraper alias.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "scrape_configuration", scrape_configuration)
        pulumi.set(__self__, "source", source)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['ScraperDestinationArgs']:
        """
        The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['ScraperDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="scrapeConfiguration")
    def scrape_configuration(self) -> pulumi.Input['ScraperScrapeConfigurationArgs']:
        """
        The configuration in use by the scraper.
        """
        return pulumi.get(self, "scrape_configuration")

    @scrape_configuration.setter
    def scrape_configuration(self, value: pulumi.Input['ScraperScrapeConfigurationArgs']):
        pulumi.set(self, "scrape_configuration", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['ScraperSourceArgs']:
        """
        The Amazon EKS cluster from which the scraper collects metrics.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['ScraperSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Scraper alias.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Scraper(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[Union['ScraperDestinationArgs', 'ScraperDestinationArgsDict']]] = None,
                 scrape_configuration: Optional[pulumi.Input[Union['ScraperScrapeConfigurationArgs', 'ScraperScrapeConfigurationArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['ScraperSourceArgs', 'ScraperSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::APS::Scraper

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: Scraper alias.
        :param pulumi.Input[Union['ScraperDestinationArgs', 'ScraperDestinationArgsDict']] destination: The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
        :param pulumi.Input[Union['ScraperScrapeConfigurationArgs', 'ScraperScrapeConfigurationArgsDict']] scrape_configuration: The configuration in use by the scraper.
        :param pulumi.Input[Union['ScraperSourceArgs', 'ScraperSourceArgsDict']] source: The Amazon EKS cluster from which the scraper collects metrics.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScraperArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::APS::Scraper

        :param str resource_name: The name of the resource.
        :param ScraperArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScraperArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[Union['ScraperDestinationArgs', 'ScraperDestinationArgsDict']]] = None,
                 scrape_configuration: Optional[pulumi.Input[Union['ScraperScrapeConfigurationArgs', 'ScraperScrapeConfigurationArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['ScraperSourceArgs', 'ScraperSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScraperArgs.__new__(ScraperArgs)

            __props__.__dict__["alias"] = alias
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if scrape_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'scrape_configuration'")
            __props__.__dict__["scrape_configuration"] = scrape_configuration
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["role_arn"] = None
            __props__.__dict__["scraper_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["alias", "destination", "scrapeConfiguration", "source"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Scraper, __self__).__init__(
            'aws-native:aps:Scraper',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Scraper':
        """
        Get an existing Scraper resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ScraperArgs.__new__(ScraperArgs)

        __props__.__dict__["alias"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["destination"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["scrape_configuration"] = None
        __props__.__dict__["scraper_id"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["tags"] = None
        return Scraper(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[str]]:
        """
        Scraper alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Scraper ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.ScraperDestination']:
        """
        The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        IAM role ARN for the scraper.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="scrapeConfiguration")
    def scrape_configuration(self) -> pulumi.Output['outputs.ScraperScrapeConfiguration']:
        """
        The configuration in use by the scraper.
        """
        return pulumi.get(self, "scrape_configuration")

    @property
    @pulumi.getter(name="scraperId")
    def scraper_id(self) -> pulumi.Output[str]:
        """
        Required to identify a specific scraper.
        """
        return pulumi.get(self, "scraper_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.ScraperSource']:
        """
        The Amazon EKS cluster from which the scraper collects metrics.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

