# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ScraperDestinationAmpConfigurationPropertiesArgs',
    'ScraperDestinationAmpConfigurationPropertiesArgsDict',
    'ScraperDestinationArgs',
    'ScraperDestinationArgsDict',
    'ScraperScrapeConfigurationArgs',
    'ScraperScrapeConfigurationArgsDict',
    'ScraperSourceEksConfigurationPropertiesArgs',
    'ScraperSourceEksConfigurationPropertiesArgsDict',
    'ScraperSourceArgs',
    'ScraperSourceArgsDict',
    'WorkspaceLoggingConfigurationArgs',
    'WorkspaceLoggingConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class ScraperDestinationAmpConfigurationPropertiesArgsDict(TypedDict):
        """
        Configuration for Amazon Managed Prometheus metrics destination
        """
        workspace_arn: pulumi.Input[str]
        """
        ARN of an Amazon Managed Prometheus workspace
        """
elif False:
    ScraperDestinationAmpConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperDestinationAmpConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 workspace_arn: pulumi.Input[str]):
        """
        Configuration for Amazon Managed Prometheus metrics destination
        :param pulumi.Input[str] workspace_arn: ARN of an Amazon Managed Prometheus workspace
        """
        pulumi.set(__self__, "workspace_arn", workspace_arn)

    @property
    @pulumi.getter(name="workspaceArn")
    def workspace_arn(self) -> pulumi.Input[str]:
        """
        ARN of an Amazon Managed Prometheus workspace
        """
        return pulumi.get(self, "workspace_arn")

    @workspace_arn.setter
    def workspace_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_arn", value)


if not MYPY:
    class ScraperDestinationArgsDict(TypedDict):
        """
        Scraper metrics destination
        """
        amp_configuration: NotRequired[pulumi.Input['ScraperDestinationAmpConfigurationPropertiesArgsDict']]
        """
        Configuration for Amazon Managed Prometheus metrics destination
        """
elif False:
    ScraperDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperDestinationArgs:
    def __init__(__self__, *,
                 amp_configuration: Optional[pulumi.Input['ScraperDestinationAmpConfigurationPropertiesArgs']] = None):
        """
        Scraper metrics destination
        :param pulumi.Input['ScraperDestinationAmpConfigurationPropertiesArgs'] amp_configuration: Configuration for Amazon Managed Prometheus metrics destination
        """
        if amp_configuration is not None:
            pulumi.set(__self__, "amp_configuration", amp_configuration)

    @property
    @pulumi.getter(name="ampConfiguration")
    def amp_configuration(self) -> Optional[pulumi.Input['ScraperDestinationAmpConfigurationPropertiesArgs']]:
        """
        Configuration for Amazon Managed Prometheus metrics destination
        """
        return pulumi.get(self, "amp_configuration")

    @amp_configuration.setter
    def amp_configuration(self, value: Optional[pulumi.Input['ScraperDestinationAmpConfigurationPropertiesArgs']]):
        pulumi.set(self, "amp_configuration", value)


if not MYPY:
    class ScraperScrapeConfigurationArgsDict(TypedDict):
        """
        Scraper configuration
        """
        configuration_blob: NotRequired[pulumi.Input[str]]
        """
        Prometheus compatible scrape configuration in base64 encoded blob format
        """
elif False:
    ScraperScrapeConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperScrapeConfigurationArgs:
    def __init__(__self__, *,
                 configuration_blob: Optional[pulumi.Input[str]] = None):
        """
        Scraper configuration
        :param pulumi.Input[str] configuration_blob: Prometheus compatible scrape configuration in base64 encoded blob format
        """
        if configuration_blob is not None:
            pulumi.set(__self__, "configuration_blob", configuration_blob)

    @property
    @pulumi.getter(name="configurationBlob")
    def configuration_blob(self) -> Optional[pulumi.Input[str]]:
        """
        Prometheus compatible scrape configuration in base64 encoded blob format
        """
        return pulumi.get(self, "configuration_blob")

    @configuration_blob.setter
    def configuration_blob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_blob", value)


if not MYPY:
    class ScraperSourceEksConfigurationPropertiesArgsDict(TypedDict):
        """
        Configuration for EKS metrics source
        """
        cluster_arn: pulumi.Input[str]
        """
        ARN of an EKS cluster
        """
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        List of subnet IDs
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of security group IDs
        """
elif False:
    ScraperSourceEksConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperSourceEksConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 cluster_arn: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Configuration for EKS metrics source
        :param pulumi.Input[str] cluster_arn: ARN of an EKS cluster
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group IDs
        """
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> pulumi.Input[str]:
        """
        ARN of an EKS cluster
        """
        return pulumi.get(self, "cluster_arn")

    @cluster_arn.setter
    def cluster_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_arn", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of subnet IDs
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of security group IDs
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)


if not MYPY:
    class ScraperSourceArgsDict(TypedDict):
        """
        Scraper metrics source
        """
        eks_configuration: NotRequired[pulumi.Input['ScraperSourceEksConfigurationPropertiesArgsDict']]
        """
        Configuration for EKS metrics source
        """
elif False:
    ScraperSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScraperSourceArgs:
    def __init__(__self__, *,
                 eks_configuration: Optional[pulumi.Input['ScraperSourceEksConfigurationPropertiesArgs']] = None):
        """
        Scraper metrics source
        :param pulumi.Input['ScraperSourceEksConfigurationPropertiesArgs'] eks_configuration: Configuration for EKS metrics source
        """
        if eks_configuration is not None:
            pulumi.set(__self__, "eks_configuration", eks_configuration)

    @property
    @pulumi.getter(name="eksConfiguration")
    def eks_configuration(self) -> Optional[pulumi.Input['ScraperSourceEksConfigurationPropertiesArgs']]:
        """
        Configuration for EKS metrics source
        """
        return pulumi.get(self, "eks_configuration")

    @eks_configuration.setter
    def eks_configuration(self, value: Optional[pulumi.Input['ScraperSourceEksConfigurationPropertiesArgs']]):
        pulumi.set(self, "eks_configuration", value)


if not MYPY:
    class WorkspaceLoggingConfigurationArgsDict(TypedDict):
        """
        Logging configuration
        """
        log_group_arn: NotRequired[pulumi.Input[str]]
        """
        CloudWatch log group ARN
        """
elif False:
    WorkspaceLoggingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceLoggingConfigurationArgs:
    def __init__(__self__, *,
                 log_group_arn: Optional[pulumi.Input[str]] = None):
        """
        Logging configuration
        :param pulumi.Input[str] log_group_arn: CloudWatch log group ARN
        """
        if log_group_arn is not None:
            pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        CloudWatch log group ARN
        """
        return pulumi.get(self, "log_group_arn")

    @log_group_arn.setter
    def log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_arn", value)


