# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'FunctionConfigurationAppSyncRuntime',
    'FunctionConfigurationLambdaConflictHandlerConfig',
    'FunctionConfigurationSyncConfig',
    'ResolverAppSyncRuntime',
    'ResolverCachingConfig',
    'ResolverLambdaConflictHandlerConfig',
    'ResolverPipelineConfig',
    'ResolverSyncConfig',
    'SourceApiAssociationConfig',
]

@pulumi.output_type
class FunctionConfigurationAppSyncRuntime(dict):
    """
    Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfigurationAppSyncRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfigurationAppSyncRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfigurationAppSyncRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 runtime_version: str):
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param str name: The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        :param str runtime_version: The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> str:
        """
        The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FunctionConfigurationLambdaConflictHandlerConfig(dict):
    """
    The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfigurationLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfigurationLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfigurationLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[str] = None):
        """
        The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
        :param str lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class FunctionConfigurationSyncConfig(dict):
    """
    Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfigurationSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfigurationSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfigurationSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: str,
                 conflict_handler: Optional[str] = None,
                 lambda_conflict_handler_config: Optional['outputs.FunctionConfigurationLambdaConflictHandlerConfig'] = None):
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param str conflict_detection: The Conflict Detection strategy to use.
        :param str conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
        :param 'FunctionConfigurationLambdaConflictHandlerConfig' lambda_conflict_handler_config: The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> str:
        """
        The Conflict Detection strategy to use.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[str]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.FunctionConfigurationLambdaConflictHandlerConfig']:
        """
        The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class ResolverAppSyncRuntime(dict):
    """
    Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverAppSyncRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverAppSyncRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverAppSyncRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 runtime_version: str):
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param str name: The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        :param str runtime_version: The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> str:
        """
        The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class ResolverCachingConfig(dict):
    """
    The caching configuration for a resolver that has caching activated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingKeys":
            suggest = "caching_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverCachingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ttl: float,
                 caching_keys: Optional[Sequence[str]] = None):
        """
        The caching configuration for a resolver that has caching activated.
        :param float ttl: The TTL in seconds for a resolver that has caching activated.
                Valid values are 1–3,600 seconds.
        :param Sequence[str] caching_keys: The caching keys for a resolver that has caching activated.
                Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        pulumi.set(__self__, "ttl", ttl)
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)

    @property
    @pulumi.getter
    def ttl(self) -> float:
        """
        The TTL in seconds for a resolver that has caching activated.
         Valid values are 1–3,600 seconds.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[Sequence[str]]:
        """
        The caching keys for a resolver that has caching activated.
         Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        return pulumi.get(self, "caching_keys")


@pulumi.output_type
class ResolverLambdaConflictHandlerConfig(dict):
    """
    The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[str] = None):
        """
        The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
        :param str lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class ResolverPipelineConfig(dict):
    """
    Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
      ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
    """
    def __init__(__self__, *,
                 functions: Optional[Sequence[str]] = None):
        """
        Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
          ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
        :param Sequence[str] functions: A list of ``Function`` objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence[str]]:
        """
        A list of ``Function`` objects.
        """
        return pulumi.get(self, "functions")


@pulumi.output_type
class ResolverSyncConfig(dict):
    """
    Describes a Sync configuration for a resolver.
     Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: str,
                 conflict_handler: Optional[str] = None,
                 lambda_conflict_handler_config: Optional['outputs.ResolverLambdaConflictHandlerConfig'] = None):
        """
        Describes a Sync configuration for a resolver.
         Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param str conflict_detection: The Conflict Detection strategy to use.
                 +   *VERSION*: Detect conflicts based on object versions for this resolver.
                 +   *NONE*: Do not detect conflicts when invoking this resolver.
        :param str conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
                 +   *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
                 +   *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
                 +   *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        :param 'ResolverLambdaConflictHandlerConfig' lambda_conflict_handler_config: The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> str:
        """
        The Conflict Detection strategy to use.
          +   *VERSION*: Detect conflicts based on object versions for this resolver.
          +   *NONE*: Do not detect conflicts when invoking this resolver.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[str]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
          +   *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
          +   *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
          +   *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.ResolverLambdaConflictHandlerConfig']:
        """
        The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class SourceApiAssociationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mergeType":
            suggest = "merge_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceApiAssociationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceApiAssociationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceApiAssociationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 merge_type: Optional['SourceApiAssociationConfigMergeType'] = None):
        """
        :param 'SourceApiAssociationConfigMergeType' merge_type: Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        if merge_type is not None:
            pulumi.set(__self__, "merge_type", merge_type)

    @property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> Optional['SourceApiAssociationConfigMergeType']:
        """
        Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        return pulumi.get(self, "merge_type")


