# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionConfigurationArgs', 'FunctionConfiguration']

@pulumi.input_type
class FunctionConfigurationArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[str],
                 data_source_name: pulumi.Input[str],
                 code: Optional[pulumi.Input[str]] = None,
                 code_s3_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 max_batch_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_mapping_template: Optional[pulumi.Input[str]] = None,
                 request_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 response_mapping_template: Optional[pulumi.Input[str]] = None,
                 response_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input['FunctionConfigurationAppSyncRuntimeArgs']] = None,
                 sync_config: Optional[pulumi.Input['FunctionConfigurationSyncConfigArgs']] = None):
        """
        The set of arguments for constructing a FunctionConfiguration resource.
        :param pulumi.Input[str] api_id: The AWS AppSync GraphQL API that you want to attach using this function.
        :param pulumi.Input[str] data_source_name: The name of data source this function will attach.
        :param pulumi.Input[str] code: The resolver code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        :param pulumi.Input[str] code_s3_location: The Amazon S3 endpoint (where the code is located??).
        :param pulumi.Input[str] description: The function description.
        :param pulumi.Input[str] function_version: The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
        :param pulumi.Input[int] max_batch_size: The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
        :param pulumi.Input[str] name: The name of the function.
        :param pulumi.Input[str] request_mapping_template: The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
        :param pulumi.Input[str] request_mapping_template_s3_location: Describes a Sync configuration for a resolver. Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
        :param pulumi.Input[str] response_mapping_template: The Function response mapping template.
        :param pulumi.Input[str] response_mapping_template_s3_location: The location of a response mapping template in an Amazon S3 bucket. Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
        :param pulumi.Input['FunctionConfigurationAppSyncRuntimeArgs'] runtime: Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input['FunctionConfigurationSyncConfigArgs'] sync_config: Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "data_source_name", data_source_name)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_s3_location is not None:
            pulumi.set(__self__, "code_s3_location", code_s3_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_mapping_template is not None:
            pulumi.set(__self__, "request_mapping_template", request_mapping_template)
        if request_mapping_template_s3_location is not None:
            pulumi.set(__self__, "request_mapping_template_s3_location", request_mapping_template_s3_location)
        if response_mapping_template is not None:
            pulumi.set(__self__, "response_mapping_template", response_mapping_template)
        if response_mapping_template_s3_location is not None:
            pulumi.set(__self__, "response_mapping_template_s3_location", response_mapping_template_s3_location)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sync_config is not None:
            pulumi.set(__self__, "sync_config", sync_config)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[str]:
        """
        The AWS AppSync GraphQL API that you want to attach using this function.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Input[str]:
        """
        The name of data source this function will attach.
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source_name", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        The resolver code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeS3Location")
    def code_s3_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon S3 endpoint (where the code is located??).
        """
        return pulumi.get(self, "code_s3_location")

    @code_s3_location.setter
    def code_s3_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_s3_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The function description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_version", value)

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_batch_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requestMappingTemplate")
    def request_mapping_template(self) -> Optional[pulumi.Input[str]]:
        """
        The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
        """
        return pulumi.get(self, "request_mapping_template")

    @request_mapping_template.setter
    def request_mapping_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_mapping_template", value)

    @property
    @pulumi.getter(name="requestMappingTemplateS3Location")
    def request_mapping_template_s3_location(self) -> Optional[pulumi.Input[str]]:
        """
        Describes a Sync configuration for a resolver. Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
        """
        return pulumi.get(self, "request_mapping_template_s3_location")

    @request_mapping_template_s3_location.setter
    def request_mapping_template_s3_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_mapping_template_s3_location", value)

    @property
    @pulumi.getter(name="responseMappingTemplate")
    def response_mapping_template(self) -> Optional[pulumi.Input[str]]:
        """
        The Function response mapping template.
        """
        return pulumi.get(self, "response_mapping_template")

    @response_mapping_template.setter
    def response_mapping_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_mapping_template", value)

    @property
    @pulumi.getter(name="responseMappingTemplateS3Location")
    def response_mapping_template_s3_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of a response mapping template in an Amazon S3 bucket. Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
        """
        return pulumi.get(self, "response_mapping_template_s3_location")

    @response_mapping_template_s3_location.setter
    def response_mapping_template_s3_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_mapping_template_s3_location", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['FunctionConfigurationAppSyncRuntimeArgs']]:
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['FunctionConfigurationAppSyncRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional[pulumi.Input['FunctionConfigurationSyncConfigArgs']]:
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        return pulumi.get(self, "sync_config")

    @sync_config.setter
    def sync_config(self, value: Optional[pulumi.Input['FunctionConfigurationSyncConfigArgs']]):
        pulumi.set(self, "sync_config", value)


class FunctionConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 code_s3_location: Optional[pulumi.Input[str]] = None,
                 data_source_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 max_batch_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_mapping_template: Optional[pulumi.Input[str]] = None,
                 request_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 response_mapping_template: Optional[pulumi.Input[str]] = None,
                 response_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[Union['FunctionConfigurationAppSyncRuntimeArgs', 'FunctionConfigurationAppSyncRuntimeArgsDict']]] = None,
                 sync_config: Optional[pulumi.Input[Union['FunctionConfigurationSyncConfigArgs', 'FunctionConfigurationSyncConfigArgsDict']]] = None,
                 __props__=None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        name = config.require("name")
        description = config.require("description")
        data_source_name = config.require("dataSourceName")
        function_version = config.require("functionVersion")
        request_mapping_template_s3_location_input = config.require("requestMappingTemplateS3LocationInput")
        response_mapping_template_s3_location_input = config.require("responseMappingTemplateS3LocationInput")
        function_configuration = aws_native.appsync.FunctionConfiguration("functionConfiguration",
            api_id=graph_ql_api_id,
            name=name,
            description=description,
            function_version=function_version,
            data_source_name=data_source_name,
            request_mapping_template_s3_location=request_mapping_template_s3_location_input,
            response_mapping_template_s3_location=response_mapping_template_s3_location_input)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_id: The AWS AppSync GraphQL API that you want to attach using this function.
        :param pulumi.Input[str] code: The resolver code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        :param pulumi.Input[str] code_s3_location: The Amazon S3 endpoint (where the code is located??).
        :param pulumi.Input[str] data_source_name: The name of data source this function will attach.
        :param pulumi.Input[str] description: The function description.
        :param pulumi.Input[str] function_version: The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
        :param pulumi.Input[int] max_batch_size: The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
        :param pulumi.Input[str] name: The name of the function.
        :param pulumi.Input[str] request_mapping_template: The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
        :param pulumi.Input[str] request_mapping_template_s3_location: Describes a Sync configuration for a resolver. Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
        :param pulumi.Input[str] response_mapping_template: The Function response mapping template.
        :param pulumi.Input[str] response_mapping_template_s3_location: The location of a response mapping template in an Amazon S3 bucket. Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
        :param pulumi.Input[Union['FunctionConfigurationAppSyncRuntimeArgs', 'FunctionConfigurationAppSyncRuntimeArgsDict']] runtime: Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input[Union['FunctionConfigurationSyncConfigArgs', 'FunctionConfigurationSyncConfigArgsDict']] sync_config: Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        name = config.require("name")
        description = config.require("description")
        data_source_name = config.require("dataSourceName")
        function_version = config.require("functionVersion")
        request_mapping_template_s3_location_input = config.require("requestMappingTemplateS3LocationInput")
        response_mapping_template_s3_location_input = config.require("responseMappingTemplateS3LocationInput")
        function_configuration = aws_native.appsync.FunctionConfiguration("functionConfiguration",
            api_id=graph_ql_api_id,
            name=name,
            description=description,
            function_version=function_version,
            data_source_name=data_source_name,
            request_mapping_template_s3_location=request_mapping_template_s3_location_input,
            response_mapping_template_s3_location=response_mapping_template_s3_location_input)

        ```

        :param str resource_name: The name of the resource.
        :param FunctionConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 code_s3_location: Optional[pulumi.Input[str]] = None,
                 data_source_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 function_version: Optional[pulumi.Input[str]] = None,
                 max_batch_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_mapping_template: Optional[pulumi.Input[str]] = None,
                 request_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 response_mapping_template: Optional[pulumi.Input[str]] = None,
                 response_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[Union['FunctionConfigurationAppSyncRuntimeArgs', 'FunctionConfigurationAppSyncRuntimeArgsDict']]] = None,
                 sync_config: Optional[pulumi.Input[Union['FunctionConfigurationSyncConfigArgs', 'FunctionConfigurationSyncConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionConfigurationArgs.__new__(FunctionConfigurationArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["code"] = code
            __props__.__dict__["code_s3_location"] = code_s3_location
            if data_source_name is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_name'")
            __props__.__dict__["data_source_name"] = data_source_name
            __props__.__dict__["description"] = description
            __props__.__dict__["function_version"] = function_version
            __props__.__dict__["max_batch_size"] = max_batch_size
            __props__.__dict__["name"] = name
            __props__.__dict__["request_mapping_template"] = request_mapping_template
            __props__.__dict__["request_mapping_template_s3_location"] = request_mapping_template_s3_location
            __props__.__dict__["response_mapping_template"] = response_mapping_template
            __props__.__dict__["response_mapping_template_s3_location"] = response_mapping_template_s3_location
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["sync_config"] = sync_config
            __props__.__dict__["function_arn"] = None
            __props__.__dict__["function_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["apiId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FunctionConfiguration, __self__).__init__(
            'aws-native:appsync:FunctionConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FunctionConfiguration':
        """
        Get an existing FunctionConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FunctionConfigurationArgs.__new__(FunctionConfigurationArgs)

        __props__.__dict__["api_id"] = None
        __props__.__dict__["code"] = None
        __props__.__dict__["code_s3_location"] = None
        __props__.__dict__["data_source_name"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["function_arn"] = None
        __props__.__dict__["function_id"] = None
        __props__.__dict__["function_version"] = None
        __props__.__dict__["max_batch_size"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["request_mapping_template"] = None
        __props__.__dict__["request_mapping_template_s3_location"] = None
        __props__.__dict__["response_mapping_template"] = None
        __props__.__dict__["response_mapping_template_s3_location"] = None
        __props__.__dict__["runtime"] = None
        __props__.__dict__["sync_config"] = None
        return FunctionConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[str]:
        """
        The AWS AppSync GraphQL API that you want to attach using this function.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[str]]:
        """
        The resolver code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="codeS3Location")
    def code_s3_location(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon S3 endpoint (where the code is located??).
        """
        return pulumi.get(self, "code_s3_location")

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[str]:
        """
        The name of data source this function will attach.
        """
        return pulumi.get(self, "data_source_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The function description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the function generated by the service
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> pulumi.Output[str]:
        """
        The unique identifier for the function generated by the service
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
        """
        return pulumi.get(self, "function_version")

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
        """
        return pulumi.get(self, "max_batch_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the function.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestMappingTemplate")
    def request_mapping_template(self) -> pulumi.Output[Optional[str]]:
        """
        The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
        """
        return pulumi.get(self, "request_mapping_template")

    @property
    @pulumi.getter(name="requestMappingTemplateS3Location")
    def request_mapping_template_s3_location(self) -> pulumi.Output[Optional[str]]:
        """
        Describes a Sync configuration for a resolver. Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
        """
        return pulumi.get(self, "request_mapping_template_s3_location")

    @property
    @pulumi.getter(name="responseMappingTemplate")
    def response_mapping_template(self) -> pulumi.Output[Optional[str]]:
        """
        The Function response mapping template.
        """
        return pulumi.get(self, "response_mapping_template")

    @property
    @pulumi.getter(name="responseMappingTemplateS3Location")
    def response_mapping_template_s3_location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of a response mapping template in an Amazon S3 bucket. Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
        """
        return pulumi.get(self, "response_mapping_template_s3_location")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional['outputs.FunctionConfigurationAppSyncRuntime']]:
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> pulumi.Output[Optional['outputs.FunctionConfigurationSyncConfig']]:
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        return pulumi.get(self, "sync_config")

