# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'FunctionConfigurationAppSyncRuntimeArgs',
    'FunctionConfigurationAppSyncRuntimeArgsDict',
    'FunctionConfigurationLambdaConflictHandlerConfigArgs',
    'FunctionConfigurationLambdaConflictHandlerConfigArgsDict',
    'FunctionConfigurationSyncConfigArgs',
    'FunctionConfigurationSyncConfigArgsDict',
    'ResolverAppSyncRuntimeArgs',
    'ResolverAppSyncRuntimeArgsDict',
    'ResolverCachingConfigArgs',
    'ResolverCachingConfigArgsDict',
    'ResolverLambdaConflictHandlerConfigArgs',
    'ResolverLambdaConflictHandlerConfigArgsDict',
    'ResolverPipelineConfigArgs',
    'ResolverPipelineConfigArgsDict',
    'ResolverSyncConfigArgs',
    'ResolverSyncConfigArgsDict',
    'SourceApiAssociationConfigArgs',
    'SourceApiAssociationConfigArgsDict',
]

MYPY = False

if not MYPY:
    class FunctionConfigurationAppSyncRuntimeArgsDict(TypedDict):
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        name: pulumi.Input[str]
        """
        The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        """
        runtime_version: pulumi.Input[str]
        """
        The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
elif False:
    FunctionConfigurationAppSyncRuntimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigurationAppSyncRuntimeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 runtime_version: pulumi.Input[str]):
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input[str] name: The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        :param pulumi.Input[str] runtime_version: The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the runtime to use. Currently, the only allowed value is APPSYNC_JS.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[str]:
        """
        The version of the runtime to use. Currently, the only allowed version is 1.0.0.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_version", value)


if not MYPY:
    class FunctionConfigurationLambdaConflictHandlerConfigArgsDict(TypedDict):
        """
        The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
        """
        lambda_conflict_handler_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
elif False:
    FunctionConfigurationLambdaConflictHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigurationLambdaConflictHandlerConfigArgs:
    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[pulumi.Input[str]] = None):
        """
        The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict Handler.
        :param pulumi.Input[str] lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")

    @lambda_conflict_handler_arn.setter
    def lambda_conflict_handler_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_conflict_handler_arn", value)


if not MYPY:
    class FunctionConfigurationSyncConfigArgsDict(TypedDict):
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        conflict_detection: pulumi.Input[str]
        """
        The Conflict Detection strategy to use.
        """
        conflict_handler: NotRequired[pulumi.Input[str]]
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
        """
        lambda_conflict_handler_config: NotRequired[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgsDict']]
        """
        The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
elif False:
    FunctionConfigurationSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FunctionConfigurationSyncConfigArgs:
    def __init__(__self__, *,
                 conflict_detection: pulumi.Input[str],
                 conflict_handler: Optional[pulumi.Input[str]] = None,
                 lambda_conflict_handler_config: Optional[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs']] = None):
        """
        Describes a Sync configuration for a resolver. Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param pulumi.Input[str] conflict_detection: The Conflict Detection strategy to use.
        :param pulumi.Input[str] conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
        :param pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs'] lambda_conflict_handler_config: The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> pulumi.Input[str]:
        """
        The Conflict Detection strategy to use.
        """
        return pulumi.get(self, "conflict_detection")

    @conflict_detection.setter
    def conflict_detection(self, value: pulumi.Input[str]):
        pulumi.set(self, "conflict_detection", value)

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[pulumi.Input[str]]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
        """
        return pulumi.get(self, "conflict_handler")

    @conflict_handler.setter
    def conflict_handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_handler", value)

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs']]:
        """
        The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")

    @lambda_conflict_handler_config.setter
    def lambda_conflict_handler_config(self, value: Optional[pulumi.Input['FunctionConfigurationLambdaConflictHandlerConfigArgs']]):
        pulumi.set(self, "lambda_conflict_handler_config", value)


if not MYPY:
    class ResolverAppSyncRuntimeArgsDict(TypedDict):
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        name: pulumi.Input[str]
        """
        The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        """
        runtime_version: pulumi.Input[str]
        """
        The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
elif False:
    ResolverAppSyncRuntimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverAppSyncRuntimeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 runtime_version: pulumi.Input[str]):
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input[str] name: The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        :param pulumi.Input[str] runtime_version: The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The ``name`` of the runtime to use. Currently, the only allowed value is ``APPSYNC_JS``.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[str]:
        """
        The ``version`` of the runtime to use. Currently, the only allowed version is ``1.0.0``.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_version", value)


if not MYPY:
    class ResolverCachingConfigArgsDict(TypedDict):
        """
        The caching configuration for a resolver that has caching activated.
        """
        ttl: pulumi.Input[float]
        """
        The TTL in seconds for a resolver that has caching activated.
         Valid values are 1–3,600 seconds.
        """
        caching_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The caching keys for a resolver that has caching activated.
         Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
elif False:
    ResolverCachingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverCachingConfigArgs:
    def __init__(__self__, *,
                 ttl: pulumi.Input[float],
                 caching_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The caching configuration for a resolver that has caching activated.
        :param pulumi.Input[float] ttl: The TTL in seconds for a resolver that has caching activated.
                Valid values are 1–3,600 seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] caching_keys: The caching keys for a resolver that has caching activated.
                Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        pulumi.set(__self__, "ttl", ttl)
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[float]:
        """
        The TTL in seconds for a resolver that has caching activated.
         Valid values are 1–3,600 seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[float]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The caching keys for a resolver that has caching activated.
         Valid values are entries from the ``$context.arguments``, ``$context.source``, and ``$context.identity`` maps.
        """
        return pulumi.get(self, "caching_keys")

    @caching_keys.setter
    def caching_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "caching_keys", value)


if not MYPY:
    class ResolverLambdaConflictHandlerConfigArgsDict(TypedDict):
        """
        The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
        """
        lambda_conflict_handler_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
elif False:
    ResolverLambdaConflictHandlerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverLambdaConflictHandlerConfigArgs:
    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[pulumi.Input[str]] = None):
        """
        The ``LambdaConflictHandlerConfig`` when configuring LAMBDA as the Conflict Handler.
        :param pulumi.Input[str] lambda_conflict_handler_arn: The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")

    @lambda_conflict_handler_arn.setter
    def lambda_conflict_handler_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_conflict_handler_arn", value)


if not MYPY:
    class ResolverPipelineConfigArgsDict(TypedDict):
        """
        Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
          ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
        """
        functions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of ``Function`` objects.
        """
elif False:
    ResolverPipelineConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverPipelineConfigArgs:
    def __init__(__self__, *,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Use the ``PipelineConfig`` property type to specify ``PipelineConfig`` for an APSYlong resolver.
          ``PipelineConfig`` is a property of the [AWS::AppSync::Resolver](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html) resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] functions: A list of ``Function`` objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ``Function`` objects.
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "functions", value)


if not MYPY:
    class ResolverSyncConfigArgsDict(TypedDict):
        """
        Describes a Sync configuration for a resolver.
         Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        """
        conflict_detection: pulumi.Input[str]
        """
        The Conflict Detection strategy to use.
          +   *VERSION*: Detect conflicts based on object versions for this resolver.
          +   *NONE*: Do not detect conflicts when invoking this resolver.
        """
        conflict_handler: NotRequired[pulumi.Input[str]]
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
          +   *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
          +   *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
          +   *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        """
        lambda_conflict_handler_config: NotRequired[pulumi.Input['ResolverLambdaConflictHandlerConfigArgsDict']]
        """
        The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
elif False:
    ResolverSyncConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverSyncConfigArgs:
    def __init__(__self__, *,
                 conflict_detection: pulumi.Input[str],
                 conflict_handler: Optional[pulumi.Input[str]] = None,
                 lambda_conflict_handler_config: Optional[pulumi.Input['ResolverLambdaConflictHandlerConfigArgs']] = None):
        """
        Describes a Sync configuration for a resolver.
         Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
        :param pulumi.Input[str] conflict_detection: The Conflict Detection strategy to use.
                 +   *VERSION*: Detect conflicts based on object versions for this resolver.
                 +   *NONE*: Do not detect conflicts when invoking this resolver.
        :param pulumi.Input[str] conflict_handler: The Conflict Resolution strategy to perform in the event of a conflict.
                 +   *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
                 +   *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
                 +   *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        :param pulumi.Input['ResolverLambdaConflictHandlerConfigArgs'] lambda_conflict_handler_config: The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> pulumi.Input[str]:
        """
        The Conflict Detection strategy to use.
          +   *VERSION*: Detect conflicts based on object versions for this resolver.
          +   *NONE*: Do not detect conflicts when invoking this resolver.
        """
        return pulumi.get(self, "conflict_detection")

    @conflict_detection.setter
    def conflict_detection(self, value: pulumi.Input[str]):
        pulumi.set(self, "conflict_detection", value)

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[pulumi.Input[str]]:
        """
        The Conflict Resolution strategy to perform in the event of a conflict.
          +   *OPTIMISTIC_CONCURRENCY*: Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.
          +   *AUTOMERGE*: Resolve conflicts with the Automerge conflict resolution strategy.
          +   *LAMBDA*: Resolve conflicts with an LAMlong function supplied in the ``LambdaConflictHandlerConfig``.
        """
        return pulumi.get(self, "conflict_handler")

    @conflict_handler.setter
    def conflict_handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_handler", value)

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional[pulumi.Input['ResolverLambdaConflictHandlerConfigArgs']]:
        """
        The ``LambdaConflictHandlerConfig`` when configuring ``LAMBDA`` as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")

    @lambda_conflict_handler_config.setter
    def lambda_conflict_handler_config(self, value: Optional[pulumi.Input['ResolverLambdaConflictHandlerConfigArgs']]):
        pulumi.set(self, "lambda_conflict_handler_config", value)


if not MYPY:
    class SourceApiAssociationConfigArgsDict(TypedDict):
        merge_type: NotRequired[pulumi.Input['SourceApiAssociationConfigMergeType']]
        """
        Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
elif False:
    SourceApiAssociationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SourceApiAssociationConfigArgs:
    def __init__(__self__, *,
                 merge_type: Optional[pulumi.Input['SourceApiAssociationConfigMergeType']] = None):
        """
        :param pulumi.Input['SourceApiAssociationConfigMergeType'] merge_type: Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        if merge_type is not None:
            pulumi.set(__self__, "merge_type", merge_type)

    @property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> Optional[pulumi.Input['SourceApiAssociationConfigMergeType']]:
        """
        Configuration of the merged behavior for the association. For example when it could be auto or has to be manual.
        """
        return pulumi.get(self, "merge_type")

    @merge_type.setter
    def merge_type(self, value: Optional[pulumi.Input['SourceApiAssociationConfigMergeType']]):
        pulumi.set(self, "merge_type", value)


