# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ImageBuilderArgs', 'ImageBuilder']

@pulumi.input_type
class ImageBuilderArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_join_info: Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']] = None,
                 enable_default_internet_access: Optional[pulumi.Input[bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 image_arn: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpc_config: Optional[pulumi.Input['ImageBuilderVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a ImageBuilder resource.
        :param pulumi.Input[str] instance_type: The instance type to use when launching the image builder. The following instance types are available:
               
               - stream.standard.small
               - stream.standard.medium
               - stream.standard.large
               - stream.compute.large
               - stream.compute.xlarge
               - stream.compute.2xlarge
               - stream.compute.4xlarge
               - stream.compute.8xlarge
               - stream.memory.large
               - stream.memory.xlarge
               - stream.memory.2xlarge
               - stream.memory.4xlarge
               - stream.memory.8xlarge
               - stream.memory.z1d.large
               - stream.memory.z1d.xlarge
               - stream.memory.z1d.2xlarge
               - stream.memory.z1d.3xlarge
               - stream.memory.z1d.6xlarge
               - stream.memory.z1d.12xlarge
               - stream.graphics-design.large
               - stream.graphics-design.xlarge
               - stream.graphics-design.2xlarge
               - stream.graphics-design.4xlarge
               - stream.graphics-desktop.2xlarge
               - stream.graphics.g4dn.xlarge
               - stream.graphics.g4dn.2xlarge
               - stream.graphics.g4dn.4xlarge
               - stream.graphics.g4dn.8xlarge
               - stream.graphics.g4dn.12xlarge
               - stream.graphics.g4dn.16xlarge
               - stream.graphics-pro.4xlarge
               - stream.graphics-pro.8xlarge
               - stream.graphics-pro.16xlarge
        :param pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]] access_endpoints: The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.
        :param pulumi.Input[str] appstream_agent_version: The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST].
        :param pulumi.Input[str] description: The description to display.
        :param pulumi.Input[str] display_name: The image builder name to display.
        :param pulumi.Input['ImageBuilderDomainJoinInfoArgs'] domain_join_info: The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
        :param pulumi.Input[bool] enable_default_internet_access: Enables or disables default internet access for the image builder.
        :param pulumi.Input[str] iam_role_arn: The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the *appstream_machine_role* credential profile on the instance.
               
               For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide* .
        :param pulumi.Input[str] image_arn: The ARN of the public, private, or shared image to use.
        :param pulumi.Input[str] image_name: The name of the image used to create the image builder.
        :param pulumi.Input[str] name: A unique name for the image builder.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs.
        :param pulumi.Input['ImageBuilderVpcConfigArgs'] vpc_config: The VPC configuration for the image builder. You can specify only one subnet.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if appstream_agent_version is not None:
            pulumi.set(__self__, "appstream_agent_version", appstream_agent_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_join_info is not None:
            pulumi.set(__self__, "domain_join_info", domain_join_info)
        if enable_default_internet_access is not None:
            pulumi.set(__self__, "enable_default_internet_access", enable_default_internet_access)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if image_arn is not None:
            pulumi.set(__self__, "image_arn", image_arn)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The instance type to use when launching the image builder. The following instance types are available:

        - stream.standard.small
        - stream.standard.medium
        - stream.standard.large
        - stream.compute.large
        - stream.compute.xlarge
        - stream.compute.2xlarge
        - stream.compute.4xlarge
        - stream.compute.8xlarge
        - stream.memory.large
        - stream.memory.xlarge
        - stream.memory.2xlarge
        - stream.memory.4xlarge
        - stream.memory.8xlarge
        - stream.memory.z1d.large
        - stream.memory.z1d.xlarge
        - stream.memory.z1d.2xlarge
        - stream.memory.z1d.3xlarge
        - stream.memory.z1d.6xlarge
        - stream.memory.z1d.12xlarge
        - stream.graphics-design.large
        - stream.graphics-design.xlarge
        - stream.graphics-design.2xlarge
        - stream.graphics-design.4xlarge
        - stream.graphics-desktop.2xlarge
        - stream.graphics.g4dn.xlarge
        - stream.graphics.g4dn.2xlarge
        - stream.graphics.g4dn.4xlarge
        - stream.graphics.g4dn.8xlarge
        - stream.graphics.g4dn.12xlarge
        - stream.graphics.g4dn.16xlarge
        - stream.graphics-pro.4xlarge
        - stream.graphics-pro.8xlarge
        - stream.graphics-pro.16xlarge
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]]:
        """
        The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.
        """
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @property
    @pulumi.getter(name="appstreamAgentVersion")
    def appstream_agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST].
        """
        return pulumi.get(self, "appstream_agent_version")

    @appstream_agent_version.setter
    def appstream_agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appstream_agent_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description to display.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image builder name to display.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']]:
        """
        The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
        """
        return pulumi.get(self, "domain_join_info")

    @domain_join_info.setter
    def domain_join_info(self, value: Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']]):
        pulumi.set(self, "domain_join_info", value)

    @property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables or disables default internet access for the image builder.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @enable_default_internet_access.setter
    def enable_default_internet_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_default_internet_access", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the *appstream_machine_role* credential profile on the instance.

        For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide* .
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @image_arn.setter
    def image_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_arn", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image used to create the image builder.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the image builder.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ImageBuilderVpcConfigArgs']]:
        """
        The VPC configuration for the image builder. You can specify only one subnet.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ImageBuilderVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class ImageBuilder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_join_info: Optional[pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']]] = None,
                 enable_default_internet_access: Optional[pulumi.Input[bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 image_arn: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::AppStream::ImageBuilder

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]] access_endpoints: The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.
        :param pulumi.Input[str] appstream_agent_version: The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST].
        :param pulumi.Input[str] description: The description to display.
        :param pulumi.Input[str] display_name: The image builder name to display.
        :param pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']] domain_join_info: The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
        :param pulumi.Input[bool] enable_default_internet_access: Enables or disables default internet access for the image builder.
        :param pulumi.Input[str] iam_role_arn: The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the *appstream_machine_role* credential profile on the instance.
               
               For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide* .
        :param pulumi.Input[str] image_arn: The ARN of the public, private, or shared image to use.
        :param pulumi.Input[str] image_name: The name of the image used to create the image builder.
        :param pulumi.Input[str] instance_type: The instance type to use when launching the image builder. The following instance types are available:
               
               - stream.standard.small
               - stream.standard.medium
               - stream.standard.large
               - stream.compute.large
               - stream.compute.xlarge
               - stream.compute.2xlarge
               - stream.compute.4xlarge
               - stream.compute.8xlarge
               - stream.memory.large
               - stream.memory.xlarge
               - stream.memory.2xlarge
               - stream.memory.4xlarge
               - stream.memory.8xlarge
               - stream.memory.z1d.large
               - stream.memory.z1d.xlarge
               - stream.memory.z1d.2xlarge
               - stream.memory.z1d.3xlarge
               - stream.memory.z1d.6xlarge
               - stream.memory.z1d.12xlarge
               - stream.graphics-design.large
               - stream.graphics-design.xlarge
               - stream.graphics-design.2xlarge
               - stream.graphics-design.4xlarge
               - stream.graphics-desktop.2xlarge
               - stream.graphics.g4dn.xlarge
               - stream.graphics.g4dn.2xlarge
               - stream.graphics.g4dn.4xlarge
               - stream.graphics.g4dn.8xlarge
               - stream.graphics.g4dn.12xlarge
               - stream.graphics.g4dn.16xlarge
               - stream.graphics-pro.4xlarge
               - stream.graphics-pro.8xlarge
               - stream.graphics-pro.16xlarge
        :param pulumi.Input[str] name: A unique name for the image builder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs.
        :param pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']] vpc_config: The VPC configuration for the image builder. You can specify only one subnet.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageBuilderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::AppStream::ImageBuilder

        :param str resource_name: The name of the resource.
        :param ImageBuilderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageBuilderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_join_info: Optional[pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']]] = None,
                 enable_default_internet_access: Optional[pulumi.Input[bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 image_arn: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageBuilderArgs.__new__(ImageBuilderArgs)

            __props__.__dict__["access_endpoints"] = access_endpoints
            __props__.__dict__["appstream_agent_version"] = appstream_agent_version
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain_join_info"] = domain_join_info
            __props__.__dict__["enable_default_internet_access"] = enable_default_internet_access
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["image_arn"] = image_arn
            __props__.__dict__["image_name"] = image_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["streaming_url"] = None
        super(ImageBuilder, __self__).__init__(
            'aws-native:appstream:ImageBuilder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ImageBuilder':
        """
        Get an existing ImageBuilder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ImageBuilderArgs.__new__(ImageBuilderArgs)

        __props__.__dict__["access_endpoints"] = None
        __props__.__dict__["appstream_agent_version"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["domain_join_info"] = None
        __props__.__dict__["enable_default_internet_access"] = None
        __props__.__dict__["iam_role_arn"] = None
        __props__.__dict__["image_arn"] = None
        __props__.__dict__["image_name"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["streaming_url"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_config"] = None
        return ImageBuilder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.ImageBuilderAccessEndpoint']]]:
        """
        The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.
        """
        return pulumi.get(self, "access_endpoints")

    @property
    @pulumi.getter(name="appstreamAgentVersion")
    def appstream_agent_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST].
        """
        return pulumi.get(self, "appstream_agent_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description to display.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The image builder name to display.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> pulumi.Output[Optional['outputs.ImageBuilderDomainJoinInfo']]:
        """
        The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain.
        """
        return pulumi.get(self, "domain_join_info")

    @property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables or disables default internet access for the image builder.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service `AssumeRole` API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the *appstream_machine_role* credential profile on the instance.

        For more information, see [Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html) in the *Amazon AppStream 2.0 Administration Guide* .
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the image used to create the image builder.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The instance type to use when launching the image builder. The following instance types are available:

        - stream.standard.small
        - stream.standard.medium
        - stream.standard.large
        - stream.compute.large
        - stream.compute.xlarge
        - stream.compute.2xlarge
        - stream.compute.4xlarge
        - stream.compute.8xlarge
        - stream.memory.large
        - stream.memory.xlarge
        - stream.memory.2xlarge
        - stream.memory.4xlarge
        - stream.memory.8xlarge
        - stream.memory.z1d.large
        - stream.memory.z1d.xlarge
        - stream.memory.z1d.2xlarge
        - stream.memory.z1d.3xlarge
        - stream.memory.z1d.6xlarge
        - stream.memory.z1d.12xlarge
        - stream.graphics-design.large
        - stream.graphics-design.xlarge
        - stream.graphics-design.2xlarge
        - stream.graphics-design.4xlarge
        - stream.graphics-desktop.2xlarge
        - stream.graphics.g4dn.xlarge
        - stream.graphics.g4dn.2xlarge
        - stream.graphics.g4dn.4xlarge
        - stream.graphics.g4dn.8xlarge
        - stream.graphics.g4dn.12xlarge
        - stream.graphics.g4dn.16xlarge
        - stream.graphics-pro.4xlarge
        - stream.graphics-pro.8xlarge
        - stream.graphics-pro.16xlarge
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the image builder.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="streamingUrl")
    def streaming_url(self) -> pulumi.Output[str]:
        """
        The URL to start an image builder streaming session, returned as a string.
        """
        return pulumi.get(self, "streaming_url")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.ImageBuilderVpcConfig']]:
        """
        The VPC configuration for the image builder. You can specify only one subnet.
        """
        return pulumi.get(self, "vpc_config")

