# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ServiceLevelObjectiveArgs', 'ServiceLevelObjective']

@pulumi.input_type
class ServiceLevelObjectiveArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 goal: Optional[pulumi.Input['ServiceLevelObjectiveGoalArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliArgs']] = None,
                 sli: Optional[pulumi.Input['ServiceLevelObjectiveSliArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceLevelObjective resource.
        :param pulumi.Input[str] description: An optional description for this SLO. Default is 'No description'
        :param pulumi.Input['ServiceLevelObjectiveGoalArgs'] goal: This structure contains the attributes that determine the goal of an SLO. This includes the time period for evaluation and the attainment threshold.
        :param pulumi.Input[str] name: The name of this SLO.
        :param pulumi.Input['ServiceLevelObjectiveRequestBasedSliArgs'] request_based_sli: A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
        :param pulumi.Input['ServiceLevelObjectiveSliArgs'] sli: A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.
               
               Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if goal is not None:
            pulumi.set(__self__, "goal", goal)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request_based_sli is not None:
            pulumi.set(__self__, "request_based_sli", request_based_sli)
        if sli is not None:
            pulumi.set(__self__, "sli", sli)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description for this SLO. Default is 'No description'
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def goal(self) -> Optional[pulumi.Input['ServiceLevelObjectiveGoalArgs']]:
        """
        This structure contains the attributes that determine the goal of an SLO. This includes the time period for evaluation and the attainment threshold.
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: Optional[pulumi.Input['ServiceLevelObjectiveGoalArgs']]):
        pulumi.set(self, "goal", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this SLO.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requestBasedSli")
    def request_based_sli(self) -> Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliArgs']]:
        """
        A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
        """
        return pulumi.get(self, "request_based_sli")

    @request_based_sli.setter
    def request_based_sli(self, value: Optional[pulumi.Input['ServiceLevelObjectiveRequestBasedSliArgs']]):
        pulumi.set(self, "request_based_sli", value)

    @property
    @pulumi.getter
    def sli(self) -> Optional[pulumi.Input['ServiceLevelObjectiveSliArgs']]:
        """
        A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
        """
        return pulumi.get(self, "sli")

    @sli.setter
    def sli(self, value: Optional[pulumi.Input['ServiceLevelObjectiveSliArgs']]):
        pulumi.set(self, "sli", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.

        Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class ServiceLevelObjective(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 goal: Optional[pulumi.Input[Union['ServiceLevelObjectiveGoalArgs', 'ServiceLevelObjectiveGoalArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input[Union['ServiceLevelObjectiveRequestBasedSliArgs', 'ServiceLevelObjectiveRequestBasedSliArgsDict']]] = None,
                 sli: Optional[pulumi.Input[Union['ServiceLevelObjectiveSliArgs', 'ServiceLevelObjectiveSliArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ApplicationSignals::ServiceLevelObjective

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description for this SLO. Default is 'No description'
        :param pulumi.Input[Union['ServiceLevelObjectiveGoalArgs', 'ServiceLevelObjectiveGoalArgsDict']] goal: This structure contains the attributes that determine the goal of an SLO. This includes the time period for evaluation and the attainment threshold.
        :param pulumi.Input[str] name: The name of this SLO.
        :param pulumi.Input[Union['ServiceLevelObjectiveRequestBasedSliArgs', 'ServiceLevelObjectiveRequestBasedSliArgsDict']] request_based_sli: A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
        :param pulumi.Input[Union['ServiceLevelObjectiveSliArgs', 'ServiceLevelObjectiveSliArgsDict']] sli: A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.
               
               Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceLevelObjectiveArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ApplicationSignals::ServiceLevelObjective

        :param str resource_name: The name of the resource.
        :param ServiceLevelObjectiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceLevelObjectiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 goal: Optional[pulumi.Input[Union['ServiceLevelObjectiveGoalArgs', 'ServiceLevelObjectiveGoalArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 request_based_sli: Optional[pulumi.Input[Union['ServiceLevelObjectiveRequestBasedSliArgs', 'ServiceLevelObjectiveRequestBasedSliArgsDict']]] = None,
                 sli: Optional[pulumi.Input[Union['ServiceLevelObjectiveSliArgs', 'ServiceLevelObjectiveSliArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceLevelObjectiveArgs.__new__(ServiceLevelObjectiveArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["goal"] = goal
            __props__.__dict__["name"] = name
            __props__.__dict__["request_based_sli"] = request_based_sli
            __props__.__dict__["sli"] = sli
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["evaluation_type"] = None
            __props__.__dict__["last_updated_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ServiceLevelObjective, __self__).__init__(
            'aws-native:applicationsignals:ServiceLevelObjective',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServiceLevelObjective':
        """
        Get an existing ServiceLevelObjective resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServiceLevelObjectiveArgs.__new__(ServiceLevelObjectiveArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["evaluation_type"] = None
        __props__.__dict__["goal"] = None
        __props__.__dict__["last_updated_time"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["request_based_sli"] = None
        __props__.__dict__["sli"] = None
        __props__.__dict__["tags"] = None
        return ServiceLevelObjective(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of this SLO.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[int]:
        """
        Epoch time in seconds of the time that this SLO was created
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description for this SLO. Default is 'No description'
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationType")
    def evaluation_type(self) -> pulumi.Output['ServiceLevelObjectiveEvaluationType']:
        """
        Displays whether this is a period-based SLO or a request-based SLO.
        """
        return pulumi.get(self, "evaluation_type")

    @property
    @pulumi.getter
    def goal(self) -> pulumi.Output[Optional['outputs.ServiceLevelObjectiveGoal']]:
        """
        This structure contains the attributes that determine the goal of an SLO. This includes the time period for evaluation and the attainment threshold.
        """
        return pulumi.get(self, "goal")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[int]:
        """
        Epoch time in seconds of the time that this SLO was most recently updated
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this SLO.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestBasedSli")
    def request_based_sli(self) -> pulumi.Output[Optional['outputs.ServiceLevelObjectiveRequestBasedSli']]:
        """
        A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
        """
        return pulumi.get(self, "request_based_sli")

    @property
    @pulumi.getter
    def sli(self) -> pulumi.Output[Optional['outputs.ServiceLevelObjectiveSli']]:
        """
        A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
        """
        return pulumi.get(self, "sli")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.

        Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
        """
        return pulumi.get(self, "tags")

