# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ServiceLevelObjectiveCalendarInterval',
    'ServiceLevelObjectiveDimension',
    'ServiceLevelObjectiveGoal',
    'ServiceLevelObjectiveInterval',
    'ServiceLevelObjectiveMetric',
    'ServiceLevelObjectiveMetricDataQuery',
    'ServiceLevelObjectiveMetricStat',
    'ServiceLevelObjectiveMonitoredRequestCountMetric',
    'ServiceLevelObjectiveRequestBasedSli',
    'ServiceLevelObjectiveRequestBasedSliMetric',
    'ServiceLevelObjectiveRollingInterval',
    'ServiceLevelObjectiveSli',
    'ServiceLevelObjectiveSliMetric',
]

@pulumi.output_type
class ServiceLevelObjectiveCalendarInterval(dict):
    """
    If the interval for this service level objective is a calendar interval, this structure contains the interval specifications.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationUnit":
            suggest = "duration_unit"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveCalendarInterval. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveCalendarInterval.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveCalendarInterval.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 duration_unit: 'ServiceLevelObjectiveDurationUnit',
                 start_time: int):
        """
        If the interval for this service level objective is a calendar interval, this structure contains the interval specifications.
        :param int duration: Specifies the duration of each calendar interval. For example, if `Duration` is `1` and `DurationUnit` is `MONTH` , each interval is one month, aligned with the calendar.
        :param 'ServiceLevelObjectiveDurationUnit' duration_unit: Specifies the calendar interval unit.
        :param int start_time: Epoch time in seconds you want the first interval to start. Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
               As soon as one calendar interval ends, another automatically begins.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Specifies the duration of each calendar interval. For example, if `Duration` is `1` and `DurationUnit` is `MONTH` , each interval is one month, aligned with the calendar.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> 'ServiceLevelObjectiveDurationUnit':
        """
        Specifies the calendar interval unit.
        """
        return pulumi.get(self, "duration_unit")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> int:
        """
        Epoch time in seconds you want the first interval to start. Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
        As soon as one calendar interval ends, another automatically begins.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ServiceLevelObjectiveDimension(dict):
    """
    A dimension is a name/value pair that is part of the identity of a metric. Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish `InstanceId` as a dimension name, and the actual instance ID as the value for that dimension. You can assign up to 30 dimensions to a metric.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        A dimension is a name/value pair that is part of the identity of a metric. Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish `InstanceId` as a dimension name, and the actual instance ID as the value for that dimension. You can assign up to 30 dimensions to a metric.
        :param str name: The name of the dimension. Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:). ASCII control characters are not supported as part of dimension names.
        :param str value: The value of the dimension. Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the dimension. Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:). ASCII control characters are not supported as part of dimension names.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the dimension. Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceLevelObjectiveGoal(dict):
    """
    A structure that contains the attributes that determine the goal of the SLO. This includes the time period for evaluation and the attainment threshold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attainmentGoal":
            suggest = "attainment_goal"
        elif key == "warningThreshold":
            suggest = "warning_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveGoal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveGoal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveGoal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attainment_goal: Optional[float] = None,
                 interval: Optional['outputs.ServiceLevelObjectiveInterval'] = None,
                 warning_threshold: Optional[float] = None):
        """
        A structure that contains the attributes that determine the goal of the SLO. This includes the time period for evaluation and the attainment threshold.
        :param float attainment_goal: The threshold that determines if the goal is being met. An attainment goal is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
               If you omit this parameter, 99 is used to represent 99% as the attainment goal.
        :param 'ServiceLevelObjectiveInterval' interval: The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
               
               If you omit this parameter, a rolling interval of 7 days is used.
        :param float warning_threshold: The percentage of remaining budget over total budget that you want to get warnings for. If you omit this parameter, the default of 50.0 is used.
        """
        if attainment_goal is not None:
            pulumi.set(__self__, "attainment_goal", attainment_goal)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter(name="attainmentGoal")
    def attainment_goal(self) -> Optional[float]:
        """
        The threshold that determines if the goal is being met. An attainment goal is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
        If you omit this parameter, 99 is used to represent 99% as the attainment goal.
        """
        return pulumi.get(self, "attainment_goal")

    @property
    @pulumi.getter
    def interval(self) -> Optional['outputs.ServiceLevelObjectiveInterval']:
        """
        The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.

        If you omit this parameter, a rolling interval of 7 days is used.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[float]:
        """
        The percentage of remaining budget over total budget that you want to get warnings for. If you omit this parameter, the default of 50.0 is used.
        """
        return pulumi.get(self, "warning_threshold")


@pulumi.output_type
class ServiceLevelObjectiveInterval(dict):
    """
    The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
    If you omit this parameter, a rolling interval of 7 days is used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "calendarInterval":
            suggest = "calendar_interval"
        elif key == "rollingInterval":
            suggest = "rolling_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveInterval. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveInterval.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveInterval.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 calendar_interval: Optional['outputs.ServiceLevelObjectiveCalendarInterval'] = None,
                 rolling_interval: Optional['outputs.ServiceLevelObjectiveRollingInterval'] = None):
        """
        The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
        If you omit this parameter, a rolling interval of 7 days is used.
        :param 'ServiceLevelObjectiveCalendarInterval' calendar_interval: If the interval is a calendar interval, this structure contains the interval specifications.
        :param 'ServiceLevelObjectiveRollingInterval' rolling_interval: If the interval is a rolling interval, this structure contains the interval specifications.
        """
        if calendar_interval is not None:
            pulumi.set(__self__, "calendar_interval", calendar_interval)
        if rolling_interval is not None:
            pulumi.set(__self__, "rolling_interval", rolling_interval)

    @property
    @pulumi.getter(name="calendarInterval")
    def calendar_interval(self) -> Optional['outputs.ServiceLevelObjectiveCalendarInterval']:
        """
        If the interval is a calendar interval, this structure contains the interval specifications.
        """
        return pulumi.get(self, "calendar_interval")

    @property
    @pulumi.getter(name="rollingInterval")
    def rolling_interval(self) -> Optional['outputs.ServiceLevelObjectiveRollingInterval']:
        """
        If the interval is a rolling interval, this structure contains the interval specifications.
        """
        return pulumi.get(self, "rolling_interval")


@pulumi.output_type
class ServiceLevelObjectiveMetric(dict):
    """
    This structure defines the metric used for a service level indicator, including the metric name, namespace, and dimensions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.ServiceLevelObjectiveDimension']] = None,
                 metric_name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        This structure defines the metric used for a service level indicator, including the metric name, namespace, and dimensions.
        :param Sequence['ServiceLevelObjectiveDimension'] dimensions: An array of one or more dimensions to use to define the metric that you want to use.
        :param str metric_name: The name of the metric to use.
        :param str namespace: The namespace of the metric.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveDimension']]:
        """
        An array of one or more dimensions to use to define the metric that you want to use.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric to use.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ServiceLevelObjectiveMetricDataQuery(dict):
    """
    Use this structure to define a metric or metric math expression that you want to use as for a service level objective.
    Each `MetricDataQuery` in the `MetricDataQueries` array specifies either a metric to retrieve, or a metric math expression to be performed on retrieved metrics. A single `MetricDataQueries` array can include as many as 20 `MetricDataQuery` structures in the array. The 20 structures can include as many as 10 structures that contain a `MetricStat` parameter to retrieve a metric, and as many as 10 structures that contain the `Expression` parameter to perform a math expression. Of those Expression structures, exactly one must have true as the value for `ReturnData`. The result of this expression used for the SLO.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "metricStat":
            suggest = "metric_stat"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveMetricDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveMetricDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveMetricDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 account_id: Optional[str] = None,
                 expression: Optional[str] = None,
                 metric_stat: Optional['outputs.ServiceLevelObjectiveMetricStat'] = None,
                 return_data: Optional[bool] = None):
        """
        Use this structure to define a metric or metric math expression that you want to use as for a service level objective.
        Each `MetricDataQuery` in the `MetricDataQueries` array specifies either a metric to retrieve, or a metric math expression to be performed on retrieved metrics. A single `MetricDataQueries` array can include as many as 20 `MetricDataQuery` structures in the array. The 20 structures can include as many as 10 structures that contain a `MetricStat` parameter to retrieve a metric, and as many as 10 structures that contain the `Expression` parameter to perform a math expression. Of those Expression structures, exactly one must have true as the value for `ReturnData`. The result of this expression used for the SLO.
        :param str id: A short name used to tie this object to the results in the response.
        :param str account_id: The ID of the account where the metrics are located, if this is a cross-account alarm.
        :param str expression: The math expression to be performed on the returned data.
        :param 'ServiceLevelObjectiveMetricStat' metric_stat: A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery, you must specify either Expression or MetricStat but not both.
        :param bool return_data: This option indicates whether to return the timestamps and raw data values of this metric.
        """
        pulumi.set(__self__, "id", id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A short name used to tie this object to the results in the response.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        The math expression to be performed on the returned data.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional['outputs.ServiceLevelObjectiveMetricStat']:
        """
        A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery, you must specify either Expression or MetricStat but not both.
        """
        return pulumi.get(self, "metric_stat")

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[bool]:
        """
        This option indicates whether to return the timestamps and raw data values of this metric.
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class ServiceLevelObjectiveMetricStat(dict):
    """
    A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery object, you must specify either Expression or MetricStat but not both.
    """
    def __init__(__self__, *,
                 metric: 'outputs.ServiceLevelObjectiveMetric',
                 period: int,
                 stat: str,
                 unit: Optional[str] = None):
        """
        A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO. Within one MetricDataQuery object, you must specify either Expression or MetricStat but not both.
        :param int period: The granularity, in seconds, to be used for the metric.
        :param str stat: The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic.
        :param str unit: If you omit Unit then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> 'outputs.ServiceLevelObjectiveMetric':
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        The granularity, in seconds, to be used for the metric.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def stat(self) -> str:
        """
        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic.
        """
        return pulumi.get(self, "stat")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        If you omit Unit then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ServiceLevelObjectiveMonitoredRequestCountMetric(dict):
    """
    This structure defines the metric that is used as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` is divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badCountMetric":
            suggest = "bad_count_metric"
        elif key == "goodCountMetric":
            suggest = "good_count_metric"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveMonitoredRequestCountMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveMonitoredRequestCountMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveMonitoredRequestCountMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_count_metric: Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']] = None,
                 good_count_metric: Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']] = None):
        """
        This structure defines the metric that is used as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` is divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        :param Sequence['ServiceLevelObjectiveMetricDataQuery'] bad_count_metric: If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
        :param Sequence['ServiceLevelObjectiveMetricDataQuery'] good_count_metric: If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
        """
        if bad_count_metric is not None:
            pulumi.set(__self__, "bad_count_metric", bad_count_metric)
        if good_count_metric is not None:
            pulumi.set(__self__, "good_count_metric", good_count_metric)

    @property
    @pulumi.getter(name="badCountMetric")
    def bad_count_metric(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']]:
        """
        If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
        """
        return pulumi.get(self, "bad_count_metric")

    @property
    @pulumi.getter(name="goodCountMetric")
    def good_count_metric(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']]:
        """
        If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
        """
        return pulumi.get(self, "good_count_metric")


@pulumi.output_type
class ServiceLevelObjectiveRequestBasedSli(dict):
    """
    This structure contains information about the performance metric that a request-based SLO monitors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestBasedSliMetric":
            suggest = "request_based_sli_metric"
        elif key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "metricThreshold":
            suggest = "metric_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveRequestBasedSli. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveRequestBasedSli.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveRequestBasedSli.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_based_sli_metric: 'outputs.ServiceLevelObjectiveRequestBasedSliMetric',
                 comparison_operator: Optional['ServiceLevelObjectiveRequestBasedSliComparisonOperator'] = None,
                 metric_threshold: Optional[float] = None):
        """
        This structure contains information about the performance metric that a request-based SLO monitors.
        :param 'ServiceLevelObjectiveRequestBasedSliMetric' request_based_sli_metric: A structure that contains information about the metric that the SLO monitors.
        :param 'ServiceLevelObjectiveRequestBasedSliComparisonOperator' comparison_operator: The arithmetic operation used when comparing the specified metric to the threshold.
        :param float metric_threshold: The value that the SLI metric is compared to.
        """
        pulumi.set(__self__, "request_based_sli_metric", request_based_sli_metric)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if metric_threshold is not None:
            pulumi.set(__self__, "metric_threshold", metric_threshold)

    @property
    @pulumi.getter(name="requestBasedSliMetric")
    def request_based_sli_metric(self) -> 'outputs.ServiceLevelObjectiveRequestBasedSliMetric':
        """
        A structure that contains information about the metric that the SLO monitors.
        """
        return pulumi.get(self, "request_based_sli_metric")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional['ServiceLevelObjectiveRequestBasedSliComparisonOperator']:
        """
        The arithmetic operation used when comparing the specified metric to the threshold.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="metricThreshold")
    def metric_threshold(self) -> Optional[float]:
        """
        The value that the SLI metric is compared to.
        """
        return pulumi.get(self, "metric_threshold")


@pulumi.output_type
class ServiceLevelObjectiveRequestBasedSliMetric(dict):
    """
    This structure contains the information about the metric that is used for a request-based SLO.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyAttributes":
            suggest = "key_attributes"
        elif key == "metricType":
            suggest = "metric_type"
        elif key == "monitoredRequestCountMetric":
            suggest = "monitored_request_count_metric"
        elif key == "operationName":
            suggest = "operation_name"
        elif key == "totalRequestCountMetric":
            suggest = "total_request_count_metric"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveRequestBasedSliMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveRequestBasedSliMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveRequestBasedSliMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_attributes: Optional[Mapping[str, str]] = None,
                 metric_type: Optional['ServiceLevelObjectiveRequestBasedSliMetricMetricType'] = None,
                 monitored_request_count_metric: Optional['outputs.ServiceLevelObjectiveMonitoredRequestCountMetric'] = None,
                 operation_name: Optional[str] = None,
                 total_request_count_metric: Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']] = None):
        """
        This structure contains the information about the metric that is used for a request-based SLO.
        :param Mapping[str, str] key_attributes: This is a string-to-string map that contains information about the type of object that this SLO is related to. It can include the following fields.
               
               - `Type` designates the type of object that this SLO is related to.
               - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
               - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Environment` specifies the location where this object is hosted, or what it belongs to.
        :param 'ServiceLevelObjectiveRequestBasedSliMetricMetricType' metric_type: If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        :param 'ServiceLevelObjectiveMonitoredRequestCountMetric' monitored_request_count_metric: Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` will be divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        :param str operation_name: If the SLO monitors a specific operation of the service, this field displays that operation name.
        :param Sequence['ServiceLevelObjectiveMetricDataQuery'] total_request_count_metric: This structure defines the metric that is used as the "total requests" number for a request-based SLO. The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in `MonitoredRequestCountMetric`.
        """
        if key_attributes is not None:
            pulumi.set(__self__, "key_attributes", key_attributes)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if monitored_request_count_metric is not None:
            pulumi.set(__self__, "monitored_request_count_metric", monitored_request_count_metric)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if total_request_count_metric is not None:
            pulumi.set(__self__, "total_request_count_metric", total_request_count_metric)

    @property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> Optional[Mapping[str, str]]:
        """
        This is a string-to-string map that contains information about the type of object that this SLO is related to. It can include the following fields.

        - `Type` designates the type of object that this SLO is related to.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        """
        return pulumi.get(self, "key_attributes")

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional['ServiceLevelObjectiveRequestBasedSliMetricMetricType']:
        """
        If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter(name="monitoredRequestCountMetric")
    def monitored_request_count_metric(self) -> Optional['outputs.ServiceLevelObjectiveMonitoredRequestCountMetric']:
        """
        Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO. This value observed for the metric defined in `TotalRequestCountMetric` will be divided by the number found for `MonitoredRequestCountMetric` to determine the percentage of successful requests that this SLO tracks.
        """
        return pulumi.get(self, "monitored_request_count_metric")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        If the SLO monitors a specific operation of the service, this field displays that operation name.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="totalRequestCountMetric")
    def total_request_count_metric(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']]:
        """
        This structure defines the metric that is used as the "total requests" number for a request-based SLO. The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in `MonitoredRequestCountMetric`.
        """
        return pulumi.get(self, "total_request_count_metric")


@pulumi.output_type
class ServiceLevelObjectiveRollingInterval(dict):
    """
    If the interval is a calendar interval, this structure contains the interval specifications.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationUnit":
            suggest = "duration_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveRollingInterval. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveRollingInterval.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveRollingInterval.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: int,
                 duration_unit: 'ServiceLevelObjectiveDurationUnit'):
        """
        If the interval is a calendar interval, this structure contains the interval specifications.
        :param int duration: Specifies the duration of each rolling interval. For example, if `Duration` is `7` and `DurationUnit` is `DAY` , each rolling interval is seven days.
        :param 'ServiceLevelObjectiveDurationUnit' duration_unit: Specifies the rolling interval unit.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Specifies the duration of each rolling interval. For example, if `Duration` is `7` and `DurationUnit` is `DAY` , each rolling interval is seven days.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> 'ServiceLevelObjectiveDurationUnit':
        """
        Specifies the rolling interval unit.
        """
        return pulumi.get(self, "duration_unit")


@pulumi.output_type
class ServiceLevelObjectiveSli(dict):
    """
    This structure contains information about the performance metric that an SLO monitors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "metricThreshold":
            suggest = "metric_threshold"
        elif key == "sliMetric":
            suggest = "sli_metric"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveSli. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveSli.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveSli.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: 'ServiceLevelObjectiveSliComparisonOperator',
                 metric_threshold: float,
                 sli_metric: 'outputs.ServiceLevelObjectiveSliMetric'):
        """
        This structure contains information about the performance metric that an SLO monitors.
        :param 'ServiceLevelObjectiveSliComparisonOperator' comparison_operator: The arithmetic operation used when comparing the specified metric to the threshold.
        :param float metric_threshold: The value that the SLI metric is compared to.
        :param 'ServiceLevelObjectiveSliMetric' sli_metric: Use this structure to specify the metric to be used for the SLO.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "metric_threshold", metric_threshold)
        pulumi.set(__self__, "sli_metric", sli_metric)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> 'ServiceLevelObjectiveSliComparisonOperator':
        """
        The arithmetic operation used when comparing the specified metric to the threshold.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="metricThreshold")
    def metric_threshold(self) -> float:
        """
        The value that the SLI metric is compared to.
        """
        return pulumi.get(self, "metric_threshold")

    @property
    @pulumi.getter(name="sliMetric")
    def sli_metric(self) -> 'outputs.ServiceLevelObjectiveSliMetric':
        """
        Use this structure to specify the metric to be used for the SLO.
        """
        return pulumi.get(self, "sli_metric")


@pulumi.output_type
class ServiceLevelObjectiveSliMetric(dict):
    """
    A structure that contains information about the metric that the SLO monitors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyAttributes":
            suggest = "key_attributes"
        elif key == "metricDataQueries":
            suggest = "metric_data_queries"
        elif key == "metricType":
            suggest = "metric_type"
        elif key == "operationName":
            suggest = "operation_name"
        elif key == "periodSeconds":
            suggest = "period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLevelObjectiveSliMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLevelObjectiveSliMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLevelObjectiveSliMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_attributes: Optional[Mapping[str, str]] = None,
                 metric_data_queries: Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']] = None,
                 metric_type: Optional['ServiceLevelObjectiveSliMetricMetricType'] = None,
                 operation_name: Optional[str] = None,
                 period_seconds: Optional[int] = None,
                 statistic: Optional[str] = None):
        """
        A structure that contains information about the metric that the SLO monitors.
        :param Mapping[str, str] key_attributes: If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to. To do so, you must specify at least the `Type` , `Name` , and `Environment` attributes.
               
               This is a string-to-string map. It can include the following fields.
               
               - `Type` designates the type of object this is.
               - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
               - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
               - `Environment` specifies the location where this object is hosted, or what it belongs to.
        :param Sequence['ServiceLevelObjectiveMetricDataQuery'] metric_data_queries: If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
        :param 'ServiceLevelObjectiveSliMetricMetricType' metric_type: If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        :param str operation_name: If the SLO monitors a specific operation of the service, this field displays that operation name.
        :param int period_seconds: The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
        :param str statistic: The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic
        """
        if key_attributes is not None:
            pulumi.set(__self__, "key_attributes", key_attributes)
        if metric_data_queries is not None:
            pulumi.set(__self__, "metric_data_queries", metric_data_queries)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> Optional[Mapping[str, str]]:
        """
        If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to. To do so, you must specify at least the `Type` , `Name` , and `Environment` attributes.

        This is a string-to-string map. It can include the following fields.

        - `Type` designates the type of object this is.
        - `ResourceType` specifies the type of the resource. This field is used only when the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Name` specifies the name of the object. This is used only if the value of the `Type` field is `Service` , `RemoteService` , or `AWS::Service` .
        - `Identifier` identifies the resource objects of this resource. This is used only if the value of the `Type` field is `Resource` or `AWS::Resource` .
        - `Environment` specifies the location where this object is hosted, or what it belongs to.
        """
        return pulumi.get(self, "key_attributes")

    @property
    @pulumi.getter(name="metricDataQueries")
    def metric_data_queries(self) -> Optional[Sequence['outputs.ServiceLevelObjectiveMetricDataQuery']]:
        """
        If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
        """
        return pulumi.get(self, "metric_data_queries")

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional['ServiceLevelObjectiveSliMetricMetricType']:
        """
        If the SLO monitors either the LATENCY or AVAILABILITY metric that Application Signals collects, this field displays which of those metrics is used.
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        If the SLO monitors a specific operation of the service, this field displays that operation name.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        The number of seconds to use as the period for SLO evaluation. Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic
        """
        return pulumi.get(self, "statistic")


