# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectorLambdaConnectorProvisioningConfig',
    'ConnectorProfileAmplitudeConnectorProfileCredentials',
    'ConnectorProfileApiKeyCredentials',
    'ConnectorProfileBasicAuthCredentials',
    'ConnectorProfileConfig',
    'ConnectorProfileConnectorOAuthRequest',
    'ConnectorProfileCredentials',
    'ConnectorProfileCustomAuthCredentials',
    'ConnectorProfileCustomConnectorProfileCredentials',
    'ConnectorProfileCustomConnectorProfileProperties',
    'ConnectorProfileDatadogConnectorProfileCredentials',
    'ConnectorProfileDatadogConnectorProfileProperties',
    'ConnectorProfileDynatraceConnectorProfileCredentials',
    'ConnectorProfileDynatraceConnectorProfileProperties',
    'ConnectorProfileGoogleAnalyticsConnectorProfileCredentials',
    'ConnectorProfileInforNexusConnectorProfileCredentials',
    'ConnectorProfileInforNexusConnectorProfileProperties',
    'ConnectorProfileMarketoConnectorProfileCredentials',
    'ConnectorProfileMarketoConnectorProfileProperties',
    'ConnectorProfileOAuth2Credentials',
    'ConnectorProfileOAuth2Properties',
    'ConnectorProfileOAuthProperties',
    'ConnectorProfilePardotConnectorProfileCredentials',
    'ConnectorProfilePardotConnectorProfileProperties',
    'ConnectorProfileProperties',
    'ConnectorProfileRedshiftConnectorProfileCredentials',
    'ConnectorProfileRedshiftConnectorProfileProperties',
    'ConnectorProfileSalesforceConnectorProfileCredentials',
    'ConnectorProfileSalesforceConnectorProfileProperties',
    'ConnectorProfileSapoDataConnectorProfileCredentials',
    'ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties',
    'ConnectorProfileSapoDataConnectorProfileProperties',
    'ConnectorProfileServiceNowConnectorProfileCredentials',
    'ConnectorProfileServiceNowConnectorProfileProperties',
    'ConnectorProfileSingularConnectorProfileCredentials',
    'ConnectorProfileSlackConnectorProfileCredentials',
    'ConnectorProfileSlackConnectorProfileProperties',
    'ConnectorProfileSnowflakeConnectorProfileCredentials',
    'ConnectorProfileSnowflakeConnectorProfileProperties',
    'ConnectorProfileTrendmicroConnectorProfileCredentials',
    'ConnectorProfileVeevaConnectorProfileCredentials',
    'ConnectorProfileVeevaConnectorProfileProperties',
    'ConnectorProfileZendeskConnectorProfileCredentials',
    'ConnectorProfileZendeskConnectorProfileProperties',
    'ConnectorProvisioningConfig',
    'FlowAggregationConfig',
    'FlowAmplitudeSourceProperties',
    'FlowConnectorOperator',
    'FlowCustomConnectorDestinationProperties',
    'FlowCustomConnectorSourceProperties',
    'FlowCustomConnectorSourcePropertiesDataTransferApiProperties',
    'FlowDatadogSourceProperties',
    'FlowDestinationConnectorProperties',
    'FlowDestinationFlowConfig',
    'FlowDynatraceSourceProperties',
    'FlowErrorHandlingConfig',
    'FlowEventBridgeDestinationProperties',
    'FlowGlueDataCatalog',
    'FlowGoogleAnalyticsSourceProperties',
    'FlowIncrementalPullConfig',
    'FlowInforNexusSourceProperties',
    'FlowLookoutMetricsDestinationProperties',
    'FlowMarketoDestinationProperties',
    'FlowMarketoSourceProperties',
    'FlowMetadataCatalogConfig',
    'FlowPardotSourceProperties',
    'FlowPrefixConfig',
    'FlowRedshiftDestinationProperties',
    'FlowS3DestinationProperties',
    'FlowS3InputFormatConfig',
    'FlowS3OutputFormatConfig',
    'FlowS3SourceProperties',
    'FlowSalesforceDestinationProperties',
    'FlowSalesforceSourceProperties',
    'FlowSapoDataDestinationProperties',
    'FlowSapoDataPaginationConfig',
    'FlowSapoDataParallelismConfig',
    'FlowSapoDataSourceProperties',
    'FlowScheduledTriggerProperties',
    'FlowServiceNowSourceProperties',
    'FlowSingularSourceProperties',
    'FlowSlackSourceProperties',
    'FlowSnowflakeDestinationProperties',
    'FlowSourceConnectorProperties',
    'FlowSourceFlowConfig',
    'FlowSuccessResponseHandlingConfig',
    'FlowTask',
    'FlowTaskPropertiesObject',
    'FlowTrendmicroSourceProperties',
    'FlowTriggerConfig',
    'FlowUpsolverDestinationProperties',
    'FlowUpsolverS3OutputFormatConfig',
    'FlowVeevaSourceProperties',
    'FlowZendeskDestinationProperties',
    'FlowZendeskSourceProperties',
]

@pulumi.output_type
class ConnectorLambdaConnectorProvisioningConfig(dict):
    """
    Contains information about the configuration of the lambda which is being registered as the connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorLambdaConnectorProvisioningConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorLambdaConnectorProvisioningConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorLambdaConnectorProvisioningConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str):
        """
        Contains information about the configuration of the lambda which is being registered as the connector.
        :param str lambda_arn: Lambda ARN of the connector being registered.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        Lambda ARN of the connector being registered.
        """
        return pulumi.get(self, "lambda_arn")


@pulumi.output_type
class ConnectorProfileAmplitudeConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileAmplitudeConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileAmplitudeConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileAmplitudeConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 secret_key: str):
        """
        :param str api_key: A unique alphanumeric identiﬁer used to authenticate a user, developer, or calling program to your API.
        :param str secret_key: The Secret Access Key portion of the credentials.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        A unique alphanumeric identiﬁer used to authenticate a user, developer, or calling program to your API.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The Secret Access Key portion of the credentials.
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ConnectorProfileApiKeyCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "apiSecretKey":
            suggest = "api_secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileApiKeyCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileApiKeyCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileApiKeyCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 api_secret_key: Optional[str] = None):
        """
        :param str api_key: The API key required for API key authentication.
        :param str api_secret_key: The API secret key required for API key authentication.
        """
        pulumi.set(__self__, "api_key", api_key)
        if api_secret_key is not None:
            pulumi.set(__self__, "api_secret_key", api_secret_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        The API key required for API key authentication.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiSecretKey")
    def api_secret_key(self) -> Optional[str]:
        """
        The API secret key required for API key authentication.
        """
        return pulumi.get(self, "api_secret_key")


@pulumi.output_type
class ConnectorProfileBasicAuthCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password to use to connect to a resource.
        :param str username: The username to use to connect to a resource.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to use to connect to a resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to use to connect to a resource.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectorProfileConfig(dict):
    """
    Connector specific configurations needed to create connector profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorProfileCredentials":
            suggest = "connector_profile_credentials"
        elif key == "connectorProfileProperties":
            suggest = "connector_profile_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_profile_credentials: Optional['outputs.ConnectorProfileCredentials'] = None,
                 connector_profile_properties: Optional['outputs.ConnectorProfileProperties'] = None):
        """
        Connector specific configurations needed to create connector profile
        :param 'ConnectorProfileCredentials' connector_profile_credentials: The connector-specific credentials required by each connector.
        :param 'ConnectorProfileProperties' connector_profile_properties: The connector-specific properties of the profile configuration.
        """
        if connector_profile_credentials is not None:
            pulumi.set(__self__, "connector_profile_credentials", connector_profile_credentials)
        if connector_profile_properties is not None:
            pulumi.set(__self__, "connector_profile_properties", connector_profile_properties)

    @property
    @pulumi.getter(name="connectorProfileCredentials")
    def connector_profile_credentials(self) -> Optional['outputs.ConnectorProfileCredentials']:
        """
        The connector-specific credentials required by each connector.
        """
        return pulumi.get(self, "connector_profile_credentials")

    @property
    @pulumi.getter(name="connectorProfileProperties")
    def connector_profile_properties(self) -> Optional['outputs.ConnectorProfileProperties']:
        """
        The connector-specific properties of the profile configuration.
        """
        return pulumi.get(self, "connector_profile_properties")


@pulumi.output_type
class ConnectorProfileConnectorOAuthRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authCode":
            suggest = "auth_code"
        elif key == "redirectUri":
            suggest = "redirect_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileConnectorOAuthRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileConnectorOAuthRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileConnectorOAuthRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_code: Optional[str] = None,
                 redirect_uri: Optional[str] = None):
        """
        :param str auth_code: The code provided by the connector when it has been authenticated via the connected app.
        :param str redirect_uri: The URL to which the authentication server redirects the browser after authorization has been
               granted.
        """
        if auth_code is not None:
            pulumi.set(__self__, "auth_code", auth_code)
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)

    @property
    @pulumi.getter(name="authCode")
    def auth_code(self) -> Optional[str]:
        """
        The code provided by the connector when it has been authenticated via the connected app.
        """
        return pulumi.get(self, "auth_code")

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional[str]:
        """
        The URL to which the authentication server redirects the browser after authorization has been
        granted.
        """
        return pulumi.get(self, "redirect_uri")


@pulumi.output_type
class ConnectorProfileCredentials(dict):
    """
    Connector specific configuration needed to create connector profile based on Authentication mechanism
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConnector":
            suggest = "custom_connector"
        elif key == "googleAnalytics":
            suggest = "google_analytics"
        elif key == "inforNexus":
            suggest = "infor_nexus"
        elif key == "sapoData":
            suggest = "sapo_data"
        elif key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amplitude: Optional['outputs.ConnectorProfileAmplitudeConnectorProfileCredentials'] = None,
                 custom_connector: Optional['outputs.ConnectorProfileCustomConnectorProfileCredentials'] = None,
                 datadog: Optional['outputs.ConnectorProfileDatadogConnectorProfileCredentials'] = None,
                 dynatrace: Optional['outputs.ConnectorProfileDynatraceConnectorProfileCredentials'] = None,
                 google_analytics: Optional['outputs.ConnectorProfileGoogleAnalyticsConnectorProfileCredentials'] = None,
                 infor_nexus: Optional['outputs.ConnectorProfileInforNexusConnectorProfileCredentials'] = None,
                 marketo: Optional['outputs.ConnectorProfileMarketoConnectorProfileCredentials'] = None,
                 pardot: Optional['outputs.ConnectorProfilePardotConnectorProfileCredentials'] = None,
                 redshift: Optional['outputs.ConnectorProfileRedshiftConnectorProfileCredentials'] = None,
                 salesforce: Optional['outputs.ConnectorProfileSalesforceConnectorProfileCredentials'] = None,
                 sapo_data: Optional['outputs.ConnectorProfileSapoDataConnectorProfileCredentials'] = None,
                 service_now: Optional['outputs.ConnectorProfileServiceNowConnectorProfileCredentials'] = None,
                 singular: Optional['outputs.ConnectorProfileSingularConnectorProfileCredentials'] = None,
                 slack: Optional['outputs.ConnectorProfileSlackConnectorProfileCredentials'] = None,
                 snowflake: Optional['outputs.ConnectorProfileSnowflakeConnectorProfileCredentials'] = None,
                 trendmicro: Optional['outputs.ConnectorProfileTrendmicroConnectorProfileCredentials'] = None,
                 veeva: Optional['outputs.ConnectorProfileVeevaConnectorProfileCredentials'] = None,
                 zendesk: Optional['outputs.ConnectorProfileZendeskConnectorProfileCredentials'] = None):
        """
        Connector specific configuration needed to create connector profile based on Authentication mechanism
        :param 'ConnectorProfileAmplitudeConnectorProfileCredentials' amplitude: The connector-specific credentials required when using Amplitude.
        :param 'ConnectorProfileCustomConnectorProfileCredentials' custom_connector: The connector-specific profile credentials that are required when using the custom connector.
        :param 'ConnectorProfileDatadogConnectorProfileCredentials' datadog: The connector-specific credentials required when using Datadog.
        :param 'ConnectorProfileDynatraceConnectorProfileCredentials' dynatrace: The connector-specific credentials required when using Dynatrace.
        :param 'ConnectorProfileGoogleAnalyticsConnectorProfileCredentials' google_analytics: The connector-specific credentials required when using Google Analytics.
        :param 'ConnectorProfileInforNexusConnectorProfileCredentials' infor_nexus: The connector-specific credentials required when using Infor Nexus.
        :param 'ConnectorProfileMarketoConnectorProfileCredentials' marketo: The connector-specific credentials required when using Marketo.
        :param 'ConnectorProfilePardotConnectorProfileCredentials' pardot: The connector-specific credentials required when using Salesforce Pardot.
        :param 'ConnectorProfileRedshiftConnectorProfileCredentials' redshift: The connector-specific credentials required when using Amazon Redshift.
        :param 'ConnectorProfileSalesforceConnectorProfileCredentials' salesforce: The connector-specific credentials required when using Salesforce.
        :param 'ConnectorProfileSapoDataConnectorProfileCredentials' sapo_data: The connector-specific profile credentials required when using SAPOData.
        :param 'ConnectorProfileServiceNowConnectorProfileCredentials' service_now: The connector-specific credentials required when using ServiceNow.
        :param 'ConnectorProfileSingularConnectorProfileCredentials' singular: The connector-specific credentials required when using Singular.
        :param 'ConnectorProfileSlackConnectorProfileCredentials' slack: The connector-specific credentials required when using Slack.
        :param 'ConnectorProfileSnowflakeConnectorProfileCredentials' snowflake: The connector-specific credentials required when using Snowflake.
        :param 'ConnectorProfileTrendmicroConnectorProfileCredentials' trendmicro: The connector-specific credentials required when using Trend Micro.
        :param 'ConnectorProfileVeevaConnectorProfileCredentials' veeva: The connector-specific credentials required when using Veeva.
        :param 'ConnectorProfileZendeskConnectorProfileCredentials' zendesk: The connector-specific credentials required when using Zendesk.
        """
        if amplitude is not None:
            pulumi.set(__self__, "amplitude", amplitude)
        if custom_connector is not None:
            pulumi.set(__self__, "custom_connector", custom_connector)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if dynatrace is not None:
            pulumi.set(__self__, "dynatrace", dynatrace)
        if google_analytics is not None:
            pulumi.set(__self__, "google_analytics", google_analytics)
        if infor_nexus is not None:
            pulumi.set(__self__, "infor_nexus", infor_nexus)
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if pardot is not None:
            pulumi.set(__self__, "pardot", pardot)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if sapo_data is not None:
            pulumi.set(__self__, "sapo_data", sapo_data)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if trendmicro is not None:
            pulumi.set(__self__, "trendmicro", trendmicro)
        if veeva is not None:
            pulumi.set(__self__, "veeva", veeva)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def amplitude(self) -> Optional['outputs.ConnectorProfileAmplitudeConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Amplitude.
        """
        return pulumi.get(self, "amplitude")

    @property
    @pulumi.getter(name="customConnector")
    def custom_connector(self) -> Optional['outputs.ConnectorProfileCustomConnectorProfileCredentials']:
        """
        The connector-specific profile credentials that are required when using the custom connector.
        """
        return pulumi.get(self, "custom_connector")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.ConnectorProfileDatadogConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Datadog.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def dynatrace(self) -> Optional['outputs.ConnectorProfileDynatraceConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Dynatrace.
        """
        return pulumi.get(self, "dynatrace")

    @property
    @pulumi.getter(name="googleAnalytics")
    def google_analytics(self) -> Optional['outputs.ConnectorProfileGoogleAnalyticsConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Google Analytics.
        """
        return pulumi.get(self, "google_analytics")

    @property
    @pulumi.getter(name="inforNexus")
    def infor_nexus(self) -> Optional['outputs.ConnectorProfileInforNexusConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Infor Nexus.
        """
        return pulumi.get(self, "infor_nexus")

    @property
    @pulumi.getter
    def marketo(self) -> Optional['outputs.ConnectorProfileMarketoConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Marketo.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def pardot(self) -> Optional['outputs.ConnectorProfilePardotConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Salesforce Pardot.
        """
        return pulumi.get(self, "pardot")

    @property
    @pulumi.getter
    def redshift(self) -> Optional['outputs.ConnectorProfileRedshiftConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Amazon Redshift.
        """
        return pulumi.get(self, "redshift")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['outputs.ConnectorProfileSalesforceConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Salesforce.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="sapoData")
    def sapo_data(self) -> Optional['outputs.ConnectorProfileSapoDataConnectorProfileCredentials']:
        """
        The connector-specific profile credentials required when using SAPOData.
        """
        return pulumi.get(self, "sapo_data")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['outputs.ConnectorProfileServiceNowConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using ServiceNow.
        """
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def singular(self) -> Optional['outputs.ConnectorProfileSingularConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Singular.
        """
        return pulumi.get(self, "singular")

    @property
    @pulumi.getter
    def slack(self) -> Optional['outputs.ConnectorProfileSlackConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Slack.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def snowflake(self) -> Optional['outputs.ConnectorProfileSnowflakeConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Snowflake.
        """
        return pulumi.get(self, "snowflake")

    @property
    @pulumi.getter
    def trendmicro(self) -> Optional['outputs.ConnectorProfileTrendmicroConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Trend Micro.
        """
        return pulumi.get(self, "trendmicro")

    @property
    @pulumi.getter
    def veeva(self) -> Optional['outputs.ConnectorProfileVeevaConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Veeva.
        """
        return pulumi.get(self, "veeva")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['outputs.ConnectorProfileZendeskConnectorProfileCredentials']:
        """
        The connector-specific credentials required when using Zendesk.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class ConnectorProfileCustomAuthCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customAuthenticationType":
            suggest = "custom_authentication_type"
        elif key == "credentialsMap":
            suggest = "credentials_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileCustomAuthCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileCustomAuthCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileCustomAuthCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_authentication_type: str,
                 credentials_map: Optional[Mapping[str, str]] = None):
        """
        :param str custom_authentication_type: The custom authentication type that the connector uses.
        :param Mapping[str, str] credentials_map: A map that holds custom authentication credentials.
        """
        pulumi.set(__self__, "custom_authentication_type", custom_authentication_type)
        if credentials_map is not None:
            pulumi.set(__self__, "credentials_map", credentials_map)

    @property
    @pulumi.getter(name="customAuthenticationType")
    def custom_authentication_type(self) -> str:
        """
        The custom authentication type that the connector uses.
        """
        return pulumi.get(self, "custom_authentication_type")

    @property
    @pulumi.getter(name="credentialsMap")
    def credentials_map(self) -> Optional[Mapping[str, str]]:
        """
        A map that holds custom authentication credentials.
        """
        return pulumi.get(self, "credentials_map")


@pulumi.output_type
class ConnectorProfileCustomConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileCustomConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileCustomConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileCustomConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: 'ConnectorProfileAuthenticationType',
                 api_key: Optional['outputs.ConnectorProfileApiKeyCredentials'] = None,
                 basic: Optional['outputs.ConnectorProfileBasicAuthCredentials'] = None,
                 custom: Optional['outputs.ConnectorProfileCustomAuthCredentials'] = None,
                 oauth2: Optional['outputs.ConnectorProfileOAuth2Credentials'] = None):
        """
        :param 'ConnectorProfileAuthenticationType' authentication_type: The authentication type that the custom connector uses for authenticating while creating a connector profile.
        :param 'ConnectorProfileApiKeyCredentials' api_key: The API keys required for the authentication of the user.
        :param 'ConnectorProfileBasicAuthCredentials' basic: The basic credentials that are required for the authentication of the user.
        :param 'ConnectorProfileCustomAuthCredentials' custom: If the connector uses the custom authentication mechanism, this holds the required credentials.
        :param 'ConnectorProfileOAuth2Credentials' oauth2: The OAuth 2.0 credentials required for the authentication of the user.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if oauth2 is not None:
            pulumi.set(__self__, "oauth2", oauth2)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> 'ConnectorProfileAuthenticationType':
        """
        The authentication type that the custom connector uses for authenticating while creating a connector profile.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional['outputs.ConnectorProfileApiKeyCredentials']:
        """
        The API keys required for the authentication of the user.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.ConnectorProfileBasicAuthCredentials']:
        """
        The basic credentials that are required for the authentication of the user.
        """
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter
    def custom(self) -> Optional['outputs.ConnectorProfileCustomAuthCredentials']:
        """
        If the connector uses the custom authentication mechanism, this holds the required credentials.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def oauth2(self) -> Optional['outputs.ConnectorProfileOAuth2Credentials']:
        """
        The OAuth 2.0 credentials required for the authentication of the user.
        """
        return pulumi.get(self, "oauth2")


@pulumi.output_type
class ConnectorProfileCustomConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oAuth2Properties":
            suggest = "o_auth2_properties"
        elif key == "profileProperties":
            suggest = "profile_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileCustomConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileCustomConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileCustomConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_auth2_properties: Optional['outputs.ConnectorProfileOAuth2Properties'] = None,
                 profile_properties: Optional[Mapping[str, str]] = None):
        """
        :param 'ConnectorProfileOAuth2Properties' o_auth2_properties: The OAuth 2.0 properties required for OAuth 2.0 authentication.
        :param Mapping[str, str] profile_properties: A map of properties that are required to create a profile for the custom connector.
        """
        if o_auth2_properties is not None:
            pulumi.set(__self__, "o_auth2_properties", o_auth2_properties)
        if profile_properties is not None:
            pulumi.set(__self__, "profile_properties", profile_properties)

    @property
    @pulumi.getter(name="oAuth2Properties")
    def o_auth2_properties(self) -> Optional['outputs.ConnectorProfileOAuth2Properties']:
        """
        The OAuth 2.0 properties required for OAuth 2.0 authentication.
        """
        return pulumi.get(self, "o_auth2_properties")

    @property
    @pulumi.getter(name="profileProperties")
    def profile_properties(self) -> Optional[Mapping[str, str]]:
        """
        A map of properties that are required to create a profile for the custom connector.
        """
        return pulumi.get(self, "profile_properties")


@pulumi.output_type
class ConnectorProfileDatadogConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "applicationKey":
            suggest = "application_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileDatadogConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileDatadogConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileDatadogConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 application_key: str):
        """
        :param str api_key: A unique alphanumeric identiﬁer used to authenticate a user, developer, or calling program to your API.
        :param str application_key: Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "application_key", application_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        A unique alphanumeric identiﬁer used to authenticate a user, developer, or calling program to your API.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> str:
        """
        Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
        """
        return pulumi.get(self, "application_key")


@pulumi.output_type
class ConnectorProfileDatadogConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileDatadogConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileDatadogConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileDatadogConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the Datadog resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the Datadog resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileDynatraceConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiToken":
            suggest = "api_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileDynatraceConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileDynatraceConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileDynatraceConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_token: str):
        """
        :param str api_token: The API tokens used by Dynatrace API to authenticate various API calls.
        """
        pulumi.set(__self__, "api_token", api_token)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> str:
        """
        The API tokens used by Dynatrace API to authenticate various API calls.
        """
        return pulumi.get(self, "api_token")


@pulumi.output_type
class ConnectorProfileDynatraceConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileDynatraceConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileDynatraceConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileDynatraceConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the Dynatrace resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the Dynatrace resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileGoogleAnalyticsConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileGoogleAnalyticsConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileGoogleAnalyticsConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileGoogleAnalyticsConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str,
                 access_token: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None,
                 refresh_token: Optional[str] = None):
        """
        :param str client_id: The identiﬁer for the desired client.
        :param str client_secret: The client secret used by the oauth client to authenticate to the authorization server.
        :param str access_token: The credentials used to access protected resources.
        :param 'ConnectorProfileConnectorOAuthRequest' connector_o_auth_request: The oauth needed to request security tokens from the connector endpoint.
        :param str refresh_token: The credentials used to acquire new access tokens.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The identiﬁer for the desired client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret used by the oauth client to authenticate to the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The credentials used to access protected resources.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        """
        The oauth needed to request security tokens from the connector endpoint.
        """
        return pulumi.get(self, "connector_o_auth_request")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        The credentials used to acquire new access tokens.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ConnectorProfileInforNexusConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileInforNexusConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileInforNexusConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileInforNexusConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 datakey: str,
                 secret_access_key: str,
                 user_id: str):
        """
        :param str access_key_id: The Access Key portion of the credentials.
        :param str datakey: The encryption keys used to encrypt data.
        :param str secret_access_key: The secret key used to sign requests.
        :param str user_id: The identiﬁer for the user.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "datakey", datakey)
        pulumi.set(__self__, "secret_access_key", secret_access_key)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        The Access Key portion of the credentials.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def datakey(self) -> str:
        """
        The encryption keys used to encrypt data.
        """
        return pulumi.get(self, "datakey")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        The secret key used to sign requests.
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The identiﬁer for the user.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class ConnectorProfileInforNexusConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileInforNexusConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileInforNexusConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileInforNexusConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the InforNexus resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the InforNexus resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileMarketoConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileMarketoConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileMarketoConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileMarketoConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str,
                 access_token: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None):
        """
        :param str client_id: The identiﬁer for the desired client.
        :param str client_secret: The client secret used by the oauth client to authenticate to the authorization server.
        :param str access_token: The credentials used to access protected resources.
        :param 'ConnectorProfileConnectorOAuthRequest' connector_o_auth_request: The oauth needed to request security tokens from the connector endpoint.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The identiﬁer for the desired client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret used by the oauth client to authenticate to the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The credentials used to access protected resources.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        """
        The oauth needed to request security tokens from the connector endpoint.
        """
        return pulumi.get(self, "connector_o_auth_request")


@pulumi.output_type
class ConnectorProfileMarketoConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileMarketoConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileMarketoConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileMarketoConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the Marketo resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the Marketo resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileOAuth2Credentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "oAuthRequest":
            suggest = "o_auth_request"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileOAuth2Credentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileOAuth2Credentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileOAuth2Credentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None,
                 refresh_token: Optional[str] = None):
        """
        :param str access_token: The access token used to access the connector on your behalf.
        :param str client_id: The identifier for the desired client.
        :param str client_secret: The client secret used by the OAuth client to authenticate to the authorization server.
        :param str refresh_token: The refresh token used to refresh an expired access token.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if o_auth_request is not None:
            pulumi.set(__self__, "o_auth_request", o_auth_request)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The access token used to access the connector on your behalf.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The identifier for the desired client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret used by the OAuth client to authenticate to the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="oAuthRequest")
    def o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        return pulumi.get(self, "o_auth_request")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        The refresh token used to refresh an expired access token.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ConnectorProfileOAuth2Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oAuth2GrantType":
            suggest = "o_auth2_grant_type"
        elif key == "tokenUrl":
            suggest = "token_url"
        elif key == "tokenUrlCustomProperties":
            suggest = "token_url_custom_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileOAuth2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileOAuth2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileOAuth2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_auth2_grant_type: Optional['ConnectorProfileOAuth2GrantType'] = None,
                 token_url: Optional[str] = None,
                 token_url_custom_properties: Optional[Mapping[str, str]] = None):
        """
        :param 'ConnectorProfileOAuth2GrantType' o_auth2_grant_type: The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
        :param str token_url: The token URL required for OAuth 2.0 authentication.
        :param Mapping[str, str] token_url_custom_properties: Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
        """
        if o_auth2_grant_type is not None:
            pulumi.set(__self__, "o_auth2_grant_type", o_auth2_grant_type)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if token_url_custom_properties is not None:
            pulumi.set(__self__, "token_url_custom_properties", token_url_custom_properties)

    @property
    @pulumi.getter(name="oAuth2GrantType")
    def o_auth2_grant_type(self) -> Optional['ConnectorProfileOAuth2GrantType']:
        """
        The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
        """
        return pulumi.get(self, "o_auth2_grant_type")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[str]:
        """
        The token URL required for OAuth 2.0 authentication.
        """
        return pulumi.get(self, "token_url")

    @property
    @pulumi.getter(name="tokenUrlCustomProperties")
    def token_url_custom_properties(self) -> Optional[Mapping[str, str]]:
        """
        Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
        """
        return pulumi.get(self, "token_url_custom_properties")


@pulumi.output_type
class ConnectorProfileOAuthProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authCodeUrl":
            suggest = "auth_code_url"
        elif key == "oAuthScopes":
            suggest = "o_auth_scopes"
        elif key == "tokenUrl":
            suggest = "token_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileOAuthProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileOAuthProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileOAuthProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_code_url: Optional[str] = None,
                 o_auth_scopes: Optional[Sequence[str]] = None,
                 token_url: Optional[str] = None):
        """
        :param str auth_code_url: The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
        :param Sequence[str] o_auth_scopes: The OAuth scopes required for OAuth type authentication.
        :param str token_url: The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.
        """
        if auth_code_url is not None:
            pulumi.set(__self__, "auth_code_url", auth_code_url)
        if o_auth_scopes is not None:
            pulumi.set(__self__, "o_auth_scopes", o_auth_scopes)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)

    @property
    @pulumi.getter(name="authCodeUrl")
    def auth_code_url(self) -> Optional[str]:
        """
        The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
        """
        return pulumi.get(self, "auth_code_url")

    @property
    @pulumi.getter(name="oAuthScopes")
    def o_auth_scopes(self) -> Optional[Sequence[str]]:
        """
        The OAuth scopes required for OAuth type authentication.
        """
        return pulumi.get(self, "o_auth_scopes")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[str]:
        """
        The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.
        """
        return pulumi.get(self, "token_url")


@pulumi.output_type
class ConnectorProfilePardotConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "clientCredentialsArn":
            suggest = "client_credentials_arn"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfilePardotConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfilePardotConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfilePardotConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[str] = None,
                 client_credentials_arn: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None,
                 refresh_token: Optional[str] = None):
        """
        :param str access_token: The credentials used to access protected resources.
        :param str client_credentials_arn: The client credentials to fetch access token and refresh token.
        :param 'ConnectorProfileConnectorOAuthRequest' connector_o_auth_request: The oauth needed to request security tokens from the connector endpoint.
        :param str refresh_token: The credentials used to acquire new access tokens.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if client_credentials_arn is not None:
            pulumi.set(__self__, "client_credentials_arn", client_credentials_arn)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The credentials used to access protected resources.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="clientCredentialsArn")
    def client_credentials_arn(self) -> Optional[str]:
        """
        The client credentials to fetch access token and refresh token.
        """
        return pulumi.get(self, "client_credentials_arn")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        """
        The oauth needed to request security tokens from the connector endpoint.
        """
        return pulumi.get(self, "connector_o_auth_request")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        The credentials used to acquire new access tokens.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ConnectorProfilePardotConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "businessUnitId":
            suggest = "business_unit_id"
        elif key == "instanceUrl":
            suggest = "instance_url"
        elif key == "isSandboxEnvironment":
            suggest = "is_sandbox_environment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfilePardotConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfilePardotConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfilePardotConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 business_unit_id: str,
                 instance_url: Optional[str] = None,
                 is_sandbox_environment: Optional[bool] = None):
        """
        :param str business_unit_id: The Business unit id of Salesforce Pardot instance to be connected
        :param str instance_url: The location of the Salesforce Pardot resource
        :param bool is_sandbox_environment: Indicates whether the connector profile applies to a demo or production environment
        """
        pulumi.set(__self__, "business_unit_id", business_unit_id)
        if instance_url is not None:
            pulumi.set(__self__, "instance_url", instance_url)
        if is_sandbox_environment is not None:
            pulumi.set(__self__, "is_sandbox_environment", is_sandbox_environment)

    @property
    @pulumi.getter(name="businessUnitId")
    def business_unit_id(self) -> str:
        """
        The Business unit id of Salesforce Pardot instance to be connected
        """
        return pulumi.get(self, "business_unit_id")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> Optional[str]:
        """
        The location of the Salesforce Pardot resource
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isSandboxEnvironment")
    def is_sandbox_environment(self) -> Optional[bool]:
        """
        Indicates whether the connector profile applies to a demo or production environment
        """
        return pulumi.get(self, "is_sandbox_environment")


@pulumi.output_type
class ConnectorProfileProperties(dict):
    """
    Connector specific properties needed to create connector profile - currently not needed for Amplitude, Trendmicro, Googleanalytics and Singular
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConnector":
            suggest = "custom_connector"
        elif key == "inforNexus":
            suggest = "infor_nexus"
        elif key == "sapoData":
            suggest = "sapo_data"
        elif key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_connector: Optional['outputs.ConnectorProfileCustomConnectorProfileProperties'] = None,
                 datadog: Optional['outputs.ConnectorProfileDatadogConnectorProfileProperties'] = None,
                 dynatrace: Optional['outputs.ConnectorProfileDynatraceConnectorProfileProperties'] = None,
                 infor_nexus: Optional['outputs.ConnectorProfileInforNexusConnectorProfileProperties'] = None,
                 marketo: Optional['outputs.ConnectorProfileMarketoConnectorProfileProperties'] = None,
                 pardot: Optional['outputs.ConnectorProfilePardotConnectorProfileProperties'] = None,
                 redshift: Optional['outputs.ConnectorProfileRedshiftConnectorProfileProperties'] = None,
                 salesforce: Optional['outputs.ConnectorProfileSalesforceConnectorProfileProperties'] = None,
                 sapo_data: Optional['outputs.ConnectorProfileSapoDataConnectorProfileProperties'] = None,
                 service_now: Optional['outputs.ConnectorProfileServiceNowConnectorProfileProperties'] = None,
                 slack: Optional['outputs.ConnectorProfileSlackConnectorProfileProperties'] = None,
                 snowflake: Optional['outputs.ConnectorProfileSnowflakeConnectorProfileProperties'] = None,
                 veeva: Optional['outputs.ConnectorProfileVeevaConnectorProfileProperties'] = None,
                 zendesk: Optional['outputs.ConnectorProfileZendeskConnectorProfileProperties'] = None):
        """
        Connector specific properties needed to create connector profile - currently not needed for Amplitude, Trendmicro, Googleanalytics and Singular
        :param 'ConnectorProfileCustomConnectorProfileProperties' custom_connector: The properties required by the custom connector.
        :param 'ConnectorProfileDatadogConnectorProfileProperties' datadog: The connector-specific properties required by Datadog.
        :param 'ConnectorProfileDynatraceConnectorProfileProperties' dynatrace: The connector-specific properties required by Dynatrace.
        :param 'ConnectorProfileInforNexusConnectorProfileProperties' infor_nexus: The connector-specific properties required by Infor Nexus.
        :param 'ConnectorProfileMarketoConnectorProfileProperties' marketo: The connector-specific properties required by Marketo.
        :param 'ConnectorProfilePardotConnectorProfileProperties' pardot: The connector-specific properties required by Salesforce Pardot.
        :param 'ConnectorProfileRedshiftConnectorProfileProperties' redshift: The connector-specific properties required by Amazon Redshift.
        :param 'ConnectorProfileSalesforceConnectorProfileProperties' salesforce: The connector-specific properties required by Salesforce.
        :param 'ConnectorProfileSapoDataConnectorProfileProperties' sapo_data: The connector-specific profile properties required when using SAPOData.
        :param 'ConnectorProfileServiceNowConnectorProfileProperties' service_now: The connector-specific properties required by serviceNow.
        :param 'ConnectorProfileSlackConnectorProfileProperties' slack: The connector-specific properties required by Slack.
        :param 'ConnectorProfileSnowflakeConnectorProfileProperties' snowflake: The connector-specific properties required by Snowflake.
        :param 'ConnectorProfileVeevaConnectorProfileProperties' veeva: The connector-specific properties required by Veeva.
        :param 'ConnectorProfileZendeskConnectorProfileProperties' zendesk: The connector-specific properties required by Zendesk.
        """
        if custom_connector is not None:
            pulumi.set(__self__, "custom_connector", custom_connector)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if dynatrace is not None:
            pulumi.set(__self__, "dynatrace", dynatrace)
        if infor_nexus is not None:
            pulumi.set(__self__, "infor_nexus", infor_nexus)
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if pardot is not None:
            pulumi.set(__self__, "pardot", pardot)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if sapo_data is not None:
            pulumi.set(__self__, "sapo_data", sapo_data)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if veeva is not None:
            pulumi.set(__self__, "veeva", veeva)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter(name="customConnector")
    def custom_connector(self) -> Optional['outputs.ConnectorProfileCustomConnectorProfileProperties']:
        """
        The properties required by the custom connector.
        """
        return pulumi.get(self, "custom_connector")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.ConnectorProfileDatadogConnectorProfileProperties']:
        """
        The connector-specific properties required by Datadog.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def dynatrace(self) -> Optional['outputs.ConnectorProfileDynatraceConnectorProfileProperties']:
        """
        The connector-specific properties required by Dynatrace.
        """
        return pulumi.get(self, "dynatrace")

    @property
    @pulumi.getter(name="inforNexus")
    def infor_nexus(self) -> Optional['outputs.ConnectorProfileInforNexusConnectorProfileProperties']:
        """
        The connector-specific properties required by Infor Nexus.
        """
        return pulumi.get(self, "infor_nexus")

    @property
    @pulumi.getter
    def marketo(self) -> Optional['outputs.ConnectorProfileMarketoConnectorProfileProperties']:
        """
        The connector-specific properties required by Marketo.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def pardot(self) -> Optional['outputs.ConnectorProfilePardotConnectorProfileProperties']:
        """
        The connector-specific properties required by Salesforce Pardot.
        """
        return pulumi.get(self, "pardot")

    @property
    @pulumi.getter
    def redshift(self) -> Optional['outputs.ConnectorProfileRedshiftConnectorProfileProperties']:
        """
        The connector-specific properties required by Amazon Redshift.
        """
        return pulumi.get(self, "redshift")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['outputs.ConnectorProfileSalesforceConnectorProfileProperties']:
        """
        The connector-specific properties required by Salesforce.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="sapoData")
    def sapo_data(self) -> Optional['outputs.ConnectorProfileSapoDataConnectorProfileProperties']:
        """
        The connector-specific profile properties required when using SAPOData.
        """
        return pulumi.get(self, "sapo_data")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['outputs.ConnectorProfileServiceNowConnectorProfileProperties']:
        """
        The connector-specific properties required by serviceNow.
        """
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def slack(self) -> Optional['outputs.ConnectorProfileSlackConnectorProfileProperties']:
        """
        The connector-specific properties required by Slack.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def snowflake(self) -> Optional['outputs.ConnectorProfileSnowflakeConnectorProfileProperties']:
        """
        The connector-specific properties required by Snowflake.
        """
        return pulumi.get(self, "snowflake")

    @property
    @pulumi.getter
    def veeva(self) -> Optional['outputs.ConnectorProfileVeevaConnectorProfileProperties']:
        """
        The connector-specific properties required by Veeva.
        """
        return pulumi.get(self, "veeva")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['outputs.ConnectorProfileZendeskConnectorProfileProperties']:
        """
        The connector-specific properties required by Zendesk.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class ConnectorProfileRedshiftConnectorProfileCredentials(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str password: The password that corresponds to the username.
        :param str username: The name of the user.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password that corresponds to the username.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectorProfileRedshiftConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "clusterIdentifier":
            suggest = "cluster_identifier"
        elif key == "dataApiRoleArn":
            suggest = "data_api_role_arn"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "databaseUrl":
            suggest = "database_url"
        elif key == "isRedshiftServerless":
            suggest = "is_redshift_serverless"
        elif key == "workgroupName":
            suggest = "workgroup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileRedshiftConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileRedshiftConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileRedshiftConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 role_arn: str,
                 bucket_prefix: Optional[str] = None,
                 cluster_identifier: Optional[str] = None,
                 data_api_role_arn: Optional[str] = None,
                 database_name: Optional[str] = None,
                 database_url: Optional[str] = None,
                 is_redshift_serverless: Optional[bool] = None,
                 workgroup_name: Optional[str] = None):
        """
        :param str bucket_name: The name of the Amazon S3 bucket associated with Redshift.
        :param str role_arn: The Amazon Resource Name (ARN) of the IAM role.
        :param str bucket_prefix: The object key for the destination bucket in which Amazon AppFlow will place the ﬁles.
        :param str cluster_identifier: The unique identifier of the Amazon Redshift cluster.
        :param str data_api_role_arn: The Amazon Resource Name (ARN) of the IAM role that grants Amazon AppFlow access to the data through the Amazon Redshift Data API.
        :param str database_name: The name of the Amazon Redshift database that will store the transferred data.
        :param str database_url: The JDBC URL of the Amazon Redshift cluster.
        :param bool is_redshift_serverless: If Amazon AppFlow will connect to Amazon Redshift Serverless or Amazon Redshift cluster.
        :param str workgroup_name: The name of the Amazon Redshift serverless workgroup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if data_api_role_arn is not None:
            pulumi.set(__self__, "data_api_role_arn", data_api_role_arn)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_url is not None:
            pulumi.set(__self__, "database_url", database_url)
        if is_redshift_serverless is not None:
            pulumi.set(__self__, "is_redshift_serverless", is_redshift_serverless)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the Amazon S3 bucket associated with Redshift.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The object key for the destination bucket in which Amazon AppFlow will place the ﬁles.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[str]:
        """
        The unique identifier of the Amazon Redshift cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="dataApiRoleArn")
    def data_api_role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that grants Amazon AppFlow access to the data through the Amazon Redshift Data API.
        """
        return pulumi.get(self, "data_api_role_arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The name of the Amazon Redshift database that will store the transferred data.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="databaseUrl")
    def database_url(self) -> Optional[str]:
        """
        The JDBC URL of the Amazon Redshift cluster.
        """
        return pulumi.get(self, "database_url")

    @property
    @pulumi.getter(name="isRedshiftServerless")
    def is_redshift_serverless(self) -> Optional[bool]:
        """
        If Amazon AppFlow will connect to Amazon Redshift Serverless or Amazon Redshift cluster.
        """
        return pulumi.get(self, "is_redshift_serverless")

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[str]:
        """
        The name of the Amazon Redshift serverless workgroup
        """
        return pulumi.get(self, "workgroup_name")


@pulumi.output_type
class ConnectorProfileSalesforceConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "clientCredentialsArn":
            suggest = "client_credentials_arn"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"
        elif key == "jwtToken":
            suggest = "jwt_token"
        elif key == "oAuth2GrantType":
            suggest = "o_auth2_grant_type"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSalesforceConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSalesforceConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSalesforceConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[str] = None,
                 client_credentials_arn: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None,
                 jwt_token: Optional[str] = None,
                 o_auth2_grant_type: Optional['ConnectorProfileOAuth2GrantType'] = None,
                 refresh_token: Optional[str] = None):
        """
        :param str access_token: The credentials used to access protected resources.
        :param str client_credentials_arn: The client credentials to fetch access token and refresh token.
        :param 'ConnectorProfileConnectorOAuthRequest' connector_o_auth_request: The oauth needed to request security tokens from the connector endpoint.
        :param str jwt_token: The credentials used to access your Salesforce records
        :param 'ConnectorProfileOAuth2GrantType' o_auth2_grant_type: The grant types to fetch an access token
        :param str refresh_token: The credentials used to acquire new access tokens.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if client_credentials_arn is not None:
            pulumi.set(__self__, "client_credentials_arn", client_credentials_arn)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)
        if jwt_token is not None:
            pulumi.set(__self__, "jwt_token", jwt_token)
        if o_auth2_grant_type is not None:
            pulumi.set(__self__, "o_auth2_grant_type", o_auth2_grant_type)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The credentials used to access protected resources.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="clientCredentialsArn")
    def client_credentials_arn(self) -> Optional[str]:
        """
        The client credentials to fetch access token and refresh token.
        """
        return pulumi.get(self, "client_credentials_arn")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        """
        The oauth needed to request security tokens from the connector endpoint.
        """
        return pulumi.get(self, "connector_o_auth_request")

    @property
    @pulumi.getter(name="jwtToken")
    def jwt_token(self) -> Optional[str]:
        """
        The credentials used to access your Salesforce records
        """
        return pulumi.get(self, "jwt_token")

    @property
    @pulumi.getter(name="oAuth2GrantType")
    def o_auth2_grant_type(self) -> Optional['ConnectorProfileOAuth2GrantType']:
        """
        The grant types to fetch an access token
        """
        return pulumi.get(self, "o_auth2_grant_type")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        The credentials used to acquire new access tokens.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ConnectorProfileSalesforceConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"
        elif key == "isSandboxEnvironment":
            suggest = "is_sandbox_environment"
        elif key == "usePrivateLinkForMetadataAndAuthorization":
            suggest = "use_private_link_for_metadata_and_authorization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSalesforceConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSalesforceConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSalesforceConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: Optional[str] = None,
                 is_sandbox_environment: Optional[bool] = None,
                 use_private_link_for_metadata_and_authorization: Optional[bool] = None):
        """
        :param str instance_url: The location of the Salesforce resource
        :param bool is_sandbox_environment: Indicates whether the connector profile applies to a sandbox or production environment
        :param bool use_private_link_for_metadata_and_authorization: Indicates whether to make Metadata And Authorization calls over Pivate Network
        """
        if instance_url is not None:
            pulumi.set(__self__, "instance_url", instance_url)
        if is_sandbox_environment is not None:
            pulumi.set(__self__, "is_sandbox_environment", is_sandbox_environment)
        if use_private_link_for_metadata_and_authorization is not None:
            pulumi.set(__self__, "use_private_link_for_metadata_and_authorization", use_private_link_for_metadata_and_authorization)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> Optional[str]:
        """
        The location of the Salesforce resource
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isSandboxEnvironment")
    def is_sandbox_environment(self) -> Optional[bool]:
        """
        Indicates whether the connector profile applies to a sandbox or production environment
        """
        return pulumi.get(self, "is_sandbox_environment")

    @property
    @pulumi.getter(name="usePrivateLinkForMetadataAndAuthorization")
    def use_private_link_for_metadata_and_authorization(self) -> Optional[bool]:
        """
        Indicates whether to make Metadata And Authorization calls over Pivate Network
        """
        return pulumi.get(self, "use_private_link_for_metadata_and_authorization")


@pulumi.output_type
class ConnectorProfileSapoDataConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuthCredentials":
            suggest = "basic_auth_credentials"
        elif key == "oAuthCredentials":
            suggest = "o_auth_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSapoDataConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSapoDataConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSapoDataConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth_credentials: Optional['outputs.ConnectorProfileBasicAuthCredentials'] = None,
                 o_auth_credentials: Optional['outputs.ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties'] = None):
        """
        :param 'ConnectorProfileBasicAuthCredentials' basic_auth_credentials: The SAPOData basic authentication credentials.
        :param 'ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties' o_auth_credentials: The SAPOData OAuth type authentication credentials.
        """
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if o_auth_credentials is not None:
            pulumi.set(__self__, "o_auth_credentials", o_auth_credentials)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional['outputs.ConnectorProfileBasicAuthCredentials']:
        """
        The SAPOData basic authentication credentials.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @property
    @pulumi.getter(name="oAuthCredentials")
    def o_auth_credentials(self) -> Optional['outputs.ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties']:
        """
        The SAPOData OAuth type authentication credentials.
        """
        return pulumi.get(self, "o_auth_credentials")


@pulumi.output_type
class ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties(dict):
    """
    The SAPOData OAuth type authentication credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSapoDataConnectorProfileCredentialsOAuthCredentialsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None,
                 refresh_token: Optional[str] = None):
        """
        The SAPOData OAuth type authentication credentials.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        return pulumi.get(self, "connector_o_auth_request")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ConnectorProfileSapoDataConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationHostUrl":
            suggest = "application_host_url"
        elif key == "applicationServicePath":
            suggest = "application_service_path"
        elif key == "clientNumber":
            suggest = "client_number"
        elif key == "disableSso":
            suggest = "disable_sso"
        elif key == "logonLanguage":
            suggest = "logon_language"
        elif key == "oAuthProperties":
            suggest = "o_auth_properties"
        elif key == "portNumber":
            suggest = "port_number"
        elif key == "privateLinkServiceName":
            suggest = "private_link_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSapoDataConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSapoDataConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSapoDataConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_host_url: Optional[str] = None,
                 application_service_path: Optional[str] = None,
                 client_number: Optional[str] = None,
                 disable_sso: Optional[bool] = None,
                 logon_language: Optional[str] = None,
                 o_auth_properties: Optional['outputs.ConnectorProfileOAuthProperties'] = None,
                 port_number: Optional[int] = None,
                 private_link_service_name: Optional[str] = None):
        """
        :param str application_host_url: The location of the SAPOData resource.
        :param str application_service_path: The application path to catalog service.
        :param str client_number: The client number for the client creating the connection.
        :param bool disable_sso: If you set this parameter to true, Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
        :param str logon_language: The logon language of SAPOData instance.
        :param 'ConnectorProfileOAuthProperties' o_auth_properties: The SAPOData OAuth properties required for OAuth type authentication.
        :param int port_number: The port number of the SAPOData instance.
        :param str private_link_service_name: The SAPOData Private Link service name to be used for private data transfers.
        """
        if application_host_url is not None:
            pulumi.set(__self__, "application_host_url", application_host_url)
        if application_service_path is not None:
            pulumi.set(__self__, "application_service_path", application_service_path)
        if client_number is not None:
            pulumi.set(__self__, "client_number", client_number)
        if disable_sso is not None:
            pulumi.set(__self__, "disable_sso", disable_sso)
        if logon_language is not None:
            pulumi.set(__self__, "logon_language", logon_language)
        if o_auth_properties is not None:
            pulumi.set(__self__, "o_auth_properties", o_auth_properties)
        if port_number is not None:
            pulumi.set(__self__, "port_number", port_number)
        if private_link_service_name is not None:
            pulumi.set(__self__, "private_link_service_name", private_link_service_name)

    @property
    @pulumi.getter(name="applicationHostUrl")
    def application_host_url(self) -> Optional[str]:
        """
        The location of the SAPOData resource.
        """
        return pulumi.get(self, "application_host_url")

    @property
    @pulumi.getter(name="applicationServicePath")
    def application_service_path(self) -> Optional[str]:
        """
        The application path to catalog service.
        """
        return pulumi.get(self, "application_service_path")

    @property
    @pulumi.getter(name="clientNumber")
    def client_number(self) -> Optional[str]:
        """
        The client number for the client creating the connection.
        """
        return pulumi.get(self, "client_number")

    @property
    @pulumi.getter(name="disableSso")
    def disable_sso(self) -> Optional[bool]:
        """
        If you set this parameter to true, Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
        """
        return pulumi.get(self, "disable_sso")

    @property
    @pulumi.getter(name="logonLanguage")
    def logon_language(self) -> Optional[str]:
        """
        The logon language of SAPOData instance.
        """
        return pulumi.get(self, "logon_language")

    @property
    @pulumi.getter(name="oAuthProperties")
    def o_auth_properties(self) -> Optional['outputs.ConnectorProfileOAuthProperties']:
        """
        The SAPOData OAuth properties required for OAuth type authentication.
        """
        return pulumi.get(self, "o_auth_properties")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> Optional[int]:
        """
        The port number of the SAPOData instance.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="privateLinkServiceName")
    def private_link_service_name(self) -> Optional[str]:
        """
        The SAPOData Private Link service name to be used for private data transfers.
        """
        return pulumi.get(self, "private_link_service_name")


@pulumi.output_type
class ConnectorProfileServiceNowConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oAuth2Credentials":
            suggest = "o_auth2_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileServiceNowConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileServiceNowConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileServiceNowConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_auth2_credentials: Optional['outputs.ConnectorProfileOAuth2Credentials'] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param 'ConnectorProfileOAuth2Credentials' o_auth2_credentials: The OAuth 2.0 credentials required to authenticate the user.
        :param str password: The password that corresponds to the username.
        :param str username: The name of the user.
        """
        if o_auth2_credentials is not None:
            pulumi.set(__self__, "o_auth2_credentials", o_auth2_credentials)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="oAuth2Credentials")
    def o_auth2_credentials(self) -> Optional['outputs.ConnectorProfileOAuth2Credentials']:
        """
        The OAuth 2.0 credentials required to authenticate the user.
        """
        return pulumi.get(self, "o_auth2_credentials")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password that corresponds to the username.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectorProfileServiceNowConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileServiceNowConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileServiceNowConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileServiceNowConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the ServiceNow resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the ServiceNow resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileSingularConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSingularConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSingularConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSingularConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str):
        """
        :param str api_key: A unique alphanumeric identiﬁer used to authenticate a user, developer, or calling program to your API.
        """
        pulumi.set(__self__, "api_key", api_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        A unique alphanumeric identiﬁer used to authenticate a user, developer, or calling program to your API.
        """
        return pulumi.get(self, "api_key")


@pulumi.output_type
class ConnectorProfileSlackConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSlackConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSlackConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSlackConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str,
                 access_token: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None):
        """
        :param str client_id: The identiﬁer for the desired client.
        :param str client_secret: The client secret used by the oauth client to authenticate to the authorization server.
        :param str access_token: The credentials used to access protected resources.
        :param 'ConnectorProfileConnectorOAuthRequest' connector_o_auth_request: The oauth needed to request security tokens from the connector endpoint.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The identiﬁer for the desired client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret used by the oauth client to authenticate to the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The credentials used to access protected resources.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        """
        The oauth needed to request security tokens from the connector endpoint.
        """
        return pulumi.get(self, "connector_o_auth_request")


@pulumi.output_type
class ConnectorProfileSlackConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSlackConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSlackConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSlackConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the Slack resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the Slack resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileSnowflakeConnectorProfileCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password that corresponds to the username.
        :param str username: The name of the user.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password that corresponds to the username.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectorProfileSnowflakeConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "privateLinkServiceName":
            suggest = "private_link_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileSnowflakeConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileSnowflakeConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileSnowflakeConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 stage: str,
                 warehouse: str,
                 account_name: Optional[str] = None,
                 bucket_prefix: Optional[str] = None,
                 private_link_service_name: Optional[str] = None,
                 region: Optional[str] = None):
        """
        :param str bucket_name: The name of the Amazon S3 bucket associated with Snowﬂake.
        :param str stage: The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the
               Snowﬂake account. This is written in the following format: < Database>< Schema><Stage Name>.
        :param str warehouse: The name of the Snowﬂake warehouse.
        :param str account_name: The name of the account.
        :param str bucket_prefix: The bucket prefix that refers to the Amazon S3 bucket associated with Snowﬂake.
        :param str private_link_service_name: The Snowﬂake Private Link service name to be used for private data transfers.
        :param str region: The region of the Snowﬂake account.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "warehouse", warehouse)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if private_link_service_name is not None:
            pulumi.set(__self__, "private_link_service_name", private_link_service_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the Amazon S3 bucket associated with Snowﬂake.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def stage(self) -> str:
        """
        The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the
        Snowﬂake account. This is written in the following format: < Database>< Schema><Stage Name>.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def warehouse(self) -> str:
        """
        The name of the Snowﬂake warehouse.
        """
        return pulumi.get(self, "warehouse")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The name of the account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The bucket prefix that refers to the Amazon S3 bucket associated with Snowﬂake.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="privateLinkServiceName")
    def private_link_service_name(self) -> Optional[str]:
        """
        The Snowﬂake Private Link service name to be used for private data transfers.
        """
        return pulumi.get(self, "private_link_service_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region of the Snowﬂake account.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ConnectorProfileTrendmicroConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiSecretKey":
            suggest = "api_secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileTrendmicroConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileTrendmicroConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileTrendmicroConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_secret_key: str):
        """
        :param str api_secret_key: The Secret Access Key portion of the credentials.
        """
        pulumi.set(__self__, "api_secret_key", api_secret_key)

    @property
    @pulumi.getter(name="apiSecretKey")
    def api_secret_key(self) -> str:
        """
        The Secret Access Key portion of the credentials.
        """
        return pulumi.get(self, "api_secret_key")


@pulumi.output_type
class ConnectorProfileVeevaConnectorProfileCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password that corresponds to the username.
        :param str username: The name of the user.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password that corresponds to the username.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectorProfileVeevaConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileVeevaConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileVeevaConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileVeevaConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the Veeva resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the Veeva resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProfileZendeskConnectorProfileCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "connectorOAuthRequest":
            suggest = "connector_o_auth_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileZendeskConnectorProfileCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileZendeskConnectorProfileCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileZendeskConnectorProfileCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str,
                 access_token: Optional[str] = None,
                 connector_o_auth_request: Optional['outputs.ConnectorProfileConnectorOAuthRequest'] = None):
        """
        :param str client_id: The identiﬁer for the desired client.
        :param str client_secret: The client secret used by the oauth client to authenticate to the authorization server.
        :param str access_token: The credentials used to access protected resources.
        :param 'ConnectorProfileConnectorOAuthRequest' connector_o_auth_request: The oauth needed to request security tokens from the connector endpoint.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if connector_o_auth_request is not None:
            pulumi.set(__self__, "connector_o_auth_request", connector_o_auth_request)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The identiﬁer for the desired client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret used by the oauth client to authenticate to the authorization server.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The credentials used to access protected resources.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="connectorOAuthRequest")
    def connector_o_auth_request(self) -> Optional['outputs.ConnectorProfileConnectorOAuthRequest']:
        """
        The oauth needed to request security tokens from the connector endpoint.
        """
        return pulumi.get(self, "connector_o_auth_request")


@pulumi.output_type
class ConnectorProfileZendeskConnectorProfileProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceUrl":
            suggest = "instance_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProfileZendeskConnectorProfileProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProfileZendeskConnectorProfileProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProfileZendeskConnectorProfileProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_url: str):
        """
        :param str instance_url: The location of the Zendesk resource
        """
        pulumi.set(__self__, "instance_url", instance_url)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> str:
        """
        The location of the Zendesk resource
        """
        return pulumi.get(self, "instance_url")


@pulumi.output_type
class ConnectorProvisioningConfig(dict):
    """
    Contains information about the configuration of the connector being registered.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambda":
            suggest = "lambda_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorProvisioningConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorProvisioningConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorProvisioningConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_: Optional['outputs.ConnectorLambdaConnectorProvisioningConfig'] = None):
        """
        Contains information about the configuration of the connector being registered.
        :param 'ConnectorLambdaConnectorProvisioningConfig' lambda_: Contains information about the configuration of the lambda which is being registered as the connector.
        """
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional['outputs.ConnectorLambdaConnectorProvisioningConfig']:
        """
        Contains information about the configuration of the lambda which is being registered as the connector.
        """
        return pulumi.get(self, "lambda_")


@pulumi.output_type
class FlowAggregationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationType":
            suggest = "aggregation_type"
        elif key == "targetFileSize":
            suggest = "target_file_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowAggregationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowAggregationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowAggregationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_type: Optional['FlowAggregationType'] = None,
                 target_file_size: Optional[int] = None):
        """
        :param 'FlowAggregationType' aggregation_type: Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
        :param int target_file_size: The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination. For each file, Amazon AppFlow attempts to achieve the size that you specify. The actual file sizes might differ from this target based on the number and size of the records that each file contains.
        """
        if aggregation_type is not None:
            pulumi.set(__self__, "aggregation_type", aggregation_type)
        if target_file_size is not None:
            pulumi.set(__self__, "target_file_size", target_file_size)

    @property
    @pulumi.getter(name="aggregationType")
    def aggregation_type(self) -> Optional['FlowAggregationType']:
        """
        Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
        """
        return pulumi.get(self, "aggregation_type")

    @property
    @pulumi.getter(name="targetFileSize")
    def target_file_size(self) -> Optional[int]:
        """
        The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination. For each file, Amazon AppFlow attempts to achieve the size that you specify. The actual file sizes might differ from this target based on the number and size of the records that each file contains.
        """
        return pulumi.get(self, "target_file_size")


@pulumi.output_type
class FlowAmplitudeSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Amplitude flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Amplitude flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowConnectorOperator(dict):
    """
    Operation to be performed on provided source fields
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConnector":
            suggest = "custom_connector"
        elif key == "googleAnalytics":
            suggest = "google_analytics"
        elif key == "inforNexus":
            suggest = "infor_nexus"
        elif key == "sapoData":
            suggest = "sapo_data"
        elif key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowConnectorOperator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowConnectorOperator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowConnectorOperator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amplitude: Optional['FlowAmplitudeConnectorOperator'] = None,
                 custom_connector: Optional['FlowOperator'] = None,
                 datadog: Optional['FlowDatadogConnectorOperator'] = None,
                 dynatrace: Optional['FlowDynatraceConnectorOperator'] = None,
                 google_analytics: Optional['FlowGoogleAnalyticsConnectorOperator'] = None,
                 infor_nexus: Optional['FlowInforNexusConnectorOperator'] = None,
                 marketo: Optional['FlowMarketoConnectorOperator'] = None,
                 pardot: Optional['FlowPardotConnectorOperator'] = None,
                 s3: Optional['FlowS3ConnectorOperator'] = None,
                 salesforce: Optional['FlowSalesforceConnectorOperator'] = None,
                 sapo_data: Optional['FlowSapoDataConnectorOperator'] = None,
                 service_now: Optional['FlowServiceNowConnectorOperator'] = None,
                 singular: Optional['FlowSingularConnectorOperator'] = None,
                 slack: Optional['FlowSlackConnectorOperator'] = None,
                 trendmicro: Optional['FlowTrendmicroConnectorOperator'] = None,
                 veeva: Optional['FlowVeevaConnectorOperator'] = None,
                 zendesk: Optional['FlowZendeskConnectorOperator'] = None):
        """
        Operation to be performed on provided source fields
        :param 'FlowAmplitudeConnectorOperator' amplitude: The operation to be performed on the provided Amplitude source fields.
        :param 'FlowOperator' custom_connector: Operators supported by the custom connector.
        :param 'FlowDatadogConnectorOperator' datadog: The operation to be performed on the provided Datadog source fields.
        :param 'FlowDynatraceConnectorOperator' dynatrace: The operation to be performed on the provided Dynatrace source fields.
        :param 'FlowGoogleAnalyticsConnectorOperator' google_analytics: The operation to be performed on the provided Google Analytics source fields.
        :param 'FlowInforNexusConnectorOperator' infor_nexus: The operation to be performed on the provided Infor Nexus source fields.
        :param 'FlowMarketoConnectorOperator' marketo: The operation to be performed on the provided Marketo source fields.
        :param 'FlowPardotConnectorOperator' pardot: The operation to be performed on the provided Salesforce Pardot source fields.
        :param 'FlowS3ConnectorOperator' s3: The operation to be performed on the provided Amazon S3 source fields.
        :param 'FlowSalesforceConnectorOperator' salesforce: The operation to be performed on the provided Salesforce source fields.
        :param 'FlowSapoDataConnectorOperator' sapo_data: The operation to be performed on the provided SAPOData source fields.
        :param 'FlowServiceNowConnectorOperator' service_now: The operation to be performed on the provided ServiceNow source fields.
        :param 'FlowSingularConnectorOperator' singular: The operation to be performed on the provided Singular source fields.
        :param 'FlowSlackConnectorOperator' slack: The operation to be performed on the provided Slack source fields.
        :param 'FlowTrendmicroConnectorOperator' trendmicro: The operation to be performed on the provided Trend Micro source fields.
        :param 'FlowVeevaConnectorOperator' veeva: The operation to be performed on the provided Veeva source fields.
        :param 'FlowZendeskConnectorOperator' zendesk: The operation to be performed on the provided Zendesk source fields.
        """
        if amplitude is not None:
            pulumi.set(__self__, "amplitude", amplitude)
        if custom_connector is not None:
            pulumi.set(__self__, "custom_connector", custom_connector)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if dynatrace is not None:
            pulumi.set(__self__, "dynatrace", dynatrace)
        if google_analytics is not None:
            pulumi.set(__self__, "google_analytics", google_analytics)
        if infor_nexus is not None:
            pulumi.set(__self__, "infor_nexus", infor_nexus)
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if pardot is not None:
            pulumi.set(__self__, "pardot", pardot)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if sapo_data is not None:
            pulumi.set(__self__, "sapo_data", sapo_data)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if trendmicro is not None:
            pulumi.set(__self__, "trendmicro", trendmicro)
        if veeva is not None:
            pulumi.set(__self__, "veeva", veeva)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def amplitude(self) -> Optional['FlowAmplitudeConnectorOperator']:
        """
        The operation to be performed on the provided Amplitude source fields.
        """
        return pulumi.get(self, "amplitude")

    @property
    @pulumi.getter(name="customConnector")
    def custom_connector(self) -> Optional['FlowOperator']:
        """
        Operators supported by the custom connector.
        """
        return pulumi.get(self, "custom_connector")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['FlowDatadogConnectorOperator']:
        """
        The operation to be performed on the provided Datadog source fields.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def dynatrace(self) -> Optional['FlowDynatraceConnectorOperator']:
        """
        The operation to be performed on the provided Dynatrace source fields.
        """
        return pulumi.get(self, "dynatrace")

    @property
    @pulumi.getter(name="googleAnalytics")
    def google_analytics(self) -> Optional['FlowGoogleAnalyticsConnectorOperator']:
        """
        The operation to be performed on the provided Google Analytics source fields.
        """
        return pulumi.get(self, "google_analytics")

    @property
    @pulumi.getter(name="inforNexus")
    def infor_nexus(self) -> Optional['FlowInforNexusConnectorOperator']:
        """
        The operation to be performed on the provided Infor Nexus source fields.
        """
        return pulumi.get(self, "infor_nexus")

    @property
    @pulumi.getter
    def marketo(self) -> Optional['FlowMarketoConnectorOperator']:
        """
        The operation to be performed on the provided Marketo source fields.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def pardot(self) -> Optional['FlowPardotConnectorOperator']:
        """
        The operation to be performed on the provided Salesforce Pardot source fields.
        """
        return pulumi.get(self, "pardot")

    @property
    @pulumi.getter
    def s3(self) -> Optional['FlowS3ConnectorOperator']:
        """
        The operation to be performed on the provided Amazon S3 source fields.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['FlowSalesforceConnectorOperator']:
        """
        The operation to be performed on the provided Salesforce source fields.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="sapoData")
    def sapo_data(self) -> Optional['FlowSapoDataConnectorOperator']:
        """
        The operation to be performed on the provided SAPOData source fields.
        """
        return pulumi.get(self, "sapo_data")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['FlowServiceNowConnectorOperator']:
        """
        The operation to be performed on the provided ServiceNow source fields.
        """
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def singular(self) -> Optional['FlowSingularConnectorOperator']:
        """
        The operation to be performed on the provided Singular source fields.
        """
        return pulumi.get(self, "singular")

    @property
    @pulumi.getter
    def slack(self) -> Optional['FlowSlackConnectorOperator']:
        """
        The operation to be performed on the provided Slack source fields.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def trendmicro(self) -> Optional['FlowTrendmicroConnectorOperator']:
        """
        The operation to be performed on the provided Trend Micro source fields.
        """
        return pulumi.get(self, "trendmicro")

    @property
    @pulumi.getter
    def veeva(self) -> Optional['FlowVeevaConnectorOperator']:
        """
        The operation to be performed on the provided Veeva source fields.
        """
        return pulumi.get(self, "veeva")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['FlowZendeskConnectorOperator']:
        """
        The operation to be performed on the provided Zendesk source fields.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class FlowCustomConnectorDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityName":
            suggest = "entity_name"
        elif key == "customProperties":
            suggest = "custom_properties"
        elif key == "errorHandlingConfig":
            suggest = "error_handling_config"
        elif key == "idFieldNames":
            suggest = "id_field_names"
        elif key == "writeOperationType":
            suggest = "write_operation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowCustomConnectorDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowCustomConnectorDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowCustomConnectorDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_name: str,
                 custom_properties: Optional[Mapping[str, str]] = None,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None,
                 id_field_names: Optional[Sequence[str]] = None,
                 write_operation_type: Optional['FlowWriteOperationType'] = None):
        """
        :param str entity_name: The entity specified in the custom connector as a destination in the flow.
        :param Mapping[str, str] custom_properties: The custom properties that are specific to the connector when it's used as a destination in the flow.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
        :param Sequence[str] id_field_names: List of fields used as ID when performing a write operation.
        :param 'FlowWriteOperationType' write_operation_type: Specifies the type of write operation to be performed in the custom connector when it's used as destination.
        """
        pulumi.set(__self__, "entity_name", entity_name)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)
        if id_field_names is not None:
            pulumi.set(__self__, "id_field_names", id_field_names)
        if write_operation_type is not None:
            pulumi.set(__self__, "write_operation_type", write_operation_type)

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> str:
        """
        The entity specified in the custom connector as a destination in the flow.
        """
        return pulumi.get(self, "entity_name")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[Mapping[str, str]]:
        """
        The custom properties that are specific to the connector when it's used as a destination in the flow.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
        """
        return pulumi.get(self, "error_handling_config")

    @property
    @pulumi.getter(name="idFieldNames")
    def id_field_names(self) -> Optional[Sequence[str]]:
        """
        List of fields used as ID when performing a write operation.
        """
        return pulumi.get(self, "id_field_names")

    @property
    @pulumi.getter(name="writeOperationType")
    def write_operation_type(self) -> Optional['FlowWriteOperationType']:
        """
        Specifies the type of write operation to be performed in the custom connector when it's used as destination.
        """
        return pulumi.get(self, "write_operation_type")


@pulumi.output_type
class FlowCustomConnectorSourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityName":
            suggest = "entity_name"
        elif key == "customProperties":
            suggest = "custom_properties"
        elif key == "dataTransferApi":
            suggest = "data_transfer_api"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowCustomConnectorSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowCustomConnectorSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowCustomConnectorSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_name: str,
                 custom_properties: Optional[Mapping[str, str]] = None,
                 data_transfer_api: Optional['outputs.FlowCustomConnectorSourcePropertiesDataTransferApiProperties'] = None):
        """
        :param str entity_name: The entity specified in the custom connector as a source in the flow.
        :param Mapping[str, str] custom_properties: Custom properties that are required to use the custom connector as a source.
        :param 'FlowCustomConnectorSourcePropertiesDataTransferApiProperties' data_transfer_api: The API of the connector application that Amazon AppFlow uses to transfer your data.
        """
        pulumi.set(__self__, "entity_name", entity_name)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if data_transfer_api is not None:
            pulumi.set(__self__, "data_transfer_api", data_transfer_api)

    @property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> str:
        """
        The entity specified in the custom connector as a source in the flow.
        """
        return pulumi.get(self, "entity_name")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[Mapping[str, str]]:
        """
        Custom properties that are required to use the custom connector as a source.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter(name="dataTransferApi")
    def data_transfer_api(self) -> Optional['outputs.FlowCustomConnectorSourcePropertiesDataTransferApiProperties']:
        """
        The API of the connector application that Amazon AppFlow uses to transfer your data.
        """
        return pulumi.get(self, "data_transfer_api")


@pulumi.output_type
class FlowCustomConnectorSourcePropertiesDataTransferApiProperties(dict):
    """
    The API of the connector application that Amazon AppFlow uses to transfer your data.
    """
    def __init__(__self__, *,
                 name: str,
                 type: 'FlowCustomConnectorSourcePropertiesDataTransferApiPropertiesType'):
        """
        The API of the connector application that Amazon AppFlow uses to transfer your data.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'FlowCustomConnectorSourcePropertiesDataTransferApiPropertiesType':
        return pulumi.get(self, "type")


@pulumi.output_type
class FlowDatadogSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Datadog flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Datadog flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowDestinationConnectorProperties(dict):
    """
    Destination connector details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConnector":
            suggest = "custom_connector"
        elif key == "eventBridge":
            suggest = "event_bridge"
        elif key == "lookoutMetrics":
            suggest = "lookout_metrics"
        elif key == "sapoData":
            suggest = "sapo_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowDestinationConnectorProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowDestinationConnectorProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowDestinationConnectorProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_connector: Optional['outputs.FlowCustomConnectorDestinationProperties'] = None,
                 event_bridge: Optional['outputs.FlowEventBridgeDestinationProperties'] = None,
                 lookout_metrics: Optional['outputs.FlowLookoutMetricsDestinationProperties'] = None,
                 marketo: Optional['outputs.FlowMarketoDestinationProperties'] = None,
                 redshift: Optional['outputs.FlowRedshiftDestinationProperties'] = None,
                 s3: Optional['outputs.FlowS3DestinationProperties'] = None,
                 salesforce: Optional['outputs.FlowSalesforceDestinationProperties'] = None,
                 sapo_data: Optional['outputs.FlowSapoDataDestinationProperties'] = None,
                 snowflake: Optional['outputs.FlowSnowflakeDestinationProperties'] = None,
                 upsolver: Optional['outputs.FlowUpsolverDestinationProperties'] = None,
                 zendesk: Optional['outputs.FlowZendeskDestinationProperties'] = None):
        """
        Destination connector details
        :param 'FlowCustomConnectorDestinationProperties' custom_connector: The properties that are required to query the custom Connector.
        :param 'FlowEventBridgeDestinationProperties' event_bridge: The properties required to query Amazon EventBridge.
        :param 'FlowLookoutMetricsDestinationProperties' lookout_metrics: The properties required to query Amazon Lookout for Metrics.
        :param 'FlowMarketoDestinationProperties' marketo: The properties required to query Marketo.
        :param 'FlowRedshiftDestinationProperties' redshift: The properties required to query Amazon Redshift.
        :param 'FlowS3DestinationProperties' s3: The properties required to query Amazon S3.
        :param 'FlowSalesforceDestinationProperties' salesforce: The properties required to query Salesforce.
        :param 'FlowSapoDataDestinationProperties' sapo_data: The properties required to query SAPOData.
        :param 'FlowSnowflakeDestinationProperties' snowflake: The properties required to query Snowflake.
        :param 'FlowUpsolverDestinationProperties' upsolver: The properties required to query Upsolver.
        :param 'FlowZendeskDestinationProperties' zendesk: The properties required to query Zendesk.
        """
        if custom_connector is not None:
            pulumi.set(__self__, "custom_connector", custom_connector)
        if event_bridge is not None:
            pulumi.set(__self__, "event_bridge", event_bridge)
        if lookout_metrics is not None:
            pulumi.set(__self__, "lookout_metrics", lookout_metrics)
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if sapo_data is not None:
            pulumi.set(__self__, "sapo_data", sapo_data)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if upsolver is not None:
            pulumi.set(__self__, "upsolver", upsolver)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter(name="customConnector")
    def custom_connector(self) -> Optional['outputs.FlowCustomConnectorDestinationProperties']:
        """
        The properties that are required to query the custom Connector.
        """
        return pulumi.get(self, "custom_connector")

    @property
    @pulumi.getter(name="eventBridge")
    def event_bridge(self) -> Optional['outputs.FlowEventBridgeDestinationProperties']:
        """
        The properties required to query Amazon EventBridge.
        """
        return pulumi.get(self, "event_bridge")

    @property
    @pulumi.getter(name="lookoutMetrics")
    def lookout_metrics(self) -> Optional['outputs.FlowLookoutMetricsDestinationProperties']:
        """
        The properties required to query Amazon Lookout for Metrics.
        """
        return pulumi.get(self, "lookout_metrics")

    @property
    @pulumi.getter
    def marketo(self) -> Optional['outputs.FlowMarketoDestinationProperties']:
        """
        The properties required to query Marketo.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def redshift(self) -> Optional['outputs.FlowRedshiftDestinationProperties']:
        """
        The properties required to query Amazon Redshift.
        """
        return pulumi.get(self, "redshift")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.FlowS3DestinationProperties']:
        """
        The properties required to query Amazon S3.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['outputs.FlowSalesforceDestinationProperties']:
        """
        The properties required to query Salesforce.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="sapoData")
    def sapo_data(self) -> Optional['outputs.FlowSapoDataDestinationProperties']:
        """
        The properties required to query SAPOData.
        """
        return pulumi.get(self, "sapo_data")

    @property
    @pulumi.getter
    def snowflake(self) -> Optional['outputs.FlowSnowflakeDestinationProperties']:
        """
        The properties required to query Snowflake.
        """
        return pulumi.get(self, "snowflake")

    @property
    @pulumi.getter
    def upsolver(self) -> Optional['outputs.FlowUpsolverDestinationProperties']:
        """
        The properties required to query Upsolver.
        """
        return pulumi.get(self, "upsolver")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['outputs.FlowZendeskDestinationProperties']:
        """
        The properties required to query Zendesk.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class FlowDestinationFlowConfig(dict):
    """
    Configurations of destination connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "destinationConnectorProperties":
            suggest = "destination_connector_properties"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "connectorProfileName":
            suggest = "connector_profile_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowDestinationFlowConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowDestinationFlowConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowDestinationFlowConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: 'FlowConnectorType',
                 destination_connector_properties: 'outputs.FlowDestinationConnectorProperties',
                 api_version: Optional[str] = None,
                 connector_profile_name: Optional[str] = None):
        """
        Configurations of destination connector.
        :param 'FlowConnectorType' connector_type: Destination connector type
        :param 'FlowDestinationConnectorProperties' destination_connector_properties: Destination connector details
        :param str api_version: The API version that the destination connector uses.
        :param str connector_profile_name: Name of destination connector profile
        """
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "destination_connector_properties", destination_connector_properties)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if connector_profile_name is not None:
            pulumi.set(__self__, "connector_profile_name", connector_profile_name)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> 'FlowConnectorType':
        """
        Destination connector type
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="destinationConnectorProperties")
    def destination_connector_properties(self) -> 'outputs.FlowDestinationConnectorProperties':
        """
        Destination connector details
        """
        return pulumi.get(self, "destination_connector_properties")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        The API version that the destination connector uses.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="connectorProfileName")
    def connector_profile_name(self) -> Optional[str]:
        """
        Name of destination connector profile
        """
        return pulumi.get(self, "connector_profile_name")


@pulumi.output_type
class FlowDynatraceSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Dynatrace flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Dynatrace flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowErrorHandlingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "failOnFirstError":
            suggest = "fail_on_first_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowErrorHandlingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowErrorHandlingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowErrorHandlingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[str] = None,
                 bucket_prefix: Optional[str] = None,
                 fail_on_first_error: Optional[bool] = None):
        """
        :param str bucket_name: Specifies the name of the Amazon S3 bucket.
        :param str bucket_prefix: Specifies the Amazon S3 bucket prefix.
        :param bool fail_on_first_error: Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if fail_on_first_error is not None:
            pulumi.set(__self__, "fail_on_first_error", fail_on_first_error)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        Specifies the name of the Amazon S3 bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        Specifies the Amazon S3 bucket prefix.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="failOnFirstError")
    def fail_on_first_error(self) -> Optional[bool]:
        """
        Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
        """
        return pulumi.get(self, "fail_on_first_error")


@pulumi.output_type
class FlowEventBridgeDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorHandlingConfig":
            suggest = "error_handling_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowEventBridgeDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowEventBridgeDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowEventBridgeDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None):
        """
        :param str object: The object specified in the Amazon EventBridge flow destination.
        :param 'FlowErrorHandlingConfig' error_handling_config: The object specified in the Amplitude flow source.
        """
        pulumi.set(__self__, "object", object)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Amazon EventBridge flow destination.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The object specified in the Amplitude flow source.
        """
        return pulumi.get(self, "error_handling_config")


@pulumi.output_type
class FlowGlueDataCatalog(dict):
    """
    Trigger settings of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "tablePrefix":
            suggest = "table_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowGlueDataCatalog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowGlueDataCatalog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowGlueDataCatalog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 role_arn: str,
                 table_prefix: str):
        """
        Trigger settings of the flow.
        :param str database_name: A string containing the value for the tag
        :param str role_arn: A string containing the value for the tag
        :param str table_prefix: A string containing the value for the tag
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        A string containing the value for the tag
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        A string containing the value for the tag
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> str:
        """
        A string containing the value for the tag
        """
        return pulumi.get(self, "table_prefix")


@pulumi.output_type
class FlowGoogleAnalyticsSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Google Analytics flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Google Analytics flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowIncrementalPullConfig(dict):
    """
    Configuration for scheduled incremental data pull
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datetimeTypeFieldName":
            suggest = "datetime_type_field_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowIncrementalPullConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowIncrementalPullConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowIncrementalPullConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datetime_type_field_name: Optional[str] = None):
        """
        Configuration for scheduled incremental data pull
        :param str datetime_type_field_name: A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
        """
        if datetime_type_field_name is not None:
            pulumi.set(__self__, "datetime_type_field_name", datetime_type_field_name)

    @property
    @pulumi.getter(name="datetimeTypeFieldName")
    def datetime_type_field_name(self) -> Optional[str]:
        """
        A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
        """
        return pulumi.get(self, "datetime_type_field_name")


@pulumi.output_type
class FlowInforNexusSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Infor Nexus flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Infor Nexus flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowLookoutMetricsDestinationProperties(dict):
    def __init__(__self__, *,
                 object: Optional[str] = None):
        """
        :param str object: The object specified in the Amazon Lookout for Metrics flow destination.
        """
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object specified in the Amazon Lookout for Metrics flow destination.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowMarketoDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorHandlingConfig":
            suggest = "error_handling_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowMarketoDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowMarketoDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowMarketoDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None):
        """
        :param str object: The object specified in the Marketo flow destination.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        pulumi.set(__self__, "object", object)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Marketo flow destination.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        return pulumi.get(self, "error_handling_config")


@pulumi.output_type
class FlowMarketoSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Marketo flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Marketo flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowMetadataCatalogConfig(dict):
    """
    Configurations of metadata catalog of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "glueDataCatalog":
            suggest = "glue_data_catalog"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowMetadataCatalogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowMetadataCatalogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowMetadataCatalogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 glue_data_catalog: Optional['outputs.FlowGlueDataCatalog'] = None):
        """
        Configurations of metadata catalog of the flow.
        :param 'FlowGlueDataCatalog' glue_data_catalog: Configurations of glue data catalog of the flow.
        """
        if glue_data_catalog is not None:
            pulumi.set(__self__, "glue_data_catalog", glue_data_catalog)

    @property
    @pulumi.getter(name="glueDataCatalog")
    def glue_data_catalog(self) -> Optional['outputs.FlowGlueDataCatalog']:
        """
        Configurations of glue data catalog of the flow.
        """
        return pulumi.get(self, "glue_data_catalog")


@pulumi.output_type
class FlowPardotSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Salesforce Pardot flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Salesforce Pardot flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowPrefixConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathPrefixHierarchy":
            suggest = "path_prefix_hierarchy"
        elif key == "prefixFormat":
            suggest = "prefix_format"
        elif key == "prefixType":
            suggest = "prefix_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowPrefixConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowPrefixConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowPrefixConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_prefix_hierarchy: Optional[Sequence['FlowPathPrefix']] = None,
                 prefix_format: Optional['FlowPrefixFormat'] = None,
                 prefix_type: Optional['FlowPrefixType'] = None):
        """
        :param Sequence['FlowPathPrefix'] path_prefix_hierarchy: Specifies whether the destination file path includes either or both of the following elements:
               
               - **EXECUTION_ID** - The ID that Amazon AppFlow assigns to the flow run.
               - **SCHEMA_VERSION** - The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:
               
               - Source-to-destination field mappings
               - Field data types
               - Partition keys
        :param 'FlowPrefixFormat' prefix_format: Determines the level of granularity for the date and time that's included in the prefix.
        :param 'FlowPrefixType' prefix_type: Determines the format of the prefix, and whether it applies to the file name, file path, or both.
        """
        if path_prefix_hierarchy is not None:
            pulumi.set(__self__, "path_prefix_hierarchy", path_prefix_hierarchy)
        if prefix_format is not None:
            pulumi.set(__self__, "prefix_format", prefix_format)
        if prefix_type is not None:
            pulumi.set(__self__, "prefix_type", prefix_type)

    @property
    @pulumi.getter(name="pathPrefixHierarchy")
    def path_prefix_hierarchy(self) -> Optional[Sequence['FlowPathPrefix']]:
        """
        Specifies whether the destination file path includes either or both of the following elements:

        - **EXECUTION_ID** - The ID that Amazon AppFlow assigns to the flow run.
        - **SCHEMA_VERSION** - The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:

        - Source-to-destination field mappings
        - Field data types
        - Partition keys
        """
        return pulumi.get(self, "path_prefix_hierarchy")

    @property
    @pulumi.getter(name="prefixFormat")
    def prefix_format(self) -> Optional['FlowPrefixFormat']:
        """
        Determines the level of granularity for the date and time that's included in the prefix.
        """
        return pulumi.get(self, "prefix_format")

    @property
    @pulumi.getter(name="prefixType")
    def prefix_type(self) -> Optional['FlowPrefixType']:
        """
        Determines the format of the prefix, and whether it applies to the file name, file path, or both.
        """
        return pulumi.get(self, "prefix_type")


@pulumi.output_type
class FlowRedshiftDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intermediateBucketName":
            suggest = "intermediate_bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "errorHandlingConfig":
            suggest = "error_handling_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowRedshiftDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowRedshiftDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowRedshiftDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intermediate_bucket_name: str,
                 object: str,
                 bucket_prefix: Optional[str] = None,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None):
        """
        :param str intermediate_bucket_name: The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
        :param str object: The object specified in the Amazon Redshift flow destination.
        :param str bucket_prefix: The object key for the bucket in which Amazon AppFlow places the destination files.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        pulumi.set(__self__, "intermediate_bucket_name", intermediate_bucket_name)
        pulumi.set(__self__, "object", object)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)

    @property
    @pulumi.getter(name="intermediateBucketName")
    def intermediate_bucket_name(self) -> str:
        """
        The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
        """
        return pulumi.get(self, "intermediate_bucket_name")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Amazon Redshift flow destination.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The object key for the bucket in which Amazon AppFlow places the destination files.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        return pulumi.get(self, "error_handling_config")


@pulumi.output_type
class FlowS3DestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "s3OutputFormatConfig":
            suggest = "s3_output_format_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowS3DestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowS3DestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowS3DestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 bucket_prefix: Optional[str] = None,
                 s3_output_format_config: Optional['outputs.FlowS3OutputFormatConfig'] = None):
        """
        :param str bucket_name: The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
        :param str bucket_prefix: The object key for the destination bucket in which Amazon AppFlow places the files.
        :param 'FlowS3OutputFormatConfig' s3_output_format_config: The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if s3_output_format_config is not None:
            pulumi.set(__self__, "s3_output_format_config", s3_output_format_config)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The object key for the destination bucket in which Amazon AppFlow places the files.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="s3OutputFormatConfig")
    def s3_output_format_config(self) -> Optional['outputs.FlowS3OutputFormatConfig']:
        """
        The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
        """
        return pulumi.get(self, "s3_output_format_config")


@pulumi.output_type
class FlowS3InputFormatConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3InputFileType":
            suggest = "s3_input_file_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowS3InputFormatConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowS3InputFormatConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowS3InputFormatConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_input_file_type: Optional['FlowS3InputFormatConfigS3InputFileType'] = None):
        """
        :param 'FlowS3InputFormatConfigS3InputFileType' s3_input_file_type: The file type that Amazon AppFlow gets from your Amazon S3 bucket.
        """
        if s3_input_file_type is not None:
            pulumi.set(__self__, "s3_input_file_type", s3_input_file_type)

    @property
    @pulumi.getter(name="s3InputFileType")
    def s3_input_file_type(self) -> Optional['FlowS3InputFormatConfigS3InputFileType']:
        """
        The file type that Amazon AppFlow gets from your Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_input_file_type")


@pulumi.output_type
class FlowS3OutputFormatConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationConfig":
            suggest = "aggregation_config"
        elif key == "fileType":
            suggest = "file_type"
        elif key == "prefixConfig":
            suggest = "prefix_config"
        elif key == "preserveSourceDataTyping":
            suggest = "preserve_source_data_typing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowS3OutputFormatConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowS3OutputFormatConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowS3OutputFormatConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_config: Optional['outputs.FlowAggregationConfig'] = None,
                 file_type: Optional['FlowFileType'] = None,
                 prefix_config: Optional['outputs.FlowPrefixConfig'] = None,
                 preserve_source_data_typing: Optional[bool] = None):
        """
        :param 'FlowAggregationConfig' aggregation_config: The aggregation settings that you can use to customize the output format of your flow data.
        :param 'FlowFileType' file_type: Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
        :param 'FlowPrefixConfig' prefix_config: Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date.
        :param bool preserve_source_data_typing: If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.
               
               - `true` : Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or `1` in your source data is still an integer in your output.
               - `false` : Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of `1` in your source data becomes the string `"1"` in the output.
        """
        if aggregation_config is not None:
            pulumi.set(__self__, "aggregation_config", aggregation_config)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if prefix_config is not None:
            pulumi.set(__self__, "prefix_config", prefix_config)
        if preserve_source_data_typing is not None:
            pulumi.set(__self__, "preserve_source_data_typing", preserve_source_data_typing)

    @property
    @pulumi.getter(name="aggregationConfig")
    def aggregation_config(self) -> Optional['outputs.FlowAggregationConfig']:
        """
        The aggregation settings that you can use to customize the output format of your flow data.
        """
        return pulumi.get(self, "aggregation_config")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional['FlowFileType']:
        """
        Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter(name="prefixConfig")
    def prefix_config(self) -> Optional['outputs.FlowPrefixConfig']:
        """
        Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date.
        """
        return pulumi.get(self, "prefix_config")

    @property
    @pulumi.getter(name="preserveSourceDataTyping")
    def preserve_source_data_typing(self) -> Optional[bool]:
        """
        If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.

        - `true` : Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or `1` in your source data is still an integer in your output.
        - `false` : Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of `1` in your source data becomes the string `"1"` in the output.
        """
        return pulumi.get(self, "preserve_source_data_typing")


@pulumi.output_type
class FlowS3SourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "s3InputFormatConfig":
            suggest = "s3_input_format_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowS3SourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowS3SourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowS3SourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 bucket_prefix: str,
                 s3_input_format_config: Optional['outputs.FlowS3InputFormatConfig'] = None):
        """
        :param str bucket_name: The Amazon S3 bucket name where the source files are stored.
        :param str bucket_prefix: The object key for the Amazon S3 bucket in which the source files are stored.
        :param 'FlowS3InputFormatConfig' s3_input_format_config: When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if s3_input_format_config is not None:
            pulumi.set(__self__, "s3_input_format_config", s3_input_format_config)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The Amazon S3 bucket name where the source files are stored.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> str:
        """
        The object key for the Amazon S3 bucket in which the source files are stored.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="s3InputFormatConfig")
    def s3_input_format_config(self) -> Optional['outputs.FlowS3InputFormatConfig']:
        """
        When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
        """
        return pulumi.get(self, "s3_input_format_config")


@pulumi.output_type
class FlowSalesforceDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTransferApi":
            suggest = "data_transfer_api"
        elif key == "errorHandlingConfig":
            suggest = "error_handling_config"
        elif key == "idFieldNames":
            suggest = "id_field_names"
        elif key == "writeOperationType":
            suggest = "write_operation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSalesforceDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSalesforceDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSalesforceDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 data_transfer_api: Optional['FlowDataTransferApi'] = None,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None,
                 id_field_names: Optional[Sequence[str]] = None,
                 write_operation_type: Optional['FlowWriteOperationType'] = None):
        """
        :param str object: The object specified in the Salesforce flow destination.
        :param 'FlowDataTransferApi' data_transfer_api: Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
               
               - **AUTOMATIC** - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
               
               Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
               
               By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
               - **BULKV2** - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.
               
               Note that Bulk API 2.0 does not transfer Salesforce compound fields.
               - **REST_SYNC** - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        :param Sequence[str] id_field_names: List of fields used as ID when performing a write operation.
        :param 'FlowWriteOperationType' write_operation_type: This specifies the type of write operation to be performed in Salesforce. When the value is `UPSERT` , then `idFieldNames` is required.
        """
        pulumi.set(__self__, "object", object)
        if data_transfer_api is not None:
            pulumi.set(__self__, "data_transfer_api", data_transfer_api)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)
        if id_field_names is not None:
            pulumi.set(__self__, "id_field_names", id_field_names)
        if write_operation_type is not None:
            pulumi.set(__self__, "write_operation_type", write_operation_type)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Salesforce flow destination.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="dataTransferApi")
    def data_transfer_api(self) -> Optional['FlowDataTransferApi']:
        """
        Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.

        - **AUTOMATIC** - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.

        Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.

        By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
        - **BULKV2** - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.

        Note that Bulk API 2.0 does not transfer Salesforce compound fields.
        - **REST_SYNC** - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.
        """
        return pulumi.get(self, "data_transfer_api")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        return pulumi.get(self, "error_handling_config")

    @property
    @pulumi.getter(name="idFieldNames")
    def id_field_names(self) -> Optional[Sequence[str]]:
        """
        List of fields used as ID when performing a write operation.
        """
        return pulumi.get(self, "id_field_names")

    @property
    @pulumi.getter(name="writeOperationType")
    def write_operation_type(self) -> Optional['FlowWriteOperationType']:
        """
        This specifies the type of write operation to be performed in Salesforce. When the value is `UPSERT` , then `idFieldNames` is required.
        """
        return pulumi.get(self, "write_operation_type")


@pulumi.output_type
class FlowSalesforceSourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTransferApi":
            suggest = "data_transfer_api"
        elif key == "enableDynamicFieldUpdate":
            suggest = "enable_dynamic_field_update"
        elif key == "includeDeletedRecords":
            suggest = "include_deleted_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSalesforceSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSalesforceSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSalesforceSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 data_transfer_api: Optional['FlowDataTransferApi'] = None,
                 enable_dynamic_field_update: Optional[bool] = None,
                 include_deleted_records: Optional[bool] = None):
        """
        :param str object: The object specified in the Salesforce flow source.
        :param 'FlowDataTransferApi' data_transfer_api: Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.
               
               - **AUTOMATIC** - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers from Salesforce. If your flow transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
               
               Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900,000 records, and it might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
               
               By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
               - **BULKV2** - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.
               
               Note that Bulk API 2.0 does not transfer Salesforce compound fields.
               - **REST_SYNC** - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail wituh a timed out error.
        :param bool enable_dynamic_field_update: The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
        :param bool include_deleted_records: Indicates whether Amazon AppFlow includes deleted files in the flow run.
        """
        pulumi.set(__self__, "object", object)
        if data_transfer_api is not None:
            pulumi.set(__self__, "data_transfer_api", data_transfer_api)
        if enable_dynamic_field_update is not None:
            pulumi.set(__self__, "enable_dynamic_field_update", enable_dynamic_field_update)
        if include_deleted_records is not None:
            pulumi.set(__self__, "include_deleted_records", include_deleted_records)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Salesforce flow source.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="dataTransferApi")
    def data_transfer_api(self) -> Optional['FlowDataTransferApi']:
        """
        Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.

        - **AUTOMATIC** - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers from Salesforce. If your flow transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.

        Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900,000 records, and it might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.

        By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
        - **BULKV2** - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.

        Note that Bulk API 2.0 does not transfer Salesforce compound fields.
        - **REST_SYNC** - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail wituh a timed out error.
        """
        return pulumi.get(self, "data_transfer_api")

    @property
    @pulumi.getter(name="enableDynamicFieldUpdate")
    def enable_dynamic_field_update(self) -> Optional[bool]:
        """
        The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
        """
        return pulumi.get(self, "enable_dynamic_field_update")

    @property
    @pulumi.getter(name="includeDeletedRecords")
    def include_deleted_records(self) -> Optional[bool]:
        """
        Indicates whether Amazon AppFlow includes deleted files in the flow run.
        """
        return pulumi.get(self, "include_deleted_records")


@pulumi.output_type
class FlowSapoDataDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectPath":
            suggest = "object_path"
        elif key == "errorHandlingConfig":
            suggest = "error_handling_config"
        elif key == "idFieldNames":
            suggest = "id_field_names"
        elif key == "successResponseHandlingConfig":
            suggest = "success_response_handling_config"
        elif key == "writeOperationType":
            suggest = "write_operation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSapoDataDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSapoDataDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSapoDataDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_path: str,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None,
                 id_field_names: Optional[Sequence[str]] = None,
                 success_response_handling_config: Optional['outputs.FlowSuccessResponseHandlingConfig'] = None,
                 write_operation_type: Optional['FlowWriteOperationType'] = None):
        """
        :param str object_path: The object path specified in the SAPOData flow destination.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        :param Sequence[str] id_field_names: List of fields used as ID when performing a write operation.
        :param 'FlowSuccessResponseHandlingConfig' success_response_handling_config: Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
               
               For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
        :param 'FlowWriteOperationType' write_operation_type: The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
        """
        pulumi.set(__self__, "object_path", object_path)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)
        if id_field_names is not None:
            pulumi.set(__self__, "id_field_names", id_field_names)
        if success_response_handling_config is not None:
            pulumi.set(__self__, "success_response_handling_config", success_response_handling_config)
        if write_operation_type is not None:
            pulumi.set(__self__, "write_operation_type", write_operation_type)

    @property
    @pulumi.getter(name="objectPath")
    def object_path(self) -> str:
        """
        The object path specified in the SAPOData flow destination.
        """
        return pulumi.get(self, "object_path")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        return pulumi.get(self, "error_handling_config")

    @property
    @pulumi.getter(name="idFieldNames")
    def id_field_names(self) -> Optional[Sequence[str]]:
        """
        List of fields used as ID when performing a write operation.
        """
        return pulumi.get(self, "id_field_names")

    @property
    @pulumi.getter(name="successResponseHandlingConfig")
    def success_response_handling_config(self) -> Optional['outputs.FlowSuccessResponseHandlingConfig']:
        """
        Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.

        For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
        """
        return pulumi.get(self, "success_response_handling_config")

    @property
    @pulumi.getter(name="writeOperationType")
    def write_operation_type(self) -> Optional['FlowWriteOperationType']:
        """
        The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
        """
        return pulumi.get(self, "write_operation_type")


@pulumi.output_type
class FlowSapoDataPaginationConfig(dict):
    """
    SAP Source connector page size
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPageSize":
            suggest = "max_page_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSapoDataPaginationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSapoDataPaginationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSapoDataPaginationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_page_size: int):
        """
        SAP Source connector page size
        """
        pulumi.set(__self__, "max_page_size", max_page_size)

    @property
    @pulumi.getter(name="maxPageSize")
    def max_page_size(self) -> int:
        return pulumi.get(self, "max_page_size")


@pulumi.output_type
class FlowSapoDataParallelismConfig(dict):
    """
    SAP Source connector parallelism factor
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxParallelism":
            suggest = "max_parallelism"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSapoDataParallelismConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSapoDataParallelismConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSapoDataParallelismConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_parallelism: int):
        """
        SAP Source connector parallelism factor
        """
        pulumi.set(__self__, "max_parallelism", max_parallelism)

    @property
    @pulumi.getter(name="maxParallelism")
    def max_parallelism(self) -> int:
        return pulumi.get(self, "max_parallelism")


@pulumi.output_type
class FlowSapoDataSourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectPath":
            suggest = "object_path"
        elif key == "paginationConfig":
            suggest = "pagination_config"
        elif key == "parallelismConfig":
            suggest = "parallelism_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSapoDataSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSapoDataSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSapoDataSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_path: str,
                 pagination_config: Optional['outputs.FlowSapoDataPaginationConfig'] = None,
                 parallelism_config: Optional['outputs.FlowSapoDataParallelismConfig'] = None):
        """
        :param str object_path: The object path specified in the SAPOData flow source.
        """
        pulumi.set(__self__, "object_path", object_path)
        if pagination_config is not None:
            pulumi.set(__self__, "pagination_config", pagination_config)
        if parallelism_config is not None:
            pulumi.set(__self__, "parallelism_config", parallelism_config)

    @property
    @pulumi.getter(name="objectPath")
    def object_path(self) -> str:
        """
        The object path specified in the SAPOData flow source.
        """
        return pulumi.get(self, "object_path")

    @property
    @pulumi.getter(name="paginationConfig")
    def pagination_config(self) -> Optional['outputs.FlowSapoDataPaginationConfig']:
        return pulumi.get(self, "pagination_config")

    @property
    @pulumi.getter(name="parallelismConfig")
    def parallelism_config(self) -> Optional['outputs.FlowSapoDataParallelismConfig']:
        return pulumi.get(self, "parallelism_config")


@pulumi.output_type
class FlowScheduledTriggerProperties(dict):
    """
    Details required for scheduled trigger type
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"
        elif key == "dataPullMode":
            suggest = "data_pull_mode"
        elif key == "firstExecutionFrom":
            suggest = "first_execution_from"
        elif key == "flowErrorDeactivationThreshold":
            suggest = "flow_error_deactivation_threshold"
        elif key == "scheduleEndTime":
            suggest = "schedule_end_time"
        elif key == "scheduleOffset":
            suggest = "schedule_offset"
        elif key == "scheduleStartTime":
            suggest = "schedule_start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowScheduledTriggerProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowScheduledTriggerProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowScheduledTriggerProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: str,
                 data_pull_mode: Optional['FlowScheduledTriggerPropertiesDataPullMode'] = None,
                 first_execution_from: Optional[float] = None,
                 flow_error_deactivation_threshold: Optional[int] = None,
                 schedule_end_time: Optional[float] = None,
                 schedule_offset: Optional[float] = None,
                 schedule_start_time: Optional[float] = None,
                 time_zone: Optional[str] = None):
        """
        Details required for scheduled trigger type
        :param str schedule_expression: The scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)` .
        :param 'FlowScheduledTriggerPropertiesDataPullMode' data_pull_mode: Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
        :param float first_execution_from: Specifies the date range for the records to import from the connector in the first flow run.
        :param int flow_error_deactivation_threshold: Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
        :param float schedule_end_time: The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-27T13:00:00-07:00` .
        :param float schedule_offset: Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
        :param float schedule_start_time: The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-26T13:00:00-07:00` .
        :param str time_zone: Specifies the time zone used when referring to the dates and times of a scheduled flow, such as `America/New_York` . This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
               
               If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the `America/New_York` timezone are `-04:00` EDT and `-05:00 EST` .
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if data_pull_mode is not None:
            pulumi.set(__self__, "data_pull_mode", data_pull_mode)
        if first_execution_from is not None:
            pulumi.set(__self__, "first_execution_from", first_execution_from)
        if flow_error_deactivation_threshold is not None:
            pulumi.set(__self__, "flow_error_deactivation_threshold", flow_error_deactivation_threshold)
        if schedule_end_time is not None:
            pulumi.set(__self__, "schedule_end_time", schedule_end_time)
        if schedule_offset is not None:
            pulumi.set(__self__, "schedule_offset", schedule_offset)
        if schedule_start_time is not None:
            pulumi.set(__self__, "schedule_start_time", schedule_start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        """
        The scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)` .
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="dataPullMode")
    def data_pull_mode(self) -> Optional['FlowScheduledTriggerPropertiesDataPullMode']:
        """
        Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
        """
        return pulumi.get(self, "data_pull_mode")

    @property
    @pulumi.getter(name="firstExecutionFrom")
    def first_execution_from(self) -> Optional[float]:
        """
        Specifies the date range for the records to import from the connector in the first flow run.
        """
        return pulumi.get(self, "first_execution_from")

    @property
    @pulumi.getter(name="flowErrorDeactivationThreshold")
    def flow_error_deactivation_threshold(self) -> Optional[int]:
        """
        Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
        """
        return pulumi.get(self, "flow_error_deactivation_threshold")

    @property
    @pulumi.getter(name="scheduleEndTime")
    def schedule_end_time(self) -> Optional[float]:
        """
        The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-27T13:00:00-07:00` .
        """
        return pulumi.get(self, "schedule_end_time")

    @property
    @pulumi.getter(name="scheduleOffset")
    def schedule_offset(self) -> Optional[float]:
        """
        Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
        """
        return pulumi.get(self, "schedule_offset")

    @property
    @pulumi.getter(name="scheduleStartTime")
    def schedule_start_time(self) -> Optional[float]:
        """
        The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-26T13:00:00-07:00` .
        """
        return pulumi.get(self, "schedule_start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies the time zone used when referring to the dates and times of a scheduled flow, such as `America/New_York` . This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.

        If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the `America/New_York` timezone are `-04:00` EDT and `-05:00 EST` .
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class FlowServiceNowSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the ServiceNow flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the ServiceNow flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowSingularSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Singular flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Singular flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowSlackSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Slack flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Slack flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowSnowflakeDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intermediateBucketName":
            suggest = "intermediate_bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "errorHandlingConfig":
            suggest = "error_handling_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSnowflakeDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSnowflakeDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSnowflakeDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intermediate_bucket_name: str,
                 object: str,
                 bucket_prefix: Optional[str] = None,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None):
        """
        :param str intermediate_bucket_name: The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
        :param str object: The object specified in the Snowflake flow destination.
        :param str bucket_prefix: The object key for the destination bucket in which Amazon AppFlow places the files.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        pulumi.set(__self__, "intermediate_bucket_name", intermediate_bucket_name)
        pulumi.set(__self__, "object", object)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)

    @property
    @pulumi.getter(name="intermediateBucketName")
    def intermediate_bucket_name(self) -> str:
        """
        The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
        """
        return pulumi.get(self, "intermediate_bucket_name")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Snowflake flow destination.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The object key for the destination bucket in which Amazon AppFlow places the files.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        return pulumi.get(self, "error_handling_config")


@pulumi.output_type
class FlowSourceConnectorProperties(dict):
    """
    Source connector details required to query a connector
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConnector":
            suggest = "custom_connector"
        elif key == "googleAnalytics":
            suggest = "google_analytics"
        elif key == "inforNexus":
            suggest = "infor_nexus"
        elif key == "sapoData":
            suggest = "sapo_data"
        elif key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceConnectorProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceConnectorProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceConnectorProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amplitude: Optional['outputs.FlowAmplitudeSourceProperties'] = None,
                 custom_connector: Optional['outputs.FlowCustomConnectorSourceProperties'] = None,
                 datadog: Optional['outputs.FlowDatadogSourceProperties'] = None,
                 dynatrace: Optional['outputs.FlowDynatraceSourceProperties'] = None,
                 google_analytics: Optional['outputs.FlowGoogleAnalyticsSourceProperties'] = None,
                 infor_nexus: Optional['outputs.FlowInforNexusSourceProperties'] = None,
                 marketo: Optional['outputs.FlowMarketoSourceProperties'] = None,
                 pardot: Optional['outputs.FlowPardotSourceProperties'] = None,
                 s3: Optional['outputs.FlowS3SourceProperties'] = None,
                 salesforce: Optional['outputs.FlowSalesforceSourceProperties'] = None,
                 sapo_data: Optional['outputs.FlowSapoDataSourceProperties'] = None,
                 service_now: Optional['outputs.FlowServiceNowSourceProperties'] = None,
                 singular: Optional['outputs.FlowSingularSourceProperties'] = None,
                 slack: Optional['outputs.FlowSlackSourceProperties'] = None,
                 trendmicro: Optional['outputs.FlowTrendmicroSourceProperties'] = None,
                 veeva: Optional['outputs.FlowVeevaSourceProperties'] = None,
                 zendesk: Optional['outputs.FlowZendeskSourceProperties'] = None):
        """
        Source connector details required to query a connector
        :param 'FlowAmplitudeSourceProperties' amplitude: Specifies the information that is required for querying Amplitude.
        :param 'FlowCustomConnectorSourceProperties' custom_connector: The properties that are applied when the custom connector is being used as a source.
        :param 'FlowDatadogSourceProperties' datadog: Specifies the information that is required for querying Datadog.
        :param 'FlowDynatraceSourceProperties' dynatrace: Specifies the information that is required for querying Dynatrace.
        :param 'FlowGoogleAnalyticsSourceProperties' google_analytics: Specifies the information that is required for querying Google Analytics.
        :param 'FlowInforNexusSourceProperties' infor_nexus: Specifies the information that is required for querying Infor Nexus.
        :param 'FlowMarketoSourceProperties' marketo: Specifies the information that is required for querying Marketo.
        :param 'FlowPardotSourceProperties' pardot: Specifies the information that is required for querying Salesforce Pardot.
        :param 'FlowS3SourceProperties' s3: Specifies the information that is required for querying Amazon S3.
        :param 'FlowSalesforceSourceProperties' salesforce: Specifies the information that is required for querying Salesforce.
        :param 'FlowSapoDataSourceProperties' sapo_data: The properties that are applied when using SAPOData as a flow source.
        :param 'FlowServiceNowSourceProperties' service_now: Specifies the information that is required for querying ServiceNow.
        :param 'FlowSingularSourceProperties' singular: Specifies the information that is required for querying Singular.
        :param 'FlowSlackSourceProperties' slack: Specifies the information that is required for querying Slack.
        :param 'FlowTrendmicroSourceProperties' trendmicro: Specifies the information that is required for querying Trend Micro.
        :param 'FlowVeevaSourceProperties' veeva: Specifies the information that is required for querying Veeva.
        :param 'FlowZendeskSourceProperties' zendesk: Specifies the information that is required for querying Zendesk.
        """
        if amplitude is not None:
            pulumi.set(__self__, "amplitude", amplitude)
        if custom_connector is not None:
            pulumi.set(__self__, "custom_connector", custom_connector)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if dynatrace is not None:
            pulumi.set(__self__, "dynatrace", dynatrace)
        if google_analytics is not None:
            pulumi.set(__self__, "google_analytics", google_analytics)
        if infor_nexus is not None:
            pulumi.set(__self__, "infor_nexus", infor_nexus)
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if pardot is not None:
            pulumi.set(__self__, "pardot", pardot)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if sapo_data is not None:
            pulumi.set(__self__, "sapo_data", sapo_data)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if trendmicro is not None:
            pulumi.set(__self__, "trendmicro", trendmicro)
        if veeva is not None:
            pulumi.set(__self__, "veeva", veeva)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def amplitude(self) -> Optional['outputs.FlowAmplitudeSourceProperties']:
        """
        Specifies the information that is required for querying Amplitude.
        """
        return pulumi.get(self, "amplitude")

    @property
    @pulumi.getter(name="customConnector")
    def custom_connector(self) -> Optional['outputs.FlowCustomConnectorSourceProperties']:
        """
        The properties that are applied when the custom connector is being used as a source.
        """
        return pulumi.get(self, "custom_connector")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.FlowDatadogSourceProperties']:
        """
        Specifies the information that is required for querying Datadog.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def dynatrace(self) -> Optional['outputs.FlowDynatraceSourceProperties']:
        """
        Specifies the information that is required for querying Dynatrace.
        """
        return pulumi.get(self, "dynatrace")

    @property
    @pulumi.getter(name="googleAnalytics")
    def google_analytics(self) -> Optional['outputs.FlowGoogleAnalyticsSourceProperties']:
        """
        Specifies the information that is required for querying Google Analytics.
        """
        return pulumi.get(self, "google_analytics")

    @property
    @pulumi.getter(name="inforNexus")
    def infor_nexus(self) -> Optional['outputs.FlowInforNexusSourceProperties']:
        """
        Specifies the information that is required for querying Infor Nexus.
        """
        return pulumi.get(self, "infor_nexus")

    @property
    @pulumi.getter
    def marketo(self) -> Optional['outputs.FlowMarketoSourceProperties']:
        """
        Specifies the information that is required for querying Marketo.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def pardot(self) -> Optional['outputs.FlowPardotSourceProperties']:
        """
        Specifies the information that is required for querying Salesforce Pardot.
        """
        return pulumi.get(self, "pardot")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.FlowS3SourceProperties']:
        """
        Specifies the information that is required for querying Amazon S3.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['outputs.FlowSalesforceSourceProperties']:
        """
        Specifies the information that is required for querying Salesforce.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="sapoData")
    def sapo_data(self) -> Optional['outputs.FlowSapoDataSourceProperties']:
        """
        The properties that are applied when using SAPOData as a flow source.
        """
        return pulumi.get(self, "sapo_data")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['outputs.FlowServiceNowSourceProperties']:
        """
        Specifies the information that is required for querying ServiceNow.
        """
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def singular(self) -> Optional['outputs.FlowSingularSourceProperties']:
        """
        Specifies the information that is required for querying Singular.
        """
        return pulumi.get(self, "singular")

    @property
    @pulumi.getter
    def slack(self) -> Optional['outputs.FlowSlackSourceProperties']:
        """
        Specifies the information that is required for querying Slack.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def trendmicro(self) -> Optional['outputs.FlowTrendmicroSourceProperties']:
        """
        Specifies the information that is required for querying Trend Micro.
        """
        return pulumi.get(self, "trendmicro")

    @property
    @pulumi.getter
    def veeva(self) -> Optional['outputs.FlowVeevaSourceProperties']:
        """
        Specifies the information that is required for querying Veeva.
        """
        return pulumi.get(self, "veeva")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['outputs.FlowZendeskSourceProperties']:
        """
        Specifies the information that is required for querying Zendesk.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class FlowSourceFlowConfig(dict):
    """
    Configurations of Source connector of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "sourceConnectorProperties":
            suggest = "source_connector_properties"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "connectorProfileName":
            suggest = "connector_profile_name"
        elif key == "incrementalPullConfig":
            suggest = "incremental_pull_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSourceFlowConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSourceFlowConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSourceFlowConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: 'FlowConnectorType',
                 source_connector_properties: 'outputs.FlowSourceConnectorProperties',
                 api_version: Optional[str] = None,
                 connector_profile_name: Optional[str] = None,
                 incremental_pull_config: Optional['outputs.FlowIncrementalPullConfig'] = None):
        """
        Configurations of Source connector of the flow.
        :param 'FlowConnectorType' connector_type: Type of source connector
        :param 'FlowSourceConnectorProperties' source_connector_properties: Source connector details required to query a connector
        :param str api_version: The API version that the destination connector uses.
        :param str connector_profile_name: Name of source connector profile
        :param 'FlowIncrementalPullConfig' incremental_pull_config: Configuration for scheduled incremental data pull
        """
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "source_connector_properties", source_connector_properties)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if connector_profile_name is not None:
            pulumi.set(__self__, "connector_profile_name", connector_profile_name)
        if incremental_pull_config is not None:
            pulumi.set(__self__, "incremental_pull_config", incremental_pull_config)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> 'FlowConnectorType':
        """
        Type of source connector
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="sourceConnectorProperties")
    def source_connector_properties(self) -> 'outputs.FlowSourceConnectorProperties':
        """
        Source connector details required to query a connector
        """
        return pulumi.get(self, "source_connector_properties")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        The API version that the destination connector uses.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="connectorProfileName")
    def connector_profile_name(self) -> Optional[str]:
        """
        Name of source connector profile
        """
        return pulumi.get(self, "connector_profile_name")

    @property
    @pulumi.getter(name="incrementalPullConfig")
    def incremental_pull_config(self) -> Optional['outputs.FlowIncrementalPullConfig']:
        """
        Configuration for scheduled incremental data pull
        """
        return pulumi.get(self, "incremental_pull_config")


@pulumi.output_type
class FlowSuccessResponseHandlingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowSuccessResponseHandlingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowSuccessResponseHandlingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowSuccessResponseHandlingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[str] = None,
                 bucket_prefix: Optional[str] = None):
        """
        :param str bucket_name: The name of the Amazon S3 bucket.
        :param str bucket_prefix: The Amazon S3 bucket prefix.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        The name of the Amazon S3 bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The Amazon S3 bucket prefix.
        """
        return pulumi.get(self, "bucket_prefix")


@pulumi.output_type
class FlowTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFields":
            suggest = "source_fields"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "connectorOperator":
            suggest = "connector_operator"
        elif key == "destinationField":
            suggest = "destination_field"
        elif key == "taskProperties":
            suggest = "task_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_fields: Sequence[str],
                 task_type: 'FlowTaskType',
                 connector_operator: Optional['outputs.FlowConnectorOperator'] = None,
                 destination_field: Optional[str] = None,
                 task_properties: Optional[Sequence['outputs.FlowTaskPropertiesObject']] = None):
        """
        :param Sequence[str] source_fields: Source fields on which particular task will be applied
        :param 'FlowTaskType' task_type: Type of task
        :param 'FlowConnectorOperator' connector_operator: Operation to be performed on provided source fields
        :param str destination_field: A field value on which source field should be validated
        :param Sequence['FlowTaskPropertiesObject'] task_properties: A Map used to store task related info
        """
        pulumi.set(__self__, "source_fields", source_fields)
        pulumi.set(__self__, "task_type", task_type)
        if connector_operator is not None:
            pulumi.set(__self__, "connector_operator", connector_operator)
        if destination_field is not None:
            pulumi.set(__self__, "destination_field", destination_field)
        if task_properties is not None:
            pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="sourceFields")
    def source_fields(self) -> Sequence[str]:
        """
        Source fields on which particular task will be applied
        """
        return pulumi.get(self, "source_fields")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> 'FlowTaskType':
        """
        Type of task
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="connectorOperator")
    def connector_operator(self) -> Optional['outputs.FlowConnectorOperator']:
        """
        Operation to be performed on provided source fields
        """
        return pulumi.get(self, "connector_operator")

    @property
    @pulumi.getter(name="destinationField")
    def destination_field(self) -> Optional[str]:
        """
        A field value on which source field should be validated
        """
        return pulumi.get(self, "destination_field")

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> Optional[Sequence['outputs.FlowTaskPropertiesObject']]:
        """
        A Map used to store task related info
        """
        return pulumi.get(self, "task_properties")


@pulumi.output_type
class FlowTaskPropertiesObject(dict):
    """
    An object used to store task related info
    """
    def __init__(__self__, *,
                 key: 'FlowOperatorPropertiesKeys',
                 value: str):
        """
        An object used to store task related info
        :param 'FlowOperatorPropertiesKeys' key: The task property key.
        :param str value: The task property value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> 'FlowOperatorPropertiesKeys':
        """
        The task property key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The task property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class FlowTrendmicroSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Trend Micro flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Trend Micro flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FlowTriggerConfig(dict):
    """
    Trigger settings of the flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerType":
            suggest = "trigger_type"
        elif key == "triggerProperties":
            suggest = "trigger_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trigger_type: 'FlowTriggerType',
                 trigger_properties: Optional['outputs.FlowScheduledTriggerProperties'] = None):
        """
        Trigger settings of the flow.
        :param 'FlowTriggerType' trigger_type: Trigger type of the flow
        :param 'FlowScheduledTriggerProperties' trigger_properties: Details required based on the type of trigger
        """
        pulumi.set(__self__, "trigger_type", trigger_type)
        if trigger_properties is not None:
            pulumi.set(__self__, "trigger_properties", trigger_properties)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> 'FlowTriggerType':
        """
        Trigger type of the flow
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="triggerProperties")
    def trigger_properties(self) -> Optional['outputs.FlowScheduledTriggerProperties']:
        """
        Details required based on the type of trigger
        """
        return pulumi.get(self, "trigger_properties")


@pulumi.output_type
class FlowUpsolverDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "s3OutputFormatConfig":
            suggest = "s3_output_format_config"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowUpsolverDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowUpsolverDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowUpsolverDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 s3_output_format_config: 'outputs.FlowUpsolverS3OutputFormatConfig',
                 bucket_prefix: Optional[str] = None):
        """
        :param str bucket_name: The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
        :param 'FlowUpsolverS3OutputFormatConfig' s3_output_format_config: The configuration that determines how data is formatted when Upsolver is used as the flow destination.
        :param str bucket_prefix: The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "s3_output_format_config", s3_output_format_config)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="s3OutputFormatConfig")
    def s3_output_format_config(self) -> 'outputs.FlowUpsolverS3OutputFormatConfig':
        """
        The configuration that determines how data is formatted when Upsolver is used as the flow destination.
        """
        return pulumi.get(self, "s3_output_format_config")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        """
        The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
        """
        return pulumi.get(self, "bucket_prefix")


@pulumi.output_type
class FlowUpsolverS3OutputFormatConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixConfig":
            suggest = "prefix_config"
        elif key == "aggregationConfig":
            suggest = "aggregation_config"
        elif key == "fileType":
            suggest = "file_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowUpsolverS3OutputFormatConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowUpsolverS3OutputFormatConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowUpsolverS3OutputFormatConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix_config: 'outputs.FlowPrefixConfig',
                 aggregation_config: Optional['outputs.FlowAggregationConfig'] = None,
                 file_type: Optional['FlowFileType'] = None):
        """
        :param 'FlowPrefixConfig' prefix_config: Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination.
        :param 'FlowAggregationConfig' aggregation_config: The aggregation settings that you can use to customize the output format of your flow data.
        :param 'FlowFileType' file_type: Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
        """
        pulumi.set(__self__, "prefix_config", prefix_config)
        if aggregation_config is not None:
            pulumi.set(__self__, "aggregation_config", aggregation_config)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)

    @property
    @pulumi.getter(name="prefixConfig")
    def prefix_config(self) -> 'outputs.FlowPrefixConfig':
        """
        Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination.
        """
        return pulumi.get(self, "prefix_config")

    @property
    @pulumi.getter(name="aggregationConfig")
    def aggregation_config(self) -> Optional['outputs.FlowAggregationConfig']:
        """
        The aggregation settings that you can use to customize the output format of your flow data.
        """
        return pulumi.get(self, "aggregation_config")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional['FlowFileType']:
        """
        Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
        """
        return pulumi.get(self, "file_type")


@pulumi.output_type
class FlowVeevaSourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentType":
            suggest = "document_type"
        elif key == "includeAllVersions":
            suggest = "include_all_versions"
        elif key == "includeRenditions":
            suggest = "include_renditions"
        elif key == "includeSourceFiles":
            suggest = "include_source_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowVeevaSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowVeevaSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowVeevaSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 document_type: Optional[str] = None,
                 include_all_versions: Optional[bool] = None,
                 include_renditions: Optional[bool] = None,
                 include_source_files: Optional[bool] = None):
        """
        :param str object: The object specified in the Veeva flow source.
        :param str document_type: The document type specified in the Veeva document extract flow.
        :param bool include_all_versions: Boolean value to include All Versions of files in Veeva document extract flow.
        :param bool include_renditions: Boolean value to include file renditions in Veeva document extract flow.
        :param bool include_source_files: Boolean value to include source files in Veeva document extract flow.
        """
        pulumi.set(__self__, "object", object)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if include_all_versions is not None:
            pulumi.set(__self__, "include_all_versions", include_all_versions)
        if include_renditions is not None:
            pulumi.set(__self__, "include_renditions", include_renditions)
        if include_source_files is not None:
            pulumi.set(__self__, "include_source_files", include_source_files)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Veeva flow source.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[str]:
        """
        The document type specified in the Veeva document extract flow.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter(name="includeAllVersions")
    def include_all_versions(self) -> Optional[bool]:
        """
        Boolean value to include All Versions of files in Veeva document extract flow.
        """
        return pulumi.get(self, "include_all_versions")

    @property
    @pulumi.getter(name="includeRenditions")
    def include_renditions(self) -> Optional[bool]:
        """
        Boolean value to include file renditions in Veeva document extract flow.
        """
        return pulumi.get(self, "include_renditions")

    @property
    @pulumi.getter(name="includeSourceFiles")
    def include_source_files(self) -> Optional[bool]:
        """
        Boolean value to include source files in Veeva document extract flow.
        """
        return pulumi.get(self, "include_source_files")


@pulumi.output_type
class FlowZendeskDestinationProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorHandlingConfig":
            suggest = "error_handling_config"
        elif key == "idFieldNames":
            suggest = "id_field_names"
        elif key == "writeOperationType":
            suggest = "write_operation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowZendeskDestinationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowZendeskDestinationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowZendeskDestinationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 error_handling_config: Optional['outputs.FlowErrorHandlingConfig'] = None,
                 id_field_names: Optional[Sequence[str]] = None,
                 write_operation_type: Optional['FlowWriteOperationType'] = None):
        """
        :param str object: The object specified in the Zendesk flow destination.
        :param 'FlowErrorHandlingConfig' error_handling_config: The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        :param Sequence[str] id_field_names: List of fields used as ID when performing a write operation.
        :param 'FlowWriteOperationType' write_operation_type: The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
        """
        pulumi.set(__self__, "object", object)
        if error_handling_config is not None:
            pulumi.set(__self__, "error_handling_config", error_handling_config)
        if id_field_names is not None:
            pulumi.set(__self__, "id_field_names", id_field_names)
        if write_operation_type is not None:
            pulumi.set(__self__, "write_operation_type", write_operation_type)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Zendesk flow destination.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="errorHandlingConfig")
    def error_handling_config(self) -> Optional['outputs.FlowErrorHandlingConfig']:
        """
        The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
        """
        return pulumi.get(self, "error_handling_config")

    @property
    @pulumi.getter(name="idFieldNames")
    def id_field_names(self) -> Optional[Sequence[str]]:
        """
        List of fields used as ID when performing a write operation.
        """
        return pulumi.get(self, "id_field_names")

    @property
    @pulumi.getter(name="writeOperationType")
    def write_operation_type(self) -> Optional['FlowWriteOperationType']:
        """
        The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
        """
        return pulumi.get(self, "write_operation_type")


@pulumi.output_type
class FlowZendeskSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        """
        :param str object: The object specified in the Zendesk flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object specified in the Zendesk flow source.
        """
        return pulumi.get(self, "object")


