# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIntegrationResult',
    'AwaitableGetIntegrationResult',
    'get_integration',
    'get_integration_output',
]

@pulumi.output_type
class GetIntegrationResult:
    def __init__(__self__, connection_id=None, connection_type=None, content_handling_strategy=None, credentials_arn=None, description=None, integration_id=None, integration_method=None, integration_subtype=None, integration_type=None, integration_uri=None, passthrough_behavior=None, payload_format_version=None, request_parameters=None, request_templates=None, response_parameters=None, template_selection_expression=None, timeout_in_millis=None, tls_config=None):
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if connection_type and not isinstance(connection_type, str):
            raise TypeError("Expected argument 'connection_type' to be a str")
        pulumi.set(__self__, "connection_type", connection_type)
        if content_handling_strategy and not isinstance(content_handling_strategy, str):
            raise TypeError("Expected argument 'content_handling_strategy' to be a str")
        pulumi.set(__self__, "content_handling_strategy", content_handling_strategy)
        if credentials_arn and not isinstance(credentials_arn, str):
            raise TypeError("Expected argument 'credentials_arn' to be a str")
        pulumi.set(__self__, "credentials_arn", credentials_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if integration_id and not isinstance(integration_id, str):
            raise TypeError("Expected argument 'integration_id' to be a str")
        pulumi.set(__self__, "integration_id", integration_id)
        if integration_method and not isinstance(integration_method, str):
            raise TypeError("Expected argument 'integration_method' to be a str")
        pulumi.set(__self__, "integration_method", integration_method)
        if integration_subtype and not isinstance(integration_subtype, str):
            raise TypeError("Expected argument 'integration_subtype' to be a str")
        pulumi.set(__self__, "integration_subtype", integration_subtype)
        if integration_type and not isinstance(integration_type, str):
            raise TypeError("Expected argument 'integration_type' to be a str")
        pulumi.set(__self__, "integration_type", integration_type)
        if integration_uri and not isinstance(integration_uri, str):
            raise TypeError("Expected argument 'integration_uri' to be a str")
        pulumi.set(__self__, "integration_uri", integration_uri)
        if passthrough_behavior and not isinstance(passthrough_behavior, str):
            raise TypeError("Expected argument 'passthrough_behavior' to be a str")
        pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if payload_format_version and not isinstance(payload_format_version, str):
            raise TypeError("Expected argument 'payload_format_version' to be a str")
        pulumi.set(__self__, "payload_format_version", payload_format_version)
        if request_parameters and not isinstance(request_parameters, dict):
            raise TypeError("Expected argument 'request_parameters' to be a dict")
        pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates and not isinstance(request_templates, dict):
            raise TypeError("Expected argument 'request_templates' to be a dict")
        pulumi.set(__self__, "request_templates", request_templates)
        if response_parameters and not isinstance(response_parameters, dict):
            raise TypeError("Expected argument 'response_parameters' to be a dict")
        pulumi.set(__self__, "response_parameters", response_parameters)
        if template_selection_expression and not isinstance(template_selection_expression, str):
            raise TypeError("Expected argument 'template_selection_expression' to be a str")
        pulumi.set(__self__, "template_selection_expression", template_selection_expression)
        if timeout_in_millis and not isinstance(timeout_in_millis, int):
            raise TypeError("Expected argument 'timeout_in_millis' to be a int")
        pulumi.set(__self__, "timeout_in_millis", timeout_in_millis)
        if tls_config and not isinstance(tls_config, dict):
            raise TypeError("Expected argument 'tls_config' to be a dict")
        pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[str]:
        """
        The ID of the VPC link for a private integration. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[str]:
        """
        The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="contentHandlingStrategy")
    def content_handling_strategy(self) -> Optional[str]:
        """
        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT.
        """
        return pulumi.get(self, "content_handling_strategy")

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> Optional[str]:
        """
        Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter.
        """
        return pulumi.get(self, "credentials_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the integration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[str]:
        """
        The integration ID.
        """
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter(name="integrationMethod")
    def integration_method(self) -> Optional[str]:
        """
        Specifies the integration's HTTP method type.
        """
        return pulumi.get(self, "integration_method")

    @property
    @pulumi.getter(name="integrationSubtype")
    def integration_subtype(self) -> Optional[str]:
        """
        Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke.
        """
        return pulumi.get(self, "integration_subtype")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> Optional[str]:
        """
        The integration type of an integration.
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="integrationUri")
    def integration_uri(self) -> Optional[str]:
        """
        For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        """
        return pulumi.get(self, "integration_uri")

    @property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional[str]:
        """
        Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "passthrough_behavior")

    @property
    @pulumi.getter(name="payloadFormatVersion")
    def payload_format_version(self) -> Optional[str]:
        """
        Specifies the format of the payload sent to an integration. Required for HTTP APIs. For HTTP APIs, supported values for Lambda proxy integrations are 1.0 and 2.0 For all other integrations, 1.0 is the only supported value.
        """
        return pulumi.get(self, "payload_format_version")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[Mapping[str, str]]:
        """
        A key-value map specifying parameters.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[Mapping[str, str]]:
        """
        A map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
        """
        return pulumi.get(self, "request_templates")

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[Mapping[str, 'outputs.IntegrationResponseParameterMap']]:
        """
        Parameters that transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "response_parameters")

    @property
    @pulumi.getter(name="templateSelectionExpression")
    def template_selection_expression(self) -> Optional[str]:
        """
        The template selection expression for the integration. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "template_selection_expression")

    @property
    @pulumi.getter(name="timeoutInMillis")
    def timeout_in_millis(self) -> Optional[int]:
        """
        Custom timeout between 50 and 29000 milliseconds for WebSocket APIs and between 50 and 30000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
        """
        return pulumi.get(self, "timeout_in_millis")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional['outputs.IntegrationTlsConfig']:
        """
        The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "tls_config")


class AwaitableGetIntegrationResult(GetIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIntegrationResult(
            connection_id=self.connection_id,
            connection_type=self.connection_type,
            content_handling_strategy=self.content_handling_strategy,
            credentials_arn=self.credentials_arn,
            description=self.description,
            integration_id=self.integration_id,
            integration_method=self.integration_method,
            integration_subtype=self.integration_subtype,
            integration_type=self.integration_type,
            integration_uri=self.integration_uri,
            passthrough_behavior=self.passthrough_behavior,
            payload_format_version=self.payload_format_version,
            request_parameters=self.request_parameters,
            request_templates=self.request_templates,
            response_parameters=self.response_parameters,
            template_selection_expression=self.template_selection_expression,
            timeout_in_millis=self.timeout_in_millis,
            tls_config=self.tls_config)


def get_integration(api_id: Optional[str] = None,
                    integration_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIntegrationResult:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param str api_id: The API identifier.
    :param str integration_id: The integration ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['integrationId'] = integration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getIntegration', __args__, opts=opts, typ=GetIntegrationResult).value

    return AwaitableGetIntegrationResult(
        connection_id=pulumi.get(__ret__, 'connection_id'),
        connection_type=pulumi.get(__ret__, 'connection_type'),
        content_handling_strategy=pulumi.get(__ret__, 'content_handling_strategy'),
        credentials_arn=pulumi.get(__ret__, 'credentials_arn'),
        description=pulumi.get(__ret__, 'description'),
        integration_id=pulumi.get(__ret__, 'integration_id'),
        integration_method=pulumi.get(__ret__, 'integration_method'),
        integration_subtype=pulumi.get(__ret__, 'integration_subtype'),
        integration_type=pulumi.get(__ret__, 'integration_type'),
        integration_uri=pulumi.get(__ret__, 'integration_uri'),
        passthrough_behavior=pulumi.get(__ret__, 'passthrough_behavior'),
        payload_format_version=pulumi.get(__ret__, 'payload_format_version'),
        request_parameters=pulumi.get(__ret__, 'request_parameters'),
        request_templates=pulumi.get(__ret__, 'request_templates'),
        response_parameters=pulumi.get(__ret__, 'response_parameters'),
        template_selection_expression=pulumi.get(__ret__, 'template_selection_expression'),
        timeout_in_millis=pulumi.get(__ret__, 'timeout_in_millis'),
        tls_config=pulumi.get(__ret__, 'tls_config'))
def get_integration_output(api_id: Optional[pulumi.Input[str]] = None,
                           integration_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIntegrationResult]:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param str api_id: The API identifier.
    :param str integration_id: The integration ID.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    __args__['integrationId'] = integration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigatewayv2:getIntegration', __args__, opts=opts, typ=GetIntegrationResult)
    return __ret__.apply(lambda __response__: GetIntegrationResult(
        connection_id=pulumi.get(__response__, 'connection_id'),
        connection_type=pulumi.get(__response__, 'connection_type'),
        content_handling_strategy=pulumi.get(__response__, 'content_handling_strategy'),
        credentials_arn=pulumi.get(__response__, 'credentials_arn'),
        description=pulumi.get(__response__, 'description'),
        integration_id=pulumi.get(__response__, 'integration_id'),
        integration_method=pulumi.get(__response__, 'integration_method'),
        integration_subtype=pulumi.get(__response__, 'integration_subtype'),
        integration_type=pulumi.get(__response__, 'integration_type'),
        integration_uri=pulumi.get(__response__, 'integration_uri'),
        passthrough_behavior=pulumi.get(__response__, 'passthrough_behavior'),
        payload_format_version=pulumi.get(__response__, 'payload_format_version'),
        request_parameters=pulumi.get(__response__, 'request_parameters'),
        request_templates=pulumi.get(__response__, 'request_templates'),
        response_parameters=pulumi.get(__response__, 'response_parameters'),
        template_selection_expression=pulumi.get(__response__, 'template_selection_expression'),
        timeout_in_millis=pulumi.get(__response__, 'timeout_in_millis'),
        tls_config=pulumi.get(__response__, 'tls_config')))
