# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetUsagePlanResult',
    'AwaitableGetUsagePlanResult',
    'get_usage_plan',
    'get_usage_plan_output',
]

@pulumi.output_type
class GetUsagePlanResult:
    def __init__(__self__, api_stages=None, description=None, id=None, quota=None, tags=None, throttle=None, usage_plan_name=None):
        if api_stages and not isinstance(api_stages, list):
            raise TypeError("Expected argument 'api_stages' to be a list")
        pulumi.set(__self__, "api_stages", api_stages)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if quota and not isinstance(quota, dict):
            raise TypeError("Expected argument 'quota' to be a dict")
        pulumi.set(__self__, "quota", quota)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if throttle and not isinstance(throttle, dict):
            raise TypeError("Expected argument 'throttle' to be a dict")
        pulumi.set(__self__, "throttle", throttle)
        if usage_plan_name and not isinstance(usage_plan_name, str):
            raise TypeError("Expected argument 'usage_plan_name' to be a str")
        pulumi.set(__self__, "usage_plan_name", usage_plan_name)

    @property
    @pulumi.getter(name="apiStages")
    def api_stages(self) -> Optional[Sequence['outputs.UsagePlanApiStage']]:
        """
        The associated API stages of a usage plan.
        """
        return pulumi.get(self, "api_stages")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of a usage plan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID for the usage plan. For example: `abc123` .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def quota(self) -> Optional['outputs.UsagePlanQuotaSettings']:
        """
        The target maximum number of permitted requests per a given unit time interval.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The collection of tags. Each tag element is associated with a given resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def throttle(self) -> Optional['outputs.UsagePlanThrottleSettings']:
        """
        A map containing method level throttling information for API stage in a usage plan.
        """
        return pulumi.get(self, "throttle")

    @property
    @pulumi.getter(name="usagePlanName")
    def usage_plan_name(self) -> Optional[str]:
        """
        The name of a usage plan.
        """
        return pulumi.get(self, "usage_plan_name")


class AwaitableGetUsagePlanResult(GetUsagePlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsagePlanResult(
            api_stages=self.api_stages,
            description=self.description,
            id=self.id,
            quota=self.quota,
            tags=self.tags,
            throttle=self.throttle,
            usage_plan_name=self.usage_plan_name)


def get_usage_plan(id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsagePlanResult:
    """
    The ``AWS::ApiGateway::UsagePlan`` resource creates a usage plan for deployed APIs. A usage plan sets a target for the throttling and quota limits on individual client API keys. For more information, see [Creating and Using API Usage Plans in Amazon API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html) in the *API Gateway Developer Guide*.
     In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using [](https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html) to monitor costs and [](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) to manage API requests.


    :param str id: The ID for the usage plan. For example: `abc123` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getUsagePlan', __args__, opts=opts, typ=GetUsagePlanResult).value

    return AwaitableGetUsagePlanResult(
        api_stages=pulumi.get(__ret__, 'api_stages'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        quota=pulumi.get(__ret__, 'quota'),
        tags=pulumi.get(__ret__, 'tags'),
        throttle=pulumi.get(__ret__, 'throttle'),
        usage_plan_name=pulumi.get(__ret__, 'usage_plan_name'))
def get_usage_plan_output(id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsagePlanResult]:
    """
    The ``AWS::ApiGateway::UsagePlan`` resource creates a usage plan for deployed APIs. A usage plan sets a target for the throttling and quota limits on individual client API keys. For more information, see [Creating and Using API Usage Plans in Amazon API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html) in the *API Gateway Developer Guide*.
     In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using [](https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html) to monitor costs and [](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) to manage API requests.


    :param str id: The ID for the usage plan. For example: `abc123` .
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:apigateway:getUsagePlan', __args__, opts=opts, typ=GetUsagePlanResult)
    return __ret__.apply(lambda __response__: GetUsagePlanResult(
        api_stages=pulumi.get(__response__, 'api_stages'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        quota=pulumi.get(__response__, 'quota'),
        tags=pulumi.get(__response__, 'tags'),
        throttle=pulumi.get(__response__, 'throttle'),
        usage_plan_name=pulumi.get(__response__, 'usage_plan_name')))
