# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetThemeResult',
    'AwaitableGetThemeResult',
    'get_theme',
    'get_theme_output',
]

@pulumi.output_type
class GetThemeResult:
    def __init__(__self__, created_at=None, id=None, modified_at=None, name=None, overrides=None, tags=None, values=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if overrides and not isinstance(overrides, list):
            raise TypeError("Expected argument 'overrides' to be a list")
        pulumi.set(__self__, "overrides", overrides)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The time that the theme was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID for the theme.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[str]:
        """
        The time that the theme was modified.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the theme.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def overrides(self) -> Optional[Sequence['outputs.ThemeValues']]:
        """
        Describes the properties that can be overriden to customize a theme.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        One or more key-value pairs to use when tagging the theme.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.ThemeValues']]:
        """
        A list of key-value pairs that defines the properties of the theme.
        """
        return pulumi.get(self, "values")


class AwaitableGetThemeResult(GetThemeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThemeResult(
            created_at=self.created_at,
            id=self.id,
            modified_at=self.modified_at,
            name=self.name,
            overrides=self.overrides,
            tags=self.tags,
            values=self.values)


def get_theme(app_id: Optional[str] = None,
              environment_name: Optional[str] = None,
              id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThemeResult:
    """
    Definition of AWS::AmplifyUIBuilder::Theme Resource Type


    :param str app_id: The unique ID for the Amplify app associated with the theme.
    :param str environment_name: The name of the backend environment that is a part of the Amplify app.
    :param str id: The ID for the theme.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['environmentName'] = environment_name
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:amplifyuibuilder:getTheme', __args__, opts=opts, typ=GetThemeResult).value

    return AwaitableGetThemeResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        name=pulumi.get(__ret__, 'name'),
        overrides=pulumi.get(__ret__, 'overrides'),
        tags=pulumi.get(__ret__, 'tags'),
        values=pulumi.get(__ret__, 'values'))
def get_theme_output(app_id: Optional[pulumi.Input[str]] = None,
                     environment_name: Optional[pulumi.Input[str]] = None,
                     id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetThemeResult]:
    """
    Definition of AWS::AmplifyUIBuilder::Theme Resource Type


    :param str app_id: The unique ID for the Amplify app associated with the theme.
    :param str environment_name: The name of the backend environment that is a part of the Amplify app.
    :param str id: The ID for the theme.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['environmentName'] = environment_name
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:amplifyuibuilder:getTheme', __args__, opts=opts, typ=GetThemeResult)
    return __ret__.apply(lambda __response__: GetThemeResult(
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        name=pulumi.get(__response__, 'name'),
        overrides=pulumi.get(__response__, 'overrides'),
        tags=pulumi.get(__response__, 'tags'),
        values=pulumi.get(__response__, 'values')))
